/* utils.c generated by valac 0.56.17, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Copyright (c) 2013 gnome-pomodoro contributors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Kamil Prusko <kamilprusko@gmail.com>
 */

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include "gnome-pomodoro.h"
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))

VALA_EXTERN gchar* pomodoro_format_time (gint seconds);

gchar*
pomodoro_format_time (gint seconds)
{
	gint minutes = 0;
	gint hours = 0;
	gchar* str = NULL;
	gchar* _tmp0_;
	gboolean _tmp2_ = FALSE;
	gchar* result;
	minutes = (seconds / 60) % 60;
	hours = seconds / 3600;
	_tmp0_ = g_strdup ("");
	str = _tmp0_;
	if (hours > 0) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup_printf (ngettext ("%d hour", "%d hours", (gulong) hours), hours);
		_g_free0 (str);
		str = _tmp1_;
	}
	if (minutes > 0) {
		const gchar* _tmp3_;
		_tmp3_ = str;
		_tmp2_ = _tmp3_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = str;
		_tmp5_ = g_strconcat (_tmp4_, " ", NULL);
		_g_free0 (str);
		str = _tmp5_;
	}
	if (minutes > 0) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = str;
		_tmp7_ = g_strdup_printf (ngettext ("%d minute", "%d minutes", (gulong) minutes), minutes);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp6_, _tmp8_, NULL);
		_g_free0 (str);
		str = _tmp9_;
		_g_free0 (_tmp8_);
	}
	result = str;
	return result;
}

/**
     * Returns the number of seconds since January 1, 1970 UTC.
     */
gdouble
pomodoro_get_current_time (void)
{
	gdouble result;
	result = ((gdouble) g_get_real_time ()) / 1000000.0;
	return result;
}

