/* window.c generated by valac 0.56.17, the Vala compiler
 * generated from window.vala, do not modify */

/*
 * Copyright (c) 2016 gnome-pomodoro contributors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Kamil Prusko <kamilprusko@gmail.com>
 *
 */

#include "gnome-pomodoro.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>

#define POMODORO_WINDOW_MIN_WIDTH 500
#define POMODORO_WINDOW_MIN_HEIGHT 650
#define POMODORO_WINDOW_FADED_IN 1.0
#define POMODORO_WINDOW_FADED_OUT 0.2
#define POMODORO_WINDOW_TIMER_LINE_WIDTH 6.0
#define POMODORO_WINDOW_TIMER_RADIUS 165.0
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	POMODORO_WINDOW_0_PROPERTY,
	POMODORO_WINDOW_MODE_PROPERTY,
	POMODORO_WINDOW_DEFAULT_MODE_PROPERTY,
	POMODORO_WINDOW_NUM_PROPERTIES
};
static GParamSpec* pomodoro_window_properties[POMODORO_WINDOW_NUM_PROPERTIES];

#define POMODORO_WINDOW_TYPE_NAME (pomodoro_window_name_get_type ())
typedef struct _PomodoroWindowName PomodoroWindowName;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _PomodoroWindowPrivate {
	PomodoroTimer* timer;
	GtkStack* stack;
	GtkStack* timer_stack;
	GtkToggleButton* state_togglebutton;
	GtkLabel* minutes_label;
	GtkLabel* seconds_label;
	GtkWidget* timer_box;
	GtkButton* pause_resume_button;
	GtkButton* skip_stop_button;
	GtkImage* pause_resume_image;
	GtkImage* skip_stop_image;
	PomodoroAnimation* blink_animation;
	gchar* default_page;
};

struct _PomodoroWindowName {
	gchar* name;
	gchar* display_name;
};

static gint PomodoroWindow_private_offset;
static gpointer pomodoro_window_parent_class = NULL;
static GtkBuildableIface * pomodoro_window_gtk_buildable_parent_iface = NULL;

static GType pomodoro_window_name_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static PomodoroWindowName* pomodoro_window_name_dup (const PomodoroWindowName* self);
static void pomodoro_window_name_free (PomodoroWindowName* self);
static void pomodoro_window_name_copy (const PomodoroWindowName* self,
                                PomodoroWindowName* dest);
static void pomodoro_window_name_destroy (PomodoroWindowName* self);
static void pomodoro_window_real_parser_finished (GtkBuildable* base,
                                           GtkBuilder* builder);
static void pomodoro_window_on_timer_state_notify (PomodoroWindow* self);
static void _pomodoro_window_on_timer_state_notify_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self);
static void pomodoro_window_on_timer_elapsed_notify (PomodoroWindow* self);
static void _pomodoro_window_on_timer_elapsed_notify_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self);
static void pomodoro_window_on_timer_is_paused_notify (PomodoroWindow* self);
static void _pomodoro_window_on_timer_is_paused_notify_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
static void pomodoro_window_update_buttons (PomodoroWindow* self);
static void pomodoro_window_on_blink_animation_complete (PomodoroWindow* self);
static void _pomodoro_window_on_blink_animation_complete_pomodoro_animation_complete (PomodoroAnimation* _sender,
                                                                               gpointer self);
static gboolean pomodoro_window_on_timer_box_draw (PomodoroWindow* self,
                                            GtkWidget* widget,
                                            cairo_t* context);
static gboolean _pomodoro_window_on_timer_box_draw_gtk_widget_draw (GtkWidget* _sender,
                                                             cairo_t* cr,
                                                             gpointer self);
static gboolean pomodoro_window_on_button_press (PomodoroWindow* self,
                                          GtkWidget* widget,
                                          GdkEventButton* event);
static gboolean _pomodoro_window_on_button_press_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                         GdkEventButton* event,
                                                                         gpointer self);
static GObject * pomodoro_window_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void pomodoro_window_finalize (GObject * obj);
static GType pomodoro_window_get_type_once (void);
static void _vala_pomodoro_window_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_pomodoro_window_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static const PomodoroWindowName POMODORO_WINDOW_STATE_NAMES[4] = {{"null", ""}, {"pomodoro", N_ ("Pomodoro")}, {"short-break", N_ ("Short Break")}, {"long-break", N_ ("Long Break")}};

static inline gpointer
pomodoro_window_get_instance_private (PomodoroWindow* self)
{
	return G_STRUCT_MEMBER_P (self, PomodoroWindow_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_pomodoro_window_on_timer_state_notify_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self)
{
	pomodoro_window_on_timer_state_notify ((PomodoroWindow*) self);
}

static void
_pomodoro_window_on_timer_elapsed_notify_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self)
{
	pomodoro_window_on_timer_elapsed_notify ((PomodoroWindow*) self);
}

static void
_pomodoro_window_on_timer_is_paused_notify_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	pomodoro_window_on_timer_is_paused_notify ((PomodoroWindow*) self);
}

static void
pomodoro_window_real_parser_finished (GtkBuildable* base,
                                      GtkBuilder* builder)
{
	PomodoroWindow * self;
	PomodoroTimer* _tmp0_;
	PomodoroTimer* _tmp1_;
	GActionGroup* _tmp2_;
	GActionGroup* _tmp3_;
	GObject* state_togglebutton = NULL;
	GObject* _tmp4_;
	GObject* _tmp5_;
	GObject* _tmp6_;
	PomodoroTimer* _tmp7_;
	PomodoroTimer* _tmp8_;
	PomodoroTimer* _tmp9_;
	self = (PomodoroWindow*) base;
	g_return_if_fail (builder != NULL);
	_tmp0_ = pomodoro_timer_get_default ();
	self->priv->timer = _tmp0_;
	_tmp1_ = self->priv->timer;
	_tmp2_ = pomodoro_timer_get_action_group (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_widget_insert_action_group ((GtkWidget*) self, "timer", _tmp3_);
	_g_object_unref0 (_tmp3_);
	pomodoro_window_gtk_buildable_parent_iface->parser_finished ((GtkBuildable*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow), builder);
	_tmp4_ = gtk_builder_get_object (builder, "state_togglebutton");
	_tmp5_ = _g_object_ref0 (_tmp4_);
	state_togglebutton = _tmp5_;
	_tmp6_ = gtk_builder_get_object (builder, "state_popover");
	g_object_bind_property_with_closures (state_togglebutton, "active", _tmp6_, "visible", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp7_ = self->priv->timer;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::state", (GCallback) _pomodoro_window_on_timer_state_notify_g_object_notify, self, G_CONNECT_AFTER);
	_tmp8_ = self->priv->timer;
	g_signal_connect_object ((GObject*) _tmp8_, "notify::elapsed", (GCallback) _pomodoro_window_on_timer_elapsed_notify_g_object_notify, self, G_CONNECT_AFTER);
	_tmp9_ = self->priv->timer;
	g_signal_connect_object ((GObject*) _tmp9_, "notify::is-paused", (GCallback) _pomodoro_window_on_timer_is_paused_notify_g_object_notify, self, G_CONNECT_AFTER);
	_g_object_unref0 (state_togglebutton);
}

static void
pomodoro_window_update_buttons (PomodoroWindow* self)
{
	PomodoroTimer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	PomodoroTimer* _tmp11_;
	PomodoroTimerState* _tmp12_;
	PomodoroTimerState* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GQuark _tmp18_ = 0U;
	static GQuark _tmp17_label0 = 0;
	static GQuark _tmp17_label1 = 0;
	static GQuark _tmp17_label2 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timer;
	_tmp1_ = pomodoro_timer_get_is_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkImage* _tmp3_;
		GtkButton* _tmp4_;
		GtkImage* _tmp5_;
		GtkButton* _tmp6_;
		_tmp3_ = self->priv->pause_resume_image;
		g_object_set (_tmp3_, "icon-name", "media-playback-start-symbolic", NULL);
		_tmp4_ = self->priv->pause_resume_button;
		gtk_actionable_set_action_name ((GtkActionable*) _tmp4_, "timer.resume");
		_tmp5_ = self->priv->skip_stop_image;
		g_object_set (_tmp5_, "icon-name", "media-playback-stop-symbolic", NULL);
		_tmp6_ = self->priv->skip_stop_button;
		gtk_actionable_set_action_name ((GtkActionable*) _tmp6_, "timer.stop");
	} else {
		GtkImage* _tmp7_;
		GtkButton* _tmp8_;
		GtkImage* _tmp9_;
		GtkButton* _tmp10_;
		_tmp7_ = self->priv->pause_resume_image;
		g_object_set (_tmp7_, "icon-name", "media-playback-pause-symbolic", NULL);
		_tmp8_ = self->priv->pause_resume_button;
		gtk_actionable_set_action_name ((GtkActionable*) _tmp8_, "timer.pause");
		_tmp9_ = self->priv->skip_stop_image;
		g_object_set (_tmp9_, "icon-name", "media-skip-forward-symbolic", NULL);
		_tmp10_ = self->priv->skip_stop_button;
		gtk_actionable_set_action_name ((GtkActionable*) _tmp10_, "timer.skip");
	}
	_tmp11_ = self->priv->timer;
	_tmp12_ = pomodoro_timer_get_state (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = pomodoro_timer_state_get_name (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_;
	_tmp18_ = (NULL == _tmp16_) ? 0 : g_quark_from_string (_tmp16_);
	if (_tmp18_ == ((0 != _tmp17_label0) ? _tmp17_label0 : (_tmp17_label0 = g_quark_from_static_string ("pomodoro")))) {
		switch (0) {
			default:
			{
				PomodoroTimer* _tmp19_;
				gboolean _tmp20_;
				gboolean _tmp21_;
				_tmp19_ = self->priv->timer;
				_tmp20_ = pomodoro_timer_get_is_paused (_tmp19_);
				_tmp21_ = _tmp20_;
				if (_tmp21_) {
					GtkButton* _tmp22_;
					GtkButton* _tmp23_;
					_tmp22_ = self->priv->pause_resume_button;
					gtk_widget_set_tooltip_text ((GtkWidget*) _tmp22_, _ ("Resume Pomodoro"));
					_tmp23_ = self->priv->skip_stop_button;
					gtk_widget_set_tooltip_text ((GtkWidget*) _tmp23_, _ ("Stop"));
				} else {
					GtkButton* _tmp24_;
					GtkButton* _tmp25_;
					_tmp24_ = self->priv->pause_resume_button;
					gtk_widget_set_tooltip_text ((GtkWidget*) _tmp24_, _ ("Pause Pomodoro"));
					_tmp25_ = self->priv->skip_stop_button;
					gtk_widget_set_tooltip_text ((GtkWidget*) _tmp25_, _ ("Take a break"));
				}
				break;
			}
		}
	} else if ((_tmp18_ == ((0 != _tmp17_label1) ? _tmp17_label1 : (_tmp17_label1 = g_quark_from_static_string ("short-break")))) || (_tmp18_ == ((0 != _tmp17_label2) ? _tmp17_label2 : (_tmp17_label2 = g_quark_from_static_string ("long-break"))))) {
		switch (0) {
			default:
			{
				PomodoroTimer* _tmp26_;
				gboolean _tmp27_;
				gboolean _tmp28_;
				_tmp26_ = self->priv->timer;
				_tmp27_ = pomodoro_timer_get_is_paused (_tmp26_);
				_tmp28_ = _tmp27_;
				if (_tmp28_) {
					GtkButton* _tmp29_;
					GtkButton* _tmp30_;
					_tmp29_ = self->priv->pause_resume_button;
					gtk_widget_set_tooltip_text ((GtkWidget*) _tmp29_, _ ("Resume break"));
					_tmp30_ = self->priv->skip_stop_button;
					gtk_widget_set_tooltip_text ((GtkWidget*) _tmp30_, _ ("Stop"));
				} else {
					GtkButton* _tmp31_;
					GtkButton* _tmp32_;
					_tmp31_ = self->priv->pause_resume_button;
					gtk_widget_set_tooltip_text ((GtkWidget*) _tmp31_, _ ("Pause break"));
					_tmp32_ = self->priv->skip_stop_button;
					gtk_widget_set_tooltip_text ((GtkWidget*) _tmp32_, _ ("Start Pomodoro"));
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
}

static void
pomodoro_window_on_blink_animation_complete (PomodoroWindow* self)
{
	PomodoroTimer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timer;
	_tmp1_ = pomodoro_timer_get_is_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		PomodoroAnimation* _tmp3_;
		_tmp3_ = self->priv->blink_animation;
		pomodoro_animation_start_with_value (_tmp3_, 1.0);
	}
}

static void
pomodoro_window_on_timer_state_notify (PomodoroWindow* self)
{
	const gchar* _tmp0_ = NULL;
	PomodoroTimer* _tmp1_;
	PomodoroTimerState* _tmp2_;
	PomodoroTimerState* _tmp3_;
	GtkStack* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->timer;
	_tmp2_ = pomodoro_timer_get_state (_tmp1_);
	_tmp3_ = _tmp2_;
	if (POMODORO_IS_DISABLED_STATE (_tmp3_)) {
		_tmp0_ = "disabled";
	} else {
		_tmp0_ = "enabled";
	}
	_tmp4_ = self->priv->timer_stack;
	gtk_stack_set_visible_child_name (_tmp4_, _tmp0_);
	pomodoro_window_update_buttons (self);
	{
		PomodoroWindowName* mapping_collection = NULL;
		gint mapping_collection_length1 = 0;
		gint _mapping_collection_size_ = 0;
		gint mapping_it = 0;
		mapping_collection = POMODORO_WINDOW_STATE_NAMES;
		mapping_collection_length1 = G_N_ELEMENTS (POMODORO_WINDOW_STATE_NAMES);
		for (mapping_it = 0; mapping_it < mapping_collection_length1; mapping_it = mapping_it + 1) {
			PomodoroWindowName mapping = {0};
			mapping = mapping_collection[mapping_it];
			{
				gboolean _tmp5_ = FALSE;
				PomodoroWindowName _tmp6_;
				const gchar* _tmp7_;
				PomodoroTimer* _tmp8_;
				PomodoroTimerState* _tmp9_;
				PomodoroTimerState* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				_tmp6_ = mapping;
				_tmp7_ = _tmp6_.name;
				_tmp8_ = self->priv->timer;
				_tmp9_ = pomodoro_timer_get_state (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = pomodoro_timer_state_get_name (_tmp10_);
				_tmp12_ = _tmp11_;
				if (g_strcmp0 (_tmp7_, _tmp12_) == 0) {
					PomodoroWindowName _tmp13_;
					const gchar* _tmp14_;
					_tmp13_ = mapping;
					_tmp14_ = _tmp13_.display_name;
					_tmp5_ = g_strcmp0 (_tmp14_, "") != 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					GtkToggleButton* _tmp15_;
					PomodoroWindowName _tmp16_;
					const gchar* _tmp17_;
					_tmp15_ = self->priv->state_togglebutton;
					_tmp16_ = mapping;
					_tmp17_ = _tmp16_.display_name;
					gtk_button_set_label ((GtkButton*) _tmp15_, _tmp17_);
					break;
				}
			}
		}
	}
}

static void
pomodoro_window_on_timer_elapsed_notify (PomodoroWindow* self)
{
	PomodoroTimer* _tmp0_;
	PomodoroTimerState* _tmp1_;
	PomodoroTimerState* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timer;
	_tmp1_ = pomodoro_timer_get_state (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!POMODORO_IS_DISABLED_STATE (_tmp2_)) {
		guint remaining = 0U;
		PomodoroTimer* _tmp3_;
		gdouble _tmp4_;
		gdouble _tmp5_;
		guint minutes = 0U;
		guint seconds = 0U;
		GtkLabel* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GtkLabel* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GtkWidget* _tmp12_;
		_tmp3_ = self->priv->timer;
		_tmp4_ = pomodoro_timer_get_remaining (_tmp3_);
		_tmp5_ = _tmp4_;
		remaining = (guint) MAX (ceil (_tmp5_), 0.0);
		minutes = remaining / 60;
		seconds = remaining % 60;
		_tmp6_ = self->priv->minutes_label;
		_tmp7_ = g_strdup_printf ("%02u", minutes);
		_tmp8_ = _tmp7_;
		gtk_label_set_label (_tmp6_, _tmp8_);
		_g_free0 (_tmp8_);
		_tmp9_ = self->priv->seconds_label;
		_tmp10_ = g_strdup_printf ("%02u", seconds);
		_tmp11_ = _tmp10_;
		gtk_label_set_label (_tmp9_, _tmp11_);
		_g_free0 (_tmp11_);
		_tmp12_ = self->priv->timer_box;
		gtk_widget_queue_draw (_tmp12_);
	}
}

static void
_pomodoro_window_on_blink_animation_complete_pomodoro_animation_complete (PomodoroAnimation* _sender,
                                                                          gpointer self)
{
	pomodoro_window_on_blink_animation_complete ((PomodoroWindow*) self);
}

static void
pomodoro_window_on_timer_is_paused_notify (PomodoroWindow* self)
{
	PomodoroAnimation* _tmp0_;
	PomodoroTimer* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->blink_animation;
	if (_tmp0_ != NULL) {
		PomodoroAnimation* _tmp1_;
		_tmp1_ = self->priv->blink_animation;
		pomodoro_animation_stop (_tmp1_);
		_g_object_unref0 (self->priv->blink_animation);
		self->priv->blink_animation = NULL;
	}
	pomodoro_window_update_buttons (self);
	_tmp2_ = self->priv->timer;
	_tmp3_ = pomodoro_timer_get_is_paused (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		PomodoroAnimation* _tmp5_;
		PomodoroAnimation* _tmp6_;
		GtkWidget* _tmp7_;
		GValue _tmp8_ = {0};
		PomodoroAnimation* _tmp9_;
		PomodoroAnimation* _tmp10_;
		_tmp5_ = pomodoro_animation_new (POMODORO_ANIMATION_MODE_BLINK, (guint) 2500, (guint) 25);
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (self->priv->blink_animation);
		self->priv->blink_animation = _tmp5_;
		_tmp6_ = self->priv->blink_animation;
		_tmp7_ = self->priv->timer_box;
		g_value_init (&_tmp8_, G_TYPE_DOUBLE);
		g_value_set_double (&_tmp8_, POMODORO_WINDOW_FADED_OUT);
		pomodoro_animation_add_property (_tmp6_, (GObject*) _tmp7_, "opacity", &_tmp8_);
		G_IS_VALUE (&_tmp8_) ? (g_value_unset (&_tmp8_), NULL) : NULL;
		_tmp9_ = self->priv->blink_animation;
		g_signal_connect_object (_tmp9_, "complete", (GCallback) _pomodoro_window_on_blink_animation_complete_pomodoro_animation_complete, self, 0);
		_tmp10_ = self->priv->blink_animation;
		pomodoro_animation_start_with_value (_tmp10_, 1.0);
	} else {
		PomodoroAnimation* _tmp11_;
		PomodoroAnimation* _tmp12_;
		GtkWidget* _tmp13_;
		GValue _tmp14_ = {0};
		PomodoroAnimation* _tmp15_;
		_tmp11_ = pomodoro_animation_new (POMODORO_ANIMATION_MODE_EASE_OUT, (guint) 200, (guint) 50);
		g_object_ref_sink (_tmp11_);
		_g_object_unref0 (self->priv->blink_animation);
		self->priv->blink_animation = _tmp11_;
		_tmp12_ = self->priv->blink_animation;
		_tmp13_ = self->priv->timer_box;
		g_value_init (&_tmp14_, G_TYPE_DOUBLE);
		g_value_set_double (&_tmp14_, 1.0);
		pomodoro_animation_add_property (_tmp12_, (GObject*) _tmp13_, "opacity", &_tmp14_);
		G_IS_VALUE (&_tmp14_) ? (g_value_unset (&_tmp14_), NULL) : NULL;
		_tmp15_ = self->priv->blink_animation;
		pomodoro_animation_start (_tmp15_);
	}
}

static gboolean
pomodoro_window_on_timer_box_draw (PomodoroWindow* self,
                                   GtkWidget* widget,
                                   cairo_t* context)
{
	PomodoroTimer* _tmp0_;
	PomodoroTimerState* _tmp1_;
	PomodoroTimerState* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = self->priv->timer;
	_tmp1_ = pomodoro_timer_get_state (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!POMODORO_IS_DISABLED_STATE (_tmp2_)) {
		GtkStyleContext* style_context = NULL;
		GtkStyleContext* _tmp3_;
		GtkStyleContext* _tmp4_;
		GdkRGBA color = {0};
		GtkStyleContext* _tmp5_;
		GdkRGBA _tmp6_ = {0};
		gint width = 0;
		gint height = 0;
		gdouble x = 0.0;
		gdouble y = 0.0;
		gdouble _tmp7_ = 0.0;
		PomodoroTimer* _tmp8_;
		gdouble _tmp9_;
		gdouble _tmp10_;
		gdouble progress = 0.0;
		gdouble angle1 = 0.0;
		gdouble angle2 = 0.0;
		GdkRGBA _tmp17_;
		GdkRGBA _tmp18_;
		GdkRGBA _tmp19_;
		GdkRGBA _tmp20_;
		GdkRGBA _tmp21_;
		GdkRGBA _tmp22_;
		GdkRGBA _tmp23_;
		GdkRGBA _tmp24_;
		GdkRGBA _tmp25_;
		_tmp3_ = gtk_widget_get_style_context (widget);
		_tmp4_ = _g_object_ref0 (_tmp3_);
		style_context = _tmp4_;
		_tmp5_ = style_context;
		gtk_style_context_get_color (_tmp5_, gtk_widget_get_state_flags (widget), &_tmp6_);
		color = _tmp6_;
		width = gtk_widget_get_allocated_width (widget);
		height = gtk_widget_get_allocated_height (widget);
		x = 0.5 * width;
		y = 0.5 * height;
		_tmp8_ = self->priv->timer;
		_tmp9_ = pomodoro_timer_get_state_duration (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ > 0.0) {
			PomodoroTimer* _tmp11_;
			gdouble _tmp12_;
			gdouble _tmp13_;
			PomodoroTimer* _tmp14_;
			gdouble _tmp15_;
			gdouble _tmp16_;
			_tmp11_ = self->priv->timer;
			_tmp12_ = pomodoro_timer_get_elapsed (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = self->priv->timer;
			_tmp15_ = pomodoro_timer_get_state_duration (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp7_ = _tmp13_ / _tmp16_;
		} else {
			_tmp7_ = 0.0;
		}
		progress = _tmp7_;
		angle1 = ((-0.5) * G_PI) - ((2.0 * G_PI) * CLAMP (progress, 0.000001, 1.0));
		angle2 = (-0.5) * G_PI;
		cairo_set_line_width (context, POMODORO_WINDOW_TIMER_LINE_WIDTH);
		_tmp17_ = color;
		_tmp18_ = color;
		_tmp19_ = color;
		_tmp20_ = color;
		cairo_set_source_rgba (context, _tmp17_.red, _tmp18_.green, _tmp19_.blue, _tmp20_.alpha * 0.1);
		cairo_arc (context, x, y, POMODORO_WINDOW_TIMER_RADIUS, 0.0, 2 * G_PI);
		cairo_stroke (context);
		cairo_set_line_cap (context, CAIRO_LINE_CAP_ROUND);
		_tmp21_ = color;
		_tmp22_ = color;
		_tmp23_ = color;
		_tmp24_ = color;
		_tmp25_ = color;
		cairo_set_source_rgba (context, _tmp21_.red, _tmp22_.green, _tmp23_.blue, (_tmp24_.alpha * POMODORO_WINDOW_FADED_IN) - ((_tmp25_.alpha * 0.1) * (1.0 - POMODORO_WINDOW_FADED_IN)));
		cairo_arc_negative (context, x, y, POMODORO_WINDOW_TIMER_RADIUS, angle1, angle2);
		cairo_stroke (context);
		_g_object_unref0 (style_context);
	}
	result = FALSE;
	return result;
}

static gboolean
_pomodoro_window_on_timer_box_draw_gtk_widget_draw (GtkWidget* _sender,
                                                    cairo_t* cr,
                                                    gpointer self)
{
	gboolean result;
	result = pomodoro_window_on_timer_box_draw ((PomodoroWindow*) self, _sender, cr);
	return result;
}

static gboolean
pomodoro_window_on_button_press (PomodoroWindow* self,
                                 GtkWidget* widget,
                                 GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button == ((guint) 1)) {
		gtk_window_begin_move_drag ((GtkWindow*) self, (gint) event->button, (gint) event->x_root, (gint) event->y_root, event->time);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
_pomodoro_window_on_button_press_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                GdkEventButton* event,
                                                                gpointer self)
{
	gboolean result;
	result = pomodoro_window_on_button_press ((PomodoroWindow*) self, _sender, event);
	return result;
}

PomodoroWindow*
pomodoro_window_construct (GType object_type)
{
	PomodoroWindow * self = NULL;
	self = (PomodoroWindow*) g_object_new (object_type, NULL);
	return self;
}

PomodoroWindow*
pomodoro_window_new (void)
{
	return pomodoro_window_construct (POMODORO_TYPE_WINDOW);
}

const gchar*
pomodoro_window_get_mode (PomodoroWindow* self)
{
	const gchar* result;
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
pomodoro_window_set_mode (PomodoroWindow* self,
                          const gchar* value)
{
	GtkStack* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, pomodoro_window_properties[POMODORO_WINDOW_MODE_PROPERTY]);
}

const gchar*
pomodoro_window_get_default_mode (PomodoroWindow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->default_page;
	result = _tmp0_;
	return result;
}

static void
pomodoro_window_name_copy (const PomodoroWindowName* self,
                           PomodoroWindowName* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).display_name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).display_name);
	(*dest).display_name = _tmp3_;
}

static void
pomodoro_window_name_destroy (PomodoroWindowName* self)
{
	_g_free0 ((*self).name);
	_g_free0 ((*self).display_name);
}

static PomodoroWindowName*
pomodoro_window_name_dup (const PomodoroWindowName* self)
{
	PomodoroWindowName* dup;
	dup = g_new0 (PomodoroWindowName, 1);
	pomodoro_window_name_copy (self, dup);
	return dup;
}

static void
pomodoro_window_name_free (PomodoroWindowName* self)
{
	pomodoro_window_name_destroy (self);
	g_free (self);
}

static GType
pomodoro_window_name_get_type_once (void)
{
	GType pomodoro_window_name_type_id;
	pomodoro_window_name_type_id = g_boxed_type_register_static ("PomodoroWindowName", (GBoxedCopyFunc) pomodoro_window_name_dup, (GBoxedFreeFunc) pomodoro_window_name_free);
	return pomodoro_window_name_type_id;
}

static GType
pomodoro_window_name_get_type (void)
{
	static volatile gsize pomodoro_window_name_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_window_name_type_id__once)) {
		GType pomodoro_window_name_type_id;
		pomodoro_window_name_type_id = pomodoro_window_name_get_type_once ();
		g_once_init_leave (&pomodoro_window_name_type_id__once, pomodoro_window_name_type_id);
	}
	return pomodoro_window_name_type_id__once;
}

static GObject *
pomodoro_window_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PomodoroWindow * self;
	GdkGeometry geometry = {0};
	GdkGeometry _tmp0_ = {0};
	GdkGeometry _tmp1_;
	GtkStack* _tmp2_;
	PomodoroStatsView* _tmp3_;
	PomodoroStatsView* _tmp4_;
	PomodoroApplication* application = NULL;
	PomodoroApplication* _tmp5_;
	PomodoroApplication* _tmp6_;
	gchar* _tmp7_;
	GtkStack* _tmp8_;
	const gchar* _tmp9_;
	parent_class = G_OBJECT_CLASS (pomodoro_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_WINDOW, PomodoroWindow);
	memset (&_tmp0_, 0, sizeof (GdkGeometry));
	_tmp0_.min_width = POMODORO_WINDOW_MIN_WIDTH;
	_tmp0_.max_width = -1;
	_tmp0_.min_height = POMODORO_WINDOW_MIN_HEIGHT;
	_tmp0_.max_height = -1;
	geometry = _tmp0_;
	_tmp1_ = geometry;
	gtk_window_set_geometry_hints ((GtkWindow*) self, (GtkWidget*) self, &_tmp1_, GDK_HINT_MIN_SIZE);
	_tmp2_ = self->priv->stack;
	_tmp3_ = pomodoro_stats_view_new ();
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	gtk_stack_add_titled (_tmp2_, (GtkWidget*) _tmp4_, "stats", _ ("Stats"));
	_g_object_unref0 (_tmp4_);
	_tmp5_ = pomodoro_application_get_default ();
	_tmp6_ = _g_object_ref0 (_tmp5_);
	application = _tmp6_;
	_tmp7_ = g_strdup ("timer");
	_g_free0 (self->priv->default_page);
	self->priv->default_page = _tmp7_;
	_tmp8_ = self->priv->stack;
	_tmp9_ = self->priv->default_page;
	gtk_stack_set_visible_child_name (_tmp8_, _tmp9_);
	pomodoro_window_on_timer_state_notify (self);
	pomodoro_window_on_timer_elapsed_notify (self);
	pomodoro_window_on_timer_is_paused_notify (self);
	pomodoro_window_update_buttons (self);
	_g_object_unref0 (application);
	return obj;
}

static void
pomodoro_window_class_init (PomodoroWindowClass * klass,
                            gpointer klass_data)
{
	pomodoro_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PomodoroWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pomodoro_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pomodoro_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = pomodoro_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = pomodoro_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_WINDOW_MODE_PROPERTY, pomodoro_window_properties[POMODORO_WINDOW_MODE_PROPERTY] = g_param_spec_string ("mode", "mode", "mode", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_WINDOW_DEFAULT_MODE_PROPERTY, pomodoro_window_properties[POMODORO_WINDOW_DEFAULT_MODE_PROPERTY] = g_param_spec_string ("default-mode", "default-mode", "default-mode", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/pomodoro/window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, PomodoroWindow_private_offset + G_STRUCT_OFFSET (PomodoroWindowPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "timer_stack", FALSE, PomodoroWindow_private_offset + G_STRUCT_OFFSET (PomodoroWindowPrivate, timer_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "state_togglebutton", FALSE, PomodoroWindow_private_offset + G_STRUCT_OFFSET (PomodoroWindowPrivate, state_togglebutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "minutes_label", FALSE, PomodoroWindow_private_offset + G_STRUCT_OFFSET (PomodoroWindowPrivate, minutes_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "seconds_label", FALSE, PomodoroWindow_private_offset + G_STRUCT_OFFSET (PomodoroWindowPrivate, seconds_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "timer_box", FALSE, PomodoroWindow_private_offset + G_STRUCT_OFFSET (PomodoroWindowPrivate, timer_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pause_resume_button", FALSE, PomodoroWindow_private_offset + G_STRUCT_OFFSET (PomodoroWindowPrivate, pause_resume_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "skip_stop_button", FALSE, PomodoroWindow_private_offset + G_STRUCT_OFFSET (PomodoroWindowPrivate, skip_stop_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pause_resume_image", FALSE, PomodoroWindow_private_offset + G_STRUCT_OFFSET (PomodoroWindowPrivate, pause_resume_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "skip_stop_image", FALSE, PomodoroWindow_private_offset + G_STRUCT_OFFSET (PomodoroWindowPrivate, skip_stop_image));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_timer_box_draw", G_CALLBACK(_pomodoro_window_on_timer_box_draw_gtk_widget_draw));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_button_press", G_CALLBACK(_pomodoro_window_on_button_press_gtk_widget_button_press_event));
}

static void
pomodoro_window_gtk_buildable_interface_init (GtkBuildableIface * iface,
                                              gpointer iface_data)
{
	pomodoro_window_gtk_buildable_parent_iface = g_type_interface_peek_parent (iface);
	iface->parser_finished = (void (*) (GtkBuildable*, GtkBuilder*)) pomodoro_window_real_parser_finished;
}

static void
pomodoro_window_instance_init (PomodoroWindow * self,
                               gpointer klass)
{
	self->priv = pomodoro_window_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
pomodoro_window_finalize (GObject * obj)
{
	PomodoroWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_WINDOW, PomodoroWindow);
	_g_object_unref0 (self->priv->blink_animation);
	_g_free0 (self->priv->default_page);
	G_OBJECT_CLASS (pomodoro_window_parent_class)->finalize (obj);
}

static GType
pomodoro_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PomodoroWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pomodoro_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PomodoroWindow), 0, (GInstanceInitFunc) pomodoro_window_instance_init, NULL };
	static const GInterfaceInfo gtk_buildable_info = { (GInterfaceInitFunc) pomodoro_window_gtk_buildable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType pomodoro_window_type_id;
	pomodoro_window_type_id = g_type_register_static (gtk_application_window_get_type (), "PomodoroWindow", &g_define_type_info, 0);
	g_type_add_interface_static (pomodoro_window_type_id, gtk_buildable_get_type (), &gtk_buildable_info);
	PomodoroWindow_private_offset = g_type_add_instance_private (pomodoro_window_type_id, sizeof (PomodoroWindowPrivate));
	return pomodoro_window_type_id;
}

GType
pomodoro_window_get_type (void)
{
	static volatile gsize pomodoro_window_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_window_type_id__once)) {
		GType pomodoro_window_type_id;
		pomodoro_window_type_id = pomodoro_window_get_type_once ();
		g_once_init_leave (&pomodoro_window_type_id__once, pomodoro_window_type_id);
	}
	return pomodoro_window_type_id__once;
}

static void
_vala_pomodoro_window_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	PomodoroWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POMODORO_TYPE_WINDOW, PomodoroWindow);
	switch (property_id) {
		case POMODORO_WINDOW_MODE_PROPERTY:
		g_value_set_string (value, pomodoro_window_get_mode (self));
		break;
		case POMODORO_WINDOW_DEFAULT_MODE_PROPERTY:
		g_value_set_string (value, pomodoro_window_get_default_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pomodoro_window_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	PomodoroWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POMODORO_TYPE_WINDOW, PomodoroWindow);
	switch (property_id) {
		case POMODORO_WINDOW_MODE_PROPERTY:
		pomodoro_window_set_mode (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

