/* service.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from service.vala, do not modify */

/*
 * Copyright (c) 2012-2013 gnome-pomodoro contributors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Kamil Prusko <kamilprusko@gmail.com>
 *
 */

#include "gnome-pomodoro.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <config.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	POMODORO_SERVICE_0_PROPERTY,
	POMODORO_SERVICE_ELAPSED_PROPERTY,
	POMODORO_SERVICE_STATE_PROPERTY,
	POMODORO_SERVICE_STATE_DURATION_PROPERTY,
	POMODORO_SERVICE_IS_PAUSED_PROPERTY,
	POMODORO_SERVICE_VERSION_PROPERTY,
	POMODORO_SERVICE_NUM_PROPERTIES
};
static GParamSpec* pomodoro_service_properties[POMODORO_SERVICE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block15Data Block15Data;
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	POMODORO_SERVICE_STATE_CHANGED_SIGNAL,
	POMODORO_SERVICE_NUM_SIGNALS
};
static guint pomodoro_service_signals[POMODORO_SERVICE_NUM_SIGNALS] = {0};
#define _g_free0(var) (var = (g_free (var), NULL))

struct _PomodoroServicePrivate {
	GDBusConnection* connection;
	PomodoroTimer* timer;
	GHashTable* changed_properties;
	guint idle_id;
	GCancellable* cancellable;
};

struct _Block15Data {
	int _ref_count_;
	PomodoroService* self;
	GVariantBuilder* builder_properties;
};

static gint PomodoroService_private_offset;
static gpointer pomodoro_service_parent_class = NULL;

static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static void pomodoro_service_on_timer_state_changed (PomodoroService* self,
                                              PomodoroTimerState* state,
                                              PomodoroTimerState* previous_state);
static void _pomodoro_service_on_timer_state_changed_pomodoro_timer_state_changed (PomodoroTimer* _sender,
                                                                            PomodoroTimerState* state,
                                                                            PomodoroTimerState* previous_state,
                                                                            gpointer self);
static void pomodoro_service_on_timer_property_notify (PomodoroService* self,
                                                GParamSpec* param_spec);
static void _pomodoro_service_on_timer_property_notify_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
static void pomodoro_service_flush (PomodoroService* self);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static void __lambda7_ (Block15Data* _data15_,
                 const gchar* key,
                 GVariant* value);
static void ___lambda7__gh_func (gconstpointer key,
                          gconstpointer value,
                          gpointer self);
static void pomodoro_service_send_property_changed (PomodoroService* self,
                                             const gchar* property_name,
                                             GVariant* new_value);
static gboolean ___lambda6_ (PomodoroService* self);
static gboolean ____lambda6__gsource_func (gpointer self);
static GHashTable* pomodoro_service_serialize_timer_state (PomodoroTimerState* state);
static void g_cclosure_user_marshal_VOID__BOXED_BOXED (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static void pomodoro_service_finalize (GObject * obj);
static GType pomodoro_service_get_type_once (void);
static void _vala_pomodoro_service_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _dbus_pomodoro_service_set_state (PomodoroService* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation);
static void _dbus_pomodoro_service_set_state_duration (PomodoroService* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation);
static void _dbus_pomodoro_service_show_main_window (PomodoroService* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation);
static void _dbus_pomodoro_service_show_preferences (PomodoroService* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation);
static void _dbus_pomodoro_service_start (PomodoroService* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation);
static void _dbus_pomodoro_service_stop (PomodoroService* self,
                                  GVariant* _parameters_,
                                  GDBusMethodInvocation* invocation);
static void _dbus_pomodoro_service_reset (PomodoroService* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation);
static void _dbus_pomodoro_service_pause (PomodoroService* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation);
static void _dbus_pomodoro_service_resume (PomodoroService* self,
                                    GVariant* _parameters_,
                                    GDBusMethodInvocation* invocation);
static void _dbus_pomodoro_service_skip (PomodoroService* self,
                                  GVariant* _parameters_,
                                  GDBusMethodInvocation* invocation);
static void _dbus_pomodoro_service_quit (PomodoroService* self,
                                  GVariant* _parameters_,
                                  GDBusMethodInvocation* invocation);
static void pomodoro_service_dbus_interface_method_call (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* method_name,
                                                  GVariant* parameters,
                                                  GDBusMethodInvocation* invocation,
                                                  gpointer user_data);
static GVariant* pomodoro_service_dbus_interface_get_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GError** error,
                                                        gpointer user_data);
static GVariant* _dbus_pomodoro_service_get_elapsed (PomodoroService* self);
static GVariant* _dbus_pomodoro_service_get_state (PomodoroService* self);
static GVariant* _dbus_pomodoro_service_get_state_duration (PomodoroService* self);
static GVariant* _dbus_pomodoro_service_get_is_paused (PomodoroService* self);
static GVariant* _dbus_pomodoro_service_get_version (PomodoroService* self);
static gboolean pomodoro_service_dbus_interface_set_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GVariant* value,
                                                       GError** error,
                                                       gpointer user_data);
static void _dbus_pomodoro_service_state_changed (GObject* _sender,
                                           GHashTable* state,
                                           GHashTable* previous_state,
                                           gpointer* _data);
static void _pomodoro_service_unregister_object (gpointer user_data);

static const GDBusArgInfo _pomodoro_service_dbus_arg_info_set_state_name = {-1, "name", "s", NULL};
static const GDBusArgInfo _pomodoro_service_dbus_arg_info_set_state_timestamp = {-1, "timestamp", "d", NULL};
static const GDBusArgInfo * const _pomodoro_service_dbus_arg_info_set_state_in[] = {&_pomodoro_service_dbus_arg_info_set_state_name, &_pomodoro_service_dbus_arg_info_set_state_timestamp, NULL};
static const GDBusArgInfo * const _pomodoro_service_dbus_arg_info_set_state_out[] = {NULL};
static const GDBusMethodInfo _pomodoro_service_dbus_method_info_set_state = {-1, "SetState", (GDBusArgInfo **) (&_pomodoro_service_dbus_arg_info_set_state_in), (GDBusArgInfo **) (&_pomodoro_service_dbus_arg_info_set_state_out), NULL};
static const GDBusArgInfo _pomodoro_service_dbus_arg_info_set_state_duration_name = {-1, "name", "s", NULL};
static const GDBusArgInfo _pomodoro_service_dbus_arg_info_set_state_duration_duration = {-1, "duration", "d", NULL};
static const GDBusArgInfo * const _pomodoro_service_dbus_arg_info_set_state_duration_in[] = {&_pomodoro_service_dbus_arg_info_set_state_duration_name, &_pomodoro_service_dbus_arg_info_set_state_duration_duration, NULL};
static const GDBusArgInfo * const _pomodoro_service_dbus_arg_info_set_state_duration_out[] = {NULL};
static const GDBusMethodInfo _pomodoro_service_dbus_method_info_set_state_duration = {-1, "SetStateDuration", (GDBusArgInfo **) (&_pomodoro_service_dbus_arg_info_set_state_duration_in), (GDBusArgInfo **) (&_pomodoro_service_dbus_arg_info_set_state_duration_out), NULL};
static const GDBusArgInfo _pomodoro_service_dbus_arg_info_show_main_window_mode = {-1, "mode", "s", NULL};
static const GDBusArgInfo _pomodoro_service_dbus_arg_info_show_main_window_timestamp = {-1, "timestamp", "u", NULL};
static const GDBusArgInfo * const _pomodoro_service_dbus_arg_info_show_main_window_in[] = {&_pomodoro_service_dbus_arg_info_show_main_window_mode, &_pomodoro_service_dbus_arg_info_show_main_window_timestamp, NULL};
static const GDBusArgInfo * const _pomodoro_service_dbus_arg_info_show_main_window_out[] = {NULL};
static const GDBusMethodInfo _pomodoro_service_dbus_method_info_show_main_window = {-1, "ShowMainWindow", (GDBusArgInfo **) (&_pomodoro_service_dbus_arg_info_show_main_window_in), (GDBusArgInfo **) (&_pomodoro_service_dbus_arg_info_show_main_window_out), NULL};
static const GDBusArgInfo _pomodoro_service_dbus_arg_info_show_preferences_timestamp = {-1, "timestamp", "u", NULL};
static const GDBusArgInfo * const _pomodoro_service_dbus_arg_info_show_preferences_in[] = {&_pomodoro_service_dbus_arg_info_show_preferences_timestamp, NULL};
static const GDBusArgInfo * const _pomodoro_service_dbus_arg_info_show_preferences_out[] = {NULL};
static const GDBusMethodInfo _pomodoro_service_dbus_method_info_show_preferences = {-1, "ShowPreferences", (GDBusArgInfo **) (&_pomodoro_service_dbus_arg_info_show_preferences_in), (GDBusArgInfo **) (&_pomodoro_service_dbus_arg_info_show_preferences_out), NULL};
static const GDBusArgInfo * const _pomodoro_service_dbus_arg_info_start_in[] = {NULL};
static const GDBusArgInfo * const _pomodoro_service_dbus_arg_info_start_out[] = {NULL};
static const GDBusMethodInfo _pomodoro_service_dbus_method_info_start = {-1, "Start", (GDBusArgInfo **) (&_pomodoro_service_dbus_arg_info_start_in), (GDBusArgInfo **) (&_pomodoro_service_dbus_arg_info_start_out), NULL};
static const GDBusArgInfo * const _pomodoro_service_dbus_arg_info_stop_in[] = {NULL};
static const GDBusArgInfo * const _pomodoro_service_dbus_arg_info_stop_out[] = {NULL};
static const GDBusMethodInfo _pomodoro_service_dbus_method_info_stop = {-1, "Stop", (GDBusArgInfo **) (&_pomodoro_service_dbus_arg_info_stop_in), (GDBusArgInfo **) (&_pomodoro_service_dbus_arg_info_stop_out), NULL};
static const GDBusArgInfo * const _pomodoro_service_dbus_arg_info_reset_in[] = {NULL};
static const GDBusArgInfo * const _pomodoro_service_dbus_arg_info_reset_out[] = {NULL};
static const GDBusMethodInfo _pomodoro_service_dbus_method_info_reset = {-1, "Reset", (GDBusArgInfo **) (&_pomodoro_service_dbus_arg_info_reset_in), (GDBusArgInfo **) (&_pomodoro_service_dbus_arg_info_reset_out), NULL};
static const GDBusArgInfo * const _pomodoro_service_dbus_arg_info_pause_in[] = {NULL};
static const GDBusArgInfo * const _pomodoro_service_dbus_arg_info_pause_out[] = {NULL};
static const GDBusMethodInfo _pomodoro_service_dbus_method_info_pause = {-1, "Pause", (GDBusArgInfo **) (&_pomodoro_service_dbus_arg_info_pause_in), (GDBusArgInfo **) (&_pomodoro_service_dbus_arg_info_pause_out), NULL};
static const GDBusArgInfo * const _pomodoro_service_dbus_arg_info_resume_in[] = {NULL};
static const GDBusArgInfo * const _pomodoro_service_dbus_arg_info_resume_out[] = {NULL};
static const GDBusMethodInfo _pomodoro_service_dbus_method_info_resume = {-1, "Resume", (GDBusArgInfo **) (&_pomodoro_service_dbus_arg_info_resume_in), (GDBusArgInfo **) (&_pomodoro_service_dbus_arg_info_resume_out), NULL};
static const GDBusArgInfo * const _pomodoro_service_dbus_arg_info_skip_in[] = {NULL};
static const GDBusArgInfo * const _pomodoro_service_dbus_arg_info_skip_out[] = {NULL};
static const GDBusMethodInfo _pomodoro_service_dbus_method_info_skip = {-1, "Skip", (GDBusArgInfo **) (&_pomodoro_service_dbus_arg_info_skip_in), (GDBusArgInfo **) (&_pomodoro_service_dbus_arg_info_skip_out), NULL};
static const GDBusArgInfo * const _pomodoro_service_dbus_arg_info_quit_in[] = {NULL};
static const GDBusArgInfo * const _pomodoro_service_dbus_arg_info_quit_out[] = {NULL};
static const GDBusMethodInfo _pomodoro_service_dbus_method_info_quit = {-1, "Quit", (GDBusArgInfo **) (&_pomodoro_service_dbus_arg_info_quit_in), (GDBusArgInfo **) (&_pomodoro_service_dbus_arg_info_quit_out), NULL};
static const GDBusMethodInfo * const _pomodoro_service_dbus_method_info[] = {&_pomodoro_service_dbus_method_info_set_state, &_pomodoro_service_dbus_method_info_set_state_duration, &_pomodoro_service_dbus_method_info_show_main_window, &_pomodoro_service_dbus_method_info_show_preferences, &_pomodoro_service_dbus_method_info_start, &_pomodoro_service_dbus_method_info_stop, &_pomodoro_service_dbus_method_info_reset, &_pomodoro_service_dbus_method_info_pause, &_pomodoro_service_dbus_method_info_resume, &_pomodoro_service_dbus_method_info_skip, &_pomodoro_service_dbus_method_info_quit, NULL};
static const GDBusArgInfo _pomodoro_service_dbus_arg_info_state_changed_state = {-1, "state", "a{sv}", NULL};
static const GDBusArgInfo _pomodoro_service_dbus_arg_info_state_changed_previous_state = {-1, "previous_state", "a{sv}", NULL};
static const GDBusArgInfo * const _pomodoro_service_dbus_arg_info_state_changed[] = {&_pomodoro_service_dbus_arg_info_state_changed_state, &_pomodoro_service_dbus_arg_info_state_changed_previous_state, NULL};
static const GDBusSignalInfo _pomodoro_service_dbus_signal_info_state_changed = {-1, "StateChanged", (GDBusArgInfo **) (&_pomodoro_service_dbus_arg_info_state_changed), NULL};
static const GDBusSignalInfo * const _pomodoro_service_dbus_signal_info[] = {&_pomodoro_service_dbus_signal_info_state_changed, NULL};
static const GDBusPropertyInfo _pomodoro_service_dbus_property_info_elapsed = {-1, "Elapsed", "d", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _pomodoro_service_dbus_property_info_state = {-1, "State", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _pomodoro_service_dbus_property_info_state_duration = {-1, "StateDuration", "d", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _pomodoro_service_dbus_property_info_is_paused = {-1, "IsPaused", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _pomodoro_service_dbus_property_info_version = {-1, "Version", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _pomodoro_service_dbus_property_info[] = {&_pomodoro_service_dbus_property_info_elapsed, &_pomodoro_service_dbus_property_info_state, &_pomodoro_service_dbus_property_info_state_duration, &_pomodoro_service_dbus_property_info_is_paused, &_pomodoro_service_dbus_property_info_version, NULL};
static const GDBusInterfaceInfo _pomodoro_service_dbus_interface_info = {-1, "org.gnome.Pomodoro", (GDBusMethodInfo **) (&_pomodoro_service_dbus_method_info), (GDBusSignalInfo **) (&_pomodoro_service_dbus_signal_info), (GDBusPropertyInfo **) (&_pomodoro_service_dbus_property_info), NULL};
static const GDBusInterfaceVTable _pomodoro_service_dbus_interface_vtable = {pomodoro_service_dbus_interface_method_call, pomodoro_service_dbus_interface_get_property, pomodoro_service_dbus_interface_set_property};

static inline gpointer
pomodoro_service_get_instance_private (PomodoroService* self)
{
	return G_STRUCT_MEMBER_P (self, PomodoroService_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_pomodoro_service_on_timer_state_changed_pomodoro_timer_state_changed (PomodoroTimer* _sender,
                                                                       PomodoroTimerState* state,
                                                                       PomodoroTimerState* previous_state,
                                                                       gpointer self)
{
	pomodoro_service_on_timer_state_changed ((PomodoroService*) self, state, previous_state);
}

static void
_pomodoro_service_on_timer_property_notify_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	pomodoro_service_on_timer_property_notify ((PomodoroService*) self, pspec);
}

PomodoroService*
pomodoro_service_construct (GType object_type,
                            GDBusConnection* connection,
                            PomodoroTimer* timer)
{
	PomodoroService * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GCancellable* _tmp3_;
	PomodoroTimer* _tmp4_;
	PomodoroTimer* _tmp5_;
	PomodoroTimer* _tmp6_;
	g_return_val_if_fail (connection != NULL, NULL);
	g_return_val_if_fail (timer != NULL, NULL);
	self = (PomodoroService*) g_object_new (object_type, NULL);
	self->priv->connection = connection;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_variant_unref0_);
	_g_hash_table_unref0 (self->priv->changed_properties);
	self->priv->changed_properties = _tmp2_;
	self->priv->idle_id = (guint) 0;
	_tmp3_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp3_;
	_tmp4_ = _g_object_ref0 (timer);
	_g_object_unref0 (self->priv->timer);
	self->priv->timer = _tmp4_;
	_tmp5_ = self->priv->timer;
	g_signal_connect_object (_tmp5_, "state-changed", (GCallback) _pomodoro_service_on_timer_state_changed_pomodoro_timer_state_changed, self, 0);
	_tmp6_ = self->priv->timer;
	g_signal_connect_object ((GObject*) _tmp6_, "notify", (GCallback) _pomodoro_service_on_timer_property_notify_g_object_notify, self, 0);
	return self;
}

PomodoroService*
pomodoro_service_new (GDBusConnection* connection,
                      PomodoroTimer* timer)
{
	return pomodoro_service_construct (POMODORO_TYPE_SERVICE, connection, timer);
}

void
pomodoro_service_set_state (PomodoroService* self,
                            const gchar* name,
                            gdouble timestamp,
                            GError** error)
{
	PomodoroTimerState* state = NULL;
	PomodoroTimerState* _tmp0_;
	PomodoroTimerState* _tmp2_;
	PomodoroTimer* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = pomodoro_timer_state_lookup (name);
	state = _tmp0_;
	if (timestamp > 0.0) {
		PomodoroTimerState* _tmp1_;
		_tmp1_ = state;
		pomodoro_timer_state_set_timestamp (_tmp1_, timestamp);
	}
	_tmp2_ = state;
	if (_tmp2_ != NULL) {
		PomodoroTimer* _tmp3_;
		PomodoroTimerState* _tmp4_;
		_tmp3_ = self->priv->timer;
		_tmp4_ = state;
		pomodoro_timer_set_state (_tmp3_, _tmp4_);
	}
	_tmp5_ = self->priv->timer;
	g_signal_emit_by_name (_tmp5_, "update", pomodoro_get_current_time ());
	_g_object_unref0 (state);
}

void
pomodoro_service_set_state_duration (PomodoroService* self,
                                     const gchar* name,
                                     gdouble duration,
                                     GError** error)
{
	PomodoroTimer* _tmp0_;
	PomodoroTimerState* _tmp1_;
	PomodoroTimerState* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->timer;
	_tmp1_ = pomodoro_timer_get_state (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = pomodoro_timer_state_get_name (_tmp2_);
	_tmp4_ = _tmp3_;
	if (g_strcmp0 (_tmp4_, name) == 0) {
		PomodoroTimer* _tmp5_;
		PomodoroTimer* _tmp6_;
		gdouble _tmp7_;
		gdouble _tmp8_;
		_tmp5_ = self->priv->timer;
		_tmp6_ = self->priv->timer;
		_tmp7_ = pomodoro_timer_get_elapsed (_tmp6_);
		_tmp8_ = _tmp7_;
		pomodoro_timer_set_state_duration (_tmp5_, MAX (duration, _tmp8_));
	} else {
	}
}

void
pomodoro_service_show_main_window (PomodoroService* self,
                                   const gchar* mode,
                                   guint32 timestamp,
                                   GError** error)
{
	PomodoroApplication* application = NULL;
	PomodoroApplication* _tmp0_;
	PomodoroApplication* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mode != NULL);
	_tmp0_ = pomodoro_application_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	application = _tmp1_;
	pomodoro_application_show_window (application, mode, timestamp);
	_g_object_unref0 (application);
}

void
pomodoro_service_show_preferences (PomodoroService* self,
                                   guint32 timestamp,
                                   GError** error)
{
	PomodoroApplication* application = NULL;
	PomodoroApplication* _tmp0_;
	PomodoroApplication* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pomodoro_application_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	application = _tmp1_;
	pomodoro_application_show_preferences (application, timestamp);
	_g_object_unref0 (application);
}

void
pomodoro_service_start (PomodoroService* self,
                        GError** error)
{
	PomodoroTimer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timer;
	pomodoro_timer_start (_tmp0_, pomodoro_get_current_time ());
}

void
pomodoro_service_stop (PomodoroService* self,
                       GError** error)
{
	PomodoroTimer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timer;
	pomodoro_timer_stop (_tmp0_, pomodoro_get_current_time ());
}

void
pomodoro_service_reset (PomodoroService* self,
                        GError** error)
{
	PomodoroTimer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timer;
	pomodoro_timer_reset (_tmp0_, pomodoro_get_current_time ());
}

void
pomodoro_service_pause (PomodoroService* self,
                        GError** error)
{
	PomodoroTimer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timer;
	pomodoro_timer_pause (_tmp0_, pomodoro_get_current_time ());
}

void
pomodoro_service_resume (PomodoroService* self,
                         GError** error)
{
	PomodoroTimer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timer;
	pomodoro_timer_resume (_tmp0_, pomodoro_get_current_time ());
}

void
pomodoro_service_skip (PomodoroService* self,
                       GError** error)
{
	PomodoroTimer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timer;
	pomodoro_timer_skip (_tmp0_, pomodoro_get_current_time ());
}

void
pomodoro_service_quit (PomodoroService* self,
                       GError** error)
{
	PomodoroTimer* _tmp0_;
	PomodoroApplication* application = NULL;
	PomodoroApplication* _tmp1_;
	PomodoroApplication* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timer;
	pomodoro_timer_stop (_tmp0_, pomodoro_get_current_time ());
	_tmp1_ = pomodoro_application_get_default ();
	_tmp2_ = _g_object_ref0 (_tmp1_);
	application = _tmp2_;
	g_application_quit ((GApplication*) application);
	_g_object_unref0 (application);
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		PomodoroService* self;
		self = _data15_->self;
		_g_variant_builder_unref0 (_data15_->builder_properties);
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}

static void
__lambda7_ (Block15Data* _data15_,
            const gchar* key,
            GVariant* value)
{
	PomodoroService* self;
	GVariantBuilder* _tmp0_;
	self = _data15_->self;
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = _data15_->builder_properties;
	g_variant_builder_add (_tmp0_, "{sv}", key, value, NULL);
}

static void
___lambda7__gh_func (gconstpointer key,
                     gconstpointer value,
                     gpointer self)
{
	__lambda7_ (self, (const gchar*) key, (GVariant*) value);
}

static void
pomodoro_service_flush (PomodoroService* self)
{
	Block15Data* _data15_;
	const GVariantType* _tmp0_;
	GVariantBuilder* _tmp1_;
	GVariantBuilder* builder_invalid = NULL;
	const GVariantType* _tmp2_;
	GVariantBuilder* _tmp3_;
	GHashTable* _tmp4_;
	GHashTable* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	_tmp0_ = G_VARIANT_TYPE_ARRAY;
	_tmp1_ = g_variant_builder_new (_tmp0_);
	_data15_->builder_properties = _tmp1_;
	_tmp2_ = G_VARIANT_TYPE_STRING_ARRAY;
	_tmp3_ = g_variant_builder_new (_tmp2_);
	builder_invalid = _tmp3_;
	_tmp4_ = self->priv->changed_properties;
	g_hash_table_foreach (_tmp4_, ___lambda7__gh_func, _data15_);
	_tmp5_ = self->priv->changed_properties;
	g_hash_table_remove_all (_tmp5_);
	{
		GDBusConnection* _tmp6_;
		GVariantBuilder* _tmp7_;
		GVariantBuilder* _tmp8_;
		GVariant* _tmp9_;
		GVariant* _tmp10_;
		GDBusConnection* _tmp11_;
		GCancellable* _tmp12_;
		_tmp6_ = self->priv->connection;
		_tmp7_ = _data15_->builder_properties;
		_tmp8_ = builder_invalid;
		_tmp9_ = g_variant_new ("(sa{sv}as)", "org.gnome.Pomodoro", _tmp7_, _tmp8_, NULL);
		g_variant_ref_sink (_tmp9_);
		_tmp10_ = _tmp9_;
		g_dbus_connection_emit_signal (_tmp6_, NULL, "/org/gnome/Pomodoro", "org.freedesktop.DBus.Properties", "PropertiesChanged", _tmp10_, &_inner_error0_);
		_g_variant_unref0 (_tmp10_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp11_ = self->priv->connection;
		_tmp12_ = self->priv->cancellable;
		g_dbus_connection_flush_sync (_tmp11_, _tmp12_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = _error_;
		_tmp14_ = _tmp13_->message;
		g_warning ("service.vala:170: %s", _tmp14_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_variant_builder_unref0 (builder_invalid);
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (self->priv->idle_id != ((guint) 0)) {
		g_source_remove (self->priv->idle_id);
		self->priv->idle_id = (guint) 0;
	}
	_g_variant_builder_unref0 (builder_invalid);
	block15_data_unref (_data15_);
	_data15_ = NULL;
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static gboolean
___lambda6_ (PomodoroService* self)
{
	gboolean result;
	pomodoro_service_flush (self);
	result = FALSE;
	return result;
}

static gboolean
____lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda6_ ((PomodoroService*) self);
	return result;
}

static void
pomodoro_service_send_property_changed (PomodoroService* self,
                                        const gchar* property_name,
                                        GVariant* new_value)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	GVariant* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (property_name != NULL);
	g_return_if_fail (new_value != NULL);
	_tmp0_ = self->priv->changed_properties;
	_tmp1_ = g_strdup (property_name);
	_tmp2_ = _g_variant_ref0 (new_value);
	g_hash_table_replace (_tmp0_, _tmp1_, _tmp2_);
	if (self->priv->idle_id == ((guint) 0)) {
		self->priv->idle_id = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda6__gsource_func, g_object_ref (self), g_object_unref);
	}
}

static void
pomodoro_service_on_timer_property_notify (PomodoroService* self,
                                           GParamSpec* param_spec)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (param_spec != NULL);
	_tmp0_ = param_spec->name;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("elapsed")))) {
		switch (0) {
			default:
			{
				gdouble _tmp4_;
				gdouble _tmp5_;
				GVariant* _tmp6_;
				GVariant* _tmp7_;
				_tmp4_ = pomodoro_service_get_elapsed (self);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_variant_new_double (_tmp5_);
				g_variant_ref_sink (_tmp6_);
				_tmp7_ = _tmp6_;
				pomodoro_service_send_property_changed (self, "Elapsed", _tmp7_);
				_g_variant_unref0 (_tmp7_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("state")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				GVariant* _tmp10_;
				GVariant* _tmp11_;
				gdouble _tmp12_;
				gdouble _tmp13_;
				GVariant* _tmp14_;
				GVariant* _tmp15_;
				_tmp8_ = pomodoro_service_get_state (self);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_variant_new_string (_tmp9_);
				g_variant_ref_sink (_tmp10_);
				_tmp11_ = _tmp10_;
				pomodoro_service_send_property_changed (self, "State", _tmp11_);
				_g_variant_unref0 (_tmp11_);
				_tmp12_ = pomodoro_service_get_state_duration (self);
				_tmp13_ = _tmp12_;
				_tmp14_ = g_variant_new_double (_tmp13_);
				g_variant_ref_sink (_tmp14_);
				_tmp15_ = _tmp14_;
				pomodoro_service_send_property_changed (self, "StateDuration", _tmp15_);
				_g_variant_unref0 (_tmp15_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("state-duration")))) {
		switch (0) {
			default:
			{
				gdouble _tmp16_;
				gdouble _tmp17_;
				GVariant* _tmp18_;
				GVariant* _tmp19_;
				_tmp16_ = pomodoro_service_get_state_duration (self);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_variant_new_double (_tmp17_);
				g_variant_ref_sink (_tmp18_);
				_tmp19_ = _tmp18_;
				pomodoro_service_send_property_changed (self, "StateDuration", _tmp19_);
				_g_variant_unref0 (_tmp19_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("is-paused")))) {
		switch (0) {
			default:
			{
				gboolean _tmp20_;
				gboolean _tmp21_;
				GVariant* _tmp22_;
				GVariant* _tmp23_;
				_tmp20_ = pomodoro_service_get_is_paused (self);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_variant_new_boolean (_tmp21_);
				g_variant_ref_sink (_tmp22_);
				_tmp23_ = _tmp22_;
				pomodoro_service_send_property_changed (self, "IsPaused", _tmp23_);
				_g_variant_unref0 (_tmp23_);
				break;
			}
		}
	}
}

static GHashTable*
pomodoro_service_serialize_timer_state (PomodoroTimerState* state)
{
	GHashTable* serialized = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GVariant* _tmp6_;
	gchar* _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	GVariant* _tmp10_;
	gchar* _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	GVariant* _tmp14_;
	gchar* _tmp15_;
	gdouble _tmp16_;
	gdouble _tmp17_;
	GVariant* _tmp18_;
	GHashTable* result;
	g_return_val_if_fail (state != NULL, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_variant_unref0_);
	serialized = _tmp2_;
	_tmp3_ = g_strdup ("name");
	_tmp4_ = pomodoro_timer_state_get_name (state);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_variant_new_string (_tmp5_);
	g_variant_ref_sink (_tmp6_);
	g_hash_table_insert (serialized, _tmp3_, _tmp6_);
	_tmp7_ = g_strdup ("elapsed");
	_tmp8_ = pomodoro_timer_state_get_elapsed (state);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_variant_new_double (_tmp9_);
	g_variant_ref_sink (_tmp10_);
	g_hash_table_insert (serialized, _tmp7_, _tmp10_);
	_tmp11_ = g_strdup ("duration");
	_tmp12_ = pomodoro_timer_state_get_duration (state);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_variant_new_double (_tmp13_);
	g_variant_ref_sink (_tmp14_);
	g_hash_table_insert (serialized, _tmp11_, _tmp14_);
	_tmp15_ = g_strdup ("timestamp");
	_tmp16_ = pomodoro_timer_state_get_timestamp (state);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_variant_new_double (_tmp17_);
	g_variant_ref_sink (_tmp18_);
	g_hash_table_insert (serialized, _tmp15_, _tmp18_);
	result = serialized;
	return result;
}

static void
pomodoro_service_on_timer_state_changed (PomodoroService* self,
                                         PomodoroTimerState* state,
                                         PomodoroTimerState* previous_state)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (state != NULL);
	g_return_if_fail (previous_state != NULL);
	_tmp0_ = pomodoro_service_serialize_timer_state (state);
	_tmp1_ = _tmp0_;
	_tmp2_ = pomodoro_service_serialize_timer_state (previous_state);
	_tmp3_ = _tmp2_;
	g_signal_emit (self, pomodoro_service_signals[POMODORO_SERVICE_STATE_CHANGED_SIGNAL], 0, _tmp1_, _tmp3_);
	_g_hash_table_unref0 (_tmp3_);
	_g_hash_table_unref0 (_tmp1_);
}

gdouble
pomodoro_service_get_elapsed (PomodoroService* self)
{
	gdouble result;
	PomodoroTimer* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->timer;
	_tmp1_ = pomodoro_timer_get_elapsed (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

const gchar*
pomodoro_service_get_state (PomodoroService* self)
{
	const gchar* result;
	PomodoroTimer* _tmp0_;
	PomodoroTimerState* _tmp1_;
	PomodoroTimerState* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->timer;
	_tmp1_ = pomodoro_timer_get_state (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = pomodoro_timer_state_get_name (_tmp2_);
	_tmp4_ = _tmp3_;
	result = _tmp4_;
	return result;
}

gdouble
pomodoro_service_get_state_duration (PomodoroService* self)
{
	gdouble result;
	PomodoroTimer* _tmp0_;
	PomodoroTimerState* _tmp1_;
	PomodoroTimerState* _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->timer;
	_tmp1_ = pomodoro_timer_get_state (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = pomodoro_timer_state_get_duration (_tmp2_);
	_tmp4_ = _tmp3_;
	result = _tmp4_;
	return result;
}

gboolean
pomodoro_service_get_is_paused (PomodoroService* self)
{
	gboolean result;
	PomodoroTimer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->timer;
	_tmp1_ = pomodoro_timer_get_is_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

const gchar*
pomodoro_service_get_version (PomodoroService* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = PACKAGE_VERSION;
	return result;
}

static void
g_cclosure_user_marshal_VOID__BOXED_BOXED (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__BOXED_BOXED) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOXED_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), g_value_get_boxed (param_values + 2), data2);
}

static void
pomodoro_service_class_init (PomodoroServiceClass * klass,
                             gpointer klass_data)
{
	pomodoro_service_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PomodoroService_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pomodoro_service_get_property;
	G_OBJECT_CLASS (klass)->finalize = pomodoro_service_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_SERVICE_ELAPSED_PROPERTY, pomodoro_service_properties[POMODORO_SERVICE_ELAPSED_PROPERTY] = g_param_spec_double ("elapsed", "elapsed", "elapsed", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_SERVICE_STATE_PROPERTY, pomodoro_service_properties[POMODORO_SERVICE_STATE_PROPERTY] = g_param_spec_string ("state", "state", "state", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_SERVICE_STATE_DURATION_PROPERTY, pomodoro_service_properties[POMODORO_SERVICE_STATE_DURATION_PROPERTY] = g_param_spec_double ("state-duration", "state-duration", "state-duration", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_SERVICE_IS_PAUSED_PROPERTY, pomodoro_service_properties[POMODORO_SERVICE_IS_PAUSED_PROPERTY] = g_param_spec_boolean ("is-paused", "is-paused", "is-paused", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POMODORO_SERVICE_VERSION_PROPERTY, pomodoro_service_properties[POMODORO_SERVICE_VERSION_PROPERTY] = g_param_spec_string ("version", "version", "version", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	pomodoro_service_signals[POMODORO_SERVICE_STATE_CHANGED_SIGNAL] = g_signal_new ("state-changed", POMODORO_TYPE_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED_BOXED, G_TYPE_NONE, 2, G_TYPE_HASH_TABLE, G_TYPE_HASH_TABLE);
}

static void
pomodoro_service_instance_init (PomodoroService * self,
                                gpointer klass)
{
	self->priv = pomodoro_service_get_instance_private (self);
}

static void
pomodoro_service_finalize (GObject * obj)
{
	PomodoroService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POMODORO_TYPE_SERVICE, PomodoroService);
	_g_object_unref0 (self->priv->timer);
	_g_hash_table_unref0 (self->priv->changed_properties);
	_g_object_unref0 (self->priv->cancellable);
	G_OBJECT_CLASS (pomodoro_service_parent_class)->finalize (obj);
}

static GType
pomodoro_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PomodoroServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pomodoro_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PomodoroService), 0, (GInstanceInitFunc) pomodoro_service_instance_init, NULL };
	GType pomodoro_service_type_id;
	pomodoro_service_type_id = g_type_register_static (G_TYPE_OBJECT, "PomodoroService", &g_define_type_info, 0);
	g_type_set_qdata (pomodoro_service_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) pomodoro_service_register_object);
	PomodoroService_private_offset = g_type_add_instance_private (pomodoro_service_type_id, sizeof (PomodoroServicePrivate));
	return pomodoro_service_type_id;
}

GType
pomodoro_service_get_type (void)
{
	static volatile gsize pomodoro_service_type_id__once = 0;
	if (g_once_init_enter (&pomodoro_service_type_id__once)) {
		GType pomodoro_service_type_id;
		pomodoro_service_type_id = pomodoro_service_get_type_once ();
		g_once_init_leave (&pomodoro_service_type_id__once, pomodoro_service_type_id);
	}
	return pomodoro_service_type_id__once;
}

static void
_vala_pomodoro_service_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	PomodoroService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POMODORO_TYPE_SERVICE, PomodoroService);
	switch (property_id) {
		case POMODORO_SERVICE_ELAPSED_PROPERTY:
		g_value_set_double (value, pomodoro_service_get_elapsed (self));
		break;
		case POMODORO_SERVICE_STATE_PROPERTY:
		g_value_set_string (value, pomodoro_service_get_state (self));
		break;
		case POMODORO_SERVICE_STATE_DURATION_PROPERTY:
		g_value_set_double (value, pomodoro_service_get_state_duration (self));
		break;
		case POMODORO_SERVICE_IS_PAUSED_PROPERTY:
		g_value_set_boolean (value, pomodoro_service_get_is_paused (self));
		break;
		case POMODORO_SERVICE_VERSION_PROPERTY:
		g_value_set_string (value, pomodoro_service_get_version (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_dbus_pomodoro_service_set_state (PomodoroService* self,
                                  GVariant* _parameters_,
                                  GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* name = NULL;
	GVariant* _tmp13_;
	gdouble timestamp = 0.0;
	GVariant* _tmp14_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp13_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp13_, NULL);
	g_variant_unref (_tmp13_);
	_tmp14_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_double (_tmp14_);
	g_variant_unref (_tmp14_);
	pomodoro_service_set_state (self, name, timestamp, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (name);
	;
}

static void
_dbus_pomodoro_service_set_state_duration (PomodoroService* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* name = NULL;
	GVariant* _tmp15_;
	gdouble duration = 0.0;
	GVariant* _tmp16_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp15_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp15_, NULL);
	g_variant_unref (_tmp15_);
	_tmp16_ = g_variant_iter_next_value (&_arguments_iter);
	duration = g_variant_get_double (_tmp16_);
	g_variant_unref (_tmp16_);
	pomodoro_service_set_state_duration (self, name, duration, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (name);
	;
}

static void
_dbus_pomodoro_service_show_main_window (PomodoroService* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* mode = NULL;
	GVariant* _tmp17_;
	guint32 timestamp = 0U;
	GVariant* _tmp18_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp17_ = g_variant_iter_next_value (&_arguments_iter);
	mode = g_variant_dup_string (_tmp17_, NULL);
	g_variant_unref (_tmp17_);
	_tmp18_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_uint32 (_tmp18_);
	g_variant_unref (_tmp18_);
	pomodoro_service_show_main_window (self, mode, timestamp, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (mode);
	;
}

static void
_dbus_pomodoro_service_show_preferences (PomodoroService* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 timestamp = 0U;
	GVariant* _tmp19_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp19_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_uint32 (_tmp19_);
	g_variant_unref (_tmp19_);
	pomodoro_service_show_preferences (self, timestamp, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_pomodoro_service_start (PomodoroService* self,
                              GVariant* _parameters_,
                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	pomodoro_service_start (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_pomodoro_service_stop (PomodoroService* self,
                             GVariant* _parameters_,
                             GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	pomodoro_service_stop (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_pomodoro_service_reset (PomodoroService* self,
                              GVariant* _parameters_,
                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	pomodoro_service_reset (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_pomodoro_service_pause (PomodoroService* self,
                              GVariant* _parameters_,
                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	pomodoro_service_pause (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_pomodoro_service_resume (PomodoroService* self,
                               GVariant* _parameters_,
                               GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	pomodoro_service_resume (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_pomodoro_service_skip (PomodoroService* self,
                             GVariant* _parameters_,
                             GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	pomodoro_service_skip (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_pomodoro_service_quit (PomodoroService* self,
                             GVariant* _parameters_,
                             GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	pomodoro_service_quit (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
pomodoro_service_dbus_interface_method_call (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* method_name,
                                             GVariant* parameters,
                                             GDBusMethodInvocation* invocation,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "SetState") == 0) {
		_dbus_pomodoro_service_set_state (object, parameters, invocation);
	} else if (strcmp (method_name, "SetStateDuration") == 0) {
		_dbus_pomodoro_service_set_state_duration (object, parameters, invocation);
	} else if (strcmp (method_name, "ShowMainWindow") == 0) {
		_dbus_pomodoro_service_show_main_window (object, parameters, invocation);
	} else if (strcmp (method_name, "ShowPreferences") == 0) {
		_dbus_pomodoro_service_show_preferences (object, parameters, invocation);
	} else if (strcmp (method_name, "Start") == 0) {
		_dbus_pomodoro_service_start (object, parameters, invocation);
	} else if (strcmp (method_name, "Stop") == 0) {
		_dbus_pomodoro_service_stop (object, parameters, invocation);
	} else if (strcmp (method_name, "Reset") == 0) {
		_dbus_pomodoro_service_reset (object, parameters, invocation);
	} else if (strcmp (method_name, "Pause") == 0) {
		_dbus_pomodoro_service_pause (object, parameters, invocation);
	} else if (strcmp (method_name, "Resume") == 0) {
		_dbus_pomodoro_service_resume (object, parameters, invocation);
	} else if (strcmp (method_name, "Skip") == 0) {
		_dbus_pomodoro_service_skip (object, parameters, invocation);
	} else if (strcmp (method_name, "Quit") == 0) {
		_dbus_pomodoro_service_quit (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_pomodoro_service_get_elapsed (PomodoroService* self)
{
	gdouble result;
	GVariant* _reply;
	result = pomodoro_service_get_elapsed (self);
	_reply = g_variant_new_double (result);
	return _reply;
}

static GVariant*
_dbus_pomodoro_service_get_state (PomodoroService* self)
{
	const gchar* result;
	GVariant* _reply;
	result = pomodoro_service_get_state (self);
	_reply = g_variant_new_string (result);
	return _reply;
}

static GVariant*
_dbus_pomodoro_service_get_state_duration (PomodoroService* self)
{
	gdouble result;
	GVariant* _reply;
	result = pomodoro_service_get_state_duration (self);
	_reply = g_variant_new_double (result);
	return _reply;
}

static GVariant*
_dbus_pomodoro_service_get_is_paused (PomodoroService* self)
{
	gboolean result;
	GVariant* _reply;
	result = pomodoro_service_get_is_paused (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_pomodoro_service_get_version (PomodoroService* self)
{
	const gchar* result;
	GVariant* _reply;
	result = pomodoro_service_get_version (self);
	_reply = g_variant_new_string (result);
	return _reply;
}

static GVariant*
pomodoro_service_dbus_interface_get_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GError** error,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Elapsed") == 0) {
		return _dbus_pomodoro_service_get_elapsed (object);
	} else if (strcmp (property_name, "State") == 0) {
		return _dbus_pomodoro_service_get_state (object);
	} else if (strcmp (property_name, "StateDuration") == 0) {
		return _dbus_pomodoro_service_get_state_duration (object);
	} else if (strcmp (property_name, "IsPaused") == 0) {
		return _dbus_pomodoro_service_get_is_paused (object);
	} else if (strcmp (property_name, "Version") == 0) {
		return _dbus_pomodoro_service_get_version (object);
	}
	return NULL;
}

static gboolean
pomodoro_service_dbus_interface_set_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GVariant* value,
                                              GError** error,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_pomodoro_service_state_changed (GObject* _sender,
                                      GHashTable* state,
                                      GHashTable* previous_state,
                                      gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp20_;
	GHashTableIter _tmp21_;
	gpointer _tmp22_;
	gpointer _tmp23_;
	GVariantBuilder _tmp24_;
	GHashTableIter _tmp25_;
	gpointer _tmp26_;
	gpointer _tmp27_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_hash_table_iter_init (&_tmp21_, state);
	g_variant_builder_init (&_tmp20_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp21_, &_tmp22_, &_tmp23_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp22_;
		_value = (GVariant*) _tmp23_;
		g_variant_builder_add (&_tmp20_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp20_));
	g_hash_table_iter_init (&_tmp25_, previous_state);
	g_variant_builder_init (&_tmp24_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp25_, &_tmp26_, &_tmp27_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp26_;
		_value = (GVariant*) _tmp27_;
		g_variant_builder_add (&_tmp24_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp24_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.Pomodoro", "StateChanged", _arguments, NULL);
}

guint
pomodoro_service_register_object (gpointer object,
                                  GDBusConnection* connection,
                                  const gchar* path,
                                  GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_pomodoro_service_dbus_interface_info), &_pomodoro_service_dbus_interface_vtable, data, _pomodoro_service_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "state-changed", (GCallback) _dbus_pomodoro_service_state_changed, data);
	return result;
}

static void
_pomodoro_service_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pomodoro_service_state_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

