#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1272
#define LARGE_STATE_COUNT 162
#define SYMBOL_COUNT 248
#define ALIAS_COUNT 4
#define TOKEN_COUNT 111
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 29
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 147

enum ts_symbol_identifiers {
  sym_identifier = 1,
  anon_sym_import = 2,
  anon_sym_DOT = 3,
  anon_sym_LPAREN = 4,
  anon_sym_COMMA = 5,
  anon_sym_RPAREN = 6,
  anon_sym_as = 7,
  anon_sym_if = 8,
  anon_sym_and = 9,
  anon_sym_extern = 10,
  anon_sym_DQUOTE = 11,
  aux_sym_extern_import_path_token1 = 12,
  anon_sym_fn = 13,
  aux_sym_method_name_token1 = 14,
  anon_sym_PLUS = 15,
  anon_sym_DASH = 16,
  anon_sym_SLASH = 17,
  anon_sym_STAR = 18,
  anon_sym_STAR_STAR = 19,
  anon_sym_PERCENT = 20,
  anon_sym_LT = 21,
  anon_sym_GT = 22,
  anon_sym_LT_EQ = 23,
  anon_sym_GT_EQ = 24,
  anon_sym_LT_LT = 25,
  anon_sym_GT_GT = 26,
  anon_sym_GT_GT_GT = 27,
  anon_sym_AMP = 28,
  anon_sym_PIPE = 29,
  anon_sym_CARET = 30,
  anon_sym_EQ_EQ = 31,
  anon_sym_BANG_EQ = 32,
  anon_sym_COLON = 33,
  sym_rest_argument = 34,
  anon_sym_DASH_GT = 35,
  anon_sym_LBRACK = 36,
  anon_sym_RBRACK = 37,
  anon_sym_mut = 38,
  anon_sym_move = 39,
  anon_sym_static = 40,
  anon_sym_async = 41,
  anon_sym_asyncmut = 42,
  anon_sym_inline = 43,
  anon_sym_inlinemut = 44,
  anon_sym_inlinemove = 45,
  anon_sym_inlinestatic = 46,
  anon_sym_inlineasync = 47,
  anon_sym_inlineasyncmut = 48,
  anon_sym_type = 49,
  anon_sym_builtin = 50,
  anon_sym_copy = 51,
  anon_sym_enum = 52,
  anon_sym_LBRACE = 53,
  anon_sym_RBRACE = 54,
  anon_sym_let = 55,
  anon_sym_case = 56,
  anon_sym_trait = 57,
  anon_sym_impl = 58,
  anon_sym_for = 59,
  anon_sym_ref = 60,
  anon_sym_uni = 61,
  anon_sym_EQ = 62,
  anon_sym_COLON_EQ = 63,
  anon_sym_PLUS_EQ = 64,
  anon_sym_DASH_EQ = 65,
  anon_sym_SLASH_EQ = 66,
  anon_sym_STAR_EQ = 67,
  anon_sym_STAR_STAR_EQ = 68,
  anon_sym_PERCENT_EQ = 69,
  anon_sym_LT_LT_EQ = 70,
  anon_sym_GT_GT_EQ = 71,
  anon_sym_GT_GT_GT_EQ = 72,
  anon_sym_AMP_EQ = 73,
  anon_sym_PIPE_EQ = 74,
  anon_sym_CARET_EQ = 75,
  anon_sym_LPAREN2 = 76,
  anon_sym_recover = 77,
  anon_sym_return = 78,
  aux_sym_return_token1 = 79,
  anon_sym_try = 80,
  anon_sym_throw = 81,
  anon_sym_else = 82,
  anon_sym_while = 83,
  anon_sym_loop = 84,
  anon_sym_in = 85,
  anon_sym_match = 86,
  sym_wildcard_pattern = 87,
  anon_sym_or = 88,
  anon_sym_true = 89,
  anon_sym_false = 90,
  sym_float = 91,
  sym_integer = 92,
  anon_sym_SQUOTE = 93,
  anon_sym_DOLLAR = 94,
  aux_sym_string_token1 = 95,
  aux_sym_string_token2 = 96,
  anon_sym_BSLASHu_LBRACE = 97,
  aux_sym_escape_sequence_token1 = 98,
  anon_sym_BSLASH_BSLASH = 99,
  aux_sym_escape_sequence_token2 = 100,
  anon_sym_DOLLAR_LBRACE = 101,
  sym_self = 102,
  sym_nil = 103,
  sym_break = 104,
  sym_next = 105,
  sym_visibility = 106,
  sym_line_comment = 107,
  sym_identifier_with_special = 108,
  sym_field = 109,
  sym_constant = 110,
  sym_source_file = 111,
  sym__root = 112,
  sym_import = 113,
  sym_path = 114,
  sym_symbols = 115,
  sym_import_as = 116,
  sym_tags = 117,
  sym_extern_import = 118,
  sym_extern_import_path = 119,
  sym_external_function = 120,
  sym_extern_arguments = 121,
  sym_module_method = 122,
  sym_method_name = 123,
  sym_method_arguments = 124,
  sym_argument = 125,
  sym__returns = 126,
  sym_type_parameters = 127,
  sym_type_parameter = 128,
  sym_type_parameter_requirements = 129,
  sym__type_parameter_requirement = 130,
  sym__method_modifier = 131,
  sym_class = 132,
  sym__class_modifier = 133,
  sym_class_body = 134,
  sym__class_expression = 135,
  sym_define_field = 136,
  sym_define_case = 137,
  sym_case_arguments = 138,
  sym_class_method = 139,
  sym_trait = 140,
  sym_trait_body = 141,
  sym_trait_method = 142,
  sym__trait_method_modifier = 143,
  sym_required_traits = 144,
  sym__required_trait = 145,
  sym_implement_trait = 146,
  sym_implement_trait_body = 147,
  sym_bounds = 148,
  sym_bound = 149,
  sym_bound_requirements = 150,
  sym_reopen_class = 151,
  sym_reopen_class_body = 152,
  sym__type = 153,
  sym_generic_type = 154,
  sym_type_arguments = 155,
  sym_ref_type = 156,
  sym_mut_type = 157,
  sym_uni_type = 158,
  sym_move_type = 159,
  sym_fn_type = 160,
  sym_fn_type_arguments = 161,
  sym_tuple_type = 162,
  sym_block = 163,
  sym__expression = 164,
  sym_assign_receiver_field = 165,
  sym_assign_local = 166,
  sym_assign_field = 167,
  sym_replace_local = 168,
  sym_replace_field = 169,
  sym_compound_assign_local = 170,
  sym_compound_assign_field = 171,
  sym_compound_assign_receiver_field = 172,
  sym__call_name = 173,
  sym_call = 174,
  sym_call_arguments = 175,
  sym__call_argument = 176,
  sym_named_argument = 177,
  sym_call_with_receiver = 178,
  sym_ref = 179,
  sym_mut = 180,
  sym_recover = 181,
  sym_grouped_expression = 182,
  sym_tuple = 183,
  sym_array = 184,
  sym_return = 185,
  sym_try = 186,
  sym_throw = 187,
  sym_if = 188,
  sym_else_if = 189,
  sym_else = 190,
  sym_while = 191,
  sym_loop = 192,
  sym_for = 193,
  sym_match = 194,
  sym_cases = 195,
  sym_case = 196,
  sym__pattern = 197,
  sym_mutable_pattern = 198,
  sym_tuple_pattern = 199,
  sym_enum_pattern = 200,
  sym_enum_pattern_arguments = 201,
  sym_class_pattern = 202,
  sym_field_pattern = 203,
  sym_or_pattern = 204,
  sym_boolean_pattern = 205,
  sym_namespaced_constant_pattern = 206,
  sym_closure = 207,
  sym_closure_arguments = 208,
  sym_closure_argument = 209,
  sym_define_constant = 210,
  sym_define_variable = 211,
  sym_and_or = 212,
  sym_binary = 213,
  sym_cast = 214,
  sym_string = 215,
  sym_escape_sequence = 216,
  sym_interpolation = 217,
  sym_true = 218,
  sym_false = 219,
  sym_mutable = 220,
  sym_inline = 221,
  sym_copy = 222,
  sym_move = 223,
  aux_sym_source_file_repeat1 = 224,
  aux_sym_path_repeat1 = 225,
  aux_sym_symbols_repeat1 = 226,
  aux_sym_tags_repeat1 = 227,
  aux_sym_extern_arguments_repeat1 = 228,
  aux_sym_type_parameters_repeat1 = 229,
  aux_sym_type_parameter_requirements_repeat1 = 230,
  aux_sym_class_body_repeat1 = 231,
  aux_sym_case_arguments_repeat1 = 232,
  aux_sym_trait_body_repeat1 = 233,
  aux_sym_required_traits_repeat1 = 234,
  aux_sym_implement_trait_body_repeat1 = 235,
  aux_sym_bounds_repeat1 = 236,
  aux_sym_block_repeat1 = 237,
  aux_sym_call_arguments_repeat1 = 238,
  aux_sym_tuple_repeat1 = 239,
  aux_sym_if_repeat1 = 240,
  aux_sym_cases_repeat1 = 241,
  aux_sym_tuple_pattern_repeat1 = 242,
  aux_sym_class_pattern_repeat1 = 243,
  aux_sym_or_pattern_repeat1 = 244,
  aux_sym_closure_arguments_repeat1 = 245,
  aux_sym_string_repeat1 = 246,
  aux_sym_string_repeat2 = 247,
  alias_sym_identifier_pattern = 248,
  alias_sym_integer_pattern = 249,
  alias_sym_string_pattern = 250,
  alias_sym_type = 251,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_import] = "import",
  [anon_sym_DOT] = ".",
  [anon_sym_LPAREN] = "(",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [anon_sym_as] = "as",
  [anon_sym_if] = "if",
  [anon_sym_and] = "and",
  [anon_sym_extern] = "extern",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_extern_import_path_token1] = "extern_import_path_token1",
  [anon_sym_fn] = "fn",
  [aux_sym_method_name_token1] = "method_name_token1",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_SLASH] = "/",
  [anon_sym_STAR] = "*",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_AMP] = "&",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_COLON] = ":",
  [sym_rest_argument] = "rest_argument",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_mut] = "mut",
  [anon_sym_move] = "move",
  [anon_sym_static] = "static",
  [anon_sym_async] = "async",
  [anon_sym_asyncmut] = "async mut",
  [anon_sym_inline] = "inline",
  [anon_sym_inlinemut] = "inline mut",
  [anon_sym_inlinemove] = "inline move",
  [anon_sym_inlinestatic] = "inline static",
  [anon_sym_inlineasync] = "inline async",
  [anon_sym_inlineasyncmut] = "inline async mut",
  [anon_sym_type] = "type",
  [anon_sym_builtin] = "builtin",
  [anon_sym_copy] = "copy",
  [anon_sym_enum] = "enum",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_let] = "let",
  [anon_sym_case] = "case",
  [anon_sym_trait] = "trait",
  [anon_sym_impl] = "impl",
  [anon_sym_for] = "for",
  [anon_sym_ref] = "ref",
  [anon_sym_uni] = "uni",
  [anon_sym_EQ] = "=",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_LPAREN2] = "(",
  [anon_sym_recover] = "recover",
  [anon_sym_return] = "return",
  [aux_sym_return_token1] = "return_token1",
  [anon_sym_try] = "try",
  [anon_sym_throw] = "throw",
  [anon_sym_else] = "else",
  [anon_sym_while] = "while",
  [anon_sym_loop] = "loop",
  [anon_sym_in] = "in",
  [anon_sym_match] = "match",
  [sym_wildcard_pattern] = "wildcard_pattern",
  [anon_sym_or] = "or",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [sym_float] = "float",
  [sym_integer] = "integer",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_DOLLAR] = "string_content",
  [aux_sym_string_token1] = "string_content",
  [aux_sym_string_token2] = "string_content",
  [anon_sym_BSLASHu_LBRACE] = "\\u{",
  [aux_sym_escape_sequence_token1] = "escape_sequence_token1",
  [anon_sym_BSLASH_BSLASH] = "\\\\",
  [aux_sym_escape_sequence_token2] = "escape_sequence_token2",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [sym_self] = "self",
  [sym_nil] = "nil",
  [sym_break] = "break",
  [sym_next] = "next",
  [sym_visibility] = "visibility",
  [sym_line_comment] = "line_comment",
  [sym_identifier_with_special] = "name",
  [sym_field] = "field",
  [sym_constant] = "constant",
  [sym_source_file] = "source_file",
  [sym__root] = "_root",
  [sym_import] = "import",
  [sym_path] = "path",
  [sym_symbols] = "symbols",
  [sym_import_as] = "import_as",
  [sym_tags] = "tags",
  [sym_extern_import] = "extern_import",
  [sym_extern_import_path] = "path",
  [sym_external_function] = "external_function",
  [sym_extern_arguments] = "arguments",
  [sym_module_method] = "method",
  [sym_method_name] = "identifier",
  [sym_method_arguments] = "arguments",
  [sym_argument] = "argument",
  [sym__returns] = "_returns",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_type_parameter_requirements] = "requirements",
  [sym__type_parameter_requirement] = "_type_parameter_requirement",
  [sym__method_modifier] = "modifier",
  [sym_class] = "class",
  [sym__class_modifier] = "modifier",
  [sym_class_body] = "class_body",
  [sym__class_expression] = "_class_expression",
  [sym_define_field] = "define_field",
  [sym_define_case] = "define_case",
  [sym_case_arguments] = "arguments",
  [sym_class_method] = "method",
  [sym_trait] = "trait",
  [sym_trait_body] = "trait_body",
  [sym_trait_method] = "method",
  [sym__trait_method_modifier] = "modifier",
  [sym_required_traits] = "required_traits",
  [sym__required_trait] = "_required_trait",
  [sym_implement_trait] = "implement_trait",
  [sym_implement_trait_body] = "implement_trait_body",
  [sym_bounds] = "bounds",
  [sym_bound] = "bound",
  [sym_bound_requirements] = "requirements",
  [sym_reopen_class] = "reopen_class",
  [sym_reopen_class_body] = "reopen_class_body",
  [sym__type] = "_type",
  [sym_generic_type] = "generic_type",
  [sym_type_arguments] = "type_arguments",
  [sym_ref_type] = "ref_type",
  [sym_mut_type] = "mut_type",
  [sym_uni_type] = "uni_type",
  [sym_move_type] = "move_type",
  [sym_fn_type] = "fn_type",
  [sym_fn_type_arguments] = "arguments",
  [sym_tuple_type] = "tuple_type",
  [sym_block] = "block",
  [sym__expression] = "_expression",
  [sym_assign_receiver_field] = "assign_receiver_field",
  [sym_assign_local] = "assign_local",
  [sym_assign_field] = "assign_field",
  [sym_replace_local] = "replace_local",
  [sym_replace_field] = "replace_field",
  [sym_compound_assign_local] = "compound_assign_local",
  [sym_compound_assign_field] = "compound_assign_field",
  [sym_compound_assign_receiver_field] = "compound_assign_receiver_field",
  [sym__call_name] = "_call_name",
  [sym_call] = "call",
  [sym_call_arguments] = "arguments",
  [sym__call_argument] = "_call_argument",
  [sym_named_argument] = "named_argument",
  [sym_call_with_receiver] = "call",
  [sym_ref] = "ref",
  [sym_mut] = "mut",
  [sym_recover] = "recover",
  [sym_grouped_expression] = "grouped_expression",
  [sym_tuple] = "tuple",
  [sym_array] = "array",
  [sym_return] = "return",
  [sym_try] = "try",
  [sym_throw] = "throw",
  [sym_if] = "if",
  [sym_else_if] = "else_if",
  [sym_else] = "else",
  [sym_while] = "while",
  [sym_loop] = "loop",
  [sym_for] = "for",
  [sym_match] = "match",
  [sym_cases] = "cases",
  [sym_case] = "case",
  [sym__pattern] = "_pattern",
  [sym_mutable_pattern] = "mutable_pattern",
  [sym_tuple_pattern] = "tuple_pattern",
  [sym_enum_pattern] = "enum_pattern",
  [sym_enum_pattern_arguments] = "arguments",
  [sym_class_pattern] = "class_pattern",
  [sym_field_pattern] = "field_pattern",
  [sym_or_pattern] = "or_pattern",
  [sym_boolean_pattern] = "boolean_pattern",
  [sym_namespaced_constant_pattern] = "constant_pattern",
  [sym_closure] = "closure",
  [sym_closure_arguments] = "arguments",
  [sym_closure_argument] = "argument",
  [sym_define_constant] = "define_constant",
  [sym_define_variable] = "define_variable",
  [sym_and_or] = "binary",
  [sym_binary] = "binary",
  [sym_cast] = "cast",
  [sym_string] = "string",
  [sym_escape_sequence] = "escape_sequence",
  [sym_interpolation] = "interpolation",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_mutable] = "mutable",
  [sym_inline] = "modifier",
  [sym_copy] = "copy",
  [sym_move] = "modifier",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_path_repeat1] = "path_repeat1",
  [aux_sym_symbols_repeat1] = "symbols_repeat1",
  [aux_sym_tags_repeat1] = "tags_repeat1",
  [aux_sym_extern_arguments_repeat1] = "extern_arguments_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_type_parameter_requirements_repeat1] = "type_parameter_requirements_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_case_arguments_repeat1] = "case_arguments_repeat1",
  [aux_sym_trait_body_repeat1] = "trait_body_repeat1",
  [aux_sym_required_traits_repeat1] = "required_traits_repeat1",
  [aux_sym_implement_trait_body_repeat1] = "implement_trait_body_repeat1",
  [aux_sym_bounds_repeat1] = "bounds_repeat1",
  [aux_sym_block_repeat1] = "block_repeat1",
  [aux_sym_call_arguments_repeat1] = "call_arguments_repeat1",
  [aux_sym_tuple_repeat1] = "tuple_repeat1",
  [aux_sym_if_repeat1] = "if_repeat1",
  [aux_sym_cases_repeat1] = "cases_repeat1",
  [aux_sym_tuple_pattern_repeat1] = "tuple_pattern_repeat1",
  [aux_sym_class_pattern_repeat1] = "class_pattern_repeat1",
  [aux_sym_or_pattern_repeat1] = "or_pattern_repeat1",
  [aux_sym_closure_arguments_repeat1] = "closure_arguments_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [alias_sym_identifier_pattern] = "identifier_pattern",
  [alias_sym_integer_pattern] = "integer_pattern",
  [alias_sym_string_pattern] = "string_pattern",
  [alias_sym_type] = "type",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_extern] = anon_sym_extern,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_extern_import_path_token1] = aux_sym_extern_import_path_token1,
  [anon_sym_fn] = anon_sym_fn,
  [aux_sym_method_name_token1] = aux_sym_method_name_token1,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_COLON] = anon_sym_COLON,
  [sym_rest_argument] = sym_rest_argument,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_mut] = anon_sym_mut,
  [anon_sym_move] = anon_sym_move,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_asyncmut] = anon_sym_asyncmut,
  [anon_sym_inline] = anon_sym_inline,
  [anon_sym_inlinemut] = anon_sym_inlinemut,
  [anon_sym_inlinemove] = anon_sym_inlinemove,
  [anon_sym_inlinestatic] = anon_sym_inlinestatic,
  [anon_sym_inlineasync] = anon_sym_inlineasync,
  [anon_sym_inlineasyncmut] = anon_sym_inlineasyncmut,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_builtin] = anon_sym_builtin,
  [anon_sym_copy] = anon_sym_copy,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_trait] = anon_sym_trait,
  [anon_sym_impl] = anon_sym_impl,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_ref] = anon_sym_ref,
  [anon_sym_uni] = anon_sym_uni,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_LPAREN2] = anon_sym_LPAREN,
  [anon_sym_recover] = anon_sym_recover,
  [anon_sym_return] = anon_sym_return,
  [aux_sym_return_token1] = aux_sym_return_token1,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_loop] = anon_sym_loop,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_match] = anon_sym_match,
  [sym_wildcard_pattern] = sym_wildcard_pattern,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [sym_float] = sym_float,
  [sym_integer] = sym_integer,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [aux_sym_string_token1] = anon_sym_DOLLAR,
  [aux_sym_string_token2] = anon_sym_DOLLAR,
  [anon_sym_BSLASHu_LBRACE] = anon_sym_BSLASHu_LBRACE,
  [aux_sym_escape_sequence_token1] = aux_sym_escape_sequence_token1,
  [anon_sym_BSLASH_BSLASH] = anon_sym_BSLASH_BSLASH,
  [aux_sym_escape_sequence_token2] = aux_sym_escape_sequence_token2,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [sym_self] = sym_self,
  [sym_nil] = sym_nil,
  [sym_break] = sym_break,
  [sym_next] = sym_next,
  [sym_visibility] = sym_visibility,
  [sym_line_comment] = sym_line_comment,
  [sym_identifier_with_special] = sym_identifier_with_special,
  [sym_field] = sym_field,
  [sym_constant] = sym_constant,
  [sym_source_file] = sym_source_file,
  [sym__root] = sym__root,
  [sym_import] = sym_import,
  [sym_path] = sym_path,
  [sym_symbols] = sym_symbols,
  [sym_import_as] = sym_import_as,
  [sym_tags] = sym_tags,
  [sym_extern_import] = sym_extern_import,
  [sym_extern_import_path] = sym_path,
  [sym_external_function] = sym_external_function,
  [sym_extern_arguments] = sym_extern_arguments,
  [sym_module_method] = sym_module_method,
  [sym_method_name] = sym_identifier,
  [sym_method_arguments] = sym_extern_arguments,
  [sym_argument] = sym_argument,
  [sym__returns] = sym__returns,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_type_parameter_requirements] = sym_type_parameter_requirements,
  [sym__type_parameter_requirement] = sym__type_parameter_requirement,
  [sym__method_modifier] = sym__method_modifier,
  [sym_class] = sym_class,
  [sym__class_modifier] = sym__method_modifier,
  [sym_class_body] = sym_class_body,
  [sym__class_expression] = sym__class_expression,
  [sym_define_field] = sym_define_field,
  [sym_define_case] = sym_define_case,
  [sym_case_arguments] = sym_extern_arguments,
  [sym_class_method] = sym_module_method,
  [sym_trait] = sym_trait,
  [sym_trait_body] = sym_trait_body,
  [sym_trait_method] = sym_module_method,
  [sym__trait_method_modifier] = sym__method_modifier,
  [sym_required_traits] = sym_required_traits,
  [sym__required_trait] = sym__required_trait,
  [sym_implement_trait] = sym_implement_trait,
  [sym_implement_trait_body] = sym_implement_trait_body,
  [sym_bounds] = sym_bounds,
  [sym_bound] = sym_bound,
  [sym_bound_requirements] = sym_type_parameter_requirements,
  [sym_reopen_class] = sym_reopen_class,
  [sym_reopen_class_body] = sym_reopen_class_body,
  [sym__type] = sym__type,
  [sym_generic_type] = sym_generic_type,
  [sym_type_arguments] = sym_type_arguments,
  [sym_ref_type] = sym_ref_type,
  [sym_mut_type] = sym_mut_type,
  [sym_uni_type] = sym_uni_type,
  [sym_move_type] = sym_move_type,
  [sym_fn_type] = sym_fn_type,
  [sym_fn_type_arguments] = sym_extern_arguments,
  [sym_tuple_type] = sym_tuple_type,
  [sym_block] = sym_block,
  [sym__expression] = sym__expression,
  [sym_assign_receiver_field] = sym_assign_receiver_field,
  [sym_assign_local] = sym_assign_local,
  [sym_assign_field] = sym_assign_field,
  [sym_replace_local] = sym_replace_local,
  [sym_replace_field] = sym_replace_field,
  [sym_compound_assign_local] = sym_compound_assign_local,
  [sym_compound_assign_field] = sym_compound_assign_field,
  [sym_compound_assign_receiver_field] = sym_compound_assign_receiver_field,
  [sym__call_name] = sym__call_name,
  [sym_call] = sym_call,
  [sym_call_arguments] = sym_extern_arguments,
  [sym__call_argument] = sym__call_argument,
  [sym_named_argument] = sym_named_argument,
  [sym_call_with_receiver] = sym_call,
  [sym_ref] = sym_ref,
  [sym_mut] = sym_mut,
  [sym_recover] = sym_recover,
  [sym_grouped_expression] = sym_grouped_expression,
  [sym_tuple] = sym_tuple,
  [sym_array] = sym_array,
  [sym_return] = sym_return,
  [sym_try] = sym_try,
  [sym_throw] = sym_throw,
  [sym_if] = sym_if,
  [sym_else_if] = sym_else_if,
  [sym_else] = sym_else,
  [sym_while] = sym_while,
  [sym_loop] = sym_loop,
  [sym_for] = sym_for,
  [sym_match] = sym_match,
  [sym_cases] = sym_cases,
  [sym_case] = sym_case,
  [sym__pattern] = sym__pattern,
  [sym_mutable_pattern] = sym_mutable_pattern,
  [sym_tuple_pattern] = sym_tuple_pattern,
  [sym_enum_pattern] = sym_enum_pattern,
  [sym_enum_pattern_arguments] = sym_extern_arguments,
  [sym_class_pattern] = sym_class_pattern,
  [sym_field_pattern] = sym_field_pattern,
  [sym_or_pattern] = sym_or_pattern,
  [sym_boolean_pattern] = sym_boolean_pattern,
  [sym_namespaced_constant_pattern] = sym_namespaced_constant_pattern,
  [sym_closure] = sym_closure,
  [sym_closure_arguments] = sym_extern_arguments,
  [sym_closure_argument] = sym_argument,
  [sym_define_constant] = sym_define_constant,
  [sym_define_variable] = sym_define_variable,
  [sym_and_or] = sym_binary,
  [sym_binary] = sym_binary,
  [sym_cast] = sym_cast,
  [sym_string] = sym_string,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_interpolation] = sym_interpolation,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_mutable] = sym_mutable,
  [sym_inline] = sym__method_modifier,
  [sym_copy] = sym_copy,
  [sym_move] = sym__method_modifier,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_path_repeat1] = aux_sym_path_repeat1,
  [aux_sym_symbols_repeat1] = aux_sym_symbols_repeat1,
  [aux_sym_tags_repeat1] = aux_sym_tags_repeat1,
  [aux_sym_extern_arguments_repeat1] = aux_sym_extern_arguments_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_type_parameter_requirements_repeat1] = aux_sym_type_parameter_requirements_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_case_arguments_repeat1] = aux_sym_case_arguments_repeat1,
  [aux_sym_trait_body_repeat1] = aux_sym_trait_body_repeat1,
  [aux_sym_required_traits_repeat1] = aux_sym_required_traits_repeat1,
  [aux_sym_implement_trait_body_repeat1] = aux_sym_implement_trait_body_repeat1,
  [aux_sym_bounds_repeat1] = aux_sym_bounds_repeat1,
  [aux_sym_block_repeat1] = aux_sym_block_repeat1,
  [aux_sym_call_arguments_repeat1] = aux_sym_call_arguments_repeat1,
  [aux_sym_tuple_repeat1] = aux_sym_tuple_repeat1,
  [aux_sym_if_repeat1] = aux_sym_if_repeat1,
  [aux_sym_cases_repeat1] = aux_sym_cases_repeat1,
  [aux_sym_tuple_pattern_repeat1] = aux_sym_tuple_pattern_repeat1,
  [aux_sym_class_pattern_repeat1] = aux_sym_class_pattern_repeat1,
  [aux_sym_or_pattern_repeat1] = aux_sym_or_pattern_repeat1,
  [aux_sym_closure_arguments_repeat1] = aux_sym_closure_arguments_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [alias_sym_identifier_pattern] = alias_sym_identifier_pattern,
  [alias_sym_integer_pattern] = alias_sym_integer_pattern,
  [alias_sym_string_pattern] = alias_sym_string_pattern,
  [alias_sym_type] = alias_sym_type,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extern] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_extern_import_path_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_fn] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_method_name_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_rest_argument] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mut] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_move] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_asyncmut] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inline] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inlinemut] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inlinemove] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inlinestatic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inlineasync] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inlineasyncmut] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_builtin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_copy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_trait] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_impl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uni] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_recover] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_return_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_loop] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_match] = {
    .visible = true,
    .named = false,
  },
  [sym_wildcard_pattern] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_string_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_string_token2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHu_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_escape_sequence_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_BSLASH_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_escape_sequence_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym_self] = {
    .visible = true,
    .named = true,
  },
  [sym_nil] = {
    .visible = true,
    .named = true,
  },
  [sym_break] = {
    .visible = true,
    .named = true,
  },
  [sym_next] = {
    .visible = true,
    .named = true,
  },
  [sym_visibility] = {
    .visible = true,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier_with_special] = {
    .visible = true,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym_constant] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__root] = {
    .visible = false,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_path] = {
    .visible = true,
    .named = true,
  },
  [sym_symbols] = {
    .visible = true,
    .named = true,
  },
  [sym_import_as] = {
    .visible = true,
    .named = true,
  },
  [sym_tags] = {
    .visible = true,
    .named = true,
  },
  [sym_extern_import] = {
    .visible = true,
    .named = true,
  },
  [sym_extern_import_path] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function] = {
    .visible = true,
    .named = true,
  },
  [sym_extern_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_module_method] = {
    .visible = true,
    .named = true,
  },
  [sym_method_name] = {
    .visible = true,
    .named = true,
  },
  [sym_method_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__returns] = {
    .visible = false,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter_requirements] = {
    .visible = true,
    .named = true,
  },
  [sym__type_parameter_requirement] = {
    .visible = false,
    .named = true,
  },
  [sym__method_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym__class_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym__class_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_define_field] = {
    .visible = true,
    .named = true,
  },
  [sym_define_case] = {
    .visible = true,
    .named = true,
  },
  [sym_case_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_class_method] = {
    .visible = true,
    .named = true,
  },
  [sym_trait] = {
    .visible = true,
    .named = true,
  },
  [sym_trait_body] = {
    .visible = true,
    .named = true,
  },
  [sym_trait_method] = {
    .visible = true,
    .named = true,
  },
  [sym__trait_method_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_required_traits] = {
    .visible = true,
    .named = true,
  },
  [sym__required_trait] = {
    .visible = false,
    .named = true,
  },
  [sym_implement_trait] = {
    .visible = true,
    .named = true,
  },
  [sym_implement_trait_body] = {
    .visible = true,
    .named = true,
  },
  [sym_bounds] = {
    .visible = true,
    .named = true,
  },
  [sym_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_requirements] = {
    .visible = true,
    .named = true,
  },
  [sym_reopen_class] = {
    .visible = true,
    .named = true,
  },
  [sym_reopen_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_ref_type] = {
    .visible = true,
    .named = true,
  },
  [sym_mut_type] = {
    .visible = true,
    .named = true,
  },
  [sym_uni_type] = {
    .visible = true,
    .named = true,
  },
  [sym_move_type] = {
    .visible = true,
    .named = true,
  },
  [sym_fn_type] = {
    .visible = true,
    .named = true,
  },
  [sym_fn_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_assign_receiver_field] = {
    .visible = true,
    .named = true,
  },
  [sym_assign_local] = {
    .visible = true,
    .named = true,
  },
  [sym_assign_field] = {
    .visible = true,
    .named = true,
  },
  [sym_replace_local] = {
    .visible = true,
    .named = true,
  },
  [sym_replace_field] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_assign_local] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_assign_field] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_assign_receiver_field] = {
    .visible = true,
    .named = true,
  },
  [sym__call_name] = {
    .visible = false,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym_call_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym__call_argument] = {
    .visible = false,
    .named = true,
  },
  [sym_named_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_call_with_receiver] = {
    .visible = true,
    .named = true,
  },
  [sym_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_mut] = {
    .visible = true,
    .named = true,
  },
  [sym_recover] = {
    .visible = true,
    .named = true,
  },
  [sym_grouped_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_return] = {
    .visible = true,
    .named = true,
  },
  [sym_try] = {
    .visible = true,
    .named = true,
  },
  [sym_throw] = {
    .visible = true,
    .named = true,
  },
  [sym_if] = {
    .visible = true,
    .named = true,
  },
  [sym_else_if] = {
    .visible = true,
    .named = true,
  },
  [sym_else] = {
    .visible = true,
    .named = true,
  },
  [sym_while] = {
    .visible = true,
    .named = true,
  },
  [sym_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_for] = {
    .visible = true,
    .named = true,
  },
  [sym_match] = {
    .visible = true,
    .named = true,
  },
  [sym_cases] = {
    .visible = true,
    .named = true,
  },
  [sym_case] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_mutable_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_pattern_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_class_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_field_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_or_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_namespaced_constant_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_closure] = {
    .visible = true,
    .named = true,
  },
  [sym_closure_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_closure_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_define_constant] = {
    .visible = true,
    .named = true,
  },
  [sym_define_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_and_or] = {
    .visible = true,
    .named = true,
  },
  [sym_binary] = {
    .visible = true,
    .named = true,
  },
  [sym_cast] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_mutable] = {
    .visible = true,
    .named = true,
  },
  [sym_inline] = {
    .visible = true,
    .named = true,
  },
  [sym_copy] = {
    .visible = true,
    .named = true,
  },
  [sym_move] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_path_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_symbols_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tags_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extern_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameter_requirements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_trait_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_required_traits_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_implement_trait_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bounds_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_call_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_cases_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_or_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_closure_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_identifier_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_integer_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_string_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alias = 1,
  field_alternative = 2,
  field_arguments = 3,
  field_body = 4,
  field_bounds = 5,
  field_cases = 6,
  field_class = 7,
  field_condition = 8,
  field_consequence = 9,
  field_expression = 10,
  field_guard = 11,
  field_iterator = 12,
  field_left = 13,
  field_modifier = 14,
  field_name = 15,
  field_operator = 16,
  field_path = 17,
  field_pattern = 18,
  field_receiver = 19,
  field_requirements = 20,
  field_returns = 21,
  field_right = 22,
  field_symbols = 23,
  field_tags = 24,
  field_trait = 25,
  field_type = 26,
  field_type_parameters = 27,
  field_value = 28,
  field_visibility = 29,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_bounds] = "bounds",
  [field_cases] = "cases",
  [field_class] = "class",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_expression] = "expression",
  [field_guard] = "guard",
  [field_iterator] = "iterator",
  [field_left] = "left",
  [field_modifier] = "modifier",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_path] = "path",
  [field_pattern] = "pattern",
  [field_receiver] = "receiver",
  [field_requirements] = "requirements",
  [field_returns] = "returns",
  [field_right] = "right",
  [field_symbols] = "symbols",
  [field_tags] = "tags",
  [field_trait] = "trait",
  [field_type] = "type",
  [field_type_parameters] = "type_parameters",
  [field_value] = "value",
  [field_visibility] = "visibility",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 1},
  [9] = {.index = 3, .length = 2},
  [10] = {.index = 5, .length = 1},
  [11] = {.index = 6, .length = 2},
  [12] = {.index = 8, .length = 2},
  [13] = {.index = 10, .length = 2},
  [14] = {.index = 12, .length = 1},
  [16] = {.index = 13, .length = 2},
  [17] = {.index = 15, .length = 2},
  [18] = {.index = 17, .length = 2},
  [19] = {.index = 19, .length = 2},
  [21] = {.index = 21, .length = 2},
  [22] = {.index = 23, .length = 2},
  [23] = {.index = 25, .length = 2},
  [24] = {.index = 27, .length = 2},
  [25] = {.index = 29, .length = 3},
  [26] = {.index = 32, .length = 2},
  [27] = {.index = 34, .length = 3},
  [28] = {.index = 37, .length = 1},
  [29] = {.index = 38, .length = 3},
  [30] = {.index = 41, .length = 3},
  [31] = {.index = 44, .length = 2},
  [32] = {.index = 46, .length = 2},
  [33] = {.index = 48, .length = 2},
  [34] = {.index = 50, .length = 1},
  [35] = {.index = 51, .length = 1},
  [36] = {.index = 52, .length = 1},
  [37] = {.index = 53, .length = 2},
  [38] = {.index = 55, .length = 3},
  [39] = {.index = 58, .length = 3},
  [40] = {.index = 61, .length = 3},
  [41] = {.index = 64, .length = 3},
  [42] = {.index = 67, .length = 3},
  [43] = {.index = 70, .length = 3},
  [44] = {.index = 73, .length = 3},
  [45] = {.index = 76, .length = 3},
  [46] = {.index = 79, .length = 2},
  [47] = {.index = 81, .length = 3},
  [48] = {.index = 84, .length = 3},
  [49] = {.index = 87, .length = 1},
  [50] = {.index = 88, .length = 3},
  [51] = {.index = 91, .length = 4},
  [52] = {.index = 95, .length = 2},
  [53] = {.index = 97, .length = 2},
  [54] = {.index = 99, .length = 3},
  [55] = {.index = 102, .length = 3},
  [56] = {.index = 105, .length = 3},
  [57] = {.index = 108, .length = 2},
  [58] = {.index = 110, .length = 3},
  [59] = {.index = 113, .length = 3},
  [60] = {.index = 116, .length = 3},
  [61] = {.index = 119, .length = 4},
  [62] = {.index = 123, .length = 4},
  [63] = {.index = 127, .length = 4},
  [64] = {.index = 131, .length = 4},
  [65] = {.index = 135, .length = 2},
  [66] = {.index = 137, .length = 4},
  [67] = {.index = 141, .length = 4},
  [68] = {.index = 145, .length = 4},
  [69] = {.index = 149, .length = 4},
  [70] = {.index = 153, .length = 4},
  [71] = {.index = 157, .length = 4},
  [72] = {.index = 161, .length = 4},
  [73] = {.index = 165, .length = 1},
  [74] = {.index = 166, .length = 3},
  [75] = {.index = 169, .length = 3},
  [76] = {.index = 172, .length = 4},
  [77] = {.index = 176, .length = 4},
  [78] = {.index = 180, .length = 3},
  [79] = {.index = 180, .length = 3},
  [80] = {.index = 183, .length = 2},
  [81] = {.index = 185, .length = 3},
  [82] = {.index = 188, .length = 2},
  [83] = {.index = 190, .length = 3},
  [84] = {.index = 193, .length = 3},
  [85] = {.index = 196, .length = 4},
  [86] = {.index = 200, .length = 4},
  [87] = {.index = 204, .length = 4},
  [88] = {.index = 208, .length = 4},
  [89] = {.index = 212, .length = 5},
  [90] = {.index = 217, .length = 5},
  [91] = {.index = 222, .length = 5},
  [92] = {.index = 227, .length = 5},
  [93] = {.index = 232, .length = 5},
  [94] = {.index = 237, .length = 5},
  [95] = {.index = 242, .length = 5},
  [96] = {.index = 247, .length = 5},
  [97] = {.index = 252, .length = 5},
  [98] = {.index = 257, .length = 5},
  [99] = {.index = 262, .length = 2},
  [100] = {.index = 264, .length = 4},
  [101] = {.index = 268, .length = 5},
  [102] = {.index = 273, .length = 2},
  [103] = {.index = 275, .length = 2},
  [104] = {.index = 277, .length = 2},
  [105] = {.index = 279, .length = 2},
  [106] = {.index = 281, .length = 4},
  [107] = {.index = 281, .length = 4},
  [108] = {.index = 285, .length = 2},
  [109] = {.index = 287, .length = 5},
  [110] = {.index = 292, .length = 6},
  [111] = {.index = 298, .length = 6},
  [112] = {.index = 304, .length = 6},
  [113] = {.index = 310, .length = 6},
  [114] = {.index = 316, .length = 6},
  [115] = {.index = 322, .length = 2},
  [116] = {.index = 324, .length = 5},
  [117] = {.index = 329, .length = 3},
  [118] = {.index = 332, .length = 3},
  [119] = {.index = 335, .length = 3},
  [120] = {.index = 338, .length = 3},
  [121] = {.index = 341, .length = 3},
  [122] = {.index = 344, .length = 3},
  [123] = {.index = 347, .length = 3},
  [124] = {.index = 350, .length = 3},
  [125] = {.index = 353, .length = 3},
  [126] = {.index = 356, .length = 3},
  [127] = {.index = 359, .length = 2},
  [128] = {.index = 361, .length = 7},
  [129] = {.index = 368, .length = 3},
  [130] = {.index = 371, .length = 4},
  [131] = {.index = 375, .length = 4},
  [132] = {.index = 379, .length = 4},
  [133] = {.index = 383, .length = 4},
  [134] = {.index = 387, .length = 4},
  [135] = {.index = 391, .length = 4},
  [136] = {.index = 395, .length = 4},
  [137] = {.index = 399, .length = 4},
  [138] = {.index = 403, .length = 4},
  [139] = {.index = 407, .length = 4},
  [140] = {.index = 411, .length = 5},
  [141] = {.index = 416, .length = 5},
  [142] = {.index = 421, .length = 5},
  [143] = {.index = 426, .length = 5},
  [144] = {.index = 431, .length = 5},
  [145] = {.index = 436, .length = 4},
  [146] = {.index = 440, .length = 6},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_path, 1},
  [2] =
    {field_body, 1},
  [3] =
    {field_arguments, 1},
    {field_name, 0},
  [5] =
    {field_path, 2},
  [6] =
    {field_path, 1},
    {field_symbols, 2},
  [8] =
    {field_path, 1},
    {field_tags, 2},
  [10] =
    {field_condition, 1},
    {field_consequence, 2},
  [12] =
    {field_name, 2},
  [13] =
    {field_body, 2},
    {field_name, 1},
  [15] =
    {field_body, 2},
    {field_returns, 1},
  [17] =
    {field_arguments, 1},
    {field_body, 2},
  [19] =
    {field_body, 2},
    {field_modifier, 1},
  [21] =
    {field_body, 2},
    {field_condition, 1},
  [23] =
    {field_name, 0},
    {field_value, 2},
  [25] =
    {field_name, 2},
    {field_receiver, 0},
  [27] =
    {field_expression, 0},
    {field_type, 2},
  [29] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [32] =
    {field_path, 2},
    {field_tags, 3},
  [34] =
    {field_path, 1},
    {field_symbols, 2},
    {field_tags, 3},
  [37] =
    {field_alternative, 0},
  [38] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [41] =
    {field_alternative, 3, .inherited = true},
    {field_condition, 1},
    {field_consequence, 2},
  [44] =
    {field_arguments, 3},
    {field_name, 2},
  [46] =
    {field_name, 2},
    {field_returns, 3},
  [48] =
    {field_body, 3},
    {field_name, 2},
  [50] =
    {field_returns, 1},
  [51] =
    {field_arguments, 1},
  [52] =
    {field_type, 1},
  [53] =
    {field_name, 3},
    {field_visibility, 1},
  [55] =
    {field_body, 3},
    {field_name, 2},
    {field_visibility, 1},
  [58] =
    {field_arguments, 2},
    {field_body, 3},
    {field_name, 1},
  [61] =
    {field_body, 3},
    {field_name, 1},
    {field_returns, 2},
  [64] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [67] =
    {field_arguments, 1},
    {field_body, 3},
    {field_returns, 2},
  [70] =
    {field_body, 3},
    {field_modifier, 1},
    {field_name, 2},
  [73] =
    {field_body, 3},
    {field_modifier, 1},
    {field_returns, 2},
  [76] =
    {field_arguments, 2},
    {field_body, 3},
    {field_modifier, 1},
  [79] =
    {field_name, 1},
    {field_value, 3},
  [81] =
    {field_body, 3},
    {field_name, 1},
    {field_requirements, 2},
  [84] =
    {field_body, 3},
    {field_bounds, 2},
    {field_name, 1},
  [87] =
    {field_value, 1},
  [88] =
    {field_arguments, 3},
    {field_name, 2},
    {field_receiver, 0},
  [91] =
    {field_alternative, 3, .inherited = true},
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [95] =
    {field_alternative, 0, .inherited = true},
    {field_alternative, 1, .inherited = true},
  [97] =
    {field_name, 0},
    {field_type, 2},
  [99] =
    {field_arguments, 3},
    {field_name, 2},
    {field_returns, 4},
  [102] =
    {field_arguments, 3},
    {field_body, 4},
    {field_name, 2},
  [105] =
    {field_body, 4},
    {field_name, 2},
    {field_returns, 3},
  [108] =
    {field_arguments, 1},
    {field_returns, 2},
  [110] =
    {field_arguments, 4},
    {field_name, 3},
    {field_visibility, 1},
  [113] =
    {field_name, 3},
    {field_returns, 4},
    {field_visibility, 1},
  [116] =
    {field_body, 4},
    {field_name, 3},
    {field_visibility, 1},
  [119] =
    {field_arguments, 3},
    {field_body, 4},
    {field_name, 2},
    {field_visibility, 1},
  [123] =
    {field_body, 4},
    {field_name, 2},
    {field_returns, 3},
    {field_visibility, 1},
  [127] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
    {field_visibility, 1},
  [131] =
    {field_body, 4},
    {field_modifier, 2},
    {field_name, 3},
    {field_visibility, 1},
  [135] =
    {field_name, 0},
    {field_requirements, 1},
  [137] =
    {field_arguments, 2},
    {field_body, 4},
    {field_name, 1},
    {field_returns, 3},
  [141] =
    {field_arguments, 3},
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [145] =
    {field_body, 4},
    {field_name, 1},
    {field_returns, 3},
    {field_type_parameters, 2},
  [149] =
    {field_arguments, 3},
    {field_body, 4},
    {field_modifier, 1},
    {field_name, 2},
  [153] =
    {field_body, 4},
    {field_modifier, 1},
    {field_name, 2},
    {field_returns, 3},
  [157] =
    {field_body, 4},
    {field_modifier, 1},
    {field_name, 2},
    {field_type_parameters, 3},
  [161] =
    {field_arguments, 2},
    {field_body, 4},
    {field_modifier, 1},
    {field_returns, 3},
  [165] =
    {field_name, 1},
  [166] =
    {field_name, 2},
    {field_value, 4},
    {field_visibility, 1},
  [169] =
    {field_modifier, 1},
    {field_name, 2},
    {field_value, 4},
  [172] =
    {field_body, 4},
    {field_name, 2},
    {field_requirements, 3},
    {field_visibility, 1},
  [176] =
    {field_body, 4},
    {field_name, 1},
    {field_requirements, 3},
    {field_type_parameters, 2},
  [180] =
    {field_body, 4},
    {field_class, 3},
    {field_trait, 1},
  [183] =
    {field_name, 0},
    {field_pattern, 2},
  [185] =
    {field_body, 4},
    {field_iterator, 3},
    {field_pattern, 1},
  [188] =
    {field_cases, 3},
    {field_value, 1},
  [190] =
    {field_name, 2},
    {field_receiver, 0},
    {field_value, 4},
  [193] =
    {field_alias, 1},
    {field_alias, 2},
    {field_name, 0},
  [196] =
    {field_arguments, 3},
    {field_body, 5},
    {field_name, 2},
    {field_returns, 4},
  [200] =
    {field_arguments, 4},
    {field_name, 3},
    {field_returns, 5},
    {field_visibility, 1},
  [204] =
    {field_arguments, 4},
    {field_body, 5},
    {field_name, 3},
    {field_visibility, 1},
  [208] =
    {field_body, 5},
    {field_name, 3},
    {field_returns, 4},
    {field_visibility, 1},
  [212] =
    {field_arguments, 3},
    {field_body, 5},
    {field_name, 2},
    {field_returns, 4},
    {field_visibility, 1},
  [217] =
    {field_arguments, 4},
    {field_body, 5},
    {field_name, 2},
    {field_type_parameters, 3},
    {field_visibility, 1},
  [222] =
    {field_body, 5},
    {field_name, 2},
    {field_returns, 4},
    {field_type_parameters, 3},
    {field_visibility, 1},
  [227] =
    {field_arguments, 4},
    {field_body, 5},
    {field_modifier, 2},
    {field_name, 3},
    {field_visibility, 1},
  [232] =
    {field_body, 5},
    {field_modifier, 2},
    {field_name, 3},
    {field_returns, 4},
    {field_visibility, 1},
  [237] =
    {field_body, 5},
    {field_modifier, 2},
    {field_name, 3},
    {field_type_parameters, 4},
    {field_visibility, 1},
  [242] =
    {field_arguments, 3},
    {field_body, 5},
    {field_name, 1},
    {field_returns, 4},
    {field_type_parameters, 2},
  [247] =
    {field_arguments, 3},
    {field_body, 5},
    {field_modifier, 1},
    {field_name, 2},
    {field_returns, 4},
  [252] =
    {field_arguments, 4},
    {field_body, 5},
    {field_modifier, 1},
    {field_name, 2},
    {field_type_parameters, 3},
  [257] =
    {field_body, 5},
    {field_modifier, 1},
    {field_name, 2},
    {field_returns, 4},
    {field_type_parameters, 3},
  [262] =
    {field_arguments, 2},
    {field_name, 1},
  [264] =
    {field_name, 1},
    {field_type, 2},
    {field_type, 3},
    {field_value, 5},
  [268] =
    {field_body, 5},
    {field_name, 2},
    {field_requirements, 4},
    {field_type_parameters, 3},
    {field_visibility, 1},
  [273] =
    {field_name, 2},
    {field_visibility, 1},
  [275] =
    {field_name, 1},
    {field_returns, 2},
  [277] =
    {field_name, 1},
    {field_type_parameters, 2},
  [279] =
    {field_modifier, 1},
    {field_name, 2},
  [281] =
    {field_body, 5},
    {field_bounds, 4},
    {field_class, 3},
    {field_trait, 1},
  [285] =
    {field_condition, 2},
    {field_consequence, 3},
  [287] =
    {field_arguments, 4},
    {field_body, 6},
    {field_name, 3},
    {field_returns, 5},
    {field_visibility, 1},
  [292] =
    {field_arguments, 4},
    {field_body, 6},
    {field_name, 2},
    {field_returns, 5},
    {field_type_parameters, 3},
    {field_visibility, 1},
  [298] =
    {field_arguments, 4},
    {field_body, 6},
    {field_modifier, 2},
    {field_name, 3},
    {field_returns, 5},
    {field_visibility, 1},
  [304] =
    {field_arguments, 5},
    {field_body, 6},
    {field_modifier, 2},
    {field_name, 3},
    {field_type_parameters, 4},
    {field_visibility, 1},
  [310] =
    {field_body, 6},
    {field_modifier, 2},
    {field_name, 3},
    {field_returns, 5},
    {field_type_parameters, 4},
    {field_visibility, 1},
  [316] =
    {field_arguments, 4},
    {field_body, 6},
    {field_modifier, 1},
    {field_name, 2},
    {field_returns, 5},
    {field_type_parameters, 3},
  [322] =
    {field_name, 1},
    {field_type, 3},
  [324] =
    {field_modifier, 1},
    {field_name, 2},
    {field_type, 3},
    {field_type, 4},
    {field_value, 6},
  [329] =
    {field_arguments, 3},
    {field_name, 2},
    {field_visibility, 1},
  [332] =
    {field_name, 2},
    {field_returns, 3},
    {field_visibility, 1},
  [335] =
    {field_name, 2},
    {field_type_parameters, 3},
    {field_visibility, 1},
  [338] =
    {field_modifier, 2},
    {field_name, 3},
    {field_visibility, 1},
  [341] =
    {field_arguments, 2},
    {field_name, 1},
    {field_returns, 3},
  [344] =
    {field_arguments, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [347] =
    {field_name, 1},
    {field_returns, 3},
    {field_type_parameters, 2},
  [350] =
    {field_arguments, 3},
    {field_modifier, 1},
    {field_name, 2},
  [353] =
    {field_modifier, 1},
    {field_name, 2},
    {field_returns, 3},
  [356] =
    {field_modifier, 1},
    {field_name, 2},
    {field_type_parameters, 3},
  [359] =
    {field_body, 3},
    {field_pattern, 1},
  [361] =
    {field_arguments, 5},
    {field_body, 7},
    {field_modifier, 2},
    {field_name, 3},
    {field_returns, 6},
    {field_type_parameters, 4},
    {field_visibility, 1},
  [368] =
    {field_name, 2},
    {field_type, 4},
    {field_visibility, 1},
  [371] =
    {field_arguments, 3},
    {field_name, 2},
    {field_returns, 4},
    {field_visibility, 1},
  [375] =
    {field_arguments, 4},
    {field_name, 2},
    {field_type_parameters, 3},
    {field_visibility, 1},
  [379] =
    {field_name, 2},
    {field_returns, 4},
    {field_type_parameters, 3},
    {field_visibility, 1},
  [383] =
    {field_arguments, 4},
    {field_modifier, 2},
    {field_name, 3},
    {field_visibility, 1},
  [387] =
    {field_modifier, 2},
    {field_name, 3},
    {field_returns, 4},
    {field_visibility, 1},
  [391] =
    {field_modifier, 2},
    {field_name, 3},
    {field_type_parameters, 4},
    {field_visibility, 1},
  [395] =
    {field_arguments, 3},
    {field_name, 1},
    {field_returns, 4},
    {field_type_parameters, 2},
  [399] =
    {field_arguments, 3},
    {field_modifier, 1},
    {field_name, 2},
    {field_returns, 4},
  [403] =
    {field_arguments, 4},
    {field_modifier, 1},
    {field_name, 2},
    {field_type_parameters, 3},
  [407] =
    {field_modifier, 1},
    {field_name, 2},
    {field_returns, 4},
    {field_type_parameters, 3},
  [411] =
    {field_arguments, 4},
    {field_name, 2},
    {field_returns, 5},
    {field_type_parameters, 3},
    {field_visibility, 1},
  [416] =
    {field_arguments, 4},
    {field_modifier, 2},
    {field_name, 3},
    {field_returns, 5},
    {field_visibility, 1},
  [421] =
    {field_arguments, 5},
    {field_modifier, 2},
    {field_name, 3},
    {field_type_parameters, 4},
    {field_visibility, 1},
  [426] =
    {field_modifier, 2},
    {field_name, 3},
    {field_returns, 5},
    {field_type_parameters, 4},
    {field_visibility, 1},
  [431] =
    {field_arguments, 4},
    {field_modifier, 1},
    {field_name, 2},
    {field_returns, 5},
    {field_type_parameters, 3},
  [436] =
    {field_body, 5},
    {field_guard, 2},
    {field_guard, 3},
    {field_pattern, 1},
  [440] =
    {field_arguments, 5},
    {field_modifier, 2},
    {field_name, 3},
    {field_returns, 6},
    {field_type_parameters, 4},
    {field_visibility, 1},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier_with_special,
  },
  [5] = {
    [0] = alias_sym_integer_pattern,
  },
  [6] = {
    [0] = alias_sym_identifier_pattern,
  },
  [7] = {
    [0] = sym_namespaced_constant_pattern,
  },
  [8] = {
    [0] = alias_sym_string_pattern,
  },
  [15] = {
    [0] = alias_sym_type,
  },
  [20] = {
    [1] = alias_sym_identifier_pattern,
  },
  [75] = {
    [1] = sym__method_modifier,
  },
  [78] = {
    [1] = alias_sym_type,
  },
  [106] = {
    [1] = alias_sym_type,
  },
  [116] = {
    [1] = sym__method_modifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_string, 2,
    sym_string,
    alias_sym_string_pattern,
  sym_mutable, 2,
    sym_mutable,
    sym__method_modifier,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 2,
  [5] = 2,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 13,
  [16] = 8,
  [17] = 12,
  [18] = 14,
  [19] = 13,
  [20] = 12,
  [21] = 14,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 10,
  [26] = 26,
  [27] = 9,
  [28] = 11,
  [29] = 22,
  [30] = 23,
  [31] = 26,
  [32] = 22,
  [33] = 33,
  [34] = 23,
  [35] = 22,
  [36] = 33,
  [37] = 37,
  [38] = 23,
  [39] = 22,
  [40] = 23,
  [41] = 22,
  [42] = 23,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 43,
  [47] = 47,
  [48] = 48,
  [49] = 48,
  [50] = 43,
  [51] = 47,
  [52] = 44,
  [53] = 53,
  [54] = 45,
  [55] = 44,
  [56] = 45,
  [57] = 47,
  [58] = 48,
  [59] = 53,
  [60] = 53,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 63,
  [92] = 68,
  [93] = 69,
  [94] = 70,
  [95] = 75,
  [96] = 76,
  [97] = 80,
  [98] = 81,
  [99] = 83,
  [100] = 84,
  [101] = 85,
  [102] = 86,
  [103] = 87,
  [104] = 88,
  [105] = 89,
  [106] = 90,
  [107] = 63,
  [108] = 68,
  [109] = 69,
  [110] = 70,
  [111] = 75,
  [112] = 76,
  [113] = 113,
  [114] = 72,
  [115] = 82,
  [116] = 80,
  [117] = 83,
  [118] = 84,
  [119] = 85,
  [120] = 86,
  [121] = 87,
  [122] = 88,
  [123] = 89,
  [124] = 80,
  [125] = 81,
  [126] = 83,
  [127] = 84,
  [128] = 85,
  [129] = 86,
  [130] = 87,
  [131] = 88,
  [132] = 89,
  [133] = 90,
  [134] = 63,
  [135] = 68,
  [136] = 69,
  [137] = 70,
  [138] = 75,
  [139] = 76,
  [140] = 90,
  [141] = 61,
  [142] = 81,
  [143] = 72,
  [144] = 82,
  [145] = 145,
  [146] = 113,
  [147] = 61,
  [148] = 72,
  [149] = 82,
  [150] = 62,
  [151] = 66,
  [152] = 145,
  [153] = 65,
  [154] = 73,
  [155] = 62,
  [156] = 66,
  [157] = 145,
  [158] = 65,
  [159] = 73,
  [160] = 113,
  [161] = 61,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 177,
  [219] = 219,
  [220] = 190,
  [221] = 170,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 191,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 178,
  [262] = 179,
  [263] = 180,
  [264] = 181,
  [265] = 182,
  [266] = 185,
  [267] = 184,
  [268] = 186,
  [269] = 165,
  [270] = 164,
  [271] = 183,
  [272] = 163,
  [273] = 189,
  [274] = 190,
  [275] = 191,
  [276] = 187,
  [277] = 162,
  [278] = 188,
  [279] = 245,
  [280] = 175,
  [281] = 226,
  [282] = 228,
  [283] = 229,
  [284] = 233,
  [285] = 238,
  [286] = 203,
  [287] = 241,
  [288] = 244,
  [289] = 247,
  [290] = 249,
  [291] = 252,
  [292] = 253,
  [293] = 198,
  [294] = 176,
  [295] = 199,
  [296] = 167,
  [297] = 260,
  [298] = 215,
  [299] = 194,
  [300] = 205,
  [301] = 195,
  [302] = 196,
  [303] = 206,
  [304] = 210,
  [305] = 214,
  [306] = 192,
  [307] = 169,
  [308] = 200,
  [309] = 219,
  [310] = 207,
  [311] = 234,
  [312] = 236,
  [313] = 204,
  [314] = 168,
  [315] = 258,
  [316] = 208,
  [317] = 209,
  [318] = 318,
  [319] = 201,
  [320] = 235,
  [321] = 171,
  [322] = 172,
  [323] = 193,
  [324] = 212,
  [325] = 213,
  [326] = 190,
  [327] = 225,
  [328] = 227,
  [329] = 230,
  [330] = 231,
  [331] = 232,
  [332] = 197,
  [333] = 254,
  [334] = 248,
  [335] = 250,
  [336] = 256,
  [337] = 255,
  [338] = 173,
  [339] = 166,
  [340] = 242,
  [341] = 243,
  [342] = 259,
  [343] = 216,
  [344] = 191,
  [345] = 174,
  [346] = 202,
  [347] = 251,
  [348] = 217,
  [349] = 222,
  [350] = 223,
  [351] = 224,
  [352] = 257,
  [353] = 211,
  [354] = 8,
  [355] = 10,
  [356] = 11,
  [357] = 9,
  [358] = 8,
  [359] = 359,
  [360] = 11,
  [361] = 361,
  [362] = 362,
  [363] = 9,
  [364] = 201,
  [365] = 10,
  [366] = 366,
  [367] = 367,
  [368] = 180,
  [369] = 369,
  [370] = 370,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 374,
  [375] = 182,
  [376] = 376,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 188,
  [382] = 382,
  [383] = 165,
  [384] = 162,
  [385] = 163,
  [386] = 386,
  [387] = 387,
  [388] = 164,
  [389] = 389,
  [390] = 390,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 394,
  [395] = 395,
  [396] = 396,
  [397] = 207,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 202,
  [419] = 171,
  [420] = 172,
  [421] = 421,
  [422] = 173,
  [423] = 166,
  [424] = 174,
  [425] = 175,
  [426] = 203,
  [427] = 176,
  [428] = 167,
  [429] = 205,
  [430] = 169,
  [431] = 431,
  [432] = 432,
  [433] = 168,
  [434] = 434,
  [435] = 208,
  [436] = 436,
  [437] = 190,
  [438] = 191,
  [439] = 439,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 443,
  [444] = 444,
  [445] = 445,
  [446] = 446,
  [447] = 447,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 455,
  [456] = 456,
  [457] = 457,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 464,
  [465] = 465,
  [466] = 466,
  [467] = 467,
  [468] = 468,
  [469] = 469,
  [470] = 470,
  [471] = 471,
  [472] = 472,
  [473] = 473,
  [474] = 474,
  [475] = 475,
  [476] = 476,
  [477] = 477,
  [478] = 478,
  [479] = 479,
  [480] = 480,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 486,
  [487] = 487,
  [488] = 488,
  [489] = 489,
  [490] = 490,
  [491] = 491,
  [492] = 492,
  [493] = 180,
  [494] = 188,
  [495] = 202,
  [496] = 208,
  [497] = 497,
  [498] = 170,
  [499] = 207,
  [500] = 205,
  [501] = 177,
  [502] = 203,
  [503] = 179,
  [504] = 504,
  [505] = 505,
  [506] = 191,
  [507] = 182,
  [508] = 190,
  [509] = 165,
  [510] = 167,
  [511] = 255,
  [512] = 181,
  [513] = 201,
  [514] = 171,
  [515] = 172,
  [516] = 169,
  [517] = 164,
  [518] = 163,
  [519] = 175,
  [520] = 176,
  [521] = 173,
  [522] = 235,
  [523] = 174,
  [524] = 162,
  [525] = 168,
  [526] = 166,
  [527] = 178,
  [528] = 186,
  [529] = 185,
  [530] = 189,
  [531] = 184,
  [532] = 183,
  [533] = 196,
  [534] = 217,
  [535] = 200,
  [536] = 204,
  [537] = 209,
  [538] = 226,
  [539] = 228,
  [540] = 229,
  [541] = 233,
  [542] = 241,
  [543] = 244,
  [544] = 247,
  [545] = 249,
  [546] = 252,
  [547] = 253,
  [548] = 260,
  [549] = 215,
  [550] = 195,
  [551] = 214,
  [552] = 192,
  [553] = 234,
  [554] = 236,
  [555] = 254,
  [556] = 256,
  [557] = 211,
  [558] = 212,
  [559] = 232,
  [560] = 248,
  [561] = 250,
  [562] = 242,
  [563] = 243,
  [564] = 245,
  [565] = 216,
  [566] = 197,
  [567] = 187,
  [568] = 178,
  [569] = 198,
  [570] = 219,
  [571] = 199,
  [572] = 193,
  [573] = 258,
  [574] = 259,
  [575] = 213,
  [576] = 225,
  [577] = 227,
  [578] = 230,
  [579] = 238,
  [580] = 194,
  [581] = 223,
  [582] = 224,
  [583] = 231,
  [584] = 210,
  [585] = 206,
  [586] = 257,
  [587] = 251,
  [588] = 588,
  [589] = 222,
  [590] = 590,
  [591] = 187,
  [592] = 592,
  [593] = 223,
  [594] = 224,
  [595] = 257,
  [596] = 259,
  [597] = 193,
  [598] = 198,
  [599] = 238,
  [600] = 194,
  [601] = 219,
  [602] = 258,
  [603] = 603,
  [604] = 603,
  [605] = 605,
  [606] = 592,
  [607] = 592,
  [608] = 603,
  [609] = 609,
  [610] = 610,
  [611] = 213,
  [612] = 225,
  [613] = 227,
  [614] = 230,
  [615] = 231,
  [616] = 222,
  [617] = 199,
  [618] = 206,
  [619] = 210,
  [620] = 251,
  [621] = 621,
  [622] = 622,
  [623] = 623,
  [624] = 624,
  [625] = 625,
  [626] = 623,
  [627] = 624,
  [628] = 628,
  [629] = 625,
  [630] = 624,
  [631] = 628,
  [632] = 622,
  [633] = 625,
  [634] = 634,
  [635] = 622,
  [636] = 623,
  [637] = 628,
  [638] = 638,
  [639] = 639,
  [640] = 639,
  [641] = 641,
  [642] = 639,
  [643] = 643,
  [644] = 644,
  [645] = 645,
  [646] = 646,
  [647] = 647,
  [648] = 648,
  [649] = 649,
  [650] = 650,
  [651] = 651,
  [652] = 652,
  [653] = 653,
  [654] = 654,
  [655] = 655,
  [656] = 656,
  [657] = 651,
  [658] = 658,
  [659] = 659,
  [660] = 660,
  [661] = 661,
  [662] = 662,
  [663] = 651,
  [664] = 664,
  [665] = 665,
  [666] = 666,
  [667] = 667,
  [668] = 668,
  [669] = 669,
  [670] = 670,
  [671] = 667,
  [672] = 672,
  [673] = 673,
  [674] = 674,
  [675] = 675,
  [676] = 670,
  [677] = 677,
  [678] = 678,
  [679] = 673,
  [680] = 680,
  [681] = 673,
  [682] = 672,
  [683] = 668,
  [684] = 669,
  [685] = 672,
  [686] = 667,
  [687] = 668,
  [688] = 669,
  [689] = 675,
  [690] = 670,
  [691] = 677,
  [692] = 673,
  [693] = 680,
  [694] = 668,
  [695] = 669,
  [696] = 672,
  [697] = 667,
  [698] = 680,
  [699] = 677,
  [700] = 675,
  [701] = 675,
  [702] = 670,
  [703] = 677,
  [704] = 704,
  [705] = 680,
  [706] = 706,
  [707] = 707,
  [708] = 708,
  [709] = 706,
  [710] = 710,
  [711] = 708,
  [712] = 707,
  [713] = 713,
  [714] = 714,
  [715] = 707,
  [716] = 706,
  [717] = 717,
  [718] = 718,
  [719] = 707,
  [720] = 718,
  [721] = 718,
  [722] = 722,
  [723] = 714,
  [724] = 724,
  [725] = 708,
  [726] = 726,
  [727] = 713,
  [728] = 714,
  [729] = 729,
  [730] = 708,
  [731] = 706,
  [732] = 713,
  [733] = 714,
  [734] = 708,
  [735] = 714,
  [736] = 724,
  [737] = 737,
  [738] = 726,
  [739] = 707,
  [740] = 724,
  [741] = 726,
  [742] = 706,
  [743] = 713,
  [744] = 726,
  [745] = 724,
  [746] = 713,
  [747] = 747,
  [748] = 748,
  [749] = 749,
  [750] = 750,
  [751] = 751,
  [752] = 749,
  [753] = 753,
  [754] = 754,
  [755] = 755,
  [756] = 756,
  [757] = 749,
  [758] = 758,
  [759] = 751,
  [760] = 750,
  [761] = 750,
  [762] = 754,
  [763] = 751,
  [764] = 754,
  [765] = 765,
  [766] = 766,
  [767] = 180,
  [768] = 768,
  [769] = 769,
  [770] = 770,
  [771] = 771,
  [772] = 772,
  [773] = 773,
  [774] = 774,
  [775] = 775,
  [776] = 776,
  [777] = 777,
  [778] = 778,
  [779] = 779,
  [780] = 780,
  [781] = 781,
  [782] = 782,
  [783] = 783,
  [784] = 784,
  [785] = 785,
  [786] = 777,
  [787] = 787,
  [788] = 788,
  [789] = 789,
  [790] = 790,
  [791] = 777,
  [792] = 792,
  [793] = 793,
  [794] = 794,
  [795] = 795,
  [796] = 796,
  [797] = 797,
  [798] = 798,
  [799] = 799,
  [800] = 188,
  [801] = 801,
  [802] = 802,
  [803] = 803,
  [804] = 804,
  [805] = 805,
  [806] = 806,
  [807] = 807,
  [808] = 808,
  [809] = 796,
  [810] = 810,
  [811] = 798,
  [812] = 812,
  [813] = 813,
  [814] = 814,
  [815] = 815,
  [816] = 816,
  [817] = 182,
  [818] = 807,
  [819] = 819,
  [820] = 820,
  [821] = 821,
  [822] = 822,
  [823] = 797,
  [824] = 824,
  [825] = 825,
  [826] = 826,
  [827] = 827,
  [828] = 828,
  [829] = 829,
  [830] = 829,
  [831] = 831,
  [832] = 832,
  [833] = 833,
  [834] = 834,
  [835] = 835,
  [836] = 836,
  [837] = 837,
  [838] = 838,
  [839] = 839,
  [840] = 840,
  [841] = 841,
  [842] = 842,
  [843] = 843,
  [844] = 844,
  [845] = 845,
  [846] = 829,
  [847] = 847,
  [848] = 848,
  [849] = 849,
  [850] = 380,
  [851] = 851,
  [852] = 852,
  [853] = 853,
  [854] = 854,
  [855] = 855,
  [856] = 856,
  [857] = 857,
  [858] = 858,
  [859] = 855,
  [860] = 860,
  [861] = 855,
  [862] = 862,
  [863] = 863,
  [864] = 864,
  [865] = 855,
  [866] = 866,
  [867] = 867,
  [868] = 868,
  [869] = 869,
  [870] = 870,
  [871] = 871,
  [872] = 872,
  [873] = 873,
  [874] = 874,
  [875] = 875,
  [876] = 876,
  [877] = 877,
  [878] = 878,
  [879] = 879,
  [880] = 880,
  [881] = 881,
  [882] = 882,
  [883] = 883,
  [884] = 884,
  [885] = 885,
  [886] = 886,
  [887] = 887,
  [888] = 888,
  [889] = 889,
  [890] = 890,
  [891] = 891,
  [892] = 892,
  [893] = 893,
  [894] = 894,
  [895] = 895,
  [896] = 896,
  [897] = 897,
  [898] = 898,
  [899] = 899,
  [900] = 900,
  [901] = 901,
  [902] = 902,
  [903] = 903,
  [904] = 904,
  [905] = 905,
  [906] = 906,
  [907] = 907,
  [908] = 908,
  [909] = 909,
  [910] = 910,
  [911] = 911,
  [912] = 912,
  [913] = 913,
  [914] = 914,
  [915] = 915,
  [916] = 916,
  [917] = 917,
  [918] = 918,
  [919] = 919,
  [920] = 868,
  [921] = 921,
  [922] = 922,
  [923] = 923,
  [924] = 924,
  [925] = 925,
  [926] = 926,
  [927] = 927,
  [928] = 928,
  [929] = 929,
  [930] = 930,
  [931] = 931,
  [932] = 932,
  [933] = 933,
  [934] = 934,
  [935] = 935,
  [936] = 936,
  [937] = 937,
  [938] = 938,
  [939] = 939,
  [940] = 940,
  [941] = 941,
  [942] = 942,
  [943] = 943,
  [944] = 944,
  [945] = 945,
  [946] = 946,
  [947] = 918,
  [948] = 948,
  [949] = 949,
  [950] = 911,
  [951] = 951,
  [952] = 952,
  [953] = 953,
  [954] = 954,
  [955] = 918,
  [956] = 868,
  [957] = 957,
  [958] = 958,
  [959] = 959,
  [960] = 960,
  [961] = 961,
  [962] = 962,
  [963] = 963,
  [964] = 964,
  [965] = 965,
  [966] = 966,
  [967] = 967,
  [968] = 968,
  [969] = 969,
  [970] = 970,
  [971] = 971,
  [972] = 972,
  [973] = 973,
  [974] = 974,
  [975] = 975,
  [976] = 976,
  [977] = 977,
  [978] = 978,
  [979] = 979,
  [980] = 980,
  [981] = 981,
  [982] = 982,
  [983] = 911,
  [984] = 984,
  [985] = 985,
  [986] = 986,
  [987] = 987,
  [988] = 988,
  [989] = 989,
  [990] = 990,
  [991] = 991,
  [992] = 992,
  [993] = 993,
  [994] = 994,
  [995] = 995,
  [996] = 996,
  [997] = 997,
  [998] = 998,
  [999] = 999,
  [1000] = 1000,
  [1001] = 1001,
  [1002] = 1002,
  [1003] = 1003,
  [1004] = 1004,
  [1005] = 1005,
  [1006] = 1006,
  [1007] = 1007,
  [1008] = 1008,
  [1009] = 1009,
  [1010] = 1010,
  [1011] = 1011,
  [1012] = 1012,
  [1013] = 1013,
  [1014] = 1014,
  [1015] = 1015,
  [1016] = 1016,
  [1017] = 1017,
  [1018] = 1018,
  [1019] = 1019,
  [1020] = 1020,
  [1021] = 1021,
  [1022] = 987,
  [1023] = 1023,
  [1024] = 1024,
  [1025] = 1007,
  [1026] = 990,
  [1027] = 994,
  [1028] = 1028,
  [1029] = 1029,
  [1030] = 1030,
  [1031] = 1031,
  [1032] = 1032,
  [1033] = 1033,
  [1034] = 1034,
  [1035] = 1001,
  [1036] = 1036,
  [1037] = 1021,
  [1038] = 987,
  [1039] = 1039,
  [1040] = 1040,
  [1041] = 1007,
  [1042] = 993,
  [1043] = 1043,
  [1044] = 990,
  [1045] = 994,
  [1046] = 1034,
  [1047] = 1047,
  [1048] = 1029,
  [1049] = 994,
  [1050] = 1050,
  [1051] = 1029,
  [1052] = 1034,
  [1053] = 1001,
  [1054] = 1021,
  [1055] = 1055,
  [1056] = 1031,
  [1057] = 993,
  [1058] = 1058,
  [1059] = 1059,
  [1060] = 1033,
  [1061] = 1034,
  [1062] = 997,
  [1063] = 1001,
  [1064] = 1064,
  [1065] = 1021,
  [1066] = 1029,
  [1067] = 1067,
  [1068] = 1068,
  [1069] = 1069,
  [1070] = 1070,
  [1071] = 1071,
  [1072] = 1031,
  [1073] = 997,
  [1074] = 1074,
  [1075] = 1075,
  [1076] = 1076,
  [1077] = 997,
  [1078] = 993,
  [1079] = 1079,
  [1080] = 1019,
  [1081] = 1081,
  [1082] = 1082,
  [1083] = 1019,
  [1084] = 1033,
  [1085] = 1085,
  [1086] = 1086,
  [1087] = 1087,
  [1088] = 1088,
  [1089] = 1089,
  [1090] = 1090,
  [1091] = 1091,
  [1092] = 1092,
  [1093] = 1093,
  [1094] = 1094,
  [1095] = 1095,
  [1096] = 1096,
  [1097] = 1097,
  [1098] = 1098,
  [1099] = 1099,
  [1100] = 1100,
  [1101] = 1101,
  [1102] = 1102,
  [1103] = 1103,
  [1104] = 1104,
  [1105] = 1105,
  [1106] = 1106,
  [1107] = 1107,
  [1108] = 1108,
  [1109] = 1109,
  [1110] = 1110,
  [1111] = 1111,
  [1112] = 1112,
  [1113] = 1113,
  [1114] = 1114,
  [1115] = 1115,
  [1116] = 1116,
  [1117] = 1117,
  [1118] = 1118,
  [1119] = 1119,
  [1120] = 1120,
  [1121] = 1121,
  [1122] = 1122,
  [1123] = 1123,
  [1124] = 1124,
  [1125] = 1125,
  [1126] = 1126,
  [1127] = 1127,
  [1128] = 1128,
  [1129] = 1129,
  [1130] = 1130,
  [1131] = 1131,
  [1132] = 1095,
  [1133] = 1133,
  [1134] = 1134,
  [1135] = 1135,
  [1136] = 1136,
  [1137] = 1137,
  [1138] = 1126,
  [1139] = 1124,
  [1140] = 1140,
  [1141] = 1141,
  [1142] = 1142,
  [1143] = 1093,
  [1144] = 1111,
  [1145] = 1145,
  [1146] = 1146,
  [1147] = 1147,
  [1148] = 1148,
  [1149] = 1149,
  [1150] = 1150,
  [1151] = 1151,
  [1152] = 1152,
  [1153] = 1125,
  [1154] = 1154,
  [1155] = 1155,
  [1156] = 1156,
  [1157] = 1157,
  [1158] = 1158,
  [1159] = 1124,
  [1160] = 1160,
  [1161] = 1161,
  [1162] = 1126,
  [1163] = 1163,
  [1164] = 1164,
  [1165] = 1165,
  [1166] = 1136,
  [1167] = 1167,
  [1168] = 1168,
  [1169] = 1095,
  [1170] = 1170,
  [1171] = 1171,
  [1172] = 1172,
  [1173] = 1173,
  [1174] = 1174,
  [1175] = 1136,
  [1176] = 1176,
  [1177] = 1136,
  [1178] = 1178,
  [1179] = 1147,
  [1180] = 1180,
  [1181] = 1181,
  [1182] = 1182,
  [1183] = 1183,
  [1184] = 1184,
  [1185] = 1185,
  [1186] = 1186,
  [1187] = 1187,
  [1188] = 1188,
  [1189] = 1189,
  [1190] = 1190,
  [1191] = 1191,
  [1192] = 1192,
  [1193] = 1193,
  [1194] = 1194,
  [1195] = 1195,
  [1196] = 1093,
  [1197] = 1197,
  [1198] = 1111,
  [1199] = 1199,
  [1200] = 1200,
  [1201] = 1201,
  [1202] = 1202,
  [1203] = 1147,
  [1204] = 1204,
  [1205] = 1205,
  [1206] = 1206,
  [1207] = 1207,
  [1208] = 1208,
  [1209] = 1209,
  [1210] = 1210,
  [1211] = 1211,
  [1212] = 1212,
  [1213] = 1147,
  [1214] = 1125,
  [1215] = 1215,
  [1216] = 1216,
  [1217] = 1217,
  [1218] = 1218,
  [1219] = 1219,
  [1220] = 1220,
  [1221] = 1221,
  [1222] = 1222,
  [1223] = 1223,
  [1224] = 1224,
  [1225] = 1225,
  [1226] = 1226,
  [1227] = 1227,
  [1228] = 1228,
  [1229] = 1229,
  [1230] = 1228,
  [1231] = 1231,
  [1232] = 1232,
  [1233] = 1233,
  [1234] = 1234,
  [1235] = 1235,
  [1236] = 1236,
  [1237] = 1237,
  [1238] = 1238,
  [1239] = 1239,
  [1240] = 1240,
  [1241] = 1222,
  [1242] = 1242,
  [1243] = 1243,
  [1244] = 1244,
  [1245] = 1229,
  [1246] = 1243,
  [1247] = 1247,
  [1248] = 1248,
  [1249] = 1239,
  [1250] = 1243,
  [1251] = 1229,
  [1252] = 1252,
  [1253] = 1253,
  [1254] = 1254,
  [1255] = 1255,
  [1256] = 1243,
  [1257] = 1235,
  [1258] = 1258,
  [1259] = 1229,
  [1260] = 1260,
  [1261] = 1222,
  [1262] = 1262,
  [1263] = 1222,
  [1264] = 1264,
  [1265] = 1227,
  [1266] = 1227,
  [1267] = 1267,
  [1268] = 1268,
  [1269] = 1235,
  [1270] = 1270,
  [1271] = 1271,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(67);
      ADVANCE_MAP(
        '!', 26,
        '"', 75,
        '#', 220,
        '$', 204,
        '%', 132,
        '&', 146,
        '\'', 203,
        '(', 195,
        ')', 72,
        '*', 127,
        '+', 118,
        ',', 71,
        '-', 120,
        '.', 69,
        '/', 126,
        '0', 198,
        ':', 154,
        '<', 133,
        '=', 181,
        '>', 135,
        '@', 60,
        '[', 157,
        '\\', 30,
        ']', 158,
        '^', 150,
        'e', 248,
        'm', 238,
        'p', 245,
        's', 241,
        '{', 179,
        '|', 148,
        '}', 180,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(61);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(199);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(254);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '!', 26,
        '#', 220,
        '%', 132,
        '&', 146,
        '(', 195,
        ')', 72,
        '*', 127,
        '+', 118,
        ',', 71,
        '-', 123,
        '.', 68,
        '/', 126,
        ':', 154,
        '<', 133,
        '=', 181,
        '>', 135,
        '[', 157,
        ']', 158,
        '^', 150,
        '{', 179,
        '|', 148,
        '}', 180,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(254);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '!', 26,
        '#', 220,
        '%', 132,
        '&', 146,
        ')', 72,
        '*', 127,
        '+', 118,
        ',', 71,
        '-', 123,
        '.', 68,
        '/', 126,
        ':', 154,
        '<', 133,
        '=', 181,
        '>', 135,
        '[', 157,
        ']', 158,
        '^', 150,
        '{', 179,
        '|', 148,
        '}', 180,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(254);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '!', 26,
        '#', 220,
        '%', 131,
        '&', 145,
        '(', 70,
        ')', 72,
        '*', 128,
        '+', 117,
        ',', 71,
        '-', 124,
        '.', 68,
        '/', 125,
        ':', 153,
        '<', 134,
        '=', 28,
        '>', 136,
        '[', 157,
        ']', 158,
        '^', 149,
        '{', 179,
        '|', 147,
        '}', 180,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '!', 26,
        '#', 220,
        '%', 131,
        '&', 145,
        '(', 70,
        '*', 128,
        '+', 117,
        '-', 124,
        '/', 125,
        '<', 134,
        '=', 28,
        '>', 136,
        '^', 149,
        'e', 114,
        'i', 102,
        'm', 105,
        'p', 112,
        '{', 179,
        '|', 147,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '!', 26,
        '#', 220,
        '%', 131,
        '&', 145,
        ')', 72,
        '*', 128,
        '+', 117,
        ',', 71,
        '-', 124,
        '.', 68,
        '/', 125,
        '<', 134,
        '=', 28,
        '>', 136,
        ']', 158,
        '^', 149,
        '{', 179,
        '|', 147,
        '}', 180,
        '\t', 196,
        ' ', 196,
      );
      if (('\n' <= lookahead && lookahead <= '\r')) SKIP(6);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '!', 26,
        '#', 220,
        '%', 131,
        '&', 145,
        ')', 72,
        '*', 128,
        '+', 117,
        ',', 71,
        '-', 124,
        '.', 68,
        '/', 125,
        '<', 134,
        '=', 28,
        '>', 136,
        ']', 158,
        '^', 149,
        '{', 179,
        '|', 147,
        '}', 180,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(6);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '!', 26,
        '#', 220,
        '%', 131,
        '&', 145,
        ')', 72,
        '*', 128,
        '+', 117,
        '-', 119,
        '.', 23,
        '/', 125,
        '<', 134,
        '=', 28,
        '>', 136,
        '^', 149,
        'a', 107,
        'i', 96,
        'm', 104,
        'p', 112,
        's', 108,
        '|', 147,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(7);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        '!', 26,
        '#', 220,
        '%', 131,
        '&', 145,
        '*', 128,
        '+', 117,
        '-', 119,
        '/', 125,
        '<', 134,
        '=', 28,
        '>', 136,
        '^', 149,
        'a', 107,
        'i', 96,
        'm', 104,
        's', 108,
        '|', 147,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(8);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '!', 26,
        '#', 220,
        '%', 131,
        '&', 145,
        '*', 128,
        '+', 117,
        '-', 119,
        '/', 125,
        '<', 134,
        '=', 28,
        '>', 136,
        '^', 149,
        'e', 114,
        'i', 102,
        '|', 147,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(9);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        '!', 26,
        '#', 220,
        '%', 131,
        '&', 145,
        '*', 128,
        '+', 117,
        '-', 119,
        '/', 125,
        '<', 134,
        '=', 28,
        '>', 136,
        '^', 149,
        'i', 103,
        'm', 104,
        'p', 112,
        '|', 147,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(10);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 11:
      ADVANCE_MAP(
        '!', 26,
        '#', 220,
        '%', 131,
        '&', 145,
        '*', 128,
        '+', 117,
        '-', 119,
        '/', 125,
        '<', 134,
        '=', 28,
        '>', 136,
        '^', 149,
        'i', 103,
        'm', 104,
        '|', 147,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(11);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 12:
      ADVANCE_MAP(
        '!', 26,
        '#', 220,
        '%', 131,
        '&', 145,
        '*', 128,
        '+', 117,
        '-', 119,
        '/', 125,
        '<', 134,
        '=', 28,
        '>', 136,
        '^', 149,
        '|', 147,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(12);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 13:
      ADVANCE_MAP(
        '"', 75,
        '#', 220,
        '\'', 203,
        '(', 70,
        ')', 72,
        ',', 71,
        '-', 25,
        '0', 200,
        ']', 158,
        'm', 246,
        '{', 179,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(13);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(201);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(254);
      END_STATE();
    case 14:
      if (lookahead == '"') ADVANCE(75);
      if (lookahead == '#') ADVANCE(208);
      if (lookahead == '$') ADVANCE(204);
      if (lookahead == '\\') ADVANCE(30);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(209);
      if (lookahead != 0) ADVANCE(210);
      END_STATE();
    case 15:
      if (lookahead == '#') ADVANCE(220);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == ')') ADVANCE(72);
      if (lookahead == ']') ADVANCE(158);
      if (lookahead == 'm') ADVANCE(238);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(15);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(254);
      END_STATE();
    case 16:
      if (lookahead == '#') ADVANCE(220);
      if (lookahead == '(') ADVANCE(70);
      if (lookahead == '-') ADVANCE(29);
      if (lookahead == '@') ADVANCE(60);
      if (lookahead == 'm') ADVANCE(44);
      if (lookahead == 'p') ADVANCE(52);
      if (lookahead == '{') ADVANCE(179);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(16);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(254);
      END_STATE();
    case 17:
      if (lookahead == '#') ADVANCE(220);
      if (lookahead == ')') ADVANCE(72);
      if (lookahead == '-') ADVANCE(25);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '0') ADVANCE(200);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(17);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(201);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(254);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(223);
      END_STATE();
    case 18:
      if (lookahead == '#') ADVANCE(220);
      if (lookahead == 'a') ADVANCE(240);
      if (lookahead == 'e') ADVANCE(248);
      if (lookahead == 'i') ADVANCE(235);
      if (lookahead == 'p') ADVANCE(245);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(18);
      if (lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(254);
      END_STATE();
    case 19:
      if (lookahead == '#') ADVANCE(220);
      if (lookahead == 'a') ADVANCE(240);
      if (lookahead == 'e') ADVANCE(248);
      if (lookahead == 'i') ADVANCE(235);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(19);
      if (lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(254);
      END_STATE();
    case 20:
      if (lookahead == '#') ADVANCE(220);
      if (lookahead == 'e') ADVANCE(248);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(20);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 21:
      if (lookahead == '#') ADVANCE(220);
      if (lookahead == 'm') ADVANCE(246);
      if (lookahead == 'p') ADVANCE(245);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(21);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(254);
      END_STATE();
    case 22:
      if (lookahead == '#') ADVANCE(205);
      if (lookahead == '$') ADVANCE(204);
      if (lookahead == '\'') ADVANCE(203);
      if (lookahead == '\\') ADVANCE(30);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(206);
      if (lookahead != 0) ADVANCE(207);
      END_STATE();
    case 23:
      if (lookahead == '.') ADVANCE(24);
      END_STATE();
    case 24:
      if (lookahead == '.') ADVANCE(155);
      END_STATE();
    case 25:
      if (lookahead == '0') ADVANCE(200);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(201);
      END_STATE();
    case 26:
      if (lookahead == '=') ADVANCE(152);
      END_STATE();
    case 27:
      if (lookahead == '=') ADVANCE(182);
      END_STATE();
    case 28:
      if (lookahead == '=') ADVANCE(151);
      END_STATE();
    case 29:
      if (lookahead == '>') ADVANCE(156);
      END_STATE();
    case 30:
      if (lookahead == '\\') ADVANCE(213);
      if (lookahead == 'u') ADVANCE(215);
      if (lookahead == '"' ||
          lookahead == '$' ||
          lookahead == '\'' ||
          lookahead == '0' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(214);
      END_STATE();
    case 31:
      if (lookahead == 'a') ADVANCE(45);
      if (lookahead == 'm') ADVANCE(43);
      if (lookahead == 's') ADVANCE(47);
      END_STATE();
    case 32:
      if (lookahead == 'a') ADVANCE(49);
      END_STATE();
    case 33:
      if (lookahead == 'b') ADVANCE(217);
      END_STATE();
    case 34:
      if (lookahead == 'c') ADVANCE(177);
      END_STATE();
    case 35:
      if (lookahead == 'c') ADVANCE(176);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(175);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 38:
      if (lookahead == 'i') ADVANCE(35);
      END_STATE();
    case 39:
      if (lookahead == 'm') ADVANCE(51);
      END_STATE();
    case 40:
      if (lookahead == 'm') ADVANCE(43);
      END_STATE();
    case 41:
      if (lookahead == 'm') ADVANCE(53);
      END_STATE();
    case 42:
      if (lookahead == 'n') ADVANCE(34);
      END_STATE();
    case 43:
      if (lookahead == 'o') ADVANCE(54);
      if (lookahead == 'u') ADVANCE(48);
      END_STATE();
    case 44:
      if (lookahead == 'o') ADVANCE(55);
      END_STATE();
    case 45:
      if (lookahead == 's') ADVANCE(56);
      END_STATE();
    case 46:
      if (lookahead == 't') ADVANCE(169);
      END_STATE();
    case 47:
      if (lookahead == 't') ADVANCE(32);
      END_STATE();
    case 48:
      if (lookahead == 't') ADVANCE(174);
      END_STATE();
    case 49:
      if (lookahead == 't') ADVANCE(38);
      END_STATE();
    case 50:
      if (lookahead == 't') ADVANCE(178);
      END_STATE();
    case 51:
      if (lookahead == 'u') ADVANCE(46);
      END_STATE();
    case 52:
      if (lookahead == 'u') ADVANCE(33);
      END_STATE();
    case 53:
      if (lookahead == 'u') ADVANCE(50);
      END_STATE();
    case 54:
      if (lookahead == 'v') ADVANCE(36);
      END_STATE();
    case 55:
      if (lookahead == 'v') ADVANCE(37);
      END_STATE();
    case 56:
      if (lookahead == 'y') ADVANCE(42);
      END_STATE();
    case 57:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(58);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(197);
      END_STATE();
    case 58:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(197);
      END_STATE();
    case 59:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(202);
      END_STATE();
    case 60:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 61:
      if (eof) ADVANCE(67);
      ADVANCE_MAP(
        '!', 26,
        '"', 75,
        '#', 220,
        '$', 204,
        '%', 132,
        '&', 146,
        '\'', 203,
        '(', 70,
        ')', 72,
        '*', 127,
        '+', 118,
        ',', 71,
        '-', 120,
        '.', 69,
        '/', 126,
        '0', 198,
        ':', 154,
        '<', 133,
        '=', 181,
        '>', 135,
        '@', 60,
        '[', 157,
        '\\', 30,
        ']', 158,
        '^', 150,
        'e', 248,
        'm', 238,
        'p', 245,
        's', 241,
        '{', 179,
        '|', 148,
        '}', 180,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(61);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(199);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(254);
      END_STATE();
    case 62:
      if (eof) ADVANCE(67);
      ADVANCE_MAP(
        '!', 26,
        '"', 75,
        '#', 220,
        '%', 132,
        '&', 146,
        '\'', 203,
        '(', 195,
        '*', 127,
        '+', 118,
        '-', 121,
        '.', 68,
        '/', 126,
        '0', 198,
        ':', 27,
        '<', 133,
        '=', 181,
        '>', 135,
        '@', 60,
        '[', 157,
        '^', 150,
        'm', 222,
        '{', 179,
        '|', 148,
        '}', 180,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(64);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(199);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(223);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(254);
      END_STATE();
    case 63:
      if (eof) ADVANCE(67);
      ADVANCE_MAP(
        '!', 26,
        '"', 75,
        '#', 220,
        '%', 132,
        '&', 146,
        '\'', 203,
        '(', 70,
        ')', 72,
        '*', 127,
        '+', 118,
        ',', 71,
        '-', 120,
        '.', 68,
        '/', 126,
        '0', 198,
        ':', 27,
        '<', 133,
        '=', 181,
        '>', 135,
        '@', 60,
        '[', 157,
        ']', 158,
        '^', 150,
        'm', 222,
        '{', 179,
        '|', 148,
        '}', 180,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(63);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(199);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(223);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(254);
      END_STATE();
    case 64:
      if (eof) ADVANCE(67);
      ADVANCE_MAP(
        '!', 26,
        '"', 75,
        '#', 220,
        '%', 132,
        '&', 146,
        '\'', 203,
        '(', 70,
        '*', 127,
        '+', 118,
        '-', 121,
        '.', 68,
        '/', 126,
        '0', 198,
        ':', 27,
        '<', 133,
        '=', 181,
        '>', 135,
        '@', 60,
        '[', 157,
        '^', 150,
        'm', 222,
        '{', 179,
        '|', 148,
        '}', 180,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(64);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(199);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(223);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(254);
      END_STATE();
    case 65:
      if (eof) ADVANCE(67);
      ADVANCE_MAP(
        '!', 26,
        '"', 75,
        '#', 220,
        '%', 131,
        '&', 145,
        '\'', 203,
        '(', 70,
        '*', 128,
        '+', 117,
        '-', 122,
        '.', 68,
        '/', 125,
        '0', 198,
        '<', 134,
        '=', 28,
        '>', 136,
        '@', 60,
        '[', 157,
        '^', 149,
        'm', 222,
        '{', 179,
        '|', 147,
        '}', 180,
        '\t', 196,
        ' ', 196,
      );
      if (('\n' <= lookahead && lookahead <= '\r')) SKIP(66);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(199);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(223);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(254);
      END_STATE();
    case 66:
      if (eof) ADVANCE(67);
      ADVANCE_MAP(
        '!', 26,
        '"', 75,
        '#', 220,
        '%', 131,
        '&', 145,
        '\'', 203,
        '(', 70,
        '*', 128,
        '+', 117,
        '-', 122,
        '.', 68,
        '/', 125,
        '0', 198,
        '<', 134,
        '=', 28,
        '>', 136,
        '@', 60,
        '[', 157,
        '^', 149,
        'm', 222,
        '{', 179,
        '|', 147,
        '}', 180,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(66);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(199);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(223);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(254);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(24);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_extern);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_extern);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(aux_sym_extern_import_path_token1);
      if (lookahead == '\n') ADVANCE(78);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(76);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(aux_sym_extern_import_path_token1);
      if (lookahead == '#') ADVANCE(76);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(77);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#') ADVANCE(78);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(aux_sym_extern_import_path_token1);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(78);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'a') ADVANCE(110);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'b') ADVANCE(218);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'c') ADVANCE(167);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'c') ADVANCE(165);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'e') ADVANCE(163);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'e') ADVANCE(170);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'e') ADVANCE(106);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'e') ADVANCE(172);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'e') ADVANCE(171);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'i') ADVANCE(83);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'i') ADVANCE(99);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'i') ADVANCE(100);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'i') ADVANCE(101);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'l') ADVANCE(90);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'l') ADVANCE(91);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'l') ADVANCE(92);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'n') ADVANCE(93);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'n') ADVANCE(82);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'n') ADVANCE(73);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'n') ADVANCE(85);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'n') ADVANCE(87);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'n') ADVANCE(88);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'n') ADVANCE(94);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'n') ADVANCE(95);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'o') ADVANCE(113);
      if (lookahead == 'u') ADVANCE(109);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'o') ADVANCE(113);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'r') ADVANCE(98);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 's') ADVANCE(115);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 't') ADVANCE(80);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 't') ADVANCE(160);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 't') ADVANCE(89);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 't') ADVANCE(86);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'u') ADVANCE(81);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'v') ADVANCE(84);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'x') ADVANCE(111);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'y') ADVANCE(97);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(183);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '0') ADVANCE(198);
      if (lookahead == '=') ADVANCE(184);
      if (lookahead == '>') ADVANCE(156);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(199);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '0') ADVANCE(198);
      if (lookahead == '=') ADVANCE(184);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(199);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '0') ADVANCE(198);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(199);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(184);
      if (lookahead == '>') ADVANCE(156);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(156);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '=') ADVANCE(185);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(130);
      if (lookahead == '=') ADVANCE(186);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(129);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(187);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(188);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(140);
      if (lookahead == '=') ADVANCE(137);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(139);
      if (lookahead == '=') ADVANCE(137);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(138);
      if (lookahead == '>') ADVANCE(141);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(138);
      if (lookahead == '>') ADVANCE(142);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(189);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(190);
      if (lookahead == '>') ADVANCE(144);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(143);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(191);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '=') ADVANCE(192);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(193);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(194);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(182);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_rest_argument);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_mut);
      if (lookahead == '$') ADVANCE(252);
      if (lookahead == '?') ADVANCE(251);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(223);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_mut);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_mut);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_move);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_move);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_move);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_static);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_static);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_async);
      if (lookahead == ' ') ADVANCE(39);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_async);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_asyncmut);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_inline);
      if (lookahead == ' ') ADVANCE(31);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_inline);
      if (lookahead == ' ') ADVANCE(40);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_inline);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_inline);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_inlinemut);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_inlinemove);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_inlinestatic);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_inlineasync);
      if (lookahead == ' ') ADVANCE(41);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_inlineasyncmut);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(151);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_LPAREN2);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(aux_sym_return_token1);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(196);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(197);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(58);
      if (lookahead == 'x') ADVANCE(59);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(199);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(58);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(199);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == 'x') ADVANCE(59);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(201);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_integer);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(201);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_integer);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(202);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '{') ADVANCE(216);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '\n') ADVANCE(207);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(205);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '#') ADVANCE(205);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(206);
      if (lookahead != 0 &&
          lookahead != '#' &&
          lookahead != '$' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(207);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(207);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '\n') ADVANCE(210);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\') ADVANCE(208);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '#') ADVANCE(208);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(209);
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead) &&
          lookahead != '\\') ADVANCE(210);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\') ADVANCE(210);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_BSLASHu_LBRACE);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(aux_sym_escape_sequence_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(212);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_BSLASH_BSLASH);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(aux_sym_escape_sequence_token2);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(aux_sym_escape_sequence_token2);
      if (lookahead == '{') ADVANCE(211);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym_visibility);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym_visibility);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(79);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(116);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym_visibility);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(220);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$') ADVANCE(252);
      if (lookahead == '?') ADVANCE(251);
      if (lookahead == 't') ADVANCE(159);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(223);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$') ADVANCE(252);
      if (lookahead == '?') ADVANCE(251);
      if (lookahead == 'u') ADVANCE(221);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(223);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$') ADVANCE(252);
      if (lookahead == '?') ADVANCE(251);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(223);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'b') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(166);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(168);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(239);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(164);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(173);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(226);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(237);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(232);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(74);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(233);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(227);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(230);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(247);
      if (lookahead == 'u') ADVANCE(243);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(234);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(249);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(228);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(161);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(231);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(243);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'v') ADVANCE(229);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'x') ADVANCE(242);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(236);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(250);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_identifier_with_special);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_identifier_with_special);
      if (lookahead == '?') ADVANCE(251);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(252);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_field);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(253);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_constant);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(254);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        '_', 1,
        'a', 2,
        'b', 3,
        'c', 4,
        'e', 5,
        'f', 6,
        'i', 7,
        'l', 8,
        'm', 9,
        'n', 10,
        'o', 11,
        'r', 12,
        's', 13,
        't', 14,
        'u', 15,
        'w', 16,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      ACCEPT_TOKEN(sym_wildcard_pattern);
      END_STATE();
    case 2:
      if (lookahead == 'n') ADVANCE(17);
      if (lookahead == 's') ADVANCE(18);
      END_STATE();
    case 3:
      if (lookahead == 'r') ADVANCE(19);
      if (lookahead == 'u') ADVANCE(20);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(21);
      if (lookahead == 'o') ADVANCE(22);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(23);
      if (lookahead == 'n') ADVANCE(24);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(25);
      if (lookahead == 'n') ADVANCE(26);
      if (lookahead == 'o') ADVANCE(27);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(28);
      if (lookahead == 'm') ADVANCE(29);
      if (lookahead == 'n') ADVANCE(30);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(31);
      if (lookahead == 'o') ADVANCE(32);
      END_STATE();
    case 9:
      if (lookahead == 'a') ADVANCE(33);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(34);
      if (lookahead == 'i') ADVANCE(35);
      END_STATE();
    case 11:
      if (lookahead == 'r') ADVANCE(36);
      END_STATE();
    case 12:
      if (lookahead == 'e') ADVANCE(37);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(38);
      END_STATE();
    case 14:
      if (lookahead == 'h') ADVANCE(39);
      if (lookahead == 'r') ADVANCE(40);
      if (lookahead == 'y') ADVANCE(41);
      END_STATE();
    case 15:
      if (lookahead == 'n') ADVANCE(42);
      END_STATE();
    case 16:
      if (lookahead == 'h') ADVANCE(43);
      END_STATE();
    case 17:
      if (lookahead == 'd') ADVANCE(44);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 19:
      if (lookahead == 'e') ADVANCE(45);
      END_STATE();
    case 20:
      if (lookahead == 'i') ADVANCE(46);
      END_STATE();
    case 21:
      if (lookahead == 's') ADVANCE(47);
      END_STATE();
    case 22:
      if (lookahead == 'p') ADVANCE(48);
      END_STATE();
    case 23:
      if (lookahead == 's') ADVANCE(49);
      END_STATE();
    case 24:
      if (lookahead == 'u') ADVANCE(50);
      END_STATE();
    case 25:
      if (lookahead == 'l') ADVANCE(51);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_fn);
      END_STATE();
    case 27:
      if (lookahead == 'r') ADVANCE(52);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 29:
      if (lookahead == 'p') ADVANCE(53);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 31:
      if (lookahead == 't') ADVANCE(54);
      END_STATE();
    case 32:
      if (lookahead == 'o') ADVANCE(55);
      END_STATE();
    case 33:
      if (lookahead == 't') ADVANCE(56);
      END_STATE();
    case 34:
      if (lookahead == 'x') ADVANCE(57);
      END_STATE();
    case 35:
      if (lookahead == 'l') ADVANCE(58);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 37:
      if (lookahead == 'c') ADVANCE(59);
      if (lookahead == 'f') ADVANCE(60);
      if (lookahead == 't') ADVANCE(61);
      END_STATE();
    case 38:
      if (lookahead == 'l') ADVANCE(62);
      END_STATE();
    case 39:
      if (lookahead == 'r') ADVANCE(63);
      END_STATE();
    case 40:
      if (lookahead == 'a') ADVANCE(64);
      if (lookahead == 'u') ADVANCE(65);
      if (lookahead == 'y') ADVANCE(66);
      END_STATE();
    case 41:
      if (lookahead == 'p') ADVANCE(67);
      END_STATE();
    case 42:
      if (lookahead == 'i') ADVANCE(68);
      END_STATE();
    case 43:
      if (lookahead == 'i') ADVANCE(69);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 45:
      if (lookahead == 'a') ADVANCE(70);
      END_STATE();
    case 46:
      if (lookahead == 'l') ADVANCE(71);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(72);
      END_STATE();
    case 48:
      if (lookahead == 'y') ADVANCE(73);
      END_STATE();
    case 49:
      if (lookahead == 'e') ADVANCE(74);
      END_STATE();
    case 50:
      if (lookahead == 'm') ADVANCE(75);
      END_STATE();
    case 51:
      if (lookahead == 's') ADVANCE(76);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 53:
      if (lookahead == 'l') ADVANCE(77);
      if (lookahead == 'o') ADVANCE(78);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 55:
      if (lookahead == 'p') ADVANCE(79);
      END_STATE();
    case 56:
      if (lookahead == 'c') ADVANCE(80);
      END_STATE();
    case 57:
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_nil);
      END_STATE();
    case 59:
      if (lookahead == 'o') ADVANCE(82);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_ref);
      END_STATE();
    case 61:
      if (lookahead == 'u') ADVANCE(83);
      END_STATE();
    case 62:
      if (lookahead == 'f') ADVANCE(84);
      END_STATE();
    case 63:
      if (lookahead == 'o') ADVANCE(85);
      END_STATE();
    case 64:
      if (lookahead == 'i') ADVANCE(86);
      END_STATE();
    case 65:
      if (lookahead == 'e') ADVANCE(87);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(88);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_uni);
      END_STATE();
    case 69:
      if (lookahead == 'l') ADVANCE(89);
      END_STATE();
    case 70:
      if (lookahead == 'k') ADVANCE(90);
      END_STATE();
    case 71:
      if (lookahead == 't') ADVANCE(91);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_copy);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 76:
      if (lookahead == 'e') ADVANCE(92);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_impl);
      END_STATE();
    case 78:
      if (lookahead == 'r') ADVANCE(93);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_loop);
      END_STATE();
    case 80:
      if (lookahead == 'h') ADVANCE(94);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_next);
      END_STATE();
    case 82:
      if (lookahead == 'v') ADVANCE(95);
      END_STATE();
    case 83:
      if (lookahead == 'r') ADVANCE(96);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_self);
      END_STATE();
    case 85:
      if (lookahead == 'w') ADVANCE(97);
      END_STATE();
    case 86:
      if (lookahead == 't') ADVANCE(98);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 89:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_break);
      END_STATE();
    case 91:
      if (lookahead == 'i') ADVANCE(100);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 93:
      if (lookahead == 't') ADVANCE(101);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_match);
      END_STATE();
    case 95:
      if (lookahead == 'e') ADVANCE(102);
      END_STATE();
    case 96:
      if (lookahead == 'n') ADVANCE(103);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_throw);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_trait);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 100:
      if (lookahead == 'n') ADVANCE(104);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 102:
      if (lookahead == 'r') ADVANCE(105);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_builtin);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_recover);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 63},
  [2] = {.lex_state = 63},
  [3] = {.lex_state = 63},
  [4] = {.lex_state = 63},
  [5] = {.lex_state = 63},
  [6] = {.lex_state = 63},
  [7] = {.lex_state = 63},
  [8] = {.lex_state = 62},
  [9] = {.lex_state = 62},
  [10] = {.lex_state = 63},
  [11] = {.lex_state = 62},
  [12] = {.lex_state = 63},
  [13] = {.lex_state = 63},
  [14] = {.lex_state = 63},
  [15] = {.lex_state = 63},
  [16] = {.lex_state = 62},
  [17] = {.lex_state = 63},
  [18] = {.lex_state = 63},
  [19] = {.lex_state = 63},
  [20] = {.lex_state = 63},
  [21] = {.lex_state = 63},
  [22] = {.lex_state = 63},
  [23] = {.lex_state = 63},
  [24] = {.lex_state = 63},
  [25] = {.lex_state = 63},
  [26] = {.lex_state = 63},
  [27] = {.lex_state = 62},
  [28] = {.lex_state = 62},
  [29] = {.lex_state = 63},
  [30] = {.lex_state = 63},
  [31] = {.lex_state = 63},
  [32] = {.lex_state = 63},
  [33] = {.lex_state = 63},
  [34] = {.lex_state = 63},
  [35] = {.lex_state = 63},
  [36] = {.lex_state = 63},
  [37] = {.lex_state = 63},
  [38] = {.lex_state = 63},
  [39] = {.lex_state = 63},
  [40] = {.lex_state = 63},
  [41] = {.lex_state = 63},
  [42] = {.lex_state = 63},
  [43] = {.lex_state = 63},
  [44] = {.lex_state = 63},
  [45] = {.lex_state = 63},
  [46] = {.lex_state = 63},
  [47] = {.lex_state = 63},
  [48] = {.lex_state = 63},
  [49] = {.lex_state = 63},
  [50] = {.lex_state = 63},
  [51] = {.lex_state = 63},
  [52] = {.lex_state = 63},
  [53] = {.lex_state = 63},
  [54] = {.lex_state = 63},
  [55] = {.lex_state = 63},
  [56] = {.lex_state = 63},
  [57] = {.lex_state = 63},
  [58] = {.lex_state = 63},
  [59] = {.lex_state = 63},
  [60] = {.lex_state = 63},
  [61] = {.lex_state = 63},
  [62] = {.lex_state = 63},
  [63] = {.lex_state = 63},
  [64] = {.lex_state = 63},
  [65] = {.lex_state = 63},
  [66] = {.lex_state = 63},
  [67] = {.lex_state = 63},
  [68] = {.lex_state = 63},
  [69] = {.lex_state = 63},
  [70] = {.lex_state = 63},
  [71] = {.lex_state = 63},
  [72] = {.lex_state = 63},
  [73] = {.lex_state = 63},
  [74] = {.lex_state = 63},
  [75] = {.lex_state = 63},
  [76] = {.lex_state = 63},
  [77] = {.lex_state = 63},
  [78] = {.lex_state = 63},
  [79] = {.lex_state = 63},
  [80] = {.lex_state = 63},
  [81] = {.lex_state = 63},
  [82] = {.lex_state = 63},
  [83] = {.lex_state = 63},
  [84] = {.lex_state = 63},
  [85] = {.lex_state = 63},
  [86] = {.lex_state = 63},
  [87] = {.lex_state = 63},
  [88] = {.lex_state = 63},
  [89] = {.lex_state = 63},
  [90] = {.lex_state = 63},
  [91] = {.lex_state = 63},
  [92] = {.lex_state = 63},
  [93] = {.lex_state = 63},
  [94] = {.lex_state = 63},
  [95] = {.lex_state = 63},
  [96] = {.lex_state = 63},
  [97] = {.lex_state = 63},
  [98] = {.lex_state = 63},
  [99] = {.lex_state = 63},
  [100] = {.lex_state = 63},
  [101] = {.lex_state = 63},
  [102] = {.lex_state = 63},
  [103] = {.lex_state = 63},
  [104] = {.lex_state = 63},
  [105] = {.lex_state = 63},
  [106] = {.lex_state = 63},
  [107] = {.lex_state = 63},
  [108] = {.lex_state = 63},
  [109] = {.lex_state = 63},
  [110] = {.lex_state = 63},
  [111] = {.lex_state = 63},
  [112] = {.lex_state = 63},
  [113] = {.lex_state = 63},
  [114] = {.lex_state = 63},
  [115] = {.lex_state = 63},
  [116] = {.lex_state = 63},
  [117] = {.lex_state = 63},
  [118] = {.lex_state = 63},
  [119] = {.lex_state = 63},
  [120] = {.lex_state = 63},
  [121] = {.lex_state = 63},
  [122] = {.lex_state = 63},
  [123] = {.lex_state = 63},
  [124] = {.lex_state = 63},
  [125] = {.lex_state = 63},
  [126] = {.lex_state = 63},
  [127] = {.lex_state = 63},
  [128] = {.lex_state = 63},
  [129] = {.lex_state = 63},
  [130] = {.lex_state = 63},
  [131] = {.lex_state = 63},
  [132] = {.lex_state = 63},
  [133] = {.lex_state = 63},
  [134] = {.lex_state = 63},
  [135] = {.lex_state = 63},
  [136] = {.lex_state = 63},
  [137] = {.lex_state = 63},
  [138] = {.lex_state = 63},
  [139] = {.lex_state = 63},
  [140] = {.lex_state = 63},
  [141] = {.lex_state = 63},
  [142] = {.lex_state = 63},
  [143] = {.lex_state = 63},
  [144] = {.lex_state = 63},
  [145] = {.lex_state = 63},
  [146] = {.lex_state = 63},
  [147] = {.lex_state = 63},
  [148] = {.lex_state = 63},
  [149] = {.lex_state = 63},
  [150] = {.lex_state = 63},
  [151] = {.lex_state = 63},
  [152] = {.lex_state = 63},
  [153] = {.lex_state = 63},
  [154] = {.lex_state = 63},
  [155] = {.lex_state = 63},
  [156] = {.lex_state = 63},
  [157] = {.lex_state = 63},
  [158] = {.lex_state = 63},
  [159] = {.lex_state = 63},
  [160] = {.lex_state = 63},
  [161] = {.lex_state = 63},
  [162] = {.lex_state = 63},
  [163] = {.lex_state = 63},
  [164] = {.lex_state = 63},
  [165] = {.lex_state = 63},
  [166] = {.lex_state = 63},
  [167] = {.lex_state = 63},
  [168] = {.lex_state = 63},
  [169] = {.lex_state = 63},
  [170] = {.lex_state = 63},
  [171] = {.lex_state = 63},
  [172] = {.lex_state = 63},
  [173] = {.lex_state = 63},
  [174] = {.lex_state = 63},
  [175] = {.lex_state = 63},
  [176] = {.lex_state = 63},
  [177] = {.lex_state = 63},
  [178] = {.lex_state = 62},
  [179] = {.lex_state = 63},
  [180] = {.lex_state = 63},
  [181] = {.lex_state = 62},
  [182] = {.lex_state = 63},
  [183] = {.lex_state = 63},
  [184] = {.lex_state = 62},
  [185] = {.lex_state = 62},
  [186] = {.lex_state = 63},
  [187] = {.lex_state = 65},
  [188] = {.lex_state = 63},
  [189] = {.lex_state = 62},
  [190] = {.lex_state = 63},
  [191] = {.lex_state = 63},
  [192] = {.lex_state = 63},
  [193] = {.lex_state = 63},
  [194] = {.lex_state = 63},
  [195] = {.lex_state = 63},
  [196] = {.lex_state = 63},
  [197] = {.lex_state = 63},
  [198] = {.lex_state = 63},
  [199] = {.lex_state = 63},
  [200] = {.lex_state = 63},
  [201] = {.lex_state = 63},
  [202] = {.lex_state = 63},
  [203] = {.lex_state = 63},
  [204] = {.lex_state = 63},
  [205] = {.lex_state = 63},
  [206] = {.lex_state = 63},
  [207] = {.lex_state = 63},
  [208] = {.lex_state = 63},
  [209] = {.lex_state = 63},
  [210] = {.lex_state = 63},
  [211] = {.lex_state = 63},
  [212] = {.lex_state = 63},
  [213] = {.lex_state = 63},
  [214] = {.lex_state = 63},
  [215] = {.lex_state = 63},
  [216] = {.lex_state = 63},
  [217] = {.lex_state = 63},
  [218] = {.lex_state = 63},
  [219] = {.lex_state = 63},
  [220] = {.lex_state = 63},
  [221] = {.lex_state = 63},
  [222] = {.lex_state = 63},
  [223] = {.lex_state = 63},
  [224] = {.lex_state = 63},
  [225] = {.lex_state = 63},
  [226] = {.lex_state = 63},
  [227] = {.lex_state = 63},
  [228] = {.lex_state = 63},
  [229] = {.lex_state = 63},
  [230] = {.lex_state = 63},
  [231] = {.lex_state = 63},
  [232] = {.lex_state = 63},
  [233] = {.lex_state = 63},
  [234] = {.lex_state = 63},
  [235] = {.lex_state = 63},
  [236] = {.lex_state = 63},
  [237] = {.lex_state = 63},
  [238] = {.lex_state = 63},
  [239] = {.lex_state = 63},
  [240] = {.lex_state = 63},
  [241] = {.lex_state = 63},
  [242] = {.lex_state = 63},
  [243] = {.lex_state = 63},
  [244] = {.lex_state = 63},
  [245] = {.lex_state = 63},
  [246] = {.lex_state = 63},
  [247] = {.lex_state = 63},
  [248] = {.lex_state = 63},
  [249] = {.lex_state = 63},
  [250] = {.lex_state = 63},
  [251] = {.lex_state = 63},
  [252] = {.lex_state = 63},
  [253] = {.lex_state = 63},
  [254] = {.lex_state = 63},
  [255] = {.lex_state = 63},
  [256] = {.lex_state = 63},
  [257] = {.lex_state = 63},
  [258] = {.lex_state = 63},
  [259] = {.lex_state = 63},
  [260] = {.lex_state = 63},
  [261] = {.lex_state = 62},
  [262] = {.lex_state = 63},
  [263] = {.lex_state = 63},
  [264] = {.lex_state = 62},
  [265] = {.lex_state = 63},
  [266] = {.lex_state = 62},
  [267] = {.lex_state = 62},
  [268] = {.lex_state = 63},
  [269] = {.lex_state = 63},
  [270] = {.lex_state = 63},
  [271] = {.lex_state = 63},
  [272] = {.lex_state = 63},
  [273] = {.lex_state = 62},
  [274] = {.lex_state = 63},
  [275] = {.lex_state = 63},
  [276] = {.lex_state = 65},
  [277] = {.lex_state = 63},
  [278] = {.lex_state = 63},
  [279] = {.lex_state = 63},
  [280] = {.lex_state = 63},
  [281] = {.lex_state = 63},
  [282] = {.lex_state = 63},
  [283] = {.lex_state = 63},
  [284] = {.lex_state = 63},
  [285] = {.lex_state = 63},
  [286] = {.lex_state = 63},
  [287] = {.lex_state = 63},
  [288] = {.lex_state = 63},
  [289] = {.lex_state = 63},
  [290] = {.lex_state = 63},
  [291] = {.lex_state = 63},
  [292] = {.lex_state = 63},
  [293] = {.lex_state = 63},
  [294] = {.lex_state = 63},
  [295] = {.lex_state = 63},
  [296] = {.lex_state = 63},
  [297] = {.lex_state = 63},
  [298] = {.lex_state = 63},
  [299] = {.lex_state = 63},
  [300] = {.lex_state = 63},
  [301] = {.lex_state = 63},
  [302] = {.lex_state = 63},
  [303] = {.lex_state = 63},
  [304] = {.lex_state = 63},
  [305] = {.lex_state = 63},
  [306] = {.lex_state = 63},
  [307] = {.lex_state = 63},
  [308] = {.lex_state = 63},
  [309] = {.lex_state = 63},
  [310] = {.lex_state = 63},
  [311] = {.lex_state = 63},
  [312] = {.lex_state = 63},
  [313] = {.lex_state = 63},
  [314] = {.lex_state = 63},
  [315] = {.lex_state = 63},
  [316] = {.lex_state = 63},
  [317] = {.lex_state = 63},
  [318] = {.lex_state = 63},
  [319] = {.lex_state = 63},
  [320] = {.lex_state = 63},
  [321] = {.lex_state = 63},
  [322] = {.lex_state = 63},
  [323] = {.lex_state = 63},
  [324] = {.lex_state = 63},
  [325] = {.lex_state = 63},
  [326] = {.lex_state = 63},
  [327] = {.lex_state = 63},
  [328] = {.lex_state = 63},
  [329] = {.lex_state = 63},
  [330] = {.lex_state = 63},
  [331] = {.lex_state = 63},
  [332] = {.lex_state = 63},
  [333] = {.lex_state = 63},
  [334] = {.lex_state = 63},
  [335] = {.lex_state = 63},
  [336] = {.lex_state = 63},
  [337] = {.lex_state = 63},
  [338] = {.lex_state = 63},
  [339] = {.lex_state = 63},
  [340] = {.lex_state = 63},
  [341] = {.lex_state = 63},
  [342] = {.lex_state = 63},
  [343] = {.lex_state = 63},
  [344] = {.lex_state = 63},
  [345] = {.lex_state = 63},
  [346] = {.lex_state = 63},
  [347] = {.lex_state = 63},
  [348] = {.lex_state = 63},
  [349] = {.lex_state = 63},
  [350] = {.lex_state = 63},
  [351] = {.lex_state = 63},
  [352] = {.lex_state = 63},
  [353] = {.lex_state = 63},
  [354] = {.lex_state = 1},
  [355] = {.lex_state = 1},
  [356] = {.lex_state = 1},
  [357] = {.lex_state = 1},
  [358] = {.lex_state = 1},
  [359] = {.lex_state = 1},
  [360] = {.lex_state = 1},
  [361] = {.lex_state = 63},
  [362] = {.lex_state = 63},
  [363] = {.lex_state = 1},
  [364] = {.lex_state = 63},
  [365] = {.lex_state = 1},
  [366] = {.lex_state = 63},
  [367] = {.lex_state = 63},
  [368] = {.lex_state = 63},
  [369] = {.lex_state = 63},
  [370] = {.lex_state = 63},
  [371] = {.lex_state = 63},
  [372] = {.lex_state = 63},
  [373] = {.lex_state = 63},
  [374] = {.lex_state = 63},
  [375] = {.lex_state = 63},
  [376] = {.lex_state = 63},
  [377] = {.lex_state = 63},
  [378] = {.lex_state = 63},
  [379] = {.lex_state = 63},
  [380] = {.lex_state = 63},
  [381] = {.lex_state = 63},
  [382] = {.lex_state = 63},
  [383] = {.lex_state = 63},
  [384] = {.lex_state = 63},
  [385] = {.lex_state = 63},
  [386] = {.lex_state = 63},
  [387] = {.lex_state = 63},
  [388] = {.lex_state = 63},
  [389] = {.lex_state = 63},
  [390] = {.lex_state = 63},
  [391] = {.lex_state = 63},
  [392] = {.lex_state = 63},
  [393] = {.lex_state = 63},
  [394] = {.lex_state = 63},
  [395] = {.lex_state = 63},
  [396] = {.lex_state = 63},
  [397] = {.lex_state = 63},
  [398] = {.lex_state = 63},
  [399] = {.lex_state = 63},
  [400] = {.lex_state = 63},
  [401] = {.lex_state = 63},
  [402] = {.lex_state = 63},
  [403] = {.lex_state = 63},
  [404] = {.lex_state = 63},
  [405] = {.lex_state = 63},
  [406] = {.lex_state = 63},
  [407] = {.lex_state = 63},
  [408] = {.lex_state = 63},
  [409] = {.lex_state = 63},
  [410] = {.lex_state = 63},
  [411] = {.lex_state = 63},
  [412] = {.lex_state = 63},
  [413] = {.lex_state = 63},
  [414] = {.lex_state = 63},
  [415] = {.lex_state = 63},
  [416] = {.lex_state = 63},
  [417] = {.lex_state = 63},
  [418] = {.lex_state = 63},
  [419] = {.lex_state = 63},
  [420] = {.lex_state = 63},
  [421] = {.lex_state = 63},
  [422] = {.lex_state = 63},
  [423] = {.lex_state = 63},
  [424] = {.lex_state = 63},
  [425] = {.lex_state = 63},
  [426] = {.lex_state = 63},
  [427] = {.lex_state = 63},
  [428] = {.lex_state = 63},
  [429] = {.lex_state = 63},
  [430] = {.lex_state = 63},
  [431] = {.lex_state = 63},
  [432] = {.lex_state = 63},
  [433] = {.lex_state = 63},
  [434] = {.lex_state = 63},
  [435] = {.lex_state = 63},
  [436] = {.lex_state = 63},
  [437] = {.lex_state = 63},
  [438] = {.lex_state = 63},
  [439] = {.lex_state = 63},
  [440] = {.lex_state = 63},
  [441] = {.lex_state = 63},
  [442] = {.lex_state = 63},
  [443] = {.lex_state = 63},
  [444] = {.lex_state = 63},
  [445] = {.lex_state = 63},
  [446] = {.lex_state = 63},
  [447] = {.lex_state = 63},
  [448] = {.lex_state = 63},
  [449] = {.lex_state = 63},
  [450] = {.lex_state = 63},
  [451] = {.lex_state = 63},
  [452] = {.lex_state = 63},
  [453] = {.lex_state = 63},
  [454] = {.lex_state = 63},
  [455] = {.lex_state = 63},
  [456] = {.lex_state = 63},
  [457] = {.lex_state = 63},
  [458] = {.lex_state = 63},
  [459] = {.lex_state = 63},
  [460] = {.lex_state = 63},
  [461] = {.lex_state = 63},
  [462] = {.lex_state = 63},
  [463] = {.lex_state = 63},
  [464] = {.lex_state = 63},
  [465] = {.lex_state = 63},
  [466] = {.lex_state = 63},
  [467] = {.lex_state = 63},
  [468] = {.lex_state = 63},
  [469] = {.lex_state = 63},
  [470] = {.lex_state = 63},
  [471] = {.lex_state = 63},
  [472] = {.lex_state = 63},
  [473] = {.lex_state = 63},
  [474] = {.lex_state = 63},
  [475] = {.lex_state = 63},
  [476] = {.lex_state = 63},
  [477] = {.lex_state = 63},
  [478] = {.lex_state = 63},
  [479] = {.lex_state = 63},
  [480] = {.lex_state = 63},
  [481] = {.lex_state = 63},
  [482] = {.lex_state = 63},
  [483] = {.lex_state = 63},
  [484] = {.lex_state = 63},
  [485] = {.lex_state = 63},
  [486] = {.lex_state = 63},
  [487] = {.lex_state = 63},
  [488] = {.lex_state = 63},
  [489] = {.lex_state = 63},
  [490] = {.lex_state = 63},
  [491] = {.lex_state = 63},
  [492] = {.lex_state = 63},
  [493] = {.lex_state = 3},
  [494] = {.lex_state = 1},
  [495] = {.lex_state = 1},
  [496] = {.lex_state = 1},
  [497] = {.lex_state = 7},
  [498] = {.lex_state = 1},
  [499] = {.lex_state = 1},
  [500] = {.lex_state = 1},
  [501] = {.lex_state = 1},
  [502] = {.lex_state = 1},
  [503] = {.lex_state = 1},
  [504] = {.lex_state = 4},
  [505] = {.lex_state = 8},
  [506] = {.lex_state = 1},
  [507] = {.lex_state = 1},
  [508] = {.lex_state = 1},
  [509] = {.lex_state = 1},
  [510] = {.lex_state = 1},
  [511] = {.lex_state = 1},
  [512] = {.lex_state = 1},
  [513] = {.lex_state = 1},
  [514] = {.lex_state = 1},
  [515] = {.lex_state = 1},
  [516] = {.lex_state = 1},
  [517] = {.lex_state = 1},
  [518] = {.lex_state = 1},
  [519] = {.lex_state = 1},
  [520] = {.lex_state = 1},
  [521] = {.lex_state = 1},
  [522] = {.lex_state = 1},
  [523] = {.lex_state = 1},
  [524] = {.lex_state = 1},
  [525] = {.lex_state = 1},
  [526] = {.lex_state = 1},
  [527] = {.lex_state = 1},
  [528] = {.lex_state = 1},
  [529] = {.lex_state = 1},
  [530] = {.lex_state = 1},
  [531] = {.lex_state = 1},
  [532] = {.lex_state = 1},
  [533] = {.lex_state = 1},
  [534] = {.lex_state = 1},
  [535] = {.lex_state = 1},
  [536] = {.lex_state = 1},
  [537] = {.lex_state = 1},
  [538] = {.lex_state = 1},
  [539] = {.lex_state = 1},
  [540] = {.lex_state = 1},
  [541] = {.lex_state = 1},
  [542] = {.lex_state = 1},
  [543] = {.lex_state = 1},
  [544] = {.lex_state = 1},
  [545] = {.lex_state = 1},
  [546] = {.lex_state = 1},
  [547] = {.lex_state = 1},
  [548] = {.lex_state = 1},
  [549] = {.lex_state = 1},
  [550] = {.lex_state = 1},
  [551] = {.lex_state = 1},
  [552] = {.lex_state = 1},
  [553] = {.lex_state = 1},
  [554] = {.lex_state = 1},
  [555] = {.lex_state = 1},
  [556] = {.lex_state = 1},
  [557] = {.lex_state = 1},
  [558] = {.lex_state = 1},
  [559] = {.lex_state = 1},
  [560] = {.lex_state = 1},
  [561] = {.lex_state = 1},
  [562] = {.lex_state = 1},
  [563] = {.lex_state = 1},
  [564] = {.lex_state = 1},
  [565] = {.lex_state = 1},
  [566] = {.lex_state = 1},
  [567] = {.lex_state = 5},
  [568] = {.lex_state = 1},
  [569] = {.lex_state = 1},
  [570] = {.lex_state = 1},
  [571] = {.lex_state = 1},
  [572] = {.lex_state = 1},
  [573] = {.lex_state = 1},
  [574] = {.lex_state = 1},
  [575] = {.lex_state = 1},
  [576] = {.lex_state = 1},
  [577] = {.lex_state = 1},
  [578] = {.lex_state = 1},
  [579] = {.lex_state = 1},
  [580] = {.lex_state = 1},
  [581] = {.lex_state = 1},
  [582] = {.lex_state = 1},
  [583] = {.lex_state = 1},
  [584] = {.lex_state = 1},
  [585] = {.lex_state = 1},
  [586] = {.lex_state = 1},
  [587] = {.lex_state = 1},
  [588] = {.lex_state = 10},
  [589] = {.lex_state = 1},
  [590] = {.lex_state = 11},
  [591] = {.lex_state = 5},
  [592] = {.lex_state = 1},
  [593] = {.lex_state = 1},
  [594] = {.lex_state = 1},
  [595] = {.lex_state = 1},
  [596] = {.lex_state = 1},
  [597] = {.lex_state = 1},
  [598] = {.lex_state = 1},
  [599] = {.lex_state = 1},
  [600] = {.lex_state = 1},
  [601] = {.lex_state = 1},
  [602] = {.lex_state = 1},
  [603] = {.lex_state = 1},
  [604] = {.lex_state = 1},
  [605] = {.lex_state = 1},
  [606] = {.lex_state = 1},
  [607] = {.lex_state = 1},
  [608] = {.lex_state = 1},
  [609] = {.lex_state = 1},
  [610] = {.lex_state = 1},
  [611] = {.lex_state = 1},
  [612] = {.lex_state = 1},
  [613] = {.lex_state = 1},
  [614] = {.lex_state = 1},
  [615] = {.lex_state = 1},
  [616] = {.lex_state = 1},
  [617] = {.lex_state = 1},
  [618] = {.lex_state = 1},
  [619] = {.lex_state = 1},
  [620] = {.lex_state = 1},
  [621] = {.lex_state = 1},
  [622] = {.lex_state = 1},
  [623] = {.lex_state = 1},
  [624] = {.lex_state = 1},
  [625] = {.lex_state = 1},
  [626] = {.lex_state = 1},
  [627] = {.lex_state = 1},
  [628] = {.lex_state = 1},
  [629] = {.lex_state = 1},
  [630] = {.lex_state = 1},
  [631] = {.lex_state = 1},
  [632] = {.lex_state = 1},
  [633] = {.lex_state = 1},
  [634] = {.lex_state = 1},
  [635] = {.lex_state = 1},
  [636] = {.lex_state = 1},
  [637] = {.lex_state = 1},
  [638] = {.lex_state = 1},
  [639] = {.lex_state = 1},
  [640] = {.lex_state = 1},
  [641] = {.lex_state = 9},
  [642] = {.lex_state = 1},
  [643] = {.lex_state = 13},
  [644] = {.lex_state = 13},
  [645] = {.lex_state = 13},
  [646] = {.lex_state = 13},
  [647] = {.lex_state = 13},
  [648] = {.lex_state = 13},
  [649] = {.lex_state = 12},
  [650] = {.lex_state = 12},
  [651] = {.lex_state = 13},
  [652] = {.lex_state = 13},
  [653] = {.lex_state = 13},
  [654] = {.lex_state = 12},
  [655] = {.lex_state = 12},
  [656] = {.lex_state = 13},
  [657] = {.lex_state = 13},
  [658] = {.lex_state = 12},
  [659] = {.lex_state = 13},
  [660] = {.lex_state = 12},
  [661] = {.lex_state = 12},
  [662] = {.lex_state = 12},
  [663] = {.lex_state = 13},
  [664] = {.lex_state = 12},
  [665] = {.lex_state = 12},
  [666] = {.lex_state = 12},
  [667] = {.lex_state = 15},
  [668] = {.lex_state = 15},
  [669] = {.lex_state = 15},
  [670] = {.lex_state = 15},
  [671] = {.lex_state = 15},
  [672] = {.lex_state = 15},
  [673] = {.lex_state = 15},
  [674] = {.lex_state = 15},
  [675] = {.lex_state = 15},
  [676] = {.lex_state = 15},
  [677] = {.lex_state = 15},
  [678] = {.lex_state = 15},
  [679] = {.lex_state = 15},
  [680] = {.lex_state = 15},
  [681] = {.lex_state = 15},
  [682] = {.lex_state = 15},
  [683] = {.lex_state = 15},
  [684] = {.lex_state = 15},
  [685] = {.lex_state = 15},
  [686] = {.lex_state = 15},
  [687] = {.lex_state = 15},
  [688] = {.lex_state = 15},
  [689] = {.lex_state = 15},
  [690] = {.lex_state = 15},
  [691] = {.lex_state = 15},
  [692] = {.lex_state = 15},
  [693] = {.lex_state = 15},
  [694] = {.lex_state = 15},
  [695] = {.lex_state = 15},
  [696] = {.lex_state = 15},
  [697] = {.lex_state = 15},
  [698] = {.lex_state = 15},
  [699] = {.lex_state = 15},
  [700] = {.lex_state = 15},
  [701] = {.lex_state = 15},
  [702] = {.lex_state = 15},
  [703] = {.lex_state = 15},
  [704] = {.lex_state = 15},
  [705] = {.lex_state = 15},
  [706] = {.lex_state = 15},
  [707] = {.lex_state = 15},
  [708] = {.lex_state = 15},
  [709] = {.lex_state = 15},
  [710] = {.lex_state = 15},
  [711] = {.lex_state = 15},
  [712] = {.lex_state = 15},
  [713] = {.lex_state = 15},
  [714] = {.lex_state = 15},
  [715] = {.lex_state = 15},
  [716] = {.lex_state = 15},
  [717] = {.lex_state = 15},
  [718] = {.lex_state = 15},
  [719] = {.lex_state = 15},
  [720] = {.lex_state = 15},
  [721] = {.lex_state = 15},
  [722] = {.lex_state = 15},
  [723] = {.lex_state = 15},
  [724] = {.lex_state = 15},
  [725] = {.lex_state = 15},
  [726] = {.lex_state = 15},
  [727] = {.lex_state = 15},
  [728] = {.lex_state = 15},
  [729] = {.lex_state = 15},
  [730] = {.lex_state = 15},
  [731] = {.lex_state = 15},
  [732] = {.lex_state = 15},
  [733] = {.lex_state = 15},
  [734] = {.lex_state = 15},
  [735] = {.lex_state = 15},
  [736] = {.lex_state = 15},
  [737] = {.lex_state = 15},
  [738] = {.lex_state = 15},
  [739] = {.lex_state = 15},
  [740] = {.lex_state = 15},
  [741] = {.lex_state = 15},
  [742] = {.lex_state = 15},
  [743] = {.lex_state = 15},
  [744] = {.lex_state = 15},
  [745] = {.lex_state = 15},
  [746] = {.lex_state = 15},
  [747] = {.lex_state = 14},
  [748] = {.lex_state = 3},
  [749] = {.lex_state = 22},
  [750] = {.lex_state = 22},
  [751] = {.lex_state = 14},
  [752] = {.lex_state = 22},
  [753] = {.lex_state = 3},
  [754] = {.lex_state = 14},
  [755] = {.lex_state = 22},
  [756] = {.lex_state = 3},
  [757] = {.lex_state = 22},
  [758] = {.lex_state = 3},
  [759] = {.lex_state = 14},
  [760] = {.lex_state = 22},
  [761] = {.lex_state = 22},
  [762] = {.lex_state = 14},
  [763] = {.lex_state = 14},
  [764] = {.lex_state = 14},
  [765] = {.lex_state = 1},
  [766] = {.lex_state = 18},
  [767] = {.lex_state = 63},
  [768] = {.lex_state = 13},
  [769] = {.lex_state = 1},
  [770] = {.lex_state = 1},
  [771] = {.lex_state = 13},
  [772] = {.lex_state = 3},
  [773] = {.lex_state = 63},
  [774] = {.lex_state = 3},
  [775] = {.lex_state = 1},
  [776] = {.lex_state = 63},
  [777] = {.lex_state = 16},
  [778] = {.lex_state = 63},
  [779] = {.lex_state = 63},
  [780] = {.lex_state = 63},
  [781] = {.lex_state = 1},
  [782] = {.lex_state = 63},
  [783] = {.lex_state = 3},
  [784] = {.lex_state = 19},
  [785] = {.lex_state = 63},
  [786] = {.lex_state = 16},
  [787] = {.lex_state = 3},
  [788] = {.lex_state = 3},
  [789] = {.lex_state = 1},
  [790] = {.lex_state = 1},
  [791] = {.lex_state = 16},
  [792] = {.lex_state = 63},
  [793] = {.lex_state = 1},
  [794] = {.lex_state = 1},
  [795] = {.lex_state = 1},
  [796] = {.lex_state = 22},
  [797] = {.lex_state = 14},
  [798] = {.lex_state = 22},
  [799] = {.lex_state = 1},
  [800] = {.lex_state = 0},
  [801] = {.lex_state = 1},
  [802] = {.lex_state = 1},
  [803] = {.lex_state = 1},
  [804] = {.lex_state = 1},
  [805] = {.lex_state = 1},
  [806] = {.lex_state = 13},
  [807] = {.lex_state = 14},
  [808] = {.lex_state = 1},
  [809] = {.lex_state = 14},
  [810] = {.lex_state = 1},
  [811] = {.lex_state = 14},
  [812] = {.lex_state = 1},
  [813] = {.lex_state = 1},
  [814] = {.lex_state = 1},
  [815] = {.lex_state = 1},
  [816] = {.lex_state = 1},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 22},
  [819] = {.lex_state = 1},
  [820] = {.lex_state = 1},
  [821] = {.lex_state = 1},
  [822] = {.lex_state = 1},
  [823] = {.lex_state = 22},
  [824] = {.lex_state = 3},
  [825] = {.lex_state = 3},
  [826] = {.lex_state = 3},
  [827] = {.lex_state = 63},
  [828] = {.lex_state = 63},
  [829] = {.lex_state = 63},
  [830] = {.lex_state = 63},
  [831] = {.lex_state = 63},
  [832] = {.lex_state = 1},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 3},
  [835] = {.lex_state = 1},
  [836] = {.lex_state = 1},
  [837] = {.lex_state = 63},
  [838] = {.lex_state = 3},
  [839] = {.lex_state = 63},
  [840] = {.lex_state = 0},
  [841] = {.lex_state = 1},
  [842] = {.lex_state = 63},
  [843] = {.lex_state = 1},
  [844] = {.lex_state = 1},
  [845] = {.lex_state = 63},
  [846] = {.lex_state = 63},
  [847] = {.lex_state = 1},
  [848] = {.lex_state = 63},
  [849] = {.lex_state = 1},
  [850] = {.lex_state = 3},
  [851] = {.lex_state = 0},
  [852] = {.lex_state = 1},
  [853] = {.lex_state = 1},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 17},
  [856] = {.lex_state = 1},
  [857] = {.lex_state = 1},
  [858] = {.lex_state = 1},
  [859] = {.lex_state = 17},
  [860] = {.lex_state = 1},
  [861] = {.lex_state = 17},
  [862] = {.lex_state = 1},
  [863] = {.lex_state = 1},
  [864] = {.lex_state = 1},
  [865] = {.lex_state = 17},
  [866] = {.lex_state = 21},
  [867] = {.lex_state = 1},
  [868] = {.lex_state = 1},
  [869] = {.lex_state = 0},
  [870] = {.lex_state = 0},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 0},
  [873] = {.lex_state = 0},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 1},
  [876] = {.lex_state = 0},
  [877] = {.lex_state = 0},
  [878] = {.lex_state = 0},
  [879] = {.lex_state = 1},
  [880] = {.lex_state = 0},
  [881] = {.lex_state = 1},
  [882] = {.lex_state = 1},
  [883] = {.lex_state = 1},
  [884] = {.lex_state = 0},
  [885] = {.lex_state = 0},
  [886] = {.lex_state = 1},
  [887] = {.lex_state = 0},
  [888] = {.lex_state = 0},
  [889] = {.lex_state = 1},
  [890] = {.lex_state = 1},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 1},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 1},
  [895] = {.lex_state = 1},
  [896] = {.lex_state = 17},
  [897] = {.lex_state = 1},
  [898] = {.lex_state = 1},
  [899] = {.lex_state = 1},
  [900] = {.lex_state = 0},
  [901] = {.lex_state = 1},
  [902] = {.lex_state = 0},
  [903] = {.lex_state = 0},
  [904] = {.lex_state = 1},
  [905] = {.lex_state = 1},
  [906] = {.lex_state = 1},
  [907] = {.lex_state = 1},
  [908] = {.lex_state = 0},
  [909] = {.lex_state = 1},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 0},
  [912] = {.lex_state = 1},
  [913] = {.lex_state = 1},
  [914] = {.lex_state = 1},
  [915] = {.lex_state = 1},
  [916] = {.lex_state = 1},
  [917] = {.lex_state = 1},
  [918] = {.lex_state = 0},
  [919] = {.lex_state = 1},
  [920] = {.lex_state = 1},
  [921] = {.lex_state = 1},
  [922] = {.lex_state = 1},
  [923] = {.lex_state = 1},
  [924] = {.lex_state = 1},
  [925] = {.lex_state = 0},
  [926] = {.lex_state = 0},
  [927] = {.lex_state = 1},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 1},
  [930] = {.lex_state = 1},
  [931] = {.lex_state = 0},
  [932] = {.lex_state = 1},
  [933] = {.lex_state = 0},
  [934] = {.lex_state = 0},
  [935] = {.lex_state = 1},
  [936] = {.lex_state = 1},
  [937] = {.lex_state = 1},
  [938] = {.lex_state = 1},
  [939] = {.lex_state = 1},
  [940] = {.lex_state = 1},
  [941] = {.lex_state = 0},
  [942] = {.lex_state = 1},
  [943] = {.lex_state = 1},
  [944] = {.lex_state = 1},
  [945] = {.lex_state = 1},
  [946] = {.lex_state = 1},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 1},
  [949] = {.lex_state = 1},
  [950] = {.lex_state = 0},
  [951] = {.lex_state = 1},
  [952] = {.lex_state = 1},
  [953] = {.lex_state = 1},
  [954] = {.lex_state = 1},
  [955] = {.lex_state = 0},
  [956] = {.lex_state = 1},
  [957] = {.lex_state = 1},
  [958] = {.lex_state = 1},
  [959] = {.lex_state = 1},
  [960] = {.lex_state = 1},
  [961] = {.lex_state = 1},
  [962] = {.lex_state = 0},
  [963] = {.lex_state = 1},
  [964] = {.lex_state = 1},
  [965] = {.lex_state = 1},
  [966] = {.lex_state = 1},
  [967] = {.lex_state = 1},
  [968] = {.lex_state = 1},
  [969] = {.lex_state = 0},
  [970] = {.lex_state = 1},
  [971] = {.lex_state = 1},
  [972] = {.lex_state = 1},
  [973] = {.lex_state = 1},
  [974] = {.lex_state = 1},
  [975] = {.lex_state = 1},
  [976] = {.lex_state = 1},
  [977] = {.lex_state = 1},
  [978] = {.lex_state = 1},
  [979] = {.lex_state = 1},
  [980] = {.lex_state = 1},
  [981] = {.lex_state = 1},
  [982] = {.lex_state = 0},
  [983] = {.lex_state = 0},
  [984] = {.lex_state = 0},
  [985] = {.lex_state = 17},
  [986] = {.lex_state = 0},
  [987] = {.lex_state = 0},
  [988] = {.lex_state = 0},
  [989] = {.lex_state = 1},
  [990] = {.lex_state = 1},
  [991] = {.lex_state = 1},
  [992] = {.lex_state = 0},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 0},
  [996] = {.lex_state = 1},
  [997] = {.lex_state = 13},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 0},
  [1001] = {.lex_state = 0},
  [1002] = {.lex_state = 0},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 63},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 0},
  [1008] = {.lex_state = 0},
  [1009] = {.lex_state = 0},
  [1010] = {.lex_state = 1},
  [1011] = {.lex_state = 0},
  [1012] = {.lex_state = 1},
  [1013] = {.lex_state = 0},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 0},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 1},
  [1020] = {.lex_state = 0},
  [1021] = {.lex_state = 0},
  [1022] = {.lex_state = 0},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 0},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 1},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 20},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 0},
  [1031] = {.lex_state = 0},
  [1032] = {.lex_state = 1},
  [1033] = {.lex_state = 0},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 0},
  [1036] = {.lex_state = 1},
  [1037] = {.lex_state = 0},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 1},
  [1040] = {.lex_state = 0},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 0},
  [1043] = {.lex_state = 0},
  [1044] = {.lex_state = 1},
  [1045] = {.lex_state = 0},
  [1046] = {.lex_state = 0},
  [1047] = {.lex_state = 0},
  [1048] = {.lex_state = 0},
  [1049] = {.lex_state = 0},
  [1050] = {.lex_state = 0},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 0},
  [1054] = {.lex_state = 0},
  [1055] = {.lex_state = 1},
  [1056] = {.lex_state = 0},
  [1057] = {.lex_state = 0},
  [1058] = {.lex_state = 0},
  [1059] = {.lex_state = 1},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 13},
  [1063] = {.lex_state = 0},
  [1064] = {.lex_state = 0},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 0},
  [1067] = {.lex_state = 0},
  [1068] = {.lex_state = 0},
  [1069] = {.lex_state = 0},
  [1070] = {.lex_state = 0},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 0},
  [1073] = {.lex_state = 13},
  [1074] = {.lex_state = 1},
  [1075] = {.lex_state = 0},
  [1076] = {.lex_state = 0},
  [1077] = {.lex_state = 13},
  [1078] = {.lex_state = 0},
  [1079] = {.lex_state = 0},
  [1080] = {.lex_state = 1},
  [1081] = {.lex_state = 0},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 1},
  [1084] = {.lex_state = 0},
  [1085] = {.lex_state = 0},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 1},
  [1088] = {.lex_state = 0},
  [1089] = {.lex_state = 1},
  [1090] = {.lex_state = 0},
  [1091] = {.lex_state = 0},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 0},
  [1094] = {.lex_state = 0},
  [1095] = {.lex_state = 0},
  [1096] = {.lex_state = 1},
  [1097] = {.lex_state = 0},
  [1098] = {.lex_state = 0},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 1},
  [1101] = {.lex_state = 0},
  [1102] = {.lex_state = 0},
  [1103] = {.lex_state = 0},
  [1104] = {.lex_state = 0},
  [1105] = {.lex_state = 0},
  [1106] = {.lex_state = 0},
  [1107] = {.lex_state = 0},
  [1108] = {.lex_state = 0},
  [1109] = {.lex_state = 0},
  [1110] = {.lex_state = 0},
  [1111] = {.lex_state = 0},
  [1112] = {.lex_state = 0},
  [1113] = {.lex_state = 0},
  [1114] = {.lex_state = 16},
  [1115] = {.lex_state = 0},
  [1116] = {.lex_state = 0},
  [1117] = {.lex_state = 0},
  [1118] = {.lex_state = 0},
  [1119] = {.lex_state = 0},
  [1120] = {.lex_state = 0},
  [1121] = {.lex_state = 1},
  [1122] = {.lex_state = 1},
  [1123] = {.lex_state = 1},
  [1124] = {.lex_state = 0},
  [1125] = {.lex_state = 0},
  [1126] = {.lex_state = 0},
  [1127] = {.lex_state = 0},
  [1128] = {.lex_state = 0},
  [1129] = {.lex_state = 0},
  [1130] = {.lex_state = 1},
  [1131] = {.lex_state = 1},
  [1132] = {.lex_state = 0},
  [1133] = {.lex_state = 0},
  [1134] = {.lex_state = 0},
  [1135] = {.lex_state = 1},
  [1136] = {.lex_state = 0},
  [1137] = {.lex_state = 1},
  [1138] = {.lex_state = 0},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 1},
  [1141] = {.lex_state = 1},
  [1142] = {.lex_state = 0},
  [1143] = {.lex_state = 0},
  [1144] = {.lex_state = 0},
  [1145] = {.lex_state = 1},
  [1146] = {.lex_state = 0},
  [1147] = {.lex_state = 0},
  [1148] = {.lex_state = 0},
  [1149] = {.lex_state = 0},
  [1150] = {.lex_state = 0},
  [1151] = {.lex_state = 0},
  [1152] = {.lex_state = 0},
  [1153] = {.lex_state = 0},
  [1154] = {.lex_state = 0},
  [1155] = {.lex_state = 0},
  [1156] = {.lex_state = 0},
  [1157] = {.lex_state = 0},
  [1158] = {.lex_state = 0},
  [1159] = {.lex_state = 0},
  [1160] = {.lex_state = 0},
  [1161] = {.lex_state = 0},
  [1162] = {.lex_state = 0},
  [1163] = {.lex_state = 0},
  [1164] = {.lex_state = 0},
  [1165] = {.lex_state = 0},
  [1166] = {.lex_state = 0},
  [1167] = {.lex_state = 0},
  [1168] = {.lex_state = 0},
  [1169] = {.lex_state = 0},
  [1170] = {.lex_state = 0},
  [1171] = {.lex_state = 0},
  [1172] = {.lex_state = 0},
  [1173] = {.lex_state = 0},
  [1174] = {.lex_state = 0},
  [1175] = {.lex_state = 0},
  [1176] = {.lex_state = 1},
  [1177] = {.lex_state = 0},
  [1178] = {.lex_state = 1},
  [1179] = {.lex_state = 0},
  [1180] = {.lex_state = 1},
  [1181] = {.lex_state = 0},
  [1182] = {.lex_state = 0},
  [1183] = {.lex_state = 1},
  [1184] = {.lex_state = 1},
  [1185] = {.lex_state = 16},
  [1186] = {.lex_state = 0},
  [1187] = {.lex_state = 7},
  [1188] = {.lex_state = 1},
  [1189] = {.lex_state = 1},
  [1190] = {.lex_state = 1},
  [1191] = {.lex_state = 1},
  [1192] = {.lex_state = 1},
  [1193] = {.lex_state = 1},
  [1194] = {.lex_state = 0},
  [1195] = {.lex_state = 1},
  [1196] = {.lex_state = 0},
  [1197] = {.lex_state = 0},
  [1198] = {.lex_state = 0},
  [1199] = {.lex_state = 1},
  [1200] = {.lex_state = 0},
  [1201] = {.lex_state = 1},
  [1202] = {.lex_state = 1},
  [1203] = {.lex_state = 0},
  [1204] = {.lex_state = 1},
  [1205] = {.lex_state = 1},
  [1206] = {.lex_state = 1},
  [1207] = {.lex_state = 1},
  [1208] = {.lex_state = 1},
  [1209] = {.lex_state = 0},
  [1210] = {.lex_state = 0},
  [1211] = {.lex_state = 0},
  [1212] = {.lex_state = 1},
  [1213] = {.lex_state = 0},
  [1214] = {.lex_state = 0},
  [1215] = {.lex_state = 0},
  [1216] = {.lex_state = 1},
  [1217] = {.lex_state = 0},
  [1218] = {.lex_state = 0},
  [1219] = {.lex_state = 0},
  [1220] = {.lex_state = 0},
  [1221] = {.lex_state = 0},
  [1222] = {.lex_state = 0},
  [1223] = {.lex_state = 0},
  [1224] = {.lex_state = 0},
  [1225] = {.lex_state = 0},
  [1226] = {.lex_state = 0},
  [1227] = {.lex_state = 0},
  [1228] = {.lex_state = 212},
  [1229] = {.lex_state = 1},
  [1230] = {.lex_state = 212},
  [1231] = {.lex_state = 1},
  [1232] = {.lex_state = 0},
  [1233] = {.lex_state = 0},
  [1234] = {.lex_state = 0},
  [1235] = {.lex_state = 1},
  [1236] = {.lex_state = 0},
  [1237] = {.lex_state = 0},
  [1238] = {.lex_state = 0},
  [1239] = {.lex_state = 0},
  [1240] = {.lex_state = 0},
  [1241] = {.lex_state = 0},
  [1242] = {.lex_state = 0},
  [1243] = {.lex_state = 0},
  [1244] = {.lex_state = 0},
  [1245] = {.lex_state = 1},
  [1246] = {.lex_state = 0},
  [1247] = {.lex_state = 0},
  [1248] = {.lex_state = 0},
  [1249] = {.lex_state = 0},
  [1250] = {.lex_state = 0},
  [1251] = {.lex_state = 1},
  [1252] = {.lex_state = 0},
  [1253] = {.lex_state = 0},
  [1254] = {.lex_state = 77},
  [1255] = {.lex_state = 1},
  [1256] = {.lex_state = 0},
  [1257] = {.lex_state = 1},
  [1258] = {.lex_state = 0},
  [1259] = {.lex_state = 1},
  [1260] = {.lex_state = 0},
  [1261] = {.lex_state = 0},
  [1262] = {.lex_state = 1},
  [1263] = {.lex_state = 0},
  [1264] = {.lex_state = 1},
  [1265] = {.lex_state = 0},
  [1266] = {.lex_state = 0},
  [1267] = {.lex_state = 1},
  [1268] = {.lex_state = 0},
  [1269] = {.lex_state = 1},
  [1270] = {.lex_state = 0},
  [1271] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_extern] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_fn] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [sym_rest_argument] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_mut] = ACTIONS(1),
    [anon_sym_move] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_builtin] = ACTIONS(1),
    [anon_sym_copy] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_trait] = ACTIONS(1),
    [anon_sym_impl] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_ref] = ACTIONS(1),
    [anon_sym_uni] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_LPAREN2] = ACTIONS(1),
    [anon_sym_recover] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_loop] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_match] = ACTIONS(1),
    [sym_wildcard_pattern] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_BSLASHu_LBRACE] = ACTIONS(1),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(1),
    [aux_sym_escape_sequence_token2] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [sym_self] = ACTIONS(1),
    [sym_nil] = ACTIONS(1),
    [sym_break] = ACTIONS(1),
    [sym_next] = ACTIONS(1),
    [sym_visibility] = ACTIONS(1),
    [sym_line_comment] = ACTIONS(3),
    [sym_field] = ACTIONS(1),
    [sym_constant] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(1223),
    [sym__root] = STATE(6),
    [sym_import] = STATE(6),
    [sym_extern_import] = STATE(6),
    [sym_external_function] = STATE(6),
    [sym_module_method] = STATE(6),
    [sym_class] = STATE(6),
    [sym_trait] = STATE(6),
    [sym_implement_trait] = STATE(6),
    [sym_reopen_class] = STATE(6),
    [sym_block] = STATE(246),
    [sym__expression] = STATE(246),
    [sym_assign_receiver_field] = STATE(246),
    [sym_assign_local] = STATE(246),
    [sym_assign_field] = STATE(246),
    [sym_replace_local] = STATE(246),
    [sym_replace_field] = STATE(246),
    [sym_compound_assign_local] = STATE(246),
    [sym_compound_assign_field] = STATE(246),
    [sym_compound_assign_receiver_field] = STATE(246),
    [sym__call_name] = STATE(1138),
    [sym_call] = STATE(246),
    [sym_call_with_receiver] = STATE(246),
    [sym_ref] = STATE(246),
    [sym_mut] = STATE(246),
    [sym_recover] = STATE(246),
    [sym_grouped_expression] = STATE(246),
    [sym_tuple] = STATE(246),
    [sym_array] = STATE(246),
    [sym_return] = STATE(246),
    [sym_try] = STATE(246),
    [sym_throw] = STATE(246),
    [sym_if] = STATE(246),
    [sym_while] = STATE(246),
    [sym_loop] = STATE(246),
    [sym_for] = STATE(246),
    [sym_match] = STATE(246),
    [sym_closure] = STATE(246),
    [sym_define_constant] = STATE(6),
    [sym_define_variable] = STATE(246),
    [sym_and_or] = STATE(246),
    [sym_binary] = STATE(246),
    [sym_cast] = STATE(246),
    [sym_string] = STATE(246),
    [sym_true] = STATE(246),
    [sym_false] = STATE(246),
    [aux_sym_source_file_repeat1] = STATE(6),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(15),
    [anon_sym_fn] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_mut] = ACTIONS(21),
    [anon_sym_type] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(27),
    [anon_sym_trait] = ACTIONS(29),
    [anon_sym_impl] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_ref] = ACTIONS(35),
    [anon_sym_recover] = ACTIONS(37),
    [anon_sym_return] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(41),
    [anon_sym_throw] = ACTIONS(43),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_loop] = ACTIONS(47),
    [anon_sym_match] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [sym_integer] = ACTIONS(57),
    [anon_sym_SQUOTE] = ACTIONS(59),
    [sym_self] = ACTIONS(61),
    [sym_nil] = ACTIONS(61),
    [sym_break] = ACTIONS(61),
    [sym_next] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(63),
    [sym_field] = ACTIONS(65),
    [sym_constant] = ACTIONS(67),
  },
  [2] = {
    [sym_block] = STATE(251),
    [sym__expression] = STATE(251),
    [sym_assign_receiver_field] = STATE(251),
    [sym_assign_local] = STATE(251),
    [sym_assign_field] = STATE(251),
    [sym_replace_local] = STATE(251),
    [sym_replace_field] = STATE(251),
    [sym_compound_assign_local] = STATE(251),
    [sym_compound_assign_field] = STATE(251),
    [sym_compound_assign_receiver_field] = STATE(251),
    [sym__call_name] = STATE(1138),
    [sym_call] = STATE(251),
    [sym_call_with_receiver] = STATE(251),
    [sym_ref] = STATE(251),
    [sym_mut] = STATE(251),
    [sym_recover] = STATE(251),
    [sym_grouped_expression] = STATE(251),
    [sym_tuple] = STATE(251),
    [sym_array] = STATE(251),
    [sym_return] = STATE(251),
    [sym_try] = STATE(251),
    [sym_throw] = STATE(251),
    [sym_if] = STATE(251),
    [sym_while] = STATE(251),
    [sym_loop] = STATE(251),
    [sym_for] = STATE(251),
    [sym_match] = STATE(251),
    [sym_closure] = STATE(251),
    [sym_define_variable] = STATE(251),
    [sym_and_or] = STATE(251),
    [sym_binary] = STATE(251),
    [sym_cast] = STATE(251),
    [sym_string] = STATE(251),
    [sym_true] = STATE(251),
    [sym_false] = STATE(251),
    [ts_builtin_sym_end] = ACTIONS(69),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(71),
    [anon_sym_DOT] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_as] = ACTIONS(71),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_and] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(15),
    [anon_sym_fn] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(71),
    [anon_sym_SLASH] = ACTIONS(69),
    [anon_sym_STAR] = ACTIONS(71),
    [anon_sym_STAR_STAR] = ACTIONS(69),
    [anon_sym_PERCENT] = ACTIONS(69),
    [anon_sym_LT] = ACTIONS(71),
    [anon_sym_GT] = ACTIONS(71),
    [anon_sym_LT_EQ] = ACTIONS(69),
    [anon_sym_GT_EQ] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(69),
    [anon_sym_GT_GT] = ACTIONS(71),
    [anon_sym_GT_GT_GT] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_CARET] = ACTIONS(69),
    [anon_sym_EQ_EQ] = ACTIONS(69),
    [anon_sym_BANG_EQ] = ACTIONS(69),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_mut] = ACTIONS(21),
    [anon_sym_type] = ACTIONS(71),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(75),
    [anon_sym_trait] = ACTIONS(71),
    [anon_sym_impl] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_ref] = ACTIONS(35),
    [anon_sym_recover] = ACTIONS(37),
    [anon_sym_return] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(41),
    [anon_sym_throw] = ACTIONS(43),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_loop] = ACTIONS(47),
    [anon_sym_match] = ACTIONS(49),
    [anon_sym_or] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [sym_float] = ACTIONS(77),
    [sym_integer] = ACTIONS(57),
    [anon_sym_SQUOTE] = ACTIONS(59),
    [sym_self] = ACTIONS(79),
    [sym_nil] = ACTIONS(79),
    [sym_break] = ACTIONS(79),
    [sym_next] = ACTIONS(79),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(63),
    [sym_field] = ACTIONS(65),
    [sym_constant] = ACTIONS(67),
  },
  [3] = {
    [sym_block] = STATE(587),
    [sym__expression] = STATE(587),
    [sym_assign_receiver_field] = STATE(587),
    [sym_assign_local] = STATE(587),
    [sym_assign_field] = STATE(587),
    [sym_replace_local] = STATE(587),
    [sym_replace_field] = STATE(587),
    [sym_compound_assign_local] = STATE(587),
    [sym_compound_assign_field] = STATE(587),
    [sym_compound_assign_receiver_field] = STATE(587),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(587),
    [sym_call_with_receiver] = STATE(587),
    [sym_ref] = STATE(587),
    [sym_mut] = STATE(587),
    [sym_recover] = STATE(587),
    [sym_grouped_expression] = STATE(587),
    [sym_tuple] = STATE(587),
    [sym_array] = STATE(587),
    [sym_return] = STATE(587),
    [sym_try] = STATE(587),
    [sym_throw] = STATE(587),
    [sym_if] = STATE(587),
    [sym_while] = STATE(587),
    [sym_loop] = STATE(587),
    [sym_for] = STATE(587),
    [sym_match] = STATE(587),
    [sym_closure] = STATE(587),
    [sym_define_variable] = STATE(587),
    [sym_and_or] = STATE(587),
    [sym_binary] = STATE(587),
    [sym_cast] = STATE(587),
    [sym_string] = STATE(587),
    [sym_true] = STATE(587),
    [sym_false] = STATE(587),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_DOT] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_COMMA] = ACTIONS(69),
    [anon_sym_RPAREN] = ACTIONS(69),
    [anon_sym_as] = ACTIONS(71),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_and] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(71),
    [anon_sym_SLASH] = ACTIONS(69),
    [anon_sym_STAR] = ACTIONS(71),
    [anon_sym_STAR_STAR] = ACTIONS(69),
    [anon_sym_PERCENT] = ACTIONS(69),
    [anon_sym_LT] = ACTIONS(71),
    [anon_sym_GT] = ACTIONS(71),
    [anon_sym_LT_EQ] = ACTIONS(69),
    [anon_sym_GT_EQ] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(69),
    [anon_sym_GT_GT] = ACTIONS(71),
    [anon_sym_GT_GT_GT] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_CARET] = ACTIONS(69),
    [anon_sym_EQ_EQ] = ACTIONS(69),
    [anon_sym_BANG_EQ] = ACTIONS(69),
    [anon_sym_DASH_GT] = ACTIONS(69),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_RBRACK] = ACTIONS(69),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_or] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(121),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(127),
    [sym_nil] = ACTIONS(127),
    [sym_break] = ACTIONS(127),
    [sym_next] = ACTIONS(127),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [4] = {
    [sym_block] = STATE(620),
    [sym__expression] = STATE(620),
    [sym_assign_receiver_field] = STATE(620),
    [sym_assign_local] = STATE(620),
    [sym_assign_field] = STATE(620),
    [sym_replace_local] = STATE(620),
    [sym_replace_field] = STATE(620),
    [sym_compound_assign_local] = STATE(620),
    [sym_compound_assign_field] = STATE(620),
    [sym_compound_assign_receiver_field] = STATE(620),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(620),
    [sym_call_with_receiver] = STATE(620),
    [sym_ref] = STATE(620),
    [sym_mut] = STATE(620),
    [sym_recover] = STATE(620),
    [sym_grouped_expression] = STATE(620),
    [sym_tuple] = STATE(620),
    [sym_array] = STATE(620),
    [sym_return] = STATE(620),
    [sym_try] = STATE(620),
    [sym_throw] = STATE(620),
    [sym_if] = STATE(620),
    [sym_while] = STATE(620),
    [sym_loop] = STATE(620),
    [sym_for] = STATE(620),
    [sym_match] = STATE(620),
    [sym_closure] = STATE(620),
    [sym_define_variable] = STATE(620),
    [sym_and_or] = STATE(620),
    [sym_binary] = STATE(620),
    [sym_cast] = STATE(620),
    [sym_string] = STATE(620),
    [sym_true] = STATE(620),
    [sym_false] = STATE(620),
    [sym_identifier] = ACTIONS(135),
    [anon_sym_DOT] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_COMMA] = ACTIONS(69),
    [anon_sym_as] = ACTIONS(71),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_and] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(71),
    [anon_sym_SLASH] = ACTIONS(69),
    [anon_sym_STAR] = ACTIONS(71),
    [anon_sym_STAR_STAR] = ACTIONS(69),
    [anon_sym_PERCENT] = ACTIONS(69),
    [anon_sym_LT] = ACTIONS(71),
    [anon_sym_GT] = ACTIONS(71),
    [anon_sym_LT_EQ] = ACTIONS(69),
    [anon_sym_GT_EQ] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(69),
    [anon_sym_GT_GT] = ACTIONS(71),
    [anon_sym_GT_GT_GT] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_CARET] = ACTIONS(69),
    [anon_sym_EQ_EQ] = ACTIONS(69),
    [anon_sym_BANG_EQ] = ACTIONS(69),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(137),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_RBRACE] = ACTIONS(69),
    [anon_sym_let] = ACTIONS(139),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(141),
    [anon_sym_recover] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_try] = ACTIONS(147),
    [anon_sym_throw] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_or] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(151),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(153),
    [sym_nil] = ACTIONS(153),
    [sym_break] = ACTIONS(153),
    [sym_next] = ACTIONS(153),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(155),
    [sym_constant] = ACTIONS(133),
  },
  [5] = {
    [sym_block] = STATE(347),
    [sym__expression] = STATE(347),
    [sym_assign_receiver_field] = STATE(347),
    [sym_assign_local] = STATE(347),
    [sym_assign_field] = STATE(347),
    [sym_replace_local] = STATE(347),
    [sym_replace_field] = STATE(347),
    [sym_compound_assign_local] = STATE(347),
    [sym_compound_assign_field] = STATE(347),
    [sym_compound_assign_receiver_field] = STATE(347),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(347),
    [sym_call_with_receiver] = STATE(347),
    [sym_ref] = STATE(347),
    [sym_mut] = STATE(347),
    [sym_recover] = STATE(347),
    [sym_grouped_expression] = STATE(347),
    [sym_tuple] = STATE(347),
    [sym_array] = STATE(347),
    [sym_return] = STATE(347),
    [sym_try] = STATE(347),
    [sym_throw] = STATE(347),
    [sym_if] = STATE(347),
    [sym_while] = STATE(347),
    [sym_loop] = STATE(347),
    [sym_for] = STATE(347),
    [sym_match] = STATE(347),
    [sym_closure] = STATE(347),
    [sym_define_variable] = STATE(347),
    [sym_and_or] = STATE(347),
    [sym_binary] = STATE(347),
    [sym_cast] = STATE(347),
    [sym_string] = STATE(347),
    [sym_true] = STATE(347),
    [sym_false] = STATE(347),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_DOT] = ACTIONS(69),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_as] = ACTIONS(71),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_and] = ACTIONS(71),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(71),
    [anon_sym_SLASH] = ACTIONS(69),
    [anon_sym_STAR] = ACTIONS(71),
    [anon_sym_STAR_STAR] = ACTIONS(69),
    [anon_sym_PERCENT] = ACTIONS(69),
    [anon_sym_LT] = ACTIONS(71),
    [anon_sym_GT] = ACTIONS(71),
    [anon_sym_LT_EQ] = ACTIONS(69),
    [anon_sym_GT_EQ] = ACTIONS(69),
    [anon_sym_LT_LT] = ACTIONS(69),
    [anon_sym_GT_GT] = ACTIONS(71),
    [anon_sym_GT_GT_GT] = ACTIONS(69),
    [anon_sym_AMP] = ACTIONS(69),
    [anon_sym_PIPE] = ACTIONS(69),
    [anon_sym_CARET] = ACTIONS(69),
    [anon_sym_EQ_EQ] = ACTIONS(69),
    [anon_sym_BANG_EQ] = ACTIONS(69),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_RBRACE] = ACTIONS(69),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_or] = ACTIONS(71),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(197),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(203),
    [sym_nil] = ACTIONS(203),
    [sym_break] = ACTIONS(203),
    [sym_next] = ACTIONS(203),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [6] = {
    [sym__root] = STATE(7),
    [sym_import] = STATE(7),
    [sym_extern_import] = STATE(7),
    [sym_external_function] = STATE(7),
    [sym_module_method] = STATE(7),
    [sym_class] = STATE(7),
    [sym_trait] = STATE(7),
    [sym_implement_trait] = STATE(7),
    [sym_reopen_class] = STATE(7),
    [sym_block] = STATE(246),
    [sym__expression] = STATE(246),
    [sym_assign_receiver_field] = STATE(246),
    [sym_assign_local] = STATE(246),
    [sym_assign_field] = STATE(246),
    [sym_replace_local] = STATE(246),
    [sym_replace_field] = STATE(246),
    [sym_compound_assign_local] = STATE(246),
    [sym_compound_assign_field] = STATE(246),
    [sym_compound_assign_receiver_field] = STATE(246),
    [sym__call_name] = STATE(1138),
    [sym_call] = STATE(246),
    [sym_call_with_receiver] = STATE(246),
    [sym_ref] = STATE(246),
    [sym_mut] = STATE(246),
    [sym_recover] = STATE(246),
    [sym_grouped_expression] = STATE(246),
    [sym_tuple] = STATE(246),
    [sym_array] = STATE(246),
    [sym_return] = STATE(246),
    [sym_try] = STATE(246),
    [sym_throw] = STATE(246),
    [sym_if] = STATE(246),
    [sym_while] = STATE(246),
    [sym_loop] = STATE(246),
    [sym_for] = STATE(246),
    [sym_match] = STATE(246),
    [sym_closure] = STATE(246),
    [sym_define_constant] = STATE(7),
    [sym_define_variable] = STATE(246),
    [sym_and_or] = STATE(246),
    [sym_binary] = STATE(246),
    [sym_cast] = STATE(246),
    [sym_string] = STATE(246),
    [sym_true] = STATE(246),
    [sym_false] = STATE(246),
    [aux_sym_source_file_repeat1] = STATE(7),
    [ts_builtin_sym_end] = ACTIONS(211),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(15),
    [anon_sym_fn] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_mut] = ACTIONS(21),
    [anon_sym_type] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(27),
    [anon_sym_trait] = ACTIONS(29),
    [anon_sym_impl] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_ref] = ACTIONS(35),
    [anon_sym_recover] = ACTIONS(37),
    [anon_sym_return] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(41),
    [anon_sym_throw] = ACTIONS(43),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_loop] = ACTIONS(47),
    [anon_sym_match] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [sym_float] = ACTIONS(55),
    [sym_integer] = ACTIONS(57),
    [anon_sym_SQUOTE] = ACTIONS(59),
    [sym_self] = ACTIONS(61),
    [sym_nil] = ACTIONS(61),
    [sym_break] = ACTIONS(61),
    [sym_next] = ACTIONS(61),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(63),
    [sym_field] = ACTIONS(65),
    [sym_constant] = ACTIONS(67),
  },
  [7] = {
    [sym__root] = STATE(7),
    [sym_import] = STATE(7),
    [sym_extern_import] = STATE(7),
    [sym_external_function] = STATE(7),
    [sym_module_method] = STATE(7),
    [sym_class] = STATE(7),
    [sym_trait] = STATE(7),
    [sym_implement_trait] = STATE(7),
    [sym_reopen_class] = STATE(7),
    [sym_block] = STATE(246),
    [sym__expression] = STATE(246),
    [sym_assign_receiver_field] = STATE(246),
    [sym_assign_local] = STATE(246),
    [sym_assign_field] = STATE(246),
    [sym_replace_local] = STATE(246),
    [sym_replace_field] = STATE(246),
    [sym_compound_assign_local] = STATE(246),
    [sym_compound_assign_field] = STATE(246),
    [sym_compound_assign_receiver_field] = STATE(246),
    [sym__call_name] = STATE(1138),
    [sym_call] = STATE(246),
    [sym_call_with_receiver] = STATE(246),
    [sym_ref] = STATE(246),
    [sym_mut] = STATE(246),
    [sym_recover] = STATE(246),
    [sym_grouped_expression] = STATE(246),
    [sym_tuple] = STATE(246),
    [sym_array] = STATE(246),
    [sym_return] = STATE(246),
    [sym_try] = STATE(246),
    [sym_throw] = STATE(246),
    [sym_if] = STATE(246),
    [sym_while] = STATE(246),
    [sym_loop] = STATE(246),
    [sym_for] = STATE(246),
    [sym_match] = STATE(246),
    [sym_closure] = STATE(246),
    [sym_define_constant] = STATE(7),
    [sym_define_variable] = STATE(246),
    [sym_and_or] = STATE(246),
    [sym_binary] = STATE(246),
    [sym_cast] = STATE(246),
    [sym_string] = STATE(246),
    [sym_true] = STATE(246),
    [sym_false] = STATE(246),
    [aux_sym_source_file_repeat1] = STATE(7),
    [ts_builtin_sym_end] = ACTIONS(213),
    [sym_identifier] = ACTIONS(215),
    [anon_sym_import] = ACTIONS(218),
    [anon_sym_LPAREN] = ACTIONS(221),
    [anon_sym_if] = ACTIONS(224),
    [anon_sym_DQUOTE] = ACTIONS(227),
    [anon_sym_fn] = ACTIONS(230),
    [anon_sym_LBRACK] = ACTIONS(233),
    [anon_sym_mut] = ACTIONS(236),
    [anon_sym_type] = ACTIONS(239),
    [anon_sym_LBRACE] = ACTIONS(242),
    [anon_sym_let] = ACTIONS(245),
    [anon_sym_trait] = ACTIONS(248),
    [anon_sym_impl] = ACTIONS(251),
    [anon_sym_for] = ACTIONS(254),
    [anon_sym_ref] = ACTIONS(257),
    [anon_sym_recover] = ACTIONS(260),
    [anon_sym_return] = ACTIONS(263),
    [anon_sym_try] = ACTIONS(266),
    [anon_sym_throw] = ACTIONS(269),
    [anon_sym_while] = ACTIONS(272),
    [anon_sym_loop] = ACTIONS(275),
    [anon_sym_match] = ACTIONS(278),
    [anon_sym_true] = ACTIONS(281),
    [anon_sym_false] = ACTIONS(284),
    [sym_float] = ACTIONS(287),
    [sym_integer] = ACTIONS(290),
    [anon_sym_SQUOTE] = ACTIONS(293),
    [sym_self] = ACTIONS(296),
    [sym_nil] = ACTIONS(296),
    [sym_break] = ACTIONS(296),
    [sym_next] = ACTIONS(296),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(299),
    [sym_field] = ACTIONS(302),
    [sym_constant] = ACTIONS(305),
  },
  [8] = {
    [ts_builtin_sym_end] = ACTIONS(308),
    [sym_identifier] = ACTIONS(310),
    [anon_sym_import] = ACTIONS(310),
    [anon_sym_DOT] = ACTIONS(308),
    [anon_sym_LPAREN] = ACTIONS(310),
    [anon_sym_as] = ACTIONS(310),
    [anon_sym_if] = ACTIONS(310),
    [anon_sym_and] = ACTIONS(310),
    [anon_sym_DQUOTE] = ACTIONS(308),
    [anon_sym_fn] = ACTIONS(310),
    [anon_sym_PLUS] = ACTIONS(310),
    [anon_sym_DASH] = ACTIONS(310),
    [anon_sym_SLASH] = ACTIONS(310),
    [anon_sym_STAR] = ACTIONS(310),
    [anon_sym_STAR_STAR] = ACTIONS(310),
    [anon_sym_PERCENT] = ACTIONS(310),
    [anon_sym_LT] = ACTIONS(310),
    [anon_sym_GT] = ACTIONS(310),
    [anon_sym_LT_EQ] = ACTIONS(308),
    [anon_sym_GT_EQ] = ACTIONS(308),
    [anon_sym_LT_LT] = ACTIONS(310),
    [anon_sym_GT_GT] = ACTIONS(310),
    [anon_sym_GT_GT_GT] = ACTIONS(310),
    [anon_sym_AMP] = ACTIONS(310),
    [anon_sym_PIPE] = ACTIONS(310),
    [anon_sym_CARET] = ACTIONS(310),
    [anon_sym_EQ_EQ] = ACTIONS(308),
    [anon_sym_BANG_EQ] = ACTIONS(308),
    [anon_sym_LBRACK] = ACTIONS(308),
    [anon_sym_mut] = ACTIONS(310),
    [anon_sym_type] = ACTIONS(310),
    [anon_sym_LBRACE] = ACTIONS(308),
    [anon_sym_let] = ACTIONS(310),
    [anon_sym_trait] = ACTIONS(310),
    [anon_sym_impl] = ACTIONS(310),
    [anon_sym_for] = ACTIONS(310),
    [anon_sym_ref] = ACTIONS(310),
    [anon_sym_EQ] = ACTIONS(312),
    [anon_sym_COLON_EQ] = ACTIONS(314),
    [anon_sym_PLUS_EQ] = ACTIONS(316),
    [anon_sym_DASH_EQ] = ACTIONS(316),
    [anon_sym_SLASH_EQ] = ACTIONS(316),
    [anon_sym_STAR_EQ] = ACTIONS(316),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(316),
    [anon_sym_PERCENT_EQ] = ACTIONS(316),
    [anon_sym_LT_LT_EQ] = ACTIONS(316),
    [anon_sym_GT_GT_EQ] = ACTIONS(316),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(316),
    [anon_sym_AMP_EQ] = ACTIONS(316),
    [anon_sym_PIPE_EQ] = ACTIONS(316),
    [anon_sym_CARET_EQ] = ACTIONS(316),
    [anon_sym_LPAREN2] = ACTIONS(318),
    [anon_sym_recover] = ACTIONS(310),
    [anon_sym_return] = ACTIONS(310),
    [anon_sym_try] = ACTIONS(310),
    [anon_sym_throw] = ACTIONS(310),
    [anon_sym_while] = ACTIONS(310),
    [anon_sym_loop] = ACTIONS(310),
    [anon_sym_match] = ACTIONS(310),
    [anon_sym_or] = ACTIONS(310),
    [anon_sym_true] = ACTIONS(310),
    [anon_sym_false] = ACTIONS(310),
    [sym_float] = ACTIONS(308),
    [sym_integer] = ACTIONS(310),
    [anon_sym_SQUOTE] = ACTIONS(308),
    [sym_self] = ACTIONS(310),
    [sym_nil] = ACTIONS(310),
    [sym_break] = ACTIONS(310),
    [sym_next] = ACTIONS(310),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(310),
    [sym_field] = ACTIONS(308),
    [sym_constant] = ACTIONS(308),
  },
  [9] = {
    [ts_builtin_sym_end] = ACTIONS(320),
    [sym_identifier] = ACTIONS(322),
    [anon_sym_import] = ACTIONS(322),
    [anon_sym_DOT] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_as] = ACTIONS(322),
    [anon_sym_if] = ACTIONS(322),
    [anon_sym_and] = ACTIONS(322),
    [anon_sym_DQUOTE] = ACTIONS(320),
    [anon_sym_fn] = ACTIONS(322),
    [anon_sym_PLUS] = ACTIONS(322),
    [anon_sym_DASH] = ACTIONS(322),
    [anon_sym_SLASH] = ACTIONS(322),
    [anon_sym_STAR] = ACTIONS(322),
    [anon_sym_STAR_STAR] = ACTIONS(322),
    [anon_sym_PERCENT] = ACTIONS(322),
    [anon_sym_LT] = ACTIONS(322),
    [anon_sym_GT] = ACTIONS(322),
    [anon_sym_LT_EQ] = ACTIONS(320),
    [anon_sym_GT_EQ] = ACTIONS(320),
    [anon_sym_LT_LT] = ACTIONS(322),
    [anon_sym_GT_GT] = ACTIONS(322),
    [anon_sym_GT_GT_GT] = ACTIONS(322),
    [anon_sym_AMP] = ACTIONS(322),
    [anon_sym_PIPE] = ACTIONS(322),
    [anon_sym_CARET] = ACTIONS(322),
    [anon_sym_EQ_EQ] = ACTIONS(320),
    [anon_sym_BANG_EQ] = ACTIONS(320),
    [anon_sym_LBRACK] = ACTIONS(320),
    [anon_sym_mut] = ACTIONS(322),
    [anon_sym_type] = ACTIONS(322),
    [anon_sym_LBRACE] = ACTIONS(320),
    [anon_sym_let] = ACTIONS(322),
    [anon_sym_trait] = ACTIONS(322),
    [anon_sym_impl] = ACTIONS(322),
    [anon_sym_for] = ACTIONS(322),
    [anon_sym_ref] = ACTIONS(322),
    [anon_sym_EQ] = ACTIONS(322),
    [anon_sym_PLUS_EQ] = ACTIONS(324),
    [anon_sym_DASH_EQ] = ACTIONS(324),
    [anon_sym_SLASH_EQ] = ACTIONS(324),
    [anon_sym_STAR_EQ] = ACTIONS(324),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(324),
    [anon_sym_PERCENT_EQ] = ACTIONS(324),
    [anon_sym_LT_LT_EQ] = ACTIONS(324),
    [anon_sym_GT_GT_EQ] = ACTIONS(324),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(324),
    [anon_sym_AMP_EQ] = ACTIONS(324),
    [anon_sym_PIPE_EQ] = ACTIONS(324),
    [anon_sym_CARET_EQ] = ACTIONS(324),
    [anon_sym_LPAREN2] = ACTIONS(320),
    [anon_sym_recover] = ACTIONS(322),
    [anon_sym_return] = ACTIONS(322),
    [anon_sym_try] = ACTIONS(322),
    [anon_sym_throw] = ACTIONS(322),
    [anon_sym_while] = ACTIONS(322),
    [anon_sym_loop] = ACTIONS(322),
    [anon_sym_match] = ACTIONS(322),
    [anon_sym_or] = ACTIONS(322),
    [anon_sym_true] = ACTIONS(322),
    [anon_sym_false] = ACTIONS(322),
    [sym_float] = ACTIONS(320),
    [sym_integer] = ACTIONS(322),
    [anon_sym_SQUOTE] = ACTIONS(320),
    [sym_self] = ACTIONS(322),
    [sym_nil] = ACTIONS(322),
    [sym_break] = ACTIONS(322),
    [sym_next] = ACTIONS(322),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(322),
    [sym_field] = ACTIONS(320),
    [sym_constant] = ACTIONS(320),
  },
  [10] = {
    [ts_builtin_sym_end] = ACTIONS(308),
    [sym_identifier] = ACTIONS(310),
    [anon_sym_import] = ACTIONS(310),
    [anon_sym_DOT] = ACTIONS(308),
    [anon_sym_LPAREN] = ACTIONS(308),
    [anon_sym_as] = ACTIONS(310),
    [anon_sym_if] = ACTIONS(310),
    [anon_sym_and] = ACTIONS(310),
    [anon_sym_DQUOTE] = ACTIONS(308),
    [anon_sym_fn] = ACTIONS(310),
    [anon_sym_PLUS] = ACTIONS(310),
    [anon_sym_DASH] = ACTIONS(310),
    [anon_sym_SLASH] = ACTIONS(310),
    [anon_sym_STAR] = ACTIONS(310),
    [anon_sym_STAR_STAR] = ACTIONS(310),
    [anon_sym_PERCENT] = ACTIONS(310),
    [anon_sym_LT] = ACTIONS(310),
    [anon_sym_GT] = ACTIONS(310),
    [anon_sym_LT_EQ] = ACTIONS(308),
    [anon_sym_GT_EQ] = ACTIONS(308),
    [anon_sym_LT_LT] = ACTIONS(310),
    [anon_sym_GT_GT] = ACTIONS(310),
    [anon_sym_GT_GT_GT] = ACTIONS(310),
    [anon_sym_AMP] = ACTIONS(310),
    [anon_sym_PIPE] = ACTIONS(310),
    [anon_sym_CARET] = ACTIONS(310),
    [anon_sym_EQ_EQ] = ACTIONS(308),
    [anon_sym_BANG_EQ] = ACTIONS(308),
    [anon_sym_LBRACK] = ACTIONS(308),
    [anon_sym_mut] = ACTIONS(310),
    [anon_sym_type] = ACTIONS(310),
    [anon_sym_LBRACE] = ACTIONS(308),
    [anon_sym_let] = ACTIONS(310),
    [anon_sym_trait] = ACTIONS(310),
    [anon_sym_impl] = ACTIONS(310),
    [anon_sym_for] = ACTIONS(310),
    [anon_sym_ref] = ACTIONS(310),
    [anon_sym_EQ] = ACTIONS(326),
    [anon_sym_COLON_EQ] = ACTIONS(328),
    [anon_sym_PLUS_EQ] = ACTIONS(330),
    [anon_sym_DASH_EQ] = ACTIONS(330),
    [anon_sym_SLASH_EQ] = ACTIONS(330),
    [anon_sym_STAR_EQ] = ACTIONS(330),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(330),
    [anon_sym_PERCENT_EQ] = ACTIONS(330),
    [anon_sym_LT_LT_EQ] = ACTIONS(330),
    [anon_sym_GT_GT_EQ] = ACTIONS(330),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(330),
    [anon_sym_AMP_EQ] = ACTIONS(330),
    [anon_sym_PIPE_EQ] = ACTIONS(330),
    [anon_sym_CARET_EQ] = ACTIONS(330),
    [anon_sym_recover] = ACTIONS(310),
    [anon_sym_return] = ACTIONS(310),
    [anon_sym_try] = ACTIONS(310),
    [anon_sym_throw] = ACTIONS(310),
    [anon_sym_while] = ACTIONS(310),
    [anon_sym_loop] = ACTIONS(310),
    [anon_sym_match] = ACTIONS(310),
    [anon_sym_or] = ACTIONS(310),
    [anon_sym_true] = ACTIONS(310),
    [anon_sym_false] = ACTIONS(310),
    [sym_float] = ACTIONS(308),
    [sym_integer] = ACTIONS(310),
    [anon_sym_SQUOTE] = ACTIONS(308),
    [sym_self] = ACTIONS(310),
    [sym_nil] = ACTIONS(310),
    [sym_break] = ACTIONS(310),
    [sym_next] = ACTIONS(310),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(310),
    [sym_field] = ACTIONS(308),
    [sym_constant] = ACTIONS(308),
  },
  [11] = {
    [ts_builtin_sym_end] = ACTIONS(318),
    [sym_identifier] = ACTIONS(332),
    [anon_sym_import] = ACTIONS(332),
    [anon_sym_DOT] = ACTIONS(318),
    [anon_sym_LPAREN] = ACTIONS(332),
    [anon_sym_as] = ACTIONS(332),
    [anon_sym_if] = ACTIONS(332),
    [anon_sym_and] = ACTIONS(332),
    [anon_sym_DQUOTE] = ACTIONS(318),
    [anon_sym_fn] = ACTIONS(332),
    [anon_sym_PLUS] = ACTIONS(332),
    [anon_sym_DASH] = ACTIONS(332),
    [anon_sym_SLASH] = ACTIONS(332),
    [anon_sym_STAR] = ACTIONS(332),
    [anon_sym_STAR_STAR] = ACTIONS(332),
    [anon_sym_PERCENT] = ACTIONS(332),
    [anon_sym_LT] = ACTIONS(332),
    [anon_sym_GT] = ACTIONS(332),
    [anon_sym_LT_EQ] = ACTIONS(318),
    [anon_sym_GT_EQ] = ACTIONS(318),
    [anon_sym_LT_LT] = ACTIONS(332),
    [anon_sym_GT_GT] = ACTIONS(332),
    [anon_sym_GT_GT_GT] = ACTIONS(332),
    [anon_sym_AMP] = ACTIONS(332),
    [anon_sym_PIPE] = ACTIONS(332),
    [anon_sym_CARET] = ACTIONS(332),
    [anon_sym_EQ_EQ] = ACTIONS(318),
    [anon_sym_BANG_EQ] = ACTIONS(318),
    [anon_sym_LBRACK] = ACTIONS(318),
    [anon_sym_mut] = ACTIONS(332),
    [anon_sym_type] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(318),
    [anon_sym_let] = ACTIONS(332),
    [anon_sym_trait] = ACTIONS(332),
    [anon_sym_impl] = ACTIONS(332),
    [anon_sym_for] = ACTIONS(332),
    [anon_sym_ref] = ACTIONS(332),
    [anon_sym_EQ] = ACTIONS(332),
    [anon_sym_PLUS_EQ] = ACTIONS(324),
    [anon_sym_DASH_EQ] = ACTIONS(324),
    [anon_sym_SLASH_EQ] = ACTIONS(324),
    [anon_sym_STAR_EQ] = ACTIONS(324),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(324),
    [anon_sym_PERCENT_EQ] = ACTIONS(324),
    [anon_sym_LT_LT_EQ] = ACTIONS(324),
    [anon_sym_GT_GT_EQ] = ACTIONS(324),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(324),
    [anon_sym_AMP_EQ] = ACTIONS(324),
    [anon_sym_PIPE_EQ] = ACTIONS(324),
    [anon_sym_CARET_EQ] = ACTIONS(324),
    [anon_sym_LPAREN2] = ACTIONS(318),
    [anon_sym_recover] = ACTIONS(332),
    [anon_sym_return] = ACTIONS(332),
    [anon_sym_try] = ACTIONS(332),
    [anon_sym_throw] = ACTIONS(332),
    [anon_sym_while] = ACTIONS(332),
    [anon_sym_loop] = ACTIONS(332),
    [anon_sym_match] = ACTIONS(332),
    [anon_sym_or] = ACTIONS(332),
    [anon_sym_true] = ACTIONS(332),
    [anon_sym_false] = ACTIONS(332),
    [sym_float] = ACTIONS(318),
    [sym_integer] = ACTIONS(332),
    [anon_sym_SQUOTE] = ACTIONS(318),
    [sym_self] = ACTIONS(332),
    [sym_nil] = ACTIONS(332),
    [sym_break] = ACTIONS(332),
    [sym_next] = ACTIONS(332),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(332),
    [sym_field] = ACTIONS(318),
    [sym_constant] = ACTIONS(318),
  },
  [12] = {
    [sym_block] = STATE(621),
    [sym__expression] = STATE(621),
    [sym_assign_receiver_field] = STATE(621),
    [sym_assign_local] = STATE(621),
    [sym_assign_field] = STATE(621),
    [sym_replace_local] = STATE(621),
    [sym_replace_field] = STATE(621),
    [sym_compound_assign_local] = STATE(621),
    [sym_compound_assign_field] = STATE(621),
    [sym_compound_assign_receiver_field] = STATE(621),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(621),
    [sym__call_argument] = STATE(1007),
    [sym_named_argument] = STATE(1007),
    [sym_call_with_receiver] = STATE(621),
    [sym_ref] = STATE(621),
    [sym_mut] = STATE(621),
    [sym_recover] = STATE(621),
    [sym_grouped_expression] = STATE(621),
    [sym_tuple] = STATE(621),
    [sym_array] = STATE(621),
    [sym_return] = STATE(621),
    [sym_try] = STATE(621),
    [sym_throw] = STATE(621),
    [sym_if] = STATE(621),
    [sym_while] = STATE(621),
    [sym_loop] = STATE(621),
    [sym_for] = STATE(621),
    [sym_match] = STATE(621),
    [sym_closure] = STATE(621),
    [sym_define_variable] = STATE(621),
    [sym_and_or] = STATE(621),
    [sym_binary] = STATE(621),
    [sym_cast] = STATE(621),
    [sym_string] = STATE(621),
    [sym_true] = STATE(621),
    [sym_false] = STATE(621),
    [sym_identifier] = ACTIONS(334),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_RPAREN] = ACTIONS(336),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(338),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(340),
    [sym_nil] = ACTIONS(340),
    [sym_break] = ACTIONS(340),
    [sym_next] = ACTIONS(340),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [13] = {
    [sym_block] = STATE(621),
    [sym__expression] = STATE(621),
    [sym_assign_receiver_field] = STATE(621),
    [sym_assign_local] = STATE(621),
    [sym_assign_field] = STATE(621),
    [sym_replace_local] = STATE(621),
    [sym_replace_field] = STATE(621),
    [sym_compound_assign_local] = STATE(621),
    [sym_compound_assign_field] = STATE(621),
    [sym_compound_assign_receiver_field] = STATE(621),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(621),
    [sym__call_argument] = STATE(1200),
    [sym_named_argument] = STATE(1200),
    [sym_call_with_receiver] = STATE(621),
    [sym_ref] = STATE(621),
    [sym_mut] = STATE(621),
    [sym_recover] = STATE(621),
    [sym_grouped_expression] = STATE(621),
    [sym_tuple] = STATE(621),
    [sym_array] = STATE(621),
    [sym_return] = STATE(621),
    [sym_try] = STATE(621),
    [sym_throw] = STATE(621),
    [sym_if] = STATE(621),
    [sym_while] = STATE(621),
    [sym_loop] = STATE(621),
    [sym_for] = STATE(621),
    [sym_match] = STATE(621),
    [sym_closure] = STATE(621),
    [sym_define_variable] = STATE(621),
    [sym_and_or] = STATE(621),
    [sym_binary] = STATE(621),
    [sym_cast] = STATE(621),
    [sym_string] = STATE(621),
    [sym_true] = STATE(621),
    [sym_false] = STATE(621),
    [sym_identifier] = ACTIONS(334),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_RPAREN] = ACTIONS(342),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(338),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(340),
    [sym_nil] = ACTIONS(340),
    [sym_break] = ACTIONS(340),
    [sym_next] = ACTIONS(340),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [14] = {
    [sym_block] = STATE(621),
    [sym__expression] = STATE(621),
    [sym_assign_receiver_field] = STATE(621),
    [sym_assign_local] = STATE(621),
    [sym_assign_field] = STATE(621),
    [sym_replace_local] = STATE(621),
    [sym_replace_field] = STATE(621),
    [sym_compound_assign_local] = STATE(621),
    [sym_compound_assign_field] = STATE(621),
    [sym_compound_assign_receiver_field] = STATE(621),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(621),
    [sym__call_argument] = STATE(1200),
    [sym_named_argument] = STATE(1200),
    [sym_call_with_receiver] = STATE(621),
    [sym_ref] = STATE(621),
    [sym_mut] = STATE(621),
    [sym_recover] = STATE(621),
    [sym_grouped_expression] = STATE(621),
    [sym_tuple] = STATE(621),
    [sym_array] = STATE(621),
    [sym_return] = STATE(621),
    [sym_try] = STATE(621),
    [sym_throw] = STATE(621),
    [sym_if] = STATE(621),
    [sym_while] = STATE(621),
    [sym_loop] = STATE(621),
    [sym_for] = STATE(621),
    [sym_match] = STATE(621),
    [sym_closure] = STATE(621),
    [sym_define_variable] = STATE(621),
    [sym_and_or] = STATE(621),
    [sym_binary] = STATE(621),
    [sym_cast] = STATE(621),
    [sym_string] = STATE(621),
    [sym_true] = STATE(621),
    [sym_false] = STATE(621),
    [sym_identifier] = ACTIONS(334),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_RPAREN] = ACTIONS(344),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(338),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(340),
    [sym_nil] = ACTIONS(340),
    [sym_break] = ACTIONS(340),
    [sym_next] = ACTIONS(340),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [15] = {
    [sym_block] = STATE(621),
    [sym__expression] = STATE(621),
    [sym_assign_receiver_field] = STATE(621),
    [sym_assign_local] = STATE(621),
    [sym_assign_field] = STATE(621),
    [sym_replace_local] = STATE(621),
    [sym_replace_field] = STATE(621),
    [sym_compound_assign_local] = STATE(621),
    [sym_compound_assign_field] = STATE(621),
    [sym_compound_assign_receiver_field] = STATE(621),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(621),
    [sym__call_argument] = STATE(1200),
    [sym_named_argument] = STATE(1200),
    [sym_call_with_receiver] = STATE(621),
    [sym_ref] = STATE(621),
    [sym_mut] = STATE(621),
    [sym_recover] = STATE(621),
    [sym_grouped_expression] = STATE(621),
    [sym_tuple] = STATE(621),
    [sym_array] = STATE(621),
    [sym_return] = STATE(621),
    [sym_try] = STATE(621),
    [sym_throw] = STATE(621),
    [sym_if] = STATE(621),
    [sym_while] = STATE(621),
    [sym_loop] = STATE(621),
    [sym_for] = STATE(621),
    [sym_match] = STATE(621),
    [sym_closure] = STATE(621),
    [sym_define_variable] = STATE(621),
    [sym_and_or] = STATE(621),
    [sym_binary] = STATE(621),
    [sym_cast] = STATE(621),
    [sym_string] = STATE(621),
    [sym_true] = STATE(621),
    [sym_false] = STATE(621),
    [sym_identifier] = ACTIONS(334),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_RPAREN] = ACTIONS(346),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(338),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(340),
    [sym_nil] = ACTIONS(340),
    [sym_break] = ACTIONS(340),
    [sym_next] = ACTIONS(340),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [16] = {
    [sym_identifier] = ACTIONS(310),
    [anon_sym_DOT] = ACTIONS(308),
    [anon_sym_LPAREN] = ACTIONS(310),
    [anon_sym_as] = ACTIONS(310),
    [anon_sym_if] = ACTIONS(310),
    [anon_sym_and] = ACTIONS(310),
    [anon_sym_DQUOTE] = ACTIONS(308),
    [anon_sym_fn] = ACTIONS(310),
    [anon_sym_PLUS] = ACTIONS(310),
    [anon_sym_DASH] = ACTIONS(310),
    [anon_sym_SLASH] = ACTIONS(310),
    [anon_sym_STAR] = ACTIONS(310),
    [anon_sym_STAR_STAR] = ACTIONS(310),
    [anon_sym_PERCENT] = ACTIONS(310),
    [anon_sym_LT] = ACTIONS(310),
    [anon_sym_GT] = ACTIONS(310),
    [anon_sym_LT_EQ] = ACTIONS(308),
    [anon_sym_GT_EQ] = ACTIONS(308),
    [anon_sym_LT_LT] = ACTIONS(310),
    [anon_sym_GT_GT] = ACTIONS(310),
    [anon_sym_GT_GT_GT] = ACTIONS(310),
    [anon_sym_AMP] = ACTIONS(310),
    [anon_sym_PIPE] = ACTIONS(310),
    [anon_sym_CARET] = ACTIONS(310),
    [anon_sym_EQ_EQ] = ACTIONS(308),
    [anon_sym_BANG_EQ] = ACTIONS(308),
    [anon_sym_LBRACK] = ACTIONS(308),
    [anon_sym_mut] = ACTIONS(310),
    [anon_sym_LBRACE] = ACTIONS(308),
    [anon_sym_RBRACE] = ACTIONS(308),
    [anon_sym_let] = ACTIONS(310),
    [anon_sym_for] = ACTIONS(310),
    [anon_sym_ref] = ACTIONS(310),
    [anon_sym_EQ] = ACTIONS(348),
    [anon_sym_COLON_EQ] = ACTIONS(350),
    [anon_sym_PLUS_EQ] = ACTIONS(352),
    [anon_sym_DASH_EQ] = ACTIONS(352),
    [anon_sym_SLASH_EQ] = ACTIONS(352),
    [anon_sym_STAR_EQ] = ACTIONS(352),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(352),
    [anon_sym_PERCENT_EQ] = ACTIONS(352),
    [anon_sym_LT_LT_EQ] = ACTIONS(352),
    [anon_sym_GT_GT_EQ] = ACTIONS(352),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(352),
    [anon_sym_AMP_EQ] = ACTIONS(352),
    [anon_sym_PIPE_EQ] = ACTIONS(352),
    [anon_sym_CARET_EQ] = ACTIONS(352),
    [anon_sym_LPAREN2] = ACTIONS(318),
    [anon_sym_recover] = ACTIONS(310),
    [anon_sym_return] = ACTIONS(310),
    [anon_sym_try] = ACTIONS(310),
    [anon_sym_throw] = ACTIONS(310),
    [anon_sym_while] = ACTIONS(310),
    [anon_sym_loop] = ACTIONS(310),
    [anon_sym_match] = ACTIONS(310),
    [anon_sym_or] = ACTIONS(310),
    [anon_sym_true] = ACTIONS(310),
    [anon_sym_false] = ACTIONS(310),
    [sym_float] = ACTIONS(308),
    [sym_integer] = ACTIONS(310),
    [anon_sym_SQUOTE] = ACTIONS(308),
    [sym_self] = ACTIONS(310),
    [sym_nil] = ACTIONS(310),
    [sym_break] = ACTIONS(310),
    [sym_next] = ACTIONS(310),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(310),
    [sym_field] = ACTIONS(308),
    [sym_constant] = ACTIONS(308),
  },
  [17] = {
    [sym_block] = STATE(621),
    [sym__expression] = STATE(621),
    [sym_assign_receiver_field] = STATE(621),
    [sym_assign_local] = STATE(621),
    [sym_assign_field] = STATE(621),
    [sym_replace_local] = STATE(621),
    [sym_replace_field] = STATE(621),
    [sym_compound_assign_local] = STATE(621),
    [sym_compound_assign_field] = STATE(621),
    [sym_compound_assign_receiver_field] = STATE(621),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(621),
    [sym__call_argument] = STATE(1041),
    [sym_named_argument] = STATE(1041),
    [sym_call_with_receiver] = STATE(621),
    [sym_ref] = STATE(621),
    [sym_mut] = STATE(621),
    [sym_recover] = STATE(621),
    [sym_grouped_expression] = STATE(621),
    [sym_tuple] = STATE(621),
    [sym_array] = STATE(621),
    [sym_return] = STATE(621),
    [sym_try] = STATE(621),
    [sym_throw] = STATE(621),
    [sym_if] = STATE(621),
    [sym_while] = STATE(621),
    [sym_loop] = STATE(621),
    [sym_for] = STATE(621),
    [sym_match] = STATE(621),
    [sym_closure] = STATE(621),
    [sym_define_variable] = STATE(621),
    [sym_and_or] = STATE(621),
    [sym_binary] = STATE(621),
    [sym_cast] = STATE(621),
    [sym_string] = STATE(621),
    [sym_true] = STATE(621),
    [sym_false] = STATE(621),
    [sym_identifier] = ACTIONS(334),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_RPAREN] = ACTIONS(354),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(338),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(340),
    [sym_nil] = ACTIONS(340),
    [sym_break] = ACTIONS(340),
    [sym_next] = ACTIONS(340),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [18] = {
    [sym_block] = STATE(621),
    [sym__expression] = STATE(621),
    [sym_assign_receiver_field] = STATE(621),
    [sym_assign_local] = STATE(621),
    [sym_assign_field] = STATE(621),
    [sym_replace_local] = STATE(621),
    [sym_replace_field] = STATE(621),
    [sym_compound_assign_local] = STATE(621),
    [sym_compound_assign_field] = STATE(621),
    [sym_compound_assign_receiver_field] = STATE(621),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(621),
    [sym__call_argument] = STATE(1200),
    [sym_named_argument] = STATE(1200),
    [sym_call_with_receiver] = STATE(621),
    [sym_ref] = STATE(621),
    [sym_mut] = STATE(621),
    [sym_recover] = STATE(621),
    [sym_grouped_expression] = STATE(621),
    [sym_tuple] = STATE(621),
    [sym_array] = STATE(621),
    [sym_return] = STATE(621),
    [sym_try] = STATE(621),
    [sym_throw] = STATE(621),
    [sym_if] = STATE(621),
    [sym_while] = STATE(621),
    [sym_loop] = STATE(621),
    [sym_for] = STATE(621),
    [sym_match] = STATE(621),
    [sym_closure] = STATE(621),
    [sym_define_variable] = STATE(621),
    [sym_and_or] = STATE(621),
    [sym_binary] = STATE(621),
    [sym_cast] = STATE(621),
    [sym_string] = STATE(621),
    [sym_true] = STATE(621),
    [sym_false] = STATE(621),
    [sym_identifier] = ACTIONS(334),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_RPAREN] = ACTIONS(356),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(338),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(340),
    [sym_nil] = ACTIONS(340),
    [sym_break] = ACTIONS(340),
    [sym_next] = ACTIONS(340),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [19] = {
    [sym_block] = STATE(621),
    [sym__expression] = STATE(621),
    [sym_assign_receiver_field] = STATE(621),
    [sym_assign_local] = STATE(621),
    [sym_assign_field] = STATE(621),
    [sym_replace_local] = STATE(621),
    [sym_replace_field] = STATE(621),
    [sym_compound_assign_local] = STATE(621),
    [sym_compound_assign_field] = STATE(621),
    [sym_compound_assign_receiver_field] = STATE(621),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(621),
    [sym__call_argument] = STATE(1200),
    [sym_named_argument] = STATE(1200),
    [sym_call_with_receiver] = STATE(621),
    [sym_ref] = STATE(621),
    [sym_mut] = STATE(621),
    [sym_recover] = STATE(621),
    [sym_grouped_expression] = STATE(621),
    [sym_tuple] = STATE(621),
    [sym_array] = STATE(621),
    [sym_return] = STATE(621),
    [sym_try] = STATE(621),
    [sym_throw] = STATE(621),
    [sym_if] = STATE(621),
    [sym_while] = STATE(621),
    [sym_loop] = STATE(621),
    [sym_for] = STATE(621),
    [sym_match] = STATE(621),
    [sym_closure] = STATE(621),
    [sym_define_variable] = STATE(621),
    [sym_and_or] = STATE(621),
    [sym_binary] = STATE(621),
    [sym_cast] = STATE(621),
    [sym_string] = STATE(621),
    [sym_true] = STATE(621),
    [sym_false] = STATE(621),
    [sym_identifier] = ACTIONS(334),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_RPAREN] = ACTIONS(358),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(338),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(340),
    [sym_nil] = ACTIONS(340),
    [sym_break] = ACTIONS(340),
    [sym_next] = ACTIONS(340),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [20] = {
    [sym_block] = STATE(621),
    [sym__expression] = STATE(621),
    [sym_assign_receiver_field] = STATE(621),
    [sym_assign_local] = STATE(621),
    [sym_assign_field] = STATE(621),
    [sym_replace_local] = STATE(621),
    [sym_replace_field] = STATE(621),
    [sym_compound_assign_local] = STATE(621),
    [sym_compound_assign_field] = STATE(621),
    [sym_compound_assign_receiver_field] = STATE(621),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(621),
    [sym__call_argument] = STATE(1025),
    [sym_named_argument] = STATE(1025),
    [sym_call_with_receiver] = STATE(621),
    [sym_ref] = STATE(621),
    [sym_mut] = STATE(621),
    [sym_recover] = STATE(621),
    [sym_grouped_expression] = STATE(621),
    [sym_tuple] = STATE(621),
    [sym_array] = STATE(621),
    [sym_return] = STATE(621),
    [sym_try] = STATE(621),
    [sym_throw] = STATE(621),
    [sym_if] = STATE(621),
    [sym_while] = STATE(621),
    [sym_loop] = STATE(621),
    [sym_for] = STATE(621),
    [sym_match] = STATE(621),
    [sym_closure] = STATE(621),
    [sym_define_variable] = STATE(621),
    [sym_and_or] = STATE(621),
    [sym_binary] = STATE(621),
    [sym_cast] = STATE(621),
    [sym_string] = STATE(621),
    [sym_true] = STATE(621),
    [sym_false] = STATE(621),
    [sym_identifier] = ACTIONS(334),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_RPAREN] = ACTIONS(360),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(338),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(340),
    [sym_nil] = ACTIONS(340),
    [sym_break] = ACTIONS(340),
    [sym_next] = ACTIONS(340),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [21] = {
    [sym_block] = STATE(621),
    [sym__expression] = STATE(621),
    [sym_assign_receiver_field] = STATE(621),
    [sym_assign_local] = STATE(621),
    [sym_assign_field] = STATE(621),
    [sym_replace_local] = STATE(621),
    [sym_replace_field] = STATE(621),
    [sym_compound_assign_local] = STATE(621),
    [sym_compound_assign_field] = STATE(621),
    [sym_compound_assign_receiver_field] = STATE(621),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(621),
    [sym__call_argument] = STATE(1200),
    [sym_named_argument] = STATE(1200),
    [sym_call_with_receiver] = STATE(621),
    [sym_ref] = STATE(621),
    [sym_mut] = STATE(621),
    [sym_recover] = STATE(621),
    [sym_grouped_expression] = STATE(621),
    [sym_tuple] = STATE(621),
    [sym_array] = STATE(621),
    [sym_return] = STATE(621),
    [sym_try] = STATE(621),
    [sym_throw] = STATE(621),
    [sym_if] = STATE(621),
    [sym_while] = STATE(621),
    [sym_loop] = STATE(621),
    [sym_for] = STATE(621),
    [sym_match] = STATE(621),
    [sym_closure] = STATE(621),
    [sym_define_variable] = STATE(621),
    [sym_and_or] = STATE(621),
    [sym_binary] = STATE(621),
    [sym_cast] = STATE(621),
    [sym_string] = STATE(621),
    [sym_true] = STATE(621),
    [sym_false] = STATE(621),
    [sym_identifier] = ACTIONS(334),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_RPAREN] = ACTIONS(362),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(338),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(340),
    [sym_nil] = ACTIONS(340),
    [sym_break] = ACTIONS(340),
    [sym_next] = ACTIONS(340),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [22] = {
    [sym_block] = STATE(318),
    [sym__expression] = STATE(318),
    [sym_assign_receiver_field] = STATE(318),
    [sym_assign_local] = STATE(318),
    [sym_assign_field] = STATE(318),
    [sym_replace_local] = STATE(318),
    [sym_replace_field] = STATE(318),
    [sym_compound_assign_local] = STATE(318),
    [sym_compound_assign_field] = STATE(318),
    [sym_compound_assign_receiver_field] = STATE(318),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(318),
    [sym_call_with_receiver] = STATE(318),
    [sym_ref] = STATE(318),
    [sym_mut] = STATE(318),
    [sym_recover] = STATE(318),
    [sym_grouped_expression] = STATE(318),
    [sym_tuple] = STATE(318),
    [sym_array] = STATE(318),
    [sym_return] = STATE(318),
    [sym_try] = STATE(318),
    [sym_throw] = STATE(318),
    [sym_if] = STATE(318),
    [sym_while] = STATE(318),
    [sym_loop] = STATE(318),
    [sym_for] = STATE(318),
    [sym_match] = STATE(318),
    [sym_closure] = STATE(318),
    [sym_define_variable] = STATE(318),
    [sym_and_or] = STATE(318),
    [sym_binary] = STATE(318),
    [sym_cast] = STATE(318),
    [sym_string] = STATE(318),
    [sym_true] = STATE(318),
    [sym_false] = STATE(318),
    [aux_sym_block_repeat1] = STATE(24),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_RBRACE] = ACTIONS(364),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(366),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(368),
    [sym_nil] = ACTIONS(368),
    [sym_break] = ACTIONS(368),
    [sym_next] = ACTIONS(368),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [23] = {
    [sym_block] = STATE(318),
    [sym__expression] = STATE(318),
    [sym_assign_receiver_field] = STATE(318),
    [sym_assign_local] = STATE(318),
    [sym_assign_field] = STATE(318),
    [sym_replace_local] = STATE(318),
    [sym_replace_field] = STATE(318),
    [sym_compound_assign_local] = STATE(318),
    [sym_compound_assign_field] = STATE(318),
    [sym_compound_assign_receiver_field] = STATE(318),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(318),
    [sym_call_with_receiver] = STATE(318),
    [sym_ref] = STATE(318),
    [sym_mut] = STATE(318),
    [sym_recover] = STATE(318),
    [sym_grouped_expression] = STATE(318),
    [sym_tuple] = STATE(318),
    [sym_array] = STATE(318),
    [sym_return] = STATE(318),
    [sym_try] = STATE(318),
    [sym_throw] = STATE(318),
    [sym_if] = STATE(318),
    [sym_while] = STATE(318),
    [sym_loop] = STATE(318),
    [sym_for] = STATE(318),
    [sym_match] = STATE(318),
    [sym_closure] = STATE(318),
    [sym_define_variable] = STATE(318),
    [sym_and_or] = STATE(318),
    [sym_binary] = STATE(318),
    [sym_cast] = STATE(318),
    [sym_string] = STATE(318),
    [sym_true] = STATE(318),
    [sym_false] = STATE(318),
    [aux_sym_block_repeat1] = STATE(29),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_RBRACE] = ACTIONS(370),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(366),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(368),
    [sym_nil] = ACTIONS(368),
    [sym_break] = ACTIONS(368),
    [sym_next] = ACTIONS(368),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [24] = {
    [sym_block] = STATE(318),
    [sym__expression] = STATE(318),
    [sym_assign_receiver_field] = STATE(318),
    [sym_assign_local] = STATE(318),
    [sym_assign_field] = STATE(318),
    [sym_replace_local] = STATE(318),
    [sym_replace_field] = STATE(318),
    [sym_compound_assign_local] = STATE(318),
    [sym_compound_assign_field] = STATE(318),
    [sym_compound_assign_receiver_field] = STATE(318),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(318),
    [sym_call_with_receiver] = STATE(318),
    [sym_ref] = STATE(318),
    [sym_mut] = STATE(318),
    [sym_recover] = STATE(318),
    [sym_grouped_expression] = STATE(318),
    [sym_tuple] = STATE(318),
    [sym_array] = STATE(318),
    [sym_return] = STATE(318),
    [sym_try] = STATE(318),
    [sym_throw] = STATE(318),
    [sym_if] = STATE(318),
    [sym_while] = STATE(318),
    [sym_loop] = STATE(318),
    [sym_for] = STATE(318),
    [sym_match] = STATE(318),
    [sym_closure] = STATE(318),
    [sym_define_variable] = STATE(318),
    [sym_and_or] = STATE(318),
    [sym_binary] = STATE(318),
    [sym_cast] = STATE(318),
    [sym_string] = STATE(318),
    [sym_true] = STATE(318),
    [sym_false] = STATE(318),
    [aux_sym_block_repeat1] = STATE(24),
    [sym_identifier] = ACTIONS(372),
    [anon_sym_LPAREN] = ACTIONS(375),
    [anon_sym_if] = ACTIONS(378),
    [anon_sym_DQUOTE] = ACTIONS(381),
    [anon_sym_fn] = ACTIONS(384),
    [anon_sym_LBRACK] = ACTIONS(387),
    [anon_sym_mut] = ACTIONS(390),
    [anon_sym_LBRACE] = ACTIONS(393),
    [anon_sym_RBRACE] = ACTIONS(396),
    [anon_sym_let] = ACTIONS(398),
    [anon_sym_for] = ACTIONS(401),
    [anon_sym_ref] = ACTIONS(404),
    [anon_sym_recover] = ACTIONS(407),
    [anon_sym_return] = ACTIONS(410),
    [anon_sym_try] = ACTIONS(413),
    [anon_sym_throw] = ACTIONS(416),
    [anon_sym_while] = ACTIONS(419),
    [anon_sym_loop] = ACTIONS(422),
    [anon_sym_match] = ACTIONS(425),
    [anon_sym_true] = ACTIONS(428),
    [anon_sym_false] = ACTIONS(431),
    [sym_float] = ACTIONS(434),
    [sym_integer] = ACTIONS(437),
    [anon_sym_SQUOTE] = ACTIONS(440),
    [sym_self] = ACTIONS(443),
    [sym_nil] = ACTIONS(443),
    [sym_break] = ACTIONS(443),
    [sym_next] = ACTIONS(443),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(446),
    [sym_field] = ACTIONS(449),
    [sym_constant] = ACTIONS(452),
  },
  [25] = {
    [sym_identifier] = ACTIONS(310),
    [anon_sym_DOT] = ACTIONS(308),
    [anon_sym_LPAREN] = ACTIONS(308),
    [anon_sym_as] = ACTIONS(310),
    [anon_sym_if] = ACTIONS(310),
    [anon_sym_and] = ACTIONS(310),
    [anon_sym_DQUOTE] = ACTIONS(308),
    [anon_sym_fn] = ACTIONS(310),
    [anon_sym_PLUS] = ACTIONS(310),
    [anon_sym_DASH] = ACTIONS(310),
    [anon_sym_SLASH] = ACTIONS(310),
    [anon_sym_STAR] = ACTIONS(310),
    [anon_sym_STAR_STAR] = ACTIONS(310),
    [anon_sym_PERCENT] = ACTIONS(310),
    [anon_sym_LT] = ACTIONS(310),
    [anon_sym_GT] = ACTIONS(310),
    [anon_sym_LT_EQ] = ACTIONS(308),
    [anon_sym_GT_EQ] = ACTIONS(308),
    [anon_sym_LT_LT] = ACTIONS(310),
    [anon_sym_GT_GT] = ACTIONS(310),
    [anon_sym_GT_GT_GT] = ACTIONS(310),
    [anon_sym_AMP] = ACTIONS(310),
    [anon_sym_PIPE] = ACTIONS(310),
    [anon_sym_CARET] = ACTIONS(310),
    [anon_sym_EQ_EQ] = ACTIONS(308),
    [anon_sym_BANG_EQ] = ACTIONS(308),
    [anon_sym_LBRACK] = ACTIONS(308),
    [anon_sym_mut] = ACTIONS(310),
    [anon_sym_LBRACE] = ACTIONS(308),
    [anon_sym_RBRACE] = ACTIONS(308),
    [anon_sym_let] = ACTIONS(310),
    [anon_sym_for] = ACTIONS(310),
    [anon_sym_ref] = ACTIONS(310),
    [anon_sym_EQ] = ACTIONS(455),
    [anon_sym_COLON_EQ] = ACTIONS(457),
    [anon_sym_PLUS_EQ] = ACTIONS(459),
    [anon_sym_DASH_EQ] = ACTIONS(459),
    [anon_sym_SLASH_EQ] = ACTIONS(459),
    [anon_sym_STAR_EQ] = ACTIONS(459),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(459),
    [anon_sym_PERCENT_EQ] = ACTIONS(459),
    [anon_sym_LT_LT_EQ] = ACTIONS(459),
    [anon_sym_GT_GT_EQ] = ACTIONS(459),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(459),
    [anon_sym_AMP_EQ] = ACTIONS(459),
    [anon_sym_PIPE_EQ] = ACTIONS(459),
    [anon_sym_CARET_EQ] = ACTIONS(459),
    [anon_sym_recover] = ACTIONS(310),
    [anon_sym_return] = ACTIONS(310),
    [anon_sym_try] = ACTIONS(310),
    [anon_sym_throw] = ACTIONS(310),
    [anon_sym_while] = ACTIONS(310),
    [anon_sym_loop] = ACTIONS(310),
    [anon_sym_match] = ACTIONS(310),
    [anon_sym_or] = ACTIONS(310),
    [anon_sym_true] = ACTIONS(310),
    [anon_sym_false] = ACTIONS(310),
    [sym_float] = ACTIONS(308),
    [sym_integer] = ACTIONS(310),
    [anon_sym_SQUOTE] = ACTIONS(308),
    [sym_self] = ACTIONS(310),
    [sym_nil] = ACTIONS(310),
    [sym_break] = ACTIONS(310),
    [sym_next] = ACTIONS(310),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(310),
    [sym_field] = ACTIONS(308),
    [sym_constant] = ACTIONS(308),
  },
  [26] = {
    [sym_block] = STATE(318),
    [sym__expression] = STATE(318),
    [sym_assign_receiver_field] = STATE(318),
    [sym_assign_local] = STATE(318),
    [sym_assign_field] = STATE(318),
    [sym_replace_local] = STATE(318),
    [sym_replace_field] = STATE(318),
    [sym_compound_assign_local] = STATE(318),
    [sym_compound_assign_field] = STATE(318),
    [sym_compound_assign_receiver_field] = STATE(318),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(318),
    [sym_call_with_receiver] = STATE(318),
    [sym_ref] = STATE(318),
    [sym_mut] = STATE(318),
    [sym_recover] = STATE(318),
    [sym_grouped_expression] = STATE(318),
    [sym_tuple] = STATE(318),
    [sym_array] = STATE(318),
    [sym_return] = STATE(318),
    [sym_try] = STATE(318),
    [sym_throw] = STATE(318),
    [sym_if] = STATE(318),
    [sym_while] = STATE(318),
    [sym_loop] = STATE(318),
    [sym_for] = STATE(318),
    [sym_match] = STATE(318),
    [sym_closure] = STATE(318),
    [sym_define_variable] = STATE(318),
    [sym_and_or] = STATE(318),
    [sym_binary] = STATE(318),
    [sym_cast] = STATE(318),
    [sym_string] = STATE(318),
    [sym_true] = STATE(318),
    [sym_false] = STATE(318),
    [aux_sym_block_repeat1] = STATE(36),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_RBRACE] = ACTIONS(461),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(366),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(368),
    [sym_nil] = ACTIONS(368),
    [sym_break] = ACTIONS(368),
    [sym_next] = ACTIONS(368),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [27] = {
    [sym_identifier] = ACTIONS(322),
    [anon_sym_DOT] = ACTIONS(320),
    [anon_sym_LPAREN] = ACTIONS(322),
    [anon_sym_as] = ACTIONS(322),
    [anon_sym_if] = ACTIONS(322),
    [anon_sym_and] = ACTIONS(322),
    [anon_sym_DQUOTE] = ACTIONS(320),
    [anon_sym_fn] = ACTIONS(322),
    [anon_sym_PLUS] = ACTIONS(322),
    [anon_sym_DASH] = ACTIONS(322),
    [anon_sym_SLASH] = ACTIONS(322),
    [anon_sym_STAR] = ACTIONS(322),
    [anon_sym_STAR_STAR] = ACTIONS(322),
    [anon_sym_PERCENT] = ACTIONS(322),
    [anon_sym_LT] = ACTIONS(322),
    [anon_sym_GT] = ACTIONS(322),
    [anon_sym_LT_EQ] = ACTIONS(320),
    [anon_sym_GT_EQ] = ACTIONS(320),
    [anon_sym_LT_LT] = ACTIONS(322),
    [anon_sym_GT_GT] = ACTIONS(322),
    [anon_sym_GT_GT_GT] = ACTIONS(322),
    [anon_sym_AMP] = ACTIONS(322),
    [anon_sym_PIPE] = ACTIONS(322),
    [anon_sym_CARET] = ACTIONS(322),
    [anon_sym_EQ_EQ] = ACTIONS(320),
    [anon_sym_BANG_EQ] = ACTIONS(320),
    [anon_sym_LBRACK] = ACTIONS(320),
    [anon_sym_mut] = ACTIONS(322),
    [anon_sym_LBRACE] = ACTIONS(320),
    [anon_sym_RBRACE] = ACTIONS(320),
    [anon_sym_let] = ACTIONS(322),
    [anon_sym_for] = ACTIONS(322),
    [anon_sym_ref] = ACTIONS(322),
    [anon_sym_EQ] = ACTIONS(322),
    [anon_sym_PLUS_EQ] = ACTIONS(463),
    [anon_sym_DASH_EQ] = ACTIONS(463),
    [anon_sym_SLASH_EQ] = ACTIONS(463),
    [anon_sym_STAR_EQ] = ACTIONS(463),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(463),
    [anon_sym_PERCENT_EQ] = ACTIONS(463),
    [anon_sym_LT_LT_EQ] = ACTIONS(463),
    [anon_sym_GT_GT_EQ] = ACTIONS(463),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(463),
    [anon_sym_AMP_EQ] = ACTIONS(463),
    [anon_sym_PIPE_EQ] = ACTIONS(463),
    [anon_sym_CARET_EQ] = ACTIONS(463),
    [anon_sym_LPAREN2] = ACTIONS(320),
    [anon_sym_recover] = ACTIONS(322),
    [anon_sym_return] = ACTIONS(322),
    [anon_sym_try] = ACTIONS(322),
    [anon_sym_throw] = ACTIONS(322),
    [anon_sym_while] = ACTIONS(322),
    [anon_sym_loop] = ACTIONS(322),
    [anon_sym_match] = ACTIONS(322),
    [anon_sym_or] = ACTIONS(322),
    [anon_sym_true] = ACTIONS(322),
    [anon_sym_false] = ACTIONS(322),
    [sym_float] = ACTIONS(320),
    [sym_integer] = ACTIONS(322),
    [anon_sym_SQUOTE] = ACTIONS(320),
    [sym_self] = ACTIONS(322),
    [sym_nil] = ACTIONS(322),
    [sym_break] = ACTIONS(322),
    [sym_next] = ACTIONS(322),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(322),
    [sym_field] = ACTIONS(320),
    [sym_constant] = ACTIONS(320),
  },
  [28] = {
    [sym_identifier] = ACTIONS(332),
    [anon_sym_DOT] = ACTIONS(318),
    [anon_sym_LPAREN] = ACTIONS(332),
    [anon_sym_as] = ACTIONS(332),
    [anon_sym_if] = ACTIONS(332),
    [anon_sym_and] = ACTIONS(332),
    [anon_sym_DQUOTE] = ACTIONS(318),
    [anon_sym_fn] = ACTIONS(332),
    [anon_sym_PLUS] = ACTIONS(332),
    [anon_sym_DASH] = ACTIONS(332),
    [anon_sym_SLASH] = ACTIONS(332),
    [anon_sym_STAR] = ACTIONS(332),
    [anon_sym_STAR_STAR] = ACTIONS(332),
    [anon_sym_PERCENT] = ACTIONS(332),
    [anon_sym_LT] = ACTIONS(332),
    [anon_sym_GT] = ACTIONS(332),
    [anon_sym_LT_EQ] = ACTIONS(318),
    [anon_sym_GT_EQ] = ACTIONS(318),
    [anon_sym_LT_LT] = ACTIONS(332),
    [anon_sym_GT_GT] = ACTIONS(332),
    [anon_sym_GT_GT_GT] = ACTIONS(332),
    [anon_sym_AMP] = ACTIONS(332),
    [anon_sym_PIPE] = ACTIONS(332),
    [anon_sym_CARET] = ACTIONS(332),
    [anon_sym_EQ_EQ] = ACTIONS(318),
    [anon_sym_BANG_EQ] = ACTIONS(318),
    [anon_sym_LBRACK] = ACTIONS(318),
    [anon_sym_mut] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(318),
    [anon_sym_RBRACE] = ACTIONS(318),
    [anon_sym_let] = ACTIONS(332),
    [anon_sym_for] = ACTIONS(332),
    [anon_sym_ref] = ACTIONS(332),
    [anon_sym_EQ] = ACTIONS(332),
    [anon_sym_PLUS_EQ] = ACTIONS(463),
    [anon_sym_DASH_EQ] = ACTIONS(463),
    [anon_sym_SLASH_EQ] = ACTIONS(463),
    [anon_sym_STAR_EQ] = ACTIONS(463),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(463),
    [anon_sym_PERCENT_EQ] = ACTIONS(463),
    [anon_sym_LT_LT_EQ] = ACTIONS(463),
    [anon_sym_GT_GT_EQ] = ACTIONS(463),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(463),
    [anon_sym_AMP_EQ] = ACTIONS(463),
    [anon_sym_PIPE_EQ] = ACTIONS(463),
    [anon_sym_CARET_EQ] = ACTIONS(463),
    [anon_sym_LPAREN2] = ACTIONS(318),
    [anon_sym_recover] = ACTIONS(332),
    [anon_sym_return] = ACTIONS(332),
    [anon_sym_try] = ACTIONS(332),
    [anon_sym_throw] = ACTIONS(332),
    [anon_sym_while] = ACTIONS(332),
    [anon_sym_loop] = ACTIONS(332),
    [anon_sym_match] = ACTIONS(332),
    [anon_sym_or] = ACTIONS(332),
    [anon_sym_true] = ACTIONS(332),
    [anon_sym_false] = ACTIONS(332),
    [sym_float] = ACTIONS(318),
    [sym_integer] = ACTIONS(332),
    [anon_sym_SQUOTE] = ACTIONS(318),
    [sym_self] = ACTIONS(332),
    [sym_nil] = ACTIONS(332),
    [sym_break] = ACTIONS(332),
    [sym_next] = ACTIONS(332),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(332),
    [sym_field] = ACTIONS(318),
    [sym_constant] = ACTIONS(318),
  },
  [29] = {
    [sym_block] = STATE(318),
    [sym__expression] = STATE(318),
    [sym_assign_receiver_field] = STATE(318),
    [sym_assign_local] = STATE(318),
    [sym_assign_field] = STATE(318),
    [sym_replace_local] = STATE(318),
    [sym_replace_field] = STATE(318),
    [sym_compound_assign_local] = STATE(318),
    [sym_compound_assign_field] = STATE(318),
    [sym_compound_assign_receiver_field] = STATE(318),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(318),
    [sym_call_with_receiver] = STATE(318),
    [sym_ref] = STATE(318),
    [sym_mut] = STATE(318),
    [sym_recover] = STATE(318),
    [sym_grouped_expression] = STATE(318),
    [sym_tuple] = STATE(318),
    [sym_array] = STATE(318),
    [sym_return] = STATE(318),
    [sym_try] = STATE(318),
    [sym_throw] = STATE(318),
    [sym_if] = STATE(318),
    [sym_while] = STATE(318),
    [sym_loop] = STATE(318),
    [sym_for] = STATE(318),
    [sym_match] = STATE(318),
    [sym_closure] = STATE(318),
    [sym_define_variable] = STATE(318),
    [sym_and_or] = STATE(318),
    [sym_binary] = STATE(318),
    [sym_cast] = STATE(318),
    [sym_string] = STATE(318),
    [sym_true] = STATE(318),
    [sym_false] = STATE(318),
    [aux_sym_block_repeat1] = STATE(24),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_RBRACE] = ACTIONS(465),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(366),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(368),
    [sym_nil] = ACTIONS(368),
    [sym_break] = ACTIONS(368),
    [sym_next] = ACTIONS(368),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [30] = {
    [sym_block] = STATE(318),
    [sym__expression] = STATE(318),
    [sym_assign_receiver_field] = STATE(318),
    [sym_assign_local] = STATE(318),
    [sym_assign_field] = STATE(318),
    [sym_replace_local] = STATE(318),
    [sym_replace_field] = STATE(318),
    [sym_compound_assign_local] = STATE(318),
    [sym_compound_assign_field] = STATE(318),
    [sym_compound_assign_receiver_field] = STATE(318),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(318),
    [sym_call_with_receiver] = STATE(318),
    [sym_ref] = STATE(318),
    [sym_mut] = STATE(318),
    [sym_recover] = STATE(318),
    [sym_grouped_expression] = STATE(318),
    [sym_tuple] = STATE(318),
    [sym_array] = STATE(318),
    [sym_return] = STATE(318),
    [sym_try] = STATE(318),
    [sym_throw] = STATE(318),
    [sym_if] = STATE(318),
    [sym_while] = STATE(318),
    [sym_loop] = STATE(318),
    [sym_for] = STATE(318),
    [sym_match] = STATE(318),
    [sym_closure] = STATE(318),
    [sym_define_variable] = STATE(318),
    [sym_and_or] = STATE(318),
    [sym_binary] = STATE(318),
    [sym_cast] = STATE(318),
    [sym_string] = STATE(318),
    [sym_true] = STATE(318),
    [sym_false] = STATE(318),
    [aux_sym_block_repeat1] = STATE(32),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_RBRACE] = ACTIONS(467),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(366),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(368),
    [sym_nil] = ACTIONS(368),
    [sym_break] = ACTIONS(368),
    [sym_next] = ACTIONS(368),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [31] = {
    [sym_block] = STATE(318),
    [sym__expression] = STATE(318),
    [sym_assign_receiver_field] = STATE(318),
    [sym_assign_local] = STATE(318),
    [sym_assign_field] = STATE(318),
    [sym_replace_local] = STATE(318),
    [sym_replace_field] = STATE(318),
    [sym_compound_assign_local] = STATE(318),
    [sym_compound_assign_field] = STATE(318),
    [sym_compound_assign_receiver_field] = STATE(318),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(318),
    [sym_call_with_receiver] = STATE(318),
    [sym_ref] = STATE(318),
    [sym_mut] = STATE(318),
    [sym_recover] = STATE(318),
    [sym_grouped_expression] = STATE(318),
    [sym_tuple] = STATE(318),
    [sym_array] = STATE(318),
    [sym_return] = STATE(318),
    [sym_try] = STATE(318),
    [sym_throw] = STATE(318),
    [sym_if] = STATE(318),
    [sym_while] = STATE(318),
    [sym_loop] = STATE(318),
    [sym_for] = STATE(318),
    [sym_match] = STATE(318),
    [sym_closure] = STATE(318),
    [sym_define_variable] = STATE(318),
    [sym_and_or] = STATE(318),
    [sym_binary] = STATE(318),
    [sym_cast] = STATE(318),
    [sym_string] = STATE(318),
    [sym_true] = STATE(318),
    [sym_false] = STATE(318),
    [aux_sym_block_repeat1] = STATE(33),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_RBRACE] = ACTIONS(469),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(366),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(368),
    [sym_nil] = ACTIONS(368),
    [sym_break] = ACTIONS(368),
    [sym_next] = ACTIONS(368),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [32] = {
    [sym_block] = STATE(318),
    [sym__expression] = STATE(318),
    [sym_assign_receiver_field] = STATE(318),
    [sym_assign_local] = STATE(318),
    [sym_assign_field] = STATE(318),
    [sym_replace_local] = STATE(318),
    [sym_replace_field] = STATE(318),
    [sym_compound_assign_local] = STATE(318),
    [sym_compound_assign_field] = STATE(318),
    [sym_compound_assign_receiver_field] = STATE(318),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(318),
    [sym_call_with_receiver] = STATE(318),
    [sym_ref] = STATE(318),
    [sym_mut] = STATE(318),
    [sym_recover] = STATE(318),
    [sym_grouped_expression] = STATE(318),
    [sym_tuple] = STATE(318),
    [sym_array] = STATE(318),
    [sym_return] = STATE(318),
    [sym_try] = STATE(318),
    [sym_throw] = STATE(318),
    [sym_if] = STATE(318),
    [sym_while] = STATE(318),
    [sym_loop] = STATE(318),
    [sym_for] = STATE(318),
    [sym_match] = STATE(318),
    [sym_closure] = STATE(318),
    [sym_define_variable] = STATE(318),
    [sym_and_or] = STATE(318),
    [sym_binary] = STATE(318),
    [sym_cast] = STATE(318),
    [sym_string] = STATE(318),
    [sym_true] = STATE(318),
    [sym_false] = STATE(318),
    [aux_sym_block_repeat1] = STATE(24),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_RBRACE] = ACTIONS(471),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(366),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(368),
    [sym_nil] = ACTIONS(368),
    [sym_break] = ACTIONS(368),
    [sym_next] = ACTIONS(368),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [33] = {
    [sym_block] = STATE(318),
    [sym__expression] = STATE(318),
    [sym_assign_receiver_field] = STATE(318),
    [sym_assign_local] = STATE(318),
    [sym_assign_field] = STATE(318),
    [sym_replace_local] = STATE(318),
    [sym_replace_field] = STATE(318),
    [sym_compound_assign_local] = STATE(318),
    [sym_compound_assign_field] = STATE(318),
    [sym_compound_assign_receiver_field] = STATE(318),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(318),
    [sym_call_with_receiver] = STATE(318),
    [sym_ref] = STATE(318),
    [sym_mut] = STATE(318),
    [sym_recover] = STATE(318),
    [sym_grouped_expression] = STATE(318),
    [sym_tuple] = STATE(318),
    [sym_array] = STATE(318),
    [sym_return] = STATE(318),
    [sym_try] = STATE(318),
    [sym_throw] = STATE(318),
    [sym_if] = STATE(318),
    [sym_while] = STATE(318),
    [sym_loop] = STATE(318),
    [sym_for] = STATE(318),
    [sym_match] = STATE(318),
    [sym_closure] = STATE(318),
    [sym_define_variable] = STATE(318),
    [sym_and_or] = STATE(318),
    [sym_binary] = STATE(318),
    [sym_cast] = STATE(318),
    [sym_string] = STATE(318),
    [sym_true] = STATE(318),
    [sym_false] = STATE(318),
    [aux_sym_block_repeat1] = STATE(24),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_RBRACE] = ACTIONS(473),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(366),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(368),
    [sym_nil] = ACTIONS(368),
    [sym_break] = ACTIONS(368),
    [sym_next] = ACTIONS(368),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [34] = {
    [sym_block] = STATE(318),
    [sym__expression] = STATE(318),
    [sym_assign_receiver_field] = STATE(318),
    [sym_assign_local] = STATE(318),
    [sym_assign_field] = STATE(318),
    [sym_replace_local] = STATE(318),
    [sym_replace_field] = STATE(318),
    [sym_compound_assign_local] = STATE(318),
    [sym_compound_assign_field] = STATE(318),
    [sym_compound_assign_receiver_field] = STATE(318),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(318),
    [sym_call_with_receiver] = STATE(318),
    [sym_ref] = STATE(318),
    [sym_mut] = STATE(318),
    [sym_recover] = STATE(318),
    [sym_grouped_expression] = STATE(318),
    [sym_tuple] = STATE(318),
    [sym_array] = STATE(318),
    [sym_return] = STATE(318),
    [sym_try] = STATE(318),
    [sym_throw] = STATE(318),
    [sym_if] = STATE(318),
    [sym_while] = STATE(318),
    [sym_loop] = STATE(318),
    [sym_for] = STATE(318),
    [sym_match] = STATE(318),
    [sym_closure] = STATE(318),
    [sym_define_variable] = STATE(318),
    [sym_and_or] = STATE(318),
    [sym_binary] = STATE(318),
    [sym_cast] = STATE(318),
    [sym_string] = STATE(318),
    [sym_true] = STATE(318),
    [sym_false] = STATE(318),
    [aux_sym_block_repeat1] = STATE(35),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_RBRACE] = ACTIONS(475),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(366),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(368),
    [sym_nil] = ACTIONS(368),
    [sym_break] = ACTIONS(368),
    [sym_next] = ACTIONS(368),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [35] = {
    [sym_block] = STATE(318),
    [sym__expression] = STATE(318),
    [sym_assign_receiver_field] = STATE(318),
    [sym_assign_local] = STATE(318),
    [sym_assign_field] = STATE(318),
    [sym_replace_local] = STATE(318),
    [sym_replace_field] = STATE(318),
    [sym_compound_assign_local] = STATE(318),
    [sym_compound_assign_field] = STATE(318),
    [sym_compound_assign_receiver_field] = STATE(318),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(318),
    [sym_call_with_receiver] = STATE(318),
    [sym_ref] = STATE(318),
    [sym_mut] = STATE(318),
    [sym_recover] = STATE(318),
    [sym_grouped_expression] = STATE(318),
    [sym_tuple] = STATE(318),
    [sym_array] = STATE(318),
    [sym_return] = STATE(318),
    [sym_try] = STATE(318),
    [sym_throw] = STATE(318),
    [sym_if] = STATE(318),
    [sym_while] = STATE(318),
    [sym_loop] = STATE(318),
    [sym_for] = STATE(318),
    [sym_match] = STATE(318),
    [sym_closure] = STATE(318),
    [sym_define_variable] = STATE(318),
    [sym_and_or] = STATE(318),
    [sym_binary] = STATE(318),
    [sym_cast] = STATE(318),
    [sym_string] = STATE(318),
    [sym_true] = STATE(318),
    [sym_false] = STATE(318),
    [aux_sym_block_repeat1] = STATE(24),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_RBRACE] = ACTIONS(477),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(366),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(368),
    [sym_nil] = ACTIONS(368),
    [sym_break] = ACTIONS(368),
    [sym_next] = ACTIONS(368),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [36] = {
    [sym_block] = STATE(318),
    [sym__expression] = STATE(318),
    [sym_assign_receiver_field] = STATE(318),
    [sym_assign_local] = STATE(318),
    [sym_assign_field] = STATE(318),
    [sym_replace_local] = STATE(318),
    [sym_replace_field] = STATE(318),
    [sym_compound_assign_local] = STATE(318),
    [sym_compound_assign_field] = STATE(318),
    [sym_compound_assign_receiver_field] = STATE(318),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(318),
    [sym_call_with_receiver] = STATE(318),
    [sym_ref] = STATE(318),
    [sym_mut] = STATE(318),
    [sym_recover] = STATE(318),
    [sym_grouped_expression] = STATE(318),
    [sym_tuple] = STATE(318),
    [sym_array] = STATE(318),
    [sym_return] = STATE(318),
    [sym_try] = STATE(318),
    [sym_throw] = STATE(318),
    [sym_if] = STATE(318),
    [sym_while] = STATE(318),
    [sym_loop] = STATE(318),
    [sym_for] = STATE(318),
    [sym_match] = STATE(318),
    [sym_closure] = STATE(318),
    [sym_define_variable] = STATE(318),
    [sym_and_or] = STATE(318),
    [sym_binary] = STATE(318),
    [sym_cast] = STATE(318),
    [sym_string] = STATE(318),
    [sym_true] = STATE(318),
    [sym_false] = STATE(318),
    [aux_sym_block_repeat1] = STATE(24),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_RBRACE] = ACTIONS(479),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(366),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(368),
    [sym_nil] = ACTIONS(368),
    [sym_break] = ACTIONS(368),
    [sym_next] = ACTIONS(368),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [37] = {
    [sym_block] = STATE(621),
    [sym__expression] = STATE(621),
    [sym_assign_receiver_field] = STATE(621),
    [sym_assign_local] = STATE(621),
    [sym_assign_field] = STATE(621),
    [sym_replace_local] = STATE(621),
    [sym_replace_field] = STATE(621),
    [sym_compound_assign_local] = STATE(621),
    [sym_compound_assign_field] = STATE(621),
    [sym_compound_assign_receiver_field] = STATE(621),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(621),
    [sym__call_argument] = STATE(1200),
    [sym_named_argument] = STATE(1200),
    [sym_call_with_receiver] = STATE(621),
    [sym_ref] = STATE(621),
    [sym_mut] = STATE(621),
    [sym_recover] = STATE(621),
    [sym_grouped_expression] = STATE(621),
    [sym_tuple] = STATE(621),
    [sym_array] = STATE(621),
    [sym_return] = STATE(621),
    [sym_try] = STATE(621),
    [sym_throw] = STATE(621),
    [sym_if] = STATE(621),
    [sym_while] = STATE(621),
    [sym_loop] = STATE(621),
    [sym_for] = STATE(621),
    [sym_match] = STATE(621),
    [sym_closure] = STATE(621),
    [sym_define_variable] = STATE(621),
    [sym_and_or] = STATE(621),
    [sym_binary] = STATE(621),
    [sym_cast] = STATE(621),
    [sym_string] = STATE(621),
    [sym_true] = STATE(621),
    [sym_false] = STATE(621),
    [sym_identifier] = ACTIONS(334),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(338),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(340),
    [sym_nil] = ACTIONS(340),
    [sym_break] = ACTIONS(340),
    [sym_next] = ACTIONS(340),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [38] = {
    [sym_block] = STATE(318),
    [sym__expression] = STATE(318),
    [sym_assign_receiver_field] = STATE(318),
    [sym_assign_local] = STATE(318),
    [sym_assign_field] = STATE(318),
    [sym_replace_local] = STATE(318),
    [sym_replace_field] = STATE(318),
    [sym_compound_assign_local] = STATE(318),
    [sym_compound_assign_field] = STATE(318),
    [sym_compound_assign_receiver_field] = STATE(318),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(318),
    [sym_call_with_receiver] = STATE(318),
    [sym_ref] = STATE(318),
    [sym_mut] = STATE(318),
    [sym_recover] = STATE(318),
    [sym_grouped_expression] = STATE(318),
    [sym_tuple] = STATE(318),
    [sym_array] = STATE(318),
    [sym_return] = STATE(318),
    [sym_try] = STATE(318),
    [sym_throw] = STATE(318),
    [sym_if] = STATE(318),
    [sym_while] = STATE(318),
    [sym_loop] = STATE(318),
    [sym_for] = STATE(318),
    [sym_match] = STATE(318),
    [sym_closure] = STATE(318),
    [sym_define_variable] = STATE(318),
    [sym_and_or] = STATE(318),
    [sym_binary] = STATE(318),
    [sym_cast] = STATE(318),
    [sym_string] = STATE(318),
    [sym_true] = STATE(318),
    [sym_false] = STATE(318),
    [aux_sym_block_repeat1] = STATE(39),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_RBRACE] = ACTIONS(481),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(366),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(368),
    [sym_nil] = ACTIONS(368),
    [sym_break] = ACTIONS(368),
    [sym_next] = ACTIONS(368),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [39] = {
    [sym_block] = STATE(318),
    [sym__expression] = STATE(318),
    [sym_assign_receiver_field] = STATE(318),
    [sym_assign_local] = STATE(318),
    [sym_assign_field] = STATE(318),
    [sym_replace_local] = STATE(318),
    [sym_replace_field] = STATE(318),
    [sym_compound_assign_local] = STATE(318),
    [sym_compound_assign_field] = STATE(318),
    [sym_compound_assign_receiver_field] = STATE(318),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(318),
    [sym_call_with_receiver] = STATE(318),
    [sym_ref] = STATE(318),
    [sym_mut] = STATE(318),
    [sym_recover] = STATE(318),
    [sym_grouped_expression] = STATE(318),
    [sym_tuple] = STATE(318),
    [sym_array] = STATE(318),
    [sym_return] = STATE(318),
    [sym_try] = STATE(318),
    [sym_throw] = STATE(318),
    [sym_if] = STATE(318),
    [sym_while] = STATE(318),
    [sym_loop] = STATE(318),
    [sym_for] = STATE(318),
    [sym_match] = STATE(318),
    [sym_closure] = STATE(318),
    [sym_define_variable] = STATE(318),
    [sym_and_or] = STATE(318),
    [sym_binary] = STATE(318),
    [sym_cast] = STATE(318),
    [sym_string] = STATE(318),
    [sym_true] = STATE(318),
    [sym_false] = STATE(318),
    [aux_sym_block_repeat1] = STATE(24),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_RBRACE] = ACTIONS(483),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(366),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(368),
    [sym_nil] = ACTIONS(368),
    [sym_break] = ACTIONS(368),
    [sym_next] = ACTIONS(368),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [40] = {
    [sym_block] = STATE(318),
    [sym__expression] = STATE(318),
    [sym_assign_receiver_field] = STATE(318),
    [sym_assign_local] = STATE(318),
    [sym_assign_field] = STATE(318),
    [sym_replace_local] = STATE(318),
    [sym_replace_field] = STATE(318),
    [sym_compound_assign_local] = STATE(318),
    [sym_compound_assign_field] = STATE(318),
    [sym_compound_assign_receiver_field] = STATE(318),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(318),
    [sym_call_with_receiver] = STATE(318),
    [sym_ref] = STATE(318),
    [sym_mut] = STATE(318),
    [sym_recover] = STATE(318),
    [sym_grouped_expression] = STATE(318),
    [sym_tuple] = STATE(318),
    [sym_array] = STATE(318),
    [sym_return] = STATE(318),
    [sym_try] = STATE(318),
    [sym_throw] = STATE(318),
    [sym_if] = STATE(318),
    [sym_while] = STATE(318),
    [sym_loop] = STATE(318),
    [sym_for] = STATE(318),
    [sym_match] = STATE(318),
    [sym_closure] = STATE(318),
    [sym_define_variable] = STATE(318),
    [sym_and_or] = STATE(318),
    [sym_binary] = STATE(318),
    [sym_cast] = STATE(318),
    [sym_string] = STATE(318),
    [sym_true] = STATE(318),
    [sym_false] = STATE(318),
    [aux_sym_block_repeat1] = STATE(41),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_RBRACE] = ACTIONS(485),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(366),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(368),
    [sym_nil] = ACTIONS(368),
    [sym_break] = ACTIONS(368),
    [sym_next] = ACTIONS(368),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [41] = {
    [sym_block] = STATE(318),
    [sym__expression] = STATE(318),
    [sym_assign_receiver_field] = STATE(318),
    [sym_assign_local] = STATE(318),
    [sym_assign_field] = STATE(318),
    [sym_replace_local] = STATE(318),
    [sym_replace_field] = STATE(318),
    [sym_compound_assign_local] = STATE(318),
    [sym_compound_assign_field] = STATE(318),
    [sym_compound_assign_receiver_field] = STATE(318),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(318),
    [sym_call_with_receiver] = STATE(318),
    [sym_ref] = STATE(318),
    [sym_mut] = STATE(318),
    [sym_recover] = STATE(318),
    [sym_grouped_expression] = STATE(318),
    [sym_tuple] = STATE(318),
    [sym_array] = STATE(318),
    [sym_return] = STATE(318),
    [sym_try] = STATE(318),
    [sym_throw] = STATE(318),
    [sym_if] = STATE(318),
    [sym_while] = STATE(318),
    [sym_loop] = STATE(318),
    [sym_for] = STATE(318),
    [sym_match] = STATE(318),
    [sym_closure] = STATE(318),
    [sym_define_variable] = STATE(318),
    [sym_and_or] = STATE(318),
    [sym_binary] = STATE(318),
    [sym_cast] = STATE(318),
    [sym_string] = STATE(318),
    [sym_true] = STATE(318),
    [sym_false] = STATE(318),
    [aux_sym_block_repeat1] = STATE(24),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_RBRACE] = ACTIONS(487),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(366),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(368),
    [sym_nil] = ACTIONS(368),
    [sym_break] = ACTIONS(368),
    [sym_next] = ACTIONS(368),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [42] = {
    [sym_block] = STATE(318),
    [sym__expression] = STATE(318),
    [sym_assign_receiver_field] = STATE(318),
    [sym_assign_local] = STATE(318),
    [sym_assign_field] = STATE(318),
    [sym_replace_local] = STATE(318),
    [sym_replace_field] = STATE(318),
    [sym_compound_assign_local] = STATE(318),
    [sym_compound_assign_field] = STATE(318),
    [sym_compound_assign_receiver_field] = STATE(318),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(318),
    [sym_call_with_receiver] = STATE(318),
    [sym_ref] = STATE(318),
    [sym_mut] = STATE(318),
    [sym_recover] = STATE(318),
    [sym_grouped_expression] = STATE(318),
    [sym_tuple] = STATE(318),
    [sym_array] = STATE(318),
    [sym_return] = STATE(318),
    [sym_try] = STATE(318),
    [sym_throw] = STATE(318),
    [sym_if] = STATE(318),
    [sym_while] = STATE(318),
    [sym_loop] = STATE(318),
    [sym_for] = STATE(318),
    [sym_match] = STATE(318),
    [sym_closure] = STATE(318),
    [sym_define_variable] = STATE(318),
    [sym_and_or] = STATE(318),
    [sym_binary] = STATE(318),
    [sym_cast] = STATE(318),
    [sym_string] = STATE(318),
    [sym_true] = STATE(318),
    [sym_false] = STATE(318),
    [aux_sym_block_repeat1] = STATE(22),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_RBRACE] = ACTIONS(489),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(366),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(368),
    [sym_nil] = ACTIONS(368),
    [sym_break] = ACTIONS(368),
    [sym_next] = ACTIONS(368),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [43] = {
    [sym_block] = STATE(609),
    [sym__expression] = STATE(609),
    [sym_assign_receiver_field] = STATE(609),
    [sym_assign_local] = STATE(609),
    [sym_assign_field] = STATE(609),
    [sym_replace_local] = STATE(609),
    [sym_replace_field] = STATE(609),
    [sym_compound_assign_local] = STATE(609),
    [sym_compound_assign_field] = STATE(609),
    [sym_compound_assign_receiver_field] = STATE(609),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(609),
    [sym_call_with_receiver] = STATE(609),
    [sym_ref] = STATE(609),
    [sym_mut] = STATE(609),
    [sym_recover] = STATE(609),
    [sym_grouped_expression] = STATE(609),
    [sym_tuple] = STATE(609),
    [sym_array] = STATE(609),
    [sym_return] = STATE(609),
    [sym_try] = STATE(609),
    [sym_throw] = STATE(609),
    [sym_if] = STATE(609),
    [sym_while] = STATE(609),
    [sym_loop] = STATE(609),
    [sym_for] = STATE(609),
    [sym_match] = STATE(609),
    [sym_closure] = STATE(609),
    [sym_define_variable] = STATE(609),
    [sym_and_or] = STATE(609),
    [sym_binary] = STATE(609),
    [sym_cast] = STATE(609),
    [sym_string] = STATE(609),
    [sym_true] = STATE(609),
    [sym_false] = STATE(609),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_RBRACK] = ACTIONS(491),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(493),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(495),
    [sym_nil] = ACTIONS(495),
    [sym_break] = ACTIONS(495),
    [sym_next] = ACTIONS(495),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [44] = {
    [sym_block] = STATE(609),
    [sym__expression] = STATE(609),
    [sym_assign_receiver_field] = STATE(609),
    [sym_assign_local] = STATE(609),
    [sym_assign_field] = STATE(609),
    [sym_replace_local] = STATE(609),
    [sym_replace_field] = STATE(609),
    [sym_compound_assign_local] = STATE(609),
    [sym_compound_assign_field] = STATE(609),
    [sym_compound_assign_receiver_field] = STATE(609),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(609),
    [sym_call_with_receiver] = STATE(609),
    [sym_ref] = STATE(609),
    [sym_mut] = STATE(609),
    [sym_recover] = STATE(609),
    [sym_grouped_expression] = STATE(609),
    [sym_tuple] = STATE(609),
    [sym_array] = STATE(609),
    [sym_return] = STATE(609),
    [sym_try] = STATE(609),
    [sym_throw] = STATE(609),
    [sym_if] = STATE(609),
    [sym_while] = STATE(609),
    [sym_loop] = STATE(609),
    [sym_for] = STATE(609),
    [sym_match] = STATE(609),
    [sym_closure] = STATE(609),
    [sym_define_variable] = STATE(609),
    [sym_and_or] = STATE(609),
    [sym_binary] = STATE(609),
    [sym_cast] = STATE(609),
    [sym_string] = STATE(609),
    [sym_true] = STATE(609),
    [sym_false] = STATE(609),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_RPAREN] = ACTIONS(497),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(493),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(495),
    [sym_nil] = ACTIONS(495),
    [sym_break] = ACTIONS(495),
    [sym_next] = ACTIONS(495),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [45] = {
    [sym_block] = STATE(604),
    [sym__expression] = STATE(604),
    [sym_assign_receiver_field] = STATE(604),
    [sym_assign_local] = STATE(604),
    [sym_assign_field] = STATE(604),
    [sym_replace_local] = STATE(604),
    [sym_replace_field] = STATE(604),
    [sym_compound_assign_local] = STATE(604),
    [sym_compound_assign_field] = STATE(604),
    [sym_compound_assign_receiver_field] = STATE(604),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(604),
    [sym_call_with_receiver] = STATE(604),
    [sym_ref] = STATE(604),
    [sym_mut] = STATE(604),
    [sym_recover] = STATE(604),
    [sym_grouped_expression] = STATE(604),
    [sym_tuple] = STATE(604),
    [sym_array] = STATE(604),
    [sym_return] = STATE(604),
    [sym_try] = STATE(604),
    [sym_throw] = STATE(604),
    [sym_if] = STATE(604),
    [sym_while] = STATE(604),
    [sym_loop] = STATE(604),
    [sym_for] = STATE(604),
    [sym_match] = STATE(604),
    [sym_closure] = STATE(604),
    [sym_define_variable] = STATE(604),
    [sym_and_or] = STATE(604),
    [sym_binary] = STATE(604),
    [sym_cast] = STATE(604),
    [sym_string] = STATE(604),
    [sym_true] = STATE(604),
    [sym_false] = STATE(604),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_RBRACK] = ACTIONS(499),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(501),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(503),
    [sym_nil] = ACTIONS(503),
    [sym_break] = ACTIONS(503),
    [sym_next] = ACTIONS(503),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [46] = {
    [sym_block] = STATE(609),
    [sym__expression] = STATE(609),
    [sym_assign_receiver_field] = STATE(609),
    [sym_assign_local] = STATE(609),
    [sym_assign_field] = STATE(609),
    [sym_replace_local] = STATE(609),
    [sym_replace_field] = STATE(609),
    [sym_compound_assign_local] = STATE(609),
    [sym_compound_assign_field] = STATE(609),
    [sym_compound_assign_receiver_field] = STATE(609),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(609),
    [sym_call_with_receiver] = STATE(609),
    [sym_ref] = STATE(609),
    [sym_mut] = STATE(609),
    [sym_recover] = STATE(609),
    [sym_grouped_expression] = STATE(609),
    [sym_tuple] = STATE(609),
    [sym_array] = STATE(609),
    [sym_return] = STATE(609),
    [sym_try] = STATE(609),
    [sym_throw] = STATE(609),
    [sym_if] = STATE(609),
    [sym_while] = STATE(609),
    [sym_loop] = STATE(609),
    [sym_for] = STATE(609),
    [sym_match] = STATE(609),
    [sym_closure] = STATE(609),
    [sym_define_variable] = STATE(609),
    [sym_and_or] = STATE(609),
    [sym_binary] = STATE(609),
    [sym_cast] = STATE(609),
    [sym_string] = STATE(609),
    [sym_true] = STATE(609),
    [sym_false] = STATE(609),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_RBRACK] = ACTIONS(505),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(493),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(495),
    [sym_nil] = ACTIONS(495),
    [sym_break] = ACTIONS(495),
    [sym_next] = ACTIONS(495),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [47] = {
    [sym_block] = STATE(609),
    [sym__expression] = STATE(609),
    [sym_assign_receiver_field] = STATE(609),
    [sym_assign_local] = STATE(609),
    [sym_assign_field] = STATE(609),
    [sym_replace_local] = STATE(609),
    [sym_replace_field] = STATE(609),
    [sym_compound_assign_local] = STATE(609),
    [sym_compound_assign_field] = STATE(609),
    [sym_compound_assign_receiver_field] = STATE(609),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(609),
    [sym_call_with_receiver] = STATE(609),
    [sym_ref] = STATE(609),
    [sym_mut] = STATE(609),
    [sym_recover] = STATE(609),
    [sym_grouped_expression] = STATE(609),
    [sym_tuple] = STATE(609),
    [sym_array] = STATE(609),
    [sym_return] = STATE(609),
    [sym_try] = STATE(609),
    [sym_throw] = STATE(609),
    [sym_if] = STATE(609),
    [sym_while] = STATE(609),
    [sym_loop] = STATE(609),
    [sym_for] = STATE(609),
    [sym_match] = STATE(609),
    [sym_closure] = STATE(609),
    [sym_define_variable] = STATE(609),
    [sym_and_or] = STATE(609),
    [sym_binary] = STATE(609),
    [sym_cast] = STATE(609),
    [sym_string] = STATE(609),
    [sym_true] = STATE(609),
    [sym_false] = STATE(609),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_RBRACK] = ACTIONS(507),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(493),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(495),
    [sym_nil] = ACTIONS(495),
    [sym_break] = ACTIONS(495),
    [sym_next] = ACTIONS(495),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [48] = {
    [sym_block] = STATE(606),
    [sym__expression] = STATE(606),
    [sym_assign_receiver_field] = STATE(606),
    [sym_assign_local] = STATE(606),
    [sym_assign_field] = STATE(606),
    [sym_replace_local] = STATE(606),
    [sym_replace_field] = STATE(606),
    [sym_compound_assign_local] = STATE(606),
    [sym_compound_assign_field] = STATE(606),
    [sym_compound_assign_receiver_field] = STATE(606),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(606),
    [sym_call_with_receiver] = STATE(606),
    [sym_ref] = STATE(606),
    [sym_mut] = STATE(606),
    [sym_recover] = STATE(606),
    [sym_grouped_expression] = STATE(606),
    [sym_tuple] = STATE(606),
    [sym_array] = STATE(606),
    [sym_return] = STATE(606),
    [sym_try] = STATE(606),
    [sym_throw] = STATE(606),
    [sym_if] = STATE(606),
    [sym_while] = STATE(606),
    [sym_loop] = STATE(606),
    [sym_for] = STATE(606),
    [sym_match] = STATE(606),
    [sym_closure] = STATE(606),
    [sym_define_variable] = STATE(606),
    [sym_and_or] = STATE(606),
    [sym_binary] = STATE(606),
    [sym_cast] = STATE(606),
    [sym_string] = STATE(606),
    [sym_true] = STATE(606),
    [sym_false] = STATE(606),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_RPAREN] = ACTIONS(509),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(511),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(513),
    [sym_nil] = ACTIONS(513),
    [sym_break] = ACTIONS(513),
    [sym_next] = ACTIONS(513),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [49] = {
    [sym_block] = STATE(607),
    [sym__expression] = STATE(607),
    [sym_assign_receiver_field] = STATE(607),
    [sym_assign_local] = STATE(607),
    [sym_assign_field] = STATE(607),
    [sym_replace_local] = STATE(607),
    [sym_replace_field] = STATE(607),
    [sym_compound_assign_local] = STATE(607),
    [sym_compound_assign_field] = STATE(607),
    [sym_compound_assign_receiver_field] = STATE(607),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(607),
    [sym_call_with_receiver] = STATE(607),
    [sym_ref] = STATE(607),
    [sym_mut] = STATE(607),
    [sym_recover] = STATE(607),
    [sym_grouped_expression] = STATE(607),
    [sym_tuple] = STATE(607),
    [sym_array] = STATE(607),
    [sym_return] = STATE(607),
    [sym_try] = STATE(607),
    [sym_throw] = STATE(607),
    [sym_if] = STATE(607),
    [sym_while] = STATE(607),
    [sym_loop] = STATE(607),
    [sym_for] = STATE(607),
    [sym_match] = STATE(607),
    [sym_closure] = STATE(607),
    [sym_define_variable] = STATE(607),
    [sym_and_or] = STATE(607),
    [sym_binary] = STATE(607),
    [sym_cast] = STATE(607),
    [sym_string] = STATE(607),
    [sym_true] = STATE(607),
    [sym_false] = STATE(607),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_RPAREN] = ACTIONS(515),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(517),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(519),
    [sym_nil] = ACTIONS(519),
    [sym_break] = ACTIONS(519),
    [sym_next] = ACTIONS(519),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [50] = {
    [sym_block] = STATE(609),
    [sym__expression] = STATE(609),
    [sym_assign_receiver_field] = STATE(609),
    [sym_assign_local] = STATE(609),
    [sym_assign_field] = STATE(609),
    [sym_replace_local] = STATE(609),
    [sym_replace_field] = STATE(609),
    [sym_compound_assign_local] = STATE(609),
    [sym_compound_assign_field] = STATE(609),
    [sym_compound_assign_receiver_field] = STATE(609),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(609),
    [sym_call_with_receiver] = STATE(609),
    [sym_ref] = STATE(609),
    [sym_mut] = STATE(609),
    [sym_recover] = STATE(609),
    [sym_grouped_expression] = STATE(609),
    [sym_tuple] = STATE(609),
    [sym_array] = STATE(609),
    [sym_return] = STATE(609),
    [sym_try] = STATE(609),
    [sym_throw] = STATE(609),
    [sym_if] = STATE(609),
    [sym_while] = STATE(609),
    [sym_loop] = STATE(609),
    [sym_for] = STATE(609),
    [sym_match] = STATE(609),
    [sym_closure] = STATE(609),
    [sym_define_variable] = STATE(609),
    [sym_and_or] = STATE(609),
    [sym_binary] = STATE(609),
    [sym_cast] = STATE(609),
    [sym_string] = STATE(609),
    [sym_true] = STATE(609),
    [sym_false] = STATE(609),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_RBRACK] = ACTIONS(521),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(493),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(495),
    [sym_nil] = ACTIONS(495),
    [sym_break] = ACTIONS(495),
    [sym_next] = ACTIONS(495),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [51] = {
    [sym_block] = STATE(609),
    [sym__expression] = STATE(609),
    [sym_assign_receiver_field] = STATE(609),
    [sym_assign_local] = STATE(609),
    [sym_assign_field] = STATE(609),
    [sym_replace_local] = STATE(609),
    [sym_replace_field] = STATE(609),
    [sym_compound_assign_local] = STATE(609),
    [sym_compound_assign_field] = STATE(609),
    [sym_compound_assign_receiver_field] = STATE(609),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(609),
    [sym_call_with_receiver] = STATE(609),
    [sym_ref] = STATE(609),
    [sym_mut] = STATE(609),
    [sym_recover] = STATE(609),
    [sym_grouped_expression] = STATE(609),
    [sym_tuple] = STATE(609),
    [sym_array] = STATE(609),
    [sym_return] = STATE(609),
    [sym_try] = STATE(609),
    [sym_throw] = STATE(609),
    [sym_if] = STATE(609),
    [sym_while] = STATE(609),
    [sym_loop] = STATE(609),
    [sym_for] = STATE(609),
    [sym_match] = STATE(609),
    [sym_closure] = STATE(609),
    [sym_define_variable] = STATE(609),
    [sym_and_or] = STATE(609),
    [sym_binary] = STATE(609),
    [sym_cast] = STATE(609),
    [sym_string] = STATE(609),
    [sym_true] = STATE(609),
    [sym_false] = STATE(609),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_RBRACK] = ACTIONS(523),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(493),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(495),
    [sym_nil] = ACTIONS(495),
    [sym_break] = ACTIONS(495),
    [sym_next] = ACTIONS(495),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [52] = {
    [sym_block] = STATE(609),
    [sym__expression] = STATE(609),
    [sym_assign_receiver_field] = STATE(609),
    [sym_assign_local] = STATE(609),
    [sym_assign_field] = STATE(609),
    [sym_replace_local] = STATE(609),
    [sym_replace_field] = STATE(609),
    [sym_compound_assign_local] = STATE(609),
    [sym_compound_assign_field] = STATE(609),
    [sym_compound_assign_receiver_field] = STATE(609),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(609),
    [sym_call_with_receiver] = STATE(609),
    [sym_ref] = STATE(609),
    [sym_mut] = STATE(609),
    [sym_recover] = STATE(609),
    [sym_grouped_expression] = STATE(609),
    [sym_tuple] = STATE(609),
    [sym_array] = STATE(609),
    [sym_return] = STATE(609),
    [sym_try] = STATE(609),
    [sym_throw] = STATE(609),
    [sym_if] = STATE(609),
    [sym_while] = STATE(609),
    [sym_loop] = STATE(609),
    [sym_for] = STATE(609),
    [sym_match] = STATE(609),
    [sym_closure] = STATE(609),
    [sym_define_variable] = STATE(609),
    [sym_and_or] = STATE(609),
    [sym_binary] = STATE(609),
    [sym_cast] = STATE(609),
    [sym_string] = STATE(609),
    [sym_true] = STATE(609),
    [sym_false] = STATE(609),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_RPAREN] = ACTIONS(525),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(493),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(495),
    [sym_nil] = ACTIONS(495),
    [sym_break] = ACTIONS(495),
    [sym_next] = ACTIONS(495),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [53] = {
    [sym_block] = STATE(609),
    [sym__expression] = STATE(609),
    [sym_assign_receiver_field] = STATE(609),
    [sym_assign_local] = STATE(609),
    [sym_assign_field] = STATE(609),
    [sym_replace_local] = STATE(609),
    [sym_replace_field] = STATE(609),
    [sym_compound_assign_local] = STATE(609),
    [sym_compound_assign_field] = STATE(609),
    [sym_compound_assign_receiver_field] = STATE(609),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(609),
    [sym_call_with_receiver] = STATE(609),
    [sym_ref] = STATE(609),
    [sym_mut] = STATE(609),
    [sym_recover] = STATE(609),
    [sym_grouped_expression] = STATE(609),
    [sym_tuple] = STATE(609),
    [sym_array] = STATE(609),
    [sym_return] = STATE(609),
    [sym_try] = STATE(609),
    [sym_throw] = STATE(609),
    [sym_if] = STATE(609),
    [sym_while] = STATE(609),
    [sym_loop] = STATE(609),
    [sym_for] = STATE(609),
    [sym_match] = STATE(609),
    [sym_closure] = STATE(609),
    [sym_define_variable] = STATE(609),
    [sym_and_or] = STATE(609),
    [sym_binary] = STATE(609),
    [sym_cast] = STATE(609),
    [sym_string] = STATE(609),
    [sym_true] = STATE(609),
    [sym_false] = STATE(609),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_RPAREN] = ACTIONS(527),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(493),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(495),
    [sym_nil] = ACTIONS(495),
    [sym_break] = ACTIONS(495),
    [sym_next] = ACTIONS(495),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [54] = {
    [sym_block] = STATE(603),
    [sym__expression] = STATE(603),
    [sym_assign_receiver_field] = STATE(603),
    [sym_assign_local] = STATE(603),
    [sym_assign_field] = STATE(603),
    [sym_replace_local] = STATE(603),
    [sym_replace_field] = STATE(603),
    [sym_compound_assign_local] = STATE(603),
    [sym_compound_assign_field] = STATE(603),
    [sym_compound_assign_receiver_field] = STATE(603),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(603),
    [sym_call_with_receiver] = STATE(603),
    [sym_ref] = STATE(603),
    [sym_mut] = STATE(603),
    [sym_recover] = STATE(603),
    [sym_grouped_expression] = STATE(603),
    [sym_tuple] = STATE(603),
    [sym_array] = STATE(603),
    [sym_return] = STATE(603),
    [sym_try] = STATE(603),
    [sym_throw] = STATE(603),
    [sym_if] = STATE(603),
    [sym_while] = STATE(603),
    [sym_loop] = STATE(603),
    [sym_for] = STATE(603),
    [sym_match] = STATE(603),
    [sym_closure] = STATE(603),
    [sym_define_variable] = STATE(603),
    [sym_and_or] = STATE(603),
    [sym_binary] = STATE(603),
    [sym_cast] = STATE(603),
    [sym_string] = STATE(603),
    [sym_true] = STATE(603),
    [sym_false] = STATE(603),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_RBRACK] = ACTIONS(529),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(531),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(533),
    [sym_nil] = ACTIONS(533),
    [sym_break] = ACTIONS(533),
    [sym_next] = ACTIONS(533),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [55] = {
    [sym_block] = STATE(609),
    [sym__expression] = STATE(609),
    [sym_assign_receiver_field] = STATE(609),
    [sym_assign_local] = STATE(609),
    [sym_assign_field] = STATE(609),
    [sym_replace_local] = STATE(609),
    [sym_replace_field] = STATE(609),
    [sym_compound_assign_local] = STATE(609),
    [sym_compound_assign_field] = STATE(609),
    [sym_compound_assign_receiver_field] = STATE(609),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(609),
    [sym_call_with_receiver] = STATE(609),
    [sym_ref] = STATE(609),
    [sym_mut] = STATE(609),
    [sym_recover] = STATE(609),
    [sym_grouped_expression] = STATE(609),
    [sym_tuple] = STATE(609),
    [sym_array] = STATE(609),
    [sym_return] = STATE(609),
    [sym_try] = STATE(609),
    [sym_throw] = STATE(609),
    [sym_if] = STATE(609),
    [sym_while] = STATE(609),
    [sym_loop] = STATE(609),
    [sym_for] = STATE(609),
    [sym_match] = STATE(609),
    [sym_closure] = STATE(609),
    [sym_define_variable] = STATE(609),
    [sym_and_or] = STATE(609),
    [sym_binary] = STATE(609),
    [sym_cast] = STATE(609),
    [sym_string] = STATE(609),
    [sym_true] = STATE(609),
    [sym_false] = STATE(609),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_RPAREN] = ACTIONS(535),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(493),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(495),
    [sym_nil] = ACTIONS(495),
    [sym_break] = ACTIONS(495),
    [sym_next] = ACTIONS(495),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [56] = {
    [sym_block] = STATE(608),
    [sym__expression] = STATE(608),
    [sym_assign_receiver_field] = STATE(608),
    [sym_assign_local] = STATE(608),
    [sym_assign_field] = STATE(608),
    [sym_replace_local] = STATE(608),
    [sym_replace_field] = STATE(608),
    [sym_compound_assign_local] = STATE(608),
    [sym_compound_assign_field] = STATE(608),
    [sym_compound_assign_receiver_field] = STATE(608),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(608),
    [sym_call_with_receiver] = STATE(608),
    [sym_ref] = STATE(608),
    [sym_mut] = STATE(608),
    [sym_recover] = STATE(608),
    [sym_grouped_expression] = STATE(608),
    [sym_tuple] = STATE(608),
    [sym_array] = STATE(608),
    [sym_return] = STATE(608),
    [sym_try] = STATE(608),
    [sym_throw] = STATE(608),
    [sym_if] = STATE(608),
    [sym_while] = STATE(608),
    [sym_loop] = STATE(608),
    [sym_for] = STATE(608),
    [sym_match] = STATE(608),
    [sym_closure] = STATE(608),
    [sym_define_variable] = STATE(608),
    [sym_and_or] = STATE(608),
    [sym_binary] = STATE(608),
    [sym_cast] = STATE(608),
    [sym_string] = STATE(608),
    [sym_true] = STATE(608),
    [sym_false] = STATE(608),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_RBRACK] = ACTIONS(537),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(539),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(541),
    [sym_nil] = ACTIONS(541),
    [sym_break] = ACTIONS(541),
    [sym_next] = ACTIONS(541),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [57] = {
    [sym_block] = STATE(609),
    [sym__expression] = STATE(609),
    [sym_assign_receiver_field] = STATE(609),
    [sym_assign_local] = STATE(609),
    [sym_assign_field] = STATE(609),
    [sym_replace_local] = STATE(609),
    [sym_replace_field] = STATE(609),
    [sym_compound_assign_local] = STATE(609),
    [sym_compound_assign_field] = STATE(609),
    [sym_compound_assign_receiver_field] = STATE(609),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(609),
    [sym_call_with_receiver] = STATE(609),
    [sym_ref] = STATE(609),
    [sym_mut] = STATE(609),
    [sym_recover] = STATE(609),
    [sym_grouped_expression] = STATE(609),
    [sym_tuple] = STATE(609),
    [sym_array] = STATE(609),
    [sym_return] = STATE(609),
    [sym_try] = STATE(609),
    [sym_throw] = STATE(609),
    [sym_if] = STATE(609),
    [sym_while] = STATE(609),
    [sym_loop] = STATE(609),
    [sym_for] = STATE(609),
    [sym_match] = STATE(609),
    [sym_closure] = STATE(609),
    [sym_define_variable] = STATE(609),
    [sym_and_or] = STATE(609),
    [sym_binary] = STATE(609),
    [sym_cast] = STATE(609),
    [sym_string] = STATE(609),
    [sym_true] = STATE(609),
    [sym_false] = STATE(609),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_RBRACK] = ACTIONS(543),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(493),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(495),
    [sym_nil] = ACTIONS(495),
    [sym_break] = ACTIONS(495),
    [sym_next] = ACTIONS(495),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [58] = {
    [sym_block] = STATE(592),
    [sym__expression] = STATE(592),
    [sym_assign_receiver_field] = STATE(592),
    [sym_assign_local] = STATE(592),
    [sym_assign_field] = STATE(592),
    [sym_replace_local] = STATE(592),
    [sym_replace_field] = STATE(592),
    [sym_compound_assign_local] = STATE(592),
    [sym_compound_assign_field] = STATE(592),
    [sym_compound_assign_receiver_field] = STATE(592),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(592),
    [sym_call_with_receiver] = STATE(592),
    [sym_ref] = STATE(592),
    [sym_mut] = STATE(592),
    [sym_recover] = STATE(592),
    [sym_grouped_expression] = STATE(592),
    [sym_tuple] = STATE(592),
    [sym_array] = STATE(592),
    [sym_return] = STATE(592),
    [sym_try] = STATE(592),
    [sym_throw] = STATE(592),
    [sym_if] = STATE(592),
    [sym_while] = STATE(592),
    [sym_loop] = STATE(592),
    [sym_for] = STATE(592),
    [sym_match] = STATE(592),
    [sym_closure] = STATE(592),
    [sym_define_variable] = STATE(592),
    [sym_and_or] = STATE(592),
    [sym_binary] = STATE(592),
    [sym_cast] = STATE(592),
    [sym_string] = STATE(592),
    [sym_true] = STATE(592),
    [sym_false] = STATE(592),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_RPAREN] = ACTIONS(545),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(547),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(549),
    [sym_nil] = ACTIONS(549),
    [sym_break] = ACTIONS(549),
    [sym_next] = ACTIONS(549),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [59] = {
    [sym_block] = STATE(609),
    [sym__expression] = STATE(609),
    [sym_assign_receiver_field] = STATE(609),
    [sym_assign_local] = STATE(609),
    [sym_assign_field] = STATE(609),
    [sym_replace_local] = STATE(609),
    [sym_replace_field] = STATE(609),
    [sym_compound_assign_local] = STATE(609),
    [sym_compound_assign_field] = STATE(609),
    [sym_compound_assign_receiver_field] = STATE(609),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(609),
    [sym_call_with_receiver] = STATE(609),
    [sym_ref] = STATE(609),
    [sym_mut] = STATE(609),
    [sym_recover] = STATE(609),
    [sym_grouped_expression] = STATE(609),
    [sym_tuple] = STATE(609),
    [sym_array] = STATE(609),
    [sym_return] = STATE(609),
    [sym_try] = STATE(609),
    [sym_throw] = STATE(609),
    [sym_if] = STATE(609),
    [sym_while] = STATE(609),
    [sym_loop] = STATE(609),
    [sym_for] = STATE(609),
    [sym_match] = STATE(609),
    [sym_closure] = STATE(609),
    [sym_define_variable] = STATE(609),
    [sym_and_or] = STATE(609),
    [sym_binary] = STATE(609),
    [sym_cast] = STATE(609),
    [sym_string] = STATE(609),
    [sym_true] = STATE(609),
    [sym_false] = STATE(609),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_RPAREN] = ACTIONS(551),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(493),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(495),
    [sym_nil] = ACTIONS(495),
    [sym_break] = ACTIONS(495),
    [sym_next] = ACTIONS(495),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [60] = {
    [sym_block] = STATE(609),
    [sym__expression] = STATE(609),
    [sym_assign_receiver_field] = STATE(609),
    [sym_assign_local] = STATE(609),
    [sym_assign_field] = STATE(609),
    [sym_replace_local] = STATE(609),
    [sym_replace_field] = STATE(609),
    [sym_compound_assign_local] = STATE(609),
    [sym_compound_assign_field] = STATE(609),
    [sym_compound_assign_receiver_field] = STATE(609),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(609),
    [sym_call_with_receiver] = STATE(609),
    [sym_ref] = STATE(609),
    [sym_mut] = STATE(609),
    [sym_recover] = STATE(609),
    [sym_grouped_expression] = STATE(609),
    [sym_tuple] = STATE(609),
    [sym_array] = STATE(609),
    [sym_return] = STATE(609),
    [sym_try] = STATE(609),
    [sym_throw] = STATE(609),
    [sym_if] = STATE(609),
    [sym_while] = STATE(609),
    [sym_loop] = STATE(609),
    [sym_for] = STATE(609),
    [sym_match] = STATE(609),
    [sym_closure] = STATE(609),
    [sym_define_variable] = STATE(609),
    [sym_and_or] = STATE(609),
    [sym_binary] = STATE(609),
    [sym_cast] = STATE(609),
    [sym_string] = STATE(609),
    [sym_true] = STATE(609),
    [sym_false] = STATE(609),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_RPAREN] = ACTIONS(553),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(493),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(495),
    [sym_nil] = ACTIONS(495),
    [sym_break] = ACTIONS(495),
    [sym_next] = ACTIONS(495),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [61] = {
    [sym_block] = STATE(213),
    [sym__expression] = STATE(213),
    [sym_assign_receiver_field] = STATE(213),
    [sym_assign_local] = STATE(213),
    [sym_assign_field] = STATE(213),
    [sym_replace_local] = STATE(213),
    [sym_replace_field] = STATE(213),
    [sym_compound_assign_local] = STATE(213),
    [sym_compound_assign_field] = STATE(213),
    [sym_compound_assign_receiver_field] = STATE(213),
    [sym__call_name] = STATE(1138),
    [sym_call] = STATE(213),
    [sym_call_with_receiver] = STATE(213),
    [sym_ref] = STATE(213),
    [sym_mut] = STATE(213),
    [sym_recover] = STATE(213),
    [sym_grouped_expression] = STATE(213),
    [sym_tuple] = STATE(213),
    [sym_array] = STATE(213),
    [sym_return] = STATE(213),
    [sym_try] = STATE(213),
    [sym_throw] = STATE(213),
    [sym_if] = STATE(213),
    [sym_while] = STATE(213),
    [sym_loop] = STATE(213),
    [sym_for] = STATE(213),
    [sym_match] = STATE(213),
    [sym_closure] = STATE(213),
    [sym_define_variable] = STATE(213),
    [sym_and_or] = STATE(213),
    [sym_binary] = STATE(213),
    [sym_cast] = STATE(213),
    [sym_string] = STATE(213),
    [sym_true] = STATE(213),
    [sym_false] = STATE(213),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(15),
    [anon_sym_fn] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_mut] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(75),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_ref] = ACTIONS(35),
    [anon_sym_recover] = ACTIONS(37),
    [anon_sym_return] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(41),
    [anon_sym_throw] = ACTIONS(43),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_loop] = ACTIONS(47),
    [anon_sym_match] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [sym_float] = ACTIONS(555),
    [sym_integer] = ACTIONS(57),
    [anon_sym_SQUOTE] = ACTIONS(59),
    [sym_self] = ACTIONS(557),
    [sym_nil] = ACTIONS(557),
    [sym_break] = ACTIONS(557),
    [sym_next] = ACTIONS(557),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(63),
    [sym_field] = ACTIONS(65),
    [sym_constant] = ACTIONS(67),
  },
  [62] = {
    [sym_block] = STATE(624),
    [sym__expression] = STATE(624),
    [sym_assign_receiver_field] = STATE(624),
    [sym_assign_local] = STATE(624),
    [sym_assign_field] = STATE(624),
    [sym_replace_local] = STATE(624),
    [sym_replace_field] = STATE(624),
    [sym_compound_assign_local] = STATE(624),
    [sym_compound_assign_field] = STATE(624),
    [sym_compound_assign_receiver_field] = STATE(624),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(624),
    [sym_call_with_receiver] = STATE(624),
    [sym_ref] = STATE(624),
    [sym_mut] = STATE(624),
    [sym_recover] = STATE(624),
    [sym_grouped_expression] = STATE(624),
    [sym_tuple] = STATE(624),
    [sym_array] = STATE(624),
    [sym_return] = STATE(624),
    [sym_try] = STATE(624),
    [sym_throw] = STATE(624),
    [sym_if] = STATE(624),
    [sym_while] = STATE(624),
    [sym_loop] = STATE(624),
    [sym_for] = STATE(624),
    [sym_match] = STATE(624),
    [sym_closure] = STATE(624),
    [sym_define_variable] = STATE(624),
    [sym_and_or] = STATE(624),
    [sym_binary] = STATE(624),
    [sym_cast] = STATE(624),
    [sym_string] = STATE(624),
    [sym_true] = STATE(624),
    [sym_false] = STATE(624),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(559),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(561),
    [sym_nil] = ACTIONS(561),
    [sym_break] = ACTIONS(561),
    [sym_next] = ACTIONS(561),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [63] = {
    [sym_block] = STATE(238),
    [sym__expression] = STATE(238),
    [sym_assign_receiver_field] = STATE(238),
    [sym_assign_local] = STATE(238),
    [sym_assign_field] = STATE(238),
    [sym_replace_local] = STATE(238),
    [sym_replace_field] = STATE(238),
    [sym_compound_assign_local] = STATE(238),
    [sym_compound_assign_field] = STATE(238),
    [sym_compound_assign_receiver_field] = STATE(238),
    [sym__call_name] = STATE(1138),
    [sym_call] = STATE(238),
    [sym_call_with_receiver] = STATE(238),
    [sym_ref] = STATE(238),
    [sym_mut] = STATE(238),
    [sym_recover] = STATE(238),
    [sym_grouped_expression] = STATE(238),
    [sym_tuple] = STATE(238),
    [sym_array] = STATE(238),
    [sym_return] = STATE(238),
    [sym_try] = STATE(238),
    [sym_throw] = STATE(238),
    [sym_if] = STATE(238),
    [sym_while] = STATE(238),
    [sym_loop] = STATE(238),
    [sym_for] = STATE(238),
    [sym_match] = STATE(238),
    [sym_closure] = STATE(238),
    [sym_define_variable] = STATE(238),
    [sym_and_or] = STATE(238),
    [sym_binary] = STATE(238),
    [sym_cast] = STATE(238),
    [sym_string] = STATE(238),
    [sym_true] = STATE(238),
    [sym_false] = STATE(238),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(15),
    [anon_sym_fn] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_mut] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(75),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_ref] = ACTIONS(35),
    [anon_sym_recover] = ACTIONS(37),
    [anon_sym_return] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(41),
    [anon_sym_throw] = ACTIONS(43),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_loop] = ACTIONS(47),
    [anon_sym_match] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [sym_float] = ACTIONS(563),
    [sym_integer] = ACTIONS(57),
    [anon_sym_SQUOTE] = ACTIONS(59),
    [sym_self] = ACTIONS(565),
    [sym_nil] = ACTIONS(565),
    [sym_break] = ACTIONS(565),
    [sym_next] = ACTIONS(565),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(63),
    [sym_field] = ACTIONS(65),
    [sym_constant] = ACTIONS(67),
  },
  [64] = {
    [sym_block] = STATE(239),
    [sym__expression] = STATE(239),
    [sym_assign_receiver_field] = STATE(239),
    [sym_assign_local] = STATE(239),
    [sym_assign_field] = STATE(239),
    [sym_replace_local] = STATE(239),
    [sym_replace_field] = STATE(239),
    [sym_compound_assign_local] = STATE(239),
    [sym_compound_assign_field] = STATE(239),
    [sym_compound_assign_receiver_field] = STATE(239),
    [sym__call_name] = STATE(1138),
    [sym_call] = STATE(239),
    [sym_call_with_receiver] = STATE(239),
    [sym_ref] = STATE(239),
    [sym_mut] = STATE(239),
    [sym_recover] = STATE(239),
    [sym_grouped_expression] = STATE(239),
    [sym_tuple] = STATE(239),
    [sym_array] = STATE(239),
    [sym_return] = STATE(239),
    [sym_try] = STATE(239),
    [sym_throw] = STATE(239),
    [sym_if] = STATE(239),
    [sym_while] = STATE(239),
    [sym_loop] = STATE(239),
    [sym_for] = STATE(239),
    [sym_match] = STATE(239),
    [sym_closure] = STATE(239),
    [sym_define_variable] = STATE(239),
    [sym_and_or] = STATE(239),
    [sym_binary] = STATE(239),
    [sym_cast] = STATE(239),
    [sym_string] = STATE(239),
    [sym_true] = STATE(239),
    [sym_false] = STATE(239),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(15),
    [anon_sym_fn] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_mut] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(75),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_ref] = ACTIONS(35),
    [anon_sym_recover] = ACTIONS(37),
    [anon_sym_return] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(41),
    [anon_sym_throw] = ACTIONS(43),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_loop] = ACTIONS(47),
    [anon_sym_match] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [sym_float] = ACTIONS(567),
    [sym_integer] = ACTIONS(57),
    [anon_sym_SQUOTE] = ACTIONS(59),
    [sym_self] = ACTIONS(569),
    [sym_nil] = ACTIONS(569),
    [sym_break] = ACTIONS(569),
    [sym_next] = ACTIONS(569),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(63),
    [sym_field] = ACTIONS(65),
    [sym_constant] = ACTIONS(67),
  },
  [65] = {
    [sym_block] = STATE(628),
    [sym__expression] = STATE(628),
    [sym_assign_receiver_field] = STATE(628),
    [sym_assign_local] = STATE(628),
    [sym_assign_field] = STATE(628),
    [sym_replace_local] = STATE(628),
    [sym_replace_field] = STATE(628),
    [sym_compound_assign_local] = STATE(628),
    [sym_compound_assign_field] = STATE(628),
    [sym_compound_assign_receiver_field] = STATE(628),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(628),
    [sym_call_with_receiver] = STATE(628),
    [sym_ref] = STATE(628),
    [sym_mut] = STATE(628),
    [sym_recover] = STATE(628),
    [sym_grouped_expression] = STATE(628),
    [sym_tuple] = STATE(628),
    [sym_array] = STATE(628),
    [sym_return] = STATE(628),
    [sym_try] = STATE(628),
    [sym_throw] = STATE(628),
    [sym_if] = STATE(628),
    [sym_while] = STATE(628),
    [sym_loop] = STATE(628),
    [sym_for] = STATE(628),
    [sym_match] = STATE(628),
    [sym_closure] = STATE(628),
    [sym_define_variable] = STATE(628),
    [sym_and_or] = STATE(628),
    [sym_binary] = STATE(628),
    [sym_cast] = STATE(628),
    [sym_string] = STATE(628),
    [sym_true] = STATE(628),
    [sym_false] = STATE(628),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(571),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(573),
    [sym_nil] = ACTIONS(573),
    [sym_break] = ACTIONS(573),
    [sym_next] = ACTIONS(573),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [66] = {
    [sym_block] = STATE(629),
    [sym__expression] = STATE(629),
    [sym_assign_receiver_field] = STATE(629),
    [sym_assign_local] = STATE(629),
    [sym_assign_field] = STATE(629),
    [sym_replace_local] = STATE(629),
    [sym_replace_field] = STATE(629),
    [sym_compound_assign_local] = STATE(629),
    [sym_compound_assign_field] = STATE(629),
    [sym_compound_assign_receiver_field] = STATE(629),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(629),
    [sym_call_with_receiver] = STATE(629),
    [sym_ref] = STATE(629),
    [sym_mut] = STATE(629),
    [sym_recover] = STATE(629),
    [sym_grouped_expression] = STATE(629),
    [sym_tuple] = STATE(629),
    [sym_array] = STATE(629),
    [sym_return] = STATE(629),
    [sym_try] = STATE(629),
    [sym_throw] = STATE(629),
    [sym_if] = STATE(629),
    [sym_while] = STATE(629),
    [sym_loop] = STATE(629),
    [sym_for] = STATE(629),
    [sym_match] = STATE(629),
    [sym_closure] = STATE(629),
    [sym_define_variable] = STATE(629),
    [sym_and_or] = STATE(629),
    [sym_binary] = STATE(629),
    [sym_cast] = STATE(629),
    [sym_string] = STATE(629),
    [sym_true] = STATE(629),
    [sym_false] = STATE(629),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(575),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(577),
    [sym_nil] = ACTIONS(577),
    [sym_break] = ACTIONS(577),
    [sym_next] = ACTIONS(577),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [67] = {
    [sym_block] = STATE(237),
    [sym__expression] = STATE(237),
    [sym_assign_receiver_field] = STATE(237),
    [sym_assign_local] = STATE(237),
    [sym_assign_field] = STATE(237),
    [sym_replace_local] = STATE(237),
    [sym_replace_field] = STATE(237),
    [sym_compound_assign_local] = STATE(237),
    [sym_compound_assign_field] = STATE(237),
    [sym_compound_assign_receiver_field] = STATE(237),
    [sym__call_name] = STATE(1138),
    [sym_call] = STATE(237),
    [sym_call_with_receiver] = STATE(237),
    [sym_ref] = STATE(237),
    [sym_mut] = STATE(237),
    [sym_recover] = STATE(237),
    [sym_grouped_expression] = STATE(237),
    [sym_tuple] = STATE(237),
    [sym_array] = STATE(237),
    [sym_return] = STATE(237),
    [sym_try] = STATE(237),
    [sym_throw] = STATE(237),
    [sym_if] = STATE(237),
    [sym_while] = STATE(237),
    [sym_loop] = STATE(237),
    [sym_for] = STATE(237),
    [sym_match] = STATE(237),
    [sym_closure] = STATE(237),
    [sym_define_variable] = STATE(237),
    [sym_and_or] = STATE(237),
    [sym_binary] = STATE(237),
    [sym_cast] = STATE(237),
    [sym_string] = STATE(237),
    [sym_true] = STATE(237),
    [sym_false] = STATE(237),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(15),
    [anon_sym_fn] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_mut] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(75),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_ref] = ACTIONS(35),
    [anon_sym_recover] = ACTIONS(37),
    [anon_sym_return] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(41),
    [anon_sym_throw] = ACTIONS(43),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_loop] = ACTIONS(47),
    [anon_sym_match] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [sym_float] = ACTIONS(579),
    [sym_integer] = ACTIONS(57),
    [anon_sym_SQUOTE] = ACTIONS(59),
    [sym_self] = ACTIONS(581),
    [sym_nil] = ACTIONS(581),
    [sym_break] = ACTIONS(581),
    [sym_next] = ACTIONS(581),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(63),
    [sym_field] = ACTIONS(65),
    [sym_constant] = ACTIONS(67),
  },
  [68] = {
    [sym_block] = STATE(194),
    [sym__expression] = STATE(194),
    [sym_assign_receiver_field] = STATE(194),
    [sym_assign_local] = STATE(194),
    [sym_assign_field] = STATE(194),
    [sym_replace_local] = STATE(194),
    [sym_replace_field] = STATE(194),
    [sym_compound_assign_local] = STATE(194),
    [sym_compound_assign_field] = STATE(194),
    [sym_compound_assign_receiver_field] = STATE(194),
    [sym__call_name] = STATE(1138),
    [sym_call] = STATE(194),
    [sym_call_with_receiver] = STATE(194),
    [sym_ref] = STATE(194),
    [sym_mut] = STATE(194),
    [sym_recover] = STATE(194),
    [sym_grouped_expression] = STATE(194),
    [sym_tuple] = STATE(194),
    [sym_array] = STATE(194),
    [sym_return] = STATE(194),
    [sym_try] = STATE(194),
    [sym_throw] = STATE(194),
    [sym_if] = STATE(194),
    [sym_while] = STATE(194),
    [sym_loop] = STATE(194),
    [sym_for] = STATE(194),
    [sym_match] = STATE(194),
    [sym_closure] = STATE(194),
    [sym_define_variable] = STATE(194),
    [sym_and_or] = STATE(194),
    [sym_binary] = STATE(194),
    [sym_cast] = STATE(194),
    [sym_string] = STATE(194),
    [sym_true] = STATE(194),
    [sym_false] = STATE(194),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(15),
    [anon_sym_fn] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_mut] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(75),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_ref] = ACTIONS(35),
    [anon_sym_recover] = ACTIONS(37),
    [anon_sym_return] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(41),
    [anon_sym_throw] = ACTIONS(43),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_loop] = ACTIONS(47),
    [anon_sym_match] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [sym_float] = ACTIONS(583),
    [sym_integer] = ACTIONS(57),
    [anon_sym_SQUOTE] = ACTIONS(59),
    [sym_self] = ACTIONS(585),
    [sym_nil] = ACTIONS(585),
    [sym_break] = ACTIONS(585),
    [sym_next] = ACTIONS(585),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(63),
    [sym_field] = ACTIONS(65),
    [sym_constant] = ACTIONS(67),
  },
  [69] = {
    [sym_block] = STATE(206),
    [sym__expression] = STATE(206),
    [sym_assign_receiver_field] = STATE(206),
    [sym_assign_local] = STATE(206),
    [sym_assign_field] = STATE(206),
    [sym_replace_local] = STATE(206),
    [sym_replace_field] = STATE(206),
    [sym_compound_assign_local] = STATE(206),
    [sym_compound_assign_field] = STATE(206),
    [sym_compound_assign_receiver_field] = STATE(206),
    [sym__call_name] = STATE(1138),
    [sym_call] = STATE(206),
    [sym_call_with_receiver] = STATE(206),
    [sym_ref] = STATE(206),
    [sym_mut] = STATE(206),
    [sym_recover] = STATE(206),
    [sym_grouped_expression] = STATE(206),
    [sym_tuple] = STATE(206),
    [sym_array] = STATE(206),
    [sym_return] = STATE(206),
    [sym_try] = STATE(206),
    [sym_throw] = STATE(206),
    [sym_if] = STATE(206),
    [sym_while] = STATE(206),
    [sym_loop] = STATE(206),
    [sym_for] = STATE(206),
    [sym_match] = STATE(206),
    [sym_closure] = STATE(206),
    [sym_define_variable] = STATE(206),
    [sym_and_or] = STATE(206),
    [sym_binary] = STATE(206),
    [sym_cast] = STATE(206),
    [sym_string] = STATE(206),
    [sym_true] = STATE(206),
    [sym_false] = STATE(206),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(15),
    [anon_sym_fn] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_mut] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(75),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_ref] = ACTIONS(35),
    [anon_sym_recover] = ACTIONS(37),
    [anon_sym_return] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(41),
    [anon_sym_throw] = ACTIONS(43),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_loop] = ACTIONS(47),
    [anon_sym_match] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [sym_float] = ACTIONS(587),
    [sym_integer] = ACTIONS(57),
    [anon_sym_SQUOTE] = ACTIONS(59),
    [sym_self] = ACTIONS(589),
    [sym_nil] = ACTIONS(589),
    [sym_break] = ACTIONS(589),
    [sym_next] = ACTIONS(589),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(63),
    [sym_field] = ACTIONS(65),
    [sym_constant] = ACTIONS(67),
  },
  [70] = {
    [sym_block] = STATE(210),
    [sym__expression] = STATE(210),
    [sym_assign_receiver_field] = STATE(210),
    [sym_assign_local] = STATE(210),
    [sym_assign_field] = STATE(210),
    [sym_replace_local] = STATE(210),
    [sym_replace_field] = STATE(210),
    [sym_compound_assign_local] = STATE(210),
    [sym_compound_assign_field] = STATE(210),
    [sym_compound_assign_receiver_field] = STATE(210),
    [sym__call_name] = STATE(1138),
    [sym_call] = STATE(210),
    [sym_call_with_receiver] = STATE(210),
    [sym_ref] = STATE(210),
    [sym_mut] = STATE(210),
    [sym_recover] = STATE(210),
    [sym_grouped_expression] = STATE(210),
    [sym_tuple] = STATE(210),
    [sym_array] = STATE(210),
    [sym_return] = STATE(210),
    [sym_try] = STATE(210),
    [sym_throw] = STATE(210),
    [sym_if] = STATE(210),
    [sym_while] = STATE(210),
    [sym_loop] = STATE(210),
    [sym_for] = STATE(210),
    [sym_match] = STATE(210),
    [sym_closure] = STATE(210),
    [sym_define_variable] = STATE(210),
    [sym_and_or] = STATE(210),
    [sym_binary] = STATE(210),
    [sym_cast] = STATE(210),
    [sym_string] = STATE(210),
    [sym_true] = STATE(210),
    [sym_false] = STATE(210),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(15),
    [anon_sym_fn] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_mut] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(75),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_ref] = ACTIONS(35),
    [anon_sym_recover] = ACTIONS(37),
    [anon_sym_return] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(41),
    [anon_sym_throw] = ACTIONS(43),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_loop] = ACTIONS(47),
    [anon_sym_match] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [sym_float] = ACTIONS(591),
    [sym_integer] = ACTIONS(57),
    [anon_sym_SQUOTE] = ACTIONS(59),
    [sym_self] = ACTIONS(593),
    [sym_nil] = ACTIONS(593),
    [sym_break] = ACTIONS(593),
    [sym_next] = ACTIONS(593),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(63),
    [sym_field] = ACTIONS(65),
    [sym_constant] = ACTIONS(67),
  },
  [71] = {
    [sym_block] = STATE(634),
    [sym__expression] = STATE(634),
    [sym_assign_receiver_field] = STATE(634),
    [sym_assign_local] = STATE(634),
    [sym_assign_field] = STATE(634),
    [sym_replace_local] = STATE(634),
    [sym_replace_field] = STATE(634),
    [sym_compound_assign_local] = STATE(634),
    [sym_compound_assign_field] = STATE(634),
    [sym_compound_assign_receiver_field] = STATE(634),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(634),
    [sym_call_with_receiver] = STATE(634),
    [sym_ref] = STATE(634),
    [sym_mut] = STATE(634),
    [sym_recover] = STATE(634),
    [sym_grouped_expression] = STATE(634),
    [sym_tuple] = STATE(634),
    [sym_array] = STATE(634),
    [sym_return] = STATE(634),
    [sym_try] = STATE(634),
    [sym_throw] = STATE(634),
    [sym_if] = STATE(634),
    [sym_while] = STATE(634),
    [sym_loop] = STATE(634),
    [sym_for] = STATE(634),
    [sym_match] = STATE(634),
    [sym_closure] = STATE(634),
    [sym_define_variable] = STATE(634),
    [sym_and_or] = STATE(634),
    [sym_binary] = STATE(634),
    [sym_cast] = STATE(634),
    [sym_string] = STATE(634),
    [sym_true] = STATE(634),
    [sym_false] = STATE(634),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(595),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(597),
    [sym_nil] = ACTIONS(597),
    [sym_break] = ACTIONS(597),
    [sym_next] = ACTIONS(597),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [72] = {
    [sym_block] = STATE(225),
    [sym__expression] = STATE(225),
    [sym_assign_receiver_field] = STATE(225),
    [sym_assign_local] = STATE(225),
    [sym_assign_field] = STATE(225),
    [sym_replace_local] = STATE(225),
    [sym_replace_field] = STATE(225),
    [sym_compound_assign_local] = STATE(225),
    [sym_compound_assign_field] = STATE(225),
    [sym_compound_assign_receiver_field] = STATE(225),
    [sym__call_name] = STATE(1138),
    [sym_call] = STATE(225),
    [sym_call_with_receiver] = STATE(225),
    [sym_ref] = STATE(225),
    [sym_mut] = STATE(225),
    [sym_recover] = STATE(225),
    [sym_grouped_expression] = STATE(225),
    [sym_tuple] = STATE(225),
    [sym_array] = STATE(225),
    [sym_return] = STATE(225),
    [sym_try] = STATE(225),
    [sym_throw] = STATE(225),
    [sym_if] = STATE(225),
    [sym_while] = STATE(225),
    [sym_loop] = STATE(225),
    [sym_for] = STATE(225),
    [sym_match] = STATE(225),
    [sym_closure] = STATE(225),
    [sym_define_variable] = STATE(225),
    [sym_and_or] = STATE(225),
    [sym_binary] = STATE(225),
    [sym_cast] = STATE(225),
    [sym_string] = STATE(225),
    [sym_true] = STATE(225),
    [sym_false] = STATE(225),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(15),
    [anon_sym_fn] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_mut] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(75),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_ref] = ACTIONS(35),
    [anon_sym_recover] = ACTIONS(37),
    [anon_sym_return] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(41),
    [anon_sym_throw] = ACTIONS(43),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_loop] = ACTIONS(47),
    [anon_sym_match] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [sym_float] = ACTIONS(599),
    [sym_integer] = ACTIONS(57),
    [anon_sym_SQUOTE] = ACTIONS(59),
    [sym_self] = ACTIONS(601),
    [sym_nil] = ACTIONS(601),
    [sym_break] = ACTIONS(601),
    [sym_next] = ACTIONS(601),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(63),
    [sym_field] = ACTIONS(65),
    [sym_constant] = ACTIONS(67),
  },
  [73] = {
    [sym_block] = STATE(635),
    [sym__expression] = STATE(635),
    [sym_assign_receiver_field] = STATE(635),
    [sym_assign_local] = STATE(635),
    [sym_assign_field] = STATE(635),
    [sym_replace_local] = STATE(635),
    [sym_replace_field] = STATE(635),
    [sym_compound_assign_local] = STATE(635),
    [sym_compound_assign_field] = STATE(635),
    [sym_compound_assign_receiver_field] = STATE(635),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(635),
    [sym_call_with_receiver] = STATE(635),
    [sym_ref] = STATE(635),
    [sym_mut] = STATE(635),
    [sym_recover] = STATE(635),
    [sym_grouped_expression] = STATE(635),
    [sym_tuple] = STATE(635),
    [sym_array] = STATE(635),
    [sym_return] = STATE(635),
    [sym_try] = STATE(635),
    [sym_throw] = STATE(635),
    [sym_if] = STATE(635),
    [sym_while] = STATE(635),
    [sym_loop] = STATE(635),
    [sym_for] = STATE(635),
    [sym_match] = STATE(635),
    [sym_closure] = STATE(635),
    [sym_define_variable] = STATE(635),
    [sym_and_or] = STATE(635),
    [sym_binary] = STATE(635),
    [sym_cast] = STATE(635),
    [sym_string] = STATE(635),
    [sym_true] = STATE(635),
    [sym_false] = STATE(635),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(603),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(605),
    [sym_nil] = ACTIONS(605),
    [sym_break] = ACTIONS(605),
    [sym_next] = ACTIONS(605),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [74] = {
    [sym_block] = STATE(609),
    [sym__expression] = STATE(609),
    [sym_assign_receiver_field] = STATE(609),
    [sym_assign_local] = STATE(609),
    [sym_assign_field] = STATE(609),
    [sym_replace_local] = STATE(609),
    [sym_replace_field] = STATE(609),
    [sym_compound_assign_local] = STATE(609),
    [sym_compound_assign_field] = STATE(609),
    [sym_compound_assign_receiver_field] = STATE(609),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(609),
    [sym_call_with_receiver] = STATE(609),
    [sym_ref] = STATE(609),
    [sym_mut] = STATE(609),
    [sym_recover] = STATE(609),
    [sym_grouped_expression] = STATE(609),
    [sym_tuple] = STATE(609),
    [sym_array] = STATE(609),
    [sym_return] = STATE(609),
    [sym_try] = STATE(609),
    [sym_throw] = STATE(609),
    [sym_if] = STATE(609),
    [sym_while] = STATE(609),
    [sym_loop] = STATE(609),
    [sym_for] = STATE(609),
    [sym_match] = STATE(609),
    [sym_closure] = STATE(609),
    [sym_define_variable] = STATE(609),
    [sym_and_or] = STATE(609),
    [sym_binary] = STATE(609),
    [sym_cast] = STATE(609),
    [sym_string] = STATE(609),
    [sym_true] = STATE(609),
    [sym_false] = STATE(609),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(493),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(495),
    [sym_nil] = ACTIONS(495),
    [sym_break] = ACTIONS(495),
    [sym_next] = ACTIONS(495),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [75] = {
    [sym_block] = STATE(219),
    [sym__expression] = STATE(219),
    [sym_assign_receiver_field] = STATE(219),
    [sym_assign_local] = STATE(219),
    [sym_assign_field] = STATE(219),
    [sym_replace_local] = STATE(219),
    [sym_replace_field] = STATE(219),
    [sym_compound_assign_local] = STATE(219),
    [sym_compound_assign_field] = STATE(219),
    [sym_compound_assign_receiver_field] = STATE(219),
    [sym__call_name] = STATE(1138),
    [sym_call] = STATE(219),
    [sym_call_with_receiver] = STATE(219),
    [sym_ref] = STATE(219),
    [sym_mut] = STATE(219),
    [sym_recover] = STATE(219),
    [sym_grouped_expression] = STATE(219),
    [sym_tuple] = STATE(219),
    [sym_array] = STATE(219),
    [sym_return] = STATE(219),
    [sym_try] = STATE(219),
    [sym_throw] = STATE(219),
    [sym_if] = STATE(219),
    [sym_while] = STATE(219),
    [sym_loop] = STATE(219),
    [sym_for] = STATE(219),
    [sym_match] = STATE(219),
    [sym_closure] = STATE(219),
    [sym_define_variable] = STATE(219),
    [sym_and_or] = STATE(219),
    [sym_binary] = STATE(219),
    [sym_cast] = STATE(219),
    [sym_string] = STATE(219),
    [sym_true] = STATE(219),
    [sym_false] = STATE(219),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(15),
    [anon_sym_fn] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_mut] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(75),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_ref] = ACTIONS(35),
    [anon_sym_recover] = ACTIONS(37),
    [anon_sym_return] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(41),
    [anon_sym_throw] = ACTIONS(43),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_loop] = ACTIONS(47),
    [anon_sym_match] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [sym_float] = ACTIONS(607),
    [sym_integer] = ACTIONS(57),
    [anon_sym_SQUOTE] = ACTIONS(59),
    [sym_self] = ACTIONS(609),
    [sym_nil] = ACTIONS(609),
    [sym_break] = ACTIONS(609),
    [sym_next] = ACTIONS(609),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(63),
    [sym_field] = ACTIONS(65),
    [sym_constant] = ACTIONS(67),
  },
  [76] = {
    [sym_block] = STATE(258),
    [sym__expression] = STATE(258),
    [sym_assign_receiver_field] = STATE(258),
    [sym_assign_local] = STATE(258),
    [sym_assign_field] = STATE(258),
    [sym_replace_local] = STATE(258),
    [sym_replace_field] = STATE(258),
    [sym_compound_assign_local] = STATE(258),
    [sym_compound_assign_field] = STATE(258),
    [sym_compound_assign_receiver_field] = STATE(258),
    [sym__call_name] = STATE(1138),
    [sym_call] = STATE(258),
    [sym_call_with_receiver] = STATE(258),
    [sym_ref] = STATE(258),
    [sym_mut] = STATE(258),
    [sym_recover] = STATE(258),
    [sym_grouped_expression] = STATE(258),
    [sym_tuple] = STATE(258),
    [sym_array] = STATE(258),
    [sym_return] = STATE(258),
    [sym_try] = STATE(258),
    [sym_throw] = STATE(258),
    [sym_if] = STATE(258),
    [sym_while] = STATE(258),
    [sym_loop] = STATE(258),
    [sym_for] = STATE(258),
    [sym_match] = STATE(258),
    [sym_closure] = STATE(258),
    [sym_define_variable] = STATE(258),
    [sym_and_or] = STATE(258),
    [sym_binary] = STATE(258),
    [sym_cast] = STATE(258),
    [sym_string] = STATE(258),
    [sym_true] = STATE(258),
    [sym_false] = STATE(258),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(15),
    [anon_sym_fn] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_mut] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(75),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_ref] = ACTIONS(35),
    [anon_sym_recover] = ACTIONS(37),
    [anon_sym_return] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(41),
    [anon_sym_throw] = ACTIONS(43),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_loop] = ACTIONS(47),
    [anon_sym_match] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [sym_float] = ACTIONS(611),
    [sym_integer] = ACTIONS(57),
    [anon_sym_SQUOTE] = ACTIONS(59),
    [sym_self] = ACTIONS(613),
    [sym_nil] = ACTIONS(613),
    [sym_break] = ACTIONS(613),
    [sym_next] = ACTIONS(613),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(63),
    [sym_field] = ACTIONS(65),
    [sym_constant] = ACTIONS(67),
  },
  [77] = {
    [sym_block] = STATE(638),
    [sym__expression] = STATE(638),
    [sym_assign_receiver_field] = STATE(638),
    [sym_assign_local] = STATE(638),
    [sym_assign_field] = STATE(638),
    [sym_replace_local] = STATE(638),
    [sym_replace_field] = STATE(638),
    [sym_compound_assign_local] = STATE(638),
    [sym_compound_assign_field] = STATE(638),
    [sym_compound_assign_receiver_field] = STATE(638),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(638),
    [sym_call_with_receiver] = STATE(638),
    [sym_ref] = STATE(638),
    [sym_mut] = STATE(638),
    [sym_recover] = STATE(638),
    [sym_grouped_expression] = STATE(638),
    [sym_tuple] = STATE(638),
    [sym_array] = STATE(638),
    [sym_return] = STATE(638),
    [sym_try] = STATE(638),
    [sym_throw] = STATE(638),
    [sym_if] = STATE(638),
    [sym_while] = STATE(638),
    [sym_loop] = STATE(638),
    [sym_for] = STATE(638),
    [sym_match] = STATE(638),
    [sym_closure] = STATE(638),
    [sym_define_variable] = STATE(638),
    [sym_and_or] = STATE(638),
    [sym_binary] = STATE(638),
    [sym_cast] = STATE(638),
    [sym_string] = STATE(638),
    [sym_true] = STATE(638),
    [sym_false] = STATE(638),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(615),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(617),
    [sym_nil] = ACTIONS(617),
    [sym_break] = ACTIONS(617),
    [sym_next] = ACTIONS(617),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [78] = {
    [sym_block] = STATE(605),
    [sym__expression] = STATE(605),
    [sym_assign_receiver_field] = STATE(605),
    [sym_assign_local] = STATE(605),
    [sym_assign_field] = STATE(605),
    [sym_replace_local] = STATE(605),
    [sym_replace_field] = STATE(605),
    [sym_compound_assign_local] = STATE(605),
    [sym_compound_assign_field] = STATE(605),
    [sym_compound_assign_receiver_field] = STATE(605),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(605),
    [sym_call_with_receiver] = STATE(605),
    [sym_ref] = STATE(605),
    [sym_mut] = STATE(605),
    [sym_recover] = STATE(605),
    [sym_grouped_expression] = STATE(605),
    [sym_tuple] = STATE(605),
    [sym_array] = STATE(605),
    [sym_return] = STATE(605),
    [sym_try] = STATE(605),
    [sym_throw] = STATE(605),
    [sym_if] = STATE(605),
    [sym_while] = STATE(605),
    [sym_loop] = STATE(605),
    [sym_for] = STATE(605),
    [sym_match] = STATE(605),
    [sym_closure] = STATE(605),
    [sym_define_variable] = STATE(605),
    [sym_and_or] = STATE(605),
    [sym_binary] = STATE(605),
    [sym_cast] = STATE(605),
    [sym_string] = STATE(605),
    [sym_true] = STATE(605),
    [sym_false] = STATE(605),
    [sym_identifier] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(137),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(139),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(141),
    [anon_sym_recover] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_try] = ACTIONS(147),
    [anon_sym_throw] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(619),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(621),
    [sym_nil] = ACTIONS(621),
    [sym_break] = ACTIONS(621),
    [sym_next] = ACTIONS(621),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(155),
    [sym_constant] = ACTIONS(133),
  },
  [79] = {
    [sym_block] = STATE(610),
    [sym__expression] = STATE(610),
    [sym_assign_receiver_field] = STATE(610),
    [sym_assign_local] = STATE(610),
    [sym_assign_field] = STATE(610),
    [sym_replace_local] = STATE(610),
    [sym_replace_field] = STATE(610),
    [sym_compound_assign_local] = STATE(610),
    [sym_compound_assign_field] = STATE(610),
    [sym_compound_assign_receiver_field] = STATE(610),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(610),
    [sym_call_with_receiver] = STATE(610),
    [sym_ref] = STATE(610),
    [sym_mut] = STATE(610),
    [sym_recover] = STATE(610),
    [sym_grouped_expression] = STATE(610),
    [sym_tuple] = STATE(610),
    [sym_array] = STATE(610),
    [sym_return] = STATE(610),
    [sym_try] = STATE(610),
    [sym_throw] = STATE(610),
    [sym_if] = STATE(610),
    [sym_while] = STATE(610),
    [sym_loop] = STATE(610),
    [sym_for] = STATE(610),
    [sym_match] = STATE(610),
    [sym_closure] = STATE(610),
    [sym_define_variable] = STATE(610),
    [sym_and_or] = STATE(610),
    [sym_binary] = STATE(610),
    [sym_cast] = STATE(610),
    [sym_string] = STATE(610),
    [sym_true] = STATE(610),
    [sym_false] = STATE(610),
    [sym_identifier] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(137),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(139),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(141),
    [anon_sym_recover] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_try] = ACTIONS(147),
    [anon_sym_throw] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(623),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(625),
    [sym_nil] = ACTIONS(625),
    [sym_break] = ACTIONS(625),
    [sym_next] = ACTIONS(625),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(155),
    [sym_constant] = ACTIONS(133),
  },
  [80] = {
    [sym_block] = STATE(578),
    [sym__expression] = STATE(578),
    [sym_assign_receiver_field] = STATE(578),
    [sym_assign_local] = STATE(578),
    [sym_assign_field] = STATE(578),
    [sym_replace_local] = STATE(578),
    [sym_replace_field] = STATE(578),
    [sym_compound_assign_local] = STATE(578),
    [sym_compound_assign_field] = STATE(578),
    [sym_compound_assign_receiver_field] = STATE(578),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(578),
    [sym_call_with_receiver] = STATE(578),
    [sym_ref] = STATE(578),
    [sym_mut] = STATE(578),
    [sym_recover] = STATE(578),
    [sym_grouped_expression] = STATE(578),
    [sym_tuple] = STATE(578),
    [sym_array] = STATE(578),
    [sym_return] = STATE(578),
    [sym_try] = STATE(578),
    [sym_throw] = STATE(578),
    [sym_if] = STATE(578),
    [sym_while] = STATE(578),
    [sym_loop] = STATE(578),
    [sym_for] = STATE(578),
    [sym_match] = STATE(578),
    [sym_closure] = STATE(578),
    [sym_define_variable] = STATE(578),
    [sym_and_or] = STATE(578),
    [sym_binary] = STATE(578),
    [sym_cast] = STATE(578),
    [sym_string] = STATE(578),
    [sym_true] = STATE(578),
    [sym_false] = STATE(578),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(627),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(629),
    [sym_nil] = ACTIONS(629),
    [sym_break] = ACTIONS(629),
    [sym_next] = ACTIONS(629),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [81] = {
    [sym_block] = STATE(583),
    [sym__expression] = STATE(583),
    [sym_assign_receiver_field] = STATE(583),
    [sym_assign_local] = STATE(583),
    [sym_assign_field] = STATE(583),
    [sym_replace_local] = STATE(583),
    [sym_replace_field] = STATE(583),
    [sym_compound_assign_local] = STATE(583),
    [sym_compound_assign_field] = STATE(583),
    [sym_compound_assign_receiver_field] = STATE(583),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(583),
    [sym_call_with_receiver] = STATE(583),
    [sym_ref] = STATE(583),
    [sym_mut] = STATE(583),
    [sym_recover] = STATE(583),
    [sym_grouped_expression] = STATE(583),
    [sym_tuple] = STATE(583),
    [sym_array] = STATE(583),
    [sym_return] = STATE(583),
    [sym_try] = STATE(583),
    [sym_throw] = STATE(583),
    [sym_if] = STATE(583),
    [sym_while] = STATE(583),
    [sym_loop] = STATE(583),
    [sym_for] = STATE(583),
    [sym_match] = STATE(583),
    [sym_closure] = STATE(583),
    [sym_define_variable] = STATE(583),
    [sym_and_or] = STATE(583),
    [sym_binary] = STATE(583),
    [sym_cast] = STATE(583),
    [sym_string] = STATE(583),
    [sym_true] = STATE(583),
    [sym_false] = STATE(583),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(631),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(633),
    [sym_nil] = ACTIONS(633),
    [sym_break] = ACTIONS(633),
    [sym_next] = ACTIONS(633),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [82] = {
    [sym_block] = STATE(227),
    [sym__expression] = STATE(227),
    [sym_assign_receiver_field] = STATE(227),
    [sym_assign_local] = STATE(227),
    [sym_assign_field] = STATE(227),
    [sym_replace_local] = STATE(227),
    [sym_replace_field] = STATE(227),
    [sym_compound_assign_local] = STATE(227),
    [sym_compound_assign_field] = STATE(227),
    [sym_compound_assign_receiver_field] = STATE(227),
    [sym__call_name] = STATE(1138),
    [sym_call] = STATE(227),
    [sym_call_with_receiver] = STATE(227),
    [sym_ref] = STATE(227),
    [sym_mut] = STATE(227),
    [sym_recover] = STATE(227),
    [sym_grouped_expression] = STATE(227),
    [sym_tuple] = STATE(227),
    [sym_array] = STATE(227),
    [sym_return] = STATE(227),
    [sym_try] = STATE(227),
    [sym_throw] = STATE(227),
    [sym_if] = STATE(227),
    [sym_while] = STATE(227),
    [sym_loop] = STATE(227),
    [sym_for] = STATE(227),
    [sym_match] = STATE(227),
    [sym_closure] = STATE(227),
    [sym_define_variable] = STATE(227),
    [sym_and_or] = STATE(227),
    [sym_binary] = STATE(227),
    [sym_cast] = STATE(227),
    [sym_string] = STATE(227),
    [sym_true] = STATE(227),
    [sym_false] = STATE(227),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(15),
    [anon_sym_fn] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_mut] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(75),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_ref] = ACTIONS(35),
    [anon_sym_recover] = ACTIONS(37),
    [anon_sym_return] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(41),
    [anon_sym_throw] = ACTIONS(43),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_loop] = ACTIONS(47),
    [anon_sym_match] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [sym_float] = ACTIONS(635),
    [sym_integer] = ACTIONS(57),
    [anon_sym_SQUOTE] = ACTIONS(59),
    [sym_self] = ACTIONS(637),
    [sym_nil] = ACTIONS(637),
    [sym_break] = ACTIONS(637),
    [sym_next] = ACTIONS(637),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(63),
    [sym_field] = ACTIONS(65),
    [sym_constant] = ACTIONS(67),
  },
  [83] = {
    [sym_block] = STATE(589),
    [sym__expression] = STATE(589),
    [sym_assign_receiver_field] = STATE(589),
    [sym_assign_local] = STATE(589),
    [sym_assign_field] = STATE(589),
    [sym_replace_local] = STATE(589),
    [sym_replace_field] = STATE(589),
    [sym_compound_assign_local] = STATE(589),
    [sym_compound_assign_field] = STATE(589),
    [sym_compound_assign_receiver_field] = STATE(589),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(589),
    [sym_call_with_receiver] = STATE(589),
    [sym_ref] = STATE(589),
    [sym_mut] = STATE(589),
    [sym_recover] = STATE(589),
    [sym_grouped_expression] = STATE(589),
    [sym_tuple] = STATE(589),
    [sym_array] = STATE(589),
    [sym_return] = STATE(589),
    [sym_try] = STATE(589),
    [sym_throw] = STATE(589),
    [sym_if] = STATE(589),
    [sym_while] = STATE(589),
    [sym_loop] = STATE(589),
    [sym_for] = STATE(589),
    [sym_match] = STATE(589),
    [sym_closure] = STATE(589),
    [sym_define_variable] = STATE(589),
    [sym_and_or] = STATE(589),
    [sym_binary] = STATE(589),
    [sym_cast] = STATE(589),
    [sym_string] = STATE(589),
    [sym_true] = STATE(589),
    [sym_false] = STATE(589),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(639),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(641),
    [sym_nil] = ACTIONS(641),
    [sym_break] = ACTIONS(641),
    [sym_next] = ACTIONS(641),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [84] = {
    [sym_block] = STATE(581),
    [sym__expression] = STATE(581),
    [sym_assign_receiver_field] = STATE(581),
    [sym_assign_local] = STATE(581),
    [sym_assign_field] = STATE(581),
    [sym_replace_local] = STATE(581),
    [sym_replace_field] = STATE(581),
    [sym_compound_assign_local] = STATE(581),
    [sym_compound_assign_field] = STATE(581),
    [sym_compound_assign_receiver_field] = STATE(581),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(581),
    [sym_call_with_receiver] = STATE(581),
    [sym_ref] = STATE(581),
    [sym_mut] = STATE(581),
    [sym_recover] = STATE(581),
    [sym_grouped_expression] = STATE(581),
    [sym_tuple] = STATE(581),
    [sym_array] = STATE(581),
    [sym_return] = STATE(581),
    [sym_try] = STATE(581),
    [sym_throw] = STATE(581),
    [sym_if] = STATE(581),
    [sym_while] = STATE(581),
    [sym_loop] = STATE(581),
    [sym_for] = STATE(581),
    [sym_match] = STATE(581),
    [sym_closure] = STATE(581),
    [sym_define_variable] = STATE(581),
    [sym_and_or] = STATE(581),
    [sym_binary] = STATE(581),
    [sym_cast] = STATE(581),
    [sym_string] = STATE(581),
    [sym_true] = STATE(581),
    [sym_false] = STATE(581),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(643),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(645),
    [sym_nil] = ACTIONS(645),
    [sym_break] = ACTIONS(645),
    [sym_next] = ACTIONS(645),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [85] = {
    [sym_block] = STATE(582),
    [sym__expression] = STATE(582),
    [sym_assign_receiver_field] = STATE(582),
    [sym_assign_local] = STATE(582),
    [sym_assign_field] = STATE(582),
    [sym_replace_local] = STATE(582),
    [sym_replace_field] = STATE(582),
    [sym_compound_assign_local] = STATE(582),
    [sym_compound_assign_field] = STATE(582),
    [sym_compound_assign_receiver_field] = STATE(582),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(582),
    [sym_call_with_receiver] = STATE(582),
    [sym_ref] = STATE(582),
    [sym_mut] = STATE(582),
    [sym_recover] = STATE(582),
    [sym_grouped_expression] = STATE(582),
    [sym_tuple] = STATE(582),
    [sym_array] = STATE(582),
    [sym_return] = STATE(582),
    [sym_try] = STATE(582),
    [sym_throw] = STATE(582),
    [sym_if] = STATE(582),
    [sym_while] = STATE(582),
    [sym_loop] = STATE(582),
    [sym_for] = STATE(582),
    [sym_match] = STATE(582),
    [sym_closure] = STATE(582),
    [sym_define_variable] = STATE(582),
    [sym_and_or] = STATE(582),
    [sym_binary] = STATE(582),
    [sym_cast] = STATE(582),
    [sym_string] = STATE(582),
    [sym_true] = STATE(582),
    [sym_false] = STATE(582),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(647),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(649),
    [sym_nil] = ACTIONS(649),
    [sym_break] = ACTIONS(649),
    [sym_next] = ACTIONS(649),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [86] = {
    [sym_block] = STATE(586),
    [sym__expression] = STATE(586),
    [sym_assign_receiver_field] = STATE(586),
    [sym_assign_local] = STATE(586),
    [sym_assign_field] = STATE(586),
    [sym_replace_local] = STATE(586),
    [sym_replace_field] = STATE(586),
    [sym_compound_assign_local] = STATE(586),
    [sym_compound_assign_field] = STATE(586),
    [sym_compound_assign_receiver_field] = STATE(586),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(586),
    [sym_call_with_receiver] = STATE(586),
    [sym_ref] = STATE(586),
    [sym_mut] = STATE(586),
    [sym_recover] = STATE(586),
    [sym_grouped_expression] = STATE(586),
    [sym_tuple] = STATE(586),
    [sym_array] = STATE(586),
    [sym_return] = STATE(586),
    [sym_try] = STATE(586),
    [sym_throw] = STATE(586),
    [sym_if] = STATE(586),
    [sym_while] = STATE(586),
    [sym_loop] = STATE(586),
    [sym_for] = STATE(586),
    [sym_match] = STATE(586),
    [sym_closure] = STATE(586),
    [sym_define_variable] = STATE(586),
    [sym_and_or] = STATE(586),
    [sym_binary] = STATE(586),
    [sym_cast] = STATE(586),
    [sym_string] = STATE(586),
    [sym_true] = STATE(586),
    [sym_false] = STATE(586),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(651),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(653),
    [sym_nil] = ACTIONS(653),
    [sym_break] = ACTIONS(653),
    [sym_next] = ACTIONS(653),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [87] = {
    [sym_block] = STATE(574),
    [sym__expression] = STATE(574),
    [sym_assign_receiver_field] = STATE(574),
    [sym_assign_local] = STATE(574),
    [sym_assign_field] = STATE(574),
    [sym_replace_local] = STATE(574),
    [sym_replace_field] = STATE(574),
    [sym_compound_assign_local] = STATE(574),
    [sym_compound_assign_field] = STATE(574),
    [sym_compound_assign_receiver_field] = STATE(574),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(574),
    [sym_call_with_receiver] = STATE(574),
    [sym_ref] = STATE(574),
    [sym_mut] = STATE(574),
    [sym_recover] = STATE(574),
    [sym_grouped_expression] = STATE(574),
    [sym_tuple] = STATE(574),
    [sym_array] = STATE(574),
    [sym_return] = STATE(574),
    [sym_try] = STATE(574),
    [sym_throw] = STATE(574),
    [sym_if] = STATE(574),
    [sym_while] = STATE(574),
    [sym_loop] = STATE(574),
    [sym_for] = STATE(574),
    [sym_match] = STATE(574),
    [sym_closure] = STATE(574),
    [sym_define_variable] = STATE(574),
    [sym_and_or] = STATE(574),
    [sym_binary] = STATE(574),
    [sym_cast] = STATE(574),
    [sym_string] = STATE(574),
    [sym_true] = STATE(574),
    [sym_false] = STATE(574),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(655),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(657),
    [sym_nil] = ACTIONS(657),
    [sym_break] = ACTIONS(657),
    [sym_next] = ACTIONS(657),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [88] = {
    [sym_block] = STATE(572),
    [sym__expression] = STATE(572),
    [sym_assign_receiver_field] = STATE(572),
    [sym_assign_local] = STATE(572),
    [sym_assign_field] = STATE(572),
    [sym_replace_local] = STATE(572),
    [sym_replace_field] = STATE(572),
    [sym_compound_assign_local] = STATE(572),
    [sym_compound_assign_field] = STATE(572),
    [sym_compound_assign_receiver_field] = STATE(572),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(572),
    [sym_call_with_receiver] = STATE(572),
    [sym_ref] = STATE(572),
    [sym_mut] = STATE(572),
    [sym_recover] = STATE(572),
    [sym_grouped_expression] = STATE(572),
    [sym_tuple] = STATE(572),
    [sym_array] = STATE(572),
    [sym_return] = STATE(572),
    [sym_try] = STATE(572),
    [sym_throw] = STATE(572),
    [sym_if] = STATE(572),
    [sym_while] = STATE(572),
    [sym_loop] = STATE(572),
    [sym_for] = STATE(572),
    [sym_match] = STATE(572),
    [sym_closure] = STATE(572),
    [sym_define_variable] = STATE(572),
    [sym_and_or] = STATE(572),
    [sym_binary] = STATE(572),
    [sym_cast] = STATE(572),
    [sym_string] = STATE(572),
    [sym_true] = STATE(572),
    [sym_false] = STATE(572),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(659),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(661),
    [sym_nil] = ACTIONS(661),
    [sym_break] = ACTIONS(661),
    [sym_next] = ACTIONS(661),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [89] = {
    [sym_block] = STATE(569),
    [sym__expression] = STATE(569),
    [sym_assign_receiver_field] = STATE(569),
    [sym_assign_local] = STATE(569),
    [sym_assign_field] = STATE(569),
    [sym_replace_local] = STATE(569),
    [sym_replace_field] = STATE(569),
    [sym_compound_assign_local] = STATE(569),
    [sym_compound_assign_field] = STATE(569),
    [sym_compound_assign_receiver_field] = STATE(569),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(569),
    [sym_call_with_receiver] = STATE(569),
    [sym_ref] = STATE(569),
    [sym_mut] = STATE(569),
    [sym_recover] = STATE(569),
    [sym_grouped_expression] = STATE(569),
    [sym_tuple] = STATE(569),
    [sym_array] = STATE(569),
    [sym_return] = STATE(569),
    [sym_try] = STATE(569),
    [sym_throw] = STATE(569),
    [sym_if] = STATE(569),
    [sym_while] = STATE(569),
    [sym_loop] = STATE(569),
    [sym_for] = STATE(569),
    [sym_match] = STATE(569),
    [sym_closure] = STATE(569),
    [sym_define_variable] = STATE(569),
    [sym_and_or] = STATE(569),
    [sym_binary] = STATE(569),
    [sym_cast] = STATE(569),
    [sym_string] = STATE(569),
    [sym_true] = STATE(569),
    [sym_false] = STATE(569),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(663),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(665),
    [sym_nil] = ACTIONS(665),
    [sym_break] = ACTIONS(665),
    [sym_next] = ACTIONS(665),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [90] = {
    [sym_block] = STATE(571),
    [sym__expression] = STATE(571),
    [sym_assign_receiver_field] = STATE(571),
    [sym_assign_local] = STATE(571),
    [sym_assign_field] = STATE(571),
    [sym_replace_local] = STATE(571),
    [sym_replace_field] = STATE(571),
    [sym_compound_assign_local] = STATE(571),
    [sym_compound_assign_field] = STATE(571),
    [sym_compound_assign_receiver_field] = STATE(571),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(571),
    [sym_call_with_receiver] = STATE(571),
    [sym_ref] = STATE(571),
    [sym_mut] = STATE(571),
    [sym_recover] = STATE(571),
    [sym_grouped_expression] = STATE(571),
    [sym_tuple] = STATE(571),
    [sym_array] = STATE(571),
    [sym_return] = STATE(571),
    [sym_try] = STATE(571),
    [sym_throw] = STATE(571),
    [sym_if] = STATE(571),
    [sym_while] = STATE(571),
    [sym_loop] = STATE(571),
    [sym_for] = STATE(571),
    [sym_match] = STATE(571),
    [sym_closure] = STATE(571),
    [sym_define_variable] = STATE(571),
    [sym_and_or] = STATE(571),
    [sym_binary] = STATE(571),
    [sym_cast] = STATE(571),
    [sym_string] = STATE(571),
    [sym_true] = STATE(571),
    [sym_false] = STATE(571),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(667),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(669),
    [sym_nil] = ACTIONS(669),
    [sym_break] = ACTIONS(669),
    [sym_next] = ACTIONS(669),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [91] = {
    [sym_block] = STATE(579),
    [sym__expression] = STATE(579),
    [sym_assign_receiver_field] = STATE(579),
    [sym_assign_local] = STATE(579),
    [sym_assign_field] = STATE(579),
    [sym_replace_local] = STATE(579),
    [sym_replace_field] = STATE(579),
    [sym_compound_assign_local] = STATE(579),
    [sym_compound_assign_field] = STATE(579),
    [sym_compound_assign_receiver_field] = STATE(579),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(579),
    [sym_call_with_receiver] = STATE(579),
    [sym_ref] = STATE(579),
    [sym_mut] = STATE(579),
    [sym_recover] = STATE(579),
    [sym_grouped_expression] = STATE(579),
    [sym_tuple] = STATE(579),
    [sym_array] = STATE(579),
    [sym_return] = STATE(579),
    [sym_try] = STATE(579),
    [sym_throw] = STATE(579),
    [sym_if] = STATE(579),
    [sym_while] = STATE(579),
    [sym_loop] = STATE(579),
    [sym_for] = STATE(579),
    [sym_match] = STATE(579),
    [sym_closure] = STATE(579),
    [sym_define_variable] = STATE(579),
    [sym_and_or] = STATE(579),
    [sym_binary] = STATE(579),
    [sym_cast] = STATE(579),
    [sym_string] = STATE(579),
    [sym_true] = STATE(579),
    [sym_false] = STATE(579),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(671),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(673),
    [sym_nil] = ACTIONS(673),
    [sym_break] = ACTIONS(673),
    [sym_next] = ACTIONS(673),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [92] = {
    [sym_block] = STATE(580),
    [sym__expression] = STATE(580),
    [sym_assign_receiver_field] = STATE(580),
    [sym_assign_local] = STATE(580),
    [sym_assign_field] = STATE(580),
    [sym_replace_local] = STATE(580),
    [sym_replace_field] = STATE(580),
    [sym_compound_assign_local] = STATE(580),
    [sym_compound_assign_field] = STATE(580),
    [sym_compound_assign_receiver_field] = STATE(580),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(580),
    [sym_call_with_receiver] = STATE(580),
    [sym_ref] = STATE(580),
    [sym_mut] = STATE(580),
    [sym_recover] = STATE(580),
    [sym_grouped_expression] = STATE(580),
    [sym_tuple] = STATE(580),
    [sym_array] = STATE(580),
    [sym_return] = STATE(580),
    [sym_try] = STATE(580),
    [sym_throw] = STATE(580),
    [sym_if] = STATE(580),
    [sym_while] = STATE(580),
    [sym_loop] = STATE(580),
    [sym_for] = STATE(580),
    [sym_match] = STATE(580),
    [sym_closure] = STATE(580),
    [sym_define_variable] = STATE(580),
    [sym_and_or] = STATE(580),
    [sym_binary] = STATE(580),
    [sym_cast] = STATE(580),
    [sym_string] = STATE(580),
    [sym_true] = STATE(580),
    [sym_false] = STATE(580),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(675),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(677),
    [sym_nil] = ACTIONS(677),
    [sym_break] = ACTIONS(677),
    [sym_next] = ACTIONS(677),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [93] = {
    [sym_block] = STATE(585),
    [sym__expression] = STATE(585),
    [sym_assign_receiver_field] = STATE(585),
    [sym_assign_local] = STATE(585),
    [sym_assign_field] = STATE(585),
    [sym_replace_local] = STATE(585),
    [sym_replace_field] = STATE(585),
    [sym_compound_assign_local] = STATE(585),
    [sym_compound_assign_field] = STATE(585),
    [sym_compound_assign_receiver_field] = STATE(585),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(585),
    [sym_call_with_receiver] = STATE(585),
    [sym_ref] = STATE(585),
    [sym_mut] = STATE(585),
    [sym_recover] = STATE(585),
    [sym_grouped_expression] = STATE(585),
    [sym_tuple] = STATE(585),
    [sym_array] = STATE(585),
    [sym_return] = STATE(585),
    [sym_try] = STATE(585),
    [sym_throw] = STATE(585),
    [sym_if] = STATE(585),
    [sym_while] = STATE(585),
    [sym_loop] = STATE(585),
    [sym_for] = STATE(585),
    [sym_match] = STATE(585),
    [sym_closure] = STATE(585),
    [sym_define_variable] = STATE(585),
    [sym_and_or] = STATE(585),
    [sym_binary] = STATE(585),
    [sym_cast] = STATE(585),
    [sym_string] = STATE(585),
    [sym_true] = STATE(585),
    [sym_false] = STATE(585),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(679),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(681),
    [sym_nil] = ACTIONS(681),
    [sym_break] = ACTIONS(681),
    [sym_next] = ACTIONS(681),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [94] = {
    [sym_block] = STATE(584),
    [sym__expression] = STATE(584),
    [sym_assign_receiver_field] = STATE(584),
    [sym_assign_local] = STATE(584),
    [sym_assign_field] = STATE(584),
    [sym_replace_local] = STATE(584),
    [sym_replace_field] = STATE(584),
    [sym_compound_assign_local] = STATE(584),
    [sym_compound_assign_field] = STATE(584),
    [sym_compound_assign_receiver_field] = STATE(584),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(584),
    [sym_call_with_receiver] = STATE(584),
    [sym_ref] = STATE(584),
    [sym_mut] = STATE(584),
    [sym_recover] = STATE(584),
    [sym_grouped_expression] = STATE(584),
    [sym_tuple] = STATE(584),
    [sym_array] = STATE(584),
    [sym_return] = STATE(584),
    [sym_try] = STATE(584),
    [sym_throw] = STATE(584),
    [sym_if] = STATE(584),
    [sym_while] = STATE(584),
    [sym_loop] = STATE(584),
    [sym_for] = STATE(584),
    [sym_match] = STATE(584),
    [sym_closure] = STATE(584),
    [sym_define_variable] = STATE(584),
    [sym_and_or] = STATE(584),
    [sym_binary] = STATE(584),
    [sym_cast] = STATE(584),
    [sym_string] = STATE(584),
    [sym_true] = STATE(584),
    [sym_false] = STATE(584),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(683),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(685),
    [sym_nil] = ACTIONS(685),
    [sym_break] = ACTIONS(685),
    [sym_next] = ACTIONS(685),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [95] = {
    [sym_block] = STATE(570),
    [sym__expression] = STATE(570),
    [sym_assign_receiver_field] = STATE(570),
    [sym_assign_local] = STATE(570),
    [sym_assign_field] = STATE(570),
    [sym_replace_local] = STATE(570),
    [sym_replace_field] = STATE(570),
    [sym_compound_assign_local] = STATE(570),
    [sym_compound_assign_field] = STATE(570),
    [sym_compound_assign_receiver_field] = STATE(570),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(570),
    [sym_call_with_receiver] = STATE(570),
    [sym_ref] = STATE(570),
    [sym_mut] = STATE(570),
    [sym_recover] = STATE(570),
    [sym_grouped_expression] = STATE(570),
    [sym_tuple] = STATE(570),
    [sym_array] = STATE(570),
    [sym_return] = STATE(570),
    [sym_try] = STATE(570),
    [sym_throw] = STATE(570),
    [sym_if] = STATE(570),
    [sym_while] = STATE(570),
    [sym_loop] = STATE(570),
    [sym_for] = STATE(570),
    [sym_match] = STATE(570),
    [sym_closure] = STATE(570),
    [sym_define_variable] = STATE(570),
    [sym_and_or] = STATE(570),
    [sym_binary] = STATE(570),
    [sym_cast] = STATE(570),
    [sym_string] = STATE(570),
    [sym_true] = STATE(570),
    [sym_false] = STATE(570),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(687),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(689),
    [sym_nil] = ACTIONS(689),
    [sym_break] = ACTIONS(689),
    [sym_next] = ACTIONS(689),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [96] = {
    [sym_block] = STATE(573),
    [sym__expression] = STATE(573),
    [sym_assign_receiver_field] = STATE(573),
    [sym_assign_local] = STATE(573),
    [sym_assign_field] = STATE(573),
    [sym_replace_local] = STATE(573),
    [sym_replace_field] = STATE(573),
    [sym_compound_assign_local] = STATE(573),
    [sym_compound_assign_field] = STATE(573),
    [sym_compound_assign_receiver_field] = STATE(573),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(573),
    [sym_call_with_receiver] = STATE(573),
    [sym_ref] = STATE(573),
    [sym_mut] = STATE(573),
    [sym_recover] = STATE(573),
    [sym_grouped_expression] = STATE(573),
    [sym_tuple] = STATE(573),
    [sym_array] = STATE(573),
    [sym_return] = STATE(573),
    [sym_try] = STATE(573),
    [sym_throw] = STATE(573),
    [sym_if] = STATE(573),
    [sym_while] = STATE(573),
    [sym_loop] = STATE(573),
    [sym_for] = STATE(573),
    [sym_match] = STATE(573),
    [sym_closure] = STATE(573),
    [sym_define_variable] = STATE(573),
    [sym_and_or] = STATE(573),
    [sym_binary] = STATE(573),
    [sym_cast] = STATE(573),
    [sym_string] = STATE(573),
    [sym_true] = STATE(573),
    [sym_false] = STATE(573),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(691),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(693),
    [sym_nil] = ACTIONS(693),
    [sym_break] = ACTIONS(693),
    [sym_next] = ACTIONS(693),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [97] = {
    [sym_block] = STATE(329),
    [sym__expression] = STATE(329),
    [sym_assign_receiver_field] = STATE(329),
    [sym_assign_local] = STATE(329),
    [sym_assign_field] = STATE(329),
    [sym_replace_local] = STATE(329),
    [sym_replace_field] = STATE(329),
    [sym_compound_assign_local] = STATE(329),
    [sym_compound_assign_field] = STATE(329),
    [sym_compound_assign_receiver_field] = STATE(329),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(329),
    [sym_call_with_receiver] = STATE(329),
    [sym_ref] = STATE(329),
    [sym_mut] = STATE(329),
    [sym_recover] = STATE(329),
    [sym_grouped_expression] = STATE(329),
    [sym_tuple] = STATE(329),
    [sym_array] = STATE(329),
    [sym_return] = STATE(329),
    [sym_try] = STATE(329),
    [sym_throw] = STATE(329),
    [sym_if] = STATE(329),
    [sym_while] = STATE(329),
    [sym_loop] = STATE(329),
    [sym_for] = STATE(329),
    [sym_match] = STATE(329),
    [sym_closure] = STATE(329),
    [sym_define_variable] = STATE(329),
    [sym_and_or] = STATE(329),
    [sym_binary] = STATE(329),
    [sym_cast] = STATE(329),
    [sym_string] = STATE(329),
    [sym_true] = STATE(329),
    [sym_false] = STATE(329),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(695),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(697),
    [sym_nil] = ACTIONS(697),
    [sym_break] = ACTIONS(697),
    [sym_next] = ACTIONS(697),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [98] = {
    [sym_block] = STATE(330),
    [sym__expression] = STATE(330),
    [sym_assign_receiver_field] = STATE(330),
    [sym_assign_local] = STATE(330),
    [sym_assign_field] = STATE(330),
    [sym_replace_local] = STATE(330),
    [sym_replace_field] = STATE(330),
    [sym_compound_assign_local] = STATE(330),
    [sym_compound_assign_field] = STATE(330),
    [sym_compound_assign_receiver_field] = STATE(330),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(330),
    [sym_call_with_receiver] = STATE(330),
    [sym_ref] = STATE(330),
    [sym_mut] = STATE(330),
    [sym_recover] = STATE(330),
    [sym_grouped_expression] = STATE(330),
    [sym_tuple] = STATE(330),
    [sym_array] = STATE(330),
    [sym_return] = STATE(330),
    [sym_try] = STATE(330),
    [sym_throw] = STATE(330),
    [sym_if] = STATE(330),
    [sym_while] = STATE(330),
    [sym_loop] = STATE(330),
    [sym_for] = STATE(330),
    [sym_match] = STATE(330),
    [sym_closure] = STATE(330),
    [sym_define_variable] = STATE(330),
    [sym_and_or] = STATE(330),
    [sym_binary] = STATE(330),
    [sym_cast] = STATE(330),
    [sym_string] = STATE(330),
    [sym_true] = STATE(330),
    [sym_false] = STATE(330),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(699),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(701),
    [sym_nil] = ACTIONS(701),
    [sym_break] = ACTIONS(701),
    [sym_next] = ACTIONS(701),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [99] = {
    [sym_block] = STATE(349),
    [sym__expression] = STATE(349),
    [sym_assign_receiver_field] = STATE(349),
    [sym_assign_local] = STATE(349),
    [sym_assign_field] = STATE(349),
    [sym_replace_local] = STATE(349),
    [sym_replace_field] = STATE(349),
    [sym_compound_assign_local] = STATE(349),
    [sym_compound_assign_field] = STATE(349),
    [sym_compound_assign_receiver_field] = STATE(349),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(349),
    [sym_call_with_receiver] = STATE(349),
    [sym_ref] = STATE(349),
    [sym_mut] = STATE(349),
    [sym_recover] = STATE(349),
    [sym_grouped_expression] = STATE(349),
    [sym_tuple] = STATE(349),
    [sym_array] = STATE(349),
    [sym_return] = STATE(349),
    [sym_try] = STATE(349),
    [sym_throw] = STATE(349),
    [sym_if] = STATE(349),
    [sym_while] = STATE(349),
    [sym_loop] = STATE(349),
    [sym_for] = STATE(349),
    [sym_match] = STATE(349),
    [sym_closure] = STATE(349),
    [sym_define_variable] = STATE(349),
    [sym_and_or] = STATE(349),
    [sym_binary] = STATE(349),
    [sym_cast] = STATE(349),
    [sym_string] = STATE(349),
    [sym_true] = STATE(349),
    [sym_false] = STATE(349),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(703),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(705),
    [sym_nil] = ACTIONS(705),
    [sym_break] = ACTIONS(705),
    [sym_next] = ACTIONS(705),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [100] = {
    [sym_block] = STATE(350),
    [sym__expression] = STATE(350),
    [sym_assign_receiver_field] = STATE(350),
    [sym_assign_local] = STATE(350),
    [sym_assign_field] = STATE(350),
    [sym_replace_local] = STATE(350),
    [sym_replace_field] = STATE(350),
    [sym_compound_assign_local] = STATE(350),
    [sym_compound_assign_field] = STATE(350),
    [sym_compound_assign_receiver_field] = STATE(350),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(350),
    [sym_call_with_receiver] = STATE(350),
    [sym_ref] = STATE(350),
    [sym_mut] = STATE(350),
    [sym_recover] = STATE(350),
    [sym_grouped_expression] = STATE(350),
    [sym_tuple] = STATE(350),
    [sym_array] = STATE(350),
    [sym_return] = STATE(350),
    [sym_try] = STATE(350),
    [sym_throw] = STATE(350),
    [sym_if] = STATE(350),
    [sym_while] = STATE(350),
    [sym_loop] = STATE(350),
    [sym_for] = STATE(350),
    [sym_match] = STATE(350),
    [sym_closure] = STATE(350),
    [sym_define_variable] = STATE(350),
    [sym_and_or] = STATE(350),
    [sym_binary] = STATE(350),
    [sym_cast] = STATE(350),
    [sym_string] = STATE(350),
    [sym_true] = STATE(350),
    [sym_false] = STATE(350),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(707),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(709),
    [sym_nil] = ACTIONS(709),
    [sym_break] = ACTIONS(709),
    [sym_next] = ACTIONS(709),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [101] = {
    [sym_block] = STATE(351),
    [sym__expression] = STATE(351),
    [sym_assign_receiver_field] = STATE(351),
    [sym_assign_local] = STATE(351),
    [sym_assign_field] = STATE(351),
    [sym_replace_local] = STATE(351),
    [sym_replace_field] = STATE(351),
    [sym_compound_assign_local] = STATE(351),
    [sym_compound_assign_field] = STATE(351),
    [sym_compound_assign_receiver_field] = STATE(351),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(351),
    [sym_call_with_receiver] = STATE(351),
    [sym_ref] = STATE(351),
    [sym_mut] = STATE(351),
    [sym_recover] = STATE(351),
    [sym_grouped_expression] = STATE(351),
    [sym_tuple] = STATE(351),
    [sym_array] = STATE(351),
    [sym_return] = STATE(351),
    [sym_try] = STATE(351),
    [sym_throw] = STATE(351),
    [sym_if] = STATE(351),
    [sym_while] = STATE(351),
    [sym_loop] = STATE(351),
    [sym_for] = STATE(351),
    [sym_match] = STATE(351),
    [sym_closure] = STATE(351),
    [sym_define_variable] = STATE(351),
    [sym_and_or] = STATE(351),
    [sym_binary] = STATE(351),
    [sym_cast] = STATE(351),
    [sym_string] = STATE(351),
    [sym_true] = STATE(351),
    [sym_false] = STATE(351),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(711),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(713),
    [sym_nil] = ACTIONS(713),
    [sym_break] = ACTIONS(713),
    [sym_next] = ACTIONS(713),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [102] = {
    [sym_block] = STATE(352),
    [sym__expression] = STATE(352),
    [sym_assign_receiver_field] = STATE(352),
    [sym_assign_local] = STATE(352),
    [sym_assign_field] = STATE(352),
    [sym_replace_local] = STATE(352),
    [sym_replace_field] = STATE(352),
    [sym_compound_assign_local] = STATE(352),
    [sym_compound_assign_field] = STATE(352),
    [sym_compound_assign_receiver_field] = STATE(352),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(352),
    [sym_call_with_receiver] = STATE(352),
    [sym_ref] = STATE(352),
    [sym_mut] = STATE(352),
    [sym_recover] = STATE(352),
    [sym_grouped_expression] = STATE(352),
    [sym_tuple] = STATE(352),
    [sym_array] = STATE(352),
    [sym_return] = STATE(352),
    [sym_try] = STATE(352),
    [sym_throw] = STATE(352),
    [sym_if] = STATE(352),
    [sym_while] = STATE(352),
    [sym_loop] = STATE(352),
    [sym_for] = STATE(352),
    [sym_match] = STATE(352),
    [sym_closure] = STATE(352),
    [sym_define_variable] = STATE(352),
    [sym_and_or] = STATE(352),
    [sym_binary] = STATE(352),
    [sym_cast] = STATE(352),
    [sym_string] = STATE(352),
    [sym_true] = STATE(352),
    [sym_false] = STATE(352),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(715),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(717),
    [sym_nil] = ACTIONS(717),
    [sym_break] = ACTIONS(717),
    [sym_next] = ACTIONS(717),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [103] = {
    [sym_block] = STATE(342),
    [sym__expression] = STATE(342),
    [sym_assign_receiver_field] = STATE(342),
    [sym_assign_local] = STATE(342),
    [sym_assign_field] = STATE(342),
    [sym_replace_local] = STATE(342),
    [sym_replace_field] = STATE(342),
    [sym_compound_assign_local] = STATE(342),
    [sym_compound_assign_field] = STATE(342),
    [sym_compound_assign_receiver_field] = STATE(342),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(342),
    [sym_call_with_receiver] = STATE(342),
    [sym_ref] = STATE(342),
    [sym_mut] = STATE(342),
    [sym_recover] = STATE(342),
    [sym_grouped_expression] = STATE(342),
    [sym_tuple] = STATE(342),
    [sym_array] = STATE(342),
    [sym_return] = STATE(342),
    [sym_try] = STATE(342),
    [sym_throw] = STATE(342),
    [sym_if] = STATE(342),
    [sym_while] = STATE(342),
    [sym_loop] = STATE(342),
    [sym_for] = STATE(342),
    [sym_match] = STATE(342),
    [sym_closure] = STATE(342),
    [sym_define_variable] = STATE(342),
    [sym_and_or] = STATE(342),
    [sym_binary] = STATE(342),
    [sym_cast] = STATE(342),
    [sym_string] = STATE(342),
    [sym_true] = STATE(342),
    [sym_false] = STATE(342),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(719),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(721),
    [sym_nil] = ACTIONS(721),
    [sym_break] = ACTIONS(721),
    [sym_next] = ACTIONS(721),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [104] = {
    [sym_block] = STATE(323),
    [sym__expression] = STATE(323),
    [sym_assign_receiver_field] = STATE(323),
    [sym_assign_local] = STATE(323),
    [sym_assign_field] = STATE(323),
    [sym_replace_local] = STATE(323),
    [sym_replace_field] = STATE(323),
    [sym_compound_assign_local] = STATE(323),
    [sym_compound_assign_field] = STATE(323),
    [sym_compound_assign_receiver_field] = STATE(323),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(323),
    [sym_call_with_receiver] = STATE(323),
    [sym_ref] = STATE(323),
    [sym_mut] = STATE(323),
    [sym_recover] = STATE(323),
    [sym_grouped_expression] = STATE(323),
    [sym_tuple] = STATE(323),
    [sym_array] = STATE(323),
    [sym_return] = STATE(323),
    [sym_try] = STATE(323),
    [sym_throw] = STATE(323),
    [sym_if] = STATE(323),
    [sym_while] = STATE(323),
    [sym_loop] = STATE(323),
    [sym_for] = STATE(323),
    [sym_match] = STATE(323),
    [sym_closure] = STATE(323),
    [sym_define_variable] = STATE(323),
    [sym_and_or] = STATE(323),
    [sym_binary] = STATE(323),
    [sym_cast] = STATE(323),
    [sym_string] = STATE(323),
    [sym_true] = STATE(323),
    [sym_false] = STATE(323),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(723),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(725),
    [sym_nil] = ACTIONS(725),
    [sym_break] = ACTIONS(725),
    [sym_next] = ACTIONS(725),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [105] = {
    [sym_block] = STATE(293),
    [sym__expression] = STATE(293),
    [sym_assign_receiver_field] = STATE(293),
    [sym_assign_local] = STATE(293),
    [sym_assign_field] = STATE(293),
    [sym_replace_local] = STATE(293),
    [sym_replace_field] = STATE(293),
    [sym_compound_assign_local] = STATE(293),
    [sym_compound_assign_field] = STATE(293),
    [sym_compound_assign_receiver_field] = STATE(293),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(293),
    [sym_call_with_receiver] = STATE(293),
    [sym_ref] = STATE(293),
    [sym_mut] = STATE(293),
    [sym_recover] = STATE(293),
    [sym_grouped_expression] = STATE(293),
    [sym_tuple] = STATE(293),
    [sym_array] = STATE(293),
    [sym_return] = STATE(293),
    [sym_try] = STATE(293),
    [sym_throw] = STATE(293),
    [sym_if] = STATE(293),
    [sym_while] = STATE(293),
    [sym_loop] = STATE(293),
    [sym_for] = STATE(293),
    [sym_match] = STATE(293),
    [sym_closure] = STATE(293),
    [sym_define_variable] = STATE(293),
    [sym_and_or] = STATE(293),
    [sym_binary] = STATE(293),
    [sym_cast] = STATE(293),
    [sym_string] = STATE(293),
    [sym_true] = STATE(293),
    [sym_false] = STATE(293),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(727),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(729),
    [sym_nil] = ACTIONS(729),
    [sym_break] = ACTIONS(729),
    [sym_next] = ACTIONS(729),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [106] = {
    [sym_block] = STATE(295),
    [sym__expression] = STATE(295),
    [sym_assign_receiver_field] = STATE(295),
    [sym_assign_local] = STATE(295),
    [sym_assign_field] = STATE(295),
    [sym_replace_local] = STATE(295),
    [sym_replace_field] = STATE(295),
    [sym_compound_assign_local] = STATE(295),
    [sym_compound_assign_field] = STATE(295),
    [sym_compound_assign_receiver_field] = STATE(295),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(295),
    [sym_call_with_receiver] = STATE(295),
    [sym_ref] = STATE(295),
    [sym_mut] = STATE(295),
    [sym_recover] = STATE(295),
    [sym_grouped_expression] = STATE(295),
    [sym_tuple] = STATE(295),
    [sym_array] = STATE(295),
    [sym_return] = STATE(295),
    [sym_try] = STATE(295),
    [sym_throw] = STATE(295),
    [sym_if] = STATE(295),
    [sym_while] = STATE(295),
    [sym_loop] = STATE(295),
    [sym_for] = STATE(295),
    [sym_match] = STATE(295),
    [sym_closure] = STATE(295),
    [sym_define_variable] = STATE(295),
    [sym_and_or] = STATE(295),
    [sym_binary] = STATE(295),
    [sym_cast] = STATE(295),
    [sym_string] = STATE(295),
    [sym_true] = STATE(295),
    [sym_false] = STATE(295),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(731),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(733),
    [sym_nil] = ACTIONS(733),
    [sym_break] = ACTIONS(733),
    [sym_next] = ACTIONS(733),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [107] = {
    [sym_block] = STATE(285),
    [sym__expression] = STATE(285),
    [sym_assign_receiver_field] = STATE(285),
    [sym_assign_local] = STATE(285),
    [sym_assign_field] = STATE(285),
    [sym_replace_local] = STATE(285),
    [sym_replace_field] = STATE(285),
    [sym_compound_assign_local] = STATE(285),
    [sym_compound_assign_field] = STATE(285),
    [sym_compound_assign_receiver_field] = STATE(285),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(285),
    [sym_call_with_receiver] = STATE(285),
    [sym_ref] = STATE(285),
    [sym_mut] = STATE(285),
    [sym_recover] = STATE(285),
    [sym_grouped_expression] = STATE(285),
    [sym_tuple] = STATE(285),
    [sym_array] = STATE(285),
    [sym_return] = STATE(285),
    [sym_try] = STATE(285),
    [sym_throw] = STATE(285),
    [sym_if] = STATE(285),
    [sym_while] = STATE(285),
    [sym_loop] = STATE(285),
    [sym_for] = STATE(285),
    [sym_match] = STATE(285),
    [sym_closure] = STATE(285),
    [sym_define_variable] = STATE(285),
    [sym_and_or] = STATE(285),
    [sym_binary] = STATE(285),
    [sym_cast] = STATE(285),
    [sym_string] = STATE(285),
    [sym_true] = STATE(285),
    [sym_false] = STATE(285),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(735),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(737),
    [sym_nil] = ACTIONS(737),
    [sym_break] = ACTIONS(737),
    [sym_next] = ACTIONS(737),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [108] = {
    [sym_block] = STATE(299),
    [sym__expression] = STATE(299),
    [sym_assign_receiver_field] = STATE(299),
    [sym_assign_local] = STATE(299),
    [sym_assign_field] = STATE(299),
    [sym_replace_local] = STATE(299),
    [sym_replace_field] = STATE(299),
    [sym_compound_assign_local] = STATE(299),
    [sym_compound_assign_field] = STATE(299),
    [sym_compound_assign_receiver_field] = STATE(299),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(299),
    [sym_call_with_receiver] = STATE(299),
    [sym_ref] = STATE(299),
    [sym_mut] = STATE(299),
    [sym_recover] = STATE(299),
    [sym_grouped_expression] = STATE(299),
    [sym_tuple] = STATE(299),
    [sym_array] = STATE(299),
    [sym_return] = STATE(299),
    [sym_try] = STATE(299),
    [sym_throw] = STATE(299),
    [sym_if] = STATE(299),
    [sym_while] = STATE(299),
    [sym_loop] = STATE(299),
    [sym_for] = STATE(299),
    [sym_match] = STATE(299),
    [sym_closure] = STATE(299),
    [sym_define_variable] = STATE(299),
    [sym_and_or] = STATE(299),
    [sym_binary] = STATE(299),
    [sym_cast] = STATE(299),
    [sym_string] = STATE(299),
    [sym_true] = STATE(299),
    [sym_false] = STATE(299),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(739),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(741),
    [sym_nil] = ACTIONS(741),
    [sym_break] = ACTIONS(741),
    [sym_next] = ACTIONS(741),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [109] = {
    [sym_block] = STATE(303),
    [sym__expression] = STATE(303),
    [sym_assign_receiver_field] = STATE(303),
    [sym_assign_local] = STATE(303),
    [sym_assign_field] = STATE(303),
    [sym_replace_local] = STATE(303),
    [sym_replace_field] = STATE(303),
    [sym_compound_assign_local] = STATE(303),
    [sym_compound_assign_field] = STATE(303),
    [sym_compound_assign_receiver_field] = STATE(303),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(303),
    [sym_call_with_receiver] = STATE(303),
    [sym_ref] = STATE(303),
    [sym_mut] = STATE(303),
    [sym_recover] = STATE(303),
    [sym_grouped_expression] = STATE(303),
    [sym_tuple] = STATE(303),
    [sym_array] = STATE(303),
    [sym_return] = STATE(303),
    [sym_try] = STATE(303),
    [sym_throw] = STATE(303),
    [sym_if] = STATE(303),
    [sym_while] = STATE(303),
    [sym_loop] = STATE(303),
    [sym_for] = STATE(303),
    [sym_match] = STATE(303),
    [sym_closure] = STATE(303),
    [sym_define_variable] = STATE(303),
    [sym_and_or] = STATE(303),
    [sym_binary] = STATE(303),
    [sym_cast] = STATE(303),
    [sym_string] = STATE(303),
    [sym_true] = STATE(303),
    [sym_false] = STATE(303),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(743),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(745),
    [sym_nil] = ACTIONS(745),
    [sym_break] = ACTIONS(745),
    [sym_next] = ACTIONS(745),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [110] = {
    [sym_block] = STATE(304),
    [sym__expression] = STATE(304),
    [sym_assign_receiver_field] = STATE(304),
    [sym_assign_local] = STATE(304),
    [sym_assign_field] = STATE(304),
    [sym_replace_local] = STATE(304),
    [sym_replace_field] = STATE(304),
    [sym_compound_assign_local] = STATE(304),
    [sym_compound_assign_field] = STATE(304),
    [sym_compound_assign_receiver_field] = STATE(304),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(304),
    [sym_call_with_receiver] = STATE(304),
    [sym_ref] = STATE(304),
    [sym_mut] = STATE(304),
    [sym_recover] = STATE(304),
    [sym_grouped_expression] = STATE(304),
    [sym_tuple] = STATE(304),
    [sym_array] = STATE(304),
    [sym_return] = STATE(304),
    [sym_try] = STATE(304),
    [sym_throw] = STATE(304),
    [sym_if] = STATE(304),
    [sym_while] = STATE(304),
    [sym_loop] = STATE(304),
    [sym_for] = STATE(304),
    [sym_match] = STATE(304),
    [sym_closure] = STATE(304),
    [sym_define_variable] = STATE(304),
    [sym_and_or] = STATE(304),
    [sym_binary] = STATE(304),
    [sym_cast] = STATE(304),
    [sym_string] = STATE(304),
    [sym_true] = STATE(304),
    [sym_false] = STATE(304),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(747),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(749),
    [sym_nil] = ACTIONS(749),
    [sym_break] = ACTIONS(749),
    [sym_next] = ACTIONS(749),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [111] = {
    [sym_block] = STATE(309),
    [sym__expression] = STATE(309),
    [sym_assign_receiver_field] = STATE(309),
    [sym_assign_local] = STATE(309),
    [sym_assign_field] = STATE(309),
    [sym_replace_local] = STATE(309),
    [sym_replace_field] = STATE(309),
    [sym_compound_assign_local] = STATE(309),
    [sym_compound_assign_field] = STATE(309),
    [sym_compound_assign_receiver_field] = STATE(309),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(309),
    [sym_call_with_receiver] = STATE(309),
    [sym_ref] = STATE(309),
    [sym_mut] = STATE(309),
    [sym_recover] = STATE(309),
    [sym_grouped_expression] = STATE(309),
    [sym_tuple] = STATE(309),
    [sym_array] = STATE(309),
    [sym_return] = STATE(309),
    [sym_try] = STATE(309),
    [sym_throw] = STATE(309),
    [sym_if] = STATE(309),
    [sym_while] = STATE(309),
    [sym_loop] = STATE(309),
    [sym_for] = STATE(309),
    [sym_match] = STATE(309),
    [sym_closure] = STATE(309),
    [sym_define_variable] = STATE(309),
    [sym_and_or] = STATE(309),
    [sym_binary] = STATE(309),
    [sym_cast] = STATE(309),
    [sym_string] = STATE(309),
    [sym_true] = STATE(309),
    [sym_false] = STATE(309),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(751),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(753),
    [sym_nil] = ACTIONS(753),
    [sym_break] = ACTIONS(753),
    [sym_next] = ACTIONS(753),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [112] = {
    [sym_block] = STATE(315),
    [sym__expression] = STATE(315),
    [sym_assign_receiver_field] = STATE(315),
    [sym_assign_local] = STATE(315),
    [sym_assign_field] = STATE(315),
    [sym_replace_local] = STATE(315),
    [sym_replace_field] = STATE(315),
    [sym_compound_assign_local] = STATE(315),
    [sym_compound_assign_field] = STATE(315),
    [sym_compound_assign_receiver_field] = STATE(315),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(315),
    [sym_call_with_receiver] = STATE(315),
    [sym_ref] = STATE(315),
    [sym_mut] = STATE(315),
    [sym_recover] = STATE(315),
    [sym_grouped_expression] = STATE(315),
    [sym_tuple] = STATE(315),
    [sym_array] = STATE(315),
    [sym_return] = STATE(315),
    [sym_try] = STATE(315),
    [sym_throw] = STATE(315),
    [sym_if] = STATE(315),
    [sym_while] = STATE(315),
    [sym_loop] = STATE(315),
    [sym_for] = STATE(315),
    [sym_match] = STATE(315),
    [sym_closure] = STATE(315),
    [sym_define_variable] = STATE(315),
    [sym_and_or] = STATE(315),
    [sym_binary] = STATE(315),
    [sym_cast] = STATE(315),
    [sym_string] = STATE(315),
    [sym_true] = STATE(315),
    [sym_false] = STATE(315),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(755),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(757),
    [sym_nil] = ACTIONS(757),
    [sym_break] = ACTIONS(757),
    [sym_next] = ACTIONS(757),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [113] = {
    [sym_block] = STATE(642),
    [sym__expression] = STATE(642),
    [sym_assign_receiver_field] = STATE(642),
    [sym_assign_local] = STATE(642),
    [sym_assign_field] = STATE(642),
    [sym_replace_local] = STATE(642),
    [sym_replace_field] = STATE(642),
    [sym_compound_assign_local] = STATE(642),
    [sym_compound_assign_field] = STATE(642),
    [sym_compound_assign_receiver_field] = STATE(642),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(642),
    [sym_call_with_receiver] = STATE(642),
    [sym_ref] = STATE(642),
    [sym_mut] = STATE(642),
    [sym_recover] = STATE(642),
    [sym_grouped_expression] = STATE(642),
    [sym_tuple] = STATE(642),
    [sym_array] = STATE(642),
    [sym_return] = STATE(642),
    [sym_try] = STATE(642),
    [sym_throw] = STATE(642),
    [sym_if] = STATE(642),
    [sym_while] = STATE(642),
    [sym_loop] = STATE(642),
    [sym_for] = STATE(642),
    [sym_match] = STATE(642),
    [sym_closure] = STATE(642),
    [sym_define_variable] = STATE(642),
    [sym_and_or] = STATE(642),
    [sym_binary] = STATE(642),
    [sym_cast] = STATE(642),
    [sym_string] = STATE(642),
    [sym_true] = STATE(642),
    [sym_false] = STATE(642),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(759),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(761),
    [sym_nil] = ACTIONS(761),
    [sym_break] = ACTIONS(761),
    [sym_next] = ACTIONS(761),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [114] = {
    [sym_block] = STATE(576),
    [sym__expression] = STATE(576),
    [sym_assign_receiver_field] = STATE(576),
    [sym_assign_local] = STATE(576),
    [sym_assign_field] = STATE(576),
    [sym_replace_local] = STATE(576),
    [sym_replace_field] = STATE(576),
    [sym_compound_assign_local] = STATE(576),
    [sym_compound_assign_field] = STATE(576),
    [sym_compound_assign_receiver_field] = STATE(576),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(576),
    [sym_call_with_receiver] = STATE(576),
    [sym_ref] = STATE(576),
    [sym_mut] = STATE(576),
    [sym_recover] = STATE(576),
    [sym_grouped_expression] = STATE(576),
    [sym_tuple] = STATE(576),
    [sym_array] = STATE(576),
    [sym_return] = STATE(576),
    [sym_try] = STATE(576),
    [sym_throw] = STATE(576),
    [sym_if] = STATE(576),
    [sym_while] = STATE(576),
    [sym_loop] = STATE(576),
    [sym_for] = STATE(576),
    [sym_match] = STATE(576),
    [sym_closure] = STATE(576),
    [sym_define_variable] = STATE(576),
    [sym_and_or] = STATE(576),
    [sym_binary] = STATE(576),
    [sym_cast] = STATE(576),
    [sym_string] = STATE(576),
    [sym_true] = STATE(576),
    [sym_false] = STATE(576),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(763),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(765),
    [sym_nil] = ACTIONS(765),
    [sym_break] = ACTIONS(765),
    [sym_next] = ACTIONS(765),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [115] = {
    [sym_block] = STATE(577),
    [sym__expression] = STATE(577),
    [sym_assign_receiver_field] = STATE(577),
    [sym_assign_local] = STATE(577),
    [sym_assign_field] = STATE(577),
    [sym_replace_local] = STATE(577),
    [sym_replace_field] = STATE(577),
    [sym_compound_assign_local] = STATE(577),
    [sym_compound_assign_field] = STATE(577),
    [sym_compound_assign_receiver_field] = STATE(577),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(577),
    [sym_call_with_receiver] = STATE(577),
    [sym_ref] = STATE(577),
    [sym_mut] = STATE(577),
    [sym_recover] = STATE(577),
    [sym_grouped_expression] = STATE(577),
    [sym_tuple] = STATE(577),
    [sym_array] = STATE(577),
    [sym_return] = STATE(577),
    [sym_try] = STATE(577),
    [sym_throw] = STATE(577),
    [sym_if] = STATE(577),
    [sym_while] = STATE(577),
    [sym_loop] = STATE(577),
    [sym_for] = STATE(577),
    [sym_match] = STATE(577),
    [sym_closure] = STATE(577),
    [sym_define_variable] = STATE(577),
    [sym_and_or] = STATE(577),
    [sym_binary] = STATE(577),
    [sym_cast] = STATE(577),
    [sym_string] = STATE(577),
    [sym_true] = STATE(577),
    [sym_false] = STATE(577),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(767),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(769),
    [sym_nil] = ACTIONS(769),
    [sym_break] = ACTIONS(769),
    [sym_next] = ACTIONS(769),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [116] = {
    [sym_block] = STATE(230),
    [sym__expression] = STATE(230),
    [sym_assign_receiver_field] = STATE(230),
    [sym_assign_local] = STATE(230),
    [sym_assign_field] = STATE(230),
    [sym_replace_local] = STATE(230),
    [sym_replace_field] = STATE(230),
    [sym_compound_assign_local] = STATE(230),
    [sym_compound_assign_field] = STATE(230),
    [sym_compound_assign_receiver_field] = STATE(230),
    [sym__call_name] = STATE(1138),
    [sym_call] = STATE(230),
    [sym_call_with_receiver] = STATE(230),
    [sym_ref] = STATE(230),
    [sym_mut] = STATE(230),
    [sym_recover] = STATE(230),
    [sym_grouped_expression] = STATE(230),
    [sym_tuple] = STATE(230),
    [sym_array] = STATE(230),
    [sym_return] = STATE(230),
    [sym_try] = STATE(230),
    [sym_throw] = STATE(230),
    [sym_if] = STATE(230),
    [sym_while] = STATE(230),
    [sym_loop] = STATE(230),
    [sym_for] = STATE(230),
    [sym_match] = STATE(230),
    [sym_closure] = STATE(230),
    [sym_define_variable] = STATE(230),
    [sym_and_or] = STATE(230),
    [sym_binary] = STATE(230),
    [sym_cast] = STATE(230),
    [sym_string] = STATE(230),
    [sym_true] = STATE(230),
    [sym_false] = STATE(230),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(15),
    [anon_sym_fn] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_mut] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(75),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_ref] = ACTIONS(35),
    [anon_sym_recover] = ACTIONS(37),
    [anon_sym_return] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(41),
    [anon_sym_throw] = ACTIONS(43),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_loop] = ACTIONS(47),
    [anon_sym_match] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [sym_float] = ACTIONS(771),
    [sym_integer] = ACTIONS(57),
    [anon_sym_SQUOTE] = ACTIONS(59),
    [sym_self] = ACTIONS(773),
    [sym_nil] = ACTIONS(773),
    [sym_break] = ACTIONS(773),
    [sym_next] = ACTIONS(773),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(63),
    [sym_field] = ACTIONS(65),
    [sym_constant] = ACTIONS(67),
  },
  [117] = {
    [sym_block] = STATE(222),
    [sym__expression] = STATE(222),
    [sym_assign_receiver_field] = STATE(222),
    [sym_assign_local] = STATE(222),
    [sym_assign_field] = STATE(222),
    [sym_replace_local] = STATE(222),
    [sym_replace_field] = STATE(222),
    [sym_compound_assign_local] = STATE(222),
    [sym_compound_assign_field] = STATE(222),
    [sym_compound_assign_receiver_field] = STATE(222),
    [sym__call_name] = STATE(1138),
    [sym_call] = STATE(222),
    [sym_call_with_receiver] = STATE(222),
    [sym_ref] = STATE(222),
    [sym_mut] = STATE(222),
    [sym_recover] = STATE(222),
    [sym_grouped_expression] = STATE(222),
    [sym_tuple] = STATE(222),
    [sym_array] = STATE(222),
    [sym_return] = STATE(222),
    [sym_try] = STATE(222),
    [sym_throw] = STATE(222),
    [sym_if] = STATE(222),
    [sym_while] = STATE(222),
    [sym_loop] = STATE(222),
    [sym_for] = STATE(222),
    [sym_match] = STATE(222),
    [sym_closure] = STATE(222),
    [sym_define_variable] = STATE(222),
    [sym_and_or] = STATE(222),
    [sym_binary] = STATE(222),
    [sym_cast] = STATE(222),
    [sym_string] = STATE(222),
    [sym_true] = STATE(222),
    [sym_false] = STATE(222),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(15),
    [anon_sym_fn] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_mut] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(75),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_ref] = ACTIONS(35),
    [anon_sym_recover] = ACTIONS(37),
    [anon_sym_return] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(41),
    [anon_sym_throw] = ACTIONS(43),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_loop] = ACTIONS(47),
    [anon_sym_match] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [sym_float] = ACTIONS(775),
    [sym_integer] = ACTIONS(57),
    [anon_sym_SQUOTE] = ACTIONS(59),
    [sym_self] = ACTIONS(777),
    [sym_nil] = ACTIONS(777),
    [sym_break] = ACTIONS(777),
    [sym_next] = ACTIONS(777),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(63),
    [sym_field] = ACTIONS(65),
    [sym_constant] = ACTIONS(67),
  },
  [118] = {
    [sym_block] = STATE(223),
    [sym__expression] = STATE(223),
    [sym_assign_receiver_field] = STATE(223),
    [sym_assign_local] = STATE(223),
    [sym_assign_field] = STATE(223),
    [sym_replace_local] = STATE(223),
    [sym_replace_field] = STATE(223),
    [sym_compound_assign_local] = STATE(223),
    [sym_compound_assign_field] = STATE(223),
    [sym_compound_assign_receiver_field] = STATE(223),
    [sym__call_name] = STATE(1138),
    [sym_call] = STATE(223),
    [sym_call_with_receiver] = STATE(223),
    [sym_ref] = STATE(223),
    [sym_mut] = STATE(223),
    [sym_recover] = STATE(223),
    [sym_grouped_expression] = STATE(223),
    [sym_tuple] = STATE(223),
    [sym_array] = STATE(223),
    [sym_return] = STATE(223),
    [sym_try] = STATE(223),
    [sym_throw] = STATE(223),
    [sym_if] = STATE(223),
    [sym_while] = STATE(223),
    [sym_loop] = STATE(223),
    [sym_for] = STATE(223),
    [sym_match] = STATE(223),
    [sym_closure] = STATE(223),
    [sym_define_variable] = STATE(223),
    [sym_and_or] = STATE(223),
    [sym_binary] = STATE(223),
    [sym_cast] = STATE(223),
    [sym_string] = STATE(223),
    [sym_true] = STATE(223),
    [sym_false] = STATE(223),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(15),
    [anon_sym_fn] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_mut] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(75),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_ref] = ACTIONS(35),
    [anon_sym_recover] = ACTIONS(37),
    [anon_sym_return] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(41),
    [anon_sym_throw] = ACTIONS(43),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_loop] = ACTIONS(47),
    [anon_sym_match] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [sym_float] = ACTIONS(779),
    [sym_integer] = ACTIONS(57),
    [anon_sym_SQUOTE] = ACTIONS(59),
    [sym_self] = ACTIONS(781),
    [sym_nil] = ACTIONS(781),
    [sym_break] = ACTIONS(781),
    [sym_next] = ACTIONS(781),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(63),
    [sym_field] = ACTIONS(65),
    [sym_constant] = ACTIONS(67),
  },
  [119] = {
    [sym_block] = STATE(224),
    [sym__expression] = STATE(224),
    [sym_assign_receiver_field] = STATE(224),
    [sym_assign_local] = STATE(224),
    [sym_assign_field] = STATE(224),
    [sym_replace_local] = STATE(224),
    [sym_replace_field] = STATE(224),
    [sym_compound_assign_local] = STATE(224),
    [sym_compound_assign_field] = STATE(224),
    [sym_compound_assign_receiver_field] = STATE(224),
    [sym__call_name] = STATE(1138),
    [sym_call] = STATE(224),
    [sym_call_with_receiver] = STATE(224),
    [sym_ref] = STATE(224),
    [sym_mut] = STATE(224),
    [sym_recover] = STATE(224),
    [sym_grouped_expression] = STATE(224),
    [sym_tuple] = STATE(224),
    [sym_array] = STATE(224),
    [sym_return] = STATE(224),
    [sym_try] = STATE(224),
    [sym_throw] = STATE(224),
    [sym_if] = STATE(224),
    [sym_while] = STATE(224),
    [sym_loop] = STATE(224),
    [sym_for] = STATE(224),
    [sym_match] = STATE(224),
    [sym_closure] = STATE(224),
    [sym_define_variable] = STATE(224),
    [sym_and_or] = STATE(224),
    [sym_binary] = STATE(224),
    [sym_cast] = STATE(224),
    [sym_string] = STATE(224),
    [sym_true] = STATE(224),
    [sym_false] = STATE(224),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(15),
    [anon_sym_fn] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_mut] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(75),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_ref] = ACTIONS(35),
    [anon_sym_recover] = ACTIONS(37),
    [anon_sym_return] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(41),
    [anon_sym_throw] = ACTIONS(43),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_loop] = ACTIONS(47),
    [anon_sym_match] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [sym_float] = ACTIONS(783),
    [sym_integer] = ACTIONS(57),
    [anon_sym_SQUOTE] = ACTIONS(59),
    [sym_self] = ACTIONS(785),
    [sym_nil] = ACTIONS(785),
    [sym_break] = ACTIONS(785),
    [sym_next] = ACTIONS(785),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(63),
    [sym_field] = ACTIONS(65),
    [sym_constant] = ACTIONS(67),
  },
  [120] = {
    [sym_block] = STATE(257),
    [sym__expression] = STATE(257),
    [sym_assign_receiver_field] = STATE(257),
    [sym_assign_local] = STATE(257),
    [sym_assign_field] = STATE(257),
    [sym_replace_local] = STATE(257),
    [sym_replace_field] = STATE(257),
    [sym_compound_assign_local] = STATE(257),
    [sym_compound_assign_field] = STATE(257),
    [sym_compound_assign_receiver_field] = STATE(257),
    [sym__call_name] = STATE(1138),
    [sym_call] = STATE(257),
    [sym_call_with_receiver] = STATE(257),
    [sym_ref] = STATE(257),
    [sym_mut] = STATE(257),
    [sym_recover] = STATE(257),
    [sym_grouped_expression] = STATE(257),
    [sym_tuple] = STATE(257),
    [sym_array] = STATE(257),
    [sym_return] = STATE(257),
    [sym_try] = STATE(257),
    [sym_throw] = STATE(257),
    [sym_if] = STATE(257),
    [sym_while] = STATE(257),
    [sym_loop] = STATE(257),
    [sym_for] = STATE(257),
    [sym_match] = STATE(257),
    [sym_closure] = STATE(257),
    [sym_define_variable] = STATE(257),
    [sym_and_or] = STATE(257),
    [sym_binary] = STATE(257),
    [sym_cast] = STATE(257),
    [sym_string] = STATE(257),
    [sym_true] = STATE(257),
    [sym_false] = STATE(257),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(15),
    [anon_sym_fn] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_mut] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(75),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_ref] = ACTIONS(35),
    [anon_sym_recover] = ACTIONS(37),
    [anon_sym_return] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(41),
    [anon_sym_throw] = ACTIONS(43),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_loop] = ACTIONS(47),
    [anon_sym_match] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [sym_float] = ACTIONS(787),
    [sym_integer] = ACTIONS(57),
    [anon_sym_SQUOTE] = ACTIONS(59),
    [sym_self] = ACTIONS(789),
    [sym_nil] = ACTIONS(789),
    [sym_break] = ACTIONS(789),
    [sym_next] = ACTIONS(789),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(63),
    [sym_field] = ACTIONS(65),
    [sym_constant] = ACTIONS(67),
  },
  [121] = {
    [sym_block] = STATE(259),
    [sym__expression] = STATE(259),
    [sym_assign_receiver_field] = STATE(259),
    [sym_assign_local] = STATE(259),
    [sym_assign_field] = STATE(259),
    [sym_replace_local] = STATE(259),
    [sym_replace_field] = STATE(259),
    [sym_compound_assign_local] = STATE(259),
    [sym_compound_assign_field] = STATE(259),
    [sym_compound_assign_receiver_field] = STATE(259),
    [sym__call_name] = STATE(1138),
    [sym_call] = STATE(259),
    [sym_call_with_receiver] = STATE(259),
    [sym_ref] = STATE(259),
    [sym_mut] = STATE(259),
    [sym_recover] = STATE(259),
    [sym_grouped_expression] = STATE(259),
    [sym_tuple] = STATE(259),
    [sym_array] = STATE(259),
    [sym_return] = STATE(259),
    [sym_try] = STATE(259),
    [sym_throw] = STATE(259),
    [sym_if] = STATE(259),
    [sym_while] = STATE(259),
    [sym_loop] = STATE(259),
    [sym_for] = STATE(259),
    [sym_match] = STATE(259),
    [sym_closure] = STATE(259),
    [sym_define_variable] = STATE(259),
    [sym_and_or] = STATE(259),
    [sym_binary] = STATE(259),
    [sym_cast] = STATE(259),
    [sym_string] = STATE(259),
    [sym_true] = STATE(259),
    [sym_false] = STATE(259),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(15),
    [anon_sym_fn] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_mut] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(75),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_ref] = ACTIONS(35),
    [anon_sym_recover] = ACTIONS(37),
    [anon_sym_return] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(41),
    [anon_sym_throw] = ACTIONS(43),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_loop] = ACTIONS(47),
    [anon_sym_match] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [sym_float] = ACTIONS(791),
    [sym_integer] = ACTIONS(57),
    [anon_sym_SQUOTE] = ACTIONS(59),
    [sym_self] = ACTIONS(793),
    [sym_nil] = ACTIONS(793),
    [sym_break] = ACTIONS(793),
    [sym_next] = ACTIONS(793),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(63),
    [sym_field] = ACTIONS(65),
    [sym_constant] = ACTIONS(67),
  },
  [122] = {
    [sym_block] = STATE(193),
    [sym__expression] = STATE(193),
    [sym_assign_receiver_field] = STATE(193),
    [sym_assign_local] = STATE(193),
    [sym_assign_field] = STATE(193),
    [sym_replace_local] = STATE(193),
    [sym_replace_field] = STATE(193),
    [sym_compound_assign_local] = STATE(193),
    [sym_compound_assign_field] = STATE(193),
    [sym_compound_assign_receiver_field] = STATE(193),
    [sym__call_name] = STATE(1138),
    [sym_call] = STATE(193),
    [sym_call_with_receiver] = STATE(193),
    [sym_ref] = STATE(193),
    [sym_mut] = STATE(193),
    [sym_recover] = STATE(193),
    [sym_grouped_expression] = STATE(193),
    [sym_tuple] = STATE(193),
    [sym_array] = STATE(193),
    [sym_return] = STATE(193),
    [sym_try] = STATE(193),
    [sym_throw] = STATE(193),
    [sym_if] = STATE(193),
    [sym_while] = STATE(193),
    [sym_loop] = STATE(193),
    [sym_for] = STATE(193),
    [sym_match] = STATE(193),
    [sym_closure] = STATE(193),
    [sym_define_variable] = STATE(193),
    [sym_and_or] = STATE(193),
    [sym_binary] = STATE(193),
    [sym_cast] = STATE(193),
    [sym_string] = STATE(193),
    [sym_true] = STATE(193),
    [sym_false] = STATE(193),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(15),
    [anon_sym_fn] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_mut] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(75),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_ref] = ACTIONS(35),
    [anon_sym_recover] = ACTIONS(37),
    [anon_sym_return] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(41),
    [anon_sym_throw] = ACTIONS(43),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_loop] = ACTIONS(47),
    [anon_sym_match] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [sym_float] = ACTIONS(795),
    [sym_integer] = ACTIONS(57),
    [anon_sym_SQUOTE] = ACTIONS(59),
    [sym_self] = ACTIONS(797),
    [sym_nil] = ACTIONS(797),
    [sym_break] = ACTIONS(797),
    [sym_next] = ACTIONS(797),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(63),
    [sym_field] = ACTIONS(65),
    [sym_constant] = ACTIONS(67),
  },
  [123] = {
    [sym_block] = STATE(198),
    [sym__expression] = STATE(198),
    [sym_assign_receiver_field] = STATE(198),
    [sym_assign_local] = STATE(198),
    [sym_assign_field] = STATE(198),
    [sym_replace_local] = STATE(198),
    [sym_replace_field] = STATE(198),
    [sym_compound_assign_local] = STATE(198),
    [sym_compound_assign_field] = STATE(198),
    [sym_compound_assign_receiver_field] = STATE(198),
    [sym__call_name] = STATE(1138),
    [sym_call] = STATE(198),
    [sym_call_with_receiver] = STATE(198),
    [sym_ref] = STATE(198),
    [sym_mut] = STATE(198),
    [sym_recover] = STATE(198),
    [sym_grouped_expression] = STATE(198),
    [sym_tuple] = STATE(198),
    [sym_array] = STATE(198),
    [sym_return] = STATE(198),
    [sym_try] = STATE(198),
    [sym_throw] = STATE(198),
    [sym_if] = STATE(198),
    [sym_while] = STATE(198),
    [sym_loop] = STATE(198),
    [sym_for] = STATE(198),
    [sym_match] = STATE(198),
    [sym_closure] = STATE(198),
    [sym_define_variable] = STATE(198),
    [sym_and_or] = STATE(198),
    [sym_binary] = STATE(198),
    [sym_cast] = STATE(198),
    [sym_string] = STATE(198),
    [sym_true] = STATE(198),
    [sym_false] = STATE(198),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(15),
    [anon_sym_fn] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_mut] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(75),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_ref] = ACTIONS(35),
    [anon_sym_recover] = ACTIONS(37),
    [anon_sym_return] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(41),
    [anon_sym_throw] = ACTIONS(43),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_loop] = ACTIONS(47),
    [anon_sym_match] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [sym_float] = ACTIONS(799),
    [sym_integer] = ACTIONS(57),
    [anon_sym_SQUOTE] = ACTIONS(59),
    [sym_self] = ACTIONS(801),
    [sym_nil] = ACTIONS(801),
    [sym_break] = ACTIONS(801),
    [sym_next] = ACTIONS(801),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(63),
    [sym_field] = ACTIONS(65),
    [sym_constant] = ACTIONS(67),
  },
  [124] = {
    [sym_block] = STATE(614),
    [sym__expression] = STATE(614),
    [sym_assign_receiver_field] = STATE(614),
    [sym_assign_local] = STATE(614),
    [sym_assign_field] = STATE(614),
    [sym_replace_local] = STATE(614),
    [sym_replace_field] = STATE(614),
    [sym_compound_assign_local] = STATE(614),
    [sym_compound_assign_field] = STATE(614),
    [sym_compound_assign_receiver_field] = STATE(614),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(614),
    [sym_call_with_receiver] = STATE(614),
    [sym_ref] = STATE(614),
    [sym_mut] = STATE(614),
    [sym_recover] = STATE(614),
    [sym_grouped_expression] = STATE(614),
    [sym_tuple] = STATE(614),
    [sym_array] = STATE(614),
    [sym_return] = STATE(614),
    [sym_try] = STATE(614),
    [sym_throw] = STATE(614),
    [sym_if] = STATE(614),
    [sym_while] = STATE(614),
    [sym_loop] = STATE(614),
    [sym_for] = STATE(614),
    [sym_match] = STATE(614),
    [sym_closure] = STATE(614),
    [sym_define_variable] = STATE(614),
    [sym_and_or] = STATE(614),
    [sym_binary] = STATE(614),
    [sym_cast] = STATE(614),
    [sym_string] = STATE(614),
    [sym_true] = STATE(614),
    [sym_false] = STATE(614),
    [sym_identifier] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(137),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(139),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(141),
    [anon_sym_recover] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_try] = ACTIONS(147),
    [anon_sym_throw] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(803),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(805),
    [sym_nil] = ACTIONS(805),
    [sym_break] = ACTIONS(805),
    [sym_next] = ACTIONS(805),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(155),
    [sym_constant] = ACTIONS(133),
  },
  [125] = {
    [sym_block] = STATE(615),
    [sym__expression] = STATE(615),
    [sym_assign_receiver_field] = STATE(615),
    [sym_assign_local] = STATE(615),
    [sym_assign_field] = STATE(615),
    [sym_replace_local] = STATE(615),
    [sym_replace_field] = STATE(615),
    [sym_compound_assign_local] = STATE(615),
    [sym_compound_assign_field] = STATE(615),
    [sym_compound_assign_receiver_field] = STATE(615),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(615),
    [sym_call_with_receiver] = STATE(615),
    [sym_ref] = STATE(615),
    [sym_mut] = STATE(615),
    [sym_recover] = STATE(615),
    [sym_grouped_expression] = STATE(615),
    [sym_tuple] = STATE(615),
    [sym_array] = STATE(615),
    [sym_return] = STATE(615),
    [sym_try] = STATE(615),
    [sym_throw] = STATE(615),
    [sym_if] = STATE(615),
    [sym_while] = STATE(615),
    [sym_loop] = STATE(615),
    [sym_for] = STATE(615),
    [sym_match] = STATE(615),
    [sym_closure] = STATE(615),
    [sym_define_variable] = STATE(615),
    [sym_and_or] = STATE(615),
    [sym_binary] = STATE(615),
    [sym_cast] = STATE(615),
    [sym_string] = STATE(615),
    [sym_true] = STATE(615),
    [sym_false] = STATE(615),
    [sym_identifier] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(137),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(139),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(141),
    [anon_sym_recover] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_try] = ACTIONS(147),
    [anon_sym_throw] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(807),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(809),
    [sym_nil] = ACTIONS(809),
    [sym_break] = ACTIONS(809),
    [sym_next] = ACTIONS(809),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(155),
    [sym_constant] = ACTIONS(133),
  },
  [126] = {
    [sym_block] = STATE(616),
    [sym__expression] = STATE(616),
    [sym_assign_receiver_field] = STATE(616),
    [sym_assign_local] = STATE(616),
    [sym_assign_field] = STATE(616),
    [sym_replace_local] = STATE(616),
    [sym_replace_field] = STATE(616),
    [sym_compound_assign_local] = STATE(616),
    [sym_compound_assign_field] = STATE(616),
    [sym_compound_assign_receiver_field] = STATE(616),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(616),
    [sym_call_with_receiver] = STATE(616),
    [sym_ref] = STATE(616),
    [sym_mut] = STATE(616),
    [sym_recover] = STATE(616),
    [sym_grouped_expression] = STATE(616),
    [sym_tuple] = STATE(616),
    [sym_array] = STATE(616),
    [sym_return] = STATE(616),
    [sym_try] = STATE(616),
    [sym_throw] = STATE(616),
    [sym_if] = STATE(616),
    [sym_while] = STATE(616),
    [sym_loop] = STATE(616),
    [sym_for] = STATE(616),
    [sym_match] = STATE(616),
    [sym_closure] = STATE(616),
    [sym_define_variable] = STATE(616),
    [sym_and_or] = STATE(616),
    [sym_binary] = STATE(616),
    [sym_cast] = STATE(616),
    [sym_string] = STATE(616),
    [sym_true] = STATE(616),
    [sym_false] = STATE(616),
    [sym_identifier] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(137),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(139),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(141),
    [anon_sym_recover] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_try] = ACTIONS(147),
    [anon_sym_throw] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(811),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(813),
    [sym_nil] = ACTIONS(813),
    [sym_break] = ACTIONS(813),
    [sym_next] = ACTIONS(813),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(155),
    [sym_constant] = ACTIONS(133),
  },
  [127] = {
    [sym_block] = STATE(593),
    [sym__expression] = STATE(593),
    [sym_assign_receiver_field] = STATE(593),
    [sym_assign_local] = STATE(593),
    [sym_assign_field] = STATE(593),
    [sym_replace_local] = STATE(593),
    [sym_replace_field] = STATE(593),
    [sym_compound_assign_local] = STATE(593),
    [sym_compound_assign_field] = STATE(593),
    [sym_compound_assign_receiver_field] = STATE(593),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(593),
    [sym_call_with_receiver] = STATE(593),
    [sym_ref] = STATE(593),
    [sym_mut] = STATE(593),
    [sym_recover] = STATE(593),
    [sym_grouped_expression] = STATE(593),
    [sym_tuple] = STATE(593),
    [sym_array] = STATE(593),
    [sym_return] = STATE(593),
    [sym_try] = STATE(593),
    [sym_throw] = STATE(593),
    [sym_if] = STATE(593),
    [sym_while] = STATE(593),
    [sym_loop] = STATE(593),
    [sym_for] = STATE(593),
    [sym_match] = STATE(593),
    [sym_closure] = STATE(593),
    [sym_define_variable] = STATE(593),
    [sym_and_or] = STATE(593),
    [sym_binary] = STATE(593),
    [sym_cast] = STATE(593),
    [sym_string] = STATE(593),
    [sym_true] = STATE(593),
    [sym_false] = STATE(593),
    [sym_identifier] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(137),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(139),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(141),
    [anon_sym_recover] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_try] = ACTIONS(147),
    [anon_sym_throw] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(815),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(817),
    [sym_nil] = ACTIONS(817),
    [sym_break] = ACTIONS(817),
    [sym_next] = ACTIONS(817),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(155),
    [sym_constant] = ACTIONS(133),
  },
  [128] = {
    [sym_block] = STATE(594),
    [sym__expression] = STATE(594),
    [sym_assign_receiver_field] = STATE(594),
    [sym_assign_local] = STATE(594),
    [sym_assign_field] = STATE(594),
    [sym_replace_local] = STATE(594),
    [sym_replace_field] = STATE(594),
    [sym_compound_assign_local] = STATE(594),
    [sym_compound_assign_field] = STATE(594),
    [sym_compound_assign_receiver_field] = STATE(594),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(594),
    [sym_call_with_receiver] = STATE(594),
    [sym_ref] = STATE(594),
    [sym_mut] = STATE(594),
    [sym_recover] = STATE(594),
    [sym_grouped_expression] = STATE(594),
    [sym_tuple] = STATE(594),
    [sym_array] = STATE(594),
    [sym_return] = STATE(594),
    [sym_try] = STATE(594),
    [sym_throw] = STATE(594),
    [sym_if] = STATE(594),
    [sym_while] = STATE(594),
    [sym_loop] = STATE(594),
    [sym_for] = STATE(594),
    [sym_match] = STATE(594),
    [sym_closure] = STATE(594),
    [sym_define_variable] = STATE(594),
    [sym_and_or] = STATE(594),
    [sym_binary] = STATE(594),
    [sym_cast] = STATE(594),
    [sym_string] = STATE(594),
    [sym_true] = STATE(594),
    [sym_false] = STATE(594),
    [sym_identifier] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(137),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(139),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(141),
    [anon_sym_recover] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_try] = ACTIONS(147),
    [anon_sym_throw] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(819),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(821),
    [sym_nil] = ACTIONS(821),
    [sym_break] = ACTIONS(821),
    [sym_next] = ACTIONS(821),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(155),
    [sym_constant] = ACTIONS(133),
  },
  [129] = {
    [sym_block] = STATE(595),
    [sym__expression] = STATE(595),
    [sym_assign_receiver_field] = STATE(595),
    [sym_assign_local] = STATE(595),
    [sym_assign_field] = STATE(595),
    [sym_replace_local] = STATE(595),
    [sym_replace_field] = STATE(595),
    [sym_compound_assign_local] = STATE(595),
    [sym_compound_assign_field] = STATE(595),
    [sym_compound_assign_receiver_field] = STATE(595),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(595),
    [sym_call_with_receiver] = STATE(595),
    [sym_ref] = STATE(595),
    [sym_mut] = STATE(595),
    [sym_recover] = STATE(595),
    [sym_grouped_expression] = STATE(595),
    [sym_tuple] = STATE(595),
    [sym_array] = STATE(595),
    [sym_return] = STATE(595),
    [sym_try] = STATE(595),
    [sym_throw] = STATE(595),
    [sym_if] = STATE(595),
    [sym_while] = STATE(595),
    [sym_loop] = STATE(595),
    [sym_for] = STATE(595),
    [sym_match] = STATE(595),
    [sym_closure] = STATE(595),
    [sym_define_variable] = STATE(595),
    [sym_and_or] = STATE(595),
    [sym_binary] = STATE(595),
    [sym_cast] = STATE(595),
    [sym_string] = STATE(595),
    [sym_true] = STATE(595),
    [sym_false] = STATE(595),
    [sym_identifier] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(137),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(139),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(141),
    [anon_sym_recover] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_try] = ACTIONS(147),
    [anon_sym_throw] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(823),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(825),
    [sym_nil] = ACTIONS(825),
    [sym_break] = ACTIONS(825),
    [sym_next] = ACTIONS(825),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(155),
    [sym_constant] = ACTIONS(133),
  },
  [130] = {
    [sym_block] = STATE(596),
    [sym__expression] = STATE(596),
    [sym_assign_receiver_field] = STATE(596),
    [sym_assign_local] = STATE(596),
    [sym_assign_field] = STATE(596),
    [sym_replace_local] = STATE(596),
    [sym_replace_field] = STATE(596),
    [sym_compound_assign_local] = STATE(596),
    [sym_compound_assign_field] = STATE(596),
    [sym_compound_assign_receiver_field] = STATE(596),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(596),
    [sym_call_with_receiver] = STATE(596),
    [sym_ref] = STATE(596),
    [sym_mut] = STATE(596),
    [sym_recover] = STATE(596),
    [sym_grouped_expression] = STATE(596),
    [sym_tuple] = STATE(596),
    [sym_array] = STATE(596),
    [sym_return] = STATE(596),
    [sym_try] = STATE(596),
    [sym_throw] = STATE(596),
    [sym_if] = STATE(596),
    [sym_while] = STATE(596),
    [sym_loop] = STATE(596),
    [sym_for] = STATE(596),
    [sym_match] = STATE(596),
    [sym_closure] = STATE(596),
    [sym_define_variable] = STATE(596),
    [sym_and_or] = STATE(596),
    [sym_binary] = STATE(596),
    [sym_cast] = STATE(596),
    [sym_string] = STATE(596),
    [sym_true] = STATE(596),
    [sym_false] = STATE(596),
    [sym_identifier] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(137),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(139),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(141),
    [anon_sym_recover] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_try] = ACTIONS(147),
    [anon_sym_throw] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(827),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(829),
    [sym_nil] = ACTIONS(829),
    [sym_break] = ACTIONS(829),
    [sym_next] = ACTIONS(829),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(155),
    [sym_constant] = ACTIONS(133),
  },
  [131] = {
    [sym_block] = STATE(597),
    [sym__expression] = STATE(597),
    [sym_assign_receiver_field] = STATE(597),
    [sym_assign_local] = STATE(597),
    [sym_assign_field] = STATE(597),
    [sym_replace_local] = STATE(597),
    [sym_replace_field] = STATE(597),
    [sym_compound_assign_local] = STATE(597),
    [sym_compound_assign_field] = STATE(597),
    [sym_compound_assign_receiver_field] = STATE(597),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(597),
    [sym_call_with_receiver] = STATE(597),
    [sym_ref] = STATE(597),
    [sym_mut] = STATE(597),
    [sym_recover] = STATE(597),
    [sym_grouped_expression] = STATE(597),
    [sym_tuple] = STATE(597),
    [sym_array] = STATE(597),
    [sym_return] = STATE(597),
    [sym_try] = STATE(597),
    [sym_throw] = STATE(597),
    [sym_if] = STATE(597),
    [sym_while] = STATE(597),
    [sym_loop] = STATE(597),
    [sym_for] = STATE(597),
    [sym_match] = STATE(597),
    [sym_closure] = STATE(597),
    [sym_define_variable] = STATE(597),
    [sym_and_or] = STATE(597),
    [sym_binary] = STATE(597),
    [sym_cast] = STATE(597),
    [sym_string] = STATE(597),
    [sym_true] = STATE(597),
    [sym_false] = STATE(597),
    [sym_identifier] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(137),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(139),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(141),
    [anon_sym_recover] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_try] = ACTIONS(147),
    [anon_sym_throw] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(831),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(833),
    [sym_nil] = ACTIONS(833),
    [sym_break] = ACTIONS(833),
    [sym_next] = ACTIONS(833),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(155),
    [sym_constant] = ACTIONS(133),
  },
  [132] = {
    [sym_block] = STATE(598),
    [sym__expression] = STATE(598),
    [sym_assign_receiver_field] = STATE(598),
    [sym_assign_local] = STATE(598),
    [sym_assign_field] = STATE(598),
    [sym_replace_local] = STATE(598),
    [sym_replace_field] = STATE(598),
    [sym_compound_assign_local] = STATE(598),
    [sym_compound_assign_field] = STATE(598),
    [sym_compound_assign_receiver_field] = STATE(598),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(598),
    [sym_call_with_receiver] = STATE(598),
    [sym_ref] = STATE(598),
    [sym_mut] = STATE(598),
    [sym_recover] = STATE(598),
    [sym_grouped_expression] = STATE(598),
    [sym_tuple] = STATE(598),
    [sym_array] = STATE(598),
    [sym_return] = STATE(598),
    [sym_try] = STATE(598),
    [sym_throw] = STATE(598),
    [sym_if] = STATE(598),
    [sym_while] = STATE(598),
    [sym_loop] = STATE(598),
    [sym_for] = STATE(598),
    [sym_match] = STATE(598),
    [sym_closure] = STATE(598),
    [sym_define_variable] = STATE(598),
    [sym_and_or] = STATE(598),
    [sym_binary] = STATE(598),
    [sym_cast] = STATE(598),
    [sym_string] = STATE(598),
    [sym_true] = STATE(598),
    [sym_false] = STATE(598),
    [sym_identifier] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(137),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(139),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(141),
    [anon_sym_recover] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_try] = ACTIONS(147),
    [anon_sym_throw] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(835),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(837),
    [sym_nil] = ACTIONS(837),
    [sym_break] = ACTIONS(837),
    [sym_next] = ACTIONS(837),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(155),
    [sym_constant] = ACTIONS(133),
  },
  [133] = {
    [sym_block] = STATE(617),
    [sym__expression] = STATE(617),
    [sym_assign_receiver_field] = STATE(617),
    [sym_assign_local] = STATE(617),
    [sym_assign_field] = STATE(617),
    [sym_replace_local] = STATE(617),
    [sym_replace_field] = STATE(617),
    [sym_compound_assign_local] = STATE(617),
    [sym_compound_assign_field] = STATE(617),
    [sym_compound_assign_receiver_field] = STATE(617),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(617),
    [sym_call_with_receiver] = STATE(617),
    [sym_ref] = STATE(617),
    [sym_mut] = STATE(617),
    [sym_recover] = STATE(617),
    [sym_grouped_expression] = STATE(617),
    [sym_tuple] = STATE(617),
    [sym_array] = STATE(617),
    [sym_return] = STATE(617),
    [sym_try] = STATE(617),
    [sym_throw] = STATE(617),
    [sym_if] = STATE(617),
    [sym_while] = STATE(617),
    [sym_loop] = STATE(617),
    [sym_for] = STATE(617),
    [sym_match] = STATE(617),
    [sym_closure] = STATE(617),
    [sym_define_variable] = STATE(617),
    [sym_and_or] = STATE(617),
    [sym_binary] = STATE(617),
    [sym_cast] = STATE(617),
    [sym_string] = STATE(617),
    [sym_true] = STATE(617),
    [sym_false] = STATE(617),
    [sym_identifier] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(137),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(139),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(141),
    [anon_sym_recover] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_try] = ACTIONS(147),
    [anon_sym_throw] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(839),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(841),
    [sym_nil] = ACTIONS(841),
    [sym_break] = ACTIONS(841),
    [sym_next] = ACTIONS(841),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(155),
    [sym_constant] = ACTIONS(133),
  },
  [134] = {
    [sym_block] = STATE(599),
    [sym__expression] = STATE(599),
    [sym_assign_receiver_field] = STATE(599),
    [sym_assign_local] = STATE(599),
    [sym_assign_field] = STATE(599),
    [sym_replace_local] = STATE(599),
    [sym_replace_field] = STATE(599),
    [sym_compound_assign_local] = STATE(599),
    [sym_compound_assign_field] = STATE(599),
    [sym_compound_assign_receiver_field] = STATE(599),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(599),
    [sym_call_with_receiver] = STATE(599),
    [sym_ref] = STATE(599),
    [sym_mut] = STATE(599),
    [sym_recover] = STATE(599),
    [sym_grouped_expression] = STATE(599),
    [sym_tuple] = STATE(599),
    [sym_array] = STATE(599),
    [sym_return] = STATE(599),
    [sym_try] = STATE(599),
    [sym_throw] = STATE(599),
    [sym_if] = STATE(599),
    [sym_while] = STATE(599),
    [sym_loop] = STATE(599),
    [sym_for] = STATE(599),
    [sym_match] = STATE(599),
    [sym_closure] = STATE(599),
    [sym_define_variable] = STATE(599),
    [sym_and_or] = STATE(599),
    [sym_binary] = STATE(599),
    [sym_cast] = STATE(599),
    [sym_string] = STATE(599),
    [sym_true] = STATE(599),
    [sym_false] = STATE(599),
    [sym_identifier] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(137),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(139),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(141),
    [anon_sym_recover] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_try] = ACTIONS(147),
    [anon_sym_throw] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(843),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(845),
    [sym_nil] = ACTIONS(845),
    [sym_break] = ACTIONS(845),
    [sym_next] = ACTIONS(845),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(155),
    [sym_constant] = ACTIONS(133),
  },
  [135] = {
    [sym_block] = STATE(600),
    [sym__expression] = STATE(600),
    [sym_assign_receiver_field] = STATE(600),
    [sym_assign_local] = STATE(600),
    [sym_assign_field] = STATE(600),
    [sym_replace_local] = STATE(600),
    [sym_replace_field] = STATE(600),
    [sym_compound_assign_local] = STATE(600),
    [sym_compound_assign_field] = STATE(600),
    [sym_compound_assign_receiver_field] = STATE(600),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(600),
    [sym_call_with_receiver] = STATE(600),
    [sym_ref] = STATE(600),
    [sym_mut] = STATE(600),
    [sym_recover] = STATE(600),
    [sym_grouped_expression] = STATE(600),
    [sym_tuple] = STATE(600),
    [sym_array] = STATE(600),
    [sym_return] = STATE(600),
    [sym_try] = STATE(600),
    [sym_throw] = STATE(600),
    [sym_if] = STATE(600),
    [sym_while] = STATE(600),
    [sym_loop] = STATE(600),
    [sym_for] = STATE(600),
    [sym_match] = STATE(600),
    [sym_closure] = STATE(600),
    [sym_define_variable] = STATE(600),
    [sym_and_or] = STATE(600),
    [sym_binary] = STATE(600),
    [sym_cast] = STATE(600),
    [sym_string] = STATE(600),
    [sym_true] = STATE(600),
    [sym_false] = STATE(600),
    [sym_identifier] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(137),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(139),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(141),
    [anon_sym_recover] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_try] = ACTIONS(147),
    [anon_sym_throw] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(847),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(849),
    [sym_nil] = ACTIONS(849),
    [sym_break] = ACTIONS(849),
    [sym_next] = ACTIONS(849),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(155),
    [sym_constant] = ACTIONS(133),
  },
  [136] = {
    [sym_block] = STATE(618),
    [sym__expression] = STATE(618),
    [sym_assign_receiver_field] = STATE(618),
    [sym_assign_local] = STATE(618),
    [sym_assign_field] = STATE(618),
    [sym_replace_local] = STATE(618),
    [sym_replace_field] = STATE(618),
    [sym_compound_assign_local] = STATE(618),
    [sym_compound_assign_field] = STATE(618),
    [sym_compound_assign_receiver_field] = STATE(618),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(618),
    [sym_call_with_receiver] = STATE(618),
    [sym_ref] = STATE(618),
    [sym_mut] = STATE(618),
    [sym_recover] = STATE(618),
    [sym_grouped_expression] = STATE(618),
    [sym_tuple] = STATE(618),
    [sym_array] = STATE(618),
    [sym_return] = STATE(618),
    [sym_try] = STATE(618),
    [sym_throw] = STATE(618),
    [sym_if] = STATE(618),
    [sym_while] = STATE(618),
    [sym_loop] = STATE(618),
    [sym_for] = STATE(618),
    [sym_match] = STATE(618),
    [sym_closure] = STATE(618),
    [sym_define_variable] = STATE(618),
    [sym_and_or] = STATE(618),
    [sym_binary] = STATE(618),
    [sym_cast] = STATE(618),
    [sym_string] = STATE(618),
    [sym_true] = STATE(618),
    [sym_false] = STATE(618),
    [sym_identifier] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(137),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(139),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(141),
    [anon_sym_recover] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_try] = ACTIONS(147),
    [anon_sym_throw] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(851),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(853),
    [sym_nil] = ACTIONS(853),
    [sym_break] = ACTIONS(853),
    [sym_next] = ACTIONS(853),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(155),
    [sym_constant] = ACTIONS(133),
  },
  [137] = {
    [sym_block] = STATE(619),
    [sym__expression] = STATE(619),
    [sym_assign_receiver_field] = STATE(619),
    [sym_assign_local] = STATE(619),
    [sym_assign_field] = STATE(619),
    [sym_replace_local] = STATE(619),
    [sym_replace_field] = STATE(619),
    [sym_compound_assign_local] = STATE(619),
    [sym_compound_assign_field] = STATE(619),
    [sym_compound_assign_receiver_field] = STATE(619),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(619),
    [sym_call_with_receiver] = STATE(619),
    [sym_ref] = STATE(619),
    [sym_mut] = STATE(619),
    [sym_recover] = STATE(619),
    [sym_grouped_expression] = STATE(619),
    [sym_tuple] = STATE(619),
    [sym_array] = STATE(619),
    [sym_return] = STATE(619),
    [sym_try] = STATE(619),
    [sym_throw] = STATE(619),
    [sym_if] = STATE(619),
    [sym_while] = STATE(619),
    [sym_loop] = STATE(619),
    [sym_for] = STATE(619),
    [sym_match] = STATE(619),
    [sym_closure] = STATE(619),
    [sym_define_variable] = STATE(619),
    [sym_and_or] = STATE(619),
    [sym_binary] = STATE(619),
    [sym_cast] = STATE(619),
    [sym_string] = STATE(619),
    [sym_true] = STATE(619),
    [sym_false] = STATE(619),
    [sym_identifier] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(137),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(139),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(141),
    [anon_sym_recover] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_try] = ACTIONS(147),
    [anon_sym_throw] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(855),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(857),
    [sym_nil] = ACTIONS(857),
    [sym_break] = ACTIONS(857),
    [sym_next] = ACTIONS(857),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(155),
    [sym_constant] = ACTIONS(133),
  },
  [138] = {
    [sym_block] = STATE(601),
    [sym__expression] = STATE(601),
    [sym_assign_receiver_field] = STATE(601),
    [sym_assign_local] = STATE(601),
    [sym_assign_field] = STATE(601),
    [sym_replace_local] = STATE(601),
    [sym_replace_field] = STATE(601),
    [sym_compound_assign_local] = STATE(601),
    [sym_compound_assign_field] = STATE(601),
    [sym_compound_assign_receiver_field] = STATE(601),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(601),
    [sym_call_with_receiver] = STATE(601),
    [sym_ref] = STATE(601),
    [sym_mut] = STATE(601),
    [sym_recover] = STATE(601),
    [sym_grouped_expression] = STATE(601),
    [sym_tuple] = STATE(601),
    [sym_array] = STATE(601),
    [sym_return] = STATE(601),
    [sym_try] = STATE(601),
    [sym_throw] = STATE(601),
    [sym_if] = STATE(601),
    [sym_while] = STATE(601),
    [sym_loop] = STATE(601),
    [sym_for] = STATE(601),
    [sym_match] = STATE(601),
    [sym_closure] = STATE(601),
    [sym_define_variable] = STATE(601),
    [sym_and_or] = STATE(601),
    [sym_binary] = STATE(601),
    [sym_cast] = STATE(601),
    [sym_string] = STATE(601),
    [sym_true] = STATE(601),
    [sym_false] = STATE(601),
    [sym_identifier] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(137),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(139),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(141),
    [anon_sym_recover] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_try] = ACTIONS(147),
    [anon_sym_throw] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(859),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(861),
    [sym_nil] = ACTIONS(861),
    [sym_break] = ACTIONS(861),
    [sym_next] = ACTIONS(861),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(155),
    [sym_constant] = ACTIONS(133),
  },
  [139] = {
    [sym_block] = STATE(602),
    [sym__expression] = STATE(602),
    [sym_assign_receiver_field] = STATE(602),
    [sym_assign_local] = STATE(602),
    [sym_assign_field] = STATE(602),
    [sym_replace_local] = STATE(602),
    [sym_replace_field] = STATE(602),
    [sym_compound_assign_local] = STATE(602),
    [sym_compound_assign_field] = STATE(602),
    [sym_compound_assign_receiver_field] = STATE(602),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(602),
    [sym_call_with_receiver] = STATE(602),
    [sym_ref] = STATE(602),
    [sym_mut] = STATE(602),
    [sym_recover] = STATE(602),
    [sym_grouped_expression] = STATE(602),
    [sym_tuple] = STATE(602),
    [sym_array] = STATE(602),
    [sym_return] = STATE(602),
    [sym_try] = STATE(602),
    [sym_throw] = STATE(602),
    [sym_if] = STATE(602),
    [sym_while] = STATE(602),
    [sym_loop] = STATE(602),
    [sym_for] = STATE(602),
    [sym_match] = STATE(602),
    [sym_closure] = STATE(602),
    [sym_define_variable] = STATE(602),
    [sym_and_or] = STATE(602),
    [sym_binary] = STATE(602),
    [sym_cast] = STATE(602),
    [sym_string] = STATE(602),
    [sym_true] = STATE(602),
    [sym_false] = STATE(602),
    [sym_identifier] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(137),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(139),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(141),
    [anon_sym_recover] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_try] = ACTIONS(147),
    [anon_sym_throw] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(863),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(865),
    [sym_nil] = ACTIONS(865),
    [sym_break] = ACTIONS(865),
    [sym_next] = ACTIONS(865),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(155),
    [sym_constant] = ACTIONS(133),
  },
  [140] = {
    [sym_block] = STATE(199),
    [sym__expression] = STATE(199),
    [sym_assign_receiver_field] = STATE(199),
    [sym_assign_local] = STATE(199),
    [sym_assign_field] = STATE(199),
    [sym_replace_local] = STATE(199),
    [sym_replace_field] = STATE(199),
    [sym_compound_assign_local] = STATE(199),
    [sym_compound_assign_field] = STATE(199),
    [sym_compound_assign_receiver_field] = STATE(199),
    [sym__call_name] = STATE(1138),
    [sym_call] = STATE(199),
    [sym_call_with_receiver] = STATE(199),
    [sym_ref] = STATE(199),
    [sym_mut] = STATE(199),
    [sym_recover] = STATE(199),
    [sym_grouped_expression] = STATE(199),
    [sym_tuple] = STATE(199),
    [sym_array] = STATE(199),
    [sym_return] = STATE(199),
    [sym_try] = STATE(199),
    [sym_throw] = STATE(199),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_loop] = STATE(199),
    [sym_for] = STATE(199),
    [sym_match] = STATE(199),
    [sym_closure] = STATE(199),
    [sym_define_variable] = STATE(199),
    [sym_and_or] = STATE(199),
    [sym_binary] = STATE(199),
    [sym_cast] = STATE(199),
    [sym_string] = STATE(199),
    [sym_true] = STATE(199),
    [sym_false] = STATE(199),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(15),
    [anon_sym_fn] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_mut] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(75),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_ref] = ACTIONS(35),
    [anon_sym_recover] = ACTIONS(37),
    [anon_sym_return] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(41),
    [anon_sym_throw] = ACTIONS(43),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_loop] = ACTIONS(47),
    [anon_sym_match] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [sym_float] = ACTIONS(867),
    [sym_integer] = ACTIONS(57),
    [anon_sym_SQUOTE] = ACTIONS(59),
    [sym_self] = ACTIONS(869),
    [sym_nil] = ACTIONS(869),
    [sym_break] = ACTIONS(869),
    [sym_next] = ACTIONS(869),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(63),
    [sym_field] = ACTIONS(65),
    [sym_constant] = ACTIONS(67),
  },
  [141] = {
    [sym_block] = STATE(325),
    [sym__expression] = STATE(325),
    [sym_assign_receiver_field] = STATE(325),
    [sym_assign_local] = STATE(325),
    [sym_assign_field] = STATE(325),
    [sym_replace_local] = STATE(325),
    [sym_replace_field] = STATE(325),
    [sym_compound_assign_local] = STATE(325),
    [sym_compound_assign_field] = STATE(325),
    [sym_compound_assign_receiver_field] = STATE(325),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(325),
    [sym_call_with_receiver] = STATE(325),
    [sym_ref] = STATE(325),
    [sym_mut] = STATE(325),
    [sym_recover] = STATE(325),
    [sym_grouped_expression] = STATE(325),
    [sym_tuple] = STATE(325),
    [sym_array] = STATE(325),
    [sym_return] = STATE(325),
    [sym_try] = STATE(325),
    [sym_throw] = STATE(325),
    [sym_if] = STATE(325),
    [sym_while] = STATE(325),
    [sym_loop] = STATE(325),
    [sym_for] = STATE(325),
    [sym_match] = STATE(325),
    [sym_closure] = STATE(325),
    [sym_define_variable] = STATE(325),
    [sym_and_or] = STATE(325),
    [sym_binary] = STATE(325),
    [sym_cast] = STATE(325),
    [sym_string] = STATE(325),
    [sym_true] = STATE(325),
    [sym_false] = STATE(325),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(871),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(873),
    [sym_nil] = ACTIONS(873),
    [sym_break] = ACTIONS(873),
    [sym_next] = ACTIONS(873),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [142] = {
    [sym_block] = STATE(231),
    [sym__expression] = STATE(231),
    [sym_assign_receiver_field] = STATE(231),
    [sym_assign_local] = STATE(231),
    [sym_assign_field] = STATE(231),
    [sym_replace_local] = STATE(231),
    [sym_replace_field] = STATE(231),
    [sym_compound_assign_local] = STATE(231),
    [sym_compound_assign_field] = STATE(231),
    [sym_compound_assign_receiver_field] = STATE(231),
    [sym__call_name] = STATE(1138),
    [sym_call] = STATE(231),
    [sym_call_with_receiver] = STATE(231),
    [sym_ref] = STATE(231),
    [sym_mut] = STATE(231),
    [sym_recover] = STATE(231),
    [sym_grouped_expression] = STATE(231),
    [sym_tuple] = STATE(231),
    [sym_array] = STATE(231),
    [sym_return] = STATE(231),
    [sym_try] = STATE(231),
    [sym_throw] = STATE(231),
    [sym_if] = STATE(231),
    [sym_while] = STATE(231),
    [sym_loop] = STATE(231),
    [sym_for] = STATE(231),
    [sym_match] = STATE(231),
    [sym_closure] = STATE(231),
    [sym_define_variable] = STATE(231),
    [sym_and_or] = STATE(231),
    [sym_binary] = STATE(231),
    [sym_cast] = STATE(231),
    [sym_string] = STATE(231),
    [sym_true] = STATE(231),
    [sym_false] = STATE(231),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(15),
    [anon_sym_fn] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_mut] = ACTIONS(21),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(75),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_ref] = ACTIONS(35),
    [anon_sym_recover] = ACTIONS(37),
    [anon_sym_return] = ACTIONS(39),
    [anon_sym_try] = ACTIONS(41),
    [anon_sym_throw] = ACTIONS(43),
    [anon_sym_while] = ACTIONS(45),
    [anon_sym_loop] = ACTIONS(47),
    [anon_sym_match] = ACTIONS(49),
    [anon_sym_true] = ACTIONS(51),
    [anon_sym_false] = ACTIONS(53),
    [sym_float] = ACTIONS(875),
    [sym_integer] = ACTIONS(57),
    [anon_sym_SQUOTE] = ACTIONS(59),
    [sym_self] = ACTIONS(877),
    [sym_nil] = ACTIONS(877),
    [sym_break] = ACTIONS(877),
    [sym_next] = ACTIONS(877),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(63),
    [sym_field] = ACTIONS(65),
    [sym_constant] = ACTIONS(67),
  },
  [143] = {
    [sym_block] = STATE(327),
    [sym__expression] = STATE(327),
    [sym_assign_receiver_field] = STATE(327),
    [sym_assign_local] = STATE(327),
    [sym_assign_field] = STATE(327),
    [sym_replace_local] = STATE(327),
    [sym_replace_field] = STATE(327),
    [sym_compound_assign_local] = STATE(327),
    [sym_compound_assign_field] = STATE(327),
    [sym_compound_assign_receiver_field] = STATE(327),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(327),
    [sym_call_with_receiver] = STATE(327),
    [sym_ref] = STATE(327),
    [sym_mut] = STATE(327),
    [sym_recover] = STATE(327),
    [sym_grouped_expression] = STATE(327),
    [sym_tuple] = STATE(327),
    [sym_array] = STATE(327),
    [sym_return] = STATE(327),
    [sym_try] = STATE(327),
    [sym_throw] = STATE(327),
    [sym_if] = STATE(327),
    [sym_while] = STATE(327),
    [sym_loop] = STATE(327),
    [sym_for] = STATE(327),
    [sym_match] = STATE(327),
    [sym_closure] = STATE(327),
    [sym_define_variable] = STATE(327),
    [sym_and_or] = STATE(327),
    [sym_binary] = STATE(327),
    [sym_cast] = STATE(327),
    [sym_string] = STATE(327),
    [sym_true] = STATE(327),
    [sym_false] = STATE(327),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(879),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(881),
    [sym_nil] = ACTIONS(881),
    [sym_break] = ACTIONS(881),
    [sym_next] = ACTIONS(881),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [144] = {
    [sym_block] = STATE(328),
    [sym__expression] = STATE(328),
    [sym_assign_receiver_field] = STATE(328),
    [sym_assign_local] = STATE(328),
    [sym_assign_field] = STATE(328),
    [sym_replace_local] = STATE(328),
    [sym_replace_field] = STATE(328),
    [sym_compound_assign_local] = STATE(328),
    [sym_compound_assign_field] = STATE(328),
    [sym_compound_assign_receiver_field] = STATE(328),
    [sym__call_name] = STATE(1126),
    [sym_call] = STATE(328),
    [sym_call_with_receiver] = STATE(328),
    [sym_ref] = STATE(328),
    [sym_mut] = STATE(328),
    [sym_recover] = STATE(328),
    [sym_grouped_expression] = STATE(328),
    [sym_tuple] = STATE(328),
    [sym_array] = STATE(328),
    [sym_return] = STATE(328),
    [sym_try] = STATE(328),
    [sym_throw] = STATE(328),
    [sym_if] = STATE(328),
    [sym_while] = STATE(328),
    [sym_loop] = STATE(328),
    [sym_for] = STATE(328),
    [sym_match] = STATE(328),
    [sym_closure] = STATE(328),
    [sym_define_variable] = STATE(328),
    [sym_and_or] = STATE(328),
    [sym_binary] = STATE(328),
    [sym_cast] = STATE(328),
    [sym_string] = STATE(328),
    [sym_true] = STATE(328),
    [sym_false] = STATE(328),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_LPAREN] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_fn] = ACTIONS(165),
    [anon_sym_LBRACK] = ACTIONS(167),
    [anon_sym_mut] = ACTIONS(169),
    [anon_sym_LBRACE] = ACTIONS(171),
    [anon_sym_let] = ACTIONS(173),
    [anon_sym_for] = ACTIONS(175),
    [anon_sym_ref] = ACTIONS(177),
    [anon_sym_recover] = ACTIONS(179),
    [anon_sym_return] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_throw] = ACTIONS(185),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_loop] = ACTIONS(189),
    [anon_sym_match] = ACTIONS(191),
    [anon_sym_true] = ACTIONS(193),
    [anon_sym_false] = ACTIONS(195),
    [sym_float] = ACTIONS(883),
    [sym_integer] = ACTIONS(199),
    [anon_sym_SQUOTE] = ACTIONS(201),
    [sym_self] = ACTIONS(885),
    [sym_nil] = ACTIONS(885),
    [sym_break] = ACTIONS(885),
    [sym_next] = ACTIONS(885),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(205),
    [sym_field] = ACTIONS(207),
    [sym_constant] = ACTIONS(209),
  },
  [145] = {
    [sym_block] = STATE(636),
    [sym__expression] = STATE(636),
    [sym_assign_receiver_field] = STATE(636),
    [sym_assign_local] = STATE(636),
    [sym_assign_field] = STATE(636),
    [sym_replace_local] = STATE(636),
    [sym_replace_field] = STATE(636),
    [sym_compound_assign_local] = STATE(636),
    [sym_compound_assign_field] = STATE(636),
    [sym_compound_assign_receiver_field] = STATE(636),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(636),
    [sym_call_with_receiver] = STATE(636),
    [sym_ref] = STATE(636),
    [sym_mut] = STATE(636),
    [sym_recover] = STATE(636),
    [sym_grouped_expression] = STATE(636),
    [sym_tuple] = STATE(636),
    [sym_array] = STATE(636),
    [sym_return] = STATE(636),
    [sym_try] = STATE(636),
    [sym_throw] = STATE(636),
    [sym_if] = STATE(636),
    [sym_while] = STATE(636),
    [sym_loop] = STATE(636),
    [sym_for] = STATE(636),
    [sym_match] = STATE(636),
    [sym_closure] = STATE(636),
    [sym_define_variable] = STATE(636),
    [sym_and_or] = STATE(636),
    [sym_binary] = STATE(636),
    [sym_cast] = STATE(636),
    [sym_string] = STATE(636),
    [sym_true] = STATE(636),
    [sym_false] = STATE(636),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(887),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(889),
    [sym_nil] = ACTIONS(889),
    [sym_break] = ACTIONS(889),
    [sym_next] = ACTIONS(889),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [146] = {
    [sym_block] = STATE(640),
    [sym__expression] = STATE(640),
    [sym_assign_receiver_field] = STATE(640),
    [sym_assign_local] = STATE(640),
    [sym_assign_field] = STATE(640),
    [sym_replace_local] = STATE(640),
    [sym_replace_field] = STATE(640),
    [sym_compound_assign_local] = STATE(640),
    [sym_compound_assign_field] = STATE(640),
    [sym_compound_assign_receiver_field] = STATE(640),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(640),
    [sym_call_with_receiver] = STATE(640),
    [sym_ref] = STATE(640),
    [sym_mut] = STATE(640),
    [sym_recover] = STATE(640),
    [sym_grouped_expression] = STATE(640),
    [sym_tuple] = STATE(640),
    [sym_array] = STATE(640),
    [sym_return] = STATE(640),
    [sym_try] = STATE(640),
    [sym_throw] = STATE(640),
    [sym_if] = STATE(640),
    [sym_while] = STATE(640),
    [sym_loop] = STATE(640),
    [sym_for] = STATE(640),
    [sym_match] = STATE(640),
    [sym_closure] = STATE(640),
    [sym_define_variable] = STATE(640),
    [sym_and_or] = STATE(640),
    [sym_binary] = STATE(640),
    [sym_cast] = STATE(640),
    [sym_string] = STATE(640),
    [sym_true] = STATE(640),
    [sym_false] = STATE(640),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(891),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(893),
    [sym_nil] = ACTIONS(893),
    [sym_break] = ACTIONS(893),
    [sym_next] = ACTIONS(893),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [147] = {
    [sym_block] = STATE(611),
    [sym__expression] = STATE(611),
    [sym_assign_receiver_field] = STATE(611),
    [sym_assign_local] = STATE(611),
    [sym_assign_field] = STATE(611),
    [sym_replace_local] = STATE(611),
    [sym_replace_field] = STATE(611),
    [sym_compound_assign_local] = STATE(611),
    [sym_compound_assign_field] = STATE(611),
    [sym_compound_assign_receiver_field] = STATE(611),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(611),
    [sym_call_with_receiver] = STATE(611),
    [sym_ref] = STATE(611),
    [sym_mut] = STATE(611),
    [sym_recover] = STATE(611),
    [sym_grouped_expression] = STATE(611),
    [sym_tuple] = STATE(611),
    [sym_array] = STATE(611),
    [sym_return] = STATE(611),
    [sym_try] = STATE(611),
    [sym_throw] = STATE(611),
    [sym_if] = STATE(611),
    [sym_while] = STATE(611),
    [sym_loop] = STATE(611),
    [sym_for] = STATE(611),
    [sym_match] = STATE(611),
    [sym_closure] = STATE(611),
    [sym_define_variable] = STATE(611),
    [sym_and_or] = STATE(611),
    [sym_binary] = STATE(611),
    [sym_cast] = STATE(611),
    [sym_string] = STATE(611),
    [sym_true] = STATE(611),
    [sym_false] = STATE(611),
    [sym_identifier] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(137),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(139),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(141),
    [anon_sym_recover] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_try] = ACTIONS(147),
    [anon_sym_throw] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(895),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(897),
    [sym_nil] = ACTIONS(897),
    [sym_break] = ACTIONS(897),
    [sym_next] = ACTIONS(897),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(155),
    [sym_constant] = ACTIONS(133),
  },
  [148] = {
    [sym_block] = STATE(612),
    [sym__expression] = STATE(612),
    [sym_assign_receiver_field] = STATE(612),
    [sym_assign_local] = STATE(612),
    [sym_assign_field] = STATE(612),
    [sym_replace_local] = STATE(612),
    [sym_replace_field] = STATE(612),
    [sym_compound_assign_local] = STATE(612),
    [sym_compound_assign_field] = STATE(612),
    [sym_compound_assign_receiver_field] = STATE(612),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(612),
    [sym_call_with_receiver] = STATE(612),
    [sym_ref] = STATE(612),
    [sym_mut] = STATE(612),
    [sym_recover] = STATE(612),
    [sym_grouped_expression] = STATE(612),
    [sym_tuple] = STATE(612),
    [sym_array] = STATE(612),
    [sym_return] = STATE(612),
    [sym_try] = STATE(612),
    [sym_throw] = STATE(612),
    [sym_if] = STATE(612),
    [sym_while] = STATE(612),
    [sym_loop] = STATE(612),
    [sym_for] = STATE(612),
    [sym_match] = STATE(612),
    [sym_closure] = STATE(612),
    [sym_define_variable] = STATE(612),
    [sym_and_or] = STATE(612),
    [sym_binary] = STATE(612),
    [sym_cast] = STATE(612),
    [sym_string] = STATE(612),
    [sym_true] = STATE(612),
    [sym_false] = STATE(612),
    [sym_identifier] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(137),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(139),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(141),
    [anon_sym_recover] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_try] = ACTIONS(147),
    [anon_sym_throw] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(899),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(901),
    [sym_nil] = ACTIONS(901),
    [sym_break] = ACTIONS(901),
    [sym_next] = ACTIONS(901),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(155),
    [sym_constant] = ACTIONS(133),
  },
  [149] = {
    [sym_block] = STATE(613),
    [sym__expression] = STATE(613),
    [sym_assign_receiver_field] = STATE(613),
    [sym_assign_local] = STATE(613),
    [sym_assign_field] = STATE(613),
    [sym_replace_local] = STATE(613),
    [sym_replace_field] = STATE(613),
    [sym_compound_assign_local] = STATE(613),
    [sym_compound_assign_field] = STATE(613),
    [sym_compound_assign_receiver_field] = STATE(613),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(613),
    [sym_call_with_receiver] = STATE(613),
    [sym_ref] = STATE(613),
    [sym_mut] = STATE(613),
    [sym_recover] = STATE(613),
    [sym_grouped_expression] = STATE(613),
    [sym_tuple] = STATE(613),
    [sym_array] = STATE(613),
    [sym_return] = STATE(613),
    [sym_try] = STATE(613),
    [sym_throw] = STATE(613),
    [sym_if] = STATE(613),
    [sym_while] = STATE(613),
    [sym_loop] = STATE(613),
    [sym_for] = STATE(613),
    [sym_match] = STATE(613),
    [sym_closure] = STATE(613),
    [sym_define_variable] = STATE(613),
    [sym_and_or] = STATE(613),
    [sym_binary] = STATE(613),
    [sym_cast] = STATE(613),
    [sym_string] = STATE(613),
    [sym_true] = STATE(613),
    [sym_false] = STATE(613),
    [sym_identifier] = ACTIONS(135),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(137),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(139),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(141),
    [anon_sym_recover] = ACTIONS(143),
    [anon_sym_return] = ACTIONS(145),
    [anon_sym_try] = ACTIONS(147),
    [anon_sym_throw] = ACTIONS(149),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(903),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(905),
    [sym_nil] = ACTIONS(905),
    [sym_break] = ACTIONS(905),
    [sym_next] = ACTIONS(905),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(155),
    [sym_constant] = ACTIONS(133),
  },
  [150] = {
    [sym_block] = STATE(630),
    [sym__expression] = STATE(630),
    [sym_assign_receiver_field] = STATE(630),
    [sym_assign_local] = STATE(630),
    [sym_assign_field] = STATE(630),
    [sym_replace_local] = STATE(630),
    [sym_replace_field] = STATE(630),
    [sym_compound_assign_local] = STATE(630),
    [sym_compound_assign_field] = STATE(630),
    [sym_compound_assign_receiver_field] = STATE(630),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(630),
    [sym_call_with_receiver] = STATE(630),
    [sym_ref] = STATE(630),
    [sym_mut] = STATE(630),
    [sym_recover] = STATE(630),
    [sym_grouped_expression] = STATE(630),
    [sym_tuple] = STATE(630),
    [sym_array] = STATE(630),
    [sym_return] = STATE(630),
    [sym_try] = STATE(630),
    [sym_throw] = STATE(630),
    [sym_if] = STATE(630),
    [sym_while] = STATE(630),
    [sym_loop] = STATE(630),
    [sym_for] = STATE(630),
    [sym_match] = STATE(630),
    [sym_closure] = STATE(630),
    [sym_define_variable] = STATE(630),
    [sym_and_or] = STATE(630),
    [sym_binary] = STATE(630),
    [sym_cast] = STATE(630),
    [sym_string] = STATE(630),
    [sym_true] = STATE(630),
    [sym_false] = STATE(630),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(907),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(909),
    [sym_nil] = ACTIONS(909),
    [sym_break] = ACTIONS(909),
    [sym_next] = ACTIONS(909),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [151] = {
    [sym_block] = STATE(633),
    [sym__expression] = STATE(633),
    [sym_assign_receiver_field] = STATE(633),
    [sym_assign_local] = STATE(633),
    [sym_assign_field] = STATE(633),
    [sym_replace_local] = STATE(633),
    [sym_replace_field] = STATE(633),
    [sym_compound_assign_local] = STATE(633),
    [sym_compound_assign_field] = STATE(633),
    [sym_compound_assign_receiver_field] = STATE(633),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(633),
    [sym_call_with_receiver] = STATE(633),
    [sym_ref] = STATE(633),
    [sym_mut] = STATE(633),
    [sym_recover] = STATE(633),
    [sym_grouped_expression] = STATE(633),
    [sym_tuple] = STATE(633),
    [sym_array] = STATE(633),
    [sym_return] = STATE(633),
    [sym_try] = STATE(633),
    [sym_throw] = STATE(633),
    [sym_if] = STATE(633),
    [sym_while] = STATE(633),
    [sym_loop] = STATE(633),
    [sym_for] = STATE(633),
    [sym_match] = STATE(633),
    [sym_closure] = STATE(633),
    [sym_define_variable] = STATE(633),
    [sym_and_or] = STATE(633),
    [sym_binary] = STATE(633),
    [sym_cast] = STATE(633),
    [sym_string] = STATE(633),
    [sym_true] = STATE(633),
    [sym_false] = STATE(633),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(911),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(913),
    [sym_nil] = ACTIONS(913),
    [sym_break] = ACTIONS(913),
    [sym_next] = ACTIONS(913),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [152] = {
    [sym_block] = STATE(623),
    [sym__expression] = STATE(623),
    [sym_assign_receiver_field] = STATE(623),
    [sym_assign_local] = STATE(623),
    [sym_assign_field] = STATE(623),
    [sym_replace_local] = STATE(623),
    [sym_replace_field] = STATE(623),
    [sym_compound_assign_local] = STATE(623),
    [sym_compound_assign_field] = STATE(623),
    [sym_compound_assign_receiver_field] = STATE(623),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(623),
    [sym_call_with_receiver] = STATE(623),
    [sym_ref] = STATE(623),
    [sym_mut] = STATE(623),
    [sym_recover] = STATE(623),
    [sym_grouped_expression] = STATE(623),
    [sym_tuple] = STATE(623),
    [sym_array] = STATE(623),
    [sym_return] = STATE(623),
    [sym_try] = STATE(623),
    [sym_throw] = STATE(623),
    [sym_if] = STATE(623),
    [sym_while] = STATE(623),
    [sym_loop] = STATE(623),
    [sym_for] = STATE(623),
    [sym_match] = STATE(623),
    [sym_closure] = STATE(623),
    [sym_define_variable] = STATE(623),
    [sym_and_or] = STATE(623),
    [sym_binary] = STATE(623),
    [sym_cast] = STATE(623),
    [sym_string] = STATE(623),
    [sym_true] = STATE(623),
    [sym_false] = STATE(623),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(915),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(917),
    [sym_nil] = ACTIONS(917),
    [sym_break] = ACTIONS(917),
    [sym_next] = ACTIONS(917),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [153] = {
    [sym_block] = STATE(637),
    [sym__expression] = STATE(637),
    [sym_assign_receiver_field] = STATE(637),
    [sym_assign_local] = STATE(637),
    [sym_assign_field] = STATE(637),
    [sym_replace_local] = STATE(637),
    [sym_replace_field] = STATE(637),
    [sym_compound_assign_local] = STATE(637),
    [sym_compound_assign_field] = STATE(637),
    [sym_compound_assign_receiver_field] = STATE(637),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(637),
    [sym_call_with_receiver] = STATE(637),
    [sym_ref] = STATE(637),
    [sym_mut] = STATE(637),
    [sym_recover] = STATE(637),
    [sym_grouped_expression] = STATE(637),
    [sym_tuple] = STATE(637),
    [sym_array] = STATE(637),
    [sym_return] = STATE(637),
    [sym_try] = STATE(637),
    [sym_throw] = STATE(637),
    [sym_if] = STATE(637),
    [sym_while] = STATE(637),
    [sym_loop] = STATE(637),
    [sym_for] = STATE(637),
    [sym_match] = STATE(637),
    [sym_closure] = STATE(637),
    [sym_define_variable] = STATE(637),
    [sym_and_or] = STATE(637),
    [sym_binary] = STATE(637),
    [sym_cast] = STATE(637),
    [sym_string] = STATE(637),
    [sym_true] = STATE(637),
    [sym_false] = STATE(637),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(919),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(921),
    [sym_nil] = ACTIONS(921),
    [sym_break] = ACTIONS(921),
    [sym_next] = ACTIONS(921),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [154] = {
    [sym_block] = STATE(622),
    [sym__expression] = STATE(622),
    [sym_assign_receiver_field] = STATE(622),
    [sym_assign_local] = STATE(622),
    [sym_assign_field] = STATE(622),
    [sym_replace_local] = STATE(622),
    [sym_replace_field] = STATE(622),
    [sym_compound_assign_local] = STATE(622),
    [sym_compound_assign_field] = STATE(622),
    [sym_compound_assign_receiver_field] = STATE(622),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(622),
    [sym_call_with_receiver] = STATE(622),
    [sym_ref] = STATE(622),
    [sym_mut] = STATE(622),
    [sym_recover] = STATE(622),
    [sym_grouped_expression] = STATE(622),
    [sym_tuple] = STATE(622),
    [sym_array] = STATE(622),
    [sym_return] = STATE(622),
    [sym_try] = STATE(622),
    [sym_throw] = STATE(622),
    [sym_if] = STATE(622),
    [sym_while] = STATE(622),
    [sym_loop] = STATE(622),
    [sym_for] = STATE(622),
    [sym_match] = STATE(622),
    [sym_closure] = STATE(622),
    [sym_define_variable] = STATE(622),
    [sym_and_or] = STATE(622),
    [sym_binary] = STATE(622),
    [sym_cast] = STATE(622),
    [sym_string] = STATE(622),
    [sym_true] = STATE(622),
    [sym_false] = STATE(622),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(923),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(925),
    [sym_nil] = ACTIONS(925),
    [sym_break] = ACTIONS(925),
    [sym_next] = ACTIONS(925),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [155] = {
    [sym_block] = STATE(627),
    [sym__expression] = STATE(627),
    [sym_assign_receiver_field] = STATE(627),
    [sym_assign_local] = STATE(627),
    [sym_assign_field] = STATE(627),
    [sym_replace_local] = STATE(627),
    [sym_replace_field] = STATE(627),
    [sym_compound_assign_local] = STATE(627),
    [sym_compound_assign_field] = STATE(627),
    [sym_compound_assign_receiver_field] = STATE(627),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(627),
    [sym_call_with_receiver] = STATE(627),
    [sym_ref] = STATE(627),
    [sym_mut] = STATE(627),
    [sym_recover] = STATE(627),
    [sym_grouped_expression] = STATE(627),
    [sym_tuple] = STATE(627),
    [sym_array] = STATE(627),
    [sym_return] = STATE(627),
    [sym_try] = STATE(627),
    [sym_throw] = STATE(627),
    [sym_if] = STATE(627),
    [sym_while] = STATE(627),
    [sym_loop] = STATE(627),
    [sym_for] = STATE(627),
    [sym_match] = STATE(627),
    [sym_closure] = STATE(627),
    [sym_define_variable] = STATE(627),
    [sym_and_or] = STATE(627),
    [sym_binary] = STATE(627),
    [sym_cast] = STATE(627),
    [sym_string] = STATE(627),
    [sym_true] = STATE(627),
    [sym_false] = STATE(627),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(927),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(929),
    [sym_nil] = ACTIONS(929),
    [sym_break] = ACTIONS(929),
    [sym_next] = ACTIONS(929),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [156] = {
    [sym_block] = STATE(625),
    [sym__expression] = STATE(625),
    [sym_assign_receiver_field] = STATE(625),
    [sym_assign_local] = STATE(625),
    [sym_assign_field] = STATE(625),
    [sym_replace_local] = STATE(625),
    [sym_replace_field] = STATE(625),
    [sym_compound_assign_local] = STATE(625),
    [sym_compound_assign_field] = STATE(625),
    [sym_compound_assign_receiver_field] = STATE(625),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(625),
    [sym_call_with_receiver] = STATE(625),
    [sym_ref] = STATE(625),
    [sym_mut] = STATE(625),
    [sym_recover] = STATE(625),
    [sym_grouped_expression] = STATE(625),
    [sym_tuple] = STATE(625),
    [sym_array] = STATE(625),
    [sym_return] = STATE(625),
    [sym_try] = STATE(625),
    [sym_throw] = STATE(625),
    [sym_if] = STATE(625),
    [sym_while] = STATE(625),
    [sym_loop] = STATE(625),
    [sym_for] = STATE(625),
    [sym_match] = STATE(625),
    [sym_closure] = STATE(625),
    [sym_define_variable] = STATE(625),
    [sym_and_or] = STATE(625),
    [sym_binary] = STATE(625),
    [sym_cast] = STATE(625),
    [sym_string] = STATE(625),
    [sym_true] = STATE(625),
    [sym_false] = STATE(625),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(931),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(933),
    [sym_nil] = ACTIONS(933),
    [sym_break] = ACTIONS(933),
    [sym_next] = ACTIONS(933),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [157] = {
    [sym_block] = STATE(626),
    [sym__expression] = STATE(626),
    [sym_assign_receiver_field] = STATE(626),
    [sym_assign_local] = STATE(626),
    [sym_assign_field] = STATE(626),
    [sym_replace_local] = STATE(626),
    [sym_replace_field] = STATE(626),
    [sym_compound_assign_local] = STATE(626),
    [sym_compound_assign_field] = STATE(626),
    [sym_compound_assign_receiver_field] = STATE(626),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(626),
    [sym_call_with_receiver] = STATE(626),
    [sym_ref] = STATE(626),
    [sym_mut] = STATE(626),
    [sym_recover] = STATE(626),
    [sym_grouped_expression] = STATE(626),
    [sym_tuple] = STATE(626),
    [sym_array] = STATE(626),
    [sym_return] = STATE(626),
    [sym_try] = STATE(626),
    [sym_throw] = STATE(626),
    [sym_if] = STATE(626),
    [sym_while] = STATE(626),
    [sym_loop] = STATE(626),
    [sym_for] = STATE(626),
    [sym_match] = STATE(626),
    [sym_closure] = STATE(626),
    [sym_define_variable] = STATE(626),
    [sym_and_or] = STATE(626),
    [sym_binary] = STATE(626),
    [sym_cast] = STATE(626),
    [sym_string] = STATE(626),
    [sym_true] = STATE(626),
    [sym_false] = STATE(626),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(935),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(937),
    [sym_nil] = ACTIONS(937),
    [sym_break] = ACTIONS(937),
    [sym_next] = ACTIONS(937),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [158] = {
    [sym_block] = STATE(631),
    [sym__expression] = STATE(631),
    [sym_assign_receiver_field] = STATE(631),
    [sym_assign_local] = STATE(631),
    [sym_assign_field] = STATE(631),
    [sym_replace_local] = STATE(631),
    [sym_replace_field] = STATE(631),
    [sym_compound_assign_local] = STATE(631),
    [sym_compound_assign_field] = STATE(631),
    [sym_compound_assign_receiver_field] = STATE(631),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(631),
    [sym_call_with_receiver] = STATE(631),
    [sym_ref] = STATE(631),
    [sym_mut] = STATE(631),
    [sym_recover] = STATE(631),
    [sym_grouped_expression] = STATE(631),
    [sym_tuple] = STATE(631),
    [sym_array] = STATE(631),
    [sym_return] = STATE(631),
    [sym_try] = STATE(631),
    [sym_throw] = STATE(631),
    [sym_if] = STATE(631),
    [sym_while] = STATE(631),
    [sym_loop] = STATE(631),
    [sym_for] = STATE(631),
    [sym_match] = STATE(631),
    [sym_closure] = STATE(631),
    [sym_define_variable] = STATE(631),
    [sym_and_or] = STATE(631),
    [sym_binary] = STATE(631),
    [sym_cast] = STATE(631),
    [sym_string] = STATE(631),
    [sym_true] = STATE(631),
    [sym_false] = STATE(631),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(939),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(941),
    [sym_nil] = ACTIONS(941),
    [sym_break] = ACTIONS(941),
    [sym_next] = ACTIONS(941),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [159] = {
    [sym_block] = STATE(632),
    [sym__expression] = STATE(632),
    [sym_assign_receiver_field] = STATE(632),
    [sym_assign_local] = STATE(632),
    [sym_assign_field] = STATE(632),
    [sym_replace_local] = STATE(632),
    [sym_replace_field] = STATE(632),
    [sym_compound_assign_local] = STATE(632),
    [sym_compound_assign_field] = STATE(632),
    [sym_compound_assign_receiver_field] = STATE(632),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(632),
    [sym_call_with_receiver] = STATE(632),
    [sym_ref] = STATE(632),
    [sym_mut] = STATE(632),
    [sym_recover] = STATE(632),
    [sym_grouped_expression] = STATE(632),
    [sym_tuple] = STATE(632),
    [sym_array] = STATE(632),
    [sym_return] = STATE(632),
    [sym_try] = STATE(632),
    [sym_throw] = STATE(632),
    [sym_if] = STATE(632),
    [sym_while] = STATE(632),
    [sym_loop] = STATE(632),
    [sym_for] = STATE(632),
    [sym_match] = STATE(632),
    [sym_closure] = STATE(632),
    [sym_define_variable] = STATE(632),
    [sym_and_or] = STATE(632),
    [sym_binary] = STATE(632),
    [sym_cast] = STATE(632),
    [sym_string] = STATE(632),
    [sym_true] = STATE(632),
    [sym_false] = STATE(632),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(943),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(945),
    [sym_nil] = ACTIONS(945),
    [sym_break] = ACTIONS(945),
    [sym_next] = ACTIONS(945),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [160] = {
    [sym_block] = STATE(639),
    [sym__expression] = STATE(639),
    [sym_assign_receiver_field] = STATE(639),
    [sym_assign_local] = STATE(639),
    [sym_assign_field] = STATE(639),
    [sym_replace_local] = STATE(639),
    [sym_replace_field] = STATE(639),
    [sym_compound_assign_local] = STATE(639),
    [sym_compound_assign_field] = STATE(639),
    [sym_compound_assign_receiver_field] = STATE(639),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(639),
    [sym_call_with_receiver] = STATE(639),
    [sym_ref] = STATE(639),
    [sym_mut] = STATE(639),
    [sym_recover] = STATE(639),
    [sym_grouped_expression] = STATE(639),
    [sym_tuple] = STATE(639),
    [sym_array] = STATE(639),
    [sym_return] = STATE(639),
    [sym_try] = STATE(639),
    [sym_throw] = STATE(639),
    [sym_if] = STATE(639),
    [sym_while] = STATE(639),
    [sym_loop] = STATE(639),
    [sym_for] = STATE(639),
    [sym_match] = STATE(639),
    [sym_closure] = STATE(639),
    [sym_define_variable] = STATE(639),
    [sym_and_or] = STATE(639),
    [sym_binary] = STATE(639),
    [sym_cast] = STATE(639),
    [sym_string] = STATE(639),
    [sym_true] = STATE(639),
    [sym_false] = STATE(639),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(947),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(949),
    [sym_nil] = ACTIONS(949),
    [sym_break] = ACTIONS(949),
    [sym_next] = ACTIONS(949),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
  [161] = {
    [sym_block] = STATE(575),
    [sym__expression] = STATE(575),
    [sym_assign_receiver_field] = STATE(575),
    [sym_assign_local] = STATE(575),
    [sym_assign_field] = STATE(575),
    [sym_replace_local] = STATE(575),
    [sym_replace_field] = STATE(575),
    [sym_compound_assign_local] = STATE(575),
    [sym_compound_assign_field] = STATE(575),
    [sym_compound_assign_receiver_field] = STATE(575),
    [sym__call_name] = STATE(1162),
    [sym_call] = STATE(575),
    [sym_call_with_receiver] = STATE(575),
    [sym_ref] = STATE(575),
    [sym_mut] = STATE(575),
    [sym_recover] = STATE(575),
    [sym_grouped_expression] = STATE(575),
    [sym_tuple] = STATE(575),
    [sym_array] = STATE(575),
    [sym_return] = STATE(575),
    [sym_try] = STATE(575),
    [sym_throw] = STATE(575),
    [sym_if] = STATE(575),
    [sym_while] = STATE(575),
    [sym_loop] = STATE(575),
    [sym_for] = STATE(575),
    [sym_match] = STATE(575),
    [sym_closure] = STATE(575),
    [sym_define_variable] = STATE(575),
    [sym_and_or] = STATE(575),
    [sym_binary] = STATE(575),
    [sym_cast] = STATE(575),
    [sym_string] = STATE(575),
    [sym_true] = STATE(575),
    [sym_false] = STATE(575),
    [sym_identifier] = ACTIONS(81),
    [anon_sym_LPAREN] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(85),
    [anon_sym_DQUOTE] = ACTIONS(87),
    [anon_sym_fn] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(91),
    [anon_sym_mut] = ACTIONS(93),
    [anon_sym_LBRACE] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_ref] = ACTIONS(101),
    [anon_sym_recover] = ACTIONS(103),
    [anon_sym_return] = ACTIONS(105),
    [anon_sym_try] = ACTIONS(107),
    [anon_sym_throw] = ACTIONS(109),
    [anon_sym_while] = ACTIONS(111),
    [anon_sym_loop] = ACTIONS(113),
    [anon_sym_match] = ACTIONS(115),
    [anon_sym_true] = ACTIONS(117),
    [anon_sym_false] = ACTIONS(119),
    [sym_float] = ACTIONS(951),
    [sym_integer] = ACTIONS(123),
    [anon_sym_SQUOTE] = ACTIONS(125),
    [sym_self] = ACTIONS(953),
    [sym_nil] = ACTIONS(953),
    [sym_break] = ACTIONS(953),
    [sym_next] = ACTIONS(953),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(129),
    [sym_field] = ACTIONS(131),
    [sym_constant] = ACTIONS(133),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(955), 27,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(957), 35,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [70] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(959), 27,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(961), 35,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [140] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(963), 27,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(965), 35,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [210] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(967), 27,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(969), 35,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [280] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(971), 26,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(973), 35,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [349] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(975), 26,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(977), 35,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [418] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(979), 26,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(981), 35,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [487] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(983), 26,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(985), 35,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [556] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(991), 1,
      anon_sym_else,
    STATE(179), 1,
      aux_sym_if_repeat1,
    STATE(186), 1,
      sym_else_if,
    STATE(253), 1,
      sym_else,
    ACTIONS(987), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(989), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [633] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(993), 26,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(995), 35,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [702] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(997), 26,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(999), 35,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [771] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1001), 26,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1003), 35,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [840] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1005), 26,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1007), 35,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [909] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1009), 26,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1011), 35,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [978] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1013), 26,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1015), 35,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [1047] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(991), 1,
      anon_sym_else,
    STATE(170), 1,
      aux_sym_if_repeat1,
    STATE(186), 1,
      sym_else_if,
    STATE(209), 1,
      sym_else,
    ACTIONS(1017), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1019), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [1124] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1025), 1,
      anon_sym_EQ,
    ACTIONS(1027), 1,
      anon_sym_LPAREN2,
    STATE(244), 1,
      sym_call_arguments,
    ACTIONS(1021), 22,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1023), 35,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [1198] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1033), 1,
      anon_sym_else,
    STATE(179), 1,
      aux_sym_if_repeat1,
    STATE(186), 1,
      sym_else_if,
    ACTIONS(1029), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1031), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [1272] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1040), 1,
      anon_sym_LPAREN,
    ACTIONS(1042), 1,
      anon_sym_DASH_GT,
    STATE(172), 1,
      sym__returns,
    STATE(182), 1,
      sym_fn_type_arguments,
    ACTIONS(1036), 22,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1038), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [1348] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(318), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN2,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(332), 36,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [1415] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1042), 1,
      anon_sym_DASH_GT,
    STATE(167), 1,
      sym__returns,
    ACTIONS(1044), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1046), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [1486] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1048), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1050), 35,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_else,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [1552] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(318), 1,
      anon_sym_LPAREN2,
    ACTIONS(1052), 22,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1054), 35,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [1620] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(320), 1,
      anon_sym_LPAREN2,
    ACTIONS(308), 22,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(310), 35,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [1688] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1056), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1058), 35,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_else,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [1754] = 4,
    ACTIONS(1060), 1,
      ts_builtin_sym_end,
    ACTIONS(1064), 1,
      aux_sym_return_token1,
    ACTIONS(1066), 1,
      sym_line_comment,
    ACTIONS(1062), 56,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_DQUOTE,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_LBRACE,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_float,
      sym_integer,
      anon_sym_SQUOTE,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
      sym_field,
      sym_constant,
  [1822] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1072), 1,
      anon_sym_LBRACK,
    STATE(202), 1,
      sym_type_arguments,
    ACTIONS(1068), 22,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1070), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [1892] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(318), 1,
      anon_sym_LPAREN2,
    ACTIONS(308), 22,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(310), 35,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [1960] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1074), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1076), 35,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_else,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [2026] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1078), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1080), 35,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_else,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [2092] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1082), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1084), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [2157] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1092), 1,
      anon_sym_as,
    ACTIONS(1094), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1098), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1086), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1096), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1088), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [2232] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1092), 1,
      anon_sym_as,
    ACTIONS(1094), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1098), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1100), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1096), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1102), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [2307] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1104), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1106), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [2372] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1108), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1110), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [2437] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1112), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1114), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [2502] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1092), 1,
      anon_sym_as,
    ACTIONS(1098), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1116), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1096), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1118), 28,
      anon_sym_import,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [2575] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1120), 22,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1122), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [2642] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1124), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1126), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [2707] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1128), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1130), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [2772] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1132), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1134), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [2837] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1136), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1138), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [2902] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1140), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1142), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [2967] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1144), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1146), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [3032] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1148), 22,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1150), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [3099] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1152), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1154), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [3164] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1156), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1158), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [3229] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1160), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1162), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [3294] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1164), 22,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1166), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [3361] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1168), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1170), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [3426] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1172), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1174), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [3491] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1092), 1,
      anon_sym_as,
    ACTIONS(1094), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1098), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1176), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1096), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1178), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [3566] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1180), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1182), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [3631] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1184), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1186), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [3696] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1188), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1190), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [3761] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1192), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1194), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [3826] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1196), 1,
      anon_sym_else,
    STATE(221), 1,
      aux_sym_if_repeat1,
    STATE(268), 1,
      sym_else_if,
    STATE(317), 1,
      sym_else,
    ACTIONS(1017), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1019), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [3899] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1092), 1,
      anon_sym_as,
    ACTIONS(1094), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1098), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1198), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1096), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1200), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [3974] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1074), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1076), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [4039] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1196), 1,
      anon_sym_else,
    STATE(262), 1,
      aux_sym_if_repeat1,
    STATE(268), 1,
      sym_else_if,
    STATE(292), 1,
      sym_else,
    ACTIONS(987), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(989), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [4112] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1092), 1,
      anon_sym_as,
    ACTIONS(1094), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1098), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1202), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1096), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1204), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [4187] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1092), 1,
      anon_sym_as,
    ACTIONS(1094), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1098), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1206), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1096), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1208), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [4262] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1092), 1,
      anon_sym_as,
    ACTIONS(1094), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1098), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1210), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1096), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1212), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [4337] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1092), 1,
      anon_sym_as,
    ACTIONS(1094), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1098), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1214), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1096), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1216), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [4412] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1218), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1220), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [4477] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1092), 1,
      anon_sym_as,
    ACTIONS(1094), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1098), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1222), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1096), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1224), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [4552] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1226), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1228), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [4617] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1230), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1232), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [4682] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1092), 1,
      anon_sym_as,
    ACTIONS(1094), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1098), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1234), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1096), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1236), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [4757] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1092), 1,
      anon_sym_as,
    ACTIONS(1094), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1098), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1238), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1096), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1240), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [4832] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1242), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1244), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [4897] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1246), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1248), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [4962] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1250), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1252), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [5027] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1254), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1256), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [5092] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1258), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1260), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [5157] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1092), 1,
      anon_sym_as,
    ACTIONS(1094), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1098), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1262), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1096), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1264), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [5232] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1092), 1,
      anon_sym_as,
    ACTIONS(1094), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1098), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1266), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1096), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1268), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [5307] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1092), 1,
      anon_sym_as,
    ACTIONS(1094), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1098), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1270), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1096), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1272), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [5382] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1078), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1080), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [5447] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1274), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1276), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [5512] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1278), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1280), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [5577] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1282), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1284), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [5642] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1286), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1288), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [5707] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1290), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1292), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [5772] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1092), 1,
      anon_sym_as,
    ACTIONS(1094), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1098), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1294), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1096), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1296), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [5847] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1298), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1300), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [5912] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1302), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1304), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [5977] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1306), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1308), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [6042] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1310), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1312), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [6107] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1092), 1,
      anon_sym_as,
    ACTIONS(1094), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1098), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1314), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1096), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1316), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [6182] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1318), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1320), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [6247] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1322), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1324), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [6312] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1326), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1328), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [6377] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1330), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1332), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [6442] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1334), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1336), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [6507] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1092), 1,
      anon_sym_as,
    ACTIONS(1094), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1098), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1338), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1096), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1340), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [6582] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1092), 1,
      anon_sym_as,
    ACTIONS(1094), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1098), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1342), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1096), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1344), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [6657] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1090), 1,
      anon_sym_DOT,
    ACTIONS(1092), 1,
      anon_sym_as,
    ACTIONS(1094), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1098), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1346), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1096), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1348), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [6732] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1350), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1352), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [6797] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1354), 1,
      anon_sym_EQ,
    ACTIONS(1356), 1,
      anon_sym_LPAREN2,
    STATE(288), 1,
      sym_call_arguments,
    ACTIONS(1021), 22,
      anon_sym_DOT,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1023), 31,
      anon_sym_LPAREN,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [6867] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1358), 1,
      anon_sym_else,
    STATE(262), 1,
      aux_sym_if_repeat1,
    STATE(268), 1,
      sym_else_if,
    ACTIONS(1029), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1031), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [6937] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1361), 1,
      anon_sym_LPAREN,
    ACTIONS(1363), 1,
      anon_sym_DASH_GT,
    STATE(265), 1,
      sym_fn_type_arguments,
    STATE(322), 1,
      sym__returns,
    ACTIONS(1036), 22,
      anon_sym_DOT,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1038), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [7009] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(318), 23,
      anon_sym_DOT,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN2,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(332), 32,
      anon_sym_LPAREN,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [7072] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1363), 1,
      anon_sym_DASH_GT,
    STATE(296), 1,
      sym__returns,
    ACTIONS(1044), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1046), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [7139] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(320), 1,
      anon_sym_LPAREN2,
    ACTIONS(308), 22,
      anon_sym_DOT,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(310), 31,
      anon_sym_LPAREN,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [7203] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(318), 1,
      anon_sym_LPAREN2,
    ACTIONS(1052), 22,
      anon_sym_DOT,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1054), 31,
      anon_sym_LPAREN,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [7267] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1056), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1058), 31,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_else,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [7329] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(967), 24,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(969), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [7391] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(963), 24,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(965), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [7453] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1048), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1050), 31,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_else,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [7515] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(959), 24,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(961), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [7577] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(318), 1,
      anon_sym_LPAREN2,
    ACTIONS(308), 22,
      anon_sym_DOT,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(310), 31,
      anon_sym_LPAREN,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [7641] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1074), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1076), 31,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_else,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [7703] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1078), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1080), 31,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_else,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [7765] = 3,
    ACTIONS(1066), 1,
      sym_line_comment,
    ACTIONS(1365), 1,
      aux_sym_return_token1,
    ACTIONS(1062), 53,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_DQUOTE,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_mut,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_float,
      sym_integer,
      anon_sym_SQUOTE,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
      sym_field,
      sym_constant,
  [7827] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(955), 24,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(957), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [7889] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1367), 1,
      anon_sym_LBRACK,
    STATE(346), 1,
      sym_type_arguments,
    ACTIONS(1068), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1070), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [7955] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1290), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1292), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [8016] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1009), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1011), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [8077] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1218), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1220), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [8138] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1226), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1228), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [8199] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1230), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1232), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [8260] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1246), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1248), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [8321] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1369), 1,
      anon_sym_DOT,
    ACTIONS(1371), 1,
      anon_sym_as,
    ACTIONS(1373), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1377), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1266), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1375), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1268), 22,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [8392] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1136), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1138), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [8453] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1274), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1276), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [8514] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1286), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1288), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [8575] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1298), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1300), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [8636] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1306), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1308), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [8697] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1318), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1320), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [8758] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1322), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1324), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [8819] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1369), 1,
      anon_sym_DOT,
    ACTIONS(1371), 1,
      anon_sym_as,
    ACTIONS(1377), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1116), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1375), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1118), 24,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [8888] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1013), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1015), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [8949] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1369), 1,
      anon_sym_DOT,
    ACTIONS(1120), 22,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1122), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [9012] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(975), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(977), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [9073] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1350), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1352), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [9134] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1184), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1186), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [9195] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1369), 1,
      anon_sym_DOT,
    ACTIONS(1371), 1,
      anon_sym_as,
    ACTIONS(1373), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1377), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1100), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1375), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1102), 22,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [9266] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1144), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1146), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [9327] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1104), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1106), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [9388] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1108), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1110), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [9449] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1369), 1,
      anon_sym_DOT,
    ACTIONS(1148), 22,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1150), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [9512] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1369), 1,
      anon_sym_DOT,
    ACTIONS(1164), 22,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1166), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [9575] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1180), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1182), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [9636] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1082), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1084), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [9697] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(983), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(985), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [9758] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1124), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1126), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [9819] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1369), 1,
      anon_sym_DOT,
    ACTIONS(1371), 1,
      anon_sym_as,
    ACTIONS(1373), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1377), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1198), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1375), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1200), 22,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [9890] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1152), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1154), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [9951] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1250), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1252), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [10012] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1258), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1260), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [10073] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1140), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1142), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [10134] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(979), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(981), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [10195] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1369), 1,
      anon_sym_DOT,
    ACTIONS(1371), 1,
      anon_sym_as,
    ACTIONS(1373), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1377), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1342), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1375), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1344), 22,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [10266] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1156), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1158), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [10327] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1160), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1162), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [10388] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1369), 1,
      anon_sym_DOT,
    ACTIONS(1371), 1,
      anon_sym_as,
    ACTIONS(1373), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1377), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1381), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1375), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1379), 22,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [10459] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1128), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1130), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [10520] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1254), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1256), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [10581] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(993), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(995), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [10642] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(997), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(999), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [10703] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1369), 1,
      anon_sym_DOT,
    ACTIONS(1371), 1,
      anon_sym_as,
    ACTIONS(1373), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1377), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1086), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1375), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1088), 22,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [10774] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1172), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1174), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [10835] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1369), 1,
      anon_sym_DOT,
    ACTIONS(1371), 1,
      anon_sym_as,
    ACTIONS(1373), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1377), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1176), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1375), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1178), 22,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [10906] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1074), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1076), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [10967] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1369), 1,
      anon_sym_DOT,
    ACTIONS(1371), 1,
      anon_sym_as,
    ACTIONS(1373), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1377), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1214), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1375), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1216), 22,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [11038] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1369), 1,
      anon_sym_DOT,
    ACTIONS(1371), 1,
      anon_sym_as,
    ACTIONS(1373), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1377), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1222), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1375), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1224), 22,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [11109] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1369), 1,
      anon_sym_DOT,
    ACTIONS(1371), 1,
      anon_sym_as,
    ACTIONS(1373), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1377), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1234), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1375), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1236), 22,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [11180] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1369), 1,
      anon_sym_DOT,
    ACTIONS(1371), 1,
      anon_sym_as,
    ACTIONS(1373), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1377), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1238), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1375), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1240), 22,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [11251] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1242), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1244), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [11312] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1112), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1114), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [11373] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1326), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1328), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [11434] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1302), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1304), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [11495] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1310), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1312), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [11556] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1334), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1336), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [11617] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1330), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1332), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [11678] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1001), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1003), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [11739] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(971), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(973), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [11800] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1278), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1280), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [11861] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1282), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1284), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [11922] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1369), 1,
      anon_sym_DOT,
    ACTIONS(1371), 1,
      anon_sym_as,
    ACTIONS(1373), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1377), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1346), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1375), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1348), 22,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [11993] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1188), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1190), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [12054] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1078), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1080), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [12115] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1005), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1007), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [12176] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1132), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1134), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [12237] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1369), 1,
      anon_sym_DOT,
    ACTIONS(1371), 1,
      anon_sym_as,
    ACTIONS(1373), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1377), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1314), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1375), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1316), 22,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [12308] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1192), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1194), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [12369] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1369), 1,
      anon_sym_DOT,
    ACTIONS(1371), 1,
      anon_sym_as,
    ACTIONS(1373), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1377), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1202), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1375), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1204), 22,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [12440] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1369), 1,
      anon_sym_DOT,
    ACTIONS(1371), 1,
      anon_sym_as,
    ACTIONS(1373), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1377), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1206), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1375), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1208), 22,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [12511] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1369), 1,
      anon_sym_DOT,
    ACTIONS(1371), 1,
      anon_sym_as,
    ACTIONS(1373), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1377), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1210), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1375), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1212), 22,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [12582] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1369), 1,
      anon_sym_DOT,
    ACTIONS(1371), 1,
      anon_sym_as,
    ACTIONS(1373), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1377), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1338), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1375), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1340), 22,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [12653] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1168), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1170), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [12714] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(318), 1,
      anon_sym_LPAREN2,
    ACTIONS(1383), 1,
      anon_sym_EQ,
    ACTIONS(1385), 1,
      anon_sym_COLON_EQ,
    ACTIONS(1387), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(308), 13,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_or,
    ACTIONS(310), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
  [12772] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1389), 1,
      anon_sym_EQ,
    ACTIONS(1391), 1,
      anon_sym_COLON_EQ,
    ACTIONS(1393), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(308), 13,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_or,
    ACTIONS(310), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
  [12827] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1395), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(318), 14,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN2,
      anon_sym_or,
    ACTIONS(332), 15,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ,
  [12878] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1395), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(320), 14,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN2,
      anon_sym_or,
    ACTIONS(322), 15,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ,
  [12929] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(318), 1,
      anon_sym_LPAREN2,
    ACTIONS(1397), 1,
      anon_sym_EQ,
    ACTIONS(1399), 1,
      anon_sym_COLON_EQ,
    ACTIONS(308), 11,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
    ACTIONS(1401), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(310), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
  [12985] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(318), 1,
      anon_sym_LPAREN2,
    ACTIONS(1383), 1,
      anon_sym_EQ,
    ACTIONS(1385), 1,
      anon_sym_COLON_EQ,
    ACTIONS(1403), 1,
      anon_sym_COLON,
    ACTIONS(308), 10,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_or,
    ACTIONS(1387), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(310), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
  [13043] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(318), 12,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_LPAREN2,
      anon_sym_or,
    ACTIONS(1405), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(332), 15,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ,
  [13092] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1411), 1,
      anon_sym_LPAREN,
    ACTIONS(1413), 1,
      anon_sym_DASH_GT,
    ACTIONS(1415), 1,
      anon_sym_LBRACE,
    STATE(366), 1,
      sym_extern_arguments,
    STATE(386), 1,
      sym__returns,
    STATE(492), 1,
      sym_block,
    ACTIONS(1407), 7,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1409), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13151] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1411), 1,
      anon_sym_LPAREN,
    ACTIONS(1413), 1,
      anon_sym_DASH_GT,
    ACTIONS(1415), 1,
      anon_sym_LBRACE,
    STATE(367), 1,
      sym_extern_arguments,
    STATE(396), 1,
      sym__returns,
    STATE(491), 1,
      sym_block,
    ACTIONS(1417), 7,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1419), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13210] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(320), 12,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_LPAREN2,
      anon_sym_or,
    ACTIONS(1405), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(322), 15,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ,
  [13259] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1128), 13,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_EQ,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1130), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13306] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1421), 1,
      anon_sym_EQ,
    ACTIONS(1423), 1,
      anon_sym_COLON_EQ,
    ACTIONS(308), 11,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
    ACTIONS(1425), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(310), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
  [13359] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1413), 1,
      anon_sym_DASH_GT,
    ACTIONS(1415), 1,
      anon_sym_LBRACE,
    STATE(395), 1,
      sym__returns,
    STATE(486), 1,
      sym_block,
    ACTIONS(1427), 8,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1429), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13413] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1413), 1,
      anon_sym_DASH_GT,
    ACTIONS(1415), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym__returns,
    STATE(402), 1,
      sym_block,
    ACTIONS(1431), 8,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1433), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13467] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1413), 1,
      anon_sym_DASH_GT,
    ACTIONS(1435), 1,
      anon_sym_LPAREN,
    STATE(375), 1,
      sym_fn_type_arguments,
    STATE(420), 1,
      sym__returns,
    ACTIONS(1036), 8,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1038), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13521] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1441), 1,
      anon_sym_DOT,
    STATE(372), 1,
      aux_sym_path_repeat1,
    ACTIONS(1437), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1439), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13570] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1441), 1,
      anon_sym_DOT,
    STATE(369), 1,
      aux_sym_path_repeat1,
    ACTIONS(1443), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1445), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13619] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1451), 1,
      anon_sym_and,
    STATE(371), 1,
      aux_sym_tags_repeat1,
    ACTIONS(1447), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1449), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13668] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1458), 1,
      anon_sym_DOT,
    STATE(372), 1,
      aux_sym_path_repeat1,
    ACTIONS(1454), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1456), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13717] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1465), 1,
      anon_sym_and,
    STATE(376), 1,
      aux_sym_tags_repeat1,
    ACTIONS(1461), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1463), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13766] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1471), 1,
      anon_sym_LPAREN,
    ACTIONS(1473), 1,
      anon_sym_if,
    STATE(390), 1,
      sym_symbols,
    STATE(476), 1,
      sym_tags,
    ACTIONS(1467), 8,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1469), 25,
      anon_sym_import,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13819] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1413), 1,
      anon_sym_DASH_GT,
    STATE(428), 1,
      sym__returns,
    ACTIONS(1044), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1046), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13868] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1465), 1,
      anon_sym_and,
    STATE(371), 1,
      aux_sym_tags_repeat1,
    ACTIONS(1475), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1477), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13917] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1479), 10,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1481), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13961] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1447), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1449), 27,
      anon_sym_import,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14005] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1454), 10,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1456), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14049] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1483), 10,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1485), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14093] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1487), 1,
      anon_sym_LBRACK,
    STATE(418), 1,
      sym_type_arguments,
    ACTIONS(1068), 8,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1070), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14141] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1415), 1,
      anon_sym_LBRACE,
    STATE(458), 1,
      sym_block,
    ACTIONS(1489), 8,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1491), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14189] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(967), 10,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(969), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14233] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(955), 10,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(957), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14277] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(959), 10,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(961), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14321] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1415), 1,
      anon_sym_LBRACE,
    STATE(487), 1,
      sym_block,
    ACTIONS(1493), 8,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1495), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14369] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1497), 10,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1499), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14413] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(963), 10,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(965), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14457] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1473), 1,
      anon_sym_if,
    STATE(431), 1,
      sym_tags,
    ACTIONS(1501), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1503), 25,
      anon_sym_import,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14505] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1473), 1,
      anon_sym_if,
    STATE(400), 1,
      sym_tags,
    ACTIONS(1505), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1507), 25,
      anon_sym_import,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14553] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1509), 10,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1511), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14597] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1513), 10,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1515), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14641] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1517), 10,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1519), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14685] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1521), 10,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1523), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14729] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1415), 1,
      anon_sym_LBRACE,
    STATE(436), 1,
      sym_block,
    ACTIONS(1525), 8,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1527), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14777] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1415), 1,
      anon_sym_LBRACE,
    STATE(403), 1,
      sym_block,
    ACTIONS(1529), 8,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1531), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14825] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1152), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1154), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14868] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1533), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1535), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14911] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1537), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1539), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14954] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1541), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1543), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14997] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1545), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1547), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15040] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1549), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1551), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15083] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1553), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1555), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15126] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1557), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1559), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15169] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1561), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1563), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15212] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1565), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1567), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15255] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1569), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1571), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15298] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1573), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1575), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15341] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1577), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1579), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15384] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1581), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1583), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15427] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1585), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1587), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15470] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1589), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1591), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15513] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1593), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1595), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15556] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1597), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1599), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15599] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1601), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1603), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15642] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1605), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1607), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15685] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1609), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1611), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15728] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1132), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1134), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15771] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(993), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(995), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15814] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(997), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(999), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15857] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1613), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1615), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15900] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1001), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1003), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15943] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(971), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(973), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15986] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1005), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1007), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16029] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1009), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1011), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16072] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1136), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1138), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16115] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1013), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1015), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16158] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(975), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(977), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16201] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1144), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1146), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16244] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(983), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(985), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16287] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1617), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1619), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16330] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1621), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1623), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16373] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(979), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(981), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16416] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1625), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1627), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16459] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1156), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1158), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16502] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1629), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1631), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16545] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1074), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1076), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16588] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1078), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1080), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16631] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1633), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1635), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16674] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1637), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1639), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16717] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1641), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1643), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16760] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1645), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1647), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16803] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1649), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1651), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16846] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1653), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1655), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16889] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1657), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1659), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16932] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1661), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1663), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16975] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1665), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1667), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17018] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1669), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1671), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17061] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1673), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1675), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17104] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1677), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1679), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17147] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1681), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1683), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17190] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1685), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1687), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17233] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1689), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1691), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17276] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1693), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1695), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17319] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1697), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1699), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17362] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1701), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1703), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17405] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1705), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1707), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17448] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1709), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1711), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17491] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1713), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1715), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17534] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1717), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1719), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17577] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1721), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1723), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17620] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1725), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1727), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17663] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1729), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1731), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17706] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1733), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1735), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17749] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1737), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1739), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17792] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1741), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1743), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17835] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1745), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1747), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17878] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1749), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1751), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17921] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1753), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1755), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17964] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1757), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1759), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18007] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1761), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1763), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18050] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1765), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1767), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18093] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1769), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1771), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18136] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1773), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1775), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18179] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1779), 1,
      sym_identifier,
    ACTIONS(1777), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1781), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier_with_special,
  [18224] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1783), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1785), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18267] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1787), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1789), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18310] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1791), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1793), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18353] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1795), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1797), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18396] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1799), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1801), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18439] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1803), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1805), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18482] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1807), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1809), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18525] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1811), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1813), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18568] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1815), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1817), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18611] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1819), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1821), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18654] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1823), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1825), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18697] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1827), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1829), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18740] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1831), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1833), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18783] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1835), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1837), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18826] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1839), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1841), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18869] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1843), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1845), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18912] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1847), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1849), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_type,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_for,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18955] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1851), 1,
      anon_sym_LPAREN,
    ACTIONS(1853), 1,
      anon_sym_DASH_GT,
    STATE(507), 1,
      sym_fn_type_arguments,
    STATE(515), 1,
      sym__returns,
    ACTIONS(1038), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1036), 25,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [19005] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1855), 1,
      anon_sym_LBRACK,
    STATE(495), 1,
      sym_type_arguments,
    ACTIONS(1070), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1068), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [19050] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1134), 6,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_EQ,
    ACTIONS(1132), 27,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_for,
      anon_sym_or,
  [19091] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1158), 6,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_EQ,
    ACTIONS(1156), 27,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_for,
      anon_sym_or,
  [19132] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1865), 1,
      sym_visibility,
    STATE(650), 1,
      sym__method_modifier,
    STATE(776), 1,
      sym_method_name,
    ACTIONS(1857), 5,
      aux_sym_method_name_token1,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1863), 5,
      anon_sym_asyncmut,
      anon_sym_inlinemut,
      anon_sym_inlinemove,
      anon_sym_inlinestatic,
      anon_sym_inlineasyncmut,
    ACTIONS(1861), 6,
      anon_sym_mut,
      anon_sym_move,
      anon_sym_static,
      anon_sym_async,
      anon_sym_inline,
      anon_sym_inlineasync,
    ACTIONS(1859), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [19183] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1867), 1,
      anon_sym_else,
    STATE(503), 1,
      aux_sym_if_repeat1,
    STATE(528), 1,
      sym_else_if,
    STATE(547), 1,
      sym_else,
    ACTIONS(989), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(987), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [19232] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1154), 6,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_EQ,
    ACTIONS(1152), 27,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_for,
      anon_sym_or,
  [19273] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1146), 6,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_EQ,
    ACTIONS(1144), 27,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_for,
      anon_sym_or,
  [19314] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1867), 1,
      anon_sym_else,
    STATE(498), 1,
      aux_sym_if_repeat1,
    STATE(528), 1,
      sym_else_if,
    STATE(537), 1,
      sym_else,
    ACTIONS(1019), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1017), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [19363] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1138), 6,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_EQ,
    ACTIONS(1136), 27,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_for,
      anon_sym_or,
  [19404] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1869), 1,
      anon_sym_else,
    STATE(503), 1,
      aux_sym_if_repeat1,
    STATE(528), 1,
      sym_else_if,
    ACTIONS(1031), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1029), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [19450] = 16,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(1872), 1,
      anon_sym_LPAREN,
    ACTIONS(1874), 1,
      anon_sym_extern,
    ACTIONS(1876), 1,
      anon_sym_DASH_GT,
    ACTIONS(1878), 1,
      anon_sym_move,
    ACTIONS(1880), 1,
      anon_sym_inline,
    ACTIONS(1882), 1,
      sym_visibility,
    STATE(211), 1,
      sym_block,
    STATE(654), 1,
      sym_inline,
    STATE(778), 1,
      sym_method_name,
    STATE(829), 1,
      sym_move,
    STATE(983), 1,
      sym_closure_arguments,
    STATE(1095), 1,
      sym__returns,
    ACTIONS(1857), 6,
      aux_sym_method_name_token1,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1859), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [19516] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(661), 1,
      sym__method_modifier,
    STATE(792), 1,
      sym_method_name,
    ACTIONS(1857), 5,
      aux_sym_method_name_token1,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1863), 5,
      anon_sym_asyncmut,
      anon_sym_inlinemut,
      anon_sym_inlinemove,
      anon_sym_inlinestatic,
      anon_sym_inlineasyncmut,
    ACTIONS(1861), 6,
      anon_sym_mut,
      anon_sym_move,
      anon_sym_static,
      anon_sym_async,
      anon_sym_inline,
      anon_sym_inlineasync,
    ACTIONS(1859), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [19564] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1080), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1078), 27,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_else,
      anon_sym_or,
  [19604] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1853), 1,
      anon_sym_DASH_GT,
    STATE(510), 1,
      sym__returns,
    ACTIONS(1046), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1044), 25,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [19648] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1076), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1074), 27,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_else,
      anon_sym_or,
  [19688] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(969), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(967), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [19727] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(977), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(975), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [19766] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1332), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1330), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_in,
      anon_sym_or,
  [19805] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(332), 6,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_EQ,
    ACTIONS(318), 25,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_LPAREN2,
      anon_sym_or,
  [19844] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1130), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1128), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [19883] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(995), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(993), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [19922] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(999), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(997), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [19961] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(985), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(983), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [20000] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(965), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(963), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [20039] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(961), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(959), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [20078] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1011), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1009), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [20117] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1015), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1013), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [20156] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1003), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1001), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [20195] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1256), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1254), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_in,
      anon_sym_or,
  [20234] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1007), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1005), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [20273] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(957), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(955), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [20312] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(981), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(979), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [20351] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(973), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(971), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [20390] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1884), 1,
      anon_sym_EQ,
    ACTIONS(1886), 1,
      anon_sym_LPAREN2,
    STATE(543), 1,
      sym_call_arguments,
    ACTIONS(1023), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1021), 22,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_or,
  [20434] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1058), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1056), 25,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_else,
      anon_sym_or,
  [20472] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(320), 1,
      anon_sym_LPAREN2,
    ACTIONS(310), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(308), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [20512] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(318), 1,
      anon_sym_LPAREN2,
    ACTIONS(310), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(308), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [20552] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(318), 1,
      anon_sym_LPAREN2,
    ACTIONS(1054), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1052), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [20592] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1050), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1048), 25,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_else,
      anon_sym_or,
  [20630] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1110), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1108), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [20667] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1194), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1192), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [20704] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1126), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1124), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [20741] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1142), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1140), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [20778] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1162), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1160), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [20815] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1220), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1218), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [20852] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1228), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1226), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [20889] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1232), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1230), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [20926] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1248), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1246), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [20963] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1276), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1274), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [21000] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1288), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1286), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [21037] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1300), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1298), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [21074] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1308), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1306), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [21111] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1320), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1318), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [21148] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1324), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1322), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [21185] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1352), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1350), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [21222] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1186), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1184), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [21259] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1106), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1104), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      an