#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 227
#define LARGE_STATE_COUNT 11
#define SYMBOL_COUNT 78
#define ALIAS_COUNT 3
#define TOKEN_COUNT 50
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 1
#define MAX_ALIAS_SEQUENCE_LENGTH 4
#define PRODUCTION_ID_COUNT 5

enum {
  anon_sym_datasource = 1,
  anon_sym_model = 2,
  anon_sym_view = 3,
  anon_sym_generator = 4,
  anon_sym_type = 5,
  anon_sym_enum = 6,
  sym_developer_comment = 7,
  aux_sym_comment_token1 = 8,
  anon_sym_LBRACE = 9,
  anon_sym_RBRACE = 10,
  anon_sym_EQ = 11,
  anon_sym_AMP_AMP = 12,
  anon_sym_PIPE_PIPE = 13,
  anon_sym_GT_GT = 14,
  anon_sym_GT_GT_GT = 15,
  anon_sym_LT_LT = 16,
  anon_sym_AMP = 17,
  anon_sym_CARET = 18,
  anon_sym_PIPE = 19,
  anon_sym_PLUS = 20,
  anon_sym_DASH = 21,
  anon_sym_STAR = 22,
  anon_sym_SLASH = 23,
  anon_sym_PERCENT = 24,
  anon_sym_STAR_STAR = 25,
  anon_sym_LT = 26,
  anon_sym_LT_EQ = 27,
  anon_sym_EQ_EQ = 28,
  anon_sym_EQ_EQ_EQ = 29,
  anon_sym_BANG_EQ = 30,
  anon_sym_BANG_EQ_EQ = 31,
  anon_sym_GT_EQ = 32,
  anon_sym_GT = 33,
  anon_sym_DOT = 34,
  anon_sym_COLON = 35,
  anon_sym_AT = 36,
  anon_sym_AT_AT = 37,
  anon_sym_LPAREN = 38,
  anon_sym_COMMA = 39,
  anon_sym_RPAREN = 40,
  aux_sym_identifier_token1 = 41,
  sym_string = 42,
  sym_number = 43,
  anon_sym_LBRACK = 44,
  anon_sym_RBRACK = 45,
  sym_maybe = 46,
  sym_true = 47,
  sym_false = 48,
  sym_null = 49,
  sym_program = 50,
  sym_datasource_declaration = 51,
  sym_model_declaration = 52,
  sym_view_declaration = 53,
  sym_generator_declaration = 54,
  sym_type_declaration = 55,
  sym_enum_declaration = 56,
  sym_comment = 57,
  sym_statement_block = 58,
  sym_enum_block = 59,
  sym_column_declaration = 60,
  sym_assignment_expression = 61,
  sym_binary_expression = 62,
  sym_member_expression = 63,
  sym_column_type = 64,
  sym_type_expression = 65,
  sym_call_expression = 66,
  sym_attribute = 67,
  sym_block_attribute_declaration = 68,
  sym_arguments = 69,
  sym_identifier = 70,
  sym_enumeral = 71,
  sym_array = 72,
  aux_sym_program_repeat1 = 73,
  aux_sym_type_declaration_repeat1 = 74,
  aux_sym_statement_block_repeat1 = 75,
  aux_sym_enum_block_repeat1 = 76,
  aux_sym_arguments_repeat1 = 77,
  alias_sym_property_identifier = 78,
  alias_sym_type_declaration_type = 79,
  alias_sym_variable = 80,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_datasource] = "datasource",
  [anon_sym_model] = "model",
  [anon_sym_view] = "view",
  [anon_sym_generator] = "generator",
  [anon_sym_type] = "type",
  [anon_sym_enum] = "enum",
  [sym_developer_comment] = "developer_comment",
  [aux_sym_comment_token1] = "comment_token1",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_EQ] = "=",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_DOT] = ".",
  [anon_sym_COLON] = ":",
  [anon_sym_AT] = "@",
  [anon_sym_AT_AT] = "@@",
  [anon_sym_LPAREN] = "(",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [aux_sym_identifier_token1] = "identifier_token1",
  [sym_string] = "string",
  [sym_number] = "number",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [sym_maybe] = "maybe",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_program] = "program",
  [sym_datasource_declaration] = "datasource_declaration",
  [sym_model_declaration] = "model_declaration",
  [sym_view_declaration] = "view_declaration",
  [sym_generator_declaration] = "generator_declaration",
  [sym_type_declaration] = "type_declaration",
  [sym_enum_declaration] = "enum_declaration",
  [sym_comment] = "comment",
  [sym_statement_block] = "statement_block",
  [sym_enum_block] = "enum_block",
  [sym_column_declaration] = "column_declaration",
  [sym_assignment_expression] = "assignment_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_member_expression] = "member_expression",
  [sym_column_type] = "column_type",
  [sym_type_expression] = "type_expression",
  [sym_call_expression] = "call_expression",
  [sym_attribute] = "attribute",
  [sym_block_attribute_declaration] = "block_attribute_declaration",
  [sym_arguments] = "arguments",
  [sym_identifier] = "identifier",
  [sym_enumeral] = "enumeral",
  [sym_array] = "array",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_type_declaration_repeat1] = "type_declaration_repeat1",
  [aux_sym_statement_block_repeat1] = "statement_block_repeat1",
  [aux_sym_enum_block_repeat1] = "enum_block_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [alias_sym_property_identifier] = "property_identifier",
  [alias_sym_type_declaration_type] = "type_declaration_type",
  [alias_sym_variable] = "variable",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_datasource] = anon_sym_datasource,
  [anon_sym_model] = anon_sym_model,
  [anon_sym_view] = anon_sym_view,
  [anon_sym_generator] = anon_sym_generator,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_enum] = anon_sym_enum,
  [sym_developer_comment] = sym_developer_comment,
  [aux_sym_comment_token1] = aux_sym_comment_token1,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_AT_AT] = anon_sym_AT_AT,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [aux_sym_identifier_token1] = aux_sym_identifier_token1,
  [sym_string] = sym_string,
  [sym_number] = sym_number,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [sym_maybe] = sym_maybe,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_program] = sym_program,
  [sym_datasource_declaration] = sym_datasource_declaration,
  [sym_model_declaration] = sym_model_declaration,
  [sym_view_declaration] = sym_view_declaration,
  [sym_generator_declaration] = sym_generator_declaration,
  [sym_type_declaration] = sym_type_declaration,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_comment] = sym_comment,
  [sym_statement_block] = sym_statement_block,
  [sym_enum_block] = sym_enum_block,
  [sym_column_declaration] = sym_column_declaration,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_column_type] = sym_column_type,
  [sym_type_expression] = sym_type_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_attribute] = sym_attribute,
  [sym_block_attribute_declaration] = sym_block_attribute_declaration,
  [sym_arguments] = sym_arguments,
  [sym_identifier] = sym_identifier,
  [sym_enumeral] = sym_enumeral,
  [sym_array] = sym_array,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_type_declaration_repeat1] = aux_sym_type_declaration_repeat1,
  [aux_sym_statement_block_repeat1] = aux_sym_statement_block_repeat1,
  [aux_sym_enum_block_repeat1] = aux_sym_enum_block_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
  [alias_sym_type_declaration_type] = alias_sym_type_declaration_type,
  [alias_sym_variable] = alias_sym_variable,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_datasource] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_model] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_view] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_generator] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [sym_developer_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_comment_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_identifier_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym_maybe] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_datasource_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_model_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_view_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_block] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_block] = {
    .visible = true,
    .named = true,
  },
  [sym_column_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_column_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_block_attribute_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_enumeral] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_declaration_type] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_variable] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_operator = 1,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_operator] = "operator",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [4] = {.index = 0, .length = 1},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_operator, 1},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [2] = alias_sym_type_declaration_type,
  },
  [2] = {
    [0] = alias_sym_variable,
  },
  [3] = {
    [2] = alias_sym_property_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_identifier, 4,
    sym_identifier,
    alias_sym_property_identifier,
    alias_sym_type_declaration_type,
    alias_sym_variable,
  0,
};

static inline bool aux_sym_identifier_token1_character_set_1(int32_t c) {
  return (c < '{'
    ? (c < '\''
      ? (c < 0
        ? c == 0
        : c <= '#')
      : (c <= '?' || (c < '`'
        ? (c >= '[' && c <= ']')
        : c <= '`')))
    : (c <= '~' || (c < 8239
      ? (c < 8192
        ? c == 5760
        : c <= 8202)
      : (c <= 8239 || (c < 12288
        ? c == 8287
        : c <= 12288)))));
}

static inline bool aux_sym_identifier_token1_character_set_2(int32_t c) {
  return (c < '{'
    ? (c < '.'
      ? (c < 0
        ? c == 0
        : (c <= '#' || (c >= '%' && c <= '+')))
      : (c <= '@' || (c < '`'
        ? c == '^'
        : c <= '`')))
    : (c <= '~' || (c < 8239
      ? (c < 8192
        ? c == 5760
        : c <= 8202)
      : (c <= 8239 || (c < 12288
        ? c == 8287
        : c <= 12288)))));
}

static inline bool aux_sym_identifier_token1_character_set_3(int32_t c) {
  return (c < '|'
    ? (c < '0'
      ? (c < 0
        ? c == 0
        : (c <= '#' || (c >= '%' && c <= ',')))
      : (c <= '>' || (c < '`'
        ? (c >= ']' && c <= '^')
        : c <= '`')))
    : (c <= '~' || (c < 8239
      ? (c < 8192
        ? c == 5760
        : c <= 8202)
      : (c <= 8239 || (c < 12288
        ? c == 8287
        : c <= 12288)))));
}

static inline bool aux_sym_identifier_token1_character_set_4(int32_t c) {
  return (c < '{'
    ? (c < '.'
      ? (c < 0
        ? c == 0
        : (c <= '#' || (c >= '%' && c <= ',')))
      : (c <= '/' || (c < '['
        ? (c >= ':' && c <= '@')
        : (c <= '^' || c == '`'))))
    : (c <= '~' || (c < 8239
      ? (c < 5760
        ? c == 160
        : (c <= 5760 || (c >= 8192 && c <= 8203)))
      : (c <= 8239 || (c < 12288
        ? (c >= 8287 && c <= 8288)
        : (c <= 12288 || c == 65279))))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(58);
      if (lookahead == '!') ADVANCE(8);
      if (lookahead == '"') ADVANCE(3);
      if (lookahead == '%') ADVANCE(84);
      if (lookahead == '&') ADVANCE(76);
      if (lookahead == '\'') ADVANCE(4);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == '*') ADVANCE(82);
      if (lookahead == '+') ADVANCE(79);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '-') ADVANCE(80);
      if (lookahead == '.') ADVANCE(94);
      if (lookahead == '/') ADVANCE(83);
      if (lookahead == ':') ADVANCE(95);
      if (lookahead == '<') ADVANCE(86);
      if (lookahead == '=') ADVANCE(70);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '?') ADVANCE(118);
      if (lookahead == '@') ADVANCE(96);
      if (lookahead == '[') ADVANCE(116);
      if (lookahead == ']') ADVANCE(117);
      if (lookahead == '^') ADVANCE(77);
      if (lookahead == 'd') ADVANCE(10);
      if (lookahead == 'e') ADVANCE(30);
      if (lookahead == 'f') ADVANCE(11);
      if (lookahead == 'g') ADVANCE(22);
      if (lookahead == 'm') ADVANCE(32);
      if (lookahead == 'n') ADVANCE(46);
      if (lookahead == 't') ADVANCE(38);
      if (lookahead == 'v') ADVANCE(24);
      if (lookahead == '{') ADVANCE(67);
      if (lookahead == '|') ADVANCE(78);
      if (lookahead == '}') ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(115);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(8);
      if (lookahead == '%') ADVANCE(84);
      if (lookahead == '&') ADVANCE(76);
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == '*') ADVANCE(82);
      if (lookahead == '+') ADVANCE(79);
      if (lookahead == '-') ADVANCE(81);
      if (lookahead == '.') ADVANCE(94);
      if (lookahead == '/') ADVANCE(83);
      if (lookahead == ':') ADVANCE(95);
      if (lookahead == '<') ADVANCE(86);
      if (lookahead == '=') ADVANCE(70);
      if (lookahead == '>') ADVANCE(93);
      if (lookahead == '@') ADVANCE(9);
      if (lookahead == '\\') ADVANCE(45);
      if (lookahead == '^') ADVANCE(77);
      if (lookahead == '|') ADVANCE(78);
      if (lookahead == '}') ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(1)
      if (!aux_sym_identifier_token1_character_set_1(lookahead)) ADVANCE(111);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(3);
      if (lookahead == '\'') ADVANCE(4);
      if (lookahead == ')') ADVANCE(100);
      if (lookahead == ',') ADVANCE(99);
      if (lookahead == '/') ADVANCE(6);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '[') ADVANCE(116);
      if (lookahead == '\\') ADVANCE(45);
      if (lookahead == ']') ADVANCE(117);
      if (lookahead == 'f') ADVANCE(101);
      if (lookahead == 'n') ADVANCE(110);
      if (lookahead == 't') ADVANCE(107);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(2)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(115);
      if (!aux_sym_identifier_token1_character_set_2(lookahead)) ADVANCE(111);
      END_STATE();
    case 3:
      if (lookahead == '"') ADVANCE(112);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(3);
      END_STATE();
    case 4:
      if (lookahead == '\'') ADVANCE(112);
      if (lookahead == '\\') ADVANCE(57);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(4);
      END_STATE();
    case 5:
      if (lookahead == '(') ADVANCE(98);
      if (lookahead == '.') ADVANCE(94);
      if (lookahead == '/') ADVANCE(6);
      if (lookahead == ':') ADVANCE(95);
      if (lookahead == '=') ADVANCE(69);
      if (lookahead == '?') ADVANCE(118);
      if (lookahead == '@') ADVANCE(96);
      if (lookahead == '[') ADVANCE(116);
      if (lookahead == '\\') ADVANCE(45);
      if (lookahead == '{') ADVANCE(67);
      if (lookahead == '}') ADVANCE(68);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(5)
      if (!aux_sym_identifier_token1_character_set_3(lookahead)) ADVANCE(111);
      END_STATE();
    case 6:
      if (lookahead == '/') ADVANCE(7);
      END_STATE();
    case 7:
      if (lookahead == '/') ADVANCE(66);
      if (lookahead != 0) ADVANCE(65);
      END_STATE();
    case 8:
      if (lookahead == '=') ADVANCE(90);
      END_STATE();
    case 9:
      if (lookahead == '@') ADVANCE(97);
      END_STATE();
    case 10:
      if (lookahead == 'a') ADVANCE(42);
      END_STATE();
    case 11:
      if (lookahead == 'a') ADVANCE(25);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(43);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(40);
      END_STATE();
    case 14:
      if (lookahead == 'c') ADVANCE(21);
      END_STATE();
    case 15:
      if (lookahead == 'd') ADVANCE(23);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(49);
      END_STATE();
    case 17:
      if (lookahead == 'e') ADVANCE(39);
      END_STATE();
    case 18:
      if (lookahead == 'e') ADVANCE(119);
      END_STATE();
    case 19:
      if (lookahead == 'e') ADVANCE(63);
      END_STATE();
    case 20:
      if (lookahead == 'e') ADVANCE(121);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(59);
      END_STATE();
    case 22:
      if (lookahead == 'e') ADVANCE(31);
      END_STATE();
    case 23:
      if (lookahead == 'e') ADVANCE(27);
      END_STATE();
    case 24:
      if (lookahead == 'i') ADVANCE(16);
      END_STATE();
    case 25:
      if (lookahead == 'l') ADVANCE(41);
      END_STATE();
    case 26:
      if (lookahead == 'l') ADVANCE(123);
      END_STATE();
    case 27:
      if (lookahead == 'l') ADVANCE(60);
      END_STATE();
    case 28:
      if (lookahead == 'l') ADVANCE(26);
      END_STATE();
    case 29:
      if (lookahead == 'm') ADVANCE(64);
      END_STATE();
    case 30:
      if (lookahead == 'n') ADVANCE(44);
      END_STATE();
    case 31:
      if (lookahead == 'n') ADVANCE(17);
      END_STATE();
    case 32:
      if (lookahead == 'o') ADVANCE(15);
      END_STATE();
    case 33:
      if (lookahead == 'o') ADVANCE(37);
      END_STATE();
    case 34:
      if (lookahead == 'o') ADVANCE(47);
      END_STATE();
    case 35:
      if (lookahead == 'p') ADVANCE(19);
      END_STATE();
    case 36:
      if (lookahead == 'r') ADVANCE(14);
      END_STATE();
    case 37:
      if (lookahead == 'r') ADVANCE(62);
      END_STATE();
    case 38:
      if (lookahead == 'r') ADVANCE(48);
      if (lookahead == 'y') ADVANCE(35);
      END_STATE();
    case 39:
      if (lookahead == 'r') ADVANCE(12);
      END_STATE();
    case 40:
      if (lookahead == 's') ADVANCE(34);
      END_STATE();
    case 41:
      if (lookahead == 's') ADVANCE(20);
      END_STATE();
    case 42:
      if (lookahead == 't') ADVANCE(13);
      END_STATE();
    case 43:
      if (lookahead == 't') ADVANCE(33);
      END_STATE();
    case 44:
      if (lookahead == 'u') ADVANCE(29);
      END_STATE();
    case 45:
      if (lookahead == 'u') ADVANCE(50);
      END_STATE();
    case 46:
      if (lookahead == 'u') ADVANCE(28);
      END_STATE();
    case 47:
      if (lookahead == 'u') ADVANCE(36);
      END_STATE();
    case 48:
      if (lookahead == 'u') ADVANCE(18);
      END_STATE();
    case 49:
      if (lookahead == 'w') ADVANCE(61);
      END_STATE();
    case 50:
      if (lookahead == '{') ADVANCE(53);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(55);
      END_STATE();
    case 51:
      if (lookahead == '}') ADVANCE(111);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(111);
      END_STATE();
    case 53:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 54:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 55:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(54);
      END_STATE();
    case 56:
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(3);
      if (lookahead == '"') ADVANCE(113);
      if (lookahead == '\\') ADVANCE(56);
      END_STATE();
    case 57:
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(4);
      if (lookahead == '\'') ADVANCE(114);
      if (lookahead == '\\') ADVANCE(57);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_datasource);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_model);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_view);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_generator);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_developer_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(65);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(66);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(88);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(74);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(71);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(72);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '\\') ADVANCE(45);
      if (!aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(111);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(85);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(7);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(75);
      if (lookahead == '=') ADVANCE(87);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(89);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(91);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(92);
      if (lookahead == '>') ADVANCE(73);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '@') ADVANCE(97);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_AT_AT);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '\\') ADVANCE(45);
      if (lookahead == 'a') ADVANCE(104);
      if (!aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(111);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '\\') ADVANCE(45);
      if (lookahead == 'e') ADVANCE(120);
      if (!aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(111);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '\\') ADVANCE(45);
      if (lookahead == 'e') ADVANCE(122);
      if (!aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(111);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '\\') ADVANCE(45);
      if (lookahead == 'l') ADVANCE(108);
      if (!aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(111);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '\\') ADVANCE(45);
      if (lookahead == 'l') ADVANCE(124);
      if (!aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(111);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '\\') ADVANCE(45);
      if (lookahead == 'l') ADVANCE(105);
      if (!aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(111);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '\\') ADVANCE(45);
      if (lookahead == 'r') ADVANCE(109);
      if (!aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(111);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '\\') ADVANCE(45);
      if (lookahead == 's') ADVANCE(103);
      if (!aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(111);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '\\') ADVANCE(45);
      if (lookahead == 'u') ADVANCE(102);
      if (!aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(111);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '\\') ADVANCE(45);
      if (lookahead == 'u') ADVANCE(106);
      if (!aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(111);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(aux_sym_identifier_token1);
      if (lookahead == '\\') ADVANCE(45);
      if (!aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(111);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_string);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_string);
      if (lookahead == '"') ADVANCE(112);
      if (lookahead == '\\') ADVANCE(56);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(3);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_string);
      if (lookahead == '\'') ADVANCE(112);
      if (lookahead == '\\') ADVANCE(57);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(4);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(115);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_maybe);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_true);
      if (lookahead == '\\') ADVANCE(45);
      if (!aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(111);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_false);
      if (lookahead == '\\') ADVANCE(45);
      if (!aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(111);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_null);
      if (lookahead == '\\') ADVANCE(45);
      if (!aux_sym_identifier_token1_character_set_4(lookahead)) ADVANCE(111);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 0},
  [3] = {.lex_state = 0},
  [4] = {.lex_state = 0},
  [5] = {.lex_state = 0},
  [6] = {.lex_state = 0},
  [7] = {.lex_state = 0},
  [8] = {.lex_state = 0},
  [9] = {.lex_state = 0},
  [10] = {.lex_state = 0},
  [11] = {.lex_state = 0},
  [12] = {.lex_state = 0},
  [13] = {.lex_state = 0},
  [14] = {.lex_state = 0},
  [15] = {.lex_state = 0},
  [16] = {.lex_state = 0},
  [17] = {.lex_state = 0},
  [18] = {.lex_state = 0},
  [19] = {.lex_state = 0},
  [20] = {.lex_state = 0},
  [21] = {.lex_state = 0},
  [22] = {.lex_state = 0},
  [23] = {.lex_state = 0},
  [24] = {.lex_state = 0},
  [25] = {.lex_state = 0},
  [26] = {.lex_state = 0},
  [27] = {.lex_state = 0},
  [28] = {.lex_state = 0},
  [29] = {.lex_state = 0},
  [30] = {.lex_state = 0},
  [31] = {.lex_state = 0},
  [32] = {.lex_state = 0},
  [33] = {.lex_state = 0},
  [34] = {.lex_state = 0},
  [35] = {.lex_state = 0},
  [36] = {.lex_state = 0},
  [37] = {.lex_state = 0},
  [38] = {.lex_state = 0},
  [39] = {.lex_state = 0},
  [40] = {.lex_state = 0},
  [41] = {.lex_state = 0},
  [42] = {.lex_state = 0},
  [43] = {.lex_state = 1},
  [44] = {.lex_state = 1},
  [45] = {.lex_state = 1},
  [46] = {.lex_state = 0},
  [47] = {.lex_state = 1},
  [48] = {.lex_state = 1},
  [49] = {.lex_state = 0},
  [50] = {.lex_state = 1},
  [51] = {.lex_state = 0},
  [52] = {.lex_state = 0},
  [53] = {.lex_state = 0},
  [54] = {.lex_state = 0},
  [55] = {.lex_state = 0},
  [56] = {.lex_state = 1},
  [57] = {.lex_state = 1},
  [58] = {.lex_state = 1},
  [59] = {.lex_state = 0},
  [60] = {.lex_state = 1},
  [61] = {.lex_state = 0},
  [62] = {.lex_state = 1},
  [63] = {.lex_state = 0},
  [64] = {.lex_state = 1},
  [65] = {.lex_state = 0},
  [66] = {.lex_state = 1},
  [67] = {.lex_state = 0},
  [68] = {.lex_state = 0},
  [69] = {.lex_state = 0},
  [70] = {.lex_state = 1},
  [71] = {.lex_state = 1},
  [72] = {.lex_state = 1},
  [73] = {.lex_state = 1},
  [74] = {.lex_state = 1},
  [75] = {.lex_state = 1},
  [76] = {.lex_state = 1},
  [77] = {.lex_state = 0},
  [78] = {.lex_state = 1},
  [79] = {.lex_state = 0},
  [80] = {.lex_state = 0},
  [81] = {.lex_state = 1},
  [82] = {.lex_state = 0},
  [83] = {.lex_state = 0},
  [84] = {.lex_state = 1},
  [85] = {.lex_state = 0},
  [86] = {.lex_state = 1},
  [87] = {.lex_state = 1},
  [88] = {.lex_state = 1},
  [89] = {.lex_state = 0},
  [90] = {.lex_state = 1},
  [91] = {.lex_state = 1},
  [92] = {.lex_state = 1},
  [93] = {.lex_state = 1},
  [94] = {.lex_state = 1},
  [95] = {.lex_state = 1},
  [96] = {.lex_state = 1},
  [97] = {.lex_state = 1},
  [98] = {.lex_state = 1},
  [99] = {.lex_state = 1},
  [100] = {.lex_state = 1},
  [101] = {.lex_state = 1},
  [102] = {.lex_state = 1},
  [103] = {.lex_state = 1},
  [104] = {.lex_state = 1},
  [105] = {.lex_state = 0},
  [106] = {.lex_state = 0},
  [107] = {.lex_state = 0},
  [108] = {.lex_state = 0},
  [109] = {.lex_state = 0},
  [110] = {.lex_state = 0},
  [111] = {.lex_state = 0},
  [112] = {.lex_state = 2},
  [113] = {.lex_state = 2},
  [114] = {.lex_state = 2},
  [115] = {.lex_state = 2},
  [116] = {.lex_state = 2},
  [117] = {.lex_state = 2},
  [118] = {.lex_state = 2},
  [119] = {.lex_state = 2},
  [120] = {.lex_state = 2},
  [121] = {.lex_state = 2},
  [122] = {.lex_state = 2},
  [123] = {.lex_state = 2},
  [124] = {.lex_state = 2},
  [125] = {.lex_state = 2},
  [126] = {.lex_state = 2},
  [127] = {.lex_state = 2},
  [128] = {.lex_state = 0},
  [129] = {.lex_state = 2},
  [130] = {.lex_state = 2},
  [131] = {.lex_state = 2},
  [132] = {.lex_state = 2},
  [133] = {.lex_state = 2},
  [134] = {.lex_state = 2},
  [135] = {.lex_state = 2},
  [136] = {.lex_state = 2},
  [137] = {.lex_state = 0},
  [138] = {.lex_state = 2},
  [139] = {.lex_state = 0},
  [140] = {.lex_state = 2},
  [141] = {.lex_state = 2},
  [142] = {.lex_state = 0},
  [143] = {.lex_state = 5},
  [144] = {.lex_state = 5},
  [145] = {.lex_state = 0},
  [146] = {.lex_state = 0},
  [147] = {.lex_state = 0},
  [148] = {.lex_state = 0},
  [149] = {.lex_state = 0},
  [150] = {.lex_state = 5},
  [151] = {.lex_state = 0},
  [152] = {.lex_state = 0},
  [153] = {.lex_state = 5},
  [154] = {.lex_state = 5},
  [155] = {.lex_state = 2},
  [156] = {.lex_state = 5},
  [157] = {.lex_state = 0},
  [158] = {.lex_state = 0},
  [159] = {.lex_state = 5},
  [160] = {.lex_state = 0},
  [161] = {.lex_state = 0},
  [162] = {.lex_state = 5},
  [163] = {.lex_state = 0},
  [164] = {.lex_state = 0},
  [165] = {.lex_state = 0},
  [166] = {.lex_state = 0},
  [167] = {.lex_state = 0},
  [168] = {.lex_state = 0},
  [169] = {.lex_state = 0},
  [170] = {.lex_state = 5},
  [171] = {.lex_state = 5},
  [172] = {.lex_state = 5},
  [173] = {.lex_state = 5},
  [174] = {.lex_state = 5},
  [175] = {.lex_state = 5},
  [176] = {.lex_state = 5},
  [177] = {.lex_state = 5},
  [178] = {.lex_state = 5},
  [179] = {.lex_state = 5},
  [180] = {.lex_state = 5},
  [181] = {.lex_state = 5},
  [182] = {.lex_state = 5},
  [183] = {.lex_state = 5},
  [184] = {.lex_state = 5},
  [185] = {.lex_state = 5},
  [186] = {.lex_state = 5},
  [187] = {.lex_state = 5},
  [188] = {.lex_state = 0},
  [189] = {.lex_state = 5},
  [190] = {.lex_state = 5},
  [191] = {.lex_state = 0},
  [192] = {.lex_state = 0},
  [193] = {.lex_state = 0},
  [194] = {.lex_state = 0},
  [195] = {.lex_state = 0},
  [196] = {.lex_state = 0},
  [197] = {.lex_state = 0},
  [198] = {.lex_state = 5},
  [199] = {.lex_state = 0},
  [200] = {.lex_state = 0},
  [201] = {.lex_state = 0},
  [202] = {.lex_state = 5},
  [203] = {.lex_state = 0},
  [204] = {.lex_state = 0},
  [205] = {.lex_state = 5},
  [206] = {.lex_state = 0},
  [207] = {.lex_state = 0},
  [208] = {.lex_state = 0},
  [209] = {.lex_state = 5},
  [210] = {.lex_state = 0},
  [211] = {.lex_state = 5},
  [212] = {.lex_state = 5},
  [213] = {.lex_state = 5},
  [214] = {.lex_state = 0},
  [215] = {.lex_state = 0},
  [216] = {.lex_state = 5},
  [217] = {.lex_state = 5},
  [218] = {.lex_state = 0},
  [219] = {.lex_state = 5},
  [220] = {.lex_state = 5},
  [221] = {.lex_state = 5},
  [222] = {.lex_state = 5},
  [223] = {.lex_state = 5},
  [224] = {.lex_state = 0},
  [225] = {.lex_state = 0},
  [226] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_datasource] = ACTIONS(1),
    [anon_sym_model] = ACTIONS(1),
    [anon_sym_view] = ACTIONS(1),
    [anon_sym_generator] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_AT_AT] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [sym_string] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [sym_maybe] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(225),
    [sym_datasource_declaration] = STATE(160),
    [sym_model_declaration] = STATE(160),
    [sym_view_declaration] = STATE(160),
    [sym_generator_declaration] = STATE(160),
    [sym_type_declaration] = STATE(160),
    [sym_enum_declaration] = STATE(160),
    [sym_comment] = STATE(1),
    [aux_sym_program_repeat1] = STATE(128),
    [ts_builtin_sym_end] = ACTIONS(7),
    [anon_sym_datasource] = ACTIONS(9),
    [anon_sym_model] = ACTIONS(11),
    [anon_sym_view] = ACTIONS(13),
    [anon_sym_generator] = ACTIONS(15),
    [anon_sym_type] = ACTIONS(17),
    [anon_sym_enum] = ACTIONS(19),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
  },
  [2] = {
    [sym_comment] = STATE(2),
    [sym_arguments] = STATE(33),
    [ts_builtin_sym_end] = ACTIONS(21),
    [anon_sym_datasource] = ACTIONS(21),
    [anon_sym_model] = ACTIONS(21),
    [anon_sym_view] = ACTIONS(21),
    [anon_sym_generator] = ACTIONS(21),
    [anon_sym_type] = ACTIONS(21),
    [anon_sym_enum] = ACTIONS(21),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_EQ] = ACTIONS(23),
    [anon_sym_AMP_AMP] = ACTIONS(25),
    [anon_sym_PIPE_PIPE] = ACTIONS(21),
    [anon_sym_GT_GT] = ACTIONS(27),
    [anon_sym_GT_GT_GT] = ACTIONS(29),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_PIPE] = ACTIONS(33),
    [anon_sym_PLUS] = ACTIONS(35),
    [anon_sym_DASH] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_SLASH] = ACTIONS(27),
    [anon_sym_PERCENT] = ACTIONS(29),
    [anon_sym_STAR_STAR] = ACTIONS(37),
    [anon_sym_LT] = ACTIONS(39),
    [anon_sym_LT_EQ] = ACTIONS(41),
    [anon_sym_EQ_EQ] = ACTIONS(39),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(41),
    [anon_sym_BANG_EQ] = ACTIONS(39),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(41),
    [anon_sym_GT_EQ] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(39),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_COMMA] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(21),
    [anon_sym_RBRACK] = ACTIONS(21),
  },
  [3] = {
    [sym_comment] = STATE(3),
    [sym_arguments] = STATE(33),
    [ts_builtin_sym_end] = ACTIONS(21),
    [anon_sym_datasource] = ACTIONS(21),
    [anon_sym_model] = ACTIONS(21),
    [anon_sym_view] = ACTIONS(21),
    [anon_sym_generator] = ACTIONS(21),
    [anon_sym_type] = ACTIONS(21),
    [anon_sym_enum] = ACTIONS(21),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_EQ] = ACTIONS(23),
    [anon_sym_AMP_AMP] = ACTIONS(21),
    [anon_sym_PIPE_PIPE] = ACTIONS(21),
    [anon_sym_GT_GT] = ACTIONS(27),
    [anon_sym_GT_GT_GT] = ACTIONS(29),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_PIPE] = ACTIONS(33),
    [anon_sym_PLUS] = ACTIONS(35),
    [anon_sym_DASH] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_SLASH] = ACTIONS(27),
    [anon_sym_PERCENT] = ACTIONS(29),
    [anon_sym_STAR_STAR] = ACTIONS(37),
    [anon_sym_LT] = ACTIONS(39),
    [anon_sym_LT_EQ] = ACTIONS(41),
    [anon_sym_EQ_EQ] = ACTIONS(39),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(41),
    [anon_sym_BANG_EQ] = ACTIONS(39),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(41),
    [anon_sym_GT_EQ] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(39),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_COMMA] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(21),
    [anon_sym_RBRACK] = ACTIONS(21),
  },
  [4] = {
    [sym_comment] = STATE(4),
    [sym_arguments] = STATE(33),
    [ts_builtin_sym_end] = ACTIONS(49),
    [anon_sym_datasource] = ACTIONS(49),
    [anon_sym_model] = ACTIONS(49),
    [anon_sym_view] = ACTIONS(49),
    [anon_sym_generator] = ACTIONS(49),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_enum] = ACTIONS(49),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_EQ] = ACTIONS(23),
    [anon_sym_AMP_AMP] = ACTIONS(25),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_GT_GT] = ACTIONS(27),
    [anon_sym_GT_GT_GT] = ACTIONS(29),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_PIPE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(35),
    [anon_sym_DASH] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_SLASH] = ACTIONS(27),
    [anon_sym_PERCENT] = ACTIONS(29),
    [anon_sym_STAR_STAR] = ACTIONS(37),
    [anon_sym_LT] = ACTIONS(39),
    [anon_sym_LT_EQ] = ACTIONS(41),
    [anon_sym_EQ_EQ] = ACTIONS(39),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(41),
    [anon_sym_BANG_EQ] = ACTIONS(39),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(41),
    [anon_sym_GT_EQ] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(39),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_COMMA] = ACTIONS(49),
    [anon_sym_RPAREN] = ACTIONS(49),
    [anon_sym_RBRACK] = ACTIONS(49),
  },
  [5] = {
    [sym_comment] = STATE(5),
    [sym_arguments] = STATE(33),
    [ts_builtin_sym_end] = ACTIONS(55),
    [anon_sym_datasource] = ACTIONS(55),
    [anon_sym_model] = ACTIONS(55),
    [anon_sym_view] = ACTIONS(55),
    [anon_sym_generator] = ACTIONS(55),
    [anon_sym_type] = ACTIONS(55),
    [anon_sym_enum] = ACTIONS(55),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_EQ] = ACTIONS(23),
    [anon_sym_AMP_AMP] = ACTIONS(25),
    [anon_sym_PIPE_PIPE] = ACTIONS(51),
    [anon_sym_GT_GT] = ACTIONS(27),
    [anon_sym_GT_GT_GT] = ACTIONS(29),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(31),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_PIPE] = ACTIONS(53),
    [anon_sym_PLUS] = ACTIONS(35),
    [anon_sym_DASH] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_SLASH] = ACTIONS(27),
    [anon_sym_PERCENT] = ACTIONS(29),
    [anon_sym_STAR_STAR] = ACTIONS(37),
    [anon_sym_LT] = ACTIONS(39),
    [anon_sym_LT_EQ] = ACTIONS(41),
    [anon_sym_EQ_EQ] = ACTIONS(39),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(41),
    [anon_sym_BANG_EQ] = ACTIONS(39),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(41),
    [anon_sym_GT_EQ] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(39),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(55),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_COMMA] = ACTIONS(55),
    [anon_sym_RPAREN] = ACTIONS(55),
    [anon_sym_RBRACK] = ACTIONS(55),
  },
  [6] = {
    [sym_comment] = STATE(6),
    [sym_arguments] = STATE(33),
    [ts_builtin_sym_end] = ACTIONS(21),
    [anon_sym_datasource] = ACTIONS(21),
    [anon_sym_model] = ACTIONS(21),
    [anon_sym_view] = ACTIONS(21),
    [anon_sym_generator] = ACTIONS(21),
    [anon_sym_type] = ACTIONS(21),
    [anon_sym_enum] = ACTIONS(21),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_EQ] = ACTIONS(23),
    [anon_sym_AMP_AMP] = ACTIONS(21),
    [anon_sym_PIPE_PIPE] = ACTIONS(21),
    [anon_sym_GT_GT] = ACTIONS(33),
    [anon_sym_GT_GT_GT] = ACTIONS(21),
    [anon_sym_LT_LT] = ACTIONS(21),
    [anon_sym_AMP] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_PIPE] = ACTIONS(33),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_SLASH] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(21),
    [anon_sym_STAR_STAR] = ACTIONS(37),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(21),
    [anon_sym_EQ_EQ] = ACTIONS(33),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(21),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(21),
    [anon_sym_GT_EQ] = ACTIONS(21),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_COMMA] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(21),
    [anon_sym_RBRACK] = ACTIONS(21),
  },
  [7] = {
    [sym_comment] = STATE(7),
    [sym_arguments] = STATE(33),
    [ts_builtin_sym_end] = ACTIONS(21),
    [anon_sym_datasource] = ACTIONS(21),
    [anon_sym_model] = ACTIONS(21),
    [anon_sym_view] = ACTIONS(21),
    [anon_sym_generator] = ACTIONS(21),
    [anon_sym_type] = ACTIONS(21),
    [anon_sym_enum] = ACTIONS(21),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_EQ] = ACTIONS(23),
    [anon_sym_AMP_AMP] = ACTIONS(21),
    [anon_sym_PIPE_PIPE] = ACTIONS(21),
    [anon_sym_GT_GT] = ACTIONS(27),
    [anon_sym_GT_GT_GT] = ACTIONS(29),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_PIPE] = ACTIONS(33),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_SLASH] = ACTIONS(27),
    [anon_sym_PERCENT] = ACTIONS(29),
    [anon_sym_STAR_STAR] = ACTIONS(37),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(21),
    [anon_sym_EQ_EQ] = ACTIONS(33),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(21),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(21),
    [anon_sym_GT_EQ] = ACTIONS(21),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_COMMA] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(21),
    [anon_sym_RBRACK] = ACTIONS(21),
  },
  [8] = {
    [sym_comment] = STATE(8),
    [sym_arguments] = STATE(33),
    [ts_builtin_sym_end] = ACTIONS(21),
    [anon_sym_datasource] = ACTIONS(21),
    [anon_sym_model] = ACTIONS(21),
    [anon_sym_view] = ACTIONS(21),
    [anon_sym_generator] = ACTIONS(21),
    [anon_sym_type] = ACTIONS(21),
    [anon_sym_enum] = ACTIONS(21),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_EQ] = ACTIONS(23),
    [anon_sym_AMP_AMP] = ACTIONS(21),
    [anon_sym_PIPE_PIPE] = ACTIONS(21),
    [anon_sym_GT_GT] = ACTIONS(33),
    [anon_sym_GT_GT_GT] = ACTIONS(21),
    [anon_sym_LT_LT] = ACTIONS(21),
    [anon_sym_AMP] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_PIPE] = ACTIONS(33),
    [anon_sym_PLUS] = ACTIONS(21),
    [anon_sym_DASH] = ACTIONS(21),
    [anon_sym_STAR] = ACTIONS(33),
    [anon_sym_SLASH] = ACTIONS(33),
    [anon_sym_PERCENT] = ACTIONS(21),
    [anon_sym_STAR_STAR] = ACTIONS(21),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(21),
    [anon_sym_EQ_EQ] = ACTIONS(33),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(21),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(21),
    [anon_sym_GT_EQ] = ACTIONS(21),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_COMMA] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(21),
    [anon_sym_RBRACK] = ACTIONS(21),
  },
  [9] = {
    [sym_comment] = STATE(9),
    [sym_arguments] = STATE(33),
    [ts_builtin_sym_end] = ACTIONS(21),
    [anon_sym_datasource] = ACTIONS(21),
    [anon_sym_model] = ACTIONS(21),
    [anon_sym_view] = ACTIONS(21),
    [anon_sym_generator] = ACTIONS(21),
    [anon_sym_type] = ACTIONS(21),
    [anon_sym_enum] = ACTIONS(21),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_EQ] = ACTIONS(23),
    [anon_sym_AMP_AMP] = ACTIONS(21),
    [anon_sym_PIPE_PIPE] = ACTIONS(21),
    [anon_sym_GT_GT] = ACTIONS(27),
    [anon_sym_GT_GT_GT] = ACTIONS(29),
    [anon_sym_LT_LT] = ACTIONS(29),
    [anon_sym_AMP] = ACTIONS(33),
    [anon_sym_CARET] = ACTIONS(21),
    [anon_sym_PIPE] = ACTIONS(33),
    [anon_sym_PLUS] = ACTIONS(35),
    [anon_sym_DASH] = ACTIONS(35),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_SLASH] = ACTIONS(27),
    [anon_sym_PERCENT] = ACTIONS(29),
    [anon_sym_STAR_STAR] = ACTIONS(37),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_LT_EQ] = ACTIONS(21),
    [anon_sym_EQ_EQ] = ACTIONS(33),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(21),
    [anon_sym_BANG_EQ] = ACTIONS(33),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(21),
    [anon_sym_GT_EQ] = ACTIONS(21),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_COLON] = ACTIONS(45),
    [anon_sym_AT] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_COMMA] = ACTIONS(21),
    [anon_sym_RPAREN] = ACTIONS(21),
    [anon_sym_RBRACK] = ACTIONS(21),
  },
  [10] = {
    [sym_comment] = STATE(10),
    [ts_builtin_sym_end] = ACTIONS(57),
    [anon_sym_datasource] = ACTIONS(57),
    [anon_sym_model] = ACTIONS(57),
    [anon_sym_view] = ACTIONS(57),
    [anon_sym_generator] = ACTIONS(57),
    [anon_sym_type] = ACTIONS(57),
    [anon_sym_enum] = ACTIONS(57),
    [sym_developer_comment] = ACTIONS(3),
    [aux_sym_comment_token1] = ACTIONS(5),
    [anon_sym_EQ] = ACTIONS(59),
    [anon_sym_AMP_AMP] = ACTIONS(57),
    [anon_sym_PIPE_PIPE] = ACTIONS(57),
    [anon_sym_GT_GT] = ACTIONS(59),
    [anon_sym_GT_GT_GT] = ACTIONS(57),
    [anon_sym_LT_LT] = ACTIONS(57),
    [anon_sym_AMP] = ACTIONS(59),
    [anon_sym_CARET] = ACTIONS(57),
    [anon_sym_PIPE] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(57),
    [anon_sym_STAR] = ACTIONS(59),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_PERCENT] = ACTIONS(57),
    [anon_sym_STAR_STAR] = ACTIONS(57),
    [anon_sym_LT] = ACTIONS(59),
    [anon_sym_LT_EQ] = ACTIONS(57),
    [anon_sym_EQ_EQ] = ACTIONS(59),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(57),
    [anon_sym_BANG_EQ] = ACTIONS(59),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(57),
    [anon_sym_GT_EQ] = ACTIONS(57),
    [anon_sym_GT] = ACTIONS(59),
    [anon_sym_DOT] = ACTIONS(57),
    [anon_sym_COLON] = ACTIONS(57),
    [anon_sym_AT] = ACTIONS(57),
    [anon_sym_LPAREN] = ACTIONS(57),
    [anon_sym_COMMA] = ACTIONS(57),
    [anon_sym_RPAREN] = ACTIONS(57),
    [anon_sym_RBRACK] = ACTIONS(57),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 16,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(33), 1,
      anon_sym_PIPE,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    STATE(11), 1,
      sym_comment,
    STATE(33), 1,
      sym_arguments,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
    ACTIONS(21), 13,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [72] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    STATE(12), 1,
      sym_comment,
    STATE(33), 1,
      sym_arguments,
    ACTIONS(33), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
    ACTIONS(21), 14,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [140] = 9,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    STATE(13), 1,
      sym_comment,
    STATE(33), 1,
      sym_arguments,
    ACTIONS(33), 9,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(21), 23,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [198] = 17,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    STATE(14), 1,
      sym_comment,
    STATE(33), 1,
      sym_arguments,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
    ACTIONS(49), 11,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [272] = 17,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    STATE(15), 1,
      sym_comment,
    STATE(33), 1,
      sym_arguments,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
    ACTIONS(55), 11,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [346] = 11,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    STATE(16), 1,
      sym_comment,
    STATE(33), 1,
      sym_arguments,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(33), 6,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(21), 20,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [408] = 8,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    STATE(17), 1,
      sym_comment,
    STATE(33), 1,
      sym_arguments,
    ACTIONS(33), 9,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(21), 24,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [464] = 12,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    STATE(18), 1,
      sym_comment,
    STATE(33), 1,
      sym_arguments,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(33), 6,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(21), 18,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [528] = 13,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    STATE(19), 1,
      sym_comment,
    STATE(33), 1,
      sym_arguments,
    ACTIONS(33), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
    ACTIONS(21), 14,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [593] = 7,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    STATE(20), 1,
      sym_comment,
    STATE(33), 1,
      sym_arguments,
    ACTIONS(33), 9,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(21), 24,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [646] = 8,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    STATE(21), 1,
      sym_comment,
    STATE(33), 1,
      sym_arguments,
    ACTIONS(33), 9,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(21), 23,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [701] = 15,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(33), 1,
      anon_sym_PIPE,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    STATE(22), 1,
      sym_comment,
    STATE(33), 1,
      sym_arguments,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
    ACTIONS(21), 13,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [770] = 16,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    STATE(23), 1,
      sym_comment,
    STATE(33), 1,
      sym_arguments,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
    ACTIONS(49), 11,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [841] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(24), 1,
      sym_comment,
    ACTIONS(63), 9,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(61), 26,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [890] = 16,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    STATE(25), 1,
      sym_comment,
    STATE(33), 1,
      sym_arguments,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
    ACTIONS(55), 11,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [961] = 11,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    STATE(26), 1,
      sym_comment,
    STATE(33), 1,
      sym_arguments,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(33), 6,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(21), 18,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [1022] = 10,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    STATE(27), 1,
      sym_comment,
    STATE(33), 1,
      sym_arguments,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(33), 6,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(21), 20,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [1081] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    STATE(28), 1,
      sym_comment,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
    ACTIONS(55), 12,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [1147] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    STATE(29), 1,
      sym_comment,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
    ACTIONS(49), 12,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [1213] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    STATE(30), 1,
      sym_comment,
    ACTIONS(33), 9,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(21), 24,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [1263] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(31), 1,
      sym_comment,
    ACTIONS(67), 9,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(65), 25,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [1311] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(32), 1,
      sym_comment,
    ACTIONS(71), 9,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(69), 25,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [1359] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(33), 1,
      sym_comment,
    ACTIONS(75), 9,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(73), 25,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [1407] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(34), 1,
      sym_comment,
    ACTIONS(79), 9,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(77), 25,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [1455] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(35), 1,
      sym_comment,
    ACTIONS(83), 9,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(81), 25,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [1503] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(36), 1,
      sym_comment,
    ACTIONS(87), 9,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(85), 25,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [1551] = 9,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    STATE(37), 1,
      sym_comment,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(33), 6,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(21), 19,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [1607] = 13,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(33), 1,
      anon_sym_PIPE,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    STATE(38), 1,
      sym_comment,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
    ACTIONS(21), 14,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [1671] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(39), 1,
      sym_comment,
    ACTIONS(91), 9,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(89), 25,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [1719] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(40), 1,
      sym_comment,
    ACTIONS(33), 9,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(21), 25,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [1767] = 11,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    STATE(41), 1,
      sym_comment,
    ACTIONS(33), 2,
      anon_sym_AMP,
      anon_sym_PIPE,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
    ACTIONS(21), 15,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [1827] = 8,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    STATE(42), 1,
      sym_comment,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(33), 6,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(21), 21,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [1881] = 19,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(93), 1,
      anon_sym_EQ,
    ACTIONS(95), 1,
      anon_sym_AMP_AMP,
    ACTIONS(101), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_PLUS,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_STAR_STAR,
    ACTIONS(113), 1,
      anon_sym_DOT,
    ACTIONS(115), 1,
      anon_sym_COLON,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    STATE(43), 1,
      sym_comment,
    STATE(96), 1,
      sym_arguments,
    ACTIONS(33), 2,
      anon_sym_PIPE,
      aux_sym_identifier_token1,
    ACTIONS(97), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(99), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(21), 4,
      anon_sym_RBRACE,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_AT_AT,
    ACTIONS(109), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(111), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [1953] = 21,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(93), 1,
      anon_sym_EQ,
    ACTIONS(95), 1,
      anon_sym_AMP_AMP,
    ACTIONS(101), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_PLUS,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_STAR_STAR,
    ACTIONS(113), 1,
      anon_sym_DOT,
    ACTIONS(115), 1,
      anon_sym_COLON,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    ACTIONS(121), 1,
      anon_sym_PIPE,
    ACTIONS(123), 1,
      aux_sym_identifier_token1,
    STATE(44), 1,
      sym_comment,
    STATE(96), 1,
      sym_arguments,
    ACTIONS(49), 2,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
    ACTIONS(119), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(97), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(99), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(109), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(111), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [2029] = 11,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(93), 1,
      anon_sym_EQ,
    ACTIONS(107), 1,
      anon_sym_STAR_STAR,
    ACTIONS(113), 1,
      anon_sym_DOT,
    ACTIONS(115), 1,
      anon_sym_COLON,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    STATE(45), 1,
      sym_comment,
    STATE(96), 1,
      sym_arguments,
    ACTIONS(33), 11,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      aux_sym_identifier_token1,
    ACTIONS(21), 13,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
  [2085] = 19,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(23), 1,
      anon_sym_EQ,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(45), 1,
      anon_sym_COLON,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    STATE(33), 1,
      sym_arguments,
    STATE(46), 1,
      sym_comment,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(125), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [2157] = 15,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(93), 1,
      anon_sym_EQ,
    ACTIONS(103), 1,
      anon_sym_PLUS,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_STAR_STAR,
    ACTIONS(113), 1,
      anon_sym_DOT,
    ACTIONS(115), 1,
      anon_sym_COLON,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    STATE(47), 1,
      sym_comment,
    STATE(96), 1,
      sym_arguments,
    ACTIONS(97), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(99), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(33), 7,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      aux_sym_identifier_token1,
    ACTIONS(21), 9,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
  [2221] = 17,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(93), 1,
      anon_sym_EQ,
    ACTIONS(103), 1,
      anon_sym_PLUS,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_STAR_STAR,
    ACTIONS(113), 1,
      anon_sym_DOT,
    ACTIONS(115), 1,
      anon_sym_COLON,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    STATE(48), 1,
      sym_comment,
    STATE(96), 1,
      sym_arguments,
    ACTIONS(33), 3,
      anon_sym_AMP,
      anon_sym_PIPE,
      aux_sym_identifier_token1,
    ACTIONS(97), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(99), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(109), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(111), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
    ACTIONS(21), 5,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_AT_AT,
  [2289] = 21,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(23), 1,
      anon_sym_EQ,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(45), 1,
      anon_sym_COLON,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(129), 1,
      anon_sym_RBRACK,
    STATE(33), 1,
      sym_arguments,
    STATE(49), 1,
      sym_comment,
    STATE(200), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [2365] = 21,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(93), 1,
      anon_sym_EQ,
    ACTIONS(95), 1,
      anon_sym_AMP_AMP,
    ACTIONS(101), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_PLUS,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_STAR_STAR,
    ACTIONS(113), 1,
      anon_sym_DOT,
    ACTIONS(115), 1,
      anon_sym_COLON,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    ACTIONS(121), 1,
      anon_sym_PIPE,
    ACTIONS(131), 1,
      aux_sym_identifier_token1,
    STATE(50), 1,
      sym_comment,
    STATE(96), 1,
      sym_arguments,
    ACTIONS(55), 2,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
    ACTIONS(119), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(97), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(99), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(109), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(111), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [2441] = 21,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(23), 1,
      anon_sym_EQ,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(45), 1,
      anon_sym_COLON,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(133), 1,
      anon_sym_RBRACK,
    STATE(33), 1,
      sym_arguments,
    STATE(51), 1,
      sym_comment,
    STATE(194), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [2517] = 21,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(23), 1,
      anon_sym_EQ,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(45), 1,
      anon_sym_COLON,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(135), 1,
      anon_sym_RBRACK,
    STATE(33), 1,
      sym_arguments,
    STATE(52), 1,
      sym_comment,
    STATE(204), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [2593] = 21,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(23), 1,
      anon_sym_EQ,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(45), 1,
      anon_sym_COLON,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(137), 1,
      anon_sym_RPAREN,
    STATE(33), 1,
      sym_arguments,
    STATE(53), 1,
      sym_comment,
    STATE(201), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [2669] = 21,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(23), 1,
      anon_sym_EQ,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(45), 1,
      anon_sym_COLON,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(139), 1,
      anon_sym_RPAREN,
    STATE(33), 1,
      sym_arguments,
    STATE(54), 1,
      sym_comment,
    STATE(193), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [2745] = 21,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(23), 1,
      anon_sym_EQ,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(45), 1,
      anon_sym_COLON,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(141), 1,
      anon_sym_RPAREN,
    STATE(33), 1,
      sym_arguments,
    STATE(55), 1,
      sym_comment,
    STATE(191), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [2821] = 10,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(93), 1,
      anon_sym_EQ,
    ACTIONS(113), 1,
      anon_sym_DOT,
    ACTIONS(115), 1,
      anon_sym_COLON,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    STATE(56), 1,
      sym_comment,
    STATE(96), 1,
      sym_arguments,
    ACTIONS(33), 11,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      aux_sym_identifier_token1,
    ACTIONS(21), 14,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
  [2875] = 13,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(93), 1,
      anon_sym_EQ,
    ACTIONS(107), 1,
      anon_sym_STAR_STAR,
    ACTIONS(113), 1,
      anon_sym_DOT,
    ACTIONS(115), 1,
      anon_sym_COLON,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    STATE(57), 1,
      sym_comment,
    STATE(96), 1,
      sym_arguments,
    ACTIONS(97), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(99), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(33), 8,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      aux_sym_identifier_token1,
    ACTIONS(21), 10,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
  [2935] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(58), 1,
      sym_comment,
    ACTIONS(59), 12,
      anon_sym_EQ,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      aux_sym_identifier_token1,
    ACTIONS(57), 17,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
  [2978] = 19,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(133), 1,
      anon_sym_RBRACK,
    STATE(33), 1,
      sym_arguments,
    STATE(59), 1,
      sym_comment,
    STATE(194), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [3048] = 13,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(103), 1,
      anon_sym_PLUS,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_STAR_STAR,
    ACTIONS(113), 1,
      anon_sym_DOT,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    STATE(60), 1,
      sym_comment,
    STATE(96), 1,
      sym_arguments,
    ACTIONS(97), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(99), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(33), 7,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      aux_sym_identifier_token1,
    ACTIONS(21), 9,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
  [3106] = 19,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(137), 1,
      anon_sym_RPAREN,
    STATE(33), 1,
      sym_arguments,
    STATE(61), 1,
      sym_comment,
    STATE(201), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [3176] = 8,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(113), 1,
      anon_sym_DOT,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    STATE(62), 1,
      sym_comment,
    STATE(96), 1,
      sym_arguments,
    ACTIONS(33), 11,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      aux_sym_identifier_token1,
    ACTIONS(21), 14,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
  [3224] = 19,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(141), 1,
      anon_sym_RPAREN,
    STATE(33), 1,
      sym_arguments,
    STATE(63), 1,
      sym_comment,
    STATE(191), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [3294] = 19,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(95), 1,
      anon_sym_AMP_AMP,
    ACTIONS(101), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_PLUS,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_STAR_STAR,
    ACTIONS(113), 1,
      anon_sym_DOT,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    ACTIONS(121), 1,
      anon_sym_PIPE,
    ACTIONS(131), 1,
      aux_sym_identifier_token1,
    STATE(64), 1,
      sym_comment,
    STATE(96), 1,
      sym_arguments,
    ACTIONS(55), 2,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
    ACTIONS(119), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(97), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(99), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(109), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(111), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [3364] = 19,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(139), 1,
      anon_sym_RPAREN,
    STATE(33), 1,
      sym_arguments,
    STATE(65), 1,
      sym_comment,
    STATE(193), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [3434] = 9,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(107), 1,
      anon_sym_STAR_STAR,
    ACTIONS(113), 1,
      anon_sym_DOT,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    STATE(66), 1,
      sym_comment,
    STATE(96), 1,
      sym_arguments,
    ACTIONS(33), 11,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      aux_sym_identifier_token1,
    ACTIONS(21), 13,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
  [3484] = 19,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(135), 1,
      anon_sym_RBRACK,
    STATE(33), 1,
      sym_arguments,
    STATE(67), 1,
      sym_comment,
    STATE(204), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [3554] = 17,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    STATE(33), 1,
      sym_arguments,
    STATE(68), 1,
      sym_comment,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(125), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [3620] = 19,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(129), 1,
      anon_sym_RBRACK,
    STATE(33), 1,
      sym_arguments,
    STATE(69), 1,
      sym_comment,
    STATE(200), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [3690] = 15,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(103), 1,
      anon_sym_PLUS,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_STAR_STAR,
    ACTIONS(113), 1,
      anon_sym_DOT,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    STATE(70), 1,
      sym_comment,
    STATE(96), 1,
      sym_arguments,
    ACTIONS(33), 3,
      anon_sym_AMP,
      anon_sym_PIPE,
      aux_sym_identifier_token1,
    ACTIONS(97), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(99), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(109), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(111), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
    ACTIONS(21), 5,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_AT_AT,
  [3752] = 17,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(95), 1,
      anon_sym_AMP_AMP,
    ACTIONS(101), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_PLUS,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_STAR_STAR,
    ACTIONS(113), 1,
      anon_sym_DOT,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    STATE(71), 1,
      sym_comment,
    STATE(96), 1,
      sym_arguments,
    ACTIONS(33), 2,
      anon_sym_PIPE,
      aux_sym_identifier_token1,
    ACTIONS(97), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(99), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(21), 4,
      anon_sym_RBRACE,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_AT_AT,
    ACTIONS(109), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(111), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [3818] = 19,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(95), 1,
      anon_sym_AMP_AMP,
    ACTIONS(101), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_PLUS,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_STAR_STAR,
    ACTIONS(113), 1,
      anon_sym_DOT,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    ACTIONS(121), 1,
      anon_sym_PIPE,
    ACTIONS(123), 1,
      aux_sym_identifier_token1,
    STATE(72), 1,
      sym_comment,
    STATE(96), 1,
      sym_arguments,
    ACTIONS(49), 2,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
    ACTIONS(119), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(97), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(99), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(109), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(111), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [3888] = 11,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(107), 1,
      anon_sym_STAR_STAR,
    ACTIONS(113), 1,
      anon_sym_DOT,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    STATE(73), 1,
      sym_comment,
    STATE(96), 1,
      sym_arguments,
    ACTIONS(97), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(99), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(33), 8,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      aux_sym_identifier_token1,
    ACTIONS(21), 10,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
  [3942] = 7,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    STATE(74), 1,
      sym_comment,
    STATE(96), 1,
      sym_arguments,
    ACTIONS(33), 11,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      aux_sym_identifier_token1,
    ACTIONS(21), 14,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
  [3987] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(75), 1,
      sym_comment,
    ACTIONS(63), 11,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      aux_sym_identifier_token1,
    ACTIONS(61), 16,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
  [4028] = 18,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(95), 1,
      anon_sym_AMP_AMP,
    ACTIONS(101), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_PLUS,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_STAR_STAR,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    ACTIONS(121), 1,
      anon_sym_PIPE,
    ACTIONS(123), 1,
      aux_sym_identifier_token1,
    STATE(76), 1,
      sym_comment,
    STATE(96), 1,
      sym_arguments,
    ACTIONS(49), 2,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
    ACTIONS(119), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(97), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(99), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(109), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(111), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [4095] = 18,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(139), 1,
      anon_sym_RPAREN,
    STATE(33), 1,
      sym_arguments,
    STATE(77), 1,
      sym_comment,
    STATE(193), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [4162] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(103), 1,
      anon_sym_PLUS,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_STAR_STAR,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    STATE(78), 1,
      sym_comment,
    STATE(96), 1,
      sym_arguments,
    ACTIONS(33), 3,
      anon_sym_AMP,
      anon_sym_PIPE,
      aux_sym_identifier_token1,
    ACTIONS(97), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(99), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(109), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(111), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
    ACTIONS(21), 5,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_AT_AT,
  [4221] = 18,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(133), 1,
      anon_sym_RBRACK,
    STATE(33), 1,
      sym_arguments,
    STATE(79), 1,
      sym_comment,
    STATE(194), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [4288] = 16,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    STATE(33), 1,
      sym_arguments,
    STATE(80), 1,
      sym_comment,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(125), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [4351] = 16,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(95), 1,
      anon_sym_AMP_AMP,
    ACTIONS(101), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_PLUS,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_STAR_STAR,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    STATE(81), 1,
      sym_comment,
    STATE(96), 1,
      sym_arguments,
    ACTIONS(33), 2,
      anon_sym_PIPE,
      aux_sym_identifier_token1,
    ACTIONS(97), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(99), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(21), 4,
      anon_sym_RBRACE,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_AT_AT,
    ACTIONS(109), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(111), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [4414] = 18,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(137), 1,
      anon_sym_RPAREN,
    STATE(33), 1,
      sym_arguments,
    STATE(82), 1,
      sym_comment,
    STATE(201), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [4481] = 18,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(141), 1,
      anon_sym_RPAREN,
    STATE(33), 1,
      sym_arguments,
    STATE(83), 1,
      sym_comment,
    STATE(191), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [4548] = 8,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(107), 1,
      anon_sym_STAR_STAR,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    STATE(84), 1,
      sym_comment,
    STATE(96), 1,
      sym_arguments,
    ACTIONS(33), 11,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      aux_sym_identifier_token1,
    ACTIONS(21), 13,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
  [4595] = 18,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(135), 1,
      anon_sym_RBRACK,
    STATE(33), 1,
      sym_arguments,
    STATE(85), 1,
      sym_comment,
    STATE(204), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [4662] = 10,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(107), 1,
      anon_sym_STAR_STAR,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    STATE(86), 1,
      sym_comment,
    STATE(96), 1,
      sym_arguments,
    ACTIONS(97), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(99), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(33), 8,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      aux_sym_identifier_token1,
    ACTIONS(21), 10,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
  [4713] = 12,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(103), 1,
      anon_sym_PLUS,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_STAR_STAR,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    STATE(87), 1,
      sym_comment,
    STATE(96), 1,
      sym_arguments,
    ACTIONS(97), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(99), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(33), 7,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      aux_sym_identifier_token1,
    ACTIONS(21), 9,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
  [4768] = 18,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(95), 1,
      anon_sym_AMP_AMP,
    ACTIONS(101), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_PLUS,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_STAR_STAR,
    ACTIONS(117), 1,
      anon_sym_LPAREN,
    ACTIONS(121), 1,
      anon_sym_PIPE,
    ACTIONS(131), 1,
      aux_sym_identifier_token1,
    STATE(88), 1,
      sym_comment,
    STATE(96), 1,
      sym_arguments,
    ACTIONS(55), 2,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
    ACTIONS(119), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(97), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(99), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(109), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(111), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [4835] = 18,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(129), 1,
      anon_sym_RBRACK,
    STATE(33), 1,
      sym_arguments,
    STATE(89), 1,
      sym_comment,
    STATE(200), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [4902] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(90), 1,
      sym_comment,
    ACTIONS(83), 11,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      aux_sym_identifier_token1,
    ACTIONS(81), 15,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
  [4942] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(95), 1,
      anon_sym_AMP_AMP,
    ACTIONS(101), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_PLUS,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_STAR_STAR,
    STATE(91), 1,
      sym_comment,
    ACTIONS(33), 2,
      anon_sym_PIPE,
      aux_sym_identifier_token1,
    ACTIONS(97), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(99), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(109), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(111), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
    ACTIONS(21), 5,
      anon_sym_RBRACE,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
  [5000] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(92), 1,
      sym_comment,
    ACTIONS(71), 11,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      aux_sym_identifier_token1,
    ACTIONS(69), 15,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
  [5040] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(93), 1,
      sym_comment,
    ACTIONS(67), 11,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      aux_sym_identifier_token1,
    ACTIONS(65), 15,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
  [5080] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(94), 1,
      sym_comment,
    ACTIONS(87), 11,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      aux_sym_identifier_token1,
    ACTIONS(85), 15,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
  [5120] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(95), 1,
      sym_comment,
    ACTIONS(91), 11,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      aux_sym_identifier_token1,
    ACTIONS(89), 15,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
  [5160] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(96), 1,
      sym_comment,
    ACTIONS(75), 11,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      aux_sym_identifier_token1,
    ACTIONS(73), 15,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
  [5200] = 16,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(95), 1,
      anon_sym_AMP_AMP,
    ACTIONS(101), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_PLUS,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_STAR_STAR,
    ACTIONS(121), 1,
      anon_sym_PIPE,
    ACTIONS(123), 1,
      aux_sym_identifier_token1,
    STATE(97), 1,
      sym_comment,
    ACTIONS(119), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(49), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
    ACTIONS(97), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(99), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(109), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(111), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [5262] = 10,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(103), 1,
      anon_sym_PLUS,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_STAR_STAR,
    STATE(98), 1,
      sym_comment,
    ACTIONS(97), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(99), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(33), 7,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      aux_sym_identifier_token1,
    ACTIONS(21), 10,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
  [5312] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(99), 1,
      sym_comment,
    ACTIONS(79), 11,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      aux_sym_identifier_token1,
    ACTIONS(77), 15,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
  [5352] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(100), 1,
      sym_comment,
    ACTIONS(33), 11,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      aux_sym_identifier_token1,
    ACTIONS(21), 15,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
  [5392] = 8,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(107), 1,
      anon_sym_STAR_STAR,
    STATE(101), 1,
      sym_comment,
    ACTIONS(97), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(99), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(33), 8,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      aux_sym_identifier_token1,
    ACTIONS(21), 11,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
  [5438] = 16,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(95), 1,
      anon_sym_AMP_AMP,
    ACTIONS(101), 1,
      anon_sym_AMP,
    ACTIONS(103), 1,
      anon_sym_PLUS,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_STAR_STAR,
    ACTIONS(121), 1,
      anon_sym_PIPE,
    ACTIONS(131), 1,
      aux_sym_identifier_token1,
    STATE(102), 1,
      sym_comment,
    ACTIONS(119), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(55), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
    ACTIONS(97), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(99), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(109), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(111), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [5500] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(107), 1,
      anon_sym_STAR_STAR,
    STATE(103), 1,
      sym_comment,
    ACTIONS(33), 11,
      anon_sym_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      aux_sym_identifier_token1,
    ACTIONS(21), 14,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
  [5542] = 12,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(103), 1,
      anon_sym_PLUS,
    ACTIONS(105), 1,
      anon_sym_DASH,
    ACTIONS(107), 1,
      anon_sym_STAR_STAR,
    STATE(104), 1,
      sym_comment,
    ACTIONS(33), 3,
      anon_sym_AMP,
      anon_sym_PIPE,
      aux_sym_identifier_token1,
    ACTIONS(97), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(99), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(109), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(111), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
    ACTIONS(21), 6,
      anon_sym_RBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
  [5596] = 16,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(135), 1,
      anon_sym_RBRACK,
    STATE(105), 1,
      sym_comment,
    STATE(204), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [5657] = 16,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(137), 1,
      anon_sym_RPAREN,
    STATE(106), 1,
      sym_comment,
    STATE(201), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [5718] = 16,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(141), 1,
      anon_sym_RPAREN,
    STATE(107), 1,
      sym_comment,
    STATE(191), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [5779] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    STATE(108), 1,
      sym_comment,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(125), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [5836] = 16,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(139), 1,
      anon_sym_RPAREN,
    STATE(109), 1,
      sym_comment,
    STATE(193), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [5897] = 16,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(133), 1,
      anon_sym_RBRACK,
    STATE(110), 1,
      sym_comment,
    STATE(194), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [5958] = 16,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(25), 1,
      anon_sym_AMP_AMP,
    ACTIONS(31), 1,
      anon_sym_AMP,
    ACTIONS(37), 1,
      anon_sym_STAR_STAR,
    ACTIONS(53), 1,
      anon_sym_PIPE,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(129), 1,
      anon_sym_RBRACK,
    STATE(111), 1,
      sym_comment,
    STATE(200), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(35), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(51), 2,
      anon_sym_PIPE_PIPE,
      anon_sym_CARET,
    ACTIONS(27), 3,
      anon_sym_GT_GT,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(29), 3,
      anon_sym_GT_GT_GT,
      anon_sym_LT_LT,
      anon_sym_PERCENT,
    ACTIONS(39), 4,
      anon_sym_LT,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
    ACTIONS(41), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ_EQ,
      anon_sym_BANG_EQ_EQ,
      anon_sym_GT_EQ,
  [6019] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(143), 1,
      anon_sym_RPAREN,
    ACTIONS(145), 1,
      aux_sym_identifier_token1,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    STATE(53), 1,
      sym_identifier,
    STATE(61), 1,
      sym_member_expression,
    STATE(112), 1,
      sym_comment,
    STATE(199), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(147), 2,
      sym_string,
      sym_number,
    STATE(82), 2,
      sym_type_expression,
      sym_array,
    ACTIONS(151), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(106), 3,
      sym_assignment_expression,
      sym_binary_expression,
      sym_call_expression,
  [6068] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(145), 1,
      aux_sym_identifier_token1,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(155), 1,
      anon_sym_RBRACK,
    STATE(51), 1,
      sym_identifier,
    STATE(59), 1,
      sym_member_expression,
    STATE(113), 1,
      sym_comment,
    STATE(197), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(153), 2,
      sym_string,
      sym_number,
    STATE(79), 2,
      sym_type_expression,
      sym_array,
    ACTIONS(157), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(110), 3,
      sym_assignment_expression,
      sym_binary_expression,
      sym_call_expression,
  [6117] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(145), 1,
      aux_sym_identifier_token1,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(159), 1,
      anon_sym_RPAREN,
    STATE(55), 1,
      sym_identifier,
    STATE(63), 1,
      sym_member_expression,
    STATE(114), 1,
      sym_comment,
    STATE(192), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(161), 2,
      sym_string,
      sym_number,
    STATE(83), 2,
      sym_type_expression,
      sym_array,
    ACTIONS(163), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(107), 3,
      sym_assignment_expression,
      sym_binary_expression,
      sym_call_expression,
  [6166] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(145), 1,
      aux_sym_identifier_token1,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_RPAREN,
    STATE(54), 1,
      sym_identifier,
    STATE(65), 1,
      sym_member_expression,
    STATE(115), 1,
      sym_comment,
    STATE(195), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(167), 2,
      sym_string,
      sym_number,
    STATE(77), 2,
      sym_type_expression,
      sym_array,
    ACTIONS(169), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(109), 3,
      sym_assignment_expression,
      sym_binary_expression,
      sym_call_expression,
  [6215] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(145), 1,
      aux_sym_identifier_token1,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(173), 1,
      anon_sym_RBRACK,
    STATE(52), 1,
      sym_identifier,
    STATE(67), 1,
      sym_member_expression,
    STATE(116), 1,
      sym_comment,
    STATE(196), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(171), 2,
      sym_string,
      sym_number,
    STATE(85), 2,
      sym_type_expression,
      sym_array,
    ACTIONS(175), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(105), 3,
      sym_assignment_expression,
      sym_binary_expression,
      sym_call_expression,
  [6264] = 12,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(145), 1,
      aux_sym_identifier_token1,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    STATE(46), 1,
      sym_identifier,
    STATE(68), 1,
      sym_member_expression,
    STATE(117), 1,
      sym_comment,
    ACTIONS(179), 2,
      sym_string,
      sym_number,
    STATE(80), 2,
      sym_type_expression,
      sym_array,
    ACTIONS(177), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(181), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(108), 3,
      sym_assignment_expression,
      sym_binary_expression,
      sym_call_expression,
  [6309] = 14,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(145), 1,
      aux_sym_identifier_token1,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(185), 1,
      anon_sym_RBRACK,
    STATE(49), 1,
      sym_identifier,
    STATE(69), 1,
      sym_member_expression,
    STATE(118), 1,
      sym_comment,
    STATE(203), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(183), 2,
      sym_string,
      sym_number,
    STATE(89), 2,
      sym_type_expression,
      sym_array,
    ACTIONS(187), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(111), 3,
      sym_assignment_expression,
      sym_binary_expression,
      sym_call_expression,
  [6358] = 11,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(189), 1,
      aux_sym_identifier_token1,
    ACTIONS(193), 1,
      anon_sym_LBRACK,
    STATE(50), 1,
      sym_identifier,
    STATE(64), 1,
      sym_member_expression,
    STATE(119), 1,
      sym_comment,
    ACTIONS(191), 2,
      sym_string,
      sym_number,
    STATE(88), 2,
      sym_type_expression,
      sym_array,
    ACTIONS(195), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(102), 3,
      sym_assignment_expression,
      sym_binary_expression,
      sym_call_expression,
  [6398] = 11,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(189), 1,
      aux_sym_identifier_token1,
    ACTIONS(193), 1,
      anon_sym_LBRACK,
    STATE(48), 1,
      sym_identifier,
    STATE(70), 1,
      sym_member_expression,
    STATE(120), 1,
      sym_comment,
    ACTIONS(197), 2,
      sym_string,
      sym_number,
    STATE(78), 2,
      sym_type_expression,
      sym_array,
    ACTIONS(199), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(104), 3,
      sym_assignment_expression,
      sym_binary_expression,
      sym_call_expression,
  [6438] = 11,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(189), 1,
      aux_sym_identifier_token1,
    ACTIONS(193), 1,
      anon_sym_LBRACK,
    STATE(47), 1,
      sym_identifier,
    STATE(60), 1,
      sym_member_expression,
    STATE(121), 1,
      sym_comment,
    ACTIONS(201), 2,
      sym_string,
      sym_number,
    STATE(87), 2,
      sym_type_expression,
      sym_array,
    ACTIONS(203), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(98), 3,
      sym_assignment_expression,
      sym_binary_expression,
      sym_call_expression,
  [6478] = 11,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(189), 1,
      aux_sym_identifier_token1,
    ACTIONS(193), 1,
      anon_sym_LBRACK,
    STATE(56), 1,
      sym_identifier,
    STATE(62), 1,
      sym_member_expression,
    STATE(122), 1,
      sym_comment,
    ACTIONS(205), 2,
      sym_string,
      sym_number,
    STATE(74), 2,
      sym_type_expression,
      sym_array,
    ACTIONS(207), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(100), 3,
      sym_assignment_expression,
      sym_binary_expression,
      sym_call_expression,
  [6518] = 11,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(189), 1,
      aux_sym_identifier_token1,
    ACTIONS(193), 1,
      anon_sym_LBRACK,
    STATE(57), 1,
      sym_identifier,
    STATE(73), 1,
      sym_member_expression,
    STATE(123), 1,
      sym_comment,
    ACTIONS(209), 2,
      sym_string,
      sym_number,
    STATE(86), 2,
      sym_type_expression,
      sym_array,
    ACTIONS(211), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(101), 3,
      sym_assignment_expression,
      sym_binary_expression,
      sym_call_expression,
  [6558] = 11,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(189), 1,
      aux_sym_identifier_token1,
    ACTIONS(193), 1,
      anon_sym_LBRACK,
    STATE(45), 1,
      sym_identifier,
    STATE(66), 1,
      sym_member_expression,
    STATE(124), 1,
      sym_comment,
    ACTIONS(213), 2,
      sym_string,
      sym_number,
    STATE(84), 2,
      sym_type_expression,
      sym_array,
    ACTIONS(215), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(103), 3,
      sym_assignment_expression,
      sym_binary_expression,
      sym_call_expression,
  [6598] = 11,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(189), 1,
      aux_sym_identifier_token1,
    ACTIONS(193), 1,
      anon_sym_LBRACK,
    STATE(43), 1,
      sym_identifier,
    STATE(71), 1,
      sym_member_expression,
    STATE(125), 1,
      sym_comment,
    ACTIONS(217), 2,
      sym_string,
      sym_number,
    STATE(81), 2,
      sym_type_expression,
      sym_array,
    ACTIONS(219), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(91), 3,
      sym_assignment_expression,
      sym_binary_expression,
      sym_call_expression,
  [6638] = 11,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(189), 1,
      aux_sym_identifier_token1,
    ACTIONS(193), 1,
      anon_sym_LBRACK,
    STATE(44), 1,
      sym_identifier,
    STATE(72), 1,
      sym_member_expression,
    STATE(126), 1,
      sym_comment,
    ACTIONS(221), 2,
      sym_string,
      sym_number,
    STATE(76), 2,
      sym_type_expression,
      sym_array,
    ACTIONS(223), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(97), 3,
      sym_assignment_expression,
      sym_binary_expression,
      sym_call_expression,
  [6678] = 13,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(225), 1,
      anon_sym_EQ,
    ACTIONS(227), 1,
      aux_sym_identifier_token1,
    STATE(127), 1,
      sym_comment,
    STATE(143), 1,
      sym_identifier,
    STATE(162), 1,
      sym_call_expression,
    STATE(173), 1,
      sym_column_type,
    STATE(206), 1,
      sym_member_expression,
    ACTIONS(229), 2,
      sym_string,
      sym_number,
    STATE(210), 2,
      sym_type_expression,
      sym_array,
    ACTIONS(231), 3,
      sym_true,
      sym_false,
      sym_null,
  [6722] = 12,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(9), 1,
      anon_sym_datasource,
    ACTIONS(11), 1,
      anon_sym_model,
    ACTIONS(13), 1,
      anon_sym_view,
    ACTIONS(15), 1,
      anon_sym_generator,
    ACTIONS(17), 1,
      anon_sym_type,
    ACTIONS(19), 1,
      anon_sym_enum,
    ACTIONS(233), 1,
      ts_builtin_sym_end,
    STATE(128), 1,
      sym_comment,
    STATE(137), 1,
      aux_sym_program_repeat1,
    STATE(160), 6,
      sym_datasource_declaration,
      sym_model_declaration,
      sym_view_declaration,
      sym_generator_declaration,
      sym_type_declaration,
      sym_enum_declaration,
  [6764] = 11,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(145), 1,
      aux_sym_identifier_token1,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    STATE(4), 1,
      sym_identifier,
    STATE(14), 1,
      sym_member_expression,
    STATE(129), 1,
      sym_comment,
    ACTIONS(235), 2,
      sym_string,
      sym_number,
    STATE(23), 2,
      sym_type_expression,
      sym_array,
    ACTIONS(237), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(29), 3,
      sym_assignment_expression,
      sym_binary_expression,
      sym_call_expression,
  [6804] = 11,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(145), 1,
      aux_sym_identifier_token1,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    STATE(3), 1,
      sym_identifier,
    STATE(12), 1,
      sym_member_expression,
    STATE(130), 1,
      sym_comment,
    ACTIONS(239), 2,
      sym_string,
      sym_number,
    STATE(19), 2,
      sym_type_expression,
      sym_array,
    ACTIONS(241), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(41), 3,
      sym_assignment_expression,
      sym_binary_expression,
      sym_call_expression,
  [6844] = 11,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(145), 1,
      aux_sym_identifier_token1,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    STATE(2), 1,
      sym_identifier,
    STATE(11), 1,
      sym_member_expression,
    STATE(131), 1,
      sym_comment,
    ACTIONS(243), 2,
      sym_string,
      sym_number,
    STATE(22), 2,
      sym_type_expression,
      sym_array,
    ACTIONS(245), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(38), 3,
      sym_assignment_expression,
      sym_binary_expression,
      sym_call_expression,
  [6884] = 11,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(145), 1,
      aux_sym_identifier_token1,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    STATE(6), 1,
      sym_identifier,
    STATE(13), 1,
      sym_member_expression,
    STATE(132), 1,
      sym_comment,
    ACTIONS(247), 2,
      sym_string,
      sym_number,
    STATE(21), 2,
      sym_type_expression,
      sym_array,
    ACTIONS(249), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(30), 3,
      sym_assignment_expression,
      sym_binary_expression,
      sym_call_expression,
  [6924] = 11,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(145), 1,
      aux_sym_identifier_token1,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    STATE(7), 1,
      sym_identifier,
    STATE(16), 1,
      sym_member_expression,
    STATE(133), 1,
      sym_comment,
    ACTIONS(251), 2,
      sym_string,
      sym_number,
    STATE(27), 2,
      sym_type_expression,
      sym_array,
    ACTIONS(253), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(42), 3,
      sym_assignment_expression,
      sym_binary_expression,
      sym_call_expression,
  [6964] = 11,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(145), 1,
      aux_sym_identifier_token1,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    STATE(8), 1,
      sym_identifier,
    STATE(17), 1,
      sym_member_expression,
    STATE(134), 1,
      sym_comment,
    ACTIONS(255), 2,
      sym_string,
      sym_number,
    STATE(20), 2,
      sym_type_expression,
      sym_array,
    ACTIONS(257), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(40), 3,
      sym_assignment_expression,
      sym_binary_expression,
      sym_call_expression,
  [7004] = 11,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(145), 1,
      aux_sym_identifier_token1,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    STATE(9), 1,
      sym_identifier,
    STATE(18), 1,
      sym_member_expression,
    STATE(135), 1,
      sym_comment,
    ACTIONS(259), 2,
      sym_string,
      sym_number,
    STATE(26), 2,
      sym_type_expression,
      sym_array,
    ACTIONS(261), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(37), 3,
      sym_assignment_expression,
      sym_binary_expression,
      sym_call_expression,
  [7044] = 11,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(145), 1,
      aux_sym_identifier_token1,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    STATE(5), 1,
      sym_identifier,
    STATE(15), 1,
      sym_member_expression,
    STATE(136), 1,
      sym_comment,
    ACTIONS(263), 2,
      sym_string,
      sym_number,
    STATE(25), 2,
      sym_type_expression,
      sym_array,
    ACTIONS(265), 3,
      sym_true,
      sym_false,
      sym_null,
    STATE(28), 3,
      sym_assignment_expression,
      sym_binary_expression,
      sym_call_expression,
  [7084] = 11,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(267), 1,
      ts_builtin_sym_end,
    ACTIONS(269), 1,
      anon_sym_datasource,
    ACTIONS(272), 1,
      anon_sym_model,
    ACTIONS(275), 1,
      anon_sym_view,
    ACTIONS(278), 1,
      anon_sym_generator,
    ACTIONS(281), 1,
      anon_sym_type,
    ACTIONS(284), 1,
      anon_sym_enum,
    STATE(137), 2,
      sym_comment,
      aux_sym_program_repeat1,
    STATE(160), 6,
      sym_datasource_declaration,
      sym_model_declaration,
      sym_view_declaration,
      sym_generator_declaration,
      sym_type_declaration,
      sym_enum_declaration,
  [7124] = 11,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(227), 1,
      aux_sym_identifier_token1,
    STATE(138), 1,
      sym_comment,
    STATE(150), 1,
      sym_identifier,
    STATE(170), 1,
      sym_member_expression,
    STATE(183), 1,
      sym_call_expression,
    ACTIONS(229), 2,
      sym_string,
      sym_number,
    STATE(210), 2,
      sym_type_expression,
      sym_array,
    ACTIONS(231), 3,
      sym_true,
      sym_false,
      sym_null,
  [7162] = 8,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(45), 1,
      anon_sym_COLON,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    STATE(33), 1,
      sym_arguments,
    STATE(139), 1,
      sym_comment,
    ACTIONS(287), 8,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AT,
  [7194] = 11,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(145), 1,
      aux_sym_identifier_token1,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    STATE(139), 1,
      sym_identifier,
    STATE(140), 1,
      sym_comment,
    STATE(142), 1,
      sym_member_expression,
    STATE(151), 1,
      sym_call_expression,
    ACTIONS(289), 2,
      sym_string,
      sym_number,
    STATE(207), 2,
      sym_type_expression,
      sym_array,
    ACTIONS(291), 3,
      sym_true,
      sym_false,
      sym_null,
  [7232] = 11,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(149), 1,
      anon_sym_LBRACK,
    ACTIONS(227), 1,
      aux_sym_identifier_token1,
    STATE(141), 1,
      sym_comment,
    STATE(159), 1,
      sym_identifier,
    STATE(172), 1,
      sym_member_expression,
    STATE(198), 1,
      sym_call_expression,
    ACTIONS(229), 2,
      sym_string,
      sym_number,
    STATE(210), 2,
      sym_type_expression,
      sym_array,
    ACTIONS(231), 3,
      sym_true,
      sym_false,
      sym_null,
  [7270] = 7,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    STATE(33), 1,
      sym_arguments,
    STATE(142), 1,
      sym_comment,
    ACTIONS(287), 8,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AT,
  [7299] = 12,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(45), 1,
      anon_sym_COLON,
    ACTIONS(295), 1,
      anon_sym_DOT,
    ACTIONS(297), 1,
      anon_sym_AT,
    ACTIONS(299), 1,
      anon_sym_LPAREN,
    ACTIONS(301), 1,
      anon_sym_LBRACK,
    ACTIONS(303), 1,
      sym_maybe,
    STATE(143), 1,
      sym_comment,
    STATE(176), 1,
      sym_arguments,
    STATE(181), 1,
      sym_array,
    ACTIONS(293), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
  [7338] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(59), 1,
      anon_sym_AT,
    STATE(144), 1,
      sym_comment,
    ACTIONS(57), 10,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_COLON,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
      aux_sym_identifier_token1,
      anon_sym_LBRACK,
      sym_maybe,
  [7363] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(307), 1,
      anon_sym_AT,
    STATE(152), 1,
      sym_attribute,
    STATE(145), 2,
      sym_comment,
      aux_sym_type_declaration_repeat1,
    ACTIONS(305), 7,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [7389] = 7,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(312), 1,
      anon_sym_AT,
    STATE(145), 1,
      aux_sym_type_declaration_repeat1,
    STATE(146), 1,
      sym_comment,
    STATE(152), 1,
      sym_attribute,
    ACTIONS(310), 7,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [7417] = 7,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(312), 1,
      anon_sym_AT,
    STATE(145), 1,
      aux_sym_type_declaration_repeat1,
    STATE(147), 1,
      sym_comment,
    STATE(152), 1,
      sym_attribute,
    ACTIONS(314), 7,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [7445] = 7,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(312), 1,
      anon_sym_AT,
    STATE(146), 1,
      aux_sym_type_declaration_repeat1,
    STATE(148), 1,
      sym_comment,
    STATE(152), 1,
      sym_attribute,
    ACTIONS(316), 7,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [7473] = 7,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(312), 1,
      anon_sym_AT,
    STATE(147), 1,
      aux_sym_type_declaration_repeat1,
    STATE(149), 1,
      sym_comment,
    STATE(152), 1,
      sym_attribute,
    ACTIONS(318), 7,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [7501] = 9,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(45), 1,
      anon_sym_COLON,
    ACTIONS(299), 1,
      anon_sym_LPAREN,
    ACTIONS(320), 1,
      anon_sym_DOT,
    ACTIONS(322), 1,
      anon_sym_AT,
    STATE(150), 1,
      sym_comment,
    STATE(176), 1,
      sym_arguments,
    ACTIONS(287), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
  [7531] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(151), 1,
      sym_comment,
    ACTIONS(287), 8,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AT,
  [7551] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(152), 1,
      sym_comment,
    ACTIONS(324), 8,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
      anon_sym_AT,
  [7571] = 9,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(326), 1,
      anon_sym_RBRACE,
    ACTIONS(328), 1,
      anon_sym_AT_AT,
    ACTIONS(330), 1,
      aux_sym_identifier_token1,
    STATE(127), 1,
      sym_identifier,
    STATE(153), 1,
      sym_comment,
    STATE(154), 1,
      aux_sym_statement_block_repeat1,
    STATE(202), 3,
      sym_column_declaration,
      sym_assignment_expression,
      sym_block_attribute_declaration,
  [7601] = 8,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(332), 1,
      anon_sym_RBRACE,
    ACTIONS(334), 1,
      anon_sym_AT_AT,
    ACTIONS(337), 1,
      aux_sym_identifier_token1,
    STATE(127), 1,
      sym_identifier,
    STATE(154), 2,
      sym_comment,
      aux_sym_statement_block_repeat1,
    STATE(202), 3,
      sym_column_declaration,
      sym_assignment_expression,
      sym_block_attribute_declaration,
  [7629] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(155), 1,
      sym_comment,
    ACTIONS(57), 4,
      anon_sym_EQ,
      sym_string,
      sym_number,
      anon_sym_LBRACK,
    ACTIONS(59), 4,
      aux_sym_identifier_token1,
      sym_true,
      sym_false,
      sym_null,
  [7651] = 9,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(328), 1,
      anon_sym_AT_AT,
    ACTIONS(330), 1,
      aux_sym_identifier_token1,
    ACTIONS(340), 1,
      anon_sym_RBRACE,
    STATE(127), 1,
      sym_identifier,
    STATE(153), 1,
      aux_sym_statement_block_repeat1,
    STATE(156), 1,
      sym_comment,
    STATE(202), 3,
      sym_column_declaration,
      sym_assignment_expression,
      sym_block_attribute_declaration,
  [7681] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(157), 1,
      sym_comment,
    ACTIONS(342), 7,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [7700] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(158), 1,
      sym_comment,
    ACTIONS(344), 7,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [7719] = 8,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(45), 1,
      anon_sym_COLON,
    ACTIONS(299), 1,
      anon_sym_LPAREN,
    ACTIONS(320), 1,
      anon_sym_DOT,
    STATE(159), 1,
      sym_comment,
    STATE(176), 1,
      sym_arguments,
    ACTIONS(346), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
  [7746] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(160), 1,
      sym_comment,
    ACTIONS(348), 7,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [7765] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(161), 1,
      sym_comment,
    ACTIONS(350), 7,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [7784] = 8,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(297), 1,
      anon_sym_AT,
    ACTIONS(301), 1,
      anon_sym_LBRACK,
    ACTIONS(303), 1,
      sym_maybe,
    STATE(162), 1,
      sym_comment,
    STATE(181), 1,
      sym_array,
    ACTIONS(293), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
  [7811] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(163), 1,
      sym_comment,
    ACTIONS(352), 7,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [7830] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(164), 1,
      sym_comment,
    ACTIONS(354), 7,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [7849] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(165), 1,
      sym_comment,
    ACTIONS(356), 7,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [7868] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(166), 1,
      sym_comment,
    ACTIONS(358), 7,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [7887] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(167), 1,
      sym_comment,
    ACTIONS(360), 7,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [7906] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(168), 1,
      sym_comment,
    ACTIONS(362), 7,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [7925] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(169), 1,
      sym_comment,
    ACTIONS(310), 7,
      ts_builtin_sym_end,
      anon_sym_datasource,
      anon_sym_model,
      anon_sym_view,
      anon_sym_generator,
      anon_sym_type,
      anon_sym_enum,
  [7944] = 8,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(299), 1,
      anon_sym_LPAREN,
    ACTIONS(320), 1,
      anon_sym_DOT,
    ACTIONS(322), 1,
      anon_sym_AT,
    STATE(170), 1,
      sym_comment,
    STATE(176), 1,
      sym_arguments,
    ACTIONS(287), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
  [7971] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(87), 1,
      anon_sym_AT,
    STATE(171), 1,
      sym_comment,
    ACTIONS(85), 5,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
      anon_sym_LBRACK,
      sym_maybe,
  [7991] = 7,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(299), 1,
      anon_sym_LPAREN,
    ACTIONS(320), 1,
      anon_sym_DOT,
    STATE(172), 1,
      sym_comment,
    STATE(176), 1,
      sym_arguments,
    ACTIONS(346), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
  [8015] = 7,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(366), 1,
      anon_sym_AT,
    STATE(173), 1,
      sym_comment,
    STATE(179), 1,
      aux_sym_type_declaration_repeat1,
    STATE(186), 1,
      sym_attribute,
    ACTIONS(364), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
  [8039] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(79), 1,
      anon_sym_AT,
    STATE(174), 1,
      sym_comment,
    ACTIONS(77), 5,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
      anon_sym_LBRACK,
      sym_maybe,
  [8059] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(368), 1,
      anon_sym_AT,
    STATE(186), 1,
      sym_attribute,
    STATE(175), 2,
      sym_comment,
      aux_sym_type_declaration_repeat1,
    ACTIONS(305), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
  [8081] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(75), 1,
      anon_sym_AT,
    STATE(176), 1,
      sym_comment,
    ACTIONS(73), 5,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
      anon_sym_LBRACK,
      sym_maybe,
  [8101] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(91), 1,
      anon_sym_AT,
    STATE(177), 1,
      sym_comment,
    ACTIONS(89), 5,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
      anon_sym_LBRACK,
      sym_maybe,
  [8121] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(63), 1,
      anon_sym_AT,
    STATE(178), 1,
      sym_comment,
    ACTIONS(61), 5,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_AT_AT,
      anon_sym_LPAREN,
      aux_sym_identifier_token1,
  [8141] = 7,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(366), 1,
      anon_sym_AT,
    STATE(175), 1,
      aux_sym_type_declaration_repeat1,
    STATE(179), 1,
      sym_comment,
    STATE(186), 1,
      sym_attribute,
    ACTIONS(371), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
  [8165] = 8,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(373), 1,
      anon_sym_LBRACE,
    ACTIONS(375), 1,
      anon_sym_EQ,
    ACTIONS(377), 1,
      aux_sym_identifier_token1,
    STATE(149), 1,
      sym_identifier,
    STATE(169), 1,
      sym_statement_block,
    STATE(180), 1,
      sym_comment,
  [8190] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(381), 1,
      anon_sym_AT,
    STATE(181), 1,
      sym_comment,
    ACTIONS(379), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
  [8208] = 7,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(383), 1,
      anon_sym_RBRACE,
    ACTIONS(385), 1,
      aux_sym_identifier_token1,
    STATE(182), 1,
      sym_comment,
    STATE(190), 1,
      aux_sym_enum_block_repeat1,
    STATE(219), 1,
      sym_enumeral,
  [8230] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(322), 1,
      anon_sym_AT,
    STATE(183), 1,
      sym_comment,
    ACTIONS(287), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
  [8248] = 7,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(385), 1,
      aux_sym_identifier_token1,
    ACTIONS(387), 1,
      anon_sym_RBRACE,
    STATE(182), 1,
      aux_sym_enum_block_repeat1,
    STATE(184), 1,
      sym_comment,
    STATE(219), 1,
      sym_enumeral,
  [8270] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(71), 1,
      anon_sym_AT,
    STATE(185), 1,
      sym_comment,
    ACTIONS(69), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
  [8288] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(389), 1,
      anon_sym_AT,
    STATE(186), 1,
      sym_comment,
    ACTIONS(324), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
  [8306] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(67), 1,
      anon_sym_AT,
    STATE(187), 1,
      sym_comment,
    ACTIONS(65), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
  [8324] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(391), 1,
      anon_sym_COMMA,
    ACTIONS(125), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    STATE(188), 2,
      sym_comment,
      aux_sym_arguments_repeat1,
  [8342] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(83), 1,
      anon_sym_AT,
    STATE(189), 1,
      sym_comment,
    ACTIONS(81), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
  [8360] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(394), 1,
      anon_sym_RBRACE,
    ACTIONS(396), 1,
      aux_sym_identifier_token1,
    STATE(219), 1,
      sym_enumeral,
    STATE(190), 2,
      sym_comment,
      aux_sym_enum_block_repeat1,
  [8380] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(399), 1,
      anon_sym_RPAREN,
    STATE(188), 1,
      aux_sym_arguments_repeat1,
    STATE(191), 1,
      sym_comment,
  [8399] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(141), 1,
      anon_sym_RPAREN,
    STATE(188), 1,
      aux_sym_arguments_repeat1,
    STATE(192), 1,
      sym_comment,
  [8418] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(401), 1,
      anon_sym_RPAREN,
    STATE(188), 1,
      aux_sym_arguments_repeat1,
    STATE(193), 1,
      sym_comment,
  [8437] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(403), 1,
      anon_sym_RBRACK,
    STATE(188), 1,
      aux_sym_arguments_repeat1,
    STATE(194), 1,
      sym_comment,
  [8456] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(139), 1,
      anon_sym_RPAREN,
    STATE(188), 1,
      aux_sym_arguments_repeat1,
    STATE(195), 1,
      sym_comment,
  [8475] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(135), 1,
      anon_sym_RBRACK,
    STATE(188), 1,
      aux_sym_arguments_repeat1,
    STATE(196), 1,
      sym_comment,
  [8494] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(133), 1,
      anon_sym_RBRACK,
    STATE(188), 1,
      aux_sym_arguments_repeat1,
    STATE(197), 1,
      sym_comment,
  [8513] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(198), 1,
      sym_comment,
    ACTIONS(346), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
  [8528] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(137), 1,
      anon_sym_RPAREN,
    STATE(188), 1,
      aux_sym_arguments_repeat1,
    STATE(199), 1,
      sym_comment,
  [8547] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(405), 1,
      anon_sym_RBRACK,
    STATE(188), 1,
      aux_sym_arguments_repeat1,
    STATE(200), 1,
      sym_comment,
  [8566] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(407), 1,
      anon_sym_RPAREN,
    STATE(188), 1,
      aux_sym_arguments_repeat1,
    STATE(201), 1,
      sym_comment,
  [8585] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(202), 1,
      sym_comment,
    ACTIONS(409), 3,
      anon_sym_RBRACE,
      anon_sym_AT_AT,
      aux_sym_identifier_token1,
  [8600] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(129), 1,
      anon_sym_RBRACK,
    STATE(188), 1,
      aux_sym_arguments_repeat1,
    STATE(203), 1,
      sym_comment,
  [8619] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(127), 1,
      anon_sym_COMMA,
    ACTIONS(411), 1,
      anon_sym_RBRACK,
    STATE(188), 1,
      aux_sym_arguments_repeat1,
    STATE(204), 1,
      sym_comment,
  [8638] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(413), 1,
      aux_sym_identifier_token1,
    STATE(148), 1,
      sym_assignment_expression,
    STATE(180), 1,
      sym_identifier,
    STATE(205), 1,
      sym_comment,
  [8657] = 6,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(295), 1,
      anon_sym_DOT,
    ACTIONS(299), 1,
      anon_sym_LPAREN,
    STATE(176), 1,
      sym_arguments,
    STATE(206), 1,
      sym_comment,
  [8676] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(47), 1,
      anon_sym_LPAREN,
    STATE(33), 1,
      sym_arguments,
    STATE(207), 1,
      sym_comment,
  [8692] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(373), 1,
      anon_sym_LBRACE,
    STATE(161), 1,
      sym_statement_block,
    STATE(208), 1,
      sym_comment,
  [8708] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(413), 1,
      aux_sym_identifier_token1,
    STATE(209), 1,
      sym_comment,
    STATE(224), 1,
      sym_identifier,
  [8724] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(299), 1,
      anon_sym_LPAREN,
    STATE(176), 1,
      sym_arguments,
    STATE(210), 1,
      sym_comment,
  [8740] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(377), 1,
      aux_sym_identifier_token1,
    STATE(24), 1,
      sym_identifier,
    STATE(211), 1,
      sym_comment,
  [8756] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(413), 1,
      aux_sym_identifier_token1,
    STATE(24), 1,
      sym_identifier,
    STATE(212), 1,
      sym_comment,
  [8772] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(413), 1,
      aux_sym_identifier_token1,
    STATE(178), 1,
      sym_identifier,
    STATE(213), 1,
      sym_comment,
  [8788] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(373), 1,
      anon_sym_LBRACE,
    STATE(158), 1,
      sym_statement_block,
    STATE(214), 1,
      sym_comment,
  [8804] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(373), 1,
      anon_sym_LBRACE,
    STATE(167), 1,
      sym_statement_block,
    STATE(215), 1,
      sym_comment,
  [8820] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(413), 1,
      aux_sym_identifier_token1,
    STATE(216), 1,
      sym_comment,
    STATE(218), 1,
      sym_identifier,
  [8836] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(413), 1,
      aux_sym_identifier_token1,
    STATE(215), 1,
      sym_identifier,
    STATE(217), 1,
      sym_comment,
  [8852] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(373), 1,
      anon_sym_LBRACE,
    STATE(164), 1,
      sym_statement_block,
    STATE(218), 1,
      sym_comment,
  [8868] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(219), 1,
      sym_comment,
    ACTIONS(415), 2,
      anon_sym_RBRACE,
      aux_sym_identifier_token1,
  [8882] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    STATE(220), 1,
      sym_comment,
    ACTIONS(417), 2,
      anon_sym_RBRACE,
      aux_sym_identifier_token1,
  [8896] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(413), 1,
      aux_sym_identifier_token1,
    STATE(214), 1,
      sym_identifier,
    STATE(221), 1,
      sym_comment,
  [8912] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(413), 1,
      aux_sym_identifier_token1,
    STATE(208), 1,
      sym_identifier,
    STATE(222), 1,
      sym_comment,
  [8928] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(419), 1,
      aux_sym_identifier_token1,
    STATE(75), 1,
      sym_identifier,
    STATE(223), 1,
      sym_comment,
  [8944] = 5,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(421), 1,
      anon_sym_LBRACE,
    STATE(168), 1,
      sym_enum_block,
    STATE(224), 1,
      sym_comment,
  [8960] = 4,
    ACTIONS(3), 1,
      sym_developer_comment,
    ACTIONS(5), 1,
      aux_sym_comment_token1,
    ACTIONS(423), 1,
      ts_builtin_sym_end,
    STATE(225), 1,
      sym_comment,
  [8973] = 1,
    ACTIONS(425), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(11)] = 0,
  [SMALL_STATE(12)] = 72,
  [SMALL_STATE(13)] = 140,
  [SMALL_STATE(14)] = 198,
  [SMALL_STATE(15)] = 272,
  [SMALL_STATE(16)] = 346,
  [SMALL_STATE(17)] = 408,
  [SMALL_STATE(18)] = 464,
  [SMALL_STATE(19)] = 528,
  [SMALL_STATE(20)] = 593,
  [SMALL_STATE(21)] = 646,
  [SMALL_STATE(22)] = 701,
  [SMALL_STATE(23)] = 770,
  [SMALL_STATE(24)] = 841,
  [SMALL_STATE(25)] = 890,
  [SMALL_STATE(26)] = 961,
  [SMALL_STATE(27)] = 1022,
  [SMALL_STATE(28)] = 1081,
  [SMALL_STATE(29)] = 1147,
  [SMALL_STATE(30)] = 1213,
  [SMALL_STATE(31)] = 1263,
  [SMALL_STATE(32)] = 1311,
  [SMALL_STATE(33)] = 1359,
  [SMALL_STATE(34)] = 1407,
  [SMALL_STATE(35)] = 1455,
  [SMALL_STATE(36)] = 1503,
  [SMALL_STATE(37)] = 1551,
  [SMALL_STATE(38)] = 1607,
  [SMALL_STATE(39)] = 1671,
  [SMALL_STATE(40)] = 1719,
  [SMALL_STATE(41)] = 1767,
  [SMALL_STATE(42)] = 1827,
  [SMALL_STATE(43)] = 1881,
  [SMALL_STATE(44)] = 1953,
  [SMALL_STATE(45)] = 2029,
  [SMALL_STATE(46)] = 2085,
  [SMALL_STATE(47)] = 2157,
  [SMALL_STATE(48)] = 2221,
  [SMALL_STATE(49)] = 2289,
  [SMALL_STATE(50)] = 2365,
  [SMALL_STATE(51)] = 2441,
  [SMALL_STATE(52)] = 2517,
  [SMALL_STATE(53)] = 2593,
  [SMALL_STATE(54)] = 2669,
  [SMALL_STATE(55)] = 2745,
  [SMALL_STATE(56)] = 2821,
  [SMALL_STATE(57)] = 2875,
  [SMALL_STATE(58)] = 2935,
  [SMALL_STATE(59)] = 2978,
  [SMALL_STATE(60)] = 3048,
  [SMALL_STATE(61)] = 3106,
  [SMALL_STATE(62)] = 3176,
  [SMALL_STATE(63)] = 3224,
  [SMALL_STATE(64)] = 3294,
  [SMALL_STATE(65)] = 3364,
  [SMALL_STATE(66)] = 3434,
  [SMALL_STATE(67)] = 3484,
  [SMALL_STATE(68)] = 3554,
  [SMALL_STATE(69)] = 3620,
  [SMALL_STATE(70)] = 3690,
  [SMALL_STATE(71)] = 3752,
  [SMALL_STATE(72)] = 3818,
  [SMALL_STATE(73)] = 3888,
  [SMALL_STATE(74)] = 3942,
  [SMALL_STATE(75)] = 3987,
  [SMALL_STATE(76)] = 4028,
  [SMALL_STATE(77)] = 4095,
  [SMALL_STATE(78)] = 4162,
  [SMALL_STATE(79)] = 4221,
  [SMALL_STATE(80)] = 4288,
  [SMALL_STATE(81)] = 4351,
  [SMALL_STATE(82)] = 4414,
  [SMALL_STATE(83)] = 4481,
  [SMALL_STATE(84)] = 4548,
  [SMALL_STATE(85)] = 4595,
  [SMALL_STATE(86)] = 4662,
  [SMALL_STATE(87)] = 4713,
  [SMALL_STATE(88)] = 4768,
  [SMALL_STATE(89)] = 4835,
  [SMALL_STATE(90)] = 4902,
  [SMALL_STATE(91)] = 4942,
  [SMALL_STATE(92)] = 5000,
  [SMALL_STATE(93)] = 5040,
  [SMALL_STATE(94)] = 5080,
  [SMALL_STATE(95)] = 5120,
  [SMALL_STATE(96)] = 5160,
  [SMALL_STATE(97)] = 5200,
  [SMALL_STATE(98)] = 5262,
  [SMALL_STATE(99)] = 5312,
  [SMALL_STATE(100)] = 5352,
  [SMALL_STATE(101)] = 5392,
  [SMALL_STATE(102)] = 5438,
  [SMALL_STATE(103)] = 5500,
  [SMALL_STATE(104)] = 5542,
  [SMALL_STATE(105)] = 5596,
  [SMALL_STATE(106)] = 5657,
  [SMALL_STATE(107)] = 5718,
  [SMALL_STATE(108)] = 5779,
  [SMALL_STATE(109)] = 5836,
  [SMALL_STATE(110)] = 5897,
  [SMALL_STATE(111)] = 5958,
  [SMALL_STATE(112)] = 6019,
  [SMALL_STATE(113)] = 6068,
  [SMALL_STATE(114)] = 6117,
  [SMALL_STATE(115)] = 6166,
  [SMALL_STATE(116)] = 6215,
  [SMALL_STATE(117)] = 6264,
  [SMALL_STATE(118)] = 6309,
  [SMALL_STATE(119)] = 6358,
  [SMALL_STATE(120)] = 6398,
  [SMALL_STATE(121)] = 6438,
  [SMALL_STATE(122)] = 6478,
  [SMALL_STATE(123)] = 6518,
  [SMALL_STATE(124)] = 6558,
  [SMALL_STATE(125)] = 6598,
  [SMALL_STATE(126)] = 6638,
  [SMALL_STATE(127)] = 6678,
  [SMALL_STATE(128)] = 6722,
  [SMALL_STATE(129)] = 6764,
  [SMALL_STATE(130)] = 6804,
  [SMALL_STATE(131)] = 6844,
  [SMALL_STATE(132)] = 6884,
  [SMALL_STATE(133)] = 6924,
  [SMALL_STATE(134)] = 6964,
  [SMALL_STATE(135)] = 7004,
  [SMALL_STATE(136)] = 7044,
  [SMALL_STATE(137)] = 7084,
  [SMALL_STATE(138)] = 7124,
  [SMALL_STATE(139)] = 7162,
  [SMALL_STATE(140)] = 7194,
  [SMALL_STATE(141)] = 7232,
  [SMALL_STATE(142)] = 7270,
  [SMALL_STATE(143)] = 7299,
  [SMALL_STATE(144)] = 7338,
  [SMALL_STATE(145)] = 7363,
  [SMALL_STATE(146)] = 7389,
  [SMALL_STATE(147)] = 7417,
  [SMALL_STATE(148)] = 7445,
  [SMALL_STATE(149)] = 7473,
  [SMALL_STATE(150)] = 7501,
  [SMALL_STATE(151)] = 7531,
  [SMALL_STATE(152)] = 7551,
  [SMALL_STATE(153)] = 7571,
  [SMALL_STATE(154)] = 7601,
  [SMALL_STATE(155)] = 7629,
  [SMALL_STATE(156)] = 7651,
  [SMALL_STATE(157)] = 7681,
  [SMALL_STATE(158)] = 7700,
  [SMALL_STATE(159)] = 7719,
  [SMALL_STATE(160)] = 7746,
  [SMALL_STATE(161)] = 7765,
  [SMALL_STATE(162)] = 7784,
  [SMALL_STATE(163)] = 7811,
  [SMALL_STATE(164)] = 7830,
  [SMALL_STATE(165)] = 7849,
  [SMALL_STATE(166)] = 7868,
  [SMALL_STATE(167)] = 7887,
  [SMALL_STATE(168)] = 7906,
  [SMALL_STATE(169)] = 7925,
  [SMALL_STATE(170)] = 7944,
  [SMALL_STATE(171)] = 7971,
  [SMALL_STATE(172)] = 7991,
  [SMALL_STATE(173)] = 8015,
  [SMALL_STATE(174)] = 8039,
  [SMALL_STATE(175)] = 8059,
  [SMALL_STATE(176)] = 8081,
  [SMALL_STATE(177)] = 8101,
  [SMALL_STATE(178)] = 8121,
  [SMALL_STATE(179)] = 8141,
  [SMALL_STATE(180)] = 8165,
  [SMALL_STATE(181)] = 8190,
  [SMALL_STATE(182)] = 8208,
  [SMALL_STATE(183)] = 8230,
  [SMALL_STATE(184)] = 8248,
  [SMALL_STATE(185)] = 8270,
  [SMALL_STATE(186)] = 8288,
  [SMALL_STATE(187)] = 8306,
  [SMALL_STATE(188)] = 8324,
  [SMALL_STATE(189)] = 8342,
  [SMALL_STATE(190)] = 8360,
  [SMALL_STATE(191)] = 8380,
  [SMALL_STATE(192)] = 8399,
  [SMALL_STATE(193)] = 8418,
  [SMALL_STATE(194)] = 8437,
  [SMALL_STATE(195)] = 8456,
  [SMALL_STATE(196)] = 8475,
  [SMALL_STATE(197)] = 8494,
  [SMALL_STATE(198)] = 8513,
  [SMALL_STATE(199)] = 8528,
  [SMALL_STATE(200)] = 8547,
  [SMALL_STATE(201)] = 8566,
  [SMALL_STATE(202)] = 8585,
  [SMALL_STATE(203)] = 8600,
  [SMALL_STATE(204)] = 8619,
  [SMALL_STATE(205)] = 8638,
  [SMALL_STATE(206)] = 8657,
  [SMALL_STATE(207)] = 8676,
  [SMALL_STATE(208)] = 8692,
  [SMALL_STATE(209)] = 8708,
  [SMALL_STATE(210)] = 8724,
  [SMALL_STATE(211)] = 8740,
  [SMALL_STATE(212)] = 8756,
  [SMALL_STATE(213)] = 8772,
  [SMALL_STATE(214)] = 8788,
  [SMALL_STATE(215)] = 8804,
  [SMALL_STATE(216)] = 8820,
  [SMALL_STATE(217)] = 8836,
  [SMALL_STATE(218)] = 8852,
  [SMALL_STATE(219)] = 8868,
  [SMALL_STATE(220)] = 8882,
  [SMALL_STATE(221)] = 8896,
  [SMALL_STATE(222)] = 8912,
  [SMALL_STATE(223)] = 8928,
  [SMALL_STATE(224)] = 8944,
  [SMALL_STATE(225)] = 8960,
  [SMALL_STATE(226)] = 8973,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [7] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 0),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [21] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3, .production_id = 4),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(136),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(132),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(130),
  [33] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3, .production_id = 4),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(135),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [49] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_expression, 3),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(131),
  [55] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment_expression, 3, .production_id = 2),
  [57] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_identifier, 1),
  [59] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_identifier, 1),
  [61] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_member_expression, 3, .production_id = 3),
  [63] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_member_expression, 3, .production_id = 3),
  [65] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array, 3),
  [67] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array, 3),
  [69] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array, 2),
  [71] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array, 2),
  [73] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_expression, 2),
  [75] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_expression, 2),
  [77] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 4),
  [79] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 4),
  [81] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array, 4),
  [83] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array, 4),
  [85] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 3),
  [87] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 3),
  [89] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 2),
  [91] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 2),
  [93] = {.entry = {.count = 1, .reusable = false}}, SHIFT(119),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [97] = {.entry = {.count = 1, .reusable = false}}, SHIFT(124),
  [99] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [101] = {.entry = {.count = 1, .reusable = false}}, SHIFT(120),
  [103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [105] = {.entry = {.count = 1, .reusable = false}}, SHIFT(123),
  [107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [109] = {.entry = {.count = 1, .reusable = false}}, SHIFT(121),
  [111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [121] = {.entry = {.count = 1, .reusable = false}}, SHIFT(125),
  [123] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_expression, 3),
  [125] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [131] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assignment_expression, 3, .production_id = 2),
  [133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [145] = {.entry = {.count = 1, .reusable = false}}, SHIFT(10),
  [147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [151] = {.entry = {.count = 1, .reusable = false}}, SHIFT(82),
  [153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [157] = {.entry = {.count = 1, .reusable = false}}, SHIFT(79),
  [159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [163] = {.entry = {.count = 1, .reusable = false}}, SHIFT(83),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [169] = {.entry = {.count = 1, .reusable = false}}, SHIFT(77),
  [171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [175] = {.entry = {.count = 1, .reusable = false}}, SHIFT(85),
  [177] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 1),
  [179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [181] = {.entry = {.count = 1, .reusable = false}}, SHIFT(80),
  [183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [187] = {.entry = {.count = 1, .reusable = false}}, SHIFT(89),
  [189] = {.entry = {.count = 1, .reusable = false}}, SHIFT(58),
  [191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [195] = {.entry = {.count = 1, .reusable = false}}, SHIFT(88),
  [197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [199] = {.entry = {.count = 1, .reusable = false}}, SHIFT(78),
  [201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [203] = {.entry = {.count = 1, .reusable = false}}, SHIFT(87),
  [205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [207] = {.entry = {.count = 1, .reusable = false}}, SHIFT(74),
  [209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [211] = {.entry = {.count = 1, .reusable = false}}, SHIFT(86),
  [213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [215] = {.entry = {.count = 1, .reusable = false}}, SHIFT(84),
  [217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [219] = {.entry = {.count = 1, .reusable = false}}, SHIFT(81),
  [221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [223] = {.entry = {.count = 1, .reusable = false}}, SHIFT(76),
  [225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [227] = {.entry = {.count = 1, .reusable = false}}, SHIFT(144),
  [229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [231] = {.entry = {.count = 1, .reusable = false}}, SHIFT(210),
  [233] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 1),
  [235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [237] = {.entry = {.count = 1, .reusable = false}}, SHIFT(23),
  [239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [241] = {.entry = {.count = 1, .reusable = false}}, SHIFT(19),
  [243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [245] = {.entry = {.count = 1, .reusable = false}}, SHIFT(22),
  [247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [249] = {.entry = {.count = 1, .reusable = false}}, SHIFT(21),
  [251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [253] = {.entry = {.count = 1, .reusable = false}}, SHIFT(27),
  [255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [257] = {.entry = {.count = 1, .reusable = false}}, SHIFT(20),
  [259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [261] = {.entry = {.count = 1, .reusable = false}}, SHIFT(26),
  [263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [265] = {.entry = {.count = 1, .reusable = false}}, SHIFT(25),
  [267] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2),
  [269] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(222),
  [272] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(221),
  [275] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(217),
  [278] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(216),
  [281] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(205),
  [284] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(209),
  [287] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 2),
  [289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [291] = {.entry = {.count = 1, .reusable = false}}, SHIFT(207),
  [293] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_column_type, 1),
  [295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [297] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_column_type, 1),
  [299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [305] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_declaration_repeat1, 2),
  [307] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_declaration_repeat1, 2), SHIFT_REPEAT(140),
  [310] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_declaration, 3),
  [312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [314] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_declaration, 4, .production_id = 1),
  [316] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_declaration, 2),
  [318] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_declaration, 3, .production_id = 1),
  [320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [322] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute, 2),
  [324] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_declaration_repeat1, 1),
  [326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [332] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_block_repeat1, 2),
  [334] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_block_repeat1, 2), SHIFT_REPEAT(141),
  [337] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_block_repeat1, 2), SHIFT_REPEAT(155),
  [340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [342] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement_block, 2),
  [344] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_model_declaration, 3),
  [346] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_attribute_declaration, 2),
  [348] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 1),
  [350] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_datasource_declaration, 3),
  [352] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement_block, 3),
  [354] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_generator_declaration, 3),
  [356] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_block, 2),
  [358] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_block, 3),
  [360] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_view_declaration, 3),
  [362] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_declaration, 3),
  [364] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_column_declaration, 2),
  [366] = {.entry = {.count = 1, .reusable = false}}, SHIFT(138),
  [368] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_type_declaration_repeat1, 2), SHIFT_REPEAT(138),
  [371] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_column_declaration, 3),
  [373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [375] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [377] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [379] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_column_type, 2),
  [381] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_column_type, 2),
  [383] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [385] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [387] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [389] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_type_declaration_repeat1, 1),
  [391] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2), SHIFT_REPEAT(117),
  [394] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_enum_block_repeat1, 2),
  [396] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enum_block_repeat1, 2), SHIFT_REPEAT(220),
  [399] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [409] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_block_repeat1, 1),
  [411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [413] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [415] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_enum_block_repeat1, 1),
  [417] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enumeral, 1),
  [419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [423] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [425] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 1),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_prisma(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
