#define HYPRE_SPGEMM_BIN 1

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/

#include "seq_mv.h"

#if defined(HYPRE_USING_GPU)

#if HYPRE_SPGEMM_BIN >= 10
#define HYPRE_SPGEMM_DEVICE_USE_DSHMEM
#endif

#include <csr_spgemm_device_numer.h>

template HYPRE_Int
hypre_spgemm_numerical_with_rownnz
< HYPRE_SPGEMM_BIN, NUMER_HASH_SIZE[HYPRE_SPGEMM_BIN], T_GROUP_SIZE[HYPRE_SPGEMM_BIN], true >
( HYPRE_Int m, HYPRE_Int *row_ind, HYPRE_Int k, HYPRE_Int n, bool need_ghash,
  HYPRE_Int exact_rownnz,
  HYPRE_Int *d_ia, HYPRE_Int *d_ja, HYPRE_Complex *d_a, HYPRE_Int *d_ib, HYPRE_Int *d_jb,
  HYPRE_Complex *d_b,
  HYPRE_Int *d_rc, HYPRE_Int *d_ic, HYPRE_Int *d_jc, HYPRE_Complex *d_c );

#if HYPRE_SPGEMM_BIN == HYPRE_SPGEMM_DEFAULT_BIN
template HYPRE_Int
hypre_spgemm_numerical_with_rownnz
< HYPRE_SPGEMM_BIN, NUMER_HASH_SIZE[HYPRE_SPGEMM_BIN], T_GROUP_SIZE[HYPRE_SPGEMM_BIN], false >
( HYPRE_Int m, HYPRE_Int *row_ind, HYPRE_Int k, HYPRE_Int n, bool need_ghash,
  HYPRE_Int exact_rownnz,
  HYPRE_Int *d_ia, HYPRE_Int *d_ja, HYPRE_Complex *d_a, HYPRE_Int *d_ib, HYPRE_Int *d_jb,
  HYPRE_Complex *d_b,
  HYPRE_Int *d_rc, HYPRE_Int *d_ic, HYPRE_Int *d_jc, HYPRE_Complex *d_c );
#endif

template HYPRE_Int
hypre_spgemm_numerical_max_num_blocks
< NUMER_HASH_SIZE[HYPRE_SPGEMM_BIN], T_GROUP_SIZE[HYPRE_SPGEMM_BIN] >
( HYPRE_Int multiProcessorCount, HYPRE_Int *num_blocks_ptr, HYPRE_Int *block_size_ptr );

#if HYPRE_SPGEMM_BIN == 5
template HYPRE_Int
hypreDevice_CSRSpGemmNumerPostCopy<T_GROUP_SIZE[HYPRE_SPGEMM_BIN]>
( HYPRE_Int m, HYPRE_Int *d_rc, HYPRE_Int *nnzC, HYPRE_Int **d_ic, HYPRE_Int **d_jc, HYPRE_Complex **d_c );
#endif

#endif /* defined(HYPRE_USING_GPU) */
