// Generated with hyprwayland-scanner 0.4.5. Made with vaxry's keyboard and ❤️.
// xx_color_management_v4

/*
 This protocol's authors' copyright notice is:


    Copyright 2019 Sebastian Wick
    Copyright 2019 Erwin Burema
    Copyright 2020 AMD
    Copyright 2020-2024 Collabora, Ltd.
    Copyright 2024 Xaver Hugl

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice (including the next
    paragraph) shall be included in all copies or substantial portions of the
    Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
    THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.
  
*/

#define private public
#define HYPRWAYLAND_SCANNER_NO_INTERFACES
#include "xx-color-management-v4.hpp"
#undef private
#define F std::function

static const wl_interface* xxColorManagementV4_dummyTypes[] = { nullptr };

// Reference all other interfaces.
// The reason why this is in snake is to
// be able to cooperate with existing
// wayland_scanner interfaces (they are interop)
extern const wl_interface xx_color_manager_v4_interface;
extern const wl_interface xx_color_management_output_v4_interface;
extern const wl_interface xx_color_management_surface_v4_interface;
extern const wl_interface xx_color_management_feedback_surface_v4_interface;
extern const wl_interface xx_image_description_creator_icc_v4_interface;
extern const wl_interface xx_image_description_creator_params_v4_interface;
extern const wl_interface xx_image_description_v4_interface;
extern const wl_interface xx_image_description_info_v4_interface;
extern const wl_interface wl_output_interface;
extern const wl_interface wl_surface_interface;

static void _CXxColorManagerV4Destroy(wl_client* client, wl_resource* resource) {
    const auto PO = (CXxColorManagerV4*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.destroy)
        PO->requests.destroy(PO);
}

static void _CXxColorManagerV4GetOutput(wl_client* client, wl_resource* resource, uint32_t id, wl_resource* output) {
    const auto PO = (CXxColorManagerV4*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.getOutput)
        PO->requests.getOutput(PO, id, output);
}

static void _CXxColorManagerV4GetSurface(wl_client* client, wl_resource* resource, uint32_t id, wl_resource* surface) {
    const auto PO = (CXxColorManagerV4*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.getSurface)
        PO->requests.getSurface(PO, id, surface);
}

static void _CXxColorManagerV4GetFeedbackSurface(wl_client* client, wl_resource* resource, uint32_t id, wl_resource* surface) {
    const auto PO = (CXxColorManagerV4*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.getFeedbackSurface)
        PO->requests.getFeedbackSurface(PO, id, surface);
}

static void _CXxColorManagerV4NewIccCreator(wl_client* client, wl_resource* resource, uint32_t obj) {
    const auto PO = (CXxColorManagerV4*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.newIccCreator)
        PO->requests.newIccCreator(PO, obj);
}

static void _CXxColorManagerV4NewParametricCreator(wl_client* client, wl_resource* resource, uint32_t obj) {
    const auto PO = (CXxColorManagerV4*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.newParametricCreator)
        PO->requests.newParametricCreator(PO, obj);
}

static void _CXxColorManagerV4__DestroyListener(wl_listener* l, void* d) {
    CXxColorManagerV4DestroyWrapper *wrap = wl_container_of(l, wrap, listener);
    CXxColorManagerV4* pResource = wrap->parent;
    pResource->onDestroyCalled();
}

static const void* _CXxColorManagerV4VTable[] = {
    (void*)_CXxColorManagerV4Destroy,
    (void*)_CXxColorManagerV4GetOutput,
    (void*)_CXxColorManagerV4GetSurface,
    (void*)_CXxColorManagerV4GetFeedbackSurface,
    (void*)_CXxColorManagerV4NewIccCreator,
    (void*)_CXxColorManagerV4NewParametricCreator,
};

void CXxColorManagerV4::sendSupportedIntent(xxColorManagerV4RenderIntent render_intent) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 0, render_intent);
}

void CXxColorManagerV4::sendSupportedFeature(xxColorManagerV4Feature feature) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 1, feature);
}

void CXxColorManagerV4::sendSupportedTfNamed(xxColorManagerV4TransferFunction tf) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 2, tf);
}

void CXxColorManagerV4::sendSupportedPrimariesNamed(xxColorManagerV4Primaries primaries) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 3, primaries);
}

void CXxColorManagerV4::sendSupportedIntentRaw(xxColorManagerV4RenderIntent render_intent) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 0, render_intent);
}

void CXxColorManagerV4::sendSupportedFeatureRaw(xxColorManagerV4Feature feature) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 1, feature);
}

void CXxColorManagerV4::sendSupportedTfNamedRaw(xxColorManagerV4TransferFunction tf) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 2, tf);
}

void CXxColorManagerV4::sendSupportedPrimariesNamedRaw(xxColorManagerV4Primaries primaries) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 3, primaries);
}
static const wl_interface* _CXxColorManagerV4GetOutputTypes[] = {
    &xx_color_management_output_v4_interface,
    &wl_output_interface,
};
static const wl_interface* _CXxColorManagerV4GetSurfaceTypes[] = {
    &xx_color_management_surface_v4_interface,
    &wl_surface_interface,
};
static const wl_interface* _CXxColorManagerV4GetFeedbackSurfaceTypes[] = {
    &xx_color_management_feedback_surface_v4_interface,
    &wl_surface_interface,
};
static const wl_interface* _CXxColorManagerV4NewIccCreatorTypes[] = {
    &xx_image_description_creator_icc_v4_interface,
};
static const wl_interface* _CXxColorManagerV4NewParametricCreatorTypes[] = {
    &xx_image_description_creator_params_v4_interface,
};
static const wl_interface* _CXxColorManagerV4SupportedIntentTypes[] = {
    nullptr,
};
static const wl_interface* _CXxColorManagerV4SupportedFeatureTypes[] = {
    nullptr,
};
static const wl_interface* _CXxColorManagerV4SupportedTfNamedTypes[] = {
    nullptr,
};
static const wl_interface* _CXxColorManagerV4SupportedPrimariesNamedTypes[] = {
    nullptr,
};

static const wl_message _CXxColorManagerV4Requests[] = {
    { .name = "destroy", .signature = "", .types = xxColorManagementV4_dummyTypes + 0},
    { .name = "get_output", .signature = "no", .types = _CXxColorManagerV4GetOutputTypes + 0},
    { .name = "get_surface", .signature = "no", .types = _CXxColorManagerV4GetSurfaceTypes + 0},
    { .name = "get_feedback_surface", .signature = "no", .types = _CXxColorManagerV4GetFeedbackSurfaceTypes + 0},
    { .name = "new_icc_creator", .signature = "n", .types = _CXxColorManagerV4NewIccCreatorTypes + 0},
    { .name = "new_parametric_creator", .signature = "n", .types = _CXxColorManagerV4NewParametricCreatorTypes + 0},
};

static const wl_message _CXxColorManagerV4Events[] = {
    { .name = "supported_intent", .signature = "u", .types = _CXxColorManagerV4SupportedIntentTypes + 0},
    { .name = "supported_feature", .signature = "u", .types = _CXxColorManagerV4SupportedFeatureTypes + 0},
    { .name = "supported_tf_named", .signature = "u", .types = _CXxColorManagerV4SupportedTfNamedTypes + 0},
    { .name = "supported_primaries_named", .signature = "u", .types = _CXxColorManagerV4SupportedPrimariesNamedTypes + 0},
};

const wl_interface xx_color_manager_v4_interface = {
    .name = "xx_color_manager_v4", .version = 1,
    .method_count = 6, .methods = _CXxColorManagerV4Requests,
    .event_count = 4, .events = _CXxColorManagerV4Events,
};

CXxColorManagerV4::CXxColorManagerV4(wl_client* client, uint32_t version, uint32_t id) :
    pResource(wl_resource_create(client, &xx_color_manager_v4_interface, version, id)) {

    if (!pResource)
        return;

    wl_resource_set_user_data(pResource, this);
    wl_list_init(&resourceDestroyListener.listener.link);
    resourceDestroyListener.listener.notify = _CXxColorManagerV4__DestroyListener;
    resourceDestroyListener.parent = this;
    wl_resource_add_destroy_listener(pResource, &resourceDestroyListener.listener);

    wl_resource_set_implementation(pResource, _CXxColorManagerV4VTable, this, nullptr);
}

CXxColorManagerV4::~CXxColorManagerV4() {
    wl_list_remove(&resourceDestroyListener.listener.link);
    wl_list_init(&resourceDestroyListener.listener.link);

    // if we still own the wayland resource,
    // it means we need to destroy it.
    if (pResource && wl_resource_get_user_data(pResource) == this) {
        wl_resource_set_user_data(pResource, nullptr);
        wl_resource_destroy(pResource);
    }
}

void CXxColorManagerV4::onDestroyCalled() {
    wl_resource_set_user_data(pResource, nullptr);
    wl_list_remove(&resourceDestroyListener.listener.link);
    wl_list_init(&resourceDestroyListener.listener.link);

    // set the resource to nullptr,
    // as it will be freed. If the consumer does not destroy this resource
    // in onDestroy here, we'd be doing a UAF in the ~dtor
    pResource = nullptr;

    if (onDestroy)
        onDestroy(this);
}

void CXxColorManagerV4::setDestroy(F<void(CXxColorManagerV4*)> handler) {
    requests.destroy = handler;
}

void CXxColorManagerV4::setGetOutput(F<void(CXxColorManagerV4*, uint32_t, wl_resource*)> handler) {
    requests.getOutput = handler;
}

void CXxColorManagerV4::setGetSurface(F<void(CXxColorManagerV4*, uint32_t, wl_resource*)> handler) {
    requests.getSurface = handler;
}

void CXxColorManagerV4::setGetFeedbackSurface(F<void(CXxColorManagerV4*, uint32_t, wl_resource*)> handler) {
    requests.getFeedbackSurface = handler;
}

void CXxColorManagerV4::setNewIccCreator(F<void(CXxColorManagerV4*, uint32_t)> handler) {
    requests.newIccCreator = handler;
}

void CXxColorManagerV4::setNewParametricCreator(F<void(CXxColorManagerV4*, uint32_t)> handler) {
    requests.newParametricCreator = handler;
}

static void _CXxColorManagementOutputV4Destroy(wl_client* client, wl_resource* resource) {
    const auto PO = (CXxColorManagementOutputV4*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.destroy)
        PO->requests.destroy(PO);
}

static void _CXxColorManagementOutputV4GetImageDescription(wl_client* client, wl_resource* resource, uint32_t image_description) {
    const auto PO = (CXxColorManagementOutputV4*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.getImageDescription)
        PO->requests.getImageDescription(PO, image_description);
}

static void _CXxColorManagementOutputV4__DestroyListener(wl_listener* l, void* d) {
    CXxColorManagementOutputV4DestroyWrapper *wrap = wl_container_of(l, wrap, listener);
    CXxColorManagementOutputV4* pResource = wrap->parent;
    pResource->onDestroyCalled();
}

static const void* _CXxColorManagementOutputV4VTable[] = {
    (void*)_CXxColorManagementOutputV4Destroy,
    (void*)_CXxColorManagementOutputV4GetImageDescription,
};

void CXxColorManagementOutputV4::sendImageDescriptionChanged() {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 0);
}

void CXxColorManagementOutputV4::sendImageDescriptionChangedRaw() {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 0);
}
static const wl_interface* _CXxColorManagementOutputV4GetImageDescriptionTypes[] = {
    &xx_image_description_v4_interface,
};

static const wl_message _CXxColorManagementOutputV4Requests[] = {
    { .name = "destroy", .signature = "", .types = xxColorManagementV4_dummyTypes + 0},
    { .name = "get_image_description", .signature = "n", .types = _CXxColorManagementOutputV4GetImageDescriptionTypes + 0},
};

static const wl_message _CXxColorManagementOutputV4Events[] = {
    { .name = "image_description_changed", .signature = "", .types = xxColorManagementV4_dummyTypes + 0},
};

const wl_interface xx_color_management_output_v4_interface = {
    .name = "xx_color_management_output_v4", .version = 1,
    .method_count = 2, .methods = _CXxColorManagementOutputV4Requests,
    .event_count = 1, .events = _CXxColorManagementOutputV4Events,
};

CXxColorManagementOutputV4::CXxColorManagementOutputV4(wl_client* client, uint32_t version, uint32_t id) :
    pResource(wl_resource_create(client, &xx_color_management_output_v4_interface, version, id)) {

    if (!pResource)
        return;

    wl_resource_set_user_data(pResource, this);
    wl_list_init(&resourceDestroyListener.listener.link);
    resourceDestroyListener.listener.notify = _CXxColorManagementOutputV4__DestroyListener;
    resourceDestroyListener.parent = this;
    wl_resource_add_destroy_listener(pResource, &resourceDestroyListener.listener);

    wl_resource_set_implementation(pResource, _CXxColorManagementOutputV4VTable, this, nullptr);
}

CXxColorManagementOutputV4::~CXxColorManagementOutputV4() {
    wl_list_remove(&resourceDestroyListener.listener.link);
    wl_list_init(&resourceDestroyListener.listener.link);

    // if we still own the wayland resource,
    // it means we need to destroy it.
    if (pResource && wl_resource_get_user_data(pResource) == this) {
        wl_resource_set_user_data(pResource, nullptr);
        wl_resource_destroy(pResource);
    }
}

void CXxColorManagementOutputV4::onDestroyCalled() {
    wl_resource_set_user_data(pResource, nullptr);
    wl_list_remove(&resourceDestroyListener.listener.link);
    wl_list_init(&resourceDestroyListener.listener.link);

    // set the resource to nullptr,
    // as it will be freed. If the consumer does not destroy this resource
    // in onDestroy here, we'd be doing a UAF in the ~dtor
    pResource = nullptr;

    if (onDestroy)
        onDestroy(this);
}

void CXxColorManagementOutputV4::setDestroy(F<void(CXxColorManagementOutputV4*)> handler) {
    requests.destroy = handler;
}

void CXxColorManagementOutputV4::setGetImageDescription(F<void(CXxColorManagementOutputV4*, uint32_t)> handler) {
    requests.getImageDescription = handler;
}

static void _CXxColorManagementSurfaceV4Destroy(wl_client* client, wl_resource* resource) {
    const auto PO = (CXxColorManagementSurfaceV4*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.destroy)
        PO->requests.destroy(PO);
}

static void _CXxColorManagementSurfaceV4SetImageDescription(wl_client* client, wl_resource* resource, wl_resource* image_description, uint32_t render_intent) {
    const auto PO = (CXxColorManagementSurfaceV4*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.setImageDescription)
        PO->requests.setImageDescription(PO, image_description, render_intent);
}

static void _CXxColorManagementSurfaceV4UnsetImageDescription(wl_client* client, wl_resource* resource) {
    const auto PO = (CXxColorManagementSurfaceV4*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.unsetImageDescription)
        PO->requests.unsetImageDescription(PO);
}

static void _CXxColorManagementSurfaceV4__DestroyListener(wl_listener* l, void* d) {
    CXxColorManagementSurfaceV4DestroyWrapper *wrap = wl_container_of(l, wrap, listener);
    CXxColorManagementSurfaceV4* pResource = wrap->parent;
    pResource->onDestroyCalled();
}

static const void* _CXxColorManagementSurfaceV4VTable[] = {
    (void*)_CXxColorManagementSurfaceV4Destroy,
    (void*)_CXxColorManagementSurfaceV4SetImageDescription,
    (void*)_CXxColorManagementSurfaceV4UnsetImageDescription,
};
static const wl_interface* _CXxColorManagementSurfaceV4SetImageDescriptionTypes[] = {
    &xx_image_description_v4_interface,
    nullptr,
};

static const wl_message _CXxColorManagementSurfaceV4Requests[] = {
    { .name = "destroy", .signature = "", .types = xxColorManagementV4_dummyTypes + 0},
    { .name = "set_image_description", .signature = "ou", .types = _CXxColorManagementSurfaceV4SetImageDescriptionTypes + 0},
    { .name = "unset_image_description", .signature = "", .types = xxColorManagementV4_dummyTypes + 0},
};

const wl_interface xx_color_management_surface_v4_interface = {
    .name = "xx_color_management_surface_v4", .version = 1,
    .method_count = 3, .methods = _CXxColorManagementSurfaceV4Requests,
    .event_count = 0, .events = nullptr,
};

CXxColorManagementSurfaceV4::CXxColorManagementSurfaceV4(wl_client* client, uint32_t version, uint32_t id) :
    pResource(wl_resource_create(client, &xx_color_management_surface_v4_interface, version, id)) {

    if (!pResource)
        return;

    wl_resource_set_user_data(pResource, this);
    wl_list_init(&resourceDestroyListener.listener.link);
    resourceDestroyListener.listener.notify = _CXxColorManagementSurfaceV4__DestroyListener;
    resourceDestroyListener.parent = this;
    wl_resource_add_destroy_listener(pResource, &resourceDestroyListener.listener);

    wl_resource_set_implementation(pResource, _CXxColorManagementSurfaceV4VTable, this, nullptr);
}

CXxColorManagementSurfaceV4::~CXxColorManagementSurfaceV4() {
    wl_list_remove(&resourceDestroyListener.listener.link);
    wl_list_init(&resourceDestroyListener.listener.link);

    // if we still own the wayland resource,
    // it means we need to destroy it.
    if (pResource && wl_resource_get_user_data(pResource) == this) {
        wl_resource_set_user_data(pResource, nullptr);
        wl_resource_destroy(pResource);
    }
}

void CXxColorManagementSurfaceV4::onDestroyCalled() {
    wl_resource_set_user_data(pResource, nullptr);
    wl_list_remove(&resourceDestroyListener.listener.link);
    wl_list_init(&resourceDestroyListener.listener.link);

    // set the resource to nullptr,
    // as it will be freed. If the consumer does not destroy this resource
    // in onDestroy here, we'd be doing a UAF in the ~dtor
    pResource = nullptr;

    if (onDestroy)
        onDestroy(this);
}

void CXxColorManagementSurfaceV4::setDestroy(F<void(CXxColorManagementSurfaceV4*)> handler) {
    requests.destroy = handler;
}

void CXxColorManagementSurfaceV4::setSetImageDescription(F<void(CXxColorManagementSurfaceV4*, wl_resource*, uint32_t)> handler) {
    requests.setImageDescription = handler;
}

void CXxColorManagementSurfaceV4::setUnsetImageDescription(F<void(CXxColorManagementSurfaceV4*)> handler) {
    requests.unsetImageDescription = handler;
}

static void _CXxColorManagementFeedbackSurfaceV4Destroy(wl_client* client, wl_resource* resource) {
    const auto PO = (CXxColorManagementFeedbackSurfaceV4*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.destroy)
        PO->requests.destroy(PO);
}

static void _CXxColorManagementFeedbackSurfaceV4GetPreferred(wl_client* client, wl_resource* resource, uint32_t image_description) {
    const auto PO = (CXxColorManagementFeedbackSurfaceV4*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.getPreferred)
        PO->requests.getPreferred(PO, image_description);
}

static void _CXxColorManagementFeedbackSurfaceV4__DestroyListener(wl_listener* l, void* d) {
    CXxColorManagementFeedbackSurfaceV4DestroyWrapper *wrap = wl_container_of(l, wrap, listener);
    CXxColorManagementFeedbackSurfaceV4* pResource = wrap->parent;
    pResource->onDestroyCalled();
}

static const void* _CXxColorManagementFeedbackSurfaceV4VTable[] = {
    (void*)_CXxColorManagementFeedbackSurfaceV4Destroy,
    (void*)_CXxColorManagementFeedbackSurfaceV4GetPreferred,
};

void CXxColorManagementFeedbackSurfaceV4::sendPreferredChanged() {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 0);
}

void CXxColorManagementFeedbackSurfaceV4::sendPreferredChangedRaw() {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 0);
}
static const wl_interface* _CXxColorManagementFeedbackSurfaceV4GetPreferredTypes[] = {
    &xx_image_description_v4_interface,
};

static const wl_message _CXxColorManagementFeedbackSurfaceV4Requests[] = {
    { .name = "destroy", .signature = "", .types = xxColorManagementV4_dummyTypes + 0},
    { .name = "get_preferred", .signature = "n", .types = _CXxColorManagementFeedbackSurfaceV4GetPreferredTypes + 0},
};

static const wl_message _CXxColorManagementFeedbackSurfaceV4Events[] = {
    { .name = "preferred_changed", .signature = "", .types = xxColorManagementV4_dummyTypes + 0},
};

const wl_interface xx_color_management_feedback_surface_v4_interface = {
    .name = "xx_color_management_feedback_surface_v4", .version = 1,
    .method_count = 2, .methods = _CXxColorManagementFeedbackSurfaceV4Requests,
    .event_count = 1, .events = _CXxColorManagementFeedbackSurfaceV4Events,
};

CXxColorManagementFeedbackSurfaceV4::CXxColorManagementFeedbackSurfaceV4(wl_client* client, uint32_t version, uint32_t id) :
    pResource(wl_resource_create(client, &xx_color_management_feedback_surface_v4_interface, version, id)) {

    if (!pResource)
        return;

    wl_resource_set_user_data(pResource, this);
    wl_list_init(&resourceDestroyListener.listener.link);
    resourceDestroyListener.listener.notify = _CXxColorManagementFeedbackSurfaceV4__DestroyListener;
    resourceDestroyListener.parent = this;
    wl_resource_add_destroy_listener(pResource, &resourceDestroyListener.listener);

    wl_resource_set_implementation(pResource, _CXxColorManagementFeedbackSurfaceV4VTable, this, nullptr);
}

CXxColorManagementFeedbackSurfaceV4::~CXxColorManagementFeedbackSurfaceV4() {
    wl_list_remove(&resourceDestroyListener.listener.link);
    wl_list_init(&resourceDestroyListener.listener.link);

    // if we still own the wayland resource,
    // it means we need to destroy it.
    if (pResource && wl_resource_get_user_data(pResource) == this) {
        wl_resource_set_user_data(pResource, nullptr);
        wl_resource_destroy(pResource);
    }
}

void CXxColorManagementFeedbackSurfaceV4::onDestroyCalled() {
    wl_resource_set_user_data(pResource, nullptr);
    wl_list_remove(&resourceDestroyListener.listener.link);
    wl_list_init(&resourceDestroyListener.listener.link);

    // set the resource to nullptr,
    // as it will be freed. If the consumer does not destroy this resource
    // in onDestroy here, we'd be doing a UAF in the ~dtor
    pResource = nullptr;

    if (onDestroy)
        onDestroy(this);
}

void CXxColorManagementFeedbackSurfaceV4::setDestroy(F<void(CXxColorManagementFeedbackSurfaceV4*)> handler) {
    requests.destroy = handler;
}

void CXxColorManagementFeedbackSurfaceV4::setGetPreferred(F<void(CXxColorManagementFeedbackSurfaceV4*, uint32_t)> handler) {
    requests.getPreferred = handler;
}

static void _CXxImageDescriptionCreatorIccV4Create(wl_client* client, wl_resource* resource, uint32_t image_description) {
    const auto PO = (CXxImageDescriptionCreatorIccV4*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.create)
        PO->requests.create(PO, image_description);
}

static void _CXxImageDescriptionCreatorIccV4SetIccFile(wl_client* client, wl_resource* resource, int32_t icc_profile, uint32_t offset, uint32_t length) {
    const auto PO = (CXxImageDescriptionCreatorIccV4*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.setIccFile)
        PO->requests.setIccFile(PO, icc_profile, offset, length);
}

static void _CXxImageDescriptionCreatorIccV4__DestroyListener(wl_listener* l, void* d) {
    CXxImageDescriptionCreatorIccV4DestroyWrapper *wrap = wl_container_of(l, wrap, listener);
    CXxImageDescriptionCreatorIccV4* pResource = wrap->parent;
    pResource->onDestroyCalled();
}

static const void* _CXxImageDescriptionCreatorIccV4VTable[] = {
    (void*)_CXxImageDescriptionCreatorIccV4Create,
    (void*)_CXxImageDescriptionCreatorIccV4SetIccFile,
};
static const wl_interface* _CXxImageDescriptionCreatorIccV4CreateTypes[] = {
    &xx_image_description_v4_interface,
};
static const wl_interface* _CXxImageDescriptionCreatorIccV4SetIccFileTypes[] = {
    nullptr,
    nullptr,
    nullptr,
};

static const wl_message _CXxImageDescriptionCreatorIccV4Requests[] = {
    { .name = "create", .signature = "n", .types = _CXxImageDescriptionCreatorIccV4CreateTypes + 0},
    { .name = "set_icc_file", .signature = "huu", .types = _CXxImageDescriptionCreatorIccV4SetIccFileTypes + 0},
};

const wl_interface xx_image_description_creator_icc_v4_interface = {
    .name = "xx_image_description_creator_icc_v4", .version = 1,
    .method_count = 2, .methods = _CXxImageDescriptionCreatorIccV4Requests,
    .event_count = 0, .events = nullptr,
};

CXxImageDescriptionCreatorIccV4::CXxImageDescriptionCreatorIccV4(wl_client* client, uint32_t version, uint32_t id) :
    pResource(wl_resource_create(client, &xx_image_description_creator_icc_v4_interface, version, id)) {

    if (!pResource)
        return;

    wl_resource_set_user_data(pResource, this);
    wl_list_init(&resourceDestroyListener.listener.link);
    resourceDestroyListener.listener.notify = _CXxImageDescriptionCreatorIccV4__DestroyListener;
    resourceDestroyListener.parent = this;
    wl_resource_add_destroy_listener(pResource, &resourceDestroyListener.listener);

    wl_resource_set_implementation(pResource, _CXxImageDescriptionCreatorIccV4VTable, this, nullptr);
}

CXxImageDescriptionCreatorIccV4::~CXxImageDescriptionCreatorIccV4() {
    wl_list_remove(&resourceDestroyListener.listener.link);
    wl_list_init(&resourceDestroyListener.listener.link);

    // if we still own the wayland resource,
    // it means we need to destroy it.
    if (pResource && wl_resource_get_user_data(pResource) == this) {
        wl_resource_set_user_data(pResource, nullptr);
        wl_resource_destroy(pResource);
    }
}

void CXxImageDescriptionCreatorIccV4::onDestroyCalled() {
    wl_resource_set_user_data(pResource, nullptr);
    wl_list_remove(&resourceDestroyListener.listener.link);
    wl_list_init(&resourceDestroyListener.listener.link);

    // set the resource to nullptr,
    // as it will be freed. If the consumer does not destroy this resource
    // in onDestroy here, we'd be doing a UAF in the ~dtor
    pResource = nullptr;

    if (onDestroy)
        onDestroy(this);
}

void CXxImageDescriptionCreatorIccV4::setCreate(F<void(CXxImageDescriptionCreatorIccV4*, uint32_t)> handler) {
    requests.create = handler;
}

void CXxImageDescriptionCreatorIccV4::setSetIccFile(F<void(CXxImageDescriptionCreatorIccV4*, int32_t, uint32_t, uint32_t)> handler) {
    requests.setIccFile = handler;
}

static void _CXxImageDescriptionCreatorParamsV4Create(wl_client* client, wl_resource* resource, uint32_t image_description) {
    const auto PO = (CXxImageDescriptionCreatorParamsV4*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.create)
        PO->requests.create(PO, image_description);
}

static void _CXxImageDescriptionCreatorParamsV4SetTfNamed(wl_client* client, wl_resource* resource, uint32_t tf) {
    const auto PO = (CXxImageDescriptionCreatorParamsV4*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.setTfNamed)
        PO->requests.setTfNamed(PO, tf);
}

static void _CXxImageDescriptionCreatorParamsV4SetTfPower(wl_client* client, wl_resource* resource, uint32_t eexp) {
    const auto PO = (CXxImageDescriptionCreatorParamsV4*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.setTfPower)
        PO->requests.setTfPower(PO, eexp);
}

static void _CXxImageDescriptionCreatorParamsV4SetPrimariesNamed(wl_client* client, wl_resource* resource, uint32_t primaries) {
    const auto PO = (CXxImageDescriptionCreatorParamsV4*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.setPrimariesNamed)
        PO->requests.setPrimariesNamed(PO, primaries);
}

static void _CXxImageDescriptionCreatorParamsV4SetPrimaries(wl_client* client, wl_resource* resource, int32_t r_x, int32_t r_y, int32_t g_x, int32_t g_y, int32_t b_x, int32_t b_y, int32_t w_x, int32_t w_y) {
    const auto PO = (CXxImageDescriptionCreatorParamsV4*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.setPrimaries)
        PO->requests.setPrimaries(PO, r_x, r_y, g_x, g_y, b_x, b_y, w_x, w_y);
}

static void _CXxImageDescriptionCreatorParamsV4SetLuminances(wl_client* client, wl_resource* resource, uint32_t min_lum, uint32_t max_lum, uint32_t reference_lum) {
    const auto PO = (CXxImageDescriptionCreatorParamsV4*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.setLuminances)
        PO->requests.setLuminances(PO, min_lum, max_lum, reference_lum);
}

static void _CXxImageDescriptionCreatorParamsV4SetMasteringDisplayPrimaries(wl_client* client, wl_resource* resource, int32_t r_x, int32_t r_y, int32_t g_x, int32_t g_y, int32_t b_x, int32_t b_y, int32_t w_x, int32_t w_y) {
    const auto PO = (CXxImageDescriptionCreatorParamsV4*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.setMasteringDisplayPrimaries)
        PO->requests.setMasteringDisplayPrimaries(PO, r_x, r_y, g_x, g_y, b_x, b_y, w_x, w_y);
}

static void _CXxImageDescriptionCreatorParamsV4SetMasteringLuminance(wl_client* client, wl_resource* resource, uint32_t min_lum, uint32_t max_lum) {
    const auto PO = (CXxImageDescriptionCreatorParamsV4*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.setMasteringLuminance)
        PO->requests.setMasteringLuminance(PO, min_lum, max_lum);
}

static void _CXxImageDescriptionCreatorParamsV4SetMaxCll(wl_client* client, wl_resource* resource, uint32_t max_cll) {
    const auto PO = (CXxImageDescriptionCreatorParamsV4*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.setMaxCll)
        PO->requests.setMaxCll(PO, max_cll);
}

static void _CXxImageDescriptionCreatorParamsV4SetMaxFall(wl_client* client, wl_resource* resource, uint32_t max_fall) {
    const auto PO = (CXxImageDescriptionCreatorParamsV4*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.setMaxFall)
        PO->requests.setMaxFall(PO, max_fall);
}

static void _CXxImageDescriptionCreatorParamsV4__DestroyListener(wl_listener* l, void* d) {
    CXxImageDescriptionCreatorParamsV4DestroyWrapper *wrap = wl_container_of(l, wrap, listener);
    CXxImageDescriptionCreatorParamsV4* pResource = wrap->parent;
    pResource->onDestroyCalled();
}

static const void* _CXxImageDescriptionCreatorParamsV4VTable[] = {
    (void*)_CXxImageDescriptionCreatorParamsV4Create,
    (void*)_CXxImageDescriptionCreatorParamsV4SetTfNamed,
    (void*)_CXxImageDescriptionCreatorParamsV4SetTfPower,
    (void*)_CXxImageDescriptionCreatorParamsV4SetPrimariesNamed,
    (void*)_CXxImageDescriptionCreatorParamsV4SetPrimaries,
    (void*)_CXxImageDescriptionCreatorParamsV4SetLuminances,
    (void*)_CXxImageDescriptionCreatorParamsV4SetMasteringDisplayPrimaries,
    (void*)_CXxImageDescriptionCreatorParamsV4SetMasteringLuminance,
    (void*)_CXxImageDescriptionCreatorParamsV4SetMaxCll,
    (void*)_CXxImageDescriptionCreatorParamsV4SetMaxFall,
};
static const wl_interface* _CXxImageDescriptionCreatorParamsV4CreateTypes[] = {
    &xx_image_description_v4_interface,
};
static const wl_interface* _CXxImageDescriptionCreatorParamsV4SetTfNamedTypes[] = {
    nullptr,
};
static const wl_interface* _CXxImageDescriptionCreatorParamsV4SetTfPowerTypes[] = {
    nullptr,
};
static const wl_interface* _CXxImageDescriptionCreatorParamsV4SetPrimariesNamedTypes[] = {
    nullptr,
};
static const wl_interface* _CXxImageDescriptionCreatorParamsV4SetPrimariesTypes[] = {
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
};
static const wl_interface* _CXxImageDescriptionCreatorParamsV4SetLuminancesTypes[] = {
    nullptr,
    nullptr,
    nullptr,
};
static const wl_interface* _CXxImageDescriptionCreatorParamsV4SetMasteringDisplayPrimariesTypes[] = {
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
};
static const wl_interface* _CXxImageDescriptionCreatorParamsV4SetMasteringLuminanceTypes[] = {
    nullptr,
    nullptr,
};
static const wl_interface* _CXxImageDescriptionCreatorParamsV4SetMaxCllTypes[] = {
    nullptr,
};
static const wl_interface* _CXxImageDescriptionCreatorParamsV4SetMaxFallTypes[] = {
    nullptr,
};

static const wl_message _CXxImageDescriptionCreatorParamsV4Requests[] = {
    { .name = "create", .signature = "n", .types = _CXxImageDescriptionCreatorParamsV4CreateTypes + 0},
    { .name = "set_tf_named", .signature = "u", .types = _CXxImageDescriptionCreatorParamsV4SetTfNamedTypes + 0},
    { .name = "set_tf_power", .signature = "u", .types = _CXxImageDescriptionCreatorParamsV4SetTfPowerTypes + 0},
    { .name = "set_primaries_named", .signature = "u", .types = _CXxImageDescriptionCreatorParamsV4SetPrimariesNamedTypes + 0},
    { .name = "set_primaries", .signature = "iiiiiiii", .types = _CXxImageDescriptionCreatorParamsV4SetPrimariesTypes + 0},
    { .name = "set_luminances", .signature = "uuu", .types = _CXxImageDescriptionCreatorParamsV4SetLuminancesTypes + 0},
    { .name = "set_mastering_display_primaries", .signature = "iiiiiiii", .types = _CXxImageDescriptionCreatorParamsV4SetMasteringDisplayPrimariesTypes + 0},
    { .name = "set_mastering_luminance", .signature = "uu", .types = _CXxImageDescriptionCreatorParamsV4SetMasteringLuminanceTypes + 0},
    { .name = "set_max_cll", .signature = "u", .types = _CXxImageDescriptionCreatorParamsV4SetMaxCllTypes + 0},
    { .name = "set_max_fall", .signature = "u", .types = _CXxImageDescriptionCreatorParamsV4SetMaxFallTypes + 0},
};

const wl_interface xx_image_description_creator_params_v4_interface = {
    .name = "xx_image_description_creator_params_v4", .version = 1,
    .method_count = 10, .methods = _CXxImageDescriptionCreatorParamsV4Requests,
    .event_count = 0, .events = nullptr,
};

CXxImageDescriptionCreatorParamsV4::CXxImageDescriptionCreatorParamsV4(wl_client* client, uint32_t version, uint32_t id) :
    pResource(wl_resource_create(client, &xx_image_description_creator_params_v4_interface, version, id)) {

    if (!pResource)
        return;

    wl_resource_set_user_data(pResource, this);
    wl_list_init(&resourceDestroyListener.listener.link);
    resourceDestroyListener.listener.notify = _CXxImageDescriptionCreatorParamsV4__DestroyListener;
    resourceDestroyListener.parent = this;
    wl_resource_add_destroy_listener(pResource, &resourceDestroyListener.listener);

    wl_resource_set_implementation(pResource, _CXxImageDescriptionCreatorParamsV4VTable, this, nullptr);
}

CXxImageDescriptionCreatorParamsV4::~CXxImageDescriptionCreatorParamsV4() {
    wl_list_remove(&resourceDestroyListener.listener.link);
    wl_list_init(&resourceDestroyListener.listener.link);

    // if we still own the wayland resource,
    // it means we need to destroy it.
    if (pResource && wl_resource_get_user_data(pResource) == this) {
        wl_resource_set_user_data(pResource, nullptr);
        wl_resource_destroy(pResource);
    }
}

void CXxImageDescriptionCreatorParamsV4::onDestroyCalled() {
    wl_resource_set_user_data(pResource, nullptr);
    wl_list_remove(&resourceDestroyListener.listener.link);
    wl_list_init(&resourceDestroyListener.listener.link);

    // set the resource to nullptr,
    // as it will be freed. If the consumer does not destroy this resource
    // in onDestroy here, we'd be doing a UAF in the ~dtor
    pResource = nullptr;

    if (onDestroy)
        onDestroy(this);
}

void CXxImageDescriptionCreatorParamsV4::setCreate(F<void(CXxImageDescriptionCreatorParamsV4*, uint32_t)> handler) {
    requests.create = handler;
}

void CXxImageDescriptionCreatorParamsV4::setSetTfNamed(F<void(CXxImageDescriptionCreatorParamsV4*, uint32_t)> handler) {
    requests.setTfNamed = handler;
}

void CXxImageDescriptionCreatorParamsV4::setSetTfPower(F<void(CXxImageDescriptionCreatorParamsV4*, uint32_t)> handler) {
    requests.setTfPower = handler;
}

void CXxImageDescriptionCreatorParamsV4::setSetPrimariesNamed(F<void(CXxImageDescriptionCreatorParamsV4*, uint32_t)> handler) {
    requests.setPrimariesNamed = handler;
}

void CXxImageDescriptionCreatorParamsV4::setSetPrimaries(F<void(CXxImageDescriptionCreatorParamsV4*, int32_t, int32_t, int32_t, int32_t, int32_t, int32_t, int32_t, int32_t)> handler) {
    requests.setPrimaries = handler;
}

void CXxImageDescriptionCreatorParamsV4::setSetLuminances(F<void(CXxImageDescriptionCreatorParamsV4*, uint32_t, uint32_t, uint32_t)> handler) {
    requests.setLuminances = handler;
}

void CXxImageDescriptionCreatorParamsV4::setSetMasteringDisplayPrimaries(F<void(CXxImageDescriptionCreatorParamsV4*, int32_t, int32_t, int32_t, int32_t, int32_t, int32_t, int32_t, int32_t)> handler) {
    requests.setMasteringDisplayPrimaries = handler;
}

void CXxImageDescriptionCreatorParamsV4::setSetMasteringLuminance(F<void(CXxImageDescriptionCreatorParamsV4*, uint32_t, uint32_t)> handler) {
    requests.setMasteringLuminance = handler;
}

void CXxImageDescriptionCreatorParamsV4::setSetMaxCll(F<void(CXxImageDescriptionCreatorParamsV4*, uint32_t)> handler) {
    requests.setMaxCll = handler;
}

void CXxImageDescriptionCreatorParamsV4::setSetMaxFall(F<void(CXxImageDescriptionCreatorParamsV4*, uint32_t)> handler) {
    requests.setMaxFall = handler;
}

static void _CXxImageDescriptionV4Destroy(wl_client* client, wl_resource* resource) {
    const auto PO = (CXxImageDescriptionV4*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.destroy)
        PO->requests.destroy(PO);
}

static void _CXxImageDescriptionV4GetInformation(wl_client* client, wl_resource* resource, uint32_t information) {
    const auto PO = (CXxImageDescriptionV4*)wl_resource_get_user_data(resource);
    if (PO && PO->requests.getInformation)
        PO->requests.getInformation(PO, information);
}

static void _CXxImageDescriptionV4__DestroyListener(wl_listener* l, void* d) {
    CXxImageDescriptionV4DestroyWrapper *wrap = wl_container_of(l, wrap, listener);
    CXxImageDescriptionV4* pResource = wrap->parent;
    pResource->onDestroyCalled();
}

static const void* _CXxImageDescriptionV4VTable[] = {
    (void*)_CXxImageDescriptionV4Destroy,
    (void*)_CXxImageDescriptionV4GetInformation,
};

void CXxImageDescriptionV4::sendFailed(xxImageDescriptionV4Cause cause, const char* msg) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 0, cause, msg);
}

void CXxImageDescriptionV4::sendReady(uint32_t identity) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 1, identity);
}

void CXxImageDescriptionV4::sendFailedRaw(xxImageDescriptionV4Cause cause, const char* msg) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 0, cause, msg);
}

void CXxImageDescriptionV4::sendReadyRaw(uint32_t identity) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 1, identity);
}
static const wl_interface* _CXxImageDescriptionV4GetInformationTypes[] = {
    &xx_image_description_info_v4_interface,
};
static const wl_interface* _CXxImageDescriptionV4FailedTypes[] = {
    nullptr,
    nullptr,
};
static const wl_interface* _CXxImageDescriptionV4ReadyTypes[] = {
    nullptr,
};

static const wl_message _CXxImageDescriptionV4Requests[] = {
    { .name = "destroy", .signature = "", .types = xxColorManagementV4_dummyTypes + 0},
    { .name = "get_information", .signature = "n", .types = _CXxImageDescriptionV4GetInformationTypes + 0},
};

static const wl_message _CXxImageDescriptionV4Events[] = {
    { .name = "failed", .signature = "us", .types = _CXxImageDescriptionV4FailedTypes + 0},
    { .name = "ready", .signature = "u", .types = _CXxImageDescriptionV4ReadyTypes + 0},
};

const wl_interface xx_image_description_v4_interface = {
    .name = "xx_image_description_v4", .version = 1,
    .method_count = 2, .methods = _CXxImageDescriptionV4Requests,
    .event_count = 2, .events = _CXxImageDescriptionV4Events,
};

CXxImageDescriptionV4::CXxImageDescriptionV4(wl_client* client, uint32_t version, uint32_t id) :
    pResource(wl_resource_create(client, &xx_image_description_v4_interface, version, id)) {

    if (!pResource)
        return;

    wl_resource_set_user_data(pResource, this);
    wl_list_init(&resourceDestroyListener.listener.link);
    resourceDestroyListener.listener.notify = _CXxImageDescriptionV4__DestroyListener;
    resourceDestroyListener.parent = this;
    wl_resource_add_destroy_listener(pResource, &resourceDestroyListener.listener);

    wl_resource_set_implementation(pResource, _CXxImageDescriptionV4VTable, this, nullptr);
}

CXxImageDescriptionV4::~CXxImageDescriptionV4() {
    wl_list_remove(&resourceDestroyListener.listener.link);
    wl_list_init(&resourceDestroyListener.listener.link);

    // if we still own the wayland resource,
    // it means we need to destroy it.
    if (pResource && wl_resource_get_user_data(pResource) == this) {
        wl_resource_set_user_data(pResource, nullptr);
        wl_resource_destroy(pResource);
    }
}

void CXxImageDescriptionV4::onDestroyCalled() {
    wl_resource_set_user_data(pResource, nullptr);
    wl_list_remove(&resourceDestroyListener.listener.link);
    wl_list_init(&resourceDestroyListener.listener.link);

    // set the resource to nullptr,
    // as it will be freed. If the consumer does not destroy this resource
    // in onDestroy here, we'd be doing a UAF in the ~dtor
    pResource = nullptr;

    if (onDestroy)
        onDestroy(this);
}

void CXxImageDescriptionV4::setDestroy(F<void(CXxImageDescriptionV4*)> handler) {
    requests.destroy = handler;
}

void CXxImageDescriptionV4::setGetInformation(F<void(CXxImageDescriptionV4*, uint32_t)> handler) {
    requests.getInformation = handler;
}

static void _CXxImageDescriptionInfoV4__DestroyListener(wl_listener* l, void* d) {
    CXxImageDescriptionInfoV4DestroyWrapper *wrap = wl_container_of(l, wrap, listener);
    CXxImageDescriptionInfoV4* pResource = wrap->parent;
    pResource->onDestroyCalled();
}

static const void* _CXxImageDescriptionInfoV4VTable[] = {
    nullptr,
};

void CXxImageDescriptionInfoV4::sendDone() {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 0);
}

void CXxImageDescriptionInfoV4::sendIccFile(int32_t icc, uint32_t icc_size) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 1, icc, icc_size);
}

void CXxImageDescriptionInfoV4::sendPrimaries(int32_t r_x, int32_t r_y, int32_t g_x, int32_t g_y, int32_t b_x, int32_t b_y, int32_t w_x, int32_t w_y) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 2, r_x, r_y, g_x, g_y, b_x, b_y, w_x, w_y);
}

void CXxImageDescriptionInfoV4::sendPrimariesNamed(uint32_t primaries) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 3, primaries);
}

void CXxImageDescriptionInfoV4::sendTfPower(uint32_t eexp) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 4, eexp);
}

void CXxImageDescriptionInfoV4::sendTfNamed(uint32_t tf) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 5, tf);
}

void CXxImageDescriptionInfoV4::sendLuminances(uint32_t min_lum, uint32_t max_lum, uint32_t reference_lum) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 6, min_lum, max_lum, reference_lum);
}

void CXxImageDescriptionInfoV4::sendTargetPrimaries(int32_t r_x, int32_t r_y, int32_t g_x, int32_t g_y, int32_t b_x, int32_t b_y, int32_t w_x, int32_t w_y) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 7, r_x, r_y, g_x, g_y, b_x, b_y, w_x, w_y);
}

void CXxImageDescriptionInfoV4::sendTargetLuminance(uint32_t min_lum, uint32_t max_lum) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 8, min_lum, max_lum);
}

void CXxImageDescriptionInfoV4::sendTargetMaxCll(uint32_t max_cll) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 9, max_cll);
}

void CXxImageDescriptionInfoV4::sendTargetMaxFall(uint32_t max_fall) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 10, max_fall);
}

void CXxImageDescriptionInfoV4::sendDoneRaw() {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 0);
}

void CXxImageDescriptionInfoV4::sendIccFileRaw(int32_t icc, uint32_t icc_size) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 1, icc, icc_size);
}

void CXxImageDescriptionInfoV4::sendPrimariesRaw(int32_t r_x, int32_t r_y, int32_t g_x, int32_t g_y, int32_t b_x, int32_t b_y, int32_t w_x, int32_t w_y) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 2, r_x, r_y, g_x, g_y, b_x, b_y, w_x, w_y);
}

void CXxImageDescriptionInfoV4::sendPrimariesNamedRaw(uint32_t primaries) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 3, primaries);
}

void CXxImageDescriptionInfoV4::sendTfPowerRaw(uint32_t eexp) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 4, eexp);
}

void CXxImageDescriptionInfoV4::sendTfNamedRaw(uint32_t tf) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 5, tf);
}

void CXxImageDescriptionInfoV4::sendLuminancesRaw(uint32_t min_lum, uint32_t max_lum, uint32_t reference_lum) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 6, min_lum, max_lum, reference_lum);
}

void CXxImageDescriptionInfoV4::sendTargetPrimariesRaw(int32_t r_x, int32_t r_y, int32_t g_x, int32_t g_y, int32_t b_x, int32_t b_y, int32_t w_x, int32_t w_y) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 7, r_x, r_y, g_x, g_y, b_x, b_y, w_x, w_y);
}

void CXxImageDescriptionInfoV4::sendTargetLuminanceRaw(uint32_t min_lum, uint32_t max_lum) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 8, min_lum, max_lum);
}

void CXxImageDescriptionInfoV4::sendTargetMaxCllRaw(uint32_t max_cll) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 9, max_cll);
}

void CXxImageDescriptionInfoV4::sendTargetMaxFallRaw(uint32_t max_fall) {
    if (!pResource)
        return;
    wl_resource_post_event(pResource, 10, max_fall);
}
static const wl_interface* _CXxImageDescriptionInfoV4IccFileTypes[] = {
    nullptr,
    nullptr,
};
static const wl_interface* _CXxImageDescriptionInfoV4PrimariesTypes[] = {
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
};
static const wl_interface* _CXxImageDescriptionInfoV4PrimariesNamedTypes[] = {
    nullptr,
};
static const wl_interface* _CXxImageDescriptionInfoV4TfPowerTypes[] = {
    nullptr,
};
static const wl_interface* _CXxImageDescriptionInfoV4TfNamedTypes[] = {
    nullptr,
};
static const wl_interface* _CXxImageDescriptionInfoV4LuminancesTypes[] = {
    nullptr,
    nullptr,
    nullptr,
};
static const wl_interface* _CXxImageDescriptionInfoV4TargetPrimariesTypes[] = {
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
};
static const wl_interface* _CXxImageDescriptionInfoV4TargetLuminanceTypes[] = {
    nullptr,
    nullptr,
};
static const wl_interface* _CXxImageDescriptionInfoV4TargetMaxCllTypes[] = {
    nullptr,
};
static const wl_interface* _CXxImageDescriptionInfoV4TargetMaxFallTypes[] = {
    nullptr,
};

static const wl_message _CXxImageDescriptionInfoV4Events[] = {
    { .name = "done", .signature = "", .types = xxColorManagementV4_dummyTypes + 0},
    { .name = "icc_file", .signature = "hu", .types = _CXxImageDescriptionInfoV4IccFileTypes + 0},
    { .name = "primaries", .signature = "iiiiiiii", .types = _CXxImageDescriptionInfoV4PrimariesTypes + 0},
    { .name = "primaries_named", .signature = "u", .types = _CXxImageDescriptionInfoV4PrimariesNamedTypes + 0},
    { .name = "tf_power", .signature = "u", .types = _CXxImageDescriptionInfoV4TfPowerTypes + 0},
    { .name = "tf_named", .signature = "u", .types = _CXxImageDescriptionInfoV4TfNamedTypes + 0},
    { .name = "luminances", .signature = "uuu", .types = _CXxImageDescriptionInfoV4LuminancesTypes + 0},
    { .name = "target_primaries", .signature = "iiiiiiii", .types = _CXxImageDescriptionInfoV4TargetPrimariesTypes + 0},
    { .name = "target_luminance", .signature = "uu", .types = _CXxImageDescriptionInfoV4TargetLuminanceTypes + 0},
    { .name = "target_max_cll", .signature = "u", .types = _CXxImageDescriptionInfoV4TargetMaxCllTypes + 0},
    { .name = "target_max_fall", .signature = "u", .types = _CXxImageDescriptionInfoV4TargetMaxFallTypes + 0},
};

const wl_interface xx_image_description_info_v4_interface = {
    .name = "xx_image_description_info_v4", .version = 1,
    .method_count = 0, .methods = nullptr,
    .event_count = 11, .events = _CXxImageDescriptionInfoV4Events,
};

CXxImageDescriptionInfoV4::CXxImageDescriptionInfoV4(wl_client* client, uint32_t version, uint32_t id) :
    pResource(wl_resource_create(client, &xx_image_description_info_v4_interface, version, id)) {

    if (!pResource)
        return;

    wl_resource_set_user_data(pResource, this);
    wl_list_init(&resourceDestroyListener.listener.link);
    resourceDestroyListener.listener.notify = _CXxImageDescriptionInfoV4__DestroyListener;
    resourceDestroyListener.parent = this;
    wl_resource_add_destroy_listener(pResource, &resourceDestroyListener.listener);

    wl_resource_set_implementation(pResource, _CXxImageDescriptionInfoV4VTable, this, nullptr);
}

CXxImageDescriptionInfoV4::~CXxImageDescriptionInfoV4() {
    wl_list_remove(&resourceDestroyListener.listener.link);
    wl_list_init(&resourceDestroyListener.listener.link);

    // if we still own the wayland resource,
    // it means we need to destroy it.
    if (pResource && wl_resource_get_user_data(pResource) == this) {
        wl_resource_set_user_data(pResource, nullptr);
        wl_resource_destroy(pResource);
    }
}

void CXxImageDescriptionInfoV4::onDestroyCalled() {
    wl_resource_set_user_data(pResource, nullptr);
    wl_list_remove(&resourceDestroyListener.listener.link);
    wl_list_init(&resourceDestroyListener.listener.link);

    // set the resource to nullptr,
    // as it will be freed. If the consumer does not destroy this resource
    // in onDestroy here, we'd be doing a UAF in the ~dtor
    pResource = nullptr;

    if (onDestroy)
        onDestroy(this);
}

#undef F
