/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone;

import com.jcloisterzone.ExpansionType;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.capability.AbbeyCapability;
import com.jcloisterzone.game.capability.BarnCapability;
import com.jcloisterzone.game.capability.BazaarCapability;
import com.jcloisterzone.game.capability.BigFollowerCapability;
import com.jcloisterzone.game.capability.BridgeCapability;
import com.jcloisterzone.game.capability.BuilderCapability;
import com.jcloisterzone.game.capability.CastleCapability;
import com.jcloisterzone.game.capability.CathedralCapability;
import com.jcloisterzone.game.capability.ChurchCapability;
import com.jcloisterzone.game.capability.CornCircleCapability;
import com.jcloisterzone.game.capability.CountCapability;
import com.jcloisterzone.game.capability.DragonCapability;
import com.jcloisterzone.game.capability.FairyCapability;
import com.jcloisterzone.game.capability.FerriesCapability;
import com.jcloisterzone.game.capability.FestivalCapability;
import com.jcloisterzone.game.capability.FlierCapability;
import com.jcloisterzone.game.capability.GermanMonasteriesCapability;
import com.jcloisterzone.game.capability.GoldminesCapability;
import com.jcloisterzone.game.capability.HillCapability;
import com.jcloisterzone.game.capability.InnCapability;
import com.jcloisterzone.game.capability.KingAndRobberBaronCapability;
import com.jcloisterzone.game.capability.LabyrinthCapability;
import com.jcloisterzone.game.capability.LittleBuildingsCapability;
import com.jcloisterzone.game.capability.MageAndWitchCapability;
import com.jcloisterzone.game.capability.MayorCapability;
import com.jcloisterzone.game.capability.PhantomCapability;
import com.jcloisterzone.game.capability.PigCapability;
import com.jcloisterzone.game.capability.PigHerdCapability;
import com.jcloisterzone.game.capability.PortalCapability;
import com.jcloisterzone.game.capability.PrincessCapability;
import com.jcloisterzone.game.capability.RiverCapability;
import com.jcloisterzone.game.capability.SheepCapability;
import com.jcloisterzone.game.capability.ShrineCapability;
import com.jcloisterzone.game.capability.SiegeCapability;
import com.jcloisterzone.game.capability.StandardGameCapability;
import com.jcloisterzone.game.capability.TowerCapability;
import com.jcloisterzone.game.capability.TradeGoodsCapability;
import com.jcloisterzone.game.capability.TunnelCapability;
import com.jcloisterzone.game.capability.VineyardCapability;
import com.jcloisterzone.game.capability.WagonCapability;
import com.jcloisterzone.game.capability.WindRoseCapability;
import com.jcloisterzone.game.capability.YagaCapability;
import com.jcloisterzone.plugin.Plugin;
import com.jcloisterzone.ui.I18nUtils;
import io.vavr.collection.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Expansion {
    public static Expansion BASIC = new Expansion("BASIC", "BA", I18nUtils._tr("Basic game", new Object[0]), new Class[]{StandardGameCapability.class}, ExpansionType.BASIC);
    public static Expansion WINTER = new Expansion("WINTER", "WI", I18nUtils._tr("Winter Edition", new Object[0]), ExpansionType.BASIC_EXT);
    public static Expansion GINGERBREAD_MAN = new Expansion("GINGERBREAD_MAN", "GM", I18nUtils._tr("The Gingerbread Man", new Object[0]), ExpansionType.MINOR);
    public static Expansion INNS_AND_CATHEDRALS = new Expansion("INNS_AND_CATHEDRALS", "IC", I18nUtils._tr("Inns & Cathedrals", new Object[0]), new Class[]{BigFollowerCapability.class, InnCapability.class, CathedralCapability.class}, ExpansionType.MAJOR);
    public static Expansion TRADERS_AND_BUILDERS = new Expansion("TRADERS_AND_BUILDERS", "TB", I18nUtils._tr("Traders & Builders", new Object[0]), new Class[]{PigCapability.class, BuilderCapability.class, TradeGoodsCapability.class, PigHerdCapability.class}, ExpansionType.MAJOR);
    public static Expansion PRINCESS_AND_DRAGON = new Expansion("PRINCESS_AND_DRAGON", "DG", I18nUtils._tr("The Princess & The Dragon", new Object[0]), new Class[]{FairyCapability.class, DragonCapability.class, PortalCapability.class, PrincessCapability.class}, ExpansionType.MAJOR);
    public static Expansion TOWER = new Expansion("TOWER", "TO", I18nUtils._tr("The Tower", new Object[0]), new Class[]{TowerCapability.class}, ExpansionType.MAJOR);
    public static Expansion ABBEY_AND_MAYOR = new Expansion("ABBEY_AND_MAYOR", "AM", I18nUtils._tr("Abbey & Mayor", new Object[0]), new Class[]{AbbeyCapability.class, WagonCapability.class, MayorCapability.class, BarnCapability.class}, ExpansionType.MAJOR);
    public static Expansion CATAPULT = new Expansion("CATAPULT", "CA", I18nUtils._tr("The Catapult", new Object[0]), ExpansionType.MAJOR);
    public static Expansion BRIDGES_CASTLES_AND_BAZAARS = new Expansion("BRIDGES_CASTLES_AND_BAZAARS", "BB", I18nUtils._tr("Bridges, Castles and Bazaars", new Object[0]), new Class[]{BridgeCapability.class, CastleCapability.class, BazaarCapability.class}, ExpansionType.MAJOR);
    public static Expansion HILLS_AND_SHEEP = new Expansion("HILLS_AND_SHEEP", "HS", I18nUtils._tr("Hills and Sheep", new Object[0]), new Class[]{SheepCapability.class, HillCapability.class, VineyardCapability.class}, ExpansionType.MAJOR);
    public static Expansion UNDER_THE_BIG_TOP = new Expansion("UNDER_THE_BIG_TOP", "UN", I18nUtils._tr("Under the Big Top", new Object[0]), ExpansionType.MAJOR);
    public static Expansion KING_AND_ROBBER_BARON = new Expansion("KING_AND_ROBBER_BARON", "KR", I18nUtils._tr("King and Robber Baron", new Object[0]), new Class[]{KingAndRobberBaronCapability.class}, ExpansionType.MINOR);
    public static Expansion RIVER = new Expansion("RIVER", "R1", I18nUtils._tr("The River", new Object[0]), new Class[]{RiverCapability.class}, ExpansionType.MINOR);
    public static Expansion RIVER_II = new Expansion("RIVER_II", "R2", I18nUtils._tr("The River II", new Object[0]), new Class[]{RiverCapability.class}, ExpansionType.MINOR);
    public static Expansion CATHARS = new Expansion("CATHARS", "SI", I18nUtils._tr("The Cathars / Siege", new Object[0]), new Class[]{SiegeCapability.class}, ExpansionType.MINOR);
    public static Expansion BESIEGERS = new Expansion("BESIEGERS", "BE", I18nUtils._tr("The Besiegers", new Object[0]), new Class[]{SiegeCapability.class}, ExpansionType.MINOR);
    public static Expansion COUNT = new Expansion("COUNT", "CO", I18nUtils._tr("The Count of Carcassonne", new Object[0]), new Class[]{CountCapability.class}, ExpansionType.MINOR);
    public static Expansion GQ11 = new Expansion("GQ11", "GQ", I18nUtils._tr("The Mini Expansion (GQ11)", new Object[0]), ExpansionType.MINOR);
    public static Expansion CULT = new Expansion("CULT", "CU", I18nUtils._tr("The Cult", new Object[0]), new Class[]{ShrineCapability.class}, ExpansionType.MINOR);
    public static Expansion TUNNEL = new Expansion("TUNNEL", "TU", I18nUtils._tr("The Tunnel", new Object[0]), new Class[]{TunnelCapability.class}, ExpansionType.MINOR);
    public static Expansion CORN_CIRCLES = new Expansion("CORN_CIRCLES", "CC", I18nUtils._tr("The Corn Circles", new Object[0]), new Class[]{CornCircleCapability.class}, ExpansionType.MINOR);
    public static Expansion PLAGUE = new Expansion("PLAGUE", "PL", I18nUtils._tr("The Plague", new Object[0]), ExpansionType.MINOR);
    public static Expansion PHANTOM = new Expansion("PHANTOM", "PH", I18nUtils._tr("The Phantom", new Object[0]), new Class[]{PhantomCapability.class}, ExpansionType.MINOR);
    public static Expansion FESTIVAL = new Expansion("FESTIVAL", "FE", I18nUtils._tr("The Festival (10th an.)", new Object[0]), new Class[]{FestivalCapability.class}, ExpansionType.MINOR);
    public static Expansion LITTLE_BUILDINGS = new Expansion("LITTLE_BUILDINGS", "LB", I18nUtils._tr("Little Buildings", new Object[0]), new Class[]{LittleBuildingsCapability.class}, ExpansionType.MINOR);
    public static Expansion WIND_ROSE = new Expansion("WIND_ROSE", "WR", I18nUtils._tr("The Wind Rose", new Object[0]), new Class[]{WindRoseCapability.class}, ExpansionType.MINOR);
    public static Expansion GERMAN_MONASTERIES = new Expansion("GERMAN_MONASTERIES", "GM", I18nUtils._tr("The German Monasteries", new Object[0]), new Class[]{GermanMonasteriesCapability.class}, ExpansionType.MINOR);
    public static Expansion CASTLES = new Expansion("CASTLES", "CS", I18nUtils._tr("Castles in Germany", new Object[0]), ExpansionType.MINOR);
    public static Expansion HALFINGS_I = new Expansion("HALFINGS_I", "H1", I18nUtils._tr("Halfings", new Object[0]) + " I", ExpansionType.MINOR);
    public static Expansion HALFINGS_II = new Expansion("HALFINGS_II", "H2", I18nUtils._tr("Halfings", new Object[0]) + " \u00cfI", ExpansionType.MINOR);
    public static Expansion WATCHTOWER = new Expansion("WATCHTOWER", "WT", I18nUtils._tr("The Watchtower", new Object[0]), ExpansionType.MINOR);
    public static Expansion FLIER = new Expansion("FLIER", "FL", "#1 - " + I18nUtils._tr("The Flier", new Object[0]), new Class[]{FlierCapability.class}, ExpansionType.MINI);
    public static Expansion MESSAGES = new Expansion("MESSAGES", "ME", "#2 - " + I18nUtils._tr("The Messages", new Object[0]), ExpansionType.MINI);
    public static Expansion FERRIES = new Expansion("FERRIES", "FR", "#3 - " + I18nUtils._tr("The Ferries", new Object[0]), new Class[]{FerriesCapability.class}, ExpansionType.MINI);
    public static Expansion GOLDMINES = new Expansion("GOLDMINES", "GO", "#4 - " + I18nUtils._tr("The Goldmines", new Object[0]), new Class[]{GoldminesCapability.class}, ExpansionType.MINI);
    public static Expansion MAGE_AND_WITCH = new Expansion("MAGE_AND_WITCH", "MW", "#5 - " + I18nUtils._tr("Mage & Witch", new Object[0]), new Class[]{MageAndWitchCapability.class}, ExpansionType.MINI);
    public static Expansion ROBBERS = new Expansion("ROBBERS", "RO", "#6 - " + I18nUtils._tr("The Robbers", new Object[0]), ExpansionType.MINI);
    public static Expansion CORN_CIRCLES_II = new Expansion("CORN_CIRCLES_II", "C2", "#7 - " + I18nUtils._tr("The Corn Circles II", new Object[0]), new Class[]{CornCircleCapability.class}, ExpansionType.MINI);
    public static Expansion SCHOOL = new Expansion("SCHOOL", "SC", I18nUtils._tr("The School", new Object[0]), ExpansionType.PROMO);
    public static Expansion LA_PORXADA = new Expansion("LA_PORXADA", "PX", I18nUtils._tr("La Porxada", new Object[0]), ExpansionType.PROMO);
    public static Expansion RUSSIAN_PROMOS = new Expansion("RUSSIAN_PROMOS", "RP", I18nUtils._tr("Russian Promos", new Object[0]), new Class[]{YagaCapability.class}, ExpansionType.PROMO);
    public static Expansion DARMSTADT = new Expansion("DARMSTADT", "DA", I18nUtils._tr("Darmstadt Promo", new Object[0]), new Class[]{ChurchCapability.class}, ExpansionType.PROMO);
    public static Expansion LABYRINTH = new Expansion("LABYRINTH", "LA", I18nUtils._tr("Labyrinth", new Object[0]), new Class[]{LabyrinthCapability.class}, ExpansionType.PROMO);
    public static Expansion _MISSING_PLACEHOLDER = new Expansion("(Unknown expansion)", "??", I18nUtils._tr("(Unknown expansion)", new Object[0]), ExpansionType.UNKNOWN);
    private static Vector<Expansion> _values = Vector.of(BASIC, WINTER, INNS_AND_CATHEDRALS, TRADERS_AND_BUILDERS, PRINCESS_AND_DRAGON, TOWER, ABBEY_AND_MAYOR, BRIDGES_CASTLES_AND_BAZAARS, HILLS_AND_SHEEP, KING_AND_ROBBER_BARON, RIVER, RIVER_II, CATHARS, BESIEGERS, COUNT, GQ11, CULT, TUNNEL, CORN_CIRCLES, PHANTOM, FESTIVAL, LITTLE_BUILDINGS, WIND_ROSE, GERMAN_MONASTERIES, FLIER, FERRIES, GOLDMINES, MAGE_AND_WITCH, CORN_CIRCLES_II, RUSSIAN_PROMOS, DARMSTADT, LABYRINTH);
    private final String name;
    private final String code;
    private final String label;
    private final Class<? extends Capability<?>>[] capabilities;
    private final ExpansionType type;
    private Plugin origin;

    public Expansion(String name, String code, String label, ExpansionType type) {
        this(name, code, label, null, type);
    }

    public Expansion(String name, String code, String label, Class<? extends Capability<?>>[] capabilities, ExpansionType type) {
        this.name = name;
        this.code = code;
        this.label = label;
        this.capabilities = capabilities == null ? new Class[]{} : capabilities;
        this.type = type;
    }

    public static Vector<Expansion> values() {
        return _values;
    }

    public String name() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public ExpansionType getType() {
        return this.type;
    }

    public Plugin getOrigin() {
        return this.origin;
    }

    public Class<? extends Capability<?>>[] getCapabilities() {
        return this.capabilities;
    }

    public String toString() {
        return this.label;
    }

    public static Expansion valueOf(String name) {
        for (Expansion exp : Expansion.values()) {
            if (!exp.name.equals(name)) continue;
            return exp;
        }
        return _MISSING_PLACEHOLDER;
    }

    public static Expansion valueOfCode(String code) {
        for (Expansion exp : Expansion.values()) {
            if (!exp.code.equals(code)) continue;
            return exp;
        }
        return _MISSING_PLACEHOLDER;
    }

    public static void register(Expansion exp, Plugin origin) {
        Logger logger = LoggerFactory.getLogger(Expansion.class);
        exp.origin = origin;
        for (Expansion other : _values) {
            if (other.name.equals(exp.name)) {
                logger.warn("Expansion {} is already registered.", (Object)exp.name);
                return;
            }
            if (!other.code.equals(exp.code)) continue;
            logger.warn("Expansion {} is already registered.", (Object)exp.code);
            return;
        }
        _values = _values.append((Object)exp);
        logger.info("Expansion {} has been registered.", (Object)exp.name());
    }

    public static void unregister(Expansion exp) {
        assert (exp.origin != null);
        _values = _values.remove((Object)exp);
    }
}

