/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone;

import java.util.Comparator;

public class VersionComparator
implements Comparator<String> {
    @Override
    public int compare(String version1, String version2) {
        VersionTokenizer tokenizer1 = new VersionTokenizer(version1);
        VersionTokenizer tokenizer2 = new VersionTokenizer(version2);
        int number1 = 0;
        int number2 = 0;
        String suffix1 = "";
        String suffix2 = "";
        while (tokenizer1.MoveNext()) {
            boolean empty2;
            if (!tokenizer2.MoveNext()) {
                do {
                    number1 = tokenizer1.getNumber();
                    suffix1 = tokenizer1.getSuffix();
                    if (number1 == 0 && suffix1.length() == 0) continue;
                    return 1;
                } while (tokenizer1.MoveNext());
                return 0;
            }
            number1 = tokenizer1.getNumber();
            suffix1 = tokenizer1.getSuffix();
            number2 = tokenizer2.getNumber();
            suffix2 = tokenizer2.getSuffix();
            if (number1 < number2) {
                return -1;
            }
            if (number1 > number2) {
                return 1;
            }
            boolean empty1 = suffix1.length() == 0;
            boolean bl = empty2 = suffix2.length() == 0;
            if (empty1 && empty2) continue;
            if (empty1) {
                return 1;
            }
            if (empty2) {
                return -1;
            }
            int result = suffix1.compareTo(suffix2);
            if (result == 0) continue;
            return result;
        }
        if (tokenizer2.MoveNext()) {
            do {
                number2 = tokenizer2.getNumber();
                suffix2 = tokenizer2.getSuffix();
                if (number2 == 0 && suffix2.length() == 0) continue;
                return -1;
            } while (tokenizer2.MoveNext());
            return 0;
        }
        return 0;
    }

    private static class VersionTokenizer {
        private final String _versionString;
        private final int _length;
        private int _position;
        private int _number;
        private String _suffix;

        public int getNumber() {
            return this._number;
        }

        public String getSuffix() {
            return this._suffix;
        }

        public VersionTokenizer(String versionString) {
            if (versionString == null) {
                throw new IllegalArgumentException("versionString is null");
            }
            this._versionString = versionString;
            this._length = versionString.length();
        }

        public boolean MoveNext() {
            char c;
            char c2;
            this._number = 0;
            this._suffix = "";
            if (this._position >= this._length) {
                return false;
            }
            while (this._position < this._length && (c2 = this._versionString.charAt(this._position)) >= '0' && c2 <= '9') {
                this._number = this._number * 10 + (c2 - 48);
                ++this._position;
            }
            int suffixStart = this._position;
            while (this._position < this._length && (c = this._versionString.charAt(this._position)) != '.') {
                ++this._position;
            }
            this._suffix = this._versionString.substring(suffixStart, this._position);
            if (this._position < this._length) {
                ++this._position;
            }
            return true;
        }
    }
}

