/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.board;

import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Rotation;
import java.io.Serializable;
import java.util.Objects;

public class Edge
implements Serializable {
    private static final long serialVersionUID = 1L;
    final Position p1;
    final Position p2;

    public Edge(Position p1, Position p2) {
        assert (!p1.equals(p2));
        if (p1.compareTo(p2) > 0) {
            this.p1 = p2;
            this.p2 = p1;
        } else {
            this.p1 = p1;
            this.p2 = p2;
        }
    }

    public Edge(Position pos, Location loc) {
        this(pos, pos.add(loc));
    }

    public Edge translate(Position pos) {
        return new Edge(this.p1.add(pos), this.p2.add(pos));
    }

    public Edge rotateCW(Position origin, Rotation rot) {
        return new Edge(this.p1.rotateCW(origin, rot), this.p2.rotateCW(origin, rot));
    }

    public Edge rotateCCW(Position origin, Rotation rot) {
        return new Edge(this.p1.rotateCCW(origin, rot), this.p2.rotateCCW(origin, rot));
    }

    public boolean isHorizontal() {
        return this.p1.x == this.p2.x;
    }

    public boolean isVertical() {
        return this.p1.y == this.p2.y;
    }

    public Position getP1() {
        return this.p1;
    }

    public Position getP2() {
        return this.p2;
    }

    public int hashCode() {
        return Objects.hash(this.p1, this.p2);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        Edge e = (Edge)obj;
        return Objects.equals(this.p1, e.p1) && Objects.equals(this.p2, e.p2);
    }

    public String toString() {
        return String.format("Edge(%s, %s)", this.p1, this.p2);
    }
}

