/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.board;

public enum EdgeType {
    ROAD(1, 'R'),
    CITY(2, 'C'),
    FARM(4, 'F'),
    RIVER(8, 'I'),
    UNKNOWN(15, '?');

    private int mask;
    private char ch;

    private EdgeType(int mask, char ch) {
        this.mask = mask;
        this.ch = ch;
    }

    public int getMask() {
        return this.mask;
    }

    public char asChar() {
        return this.ch;
    }

    static EdgeType forMask(int mask) {
        for (EdgeType e : EdgeType.values()) {
            if (e.mask != mask) continue;
            return e;
        }
        throw new IllegalArgumentException("Invalid Edge mask " + mask);
    }

    static EdgeType forChar(int ch) {
        for (EdgeType e : EdgeType.values()) {
            if (e.ch != ch) continue;
            return e;
        }
        throw new IllegalArgumentException("Unknown edge " + ch);
    }
}

