/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.board;

import com.jcloisterzone.board.Tile;
import io.vavr.collection.Vector;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;

public class TileGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Vector<Tile> tiles;
    private final boolean active;
    private final String successiveGroup;

    public TileGroup(String name, Vector<Tile> tiles, boolean active) {
        this(name, tiles, active, null);
    }

    public TileGroup(String name, Vector<Tile> tiles, boolean active, String successiveGroup) {
        this.name = name;
        this.tiles = tiles;
        this.active = active;
        this.successiveGroup = successiveGroup;
    }

    public String getName() {
        return this.name;
    }

    public Vector<Tile> getTiles() {
        return this.tiles;
    }

    public TileGroup setTiles(Vector<Tile> tiles) {
        if (this.tiles == tiles) {
            return this;
        }
        return new TileGroup(this.name, tiles, this.active, this.successiveGroup);
    }

    public TileGroup mapTiles(Function<Vector<Tile>, Vector<Tile>> fn) {
        return this.setTiles(fn.apply(this.tiles));
    }

    public boolean isActive() {
        return this.active;
    }

    public TileGroup setActive(boolean active) {
        if (this.active == active) {
            return this;
        }
        return new TileGroup(this.name, this.tiles, active, this.successiveGroup);
    }

    public String getSuccessiveGroup() {
        return this.successiveGroup;
    }

    public TileGroup setSuccessiveGroup(String successiveGroup) {
        if (Objects.equals(this.successiveGroup, successiveGroup)) {
            return this;
        }
        return new TileGroup(this.name, this.tiles, this.active, successiveGroup);
    }

    public int size() {
        return this.tiles.size();
    }

    public boolean isEmpty() {
        return this.tiles.isEmpty();
    }
}

