/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.board;

import com.jcloisterzone.board.EdgePattern;
import com.jcloisterzone.board.Tile;
import com.jcloisterzone.board.TileGroup;
import com.jcloisterzone.game.RandomGenerator;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.Map;
import io.vavr.collection.Stream;
import io.vavr.collection.Vector;
import io.vavr.control.Option;
import java.io.Serializable;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TilePack
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LinkedHashMap<String, TileGroup> groups;
    private final int hiddenUnderHills;

    public TilePack(LinkedHashMap<String, TileGroup> groups, int hiddenUnderHills) {
        this.groups = groups;
        this.hiddenUnderHills = hiddenUnderHills;
    }

    public LinkedHashMap<String, TileGroup> getGroups() {
        return this.groups;
    }

    public int getHiddenUnderHills() {
        return this.hiddenUnderHills;
    }

    public TilePack setGroups(LinkedHashMap<String, TileGroup> groups) {
        if (this.groups == groups) {
            return this;
        }
        return new TilePack(groups, this.hiddenUnderHills);
    }

    public TilePack setHiddenUnderHills(int hiddenUnderHills) {
        if (this.hiddenUnderHills == hiddenUnderHills) {
            return this;
        }
        return new TilePack(this.groups, hiddenUnderHills);
    }

    public TilePack increaseHiddenUnderHills() {
        return this.setHiddenUnderHills(this.hiddenUnderHills + 1);
    }

    private Stream<TileGroup> getActiveGroups() {
        return Stream.ofAll(this.groups.values()).filter(TileGroup::isActive);
    }

    private Stream<Tile> getActiveTiles() {
        return this.getActiveGroups().flatMap(TileGroup::getTiles);
    }

    public Map<EdgePattern, Integer> getPatterns() {
        return Stream.ofAll(this.groups.values()).flatMap(TileGroup::getTiles).map(Tile::getEdgePattern).map(EdgePattern::canonize).foldLeft(HashMap.empty(), (m, e) -> m.put(e, (Object)(m.getOrElse(e, 0) + 1)));
    }

    public int totalSize() {
        return Stream.ofAll(this.groups.values()).map(TileGroup::size).sum().intValue() - this.hiddenUnderHills;
    }

    public int size() {
        return this.getActiveGroups().map(TileGroup::size).sum().intValue() - this.hiddenUnderHills;
    }

    public boolean isEmpty() {
        return this.size() <= 0;
    }

    protected int getInternalSize() {
        return this.size() + this.hiddenUnderHills;
    }

    public boolean hasGroup(String name) {
        return this.groups.containsKey(name);
    }

    public TileGroup getGroup(String name) {
        return (TileGroup)this.groups.get(name).getOrNull();
    }

    public int getGroupSize(String name) {
        return this.groups.get(name).map(TileGroup::size).getOrElse(0);
    }

    public TilePack mapGroup(String name, Function<TileGroup, TileGroup> mapper) {
        return this.updateGroup(mapper.apply(this.getGroup(name)));
    }

    private TilePack updateGroup(TileGroup group) {
        if (group.isEmpty()) {
            TilePack pack = this.setGroups((LinkedHashMap<String, TileGroup>)this.groups.remove((Object)group.getName()));
            String succ = group.getSuccessiveGroup();
            if (succ != null && pack.hasGroup(succ)) {
                pack = pack.activateGroup(succ);
            }
            return pack;
        }
        return this.setGroups((LinkedHashMap<String, TileGroup>)this.groups.put((Object)group.getName(), (Object)group));
    }

    public Tuple2<Tile, TilePack> drawTile(RandomGenerator random) {
        int index = random.nextInt(this.getInternalSize());
        for (TileGroup group : this.getActiveGroups()) {
            if (index < group.size()) {
                Vector<Tile> tiles = group.getTiles();
                Tile tile = tiles.get(index);
                group = group.setTiles((Vector<Tile>)tiles.removeAt(index));
                return new Tuple2<Tile, TilePack>(tile, this.updateGroup(group));
            }
            index -= group.size();
        }
        throw new IllegalArgumentException();
    }

    public Tuple2<Tile, TilePack> drawTile(String groupName, String tileId) {
        Predicate<Tile> matchesId = t -> t.getId().equals(tileId);
        TileGroup group = this.groups.get(groupName).getOrElseThrow(IllegalArgumentException::new);
        Tile tile = group.getTiles().find(matchesId).getOrElseThrow(IllegalArgumentException::new);
        TilePack pack = this.updateGroup(group.mapTiles(tiles -> tiles.removeFirst((Predicate)matchesId)));
        return new Tuple2<Tile, TilePack>(tile, pack);
    }

    public Tuple2<Tile, TilePack> drawTile(String tileId) {
        for (TileGroup group : this.getActiveGroups()) {
            try {
                return this.drawTile(group.getName(), tileId);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        throw new IllegalArgumentException("Tile pack does not contain active " + tileId);
    }

    public TilePack removeTilesById(String tileId) {
        return this.setGroups((LinkedHashMap<String, TileGroup>)this.groups.mapValues(g -> g.mapTiles(tiles -> tiles.filter(tile -> !tile.getId().equals(tileId)))));
    }

    public TilePack activateGroup(String groupName) {
        TileGroup group = (TileGroup)this.groups.get(groupName).getOrNull();
        if (group == null || group.isActive()) {
            return this;
        }
        return this.setGroups((LinkedHashMap<String, TileGroup>)this.groups.put((Object)groupName, (Object)group.setActive(true)));
    }

    public TilePack deactivateGroup(String groupName) {
        TileGroup group = (TileGroup)this.groups.get(groupName).getOrNull();
        if (group == null || !group.isActive()) {
            return this;
        }
        return this.setGroups((LinkedHashMap<String, TileGroup>)this.groups.put((Object)groupName, (Object)group.setActive(false)));
    }

    public int getSizeForEdgePattern(EdgePattern edgePattern) {
        return this.getActiveTiles().filter(tile -> edgePattern.isMatchingAnyRotation(tile.getEdgePattern())).size();
    }

    public Option<Tile> findTile(String tileId) {
        Predicate<Tile> pred = t -> t.getId().equals(tileId);
        for (TileGroup group : this.groups.values()) {
            Option<Tile> res = group.getTiles().find(pred);
            if (res.isEmpty()) continue;
            return res;
        }
        return Option.none();
    }

    public String toString() {
        return String.format("%s/%s", this.size(), this.totalSize());
    }
}

