/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.board;

import com.jcloisterzone.Expansion;
import com.jcloisterzone.XMLUtils;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.RemoveTileException;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.Tile;
import com.jcloisterzone.board.TileBuilder;
import com.jcloisterzone.board.TileGroup;
import com.jcloisterzone.board.TilePack;
import com.jcloisterzone.config.Config;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.Rule;
import com.jcloisterzone.game.capability.RiverCapability;
import com.jcloisterzone.game.capability.TunnelCapability;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTile;
import io.vavr.Tuple2;
import io.vavr.collection.IndexedSeq;
import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.Seq;
import io.vavr.collection.Stream;
import io.vavr.collection.Vector;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TilePackBuilder {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String DEFAULT_TILE_GROUP = "default";
    private final TileBuilder tileBuilder = new TileBuilder();
    protected GameState state;
    protected io.vavr.collection.Map<Expansion, Integer> expansions;
    protected Config config;
    private Set<String> usedIds = new HashSet<String>();
    private Map<Expansion, Element> parsedDefinitions = new HashMap<Expansion, Element>();
    private Map<String, List<Tile>> tiles = new HashMap<String, List<Tile>>();
    private io.vavr.collection.Map<Position, Tuple2<PlacedTile, Integer>> preplacedTiles = io.vavr.collection.HashMap.empty();

    public void setGameState(GameState state) {
        this.state = state;
        this.tileBuilder.setGameState(state);
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setExpansions(io.vavr.collection.Map<Expansion, Integer> expansions) {
        this.expansions = expansions;
    }

    public Stream<TileCount> getExpansionTiles(Expansion expansion) {
        Element el = this.getExpansionDefinition(expansion);
        return XMLUtils.elementStream(el.getElementsByTagName("tile")).map(tileElement -> {
            String tileId = XMLUtils.getTileId(expansion, tileElement);
            return new TileCount(tileId, this.getTileCount((Element)tileElement, tileId, 1));
        });
    }

    public int getExpansionSize(Expansion expansion) {
        Element el = this.getExpansionDefinition(expansion);
        NodeList nl = el.getElementsByTagName("tile");
        int size = 0;
        for (int i = 0; i < nl.getLength(); ++i) {
            Element tileElement = (Element)nl.item(i);
            String tileId = XMLUtils.getTileId(expansion, tileElement);
            size += this.getTileCount(tileElement, tileId, 1);
        }
        return size;
    }

    protected URL getStandardTilesConfig(Expansion expansion) {
        String fileName = "tile-definitions/" + expansion.name().toLowerCase() + ".xml";
        return TilePackBuilder.class.getClassLoader().getResource(fileName);
    }

    protected URL getTilesConfig(Expansion expansion) {
        Config.DebugConfig debugConfig = this.config.getDebug();
        String fileName = null;
        if (debugConfig != null && debugConfig.getTile_definitions() != null) {
            fileName = debugConfig.getTile_definitions().get(expansion.name());
        }
        if (fileName == null) {
            fileName = "tile-definitions/" + expansion.name().toLowerCase() + ".xml";
            if (expansion.getOrigin() != null) {
                return expansion.getOrigin().getLoader().getResource(fileName);
            }
        }
        if (fileName.startsWith("/")) {
            try {
                return new File(fileName).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return TilePackBuilder.class.getClassLoader().getResource(fileName);
    }

    protected Element getExpansionDefinition(Expansion expansion) {
        Element root = this.parsedDefinitions.get(expansion);
        if (root == null) {
            try {
                root = XMLUtils.parseDocument(this.getTilesConfig(expansion)).getDocumentElement();
                this.parsedDefinitions.put(expansion, root);
            }
            catch (Exception e) {
                this.logger.error("Can't parse definition for " + expansion.name(), e);
            }
        }
        return root;
    }

    protected boolean isTunnelActive(Expansion expansion) {
        if (!this.state.getCapabilities().contains(TunnelCapability.class)) {
            return false;
        }
        return expansion == Expansion.TUNNEL || this.state.getBooleanValue(Rule.TUNNELIZE_ALL_EXPANSIONS);
    }

    protected int getTileCount(Element tileEl, String tileId, int expansionCount) {
        int baseCount = XMLUtils.attributeIntValue(tileEl, "count", 1);
        return Math.min(expansionCount * baseCount, XMLUtils.attributeIntValue(tileEl, "maxCount", Integer.MAX_VALUE));
    }

    protected String getTileGroup(Tile tile, Vector<Element> tileElements) {
        String group;
        for (Capability capability : this.state.getCapabilities().toSeq()) {
            group = capability.getTileGroup(tile);
            if (group == null) continue;
            return group;
        }
        for (Element element : tileElements) {
            group = element.getAttribute("group");
            if (group.isEmpty()) continue;
            return group;
        }
        return DEFAULT_TILE_GROUP;
    }

    public Tile initTile(Tile tile, Vector<Element> tileElements) throws RemoveTileException {
        for (Capability capability : this.state.getCapabilities().toSeq()) {
            tile = capability.initTile(this.state, tile, tileElements);
        }
        return tile;
    }

    public Tile createTile(Expansion expansion, String tileId, Vector<Element> tileElements) throws RemoveTileException {
        if (this.usedIds.contains(tileId)) {
            throw new IllegalArgumentException("Multiple occurences of id " + tileId + " in tile definition xml.");
        }
        this.usedIds.add(tileId);
        Tile tile = this.tileBuilder.createTile(expansion, tileId, tileElements, this.isTunnelActive(expansion));
        return this.initTile(tile, tileElements);
    }

    public Stream<Preplaced> getPreplacedPositions(String tileId, Vector<Element> tileElements) {
        return Stream.concat(tileElements.map(el -> XMLUtils.elementStream(el.getElementsByTagName("position")))).map(e -> {
            Position pos = new Position(XMLUtils.attributeIntValue(e, "x"), XMLUtils.attributeIntValue(e, "y"));
            return new Preplaced(pos, XMLUtils.attributeIntValue(e, "priority", 1));
        });
    }

    public Element findTileElement(String id) {
        String[] tokens = id.split("\\.", 2);
        Expansion expansion = Expansion.valueOfCode(tokens[0]);
        Element element = this.getExpansionDefinition(expansion);
        NodeList nl = element.getElementsByTagName("tile");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element tileElement = (Element)nl.item(i);
            if (!tileElement.getAttribute("id").equals(tokens[1])) continue;
            return tileElement;
        }
        throw new NoSuchElementException();
    }

    public Tiles createTilePack() {
        this.expansions.forEach(t -> {
            Expansion expansion = (Expansion)t._1;
            Element element = this.getExpansionDefinition(expansion);
            int expansionCount = Math.min((Integer)t._2, XMLUtils.attributeIntValue(element, "maxCount", 5));
            NodeList nl = element.getElementsByTagName("tile");
            XMLUtils.elementStream(nl).forEach(tileElement -> {
                Tile tile;
                String capabilityClass = tileElement.getAttribute("if-capability");
                if (!capabilityClass.isEmpty()) {
                    try {
                        Class<?> cls = Class.forName(capabilityClass);
                        if (!this.state.getCapabilities().contains(cls)) {
                            return;
                        }
                    }
                    catch (ClassNotFoundException e) {
                        this.logger.error("Can't find " + capabilityClass, e);
                    }
                }
                String extendsTile = tileElement.getAttribute("extends");
                IndexedSeq<Element> tileElements = Vector.of(tileElement);
                if (!extendsTile.isEmpty()) {
                    Element parentElement = this.findTileElement(extendsTile);
                    tileElements = tileElements.append((Object)parentElement);
                }
                String tileId = XMLUtils.getTileId(expansion, tileElement);
                io.vavr.collection.List positions = this.getPreplacedPositions(tileId, (Vector<Element>)tileElements).toList();
                int count = this.getTileCount((Element)tileElement, tileId, expansionCount);
                try {
                    tile = this.createTile(expansion, tileId, (Vector<Element>)tileElements);
                }
                catch (RemoveTileException ex) {
                    return;
                }
                for (int ci = 0; ci < count; ++ci) {
                    Position pos = null;
                    int priority = 0;
                    if (positions != null && !positions.isEmpty()) {
                        Preplaced pp = (Preplaced)positions.peek();
                        pos = pp.position;
                        priority = pp.priority;
                        positions = positions.pop();
                        if (this.expansions.containsKey(Expansion.COUNT)) {
                            if (tileId.equals("BA.RCr")) continue;
                            if (tileId.equals("R1.I.s") || tileId.equals("R2.I.s") || tileId.equals("GQ.RFI")) {
                                pos = new Position(1, 2);
                            }
                            if (tileId.equals("WR.CFR")) {
                                pos = new Position(-2, -2);
                            }
                        } else if (this.expansions.containsKey(Expansion.WIND_ROSE) && this.state.getCapabilities().contains(RiverCapability.class) && tileId.equals("WR.CFR")) {
                            pos = new Position(0, 1);
                        }
                        this.logger.info("Setting initial placement {} for {}", (Object)pos, (Object)tileId);
                    }
                    if (pos != null) {
                        Tuple2 pt = (Tuple2)this.preplacedTiles.get(pos).getOrNull();
                        if (pt != null && (Integer)pt._2 >= priority) continue;
                        this.preplacedTiles = this.preplacedTiles.put(pos, new Tuple2<PlacedTile, Integer>(new PlacedTile(tile, pos, Rotation.R0), priority));
                        continue;
                    }
                    String group = this.getTileGroup(tile, (Vector<Element>)tileElements);
                    if (!this.tiles.containsKey(group)) {
                        this.tiles.put(group, new ArrayList());
                    }
                    this.tiles.get(group).add(tile);
                }
            });
        });
        io.vavr.collection.Map<String, TileGroup> groups = LinkedHashMap.empty();
        IndexedSeq groupNames = Vector.ofAll(this.tiles.keySet()).sorted();
        for (String name : groupNames) {
            List<Tile> groupTiles = this.tiles.get(name);
            groups = groups.put((Object)name, (Object)new TileGroup(name, (Vector<Tile>)Vector.ofAll(groupTiles).sortBy(Tile::getId), true));
        }
        return new Tiles(new TilePack((LinkedHashMap<String, TileGroup>)groups, 0), (Seq<PlacedTile>)this.preplacedTiles.values().map(Tuple2::_1));
    }

    public static class Tiles {
        private final TilePack tilePack;
        private Seq<PlacedTile> preplacedTiles;

        public Tiles(TilePack tilePack, Seq<PlacedTile> preplacedTiles) {
            this.tilePack = tilePack;
            this.preplacedTiles = preplacedTiles;
        }

        public TilePack getTilePack() {
            return this.tilePack;
        }

        public Seq<PlacedTile> getPreplacedTiles() {
            return this.preplacedTiles;
        }
    }

    public class Preplaced {
        final Position position;
        final int priority;

        public Preplaced(Position position, int priority) {
            this.position = position;
            this.priority = priority;
        }
    }

    public static class TileCount {
        public String tileId;
        public Integer count;

        public TileCount(String tileId, Integer count) {
            this.tileId = tileId;
            this.count = count;
        }
    }
}

