/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.board.pointer;

import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.pointer.BoardPointer;
import com.jcloisterzone.feature.Farm;
import com.jcloisterzone.feature.Feature;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.List;
import io.vavr.collection.Stream;
import java.util.Objects;

public class FeaturePointer
implements BoardPointer {
    private static final long serialVersionUID = 1L;
    private final Position position;
    private final Location location;

    public FeaturePointer(Position position, Location location) {
        this.position = position;
        this.location = location;
    }

    @Override
    public FeaturePointer asFeaturePointer() {
        return this;
    }

    public FeaturePointer translate(Position pos) {
        return new FeaturePointer(this.position.add(pos), this.location);
    }

    public FeaturePointer rotateCW(Rotation rot) {
        return new FeaturePointer(this.position, this.location.rotateCW(rot));
    }

    public FeaturePointer rotateCCW(Rotation rot) {
        return new FeaturePointer(this.position, this.location.rotateCCW(rot));
    }

    public Stream<FeaturePointer> getAdjacent(Class<? extends Feature> forType) {
        boolean isFarm = Farm.class.isAssignableFrom(forType);
        if (isFarm) {
            return Stream.ofAll(Location.SIDES).flatMap(loc -> {
                LinearSeq res = List.empty();
                Location l = loc.getLeftFarm();
                Location r = loc.getRightFarm();
                if (l.intersect(this.location) != null) {
                    res = res.prepend(new FeaturePointer(this.position.add((Location)loc), l.rev()));
                }
                if (r.intersect(this.location) != null) {
                    res = res.prepend(new FeaturePointer(this.position.add((Location)loc), r.rev()));
                }
                return res;
            });
        }
        return Stream.ofAll(Location.SIDES).filter(loc -> loc.intersect(this.location) != null).map(loc -> new FeaturePointer(this.position.add((Location)loc), loc.rev()));
    }

    public boolean isPartOf(FeaturePointer other) {
        return this.position.equals(other.position) && this.location.isPartOf(other.location);
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    public FeaturePointer setPosition(Position position) {
        if (this.position == position) {
            return this;
        }
        return new FeaturePointer(position, this.location);
    }

    public Location getLocation() {
        return this.location;
    }

    public FeaturePointer setLocation(Location location) {
        if (this.location == location) {
            return this;
        }
        return new FeaturePointer(this.position, location);
    }

    public String toString() {
        return String.format("{%s,%s}", this.position, this.location);
    }

    public int hashCode() {
        return Objects.hash(this.position, this.location);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeaturePointer other = (FeaturePointer)obj;
        if (!Objects.equals(this.location, other.location)) {
            return false;
        }
        return Objects.equals(this.position, other.position);
    }
}

