/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.bugreport;

import com.jcloisterzone.bugreport.ReportingTool;
import com.jcloisterzone.ui.I18nUtils;
import com.jcloisterzone.ui.gtk.ThemedJLabel;
import com.jcloisterzone.ui.gtk.ThemedJPanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BugReportPanel
extends ThemedJPanel {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private ReportingTool reportingTool;
    private JDialog parent;

    public BugReportPanel() {
        this.setLayout(new MigLayout("insets dialog, gapy unrel", "[grow]", "[][][grow,fill][][]"));
        ThemedJLabel headerLabel = new ThemedJLabel(I18nUtils._tr("<html>Bug report tool pack saved game, internal game log and system information to simplify debugging process.</html>", new Object[0]));
        this.add((Component)headerLabel, "cell 0 0");
        ThemedJLabel describeLabel = new ThemedJLabel(I18nUtils._tr("Please describe bug...", new Object[0]));
        this.add((Component)describeLabel, "cell 0 1,grow");
        final JTextArea textArea = new JTextArea();
        textArea.setFont(new Font("SansSerif", 0, 11));
        this.add((Component)textArea, "cell 0 2,grow");
        JButton downloadButton = new JButton("Download report");
        downloadButton.addActionListener(new ActionListener(){
            final /* synthetic */ BugReportPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.selectFile(textArea.getText());
            }
        });
        ThemedJLabel downloadLabel = new ThemedJLabel(I18nUtils._tr("...then download report archive and send via email to farin@farin.cz", new Object[0]));
        this.add((Component)downloadLabel, "cell 0 3");
        this.add((Component)downloadButton, "cell 0 4");
    }

    public void selectFile(String description) {
        File file;
        JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));
        fc.setFileSelectionMode(0);
        fc.setDialogTitle(I18nUtils._tr("Report bug", new Object[0]));
        fc.setDialogType(1);
        fc.setFileFilter(new ReportFileFilter());
        fc.setLocale(this.getLocale());
        fc.setSelectedFile(new File("report.zip"));
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0 && (file = fc.getSelectedFile()) != null) {
            if (!file.getName().endsWith(".zip")) {
                file = new File(file.getAbsolutePath() + ".zip");
            }
            try {
                this.reportingTool.createReport(new FileOutputStream(file), description);
                this.parent.dispose();
            }
            catch (Exception ex) {
                this.logger.error("Bug report failed", ex);
                JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), I18nUtils._tr("Bug report failed", new Object[0]), 0);
            }
        }
    }

    public ReportingTool getReportingTool() {
        return this.reportingTool;
    }

    public void setReportingTool(ReportingTool reportingTool) {
        this.reportingTool = reportingTool;
    }

    public void setParent(JDialog parent) {
        this.parent = parent;
    }

    public static class ReportFileFilter
    extends FileFilter {
        @Override
        public boolean accept(File f) {
            return f.getName().toLowerCase().endsWith(".zip") || f.isDirectory();
        }

        @Override
        public String getDescription() {
            return "*.zip";
        }
    }
}

