/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.config;

import com.floreysoft.jmte.Engine;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import com.jcloisterzone.KeyUtils;
import com.jcloisterzone.ai.player.LegacyAiPlayer;
import com.jcloisterzone.config.Config;
import com.jcloisterzone.ui.Client;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.parser.ParserException;

public class ConfigLoader {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String DEFAULT_UPDATE = "http://jcloisterzone.com/version.xml";
    public static final int DEFAULT_PORT = 37447;
    public static final int DEFAULT_SCORE_DISPLAY_DURATION = 9;
    public static final int DEFAULT_AI_PLACE_TILE_DELAY = 250;
    public static final String DEFAULT_AI_CLASS_NAME = LegacyAiPlayer.class.getName();
    public static final String DEFAULT_THEME = "light";
    public static final int DEFAULT_SCREENSHOT_SCALE = 120;
    public static final String DEFAULT_PLAY_ONLINE_HOST = "play.jcloisterzone.com";
    public static final String DEFAULT_SAVED_GAMES_FORMAT = "compact";
    private final Path dataDirectory;
    private final Yaml yaml;
    private final Pattern indentPatter = Pattern.compile("^", 8);

    public ConfigLoader(Path dataDirectory) {
        this.dataDirectory = dataDirectory;
        this.yaml = new Yaml(new Constructor(Config.class));
    }

    private File getConfigFile() {
        String configFile = System.getProperty("config");
        if (configFile != null) {
            URL resource;
            File file = Paths.get(configFile, new String[0]).toFile();
            if (!file.exists() && (resource = Client.class.getClassLoader().getResource(configFile)) != null) {
                file = new File(resource.getFile());
            }
            if (file.exists()) {
                return file;
            }
            this.logger.warn("Custom configuration file not found {}. Using default.", (Object)file.toString());
        }
        return this.dataDirectory.resolve("config.yaml").toFile();
    }

    public Config load() {
        Yaml yaml = new Yaml(new Constructor(Config.class));
        File configFile = this.getConfigFile();
        Config config = null;
        boolean save = false;
        if (!configFile.exists()) {
            this.logger.info("Default configuration file {} doesn't exist. Creating new one.", (Object)configFile);
            config = this.createDefault();
            config.setOrigin(configFile);
            save = true;
        } else {
            this.logger.info("Loading configuration {}", (Object)configFile);
            try {
                config = (Config)yaml.load(new FileInputStream(configFile));
            }
            catch (Exception ex) {
                this.logger.warn("Error reading configuration.", ex);
                if (ex instanceof ParserException) {
                    String name = configFile.getParent() == null ? "~" + configFile.getName() : configFile.getParent() + File.separator + "~" + configFile.getName();
                    File backup = new File(name);
                    if (!backup.isFile()) {
                        try {
                            Files.copy(configFile.toPath(), backup.toPath(), new CopyOption[0]);
                        }
                        catch (IOException copyEx) {
                            this.logger.warn("Unable to backup invalid config.", copyEx);
                        }
                    }
                    save = true;
                }
                config = this.createDefault();
            }
            config.setOrigin(configFile);
        }
        if (config.getClient_id() == null) {
            config.setClient_id(KeyUtils.createRandomId());
            save = true;
        }
        if (config.getSecret() == null) {
            config.setSecret(KeyUtils.createRandomId());
            save = true;
        }
        if (save) {
            this.save(config);
        }
        return config;
    }

    public void save(Config config) {
        File file = config.getOrigin();
        try (PrintWriter writer = new PrintWriter(file);){
            writer.print(this.fillTemplate(config));
            this.logger.info("Configuration saved {}", (Object)file);
        }
        catch (IOException e) {
            this.logger.warn("Unable to create configuration file {}", (Object)file);
        }
    }

    private Config createDefault() {
        Config config = new Config();
        config.setUpdate(DEFAULT_UPDATE);
        config.setPort(37447);
        config.setScore_display_duration(9);
        config.getAi().setPlace_tile_delay(250);
        config.getAi().setClass_name(DEFAULT_AI_CLASS_NAME);
        config.setTheme(DEFAULT_THEME);
        config.setClient_name("");
        config.setTile_rotation(Config.TileRotationControls.TAB_RCLICK);
        config.setPlay_online_host(DEFAULT_PLAY_ONLINE_HOST);
        config.setClient_id(KeyUtils.createRandomId());
        config.setSecret(KeyUtils.createRandomId());
        config.getConfirm().setFarm_deployment(true);
        config.getConfirm().setOn_tower_deployment(true);
        config.getConfirm().setRansom_payment(true);
        config.getPlayers().setColors(Lists.newArrayList(new Config.ColorConfig("RED"), new Config.ColorConfig("#008ffe", null, "#5bb7fe"), new Config.ColorConfig("#FFED00"), new Config.ColorConfig("#009900", null, "#37a800"), new Config.ColorConfig("BLACK", null, "WHITE"), new Config.ColorConfig("#812EFF", null, "#ba92f8")));
        config.getPlayers().setAi_names(Lists.newArrayList("Adda", "Ellen", "Caitlyn", "Riannon", "Tankred", "Rigatona"));
        config.getPlugins().setLookup_folders(Lists.newArrayList("plugins"));
        config.getPlugins().setEnabled_plugins(Lists.newArrayList("classic.jar"));
        config.getScreenshots().setScale(120);
        config.getSaved_games().setFormat(DEFAULT_SAVED_GAMES_FORMAT);
        return config;
    }

    private String indent(int level, String fragment) {
        if ((fragment = fragment.trim()).length() == 0) {
            return "\n";
        }
        String spaces = String.format("%" + level * 2 + "s", "");
        return "\n" + this.indentPatter.matcher(fragment).replaceAll(spaces);
    }

    public String fillTemplate(Config config) throws IOException {
        Config.DebugConfig dc;
        Config.PlayersConfig pc;
        String template = Resources.toString(Client.class.getClassLoader().getResource("config.tpl"), Charsets.UTF_8);
        Engine engine = new Engine();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("update", config.getUpdate());
        model.put("port", config.getPort());
        model.put("locale", config.getLocale());
        model.put("score_display_duration", config.getScore_display_duration());
        model.put("theme", config.getTheme());
        model.put("beep_alert", config.getBeep_alert());
        model.put("tile_rotation", (Object)config.getTile_rotation());
        model.put("client_name", config.getClient_name());
        model.put("play_online_host", config.getPlay_online_host());
        model.put("client_id", config.getClient_id());
        model.put("secret", config.getSecret());
        model.put("screenshot_folder", config.getScreenshots().getFolder());
        model.put("screenshot_scale", config.getScreenshots().getScale());
        model.put("saved_games_folder", config.getSaved_games().getFolder());
        model.put("saved_games_format", config.getSaved_games().getFormat());
        if (config.getConfirm() != null) {
            model.put("confirm", this.indent(1, this.yaml.dumpAs(config.getConfirm(), Tag.MAP, DumperOptions.FlowStyle.BLOCK)));
        }
        if (config.getAi() != null) {
            model.put("ai_place_tile_delay", config.getAi().getPlace_tile_delay());
            model.put("ai_class_name", config.getAi().getClass_name());
        }
        if ((pc = config.getPlayers()) != null) {
            if (pc.getColors() != null && !pc.getColors().isEmpty()) {
                StringBuilder colors = new StringBuilder();
                for (Config.ColorConfig cfg : pc.getColors()) {
                    colors.append("\n  - ");
                    colors.append(this.yaml.dumpAs(cfg, Tag.MAP, DumperOptions.FlowStyle.FLOW).trim());
                }
                model.put("colors", colors.toString());
            }
            if (pc.getNames() != null && !pc.getNames().isEmpty()) {
                model.put("player_names", this.yaml.dumpAs(pc.getNames(), Tag.SEQ, DumperOptions.FlowStyle.FLOW).trim());
            }
            if (pc.getAi_names() != null && !pc.getAi_names().isEmpty()) {
                model.put("ai_names", this.yaml.dumpAs(pc.getAi_names(), Tag.SEQ, DumperOptions.FlowStyle.FLOW).trim());
            }
        }
        model.put("plugins_lookup_folders", this.indent(2, this.yaml.dumpAs(config.getPlugins().getLookup_folders(), Tag.SEQ, DumperOptions.FlowStyle.BLOCK)));
        model.put("plugins_enabled_plugins", this.indent(2, this.yaml.dumpAs(config.getPlugins().getEnabled_plugins(), Tag.SEQ, DumperOptions.FlowStyle.BLOCK)));
        if (config.getPresets() != null && !config.getPresets().isEmpty()) {
            model.put("presets", this.indent(1, this.yaml.dumpAs(config.getPresets(), Tag.MAP, DumperOptions.FlowStyle.BLOCK)));
        }
        if (config.getConnection_history() != null && !config.getConnection_history().isEmpty()) {
            model.put("connection_history", this.yaml.dumpAs(config.getConnection_history(), Tag.SEQ, DumperOptions.FlowStyle.FLOW).trim());
        }
        model.put("hasDebug", (dc = config.getDebug()) != null);
        if (dc != null) {
            model.put("window_size", dc.getWindow_size());
            model.put("autosave", dc.getAutosave());
            if (dc.getAutostart() != null) {
                model.put("autostart", this.indent(2, this.yaml.dumpAs(dc.getAutostart(), Tag.MAP, DumperOptions.FlowStyle.BLOCK)));
            }
            if (dc.getTile_definitions() != null && !dc.getTile_definitions().isEmpty()) {
                model.put("tile_definitions", this.indent(2, this.yaml.dumpAs(dc.getTile_definitions(), Tag.MAP, DumperOptions.FlowStyle.BLOCK)));
            }
            if (dc.getGame_annotation() != null && !dc.getGame_annotation().isEmpty()) {
                model.put("game_annotation", this.indent(2, this.yaml.dumpAs(dc.getGame_annotation(), Tag.MAP, DumperOptions.FlowStyle.BLOCK)));
            }
            model.put("area_highlight", dc.getArea_highlight());
        }
        String result = engine.transform(template, model);
        result = result.replace(" !!" + Config.PresetConfig.class.getName(), "");
        result = result.replace("\n", System.lineSeparator());
        return result;
    }
}

