/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.debug;

import com.jcloisterzone.board.Tile;
import com.jcloisterzone.board.TileGroup;
import com.jcloisterzone.board.TilePack;
import com.jcloisterzone.game.RandomGenerator;
import io.vavr.Tuple2;
import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.Queue;
import java.util.List;
import java.util.Map;

public class ForcedDrawTilePack
extends TilePack {
    private final Queue<String> drawQueue;
    private final Integer drawLimit;

    public ForcedDrawTilePack(LinkedHashMap<String, TileGroup> groups, Map<String, Object> params) {
        this(groups, 0, ForcedDrawTilePack.paramsToDrawQueue(params), ForcedDrawTilePack.paramsToDrawLimit(params));
    }

    private static Queue<String> paramsToDrawQueue(Map<String, Object> params) {
        if (params == null) {
            return Queue.empty();
        }
        List drawOrder = (List)params.get("drawOrder");
        return drawOrder == null ? Queue.empty() : Queue.ofAll(drawOrder);
    }

    private static Integer paramsToDrawLimit(Map<String, Object> params) {
        if (params == null) {
            return null;
        }
        Object value = params.get("drawLimit");
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return ((Double)value).intValue();
        }
        return (Integer)value;
    }

    private ForcedDrawTilePack(LinkedHashMap<String, TileGroup> groups, int hiddenUnderHills, Queue<String> drawQueue, Integer drawLimit) {
        super(groups, hiddenUnderHills);
        this.drawQueue = drawQueue;
        this.drawLimit = drawLimit;
    }

    @Override
    public ForcedDrawTilePack setGroups(LinkedHashMap<String, TileGroup> groups) {
        if (this.getGroups() == groups) {
            return this;
        }
        return new ForcedDrawTilePack(groups, this.getHiddenUnderHills(), this.drawQueue, this.drawLimit);
    }

    @Override
    public ForcedDrawTilePack setHiddenUnderHills(int hiddenUnderHills) {
        if (this.getHiddenUnderHills() == hiddenUnderHills) {
            return this;
        }
        return new ForcedDrawTilePack(this.getGroups(), hiddenUnderHills, this.drawQueue, this.drawLimit);
    }

    private ForcedDrawTilePack setDrawList(Queue<String> drawQueue) {
        if (this.drawQueue == drawQueue) {
            return this;
        }
        return new ForcedDrawTilePack(this.getGroups(), this.getHiddenUnderHills(), drawQueue, this.drawLimit);
    }

    private ForcedDrawTilePack setDrawLimit(Integer drawLimit) {
        if (this.drawLimit == drawLimit) {
            return this;
        }
        return new ForcedDrawTilePack(this.getGroups(), this.getHiddenUnderHills(), this.drawQueue, drawLimit);
    }

    @Override
    public Tuple2<Tile, TilePack> drawTile(RandomGenerator random) {
        if (!this.drawQueue.isEmpty()) {
            Tuple2 q = this.drawQueue.dequeue();
            Tuple2<Tile, TilePack> res = this.drawTile((String)q._1);
            return res.map2(_pack -> {
                ForcedDrawTilePack pack = (ForcedDrawTilePack)_pack;
                return pack.setDrawList((Queue)q._2);
            });
        }
        Tuple2<Tile, TilePack> res = super.drawTile(random);
        return this.decreaseTileLimit(res);
    }

    @Override
    public Tuple2<Tile, TilePack> drawTile(String groupName, String tileId) {
        Tuple2<Tile, TilePack> res = super.drawTile(groupName, tileId);
        return this.decreaseTileLimit(res);
    }

    private Tuple2<Tile, TilePack> decreaseTileLimit(Tuple2<Tile, TilePack> res) {
        if (this.drawLimit == null) {
            return res;
        }
        return res.map2(_pack -> {
            ForcedDrawTilePack pack = (ForcedDrawTilePack)_pack;
            return pack.setDrawLimit(pack.drawLimit - 1);
        });
    }

    @Override
    public int totalSize() {
        if (this.drawLimit != null) {
            return this.drawLimit;
        }
        return super.totalSize();
    }

    @Override
    public int size() {
        if (this.drawLimit != null) {
            return this.drawLimit;
        }
        if (!this.drawQueue.isEmpty() && this.drawQueue.last().equals("#END")) {
            return this.drawQueue.size() - 1;
        }
        return super.size();
    }

    @Override
    protected int getInternalSize() {
        return super.size() + this.getHiddenUnderHills();
    }

    public Queue<String> getDrawQueue() {
        return this.drawQueue;
    }
}

