/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.debug;

import com.jcloisterzone.board.Edge;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.feature.CompletableFeature;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.game.state.GameState;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.Seq;

public class GameStateDumper {
    public static void dumpFeatures(GameState state) {
        System.out.println("----- features < " + System.identityHashCode(state));
        Seq<Feature> features = state.getFeatureMap().values().distinct().sortBy(f -> f.getClass().getSimpleName());
        for (Feature f2 : features) {
            System.out.println(f2.toString() + " (" + System.identityHashCode(f2) + ")");
            LinearSeq places = state.getFeatureMap().filter((fp, _f) -> f2 == _f).keySet().toList().sortBy(fp -> fp.getPosition());
            System.out.println(" - places:");
            for (FeaturePointer fp2 : places) {
                System.out.println("   - " + fp2.toString());
            }
            if (!(f2 instanceof CompletableFeature)) continue;
            System.out.println(" - open edges:");
            for (Edge edge : ((CompletableFeature)f2).getOpenEdges()) {
                System.out.println("   - " + edge.toString());
            }
        }
        System.out.println("--------------------");
    }
}

