/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.event;

import com.jcloisterzone.event.Event;
import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.game.state.GameState;
import io.vavr.collection.Queue;
import io.vavr.collection.Stream;

public class GameChangedEvent
extends Event {
    private final GameState prev;
    private final GameState curr;
    private transient Queue<PlayEvent> newEvents;
    private transient Queue<PlayEvent> removedEvents;

    public GameChangedEvent(GameState prev, GameState curr) {
        this.prev = prev;
        this.curr = curr;
    }

    public GameState getCurrentState() {
        return this.curr;
    }

    public GameState getPrevState() {
        return this.prev;
    }

    public Queue<PlayEvent> getNewPlayEvents() {
        if (this.newEvents == null) {
            this.newEvents = this.prev == null || this.prev.getEvents() == null ? this.curr.getEvents() : (Queue)this.curr.getEvents().removeAll(this.prev.getEvents());
        }
        return this.newEvents;
    }

    public Queue<PlayEvent> getRemovedPlayEvents() {
        if (this.removedEvents == null) {
            this.removedEvents = this.prev == null || this.prev.getEvents() == null ? Queue.empty() : (Queue)this.prev.getEvents().removeAll(this.curr.getEvents());
        }
        return this.removedEvents;
    }

    public Stream<PlayEvent> getPlayEventsSymmetricDifference() {
        return Stream.concat(this.getNewPlayEvents(), this.getRemovedPlayEvents());
    }

    public boolean hasPlacedTilesChanged() {
        return this.prev.getPlacedTiles() != this.curr.getPlacedTiles();
    }

    public boolean hasTilePackChanged() {
        return this.prev.getTilePack() != this.curr.getTilePack();
    }

    public boolean hasPlayerActionsChanged() {
        return this.prev.getPlayerActions() != this.curr.getPlayerActions();
    }

    public boolean hasTurnPlayerChanged() {
        return !this.prev.getTurnPlayer().equals(this.curr.getTurnPlayer());
    }

    public boolean hasDiscardedTilesChanged() {
        return this.prev.getDiscardedTiles() != this.curr.getDiscardedTiles();
    }

    public boolean hasMeeplesChanged() {
        return this.prev.getDeployedMeeples() != this.curr.getDeployedMeeples();
    }

    public boolean hasNeutralFiguresChanged() {
        return this.prev.getNeutralFigures().getDeployedNeutralFigures() != this.curr.getNeutralFigures().getDeployedNeutralFigures();
    }
}

