/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.event.play;

import com.jcloisterzone.Player;
import com.jcloisterzone.game.state.GameState;
import java.io.Serializable;

public abstract class PlayEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final PlayEventMeta metadata;

    public PlayEvent(PlayEventMeta metadata) {
        this.metadata = metadata;
    }

    public PlayEventMeta getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class PlayEventMeta
    implements Serializable {
        private final long time;
        private final Integer triggeringPlayerIndex;

        public PlayEventMeta(long time, Integer triggeringPlayerIndex) {
            this.time = time;
            this.triggeringPlayerIndex = triggeringPlayerIndex;
        }

        public static PlayEventMeta createWithActivePlayer(GameState state) {
            Player p = state.getActivePlayer();
            return PlayEventMeta.createWithPlayer(p);
        }

        public static PlayEventMeta createWithoutPlayer() {
            return PlayEventMeta.createWithPlayer(null);
        }

        public static PlayEventMeta createWithPlayer(Player p) {
            return new PlayEventMeta(System.currentTimeMillis(), p == null ? null : Integer.valueOf(p.getIndex()));
        }

        public long getTime() {
            return this.time;
        }

        public Integer getTriggeringPlayerIndex() {
            return this.triggeringPlayerIndex;
        }
    }
}

