/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.event.play;

import com.jcloisterzone.Player;
import com.jcloisterzone.PointCategory;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.pointer.BoardPointer;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.figure.Meeple;
import io.vavr.collection.List;

public class ScoreEvent
extends PlayEvent {
    private static final long serialVersionUID = 1L;
    private final int points;
    private final String label;
    private final PointCategory category;
    private final boolean isFinal;
    private final BoardPointer pointer;
    private final Meeple meeple;
    private final Player receiver;
    private final List<Position> source;

    public ScoreEvent(int points, String label, PointCategory category, boolean isFinal, BoardPointer pointer, Meeple meeple, Player receiver, List<Position> source) {
        super(PlayEvent.PlayEventMeta.createWithoutPlayer());
        this.points = points;
        this.category = category;
        this.label = label;
        this.isFinal = isFinal;
        this.pointer = pointer;
        this.meeple = meeple;
        this.receiver = receiver;
        this.source = source;
    }

    public ScoreEvent(int points, PointCategory category, boolean isFinal, FeaturePointer fp, Meeple meeple) {
        this(points, points + "", category, isFinal, fp, meeple, meeple.getPlayer(), null);
    }

    public ScoreEvent(int points, String label, PointCategory category, boolean isFinal, FeaturePointer fp, Meeple meeple) {
        this(points, label, category, isFinal, fp, meeple, meeple.getPlayer(), null);
    }

    public ScoreEvent(int points, String label, PointCategory category, boolean isFinal, Position position, Player receiver) {
        this(points, label, category, isFinal, position, null, receiver, null);
    }

    public FeaturePointer getFeaturePointer() {
        return this.pointer instanceof FeaturePointer ? (FeaturePointer)this.pointer : null;
    }

    public Position getPosition() {
        return this.pointer.getPosition();
    }

    public int getPoints() {
        return this.points;
    }

    public String getLabel() {
        return this.label == null ? this.points + "" : this.label;
    }

    public Meeple getMeeple() {
        return this.meeple;
    }

    public PointCategory getCategory() {
        return this.category;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public Player getReceiver() {
        return this.receiver;
    }

    public List<Position> getSource() {
        return this.source;
    }

    public ScoreEvent setSource(List<Position> source) {
        if (source == this.source) {
            return this;
        }
        return new ScoreEvent(this.points, this.label, this.category, this.isFinal, this.pointer, this.meeple, this.receiver, source);
    }

    @Override
    public String toString() {
        return "ScoreEvent(  " + this.pointer + ", " + this.points + ")";
    }
}

