/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.feature;

import com.jcloisterzone.PointCategory;
import com.jcloisterzone.board.Edge;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.feature.Scoreable;
import com.jcloisterzone.feature.TileFeature;
import com.jcloisterzone.ui.I18nUtils;
import io.vavr.collection.HashSet;
import io.vavr.collection.List;
import io.vavr.collection.Set;

public class Castle
extends TileFeature
implements Scoreable {
    private static final long serialVersionUID = 1L;

    public Castle(List<FeaturePointer> places) {
        super(places);
        assert (places.size() == 2);
    }

    @Override
    public PointCategory getPointCategory() {
        return PointCategory.CASTLE;
    }

    public Edge getEdge() {
        return new Edge(((FeaturePointer)this.places.get(0)).getPosition(), ((FeaturePointer)this.places.get(1)).getPosition());
    }

    @Override
    public Set<Position> getTilePositions() {
        return HashSet.ofAll(this.places.map(fp -> fp.getPosition()));
    }

    public Set<Position> getVicinity() {
        Position p0 = ((FeaturePointer)this.places.get(0)).getPosition();
        Position p1 = ((FeaturePointer)this.places.get(1)).getPosition();
        Set<Position> vicinity = HashSet.of(p0, p1);
        vicinity = p0.x == p1.x ? vicinity.addAll(List.of(p0.add(Location.W), p0.add(Location.E), p1.add(Location.W), p1.add(Location.E))) : vicinity.addAll(List.of(p0.add(Location.N), p0.add(Location.S), p1.add(Location.N), p1.add(Location.S)));
        assert (vicinity.size() == 6);
        return vicinity;
    }

    public static String name() {
        return I18nUtils._tr("Castle", new Object[0]);
    }

    @Override
    public Feature placeOnBoard(Position pos, Rotation rot) {
        throw new UnsupportedOperationException();
    }
}

