/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.feature;

import com.jcloisterzone.PointCategory;
import com.jcloisterzone.board.Edge;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.ShortEdge;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.feature.CompletableFeature;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.game.Rule;
import com.jcloisterzone.game.capability.TradeGoodsCapability;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.ui.I18nUtils;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.HashSet;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Set;

public class City
extends CompletableFeature<City> {
    private static final long serialVersionUID = 1L;
    private final Set<Tuple2<ShortEdge, FeaturePointer>> multiEdges;
    private final int pennants;
    private final int extraPoints;
    private final Map<TradeGoodsCapability.TradeGoods, Integer> tradeGoods;
    private final boolean besieged;
    private final boolean cathedral;
    private final boolean princess;
    private final boolean castleBase;

    public City(List<FeaturePointer> places, Set<Edge> openEdges, int pennants, int extraPoints) {
        this(places, openEdges, HashSet.empty(), HashSet.empty(), pennants, extraPoints, HashMap.empty(), false, false, false, false);
    }

    public City(List<FeaturePointer> places, Set<Edge> openEdges, Set<FeaturePointer> neighboring, Set<Tuple2<ShortEdge, FeaturePointer>> multiEdges, int pennants, int extraPoints, Map<TradeGoodsCapability.TradeGoods, Integer> tradeGoods, boolean besieged, boolean cathedral, boolean princess, boolean castleBase) {
        super(places, openEdges, neighboring);
        this.multiEdges = multiEdges;
        this.pennants = pennants;
        this.extraPoints = extraPoints;
        this.tradeGoods = tradeGoods;
        this.besieged = besieged;
        this.cathedral = cathedral;
        this.princess = princess;
        this.castleBase = castleBase;
    }

    @Override
    public City merge(City city) {
        assert (city != this);
        return new City(this.mergePlaces(city), this.mergeEdges(city), this.mergeNeighboring(city), this.mergeMultiEdges(city), this.pennants + city.pennants, this.extraPoints + city.extraPoints, this.mergeTradeGoods(city), this.besieged || city.besieged, this.cathedral || city.cathedral, this.princess || city.princess, this.castleBase && city.castleBase);
    }

    @Override
    public City mergeAbbeyEdge(Edge edge) {
        return new City(this.places, this.openEdges.remove(edge), this.neighboring, (Set<Tuple2<ShortEdge, FeaturePointer>>)this.multiEdges.filter(me -> !((ShortEdge)me._1).equals(edge)), this.pennants, this.extraPoints, this.tradeGoods, this.besieged, this.cathedral, this.princess, this.castleBase);
    }

    @Override
    public City setOpenEdges(Set<Edge> openEdges) {
        return new City(this.places, openEdges, this.neighboring, this.multiEdges, this.pennants, this.extraPoints, this.tradeGoods, this.besieged, this.cathedral, this.princess, this.castleBase);
    }

    @Override
    public Feature placeOnBoard(Position pos, Rotation rot) {
        return new City(this.placeOnBoardPlaces(pos, rot), this.placeOnBoardEdges(pos, rot), this.placeOnBoardNeighboring(pos, rot), this.placeOnBoardMultiEdges(pos, rot), this.pennants, this.extraPoints, this.tradeGoods, this.besieged, this.cathedral, this.princess, this.castleBase);
    }

    protected Map<TradeGoodsCapability.TradeGoods, Integer> mergeTradeGoods(City city) {
        return this.tradeGoods.merge(city.tradeGoods, (a, b) -> a + b);
    }

    public City setMultiEdges(Set<Tuple2<ShortEdge, FeaturePointer>> multiEdges) {
        if (this.multiEdges == multiEdges) {
            return this;
        }
        return new City(this.places, this.openEdges, this.neighboring, multiEdges, this.pennants, this.extraPoints, this.tradeGoods, this.besieged, this.cathedral, this.princess, this.castleBase);
    }

    public Set<Tuple2<ShortEdge, FeaturePointer>> getMultiEdges() {
        return this.multiEdges;
    }

    @Override
    public City setNeighboring(Set<FeaturePointer> neighboring) {
        if (this.neighboring == neighboring) {
            return this;
        }
        return new City(this.places, this.openEdges, neighboring, this.multiEdges, this.pennants, this.extraPoints, this.tradeGoods, this.besieged, this.cathedral, this.princess, this.castleBase);
    }

    public boolean isBesieged() {
        return this.besieged;
    }

    public City setBesieged(boolean besieged) {
        if (this.besieged == besieged) {
            return this;
        }
        return new City(this.places, this.openEdges, this.neighboring, this.multiEdges, this.pennants, this.extraPoints, this.tradeGoods, besieged, this.cathedral, this.princess, this.castleBase);
    }

    public boolean isCathedral() {
        return this.cathedral;
    }

    public City setCathedral(boolean cathedral) {
        if (this.cathedral == cathedral) {
            return this;
        }
        return new City(this.places, this.openEdges, this.neighboring, this.multiEdges, this.pennants, this.extraPoints, this.tradeGoods, this.besieged, cathedral, this.princess, this.castleBase);
    }

    public boolean isPrincess() {
        return this.princess;
    }

    public City setPrincess(boolean princess) {
        if (this.princess == princess) {
            return this;
        }
        return new City(this.places, this.openEdges, this.neighboring, this.multiEdges, this.pennants, this.extraPoints, this.tradeGoods, this.besieged, this.cathedral, princess, this.castleBase);
    }

    public boolean isCastleBase() {
        return this.castleBase;
    }

    public City setCastleBase(boolean castleBase) {
        if (this.castleBase == castleBase) {
            return this;
        }
        return new City(this.places, this.openEdges, this.neighboring, this.multiEdges, this.pennants, this.extraPoints, this.tradeGoods, this.besieged, this.cathedral, this.princess, castleBase);
    }

    public int getPennants() {
        return this.pennants;
    }

    public int getExtraPoints() {
        return this.extraPoints;
    }

    public Map<TradeGoodsCapability.TradeGoods, Integer> getTradeGoods() {
        return this.tradeGoods;
    }

    public City setTradeGoods(Map<TradeGoodsCapability.TradeGoods, Integer> tradeGoods) {
        return new City(this.places, this.openEdges, this.neighboring, this.multiEdges, this.pennants, this.extraPoints, tradeGoods, this.besieged, this.cathedral, this.princess, this.castleBase);
    }

    private int getBasePoints(GameState state, boolean completed) {
        int tileCount = this.getTilePositions().size();
        int pointsPerUnit = 2;
        if (completed && tileCount == 2 && state.getBooleanValue(Rule.TINY_CITY_2_POINTS)) {
            pointsPerUnit = 1;
        } else if (this.besieged) {
            --pointsPerUnit;
        }
        if (completed) {
            if (this.cathedral) {
                ++pointsPerUnit;
            }
        } else {
            pointsPerUnit = this.cathedral ? 0 : --pointsPerUnit;
        }
        return pointsPerUnit * (tileCount + this.pennants) + this.extraPoints;
    }

    @Override
    public int getStructurePoints(GameState state, boolean completed) {
        return this.getBasePoints(state, completed) + this.getLittleBuildingPoints(state);
    }

    @Override
    public int getPoints(GameState state) {
        int basePoints = this.getBasePoints(state, this.isCompleted(state));
        return this.getMageAndWitchPoints(state, basePoints) + this.getLittleBuildingPoints(state);
    }

    @Override
    public PointCategory getPointCategory() {
        return PointCategory.CITY;
    }

    public static String name() {
        return I18nUtils._tr("City", new Object[0]);
    }

    protected Set<Tuple2<ShortEdge, FeaturePointer>> mergeMultiEdges(City city) {
        return this.multiEdges.addAll(city.multiEdges);
    }

    protected Set<Tuple2<ShortEdge, FeaturePointer>> placeOnBoardMultiEdges(Position pos, Rotation rot) {
        return this.multiEdges.map(t -> {
            ShortEdge edge = ((ShortEdge)t._1).rotateCW(Position.ZERO, rot).translate(pos);
            FeaturePointer fp = ((FeaturePointer)t._2).rotateCW(rot).translate(pos);
            return new Tuple2<ShortEdge, FeaturePointer>(edge, fp);
        });
    }
}

