/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.feature;

import com.jcloisterzone.PointCategory;
import com.jcloisterzone.board.Edge;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.feature.CompletableFeature;
import com.jcloisterzone.game.capability.FerriesCapability;
import com.jcloisterzone.game.capability.FerriesCapabilityModel;
import com.jcloisterzone.game.capability.TunnelCapability;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTunnelToken;
import com.jcloisterzone.ui.I18nUtils;
import io.vavr.Tuple2;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Set;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.function.Function;

public class Road
extends CompletableFeature<Road> {
    private static final long serialVersionUID = 1L;
    private final boolean inn;
    private final boolean labyrinth;
    private final Set<FeaturePointer> openTunnelEnds;

    public Road(List<FeaturePointer> places, Set<Edge> openEdges) {
        this(places, openEdges, io.vavr.collection.HashSet.empty(), false, false, io.vavr.collection.HashSet.empty());
    }

    public Road(List<FeaturePointer> places, Set<Edge> openEdges, Set<FeaturePointer> neighboring, boolean inn, boolean labyrinth, Set<FeaturePointer> openTunnelEnds) {
        super(places, openEdges, neighboring);
        this.inn = inn;
        this.labyrinth = labyrinth;
        this.openTunnelEnds = openTunnelEnds;
    }

    @Override
    public boolean isOpen(GameState state) {
        return super.isOpen(state) || !this.openTunnelEnds.isEmpty();
    }

    @Override
    public Road merge(Road road) {
        assert (road != this);
        return new Road(this.mergePlaces(road), this.mergeEdges(road), this.mergeNeighboring(road), this.inn || road.inn, this.labyrinth || road.labyrinth, this.mergeTunnelEnds(road));
    }

    @Override
    public Road mergeAbbeyEdge(Edge edge) {
        return new Road(this.places, this.openEdges.remove(edge), this.neighboring, this.inn, this.labyrinth, this.openTunnelEnds);
    }

    @Override
    public Road setOpenEdges(Set<Edge> openEdges) {
        return new Road(this.places, openEdges, this.neighboring, this.inn, this.labyrinth, this.openTunnelEnds);
    }

    public Road connectTunnels(Road road, FeaturePointer tunnelEnd1, FeaturePointer tunnelEnd2) {
        Road merged = this == road ? this : this.merge(road);
        return merged.setOpenTunnelEnds(merged.openTunnelEnds.remove(tunnelEnd1).remove(tunnelEnd2));
    }

    @Override
    public Road placeOnBoard(Position pos, Rotation rot) {
        return new Road(this.placeOnBoardPlaces(pos, rot), this.placeOnBoardEdges(pos, rot), this.placeOnBoardNeighboring(pos, rot), this.inn, this.labyrinth, this.placeOnBoardTunnelEnds(pos, rot));
    }

    public boolean isInn() {
        return this.inn;
    }

    public Road setInn(boolean inn) {
        if (this.inn == inn) {
            return this;
        }
        return new Road(this.places, this.openEdges, this.neighboring, inn, this.labyrinth, this.openTunnelEnds);
    }

    public boolean isLabyrinth() {
        return this.labyrinth;
    }

    public Road setLabyrinth(boolean labyrinth) {
        if (this.labyrinth == labyrinth) {
            return this;
        }
        return new Road(this.places, this.openEdges, this.neighboring, this.inn, labyrinth, this.openTunnelEnds);
    }

    public Set<FeaturePointer> getOpenTunnelEnds() {
        return this.openTunnelEnds;
    }

    public Road setOpenTunnelEnds(Set<FeaturePointer> openTunnelEnds) {
        if (this.openTunnelEnds == openTunnelEnds) {
            return this;
        }
        return new Road(this.places, this.openEdges, this.neighboring, this.inn, this.labyrinth, openTunnelEnds);
    }

    @Override
    public Road setNeighboring(Set<FeaturePointer> neighboring) {
        if (this.neighboring == neighboring) {
            return this;
        }
        return new Road(this.places, this.openEdges, neighboring, this.inn, this.labyrinth, this.openTunnelEnds);
    }

    private int getBasePoints(GameState state, boolean completed) {
        int points;
        int tileCount = this.getTilePositions().size();
        if (this.inn && !completed) {
            return 0;
        }
        int n = points = this.inn ? tileCount * 2 : tileCount;
        if (this.labyrinth && completed) {
            points += 2 * this.getMeeples(state).size();
        }
        return points;
    }

    @Override
    public int getPoints(GameState state) {
        int basePoints = this.getBasePoints(state, this.isCompleted(state));
        return this.getMageAndWitchPoints(state, basePoints) + this.getLittleBuildingPoints(state);
    }

    @Override
    public int getStructurePoints(GameState state, boolean completed) {
        return this.getBasePoints(state, completed) + this.getLittleBuildingPoints(state);
    }

    @Override
    public PointCategory getPointCategory() {
        return PointCategory.ROAD;
    }

    public static String name() {
        return I18nUtils._tr("Road", new Object[0]);
    }

    private FeaturePointer findPartOf(Iterable<FeaturePointer> list, FeaturePointer fp) {
        for (FeaturePointer item : list) {
            if (!fp.isPartOf(item)) continue;
            return item;
        }
        return null;
    }

    private void iterateParts(GameState state, FeaturePointer from, Function<FeaturePointer, Boolean> callback) {
        java.util.Set<FeaturePointer> places = this.places.toJavaSet();
        places.remove(from);
        ArrayDeque<FeaturePointer> queue = new ArrayDeque<FeaturePointer>();
        queue.push(from);
        Map placedTunnels = (Map)state.getCapabilityModel(TunnelCapability.class);
        FerriesCapabilityModel ferriesModel = (FerriesCapabilityModel)state.getCapabilityModel(FerriesCapability.class);
        while (!queue.isEmpty()) {
            FeaturePointer ferry;
            FeaturePointer place;
            PlacedTunnelToken placedTunnel;
            FeaturePointer fp = (FeaturePointer)queue.pop();
            if (!callback.apply(fp).booleanValue()) continue;
            for (FeaturePointer adj : fp.getAdjacent(Road.class)) {
                FeaturePointer place2 = this.findPartOf(places, adj);
                if (place2 == null || !places.remove(place2)) continue;
                queue.push(place2);
            }
            if (placedTunnels != null && (placedTunnel = (PlacedTunnelToken)placedTunnels.get(fp).getOrNull()) != null && (place = (FeaturePointer)placedTunnels.find(t -> t._2 != null && t._2 != placedTunnel && ((PlacedTunnelToken)t._2).getToken() == placedTunnel.getToken() && ((PlacedTunnelToken)t._2).getPlayerIndex() == placedTunnel.getPlayerIndex()).map(Tuple2::_1).getOrNull()) != null && places.remove(place)) {
                queue.push(place);
            }
            if (ferriesModel == null || (ferry = (FeaturePointer)ferriesModel.getFerries().find(f -> fp.isPartOf((FeaturePointer)f)).getOrNull()) == null || (place = ferry.setLocation(ferry.getLocation().subtract(fp.getLocation()))) == null || !places.remove(place)) continue;
            queue.push(place);
        }
    }

    public List<FeaturePointer> findNearest(GameState state, FeaturePointer from, Function<FeaturePointer, Boolean> predicate) {
        HashSet result = new HashSet();
        this.iterateParts(state, from, fp -> {
            boolean match = (Boolean)predicate.apply((FeaturePointer)fp);
            if (match) {
                result.add(fp);
                return false;
            }
            return true;
        });
        return List.ofAll(result);
    }

    public List<FeaturePointer> findSegmentBorderedBy(GameState state, FeaturePointer from, Function<FeaturePointer, Boolean> predicate) {
        HashSet result = new HashSet();
        this.iterateParts(state, from, fp -> {
            boolean match = (Boolean)predicate.apply((FeaturePointer)fp);
            if (match) {
                return false;
            }
            result.add(fp);
            return true;
        });
        return List.ofAll(result);
    }

    protected Set<FeaturePointer> mergeTunnelEnds(Road road) {
        return this.openTunnelEnds.union(road.openTunnelEnds);
    }

    protected Set<FeaturePointer> placeOnBoardTunnelEnds(Position pos, Rotation rot) {
        return this.openTunnelEnds.map(fp -> fp.rotateCW(rot).translate(pos));
    }
}

