/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.feature;

import com.jcloisterzone.Player;
import com.jcloisterzone.PointCategory;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.feature.Structure;
import com.jcloisterzone.figure.Follower;
import com.jcloisterzone.game.Rule;
import com.jcloisterzone.game.capability.HillCapability;
import com.jcloisterzone.game.capability.LittleBuildingsCapability;
import com.jcloisterzone.game.state.GameState;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.HashSet;
import io.vavr.collection.Map;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;

public interface Scoreable
extends Structure {
    public PointCategory getPointCategory();

    default public HashMap<Player, Tuple2<Integer, Integer>> getPowers(GameState state) {
        boolean useHillTiebreaker = state.hasCapability(HillCapability.class);
        boolean useOnHillCount = state.getBooleanValue(Rule.ON_HILL_NUMBER_TIEBREAKER);
        return this.getFollowers2(state).foldLeft(HashMap.empty(), (acc, follower2) -> {
            boolean onHill;
            Follower follower = (Follower)follower2._1;
            FeaturePointer fp = (FeaturePointer)follower2._2;
            Player player = follower.getPlayer();
            int power = follower.getPower(state, this);
            Tuple2<Integer, Integer> t = acc.get(player).getOrElse(new Tuple2<Integer, Integer>(0, 0));
            t = t.map1(p -> p + power);
            if (useHillTiebreaker && (onHill = state.getPlacedTile(fp.getPosition()).getTile().hasModifier(HillCapability.HILL))) {
                if (useOnHillCount) {
                    t = t.map2(cnt -> cnt + 1);
                } else if ((Integer)t._2 == 0) {
                    t = t.update2(1);
                }
            }
            return acc.put(player, t);
        });
    }

    default public Set<Player> getOwners(GameState state) {
        HashMap<Player, Tuple2<Integer, Integer>> powers = this.getPowers(state);
        int maxPower = powers.values().map(Tuple2::_1).max().getOrElse(0);
        if (maxPower == 0) {
            return HashSet.empty();
        }
        int maxTiebreaker = powers.values().filter(t -> (Integer)t._1 == maxPower).map(Tuple2::_2).max().getOrElse(0);
        return ((HashMap)powers.filterValues(t -> (Integer)t._1 == maxPower && (Integer)t._2 == maxTiebreaker)).keySet();
    }

    default public Follower getSampleFollower(GameState state, Player player) {
        return (Follower)this.getFollowers(state).find(f -> f.getPlayer().equals(player)).getOrNull();
    }

    default public int getLittleBuildingPoints(GameState state) {
        Map buildings = (Map)state.getCapabilityModel(LittleBuildingsCapability.class);
        if (buildings == null) {
            return 0;
        }
        Set<Position> position = this.getTilePositions();
        Seq<LittleBuildingsCapability.LittleBuilding> buldingsSeq = buildings.filterKeys(pos -> position.contains((Position)pos)).values();
        return LittleBuildingsCapability.getBuildingsPoints(state, buldingsSeq);
    }
}

