/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.feature;

import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.feature.CloisterLike;
import com.jcloisterzone.feature.Completable;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.feature.TileFeature;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.ui.I18nUtils;
import io.vavr.collection.HashSet;
import io.vavr.collection.List;
import io.vavr.collection.Set;

public class YagaHut
extends TileFeature
implements Completable,
CloisterLike {
    private static final long serialVersionUID = 1L;
    private static final List<FeaturePointer> INITIAL_PLACE = List.of(new FeaturePointer(Position.ZERO, Location.CLOISTER));
    protected final Set<FeaturePointer> neighboring;

    public YagaHut() {
        this(INITIAL_PLACE, HashSet.empty());
    }

    public YagaHut(List<FeaturePointer> places, Set<FeaturePointer> neighboring) {
        super(places);
        this.neighboring = neighboring;
    }

    @Override
    public YagaHut setNeighboring(Set<FeaturePointer> neighboring) {
        if (this.neighboring == neighboring) {
            return this;
        }
        return new YagaHut(this.places, neighboring);
    }

    @Override
    public Set<FeaturePointer> getNeighboring() {
        return this.neighboring;
    }

    @Override
    public Feature placeOnBoard(Position pos, Rotation rot) {
        return new YagaHut(this.placeOnBoardPlaces(pos, rot), this.placeOnBoardNeighboring(pos, rot));
    }

    @Override
    public int getPoints(GameState state) {
        Position p = ((FeaturePointer)this.places.get()).getPosition();
        return 9 - state.getAdjacentAndDiagonalTiles2(p).size() + this.getLittleBuildingPoints(state);
    }

    public static String name() {
        return I18nUtils._tr("Yaga's Hut", new Object[0]);
    }

    protected Set<FeaturePointer> placeOnBoardNeighboring(Position pos, Rotation rot) {
        return this.neighboring.map(fp -> fp.rotateCW(rot).translate(pos));
    }
}

