/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.figure;

import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.pointer.BoardPointer;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.feature.Structure;
import com.jcloisterzone.game.state.GameState;
import java.io.Serializable;
import java.util.Objects;

public abstract class Figure<T extends BoardPointer>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String id;

    public Figure(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public abstract T getDeployment(GameState var1);

    public Feature getFeature(GameState state) {
        FeaturePointer fp;
        T at = this.getDeployment(state);
        FeaturePointer featurePointer = fp = at == null ? null : at.asFeaturePointer();
        if (fp == null) {
            return null;
        }
        return (Feature)state.getFeatureMap().get(fp).getOrNull();
    }

    public Location getLocation(GameState state) {
        T at = this.getDeployment(state);
        FeaturePointer fp = at == null ? null : at.asFeaturePointer();
        return fp == null ? null : fp.getLocation();
    }

    public Position getPosition(GameState state) {
        T at = this.getDeployment(state);
        return at == null ? null : at.getPosition();
    }

    public boolean at(GameState state, Position p) {
        return Objects.equals(p, this.getPosition(state));
    }

    public boolean at(GameState state, FeaturePointer fp) {
        T at = this.getDeployment(state);
        return Objects.equals(fp, at == null ? null : at.asFeaturePointer());
    }

    public abstract boolean at(GameState var1, Structure var2);

    public boolean isDeployed(GameState state) {
        return this.getDeployment(state) != null;
    }

    public boolean isInSupply(GameState state) {
        return !this.isDeployed(state);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Figure)) {
            return false;
        }
        return this.id.equals(((Figure)obj).id);
    }

    public String toString() {
        return this.id;
    }
}

