/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game;

import com.jcloisterzone.Player;
import com.jcloisterzone.board.PlacementOption;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.RemoveTileException;
import com.jcloisterzone.board.Tile;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.feature.Scoreable;
import com.jcloisterzone.figure.Follower;
import com.jcloisterzone.figure.MeepleIdProvider;
import com.jcloisterzone.figure.Special;
import com.jcloisterzone.game.BonusPoints;
import com.jcloisterzone.game.ScoreFeatureReducer;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.plugin.Plugin;
import com.jcloisterzone.ui.Client;
import io.vavr.collection.HashMap;
import io.vavr.collection.List;
import io.vavr.collection.Set;
import io.vavr.collection.Vector;
import java.io.Serializable;
import java.util.function.Function;
import org.w3c.dom.Element;

public abstract class Capability<T>
implements Serializable {
    private Class<? extends Capability<T>> narrowClass() {
        return this.getClass();
    }

    public final T getModel(GameState state) {
        return state.getCapabilityModel(this.narrowClass());
    }

    public final GameState updateModel(GameState state, Function<T, T> fn) {
        return state.mapCapabilityModel(this.narrowClass(), fn);
    }

    public final GameState setModel(GameState state, T model) {
        return state.setCapabilityModel(this.narrowClass(), model);
    }

    public Tile initTile(GameState state, Tile tile, Vector<Element> tileElements) throws RemoveTileException {
        return tile;
    }

    public Feature initFeature(GameState settings, String tileId, Feature feature, Element xml) {
        return feature;
    }

    public String getTileGroup(Tile tile) {
        return null;
    }

    public List<Follower> createPlayerFollowers(Player player, MeepleIdProvider idProvider) {
        return List.empty();
    }

    public List<Special> createPlayerSpecialMeeples(Player player, MeepleIdProvider idProvider) {
        return List.empty();
    }

    @Deprecated
    public Set<FeaturePointer> extendFollowOptions(Set<FeaturePointer> locations) {
        return locations;
    }

    public GameState onStartGame(GameState state) {
        return state;
    }

    public GameState onTilePlaced(GameState state, PlacedTile placedTile) {
        return state;
    }

    public List<BonusPoints> appendBonusPoints(GameState state, List<BonusPoints> bonusPoints, Scoreable feature, boolean isFinal) {
        return bonusPoints;
    }

    public GameState onTurnScoring(GameState state, HashMap<Scoreable, ScoreFeatureReducer> completed) {
        return state;
    }

    public GameState onActionPhaseEntered(GameState state) {
        return state;
    }

    public GameState onTurnCleanUp(GameState state) {
        return state;
    }

    public GameState onTurnPartCleanUp(GameState state) {
        return state;
    }

    public GameState onFinalScoring(GameState state) {
        return state;
    }

    public boolean isTilePlacementAllowed(GameState state, Tile tile, PlacementOption placement) {
        return true;
    }

    public boolean isMeepleDeploymentAllowed(GameState state, Position pos) {
        return true;
    }

    public String toString() {
        return Capability.nameForClass(this.getClass());
    }

    public static Class<? extends Capability<?>> classForName(String name) throws ClassNotFoundException {
        ClassLoader defaultLoader = Capability.class.getClassLoader();
        try {
            return Capability.classForName(name, defaultLoader);
        }
        catch (ClassNotFoundException ex) {
            for (Plugin p : Client.getInstance().getPlugins()) {
                if (!p.isEnabled() || p.getLoader().equals(defaultLoader)) continue;
                try {
                    return Capability.classForName(name, p.getLoader());
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            throw ex;
        }
    }

    public static Class<? extends Capability<?>> classForName(String name, ClassLoader classLoader) throws ClassNotFoundException {
        String clsName = "com.jcloisterzone.game.capability." + name + "Capability";
        return Class.forName(clsName, true, classLoader);
    }

    public static String nameForClass(Class<? extends Capability<?>> cls) {
        return cls.getSimpleName().replaceAll("Capability$", "");
    }
}

