/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import com.jcloisterzone.game.GameSetup;
import com.jcloisterzone.game.MessageNotHandledException;
import com.jcloisterzone.game.RandomGenerator;
import com.jcloisterzone.game.Rule;
import com.jcloisterzone.game.phase.AbbeyPhase;
import com.jcloisterzone.game.phase.ActionPhase;
import com.jcloisterzone.game.phase.BazaarPhase;
import com.jcloisterzone.game.phase.CastlePhase;
import com.jcloisterzone.game.phase.ChangeFerriesPhase;
import com.jcloisterzone.game.phase.CleanUpTurnPartPhase;
import com.jcloisterzone.game.phase.CleanUpTurnPhase;
import com.jcloisterzone.game.phase.CocCountPhase;
import com.jcloisterzone.game.phase.CocFinalScoringPhase;
import com.jcloisterzone.game.phase.CocFollowerPhase;
import com.jcloisterzone.game.phase.CocScoringPhase;
import com.jcloisterzone.game.phase.CommitAbbeyPassPhase;
import com.jcloisterzone.game.phase.CommitActionPhase;
import com.jcloisterzone.game.phase.CornCirclePhase;
import com.jcloisterzone.game.phase.DragonMovePhase;
import com.jcloisterzone.game.phase.DragonPhase;
import com.jcloisterzone.game.phase.EscapePhase;
import com.jcloisterzone.game.phase.FairyPhase;
import com.jcloisterzone.game.phase.GameOverPhase;
import com.jcloisterzone.game.phase.GoldPiecePhase;
import com.jcloisterzone.game.phase.MageAndWitchPhase;
import com.jcloisterzone.game.phase.PhantomPhase;
import com.jcloisterzone.game.phase.Phase;
import com.jcloisterzone.game.phase.PhaseMessageHandler;
import com.jcloisterzone.game.phase.PlaceFerryPhase;
import com.jcloisterzone.game.phase.RequiredCapability;
import com.jcloisterzone.game.phase.ScoringPhase;
import com.jcloisterzone.game.phase.ShepherdPhase;
import com.jcloisterzone.game.phase.StepResult;
import com.jcloisterzone.game.phase.TilePhase;
import com.jcloisterzone.game.phase.TowerCapturePhase;
import com.jcloisterzone.game.phase.WagonPhase;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.wsio.MessageParser;
import com.jcloisterzone.wsio.message.WsInGameMessage;
import io.vavr.Function2;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameStatePhaseReducer
implements Function2<GameState, WsInGameMessage, GameState> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ClassToInstanceMap<Phase> phases = MutableClassToInstanceMap.create();
    private final Phase firstPhase;
    private final RandomGenerator random;

    public GameStatePhaseReducer(GameSetup setup, long initialSeed) {
        Phase last;
        this.random = new RandomGenerator(initialSeed);
        Phase next = null;
        Phase over = this.addPhase(setup, next, GameOverPhase.class);
        this.addPhase(setup, over, CocFinalScoringPhase.class);
        next = last = this.addPhase(setup, next, CleanUpTurnPhase.class);
        next = this.addPhase(setup, next, BazaarPhase.class);
        next = this.addPhase(setup, next, EscapePhase.class);
        next = this.addPhase(setup, next, CleanUpTurnPartPhase.class);
        next = this.addPhase(setup, next, CornCirclePhase.class);
        if (setup.getBooleanValue(Rule.DRAGON_MOVE_AFTER_SCORING)) {
            this.addPhase(setup, next, DragonMovePhase.class);
            next = this.addPhase(setup, next, DragonPhase.class);
        }
        this.addPhase(setup, next, CocCountPhase.class);
        next = this.addPhase(setup, next, CocFollowerPhase.class);
        next = this.addPhase(setup, next, WagonPhase.class);
        next = this.addPhase(setup, next, ScoringPhase.class);
        next = this.addPhase(setup, next, CocScoringPhase.class);
        next = this.addPhase(setup, next, CommitActionPhase.class);
        next = this.addPhase(setup, next, CastlePhase.class);
        if (!setup.getBooleanValue(Rule.DRAGON_MOVE_AFTER_SCORING)) {
            this.addPhase(setup, next, DragonMovePhase.class);
            next = this.addPhase(setup, next, DragonPhase.class);
        }
        next = this.addPhase(setup, next, ShepherdPhase.class);
        next = this.addPhase(setup, next, ChangeFerriesPhase.class);
        next = this.addPhase(setup, next, PlaceFerryPhase.class);
        next = this.addPhase(setup, next, PhantomPhase.class);
        this.addPhase(setup, next, TowerCapturePhase.class);
        next = this.addPhase(setup, next, ActionPhase.class);
        next = this.addPhase(setup, next, MageAndWitchPhase.class);
        next = this.addPhase(setup, next, GoldPiecePhase.class);
        next = this.addPhase(setup, next, TilePhase.class);
        next = this.addPhase(setup, next, CommitAbbeyPassPhase.class);
        next = this.addPhase(setup, next, AbbeyPhase.class);
        next = this.addPhase(setup, next, FairyPhase.class);
        last.setDefaultNext(next);
        this.firstPhase = next;
    }

    private Phase addPhase(GameSetup setup, Phase next, Class<? extends Phase> phaseClass) {
        Phase phase;
        RequiredCapability req = phaseClass.getAnnotation(RequiredCapability.class);
        if (req != null && !setup.getCapabilities().contains(req.value())) {
            return next;
        }
        try {
            phase = phaseClass.getConstructor(RandomGenerator.class).newInstance(this.random);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.phases.put(phaseClass, phase);
        if (next != null) {
            phase.setDefaultNext(next);
        }
        return phase;
    }

    private StepResult applyMessageOnPhase(Phase phase, GameState state, WsInGameMessage message) {
        for (Method m : phase.getClass().getMethods()) {
            if (m.getAnnotation(PhaseMessageHandler.class) == null) continue;
            Class<?>[] params = m.getParameterTypes();
            assert (params.length == 2);
            Class<?> acceptedMessageClass = params[1];
            if (!acceptedMessageClass.equals(message.getClass())) continue;
            try {
                assert (m.getReturnType().equals(StepResult.class)) : String.format("Bad return type %s.%s()", phase.getClass().getSimpleName(), m.getName());
                return (StepResult)m.invoke((Object)phase, state, message);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e.getCause() == null ? e : e.getCause());
            }
        }
        MessageParser parser = new MessageParser();
        this.logger.warn("Unhandled message:\n\t" + parser.toJson(message));
        throw new MessageNotHandledException(String.format("Message %s hasn't been handled by %s phase.", message.getClass().getSimpleName(), phase));
    }

    public GameState applyStepResult(StepResult stepResult) {
        GameState state = stepResult.getState();
        while (stepResult.getNext() != null) {
            stepResult = this.getPhase(stepResult.getNext()).enter(state);
            state = stepResult.getState();
        }
        return state;
    }

    @Override
    public GameState apply(GameState state, WsInGameMessage message) {
        Phase phase = this.getPhase(state.getPhase());
        StepResult stepResult = this.applyMessageOnPhase(phase, state, message);
        return this.applyStepResult(stepResult);
    }

    public Phase getFirstPhase() {
        return this.firstPhase;
    }

    public Phase getPhase(Class<? extends Phase> cls) {
        return (Phase)this.phases.get(cls);
    }

    public RandomGenerator getRandom() {
        return this.random;
    }
}

