/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game;

import com.jcloisterzone.ui.PlayerColors;
import java.io.Serializable;

public class PlayerSlot
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int COUNT = 6;
    private final int number;
    private Integer serial;
    private String sessionId;
    private String clientId;
    private String nickname;
    private SlotState state = SlotState.OPEN;
    private String aiClassName;
    private transient PlayerColors colors;

    public PlayerSlot(int number) {
        this.number = number;
    }

    public boolean isOccupied() {
        return this.state != SlotState.OPEN;
    }

    public boolean isAi() {
        return this.aiClassName != null;
    }

    public boolean isOwn() {
        return this.state == SlotState.OWN;
    }

    public int getNumber() {
        return this.number;
    }

    public Integer getSerial() {
        return this.serial;
    }

    public void setSerial(Integer serial) {
        this.serial = serial;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public SlotState getState() {
        return this.state;
    }

    public void setState(SlotState state) {
        this.state = state;
    }

    public String getAiClassName() {
        return this.aiClassName;
    }

    public void setAiClassName(String aiClassName) {
        this.aiClassName = aiClassName;
    }

    public PlayerColors getColors() {
        return this.colors;
    }

    public void setColors(PlayerColors colors) {
        this.colors = colors;
    }

    public String toString() {
        return "(" + this.number + ") " + (Object)((Object)this.state) + (this.nickname == null ? "" : " " + this.nickname);
    }

    public boolean isDisconnected() {
        return this.sessionId == null;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public static enum SlotState {
        OPEN,
        OWN,
        REMOTE;

    }
}

