/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game;

import com.jcloisterzone.Expansion;
import com.jcloisterzone.ui.I18nUtils;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;

public enum Rule {
    RANDOM_SEATING_ORDER(null, Boolean.class, I18nUtils._tr("Randomize seating order", new Object[0])),
    FARMERS(Expansion.BASIC, Boolean.class, I18nUtils._tr("Play farmers", new Object[0])),
    USE_PIG_HERDS_INDEPENDENTLY(Expansion.BASIC, Boolean.class, I18nUtils._tr("Use pig herds independently (without T&B expansion)", new Object[0])),
    PRINCESS_MUST_REMOVE_KNIGHT(Expansion.PRINCESS_AND_DRAGON, Boolean.class, I18nUtils._tr("Princess MUST remove a knight from city.", new Object[0]) + " (RGG, ZMG)"),
    DRAGON_MOVE_AFTER_SCORING(Expansion.PRINCESS_AND_DRAGON, Boolean.class, I18nUtils._tr("Dragon movement occurs after scoring.", new Object[0]) + " (RGG)"),
    FAIRY_ON_TILE(Expansion.PRINCESS_AND_DRAGON, Boolean.class, I18nUtils._tr("Place fairy on the tile. (instead of next to a follower)", new Object[0]) + " (RGG, ZMG)"),
    MULTI_BARN_ALLOWED(Expansion.ABBEY_AND_MAYOR, Boolean.class, I18nUtils._tr("Allow direct barn placement on a farm where another barn is already placed.", new Object[0])),
    BAZAAR_NO_AUCTION(Expansion.BRIDGES_CASTLES_AND_BAZAARS, Boolean.class, I18nUtils._tr("No bazaar bidding. Each player just chooses one tile.", new Object[0])),
    ON_HILL_NUMBER_TIEBREAKER(Expansion.HILLS_AND_SHEEP, Boolean.class, I18nUtils._tr("Count number of followers on hill as tiebreaker.", new Object[0]) + " [house rule]"),
    ESCAPE_RGG(Expansion.CATHARS, Boolean.class, I18nUtils._tr("Escape cloister can be placed adjacent to any tile of a besieged city.", new Object[0]) + " (RGG)"),
    PIG_HERD_ON_GQ_FARM(Expansion.GQ11, Boolean.class, I18nUtils._tr("The Pig herd is present on the farm tile.", new Object[0]) + " [house rule]"),
    TUNNELIZE_ALL_EXPANSIONS(Expansion.TUNNEL, Boolean.class, I18nUtils._tr("Apply tunnel rule on tunnels from other expansions.", new Object[0])),
    MORE_TUNNEL_TOKENS(Expansion.TUNNEL, Boolean.class, I18nUtils._tr("Assign 3/2 tunnel set in game of two/three players.", new Object[0])),
    FESTIVAL_FOLLOWER_ONLY(Expansion.FESTIVAL, Boolean.class, I18nUtils._tr("Only follower can be returned by festival (instead of any figure)", new Object[0]) + " (RGG)"),
    KEEP_CLOISTERS(Expansion.GERMAN_MONASTERIES, Boolean.class, I18nUtils._tr("Keep basic cloisters in the game.", new Object[0])),
    BULDINGS_DIFFERENT_VALUE(Expansion.LITTLE_BUILDINGS, Boolean.class, I18nUtils._tr("Add 3/2/1 points for tower/house/shed.", new Object[0])),
    ADVANCED_LABYRINTH(Expansion.LABYRINTH, Boolean.class, I18nUtils._tr("Advanced labyrinth variant", new Object[0])),
    TINY_CITY_2_POINTS(Expansion.BASIC, Boolean.class, I18nUtils._tr("Tiny city is scored only for 2 points.", new Object[0])),
    CLOCK_PLAYER_TIME(null, Integer.class, null);

    String label;
    Class<?> type;
    Expansion expansion;

    private Rule(Expansion expansion, Class<?> type, String label) {
        this.expansion = expansion;
        this.type = type;
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public Expansion getExpansion() {
        return this.expansion;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Object unpackValue(String value) {
        if (this.type.equals(Boolean.class)) {
            return Boolean.valueOf(value);
        }
        if (this.type.equals(Integer.class)) {
            return Double.valueOf(value).intValue();
        }
        if (this.type.equals(String.class)) {
            return value;
        }
        throw new IllegalArgumentException("Unsupported type");
    }

    public static Map<Rule, Object> getDefaultRules() {
        return HashMap.of(FARMERS, true, PIG_HERD_ON_GQ_FARM, true, TUNNELIZE_ALL_EXPANSIONS, true, MORE_TUNNEL_TOKENS, true, ADVANCED_LABYRINTH, true);
    }
}

