/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.capability;

import com.jcloisterzone.Expansion;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Tile;
import com.jcloisterzone.feature.Cloister;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.Token;
import com.jcloisterzone.game.state.GameState;
import io.vavr.collection.HashMap;

public class AbbeyCapability
extends Capability<Integer> {
    private static final long serialVersionUID = 1L;
    public static final String ABBEY_TILE_ID = "AM.A";
    public static Tile ABBEY_TILE;

    @Override
    public GameState onStartGame(GameState state) {
        return state.mapPlayers(ps -> ps.setTokenCountForAllPlayers(AbbeyToken.ABBEY_TILE, 1));
    }

    public static boolean isAbbey(Tile tile) {
        return tile.getId().equals(ABBEY_TILE_ID);
    }

    static {
        HashMap<Location, Feature> features = HashMap.of(Location.CLOISTER, new Cloister());
        ABBEY_TILE = new Tile(Expansion.ABBEY_AND_MAYOR, ABBEY_TILE_ID, features);
    }

    public static enum AbbeyToken implements Token
    {
        ABBEY_TILE;

    }
}

