/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.capability;

import com.jcloisterzone.Player;
import com.jcloisterzone.game.capability.BazaarItem;
import io.vavr.collection.Queue;
import java.io.Serializable;

public class BazaarCapabilityModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Queue<BazaarItem> supply;
    private final Integer auctionedItemIndex;
    private final Player tileSelectingPlayer;

    public BazaarCapabilityModel() {
        this(null, null, null);
    }

    public BazaarCapabilityModel(Queue<BazaarItem> supply, Integer auctionedItemIndex, Player tileSelectingPlayer) {
        this.supply = supply;
        this.auctionedItemIndex = auctionedItemIndex;
        this.tileSelectingPlayer = tileSelectingPlayer;
    }

    public BazaarCapabilityModel setSupply(Queue<BazaarItem> supply) {
        return new BazaarCapabilityModel(supply, this.auctionedItemIndex, this.tileSelectingPlayer);
    }

    public BazaarCapabilityModel setAuctionedItemIndex(Integer auctionedItemIndex) {
        return new BazaarCapabilityModel(this.supply, auctionedItemIndex, this.tileSelectingPlayer);
    }

    public BazaarCapabilityModel setTileSelectingPlayer(Player tileSelectingPlayer) {
        return new BazaarCapabilityModel(this.supply, this.auctionedItemIndex, tileSelectingPlayer);
    }

    public BazaarCapabilityModel updateSupplyItem(int index, BazaarItem item) {
        return this.setSupply((Queue<BazaarItem>)this.supply.update(index, (Object)item));
    }

    public Queue<BazaarItem> getSupply() {
        return this.supply;
    }

    public Integer getAuctionedItemIndex() {
        return this.auctionedItemIndex;
    }

    public BazaarItem getAuctionedItem() {
        if (this.auctionedItemIndex == null) {
            return null;
        }
        return this.supply.get(this.auctionedItemIndex);
    }

    public Player getTileSelectingPlayer() {
        return this.tileSelectingPlayer;
    }
}

