/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.capability;

import com.jcloisterzone.XMLUtils;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.feature.Castle;
import com.jcloisterzone.feature.City;
import com.jcloisterzone.feature.Completable;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.ScoreFeatureReducer;
import com.jcloisterzone.game.Token;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.reducers.ScoreCastle;
import com.jcloisterzone.reducers.UndeployMeeples;
import io.vavr.Tuple2;
import io.vavr.collection.Array;
import io.vavr.collection.HashMap;
import io.vavr.collection.IndexedSeq;
import io.vavr.collection.Map;
import io.vavr.collection.Set;
import io.vavr.collection.Stream;
import org.w3c.dom.Element;

public class CastleCapability
extends Capability<Void> {
    private static final long serialVersionUID = 1L;

    @Override
    public GameState onStartGame(GameState state) {
        int tokens = state.getPlayers().length() < 5 ? 3 : 2;
        return state.mapPlayers(ps -> ps.setTokenCountForAllPlayers(CastleToken.CASTLE, tokens));
    }

    @Override
    public Feature initFeature(GameState state, String tileId, Feature feature, Element xml) {
        if (feature instanceof City) {
            feature = ((City)feature).setCastleBase(XMLUtils.attributeBoolValue(xml, "castle-base"));
        }
        return feature;
    }

    private Stream<Castle> getOccupiedCastles(GameState state) {
        return state.getFeatures(Castle.class).filter(c -> c.isOccupied(state));
    }

    public Tuple2<GameState, Map<Castle, ScoreFeatureReducer>> scoreCastles(GameState state, HashMap<Completable, ScoreFeatureReducer> completed) {
        java.util.HashMap<Castle, ScoreCastle> scoredCastles = new java.util.HashMap<Castle, ScoreCastle>();
        IndexedSeq scored = Array.ofAll(completed).sortBy(t -> -((ScoreFeatureReducer)t._2).getFeaturePoints());
        Map allScoredCastled = HashMap.empty();
        Position placedThisTurn = state.getLastPlaced().getPosition();
        block0: for (Castle castle : this.getOccupiedCastles(state)) {
            if (castle.getTilePositions().contains(placedThisTurn)) continue;
            Set<Position> vicinity = castle.getVicinity();
            for (Tuple2 t2 : scored) {
                if (vicinity.intersect(((Completable)t2._1).getTilePositions()).isEmpty()) continue;
                ScoreCastle scoreCastle = new ScoreCastle(castle, ((ScoreFeatureReducer)t2._2).getFeaturePoints(), false);
                state = scoreCastle.apply(state);
                state = new UndeployMeeples(castle, false).apply(state);
                scoredCastles.put(castle, scoreCastle);
                continue block0;
            }
        }
        while (!scoredCastles.isEmpty()) {
            HashMap scoredCastlesCpy = HashMap.ofAll(scoredCastles);
            allScoredCastled = allScoredCastled.merge((Map)scoredCastlesCpy);
            scoredCastles.clear();
            block3: for (Castle castle : this.getOccupiedCastles(state)) {
                Set<Position> vicinity = castle.getVicinity();
                for (Tuple2 tuple2 : scoredCastlesCpy) {
                    if (vicinity.intersect(((Castle)tuple2._1).getTilePositions()).isEmpty()) continue;
                    ScoreCastle scoreReducer = new ScoreCastle(castle, ((ScoreFeatureReducer)tuple2._2).getFeaturePoints(), false);
                    state = scoreReducer.apply(state);
                    state = new UndeployMeeples(castle, false).apply(state);
                    scoredCastles.put(castle, scoreReducer);
                    continue block3;
                }
            }
        }
        return new Tuple2<GameState, Map<Castle, ScoreFeatureReducer>>(state, allScoredCastled);
    }

    public static enum CastleToken implements Token
    {
        CASTLE;

    }
}

