/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.capability;

import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.pointer.FeaturePointer;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.HashSet;
import io.vavr.collection.Map;
import io.vavr.collection.Set;
import java.io.Serializable;
import java.util.function.Function;

public class FerriesCapabilityModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<FeaturePointer> ferries;
    private final Map<Position, Tuple2<Location, Location>> movedFerries;

    public FerriesCapabilityModel() {
        this(HashSet.empty(), HashMap.empty());
    }

    public FerriesCapabilityModel(Set<FeaturePointer> ferries, Map<Position, Tuple2<Location, Location>> movedFerries) {
        this.ferries = ferries;
        this.movedFerries = movedFerries;
    }

    public Set<FeaturePointer> getFerries() {
        return this.ferries;
    }

    public Map<Position, Tuple2<Location, Location>> getMovedFerries() {
        return this.movedFerries;
    }

    public FerriesCapabilityModel addFerry(FeaturePointer ferry) {
        return new FerriesCapabilityModel(this.ferries.add(ferry), this.movedFerries);
    }

    public FerriesCapabilityModel setMovedFerries(Map<Position, Tuple2<Location, Location>> movedFerries) {
        if (this.movedFerries == movedFerries) {
            return this;
        }
        return new FerriesCapabilityModel(this.ferries, movedFerries);
    }

    public FerriesCapabilityModel mapMovedFerries(Function<Map<Position, Tuple2<Location, Location>>, Map<Position, Tuple2<Location, Location>>> fn) {
        return this.setMovedFerries(fn.apply(this.movedFerries));
    }
}

