/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.capability;

import com.jcloisterzone.Player;
import com.jcloisterzone.XMLUtils;
import com.jcloisterzone.action.ReturnMeepleAction;
import com.jcloisterzone.board.Tile;
import com.jcloisterzone.board.TileModifier;
import com.jcloisterzone.board.pointer.MeeplePointer;
import com.jcloisterzone.figure.Follower;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.Rule;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.wsio.message.ReturnMeepleMessage;
import io.vavr.Predicates;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.Set;
import io.vavr.collection.Stream;
import io.vavr.collection.Vector;
import org.w3c.dom.Element;

public class FestivalCapability
extends Capability<Void> {
    private static final long serialVersionUID = 1L;
    public static final TileModifier FESTIVAL = new TileModifier("Festival");
    public static final String UNDEPLOY_FESTIVAL = "festival";

    @Override
    public Tile initTile(GameState state, Tile tile, Vector<Element> tileElements) {
        if (!XMLUtils.getElementStreamByTagName(tileElements, UNDEPLOY_FESTIVAL).isEmpty()) {
            tile = tile.addTileModifier(FESTIVAL);
        }
        return tile;
    }

    @Override
    public GameState onActionPhaseEntered(GameState state) {
        Set<MeeplePointer> options;
        PlacedTile placedTile = state.getLastPlaced();
        if (!placedTile.getTile().hasModifier(FESTIVAL)) {
            return state;
        }
        Player player = state.getTurnPlayer();
        LinearSeq meeples = Stream.ofAll(state.getDeployedMeeples()).filter(t -> ((Meeple)t._1).getPlayer().equals(player));
        if (state.getBooleanValue(Rule.FESTIVAL_FOLLOWER_ONLY)) {
            meeples = meeples.filter(Predicates.instanceOf(Follower.class));
        }
        if ((options = meeples.map(MeeplePointer::new).toSet()).isEmpty()) {
            return state;
        }
        return state.appendAction(new ReturnMeepleAction(options, ReturnMeepleMessage.ReturnMeepleSource.FESTIVAL));
    }
}

