/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.capability;

import com.jcloisterzone.Player;
import com.jcloisterzone.XMLUtils;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Tile;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.feature.Completable;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.figure.Follower;
import com.jcloisterzone.figure.MeepleIdProvider;
import com.jcloisterzone.figure.Wagon;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.state.GameState;
import io.vavr.Tuple2;
import io.vavr.collection.Array;
import io.vavr.collection.IndexedSeq;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Queue;
import io.vavr.collection.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WagonCapability
extends Capability<Queue<Tuple2<Wagon, FeaturePointer>>> {
    private static final long serialVersionUID = 1L;

    @Override
    public GameState onStartGame(GameState state) {
        return this.setModel(state, Queue.empty());
    }

    @Override
    public List<Follower> createPlayerFollowers(Player player, MeepleIdProvider idProvider) {
        return List.of(new Wagon(idProvider.generateId(Wagon.class), player));
    }

    @Override
    public Tile initTile(GameState state, Tile tile, Vector<Element> tileElements) {
        for (Element moveEl : XMLUtils.getElementStreamByTagName(tileElements, "wagon-move")) {
            String tileId = tile.getId();
            Map<Location, Feature> features = tile.getInitialFeatures();
            NodeList nl = moveEl.getElementsByTagName("neighbouring");
            for (int i = 0; i < nl.getLength(); ++i) {
                IndexedSeq fps = XMLUtils.contentAsLocations((Element)nl.item(i)).map(l -> new FeaturePointer(Position.ZERO, (Location)l)).toArray();
                Map<Location, Feature> _features = features;
                fps = ((Array)fps).map(fp -> {
                    Location partLoc = fp.getLocation();
                    Tuple2 item = _features.find(t -> partLoc.isPartOf((Location)t._1)).getOrElseThrow(() -> new IllegalStateException(String.format("%s / <wagon-move>: No feature for %s", tileId, partLoc)));
                    return fp.setLocation((Location)item._1);
                });
                for (FeaturePointer fp2 : fps) {
                    Completable feature = (Completable)features.get(fp2.getLocation()).getOrNull();
                    feature = feature.setNeighboring(feature.getNeighboring().addAll(((Array)fps).remove(fp2)));
                    features = features.put(fp2.getLocation(), feature);
                }
            }
            tile = tile.setInitialFeatures(features);
        }
        return tile;
    }

    @Override
    public GameState onTurnPartCleanUp(GameState state) {
        return this.setModel(state, Queue.empty());
    }
}

