/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.phase;

import com.jcloisterzone.Player;
import com.jcloisterzone.action.TilePlacementAction;
import com.jcloisterzone.board.PlacementOption;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.RandomGenerator;
import com.jcloisterzone.game.capability.AbbeyCapability;
import com.jcloisterzone.game.capability.BazaarCapability;
import com.jcloisterzone.game.capability.BazaarCapabilityModel;
import com.jcloisterzone.game.capability.BuilderCapability;
import com.jcloisterzone.game.capability.BuilderState;
import com.jcloisterzone.game.phase.ActionPhase;
import com.jcloisterzone.game.phase.Phase;
import com.jcloisterzone.game.phase.PhaseMessageHandler;
import com.jcloisterzone.game.phase.RequiredCapability;
import com.jcloisterzone.game.phase.StepResult;
import com.jcloisterzone.game.phase.TilePhase;
import com.jcloisterzone.game.state.ActionsState;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.reducers.PlaceTile;
import com.jcloisterzone.wsio.message.PlaceTileMessage;
import io.vavr.collection.Array;
import io.vavr.collection.LinearSeq;
import java.util.Arrays;

@RequiredCapability(value=AbbeyCapability.class)
public class AbbeyPhase
extends Phase {
    public AbbeyPhase(RandomGenerator random) {
        super(random);
    }

    @Override
    public StepResult enter(GameState state) {
        boolean hasAbbey;
        BazaarCapabilityModel bazaarModel = (BazaarCapabilityModel)state.getCapabilityModel(BazaarCapability.class);
        BuilderState builderState = (BuilderState)((Object)state.getCapabilityModel(BuilderCapability.class));
        boolean baazaarInProgress = bazaarModel != null && bazaarModel.getSupply() != null;
        boolean builderSecondTurnPart = builderState == BuilderState.SECOND_TURN;
        boolean bl = hasAbbey = state.getPlayers().getPlayerTokenCount(state.getPlayers().getTurnPlayerIndex(), AbbeyCapability.AbbeyToken.ABBEY_TILE) > 0;
        if (hasAbbey && (builderSecondTurnPart || !baazaarInProgress)) {
            GameState _state = state;
            LinearSeq options = state.getHoles().flatMap(t -> Array.ofAll(Arrays.asList(Rotation.values())).map(r -> new PlacementOption((Position)t._1, (Rotation)((Object)((Object)r)), null))).filter(tp -> {
                for (Capability capability : _state.getCapabilities().toSeq()) {
                    if (capability.isTilePlacementAllowed(_state, AbbeyCapability.ABBEY_TILE, (PlacementOption)tp)) continue;
                    return false;
                }
                return true;
            });
            if (!options.isEmpty()) {
                TilePlacementAction action = new TilePlacementAction(AbbeyCapability.ABBEY_TILE, options.toSet());
                state = state.setPlayerActions(new ActionsState(state.getTurnPlayer(), action, true));
                return this.promote(state);
            }
        }
        return this.next(state, TilePhase.class);
    }

    @PhaseMessageHandler
    public StepResult handlePlaceTile(GameState state, PlaceTileMessage msg) {
        if (!msg.getTileId().equals("AM.A")) {
            throw new IllegalArgumentException("Only abbey can be placed.");
        }
        Player player = state.getActivePlayer();
        state = state.mapPlayers(ps -> ps.addTokenCount(player.getIndex(), AbbeyCapability.AbbeyToken.ABBEY_TILE, -1));
        state = new PlaceTile(AbbeyCapability.ABBEY_TILE, msg.getPosition(), msg.getRotation()).apply(state);
        state = this.clearActions(state);
        return this.next(state, ActionPhase.class);
    }
}

