/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.phase;

import com.jcloisterzone.Player;
import com.jcloisterzone.action.PlayerAction;
import com.jcloisterzone.action.PrincessAction;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.pointer.BoardPointer;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.board.pointer.MeeplePointer;
import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.event.play.TokenPlacedEvent;
import com.jcloisterzone.feature.Tower;
import com.jcloisterzone.figure.BigFollower;
import com.jcloisterzone.figure.Builder;
import com.jcloisterzone.figure.Mayor;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.figure.Phantom;
import com.jcloisterzone.figure.Pig;
import com.jcloisterzone.figure.Shepherd;
import com.jcloisterzone.figure.SmallFollower;
import com.jcloisterzone.figure.Wagon;
import com.jcloisterzone.figure.neutral.Fairy;
import com.jcloisterzone.figure.neutral.NeutralFigure;
import com.jcloisterzone.game.Capability;
import com.jcloisterzone.game.RandomGenerator;
import com.jcloisterzone.game.Rule;
import com.jcloisterzone.game.Token;
import com.jcloisterzone.game.capability.BridgeCapability;
import com.jcloisterzone.game.capability.FestivalCapability;
import com.jcloisterzone.game.capability.LittleBuildingsCapability;
import com.jcloisterzone.game.capability.PrincessCapability;
import com.jcloisterzone.game.capability.TowerCapability;
import com.jcloisterzone.game.capability.TunnelCapability;
import com.jcloisterzone.game.phase.AbstractActionPhase;
import com.jcloisterzone.game.phase.PhaseMessageHandler;
import com.jcloisterzone.game.phase.StepResult;
import com.jcloisterzone.game.phase.TowerCapturePhase;
import com.jcloisterzone.game.state.ActionsState;
import com.jcloisterzone.game.state.Flag;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.reducers.MoveNeutralFigure;
import com.jcloisterzone.reducers.PlaceBridge;
import com.jcloisterzone.reducers.PlaceLittleBuilding;
import com.jcloisterzone.reducers.PlaceTunnel;
import com.jcloisterzone.reducers.UndeployMeeple;
import com.jcloisterzone.wsio.message.MoveNeutralFigureMessage;
import com.jcloisterzone.wsio.message.PlaceTokenMessage;
import com.jcloisterzone.wsio.message.ReturnMeepleMessage;
import io.vavr.Predicates;
import io.vavr.collection.Vector;

public class ActionPhase
extends AbstractActionPhase {
    public ActionPhase(RandomGenerator random) {
        super(random);
    }

    @Override
    public StepResult enter(GameState state) {
        PrincessAction princessAction;
        Player player = state.getTurnPlayer();
        Vector<Class<? extends Meeple>> meepleTypes = Vector.of(SmallFollower.class, BigFollower.class, Phantom.class, Wagon.class, Mayor.class, Builder.class, Pig.class, Shepherd.class);
        Vector<PlayerAction<?>> actions = this.prepareMeepleActions(state, meepleTypes);
        GameState nextState = state.setPlayerActions(new ActionsState(player, actions, true));
        for (Capability capability : nextState.getCapabilities().toSeq()) {
            nextState = capability.onActionPhaseEntered(nextState);
        }
        if (state.getCapabilities().contains(PrincessCapability.class) && state.getBooleanValue(Rule.PRINCESS_MUST_REMOVE_KNIGHT) && (princessAction = (PrincessAction)actions.find(a -> a instanceof PrincessAction).getOrNull()) != null) {
            actions = Vector.of(princessAction);
        }
        return this.promote(nextState);
    }

    @PhaseMessageHandler
    public StepResult handleMoveNeutralFigure(GameState state, MoveNeutralFigureMessage msg) {
        BoardPointer ptr = msg.getTo();
        NeutralFigure<?> fig = state.getNeutralFigures().getById(msg.getFigureId());
        if (fig instanceof Fairy) {
            assert ((state.getBooleanValue(Rule.FAIRY_ON_TILE) ? Position.class : BoardPointer.class).isInstance(ptr));
            Fairy fairy = (Fairy)fig;
            state = new MoveNeutralFigure<BoardPointer>(fairy, ptr, state.getActivePlayer()).apply(state);
            state = this.clearActions(state);
            return this.next(state);
        }
        throw new IllegalArgumentException("Illegal neutral figure move");
    }

    @PhaseMessageHandler
    public StepResult handleReturnMeeple(GameState state, ReturnMeepleMessage msg) {
        MeeplePointer ptr = msg.getPointer();
        Meeple meeple = (Meeple)state.getDeployedMeeples().find(m -> ptr.match((Meeple)m._1)).map(t -> (Meeple)t._1).getOrElseThrow(() -> new IllegalArgumentException("Pointer doesn't match any meeple"));
        switch (msg.getSource()) {
            case PRINCESS: {
                PrincessAction princessAction = state.getPlayerActions().getActions().find(Predicates.instanceOf(PrincessAction.class)).getOrElseThrow(() -> new IllegalArgumentException("Return meeple is not allowed"));
                if (princessAction.getOptions().contains(ptr)) {
                    state = state.addFlag(Flag.PRINCESS_USED);
                    break;
                }
                throw new IllegalArgumentException("Pointer doesn't match princess action");
            }
            case FESTIVAL: {
                if (state.getLastPlaced().getTile().hasModifier(FestivalCapability.FESTIVAL)) break;
                throw new IllegalArgumentException("Festival return is not allowed");
            }
            default: {
                throw new IllegalArgumentException("Return meeple is not allowed");
            }
        }
        state = new UndeployMeeple(meeple, true).apply(state);
        state = this.clearActions(state);
        return this.next(state);
    }

    private StepResult handlePlaceTower(GameState state, PlaceTokenMessage msg) {
        FeaturePointer ptr = (FeaturePointer)msg.getPointer();
        Tower tower = (Tower)state.getFeatureMap().get(ptr).getOrElseThrow(() -> new IllegalArgumentException("No tower"));
        tower = tower.increaseHeight();
        state = state.setFeatureMap(state.getFeatureMap().put(ptr, tower));
        state = state.appendEvent(new TokenPlacedEvent(PlayEvent.PlayEventMeta.createWithActivePlayer(state), TowerCapability.TowerToken.TOWER_PIECE, ptr));
        state = this.clearActions(state);
        return this.next(state, TowerCapturePhase.class);
    }

    private StepResult handlePlaceBridge(GameState state, PlaceTokenMessage msg) {
        FeaturePointer ptr = (FeaturePointer)msg.getPointer();
        state = new PlaceBridge(ptr).apply(state);
        state = this.clearActions(state);
        return this.enter(state);
    }

    private StepResult handlePlaceTunnel(GameState state, PlaceTokenMessage msg) {
        TunnelCapability.Tunnel token = (TunnelCapability.Tunnel)msg.getToken();
        FeaturePointer ptr = (FeaturePointer)msg.getPointer();
        state = new PlaceTunnel(token, ptr).apply(state);
        state = this.clearActions(state);
        return this.enter(state);
    }

    private StepResult handlePlaceLittleBuilding(GameState state, PlaceTokenMessage msg) {
        LittleBuildingsCapability.LittleBuilding token = (LittleBuildingsCapability.LittleBuilding)msg.getToken();
        Position pos = (Position)msg.getPointer();
        state = new PlaceLittleBuilding(token, pos).apply(state);
        state = this.clearActions(state);
        return this.next(state);
    }

    @PhaseMessageHandler
    public StepResult handlePlaceToken(GameState state, PlaceTokenMessage msg) {
        Player player = state.getActivePlayer();
        Token token = msg.getToken();
        state = state.mapPlayers(ps -> ps.addTokenCount(player.getIndex(), token, -1));
        if (token instanceof TunnelCapability.Tunnel) {
            return this.handlePlaceTunnel(state, msg);
        }
        if (token instanceof LittleBuildingsCapability.LittleBuilding) {
            return this.handlePlaceLittleBuilding(state, msg);
        }
        if (token instanceof TowerCapability.TowerToken) {
            return this.handlePlaceTower(state, msg);
        }
        if (token instanceof BridgeCapability.BrigeToken) {
            return this.handlePlaceBridge(state, msg);
        }
        throw new IllegalArgumentException(String.format("%s placement is not allowed", token));
    }
}

