/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.phase;

import com.jcloisterzone.action.FerriesAction;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.feature.Road;
import com.jcloisterzone.game.RandomGenerator;
import com.jcloisterzone.game.Token;
import com.jcloisterzone.game.capability.FerriesCapability;
import com.jcloisterzone.game.capability.FerriesCapabilityModel;
import com.jcloisterzone.game.phase.Phase;
import com.jcloisterzone.game.phase.PhaseMessageHandler;
import com.jcloisterzone.game.phase.RequiredCapability;
import com.jcloisterzone.game.phase.StepResult;
import com.jcloisterzone.game.state.ActionsState;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.reducers.ChangeFerry;
import com.jcloisterzone.wsio.message.PlaceTokenMessage;
import io.vavr.Tuple2;
import io.vavr.collection.Set;
import io.vavr.collection.Traversable;

@RequiredCapability(value=FerriesCapability.class)
public class ChangeFerriesPhase
extends Phase {
    public ChangeFerriesPhase(RandomGenerator random) {
        super(random);
    }

    @Override
    public StepResult enter(GameState state) {
        PlacedTile lastPlaced = state.getLastPlaced();
        Position pos = lastPlaced.getPosition();
        FerriesCapabilityModel model = (FerriesCapabilityModel)state.getCapabilityModel(FerriesCapability.class);
        Traversable ferries = model.getFerries().filter(f -> !f.getPosition().equals(pos));
        Set<FeaturePointer> options = state.getTileFeatures2(pos, Road.class).flatMap(arg_0 -> ChangeFerriesPhase.lambda$enter$3(state, pos, (Set)ferries, arg_0)).distinct().filter(ferry -> !model.getMovedFerries().containsKey(ferry.getPosition())).flatMap(ferry -> {
            Position ferryPos = ferry.getPosition();
            PlacedTile ferryTile = state.getPlacedTile(ferryPos);
            return ferryTile.getTile().getInitialFeatures().filter(t -> t._2 instanceof Road).map(Tuple2::_1).combinations(2).map(pair -> pair.reduce(Location::union)).map(loc -> loc.rotateCW(ferryTile.getRotation())).filter(loc -> loc != ferry.getLocation()).map(loc -> new FeaturePointer(ferryPos, (Location)loc)).toList();
        }).toSet();
        if (options.isEmpty()) {
            return this.next(state);
        }
        return this.promote(state.setPlayerActions(new ActionsState(state.getTurnPlayer(), new FerriesAction(options), true)));
    }

    @PhaseMessageHandler
    public StepResult handlePlaceToken(GameState state, PlaceTokenMessage msg) {
        Token token = msg.getToken();
        if (token != FerriesCapability.FerryToken.FERRY) {
            throw new IllegalArgumentException();
        }
        FerriesCapabilityModel model = (FerriesCapabilityModel)state.getCapabilityModel(FerriesCapability.class);
        FeaturePointer newFerry = msg.getPointer().asFeaturePointer();
        Position pos = newFerry.getPosition();
        FeaturePointer oldFerry = model.getFerries().find(f -> f.getPosition().equals(pos)).get();
        state = state.setCapabilityModel(FerriesCapability.class, model.mapMovedFerries(mf -> mf.put(pos, new Tuple2<Location, Location>(oldFerry.getLocation(), newFerry.getLocation()))));
        state = new ChangeFerry(oldFerry, newFerry).apply(state);
        state = this.clearActions(state);
        return this.enter(state);
    }

    private static /* synthetic */ Iterable lambda$enter$3(GameState state, Position pos, Set ferries, Tuple2 t) {
        return ((Road)t._2).findNearest(state, new FeaturePointer(pos, (Location)t._1), fp -> ferries.find(f -> fp.isPartOf((FeaturePointer)f)).isDefined());
    }
}

