/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.phase;

import com.jcloisterzone.Player;
import com.jcloisterzone.action.MeepleAction;
import com.jcloisterzone.action.PlayerAction;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.event.play.ScoreEvent;
import com.jcloisterzone.feature.Quarter;
import com.jcloisterzone.feature.Structure;
import com.jcloisterzone.figure.BigFollower;
import com.jcloisterzone.figure.DeploymentCheckResult;
import com.jcloisterzone.figure.Mayor;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.figure.Phantom;
import com.jcloisterzone.figure.SmallFollower;
import com.jcloisterzone.figure.Wagon;
import com.jcloisterzone.game.RandomGenerator;
import com.jcloisterzone.game.Rule;
import com.jcloisterzone.game.capability.CountCapability;
import com.jcloisterzone.game.capability.CountCapabilityModel;
import com.jcloisterzone.game.phase.CocCountPhase;
import com.jcloisterzone.game.phase.Phase;
import com.jcloisterzone.game.phase.PhaseMessageHandler;
import com.jcloisterzone.game.phase.RequiredCapability;
import com.jcloisterzone.game.phase.StepResult;
import com.jcloisterzone.game.state.ActionsState;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.reducers.DeployMeeple;
import com.jcloisterzone.wsio.message.DeployMeepleMessage;
import io.vavr.Predicates;
import io.vavr.Tuple2;
import io.vavr.collection.IndexedSeq;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.Set;
import io.vavr.collection.Stream;
import io.vavr.collection.Vector;

@RequiredCapability(value=CountCapability.class)
public class CocFollowerPhase
extends Phase {
    public CocFollowerPhase(RandomGenerator random) {
        super(random);
    }

    @Override
    public StepResult enter(GameState state) {
        LinearSeq events = Stream.ofAll(state.getCurrentTurnPartEvents()).filter(Predicates.instanceOf(ScoreEvent.class)).map(ev -> (ScoreEvent)ev).filter(ev -> ev.getCategory().hasLandscapeSource()).filter(ev -> ev.getPoints() > 0);
        Player player = state.getTurnPlayer();
        boolean didReceived = false;
        boolean didCauseOpponentScoring = false;
        for (ScoreEvent ev2 : events) {
            if (ev2.getReceiver().equals(player)) {
                didReceived = true;
                break;
            }
            didCauseOpponentScoring = true;
        }
        if (didReceived || !didCauseOpponentScoring) {
            return this.next(state);
        }
        Position quarterPos = ((CountCapabilityModel)state.getCapabilityModel(CountCapability.class)).getQuarterPosition();
        Vector<Class<? extends Meeple>> meepleTypes = Vector.of(SmallFollower.class, BigFollower.class, Phantom.class, Wagon.class, Mayor.class);
        Vector<Meeple> availMeeples = player.getMeeplesFromSupply(state, meepleTypes);
        boolean marketAllowed = state.getBooleanValue(Rule.FARMERS);
        LinearSeq quarters = state.getTileFeatures2(quarterPos).filter(t -> ((Location)t._1).isCityOfCarcassonneQuarter() && (marketAllowed || t._1 != Location.QUARTER_MARKET)).map(t -> new Tuple2<FeaturePointer, Quarter>(new FeaturePointer(quarterPos, (Location)t._1), (Quarter)t._2));
        GameState _state = state;
        IndexedSeq actions = availMeeples.map(arg_0 -> CocFollowerPhase.lambda$enter$7((Stream)quarters, _state, arg_0));
        if (((Vector)(actions = ((Vector)actions).filter(action -> !action.isEmpty()))).isEmpty()) {
            return this.next(state);
        }
        state = state.setPlayerActions(new ActionsState(player, (Vector<PlayerAction<?>>)actions, true));
        return this.promote(state);
    }

    @PhaseMessageHandler
    public StepResult handleDeployMeeple(GameState state, DeployMeepleMessage msg) {
        FeaturePointer fp = msg.getPointer();
        Meeple m = state.getActivePlayer().getMeepleFromSupply(state, msg.getMeepleId());
        if (!fp.getLocation().isCityOfCarcassonneQuarter()) {
            throw new IllegalArgumentException("Only deplpy to the City of Carcassone is allowed");
        }
        state = new DeployMeeple(m, fp).apply(state);
        state = this.clearActions(state);
        return this.next(state, CocCountPhase.class);
    }

    private static /* synthetic */ PlayerAction lambda$enter$7(Stream quarters, GameState _state, Meeple meeple) {
        Set<FeaturePointer> locations = quarters.filter(t -> meeple.isDeploymentAllowed(_state, (FeaturePointer)t._1, (Structure)t._2) == DeploymentCheckResult.OK).map(t -> (FeaturePointer)t._1).toSet();
        MeepleAction action = new MeepleAction(meeple, locations);
        return action;
    }
}

