/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.phase;

import com.jcloisterzone.Player;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.feature.Cloister;
import com.jcloisterzone.feature.Completable;
import com.jcloisterzone.feature.Farm;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.figure.Barn;
import com.jcloisterzone.figure.Follower;
import com.jcloisterzone.game.RandomGenerator;
import com.jcloisterzone.game.capability.AbbeyCapability;
import com.jcloisterzone.game.capability.BarnCapability;
import com.jcloisterzone.game.capability.CountCapability;
import com.jcloisterzone.game.phase.AbstractCocScoringPhase;
import com.jcloisterzone.game.phase.PhaseMessageHandler;
import com.jcloisterzone.game.phase.RequiredCapability;
import com.jcloisterzone.game.phase.StepResult;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.reducers.DeployMeeple;
import com.jcloisterzone.wsio.message.DeployMeepleMessage;
import io.vavr.Predicates;
import io.vavr.Tuple2;
import java.util.HashSet;
import java.util.function.Function;

@RequiredCapability(value=CountCapability.class)
public class CocScoringPhase
extends AbstractCocScoringPhase {
    public CocScoringPhase(RandomGenerator random) {
        super(random);
    }

    @Override
    protected boolean isLast(GameState state, Player player, boolean actionUsed) {
        return state.getTurnPlayer().equals(player);
    }

    @Override
    protected Function<Feature, Boolean> getAllowedFeaturesFilter(GameState state) {
        PlacedTile lastPlaced = state.getLastPlaced();
        Position lastPlacedPos = lastPlaced.getPosition();
        HashSet<Completable> justPlacedAbbeyAdjacent = new HashSet<Completable>();
        if (AbbeyCapability.isAbbey(lastPlaced.getTile())) {
            for (Tuple2 tuple2 : state.getAdjacentTiles2(lastPlacedPos)) {
                PlacedTile pt = (PlacedTile)tuple2._2;
                Feature feature = state.getFeaturePartOf(new FeaturePointer(pt.getPosition(), ((Location)tuple2._1).rev()));
                if (!(feature instanceof Completable)) continue;
                justPlacedAbbeyAdjacent.add((Completable)feature);
            }
        }
        HashSet<Farm> barnInvolvedFarms = new HashSet<Farm>();
        if (state.getCapabilities().contains(BarnCapability.class)) {
            Farm placedBarnFarm;
            FeaturePointer featurePointer = (FeaturePointer)state.getCapabilityModel(BarnCapability.class);
            Farm farm2 = placedBarnFarm = featurePointer == null ? null : (Farm)state.getFeature(featurePointer);
            if (placedBarnFarm != null) {
                barnInvolvedFarms.add(placedBarnFarm);
            }
            Position pos = lastPlaced.getPosition();
            state.getTileFeatures2(pos).map(Tuple2::_2).filter(f -> f != placedBarnFarm).filter(Predicates.instanceOf(Farm.class)).map(f -> (Farm)f).filter(farm -> farm.getSpecialMeeples(state).find(Predicates.instanceOf(Barn.class)).isDefined()).filter(farm -> !farm.getFollowers(state).isEmpty()).forEach(farm -> barnInvolvedFarms.add((Farm)farm));
        }
        return f -> {
            if (f instanceof Farm) {
                return barnInvolvedFarms.contains(f);
            }
            if (f instanceof Completable) {
                Position cloisterPos;
                Completable completable = (Completable)f;
                if (!completable.isCompleted(state)) {
                    return false;
                }
                if (justPlacedAbbeyAdjacent.contains(f)) {
                    return true;
                }
                if (f.getPlaces().find(p -> p.getPosition().equals(lastPlacedPos)).isDefined()) {
                    return true;
                }
                if (f instanceof Cloister && !Position.ADJACENT_AND_DIAGONAL.map(arg_0 -> CocScoringPhase.lambda$getAllowedFeaturesFilter$6(cloisterPos = ((Cloister)f).getPosition(), arg_0)).filter(p -> p.equals(lastPlacedPos)).isEmpty()) {
                    return true;
                }
                return false;
            }
            throw new UnsupportedOperationException();
        };
    }

    @PhaseMessageHandler
    public StepResult handleDeployMeeple(GameState state, DeployMeepleMessage msg) {
        FeaturePointer fp = msg.getPointer();
        Player player = state.getActivePlayer();
        Follower follower = player.getFollowers(state).find(f -> f.getId().equals(msg.getMeepleId())).get();
        state = new DeployMeeple(follower, fp).apply(state);
        return this.processPlayer(state, player);
    }

    private static /* synthetic */ Position lambda$getAllowedFeaturesFilter$6(Position cloisterPos, Tuple2 t) {
        return cloisterPos.add((Position)t._2);
    }
}

