/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.phase;

import com.jcloisterzone.Player;
import com.jcloisterzone.action.MoveDragonAction;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.pointer.BoardPointer;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.figure.neutral.Dragon;
import com.jcloisterzone.figure.neutral.NeutralFigure;
import com.jcloisterzone.game.RandomGenerator;
import com.jcloisterzone.game.capability.CountCapability;
import com.jcloisterzone.game.capability.DragonCapability;
import com.jcloisterzone.game.phase.Phase;
import com.jcloisterzone.game.phase.PhaseMessageHandler;
import com.jcloisterzone.game.phase.RequiredCapability;
import com.jcloisterzone.game.phase.StepResult;
import com.jcloisterzone.game.state.ActionsState;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.reducers.MoveNeutralFigure;
import com.jcloisterzone.reducers.UndeployMeeple;
import com.jcloisterzone.wsio.message.MoveNeutralFigureMessage;
import io.vavr.Tuple2;
import io.vavr.collection.HashSet;
import io.vavr.collection.Set;
import io.vavr.collection.Vector;

@RequiredCapability(value=DragonCapability.class)
public class DragonMovePhase
extends Phase {
    public DragonMovePhase(RandomGenerator random) {
        super(random);
    }

    private Vector<Position> getVisitedPositions(GameState state) {
        Vector visited = (Vector)state.getCapabilityModel(DragonCapability.class);
        return visited == null ? Vector.empty() : visited;
    }

    @Override
    public StepResult enter(GameState state) {
        Vector<Position> visited = this.getVisitedPositions(state);
        if (visited.size() == 6) {
            return this.next(this.endDragonMove(state));
        }
        Set<Position> availMoves = this.getAvailDragonMoves(state, visited);
        if (availMoves.isEmpty()) {
            return this.next(this.endDragonMove(state));
        }
        Dragon dragon = state.getNeutralFigures().getDragon();
        Player p = state.getTurnPlayer();
        p = state.getPlayers().getPlayer((p.getIndex() + visited.length()) % state.getPlayers().getPlayers().length());
        return this.promote(state.setPlayerActions(new ActionsState(p, new MoveDragonAction(dragon.getId(), availMoves), false)));
    }

    private GameState endDragonMove(GameState state) {
        state = state.setCapabilityModel(DragonCapability.class, Vector.empty());
        state = this.clearActions(state);
        return state;
    }

    public Set<Position> getAvailDragonMoves(GameState state, Vector<Position> visited) {
        Set<Position> result = HashSet.empty();
        BoardPointer fairyPtr = state.getNeutralFigures().getFairyDeployment();
        Position fairyPosition = fairyPtr == null ? null : fairyPtr.getPosition();
        Position dragonPosition = state.getNeutralFigures().getDragonDeployment();
        for (Position offset : Position.ADJACENT.values()) {
            Position pos = dragonPosition.add(offset);
            PlacedTile pt = state.getPlacedTile(pos);
            if (pt == null || CountCapability.isTileForbidden(pt.getTile()) || visited.contains(pos) || pos.equals(fairyPosition)) continue;
            result = result.add(pos);
        }
        return result;
    }

    @PhaseMessageHandler
    public StepResult handleMoveNeutralFigure(GameState state, MoveNeutralFigureMessage msg) {
        Position pos;
        BoardPointer ptr = msg.getTo();
        NeutralFigure<?> fig = state.getNeutralFigures().getById(msg.getFigureId());
        if (!(fig instanceof Dragon)) {
            throw new IllegalArgumentException("Illegal neutral figure move");
        }
        Vector<Position> visited = this.getVisitedPositions(state);
        Set<Position> availMoves = this.getAvailDragonMoves(state, visited);
        if (!availMoves.contains(pos = ptr.getPosition())) {
            throw new IllegalArgumentException("Invalid dragon move.");
        }
        Position dragonPosition = state.getNeutralFigures().getDragonDeployment();
        state = new MoveNeutralFigure<Position>((Dragon)fig, pos, state.getActivePlayer()).apply(state);
        state = state.mapCapabilityModel(DragonCapability.class, moves -> moves.append(dragonPosition));
        for (Tuple2 tuple2 : state.getDeployedMeeples()) {
            Meeple m = (Meeple)tuple2._1;
            FeaturePointer fp = (FeaturePointer)tuple2._2;
            if (!pos.equals(fp.getPosition()) || !m.canBeEatenByDragon(state)) continue;
            state = new UndeployMeeple(m, true).apply(state);
        }
        return this.enter(state);
    }
}

