/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.phase;

import com.jcloisterzone.PointCategory;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.pointer.BoardPointer;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.board.pointer.MeeplePointer;
import com.jcloisterzone.event.play.ScoreEvent;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.game.RandomGenerator;
import com.jcloisterzone.game.capability.FairyCapability;
import com.jcloisterzone.game.phase.Phase;
import com.jcloisterzone.game.phase.RequiredCapability;
import com.jcloisterzone.game.phase.StepResult;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.reducers.AddPoints;
import io.vavr.Tuple2;

@RequiredCapability(value=FairyCapability.class)
public class FairyPhase
extends Phase {
    public FairyPhase(RandomGenerator random) {
        super(random);
    }

    @Override
    public StepResult enter(GameState state) {
        BoardPointer ptr = state.getNeutralFigures().getFairyDeployment();
        if (ptr == null) {
            return this.next(state);
        }
        boolean onTileRule = ptr instanceof Position;
        FeaturePointer fairyFp = ptr.asFeaturePointer();
        for (Tuple2 tuple2 : state.getDeployedMeeples()) {
            Meeple m = (Meeple)tuple2._1;
            if (!m.getPlayer().equals(state.getTurnPlayer()) || !((FeaturePointer)tuple2._2).equals(fairyFp) || !onTileRule && !((MeeplePointer)ptr).getMeepleId().equals(m.getId())) continue;
            state = new AddPoints(m.getPlayer(), 1, PointCategory.FAIRY).apply(state);
            state = state.appendEvent(new ScoreEvent(1, PointCategory.FAIRY, false, fairyFp, m));
        }
        return this.next(state);
    }
}

