/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.phase;

import com.jcloisterzone.game.RandomGenerator;
import com.jcloisterzone.game.phase.PhantomPhase;
import com.jcloisterzone.game.phase.PhaseMessageHandler;
import com.jcloisterzone.game.phase.StepResult;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.reducers.PayRansom;
import com.jcloisterzone.wsio.message.PassMessage;
import com.jcloisterzone.wsio.message.PayRansomMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Phase {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RandomGenerator random;
    private Phase defaultNext;

    public Phase(RandomGenerator random) {
        this.random = random;
    }

    public Phase getDefaultNext() {
        return this.defaultNext;
    }

    public void setDefaultNext(Phase defaultNext) {
        this.defaultNext = defaultNext;
    }

    public StepResult next(GameState state) {
        return new StepResult(state, this.defaultNext.getClass());
    }

    public StepResult next(GameState state, Class<? extends Phase> phaseClass) {
        return new StepResult(state, phaseClass);
    }

    public void next(GameState state, Phase phase) {
        phase.enter(state);
    }

    public abstract StepResult enter(GameState var1);

    protected StepResult promote(GameState state) {
        return new StepResult(state.setPhase(this.getClass()), null);
    }

    protected GameState clearActions(GameState state) {
        return state.setPlayerActions(null);
    }

    @PhaseMessageHandler
    public StepResult handlePass(GameState state, PassMessage msg) {
        if (!state.getPlayerActions().isPassAllowed()) {
            throw new IllegalStateException("Pass is not allowed");
        }
        state = this.clearActions(state);
        if (this.getDefaultNext() instanceof PhantomPhase) {
            return this.getDefaultNext().next(state);
        }
        return this.next(state);
    }

    @PhaseMessageHandler
    public StepResult handlePayRansom(GameState state, PayRansomMessage msg) {
        state = new PayRansom(msg.getMeepleId()).apply(state);
        return this.promote(state);
    }

    public RandomGenerator getRandom() {
        return this.random;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

