/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.phase;

import com.jcloisterzone.PointCategory;
import com.jcloisterzone.action.FlockAction;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.event.play.ScoreEvent;
import com.jcloisterzone.event.play.TokenPlacedEvent;
import com.jcloisterzone.feature.Farm;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.figure.Shepherd;
import com.jcloisterzone.game.RandomGenerator;
import com.jcloisterzone.game.capability.SheepCapability;
import com.jcloisterzone.game.phase.Phase;
import com.jcloisterzone.game.phase.PhaseMessageHandler;
import com.jcloisterzone.game.phase.RequiredCapability;
import com.jcloisterzone.game.phase.StepResult;
import com.jcloisterzone.game.state.ActionsState;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.game.state.PlacedTile;
import com.jcloisterzone.reducers.AddPoints;
import com.jcloisterzone.reducers.UndeployMeeple;
import com.jcloisterzone.wsio.message.FlockMessage;
import io.vavr.Predicates;
import io.vavr.Tuple2;
import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Traversable;
import io.vavr.collection.Vector;

@RequiredCapability(value=SheepCapability.class)
public class ShepherdPhase
extends Phase {
    public ShepherdPhase(RandomGenerator random) {
        super(random);
    }

    @Override
    public StepResult enter(GameState state) {
        PlacedTile lastPlaced = state.getLastPlaced();
        GameState _state = state;
        Traversable closedFarmsWithShepherd = ((LinkedHashMap)state.getDeployedMeeples().filterKeys(Predicates.instanceOf(Shepherd.class))).values().map(fp -> (Farm)_state.getFeature((FeaturePointer)fp)).distinct().filter(farm -> !farm.isOpen(_state));
        Shepherd shepherd = (Shepherd)state.getTurnPlayer().getSpecialMeeples(state).find(m -> m instanceof Shepherd).getOrNull();
        FeaturePointer shepherdFp = shepherd.getDeployment(state);
        boolean isFarmExtended = false;
        boolean alreadyExpanded = false;
        if (shepherdFp != null) {
            boolean isJustPlaced = lastPlaced.getPosition().equals(shepherdFp.getPosition());
            Farm farm2 = (Farm)state.getFeature(shepherdFp);
            isFarmExtended = state.getTileFeatures2(lastPlaced.getPosition()).map(Tuple2::_2).contains(farm2);
            if (isJustPlaced || closedFarmsWithShepherd.contains(farm2)) {
                state = this.expandFlock(state, shepherdFp);
                alreadyExpanded = true;
            }
        }
        for (Farm farm2 : closedFarmsWithShepherd) {
            state = this.scoreFlock(state, farm2);
        }
        if (shepherdFp == null || !isFarmExtended || alreadyExpanded) {
            return this.next(state);
        }
        FlockAction action = new FlockAction();
        ActionsState as = new ActionsState(state.getTurnPlayer(), action, false);
        return this.promote(state.setPlayerActions(as));
    }

    @PhaseMessageHandler
    public StepResult handleFlockMessage(GameState state, FlockMessage msg) {
        Shepherd shepherd = (Shepherd)state.getTurnPlayer().getSpecialMeeples(state).find(m -> m instanceof Shepherd).getOrNull();
        FeaturePointer shepherdFp = shepherd.getDeployment(state);
        if (msg.getValue() == FlockMessage.FlockOption.EXPAND) {
            return this.next(this.expandFlock(state, shepherdFp));
        }
        return this.scoreFlock(state, shepherdFp);
    }

    private Map<Meeple, FeaturePointer> getShepherdsOnFarm(GameState state, Farm farm) {
        return state.getDeployedMeeples().filter((m, fp) -> m instanceof Shepherd && farm.getPlaces().contains((FeaturePointer)fp));
    }

    private StepResult scoreFlock(GameState state, FeaturePointer shepherdFp) {
        Farm farm = (Farm)state.getFeature(shepherdFp);
        state = this.scoreFlock(state, farm);
        state = this.clearActions(state);
        return this.next(state);
    }

    private GameState scoreFlock(GameState state, Farm farm) {
        SheepCapability cap = state.getCapabilities().get(SheepCapability.class);
        Map placedTokens = (Map)cap.getModel(state);
        Map<Meeple, FeaturePointer> shepherdsOnFarm = this.getShepherdsOnFarm(state, farm);
        int points = shepherdsOnFarm.values().map(fp -> ((List)placedTokens.get(fp).get()).map(SheepCapability.SheepToken::sheepCount).sum()).sum().intValue();
        for (Tuple2 tuple2 : shepherdsOnFarm) {
            Shepherd m = (Shepherd)tuple2._1;
            state = new AddPoints(m.getPlayer(), points, PointCategory.SHEEP).apply(state);
            ScoreEvent scoreEvent = new ScoreEvent(points, PointCategory.SHEEP, false, (FeaturePointer)tuple2._2, m);
            state = state.appendEvent(scoreEvent);
            state = new UndeployMeeple(m, false).apply(state);
        }
        return cap.setModel(state, shepherdsOnFarm.values().foldLeft(placedTokens, (acc, fp) -> acc.remove(fp)));
    }

    private GameState expandFlock(GameState state, FeaturePointer shepherdFp) {
        SheepCapability.SheepToken drawnToken = this.drawTokenFromBag(state);
        state = state.appendEvent(new TokenPlacedEvent(PlayEvent.PlayEventMeta.createWithoutPlayer(), drawnToken, shepherdFp));
        SheepCapability cap = state.getCapabilities().get(SheepCapability.class);
        if (drawnToken == SheepCapability.SheepToken.WOLF) {
            Farm farm = (Farm)state.getFeature(shepherdFp);
            Map<Meeple, FeaturePointer> shepherdsOnFarm = this.getShepherdsOnFarm(state, farm);
            for (Meeple m : shepherdsOnFarm.keySet()) {
                state = new UndeployMeeple(m, true).apply(state);
            }
            state = cap.updateModel(state, placedTokens -> shepherdsOnFarm.values().foldLeft(placedTokens, (acc, fp) -> acc.remove(fp)));
            return state;
        }
        return state.getCapabilities().get(SheepCapability.class).updateModel(state, placedTokens -> placedTokens.put(shepherdFp, List.of(drawnToken), (l1, l2) -> l1.appendAll((Iterable)l2)));
    }

    private SheepCapability.SheepToken drawTokenFromBag(GameState state) {
        Vector<SheepCapability.SheepToken> bag = state.getCapabilities().get(SheepCapability.class).getBagConent(state);
        return bag.get(this.getRandom().nextInt(bag.size()));
    }
}

