/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.phase;

import com.jcloisterzone.Player;
import com.jcloisterzone.action.TilePlacementAction;
import com.jcloisterzone.board.Location;
import com.jcloisterzone.board.PlacementOption;
import com.jcloisterzone.board.Position;
import com.jcloisterzone.board.Rotation;
import com.jcloisterzone.board.Tile;
import com.jcloisterzone.board.TilePack;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.event.play.PlayEvent;
import com.jcloisterzone.event.play.TileDiscardedEvent;
import com.jcloisterzone.event.play.TokenPlacedEvent;
import com.jcloisterzone.game.RandomGenerator;
import com.jcloisterzone.game.capability.AbbeyCapability;
import com.jcloisterzone.game.capability.BazaarCapability;
import com.jcloisterzone.game.capability.BazaarCapabilityModel;
import com.jcloisterzone.game.capability.BazaarItem;
import com.jcloisterzone.game.capability.BridgeCapability;
import com.jcloisterzone.game.capability.CountCapability;
import com.jcloisterzone.game.capability.HillCapability;
import com.jcloisterzone.game.phase.CleanUpTurnPartPhase;
import com.jcloisterzone.game.phase.CleanUpTurnPhase;
import com.jcloisterzone.game.phase.CocFinalScoringPhase;
import com.jcloisterzone.game.phase.GameOverPhase;
import com.jcloisterzone.game.phase.Phase;
import com.jcloisterzone.game.phase.PhaseMessageHandler;
import com.jcloisterzone.game.phase.StepResult;
import com.jcloisterzone.game.state.ActionsState;
import com.jcloisterzone.game.state.Flag;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.reducers.PlaceBridge;
import com.jcloisterzone.reducers.PlaceTile;
import com.jcloisterzone.wsio.message.PassMessage;
import com.jcloisterzone.wsio.message.PlaceTileMessage;
import io.vavr.Tuple2;
import io.vavr.collection.List;
import io.vavr.collection.Queue;
import io.vavr.collection.Set;
import io.vavr.collection.Vector;

public class TilePhase
extends Phase {
    public TilePhase(RandomGenerator random) {
        super(random);
    }

    public GameState drawTile(GameState state) {
        TilePack tps = state.getTilePack();
        Tuple2<Tile, TilePack> t = tps.drawTile(this.getRandom());
        return state.setTilePack((TilePack)t._2).setDrawnTile((Tile)t._1);
    }

    public GameState drawTile(GameState state, String tileId) {
        TilePack tps = state.getTilePack();
        Tuple2<Tile, TilePack> t = tps.drawTile(tileId);
        return state.setTilePack((TilePack)t._2).setDrawnTile((Tile)t._1);
    }

    @Override
    public StepResult enter(GameState state) {
        Tile tile;
        Set<PlacementOption> placements;
        while (true) {
            BazaarCapabilityModel bazaarModel;
            Queue bazaarSupply;
            Queue queue = bazaarSupply = (bazaarModel = (BazaarCapabilityModel)state.getCapabilityModel(BazaarCapability.class)) == null ? null : bazaarModel.getSupply();
            if (bazaarSupply != null && !bazaarSupply.isEmpty()) {
                Tuple2 t = bazaarSupply.dequeue();
                BazaarItem item = (BazaarItem)t._1;
                if (item.getOwner().equals(state.getTurnPlayer())) {
                    bazaarSupply = (Queue)t._2;
                    bazaarModel = bazaarModel.setSupply(bazaarSupply);
                    state = state.setCapabilityModel(BazaarCapability.class, bazaarModel);
                    state = state.setDrawnTile(item.getTile());
                }
            }
            if (state.getDrawnTile() == null) {
                TilePack tilePack = state.getTilePack();
                boolean packIsEmpty = tilePack.isEmpty();
                if (packIsEmpty && bazaarSupply != null) {
                    return this.next(state, CleanUpTurnPhase.class);
                }
                if (packIsEmpty && state.getCapabilities().contains(AbbeyCapability.class)) {
                    Integer endPlayerIdx = (Integer)state.getCapabilityModel(AbbeyCapability.class);
                    Player turnPlayer = state.getTurnPlayer();
                    if (endPlayerIdx == null) {
                        endPlayerIdx = turnPlayer.getPrevPlayer(state).getIndex();
                        state = state.setCapabilityModel(AbbeyCapability.class, endPlayerIdx);
                    }
                    if (endPlayerIdx.intValue() != turnPlayer.getIndex()) {
                        return this.next(state, CleanUpTurnPartPhase.class);
                    }
                }
                if (packIsEmpty) {
                    if (state.hasCapability(CountCapability.class)) {
                        return this.next(state, CocFinalScoringPhase.class);
                    }
                    return this.next(state, GameOverPhase.class);
                }
                state = this.drawTile(state);
            }
            if (!(placements = state.getTilePlacements(tile = state.getDrawnTile()).toSet()).isEmpty()) break;
            state = this.discardTile(state);
        }
        TilePlacementAction action = new TilePlacementAction(tile, placements);
        boolean canPass = placements.find(p -> p.getMandatoryBridge() == null).isEmpty();
        state = state.setPlayerActions(new ActionsState(state.getTurnPlayer(), Vector.of(action), canPass));
        return this.promote(state);
    }

    @Override
    @PhaseMessageHandler
    public StepResult handlePass(GameState state, PassMessage msg) {
        TilePlacementAction action = (TilePlacementAction)state.getAction();
        if (action.getOptions().find(p -> p.getMandatoryBridge() == null).isDefined()) {
            throw new IllegalStateException("Pass is not allowed");
        }
        state = this.discardTile(state);
        state = state.setDrawnTile(null);
        return this.enter(state);
    }

    @PhaseMessageHandler
    public StepResult handlePlaceTile(GameState state, PlaceTileMessage msg) {
        BazaarCapabilityModel model2;
        TilePack tilePack;
        Tile tile = state.getDrawnTile();
        Position pos = msg.getPosition();
        Rotation rot = msg.getRotation();
        Player player = state.getActivePlayer();
        assert (tile.getId().equals(msg.getTileId())) : String.format("%s received, but %s is drawn", msg.getTileId(), tile.getId());
        TilePlacementAction action = (TilePlacementAction)state.getPlayerActions().getActions().get();
        PlacementOption placement = action.getOptions().find(tp -> tp.getPosition().equals(pos) && tp.getRotation().equals((Object)rot)).getOrElseThrow(() -> new IllegalArgumentException("Invalid placement " + pos + "," + (Object)((Object)rot)));
        FeaturePointer mandatoryBridge = placement.getMandatoryBridge();
        if (mandatoryBridge != null) {
            state = state.mapPlayers(ps -> ps.addTokenCount(player.getIndex(), BridgeCapability.BrigeToken.BRIDGE, -1));
            state = state.mapCapabilityModel(BridgeCapability.class, model -> model.add(mandatoryBridge));
            Position bridgePos = mandatoryBridge.getPosition();
            Location bridgeLoc = mandatoryBridge.getLocation();
            if (bridgePos.equals(pos)) {
                tile = tile.addBridge(bridgeLoc.rotateCCW(rot));
                state = state.mapCapabilityModel(BridgeCapability.class, model -> model.add(mandatoryBridge));
            } else {
                state = new PlaceBridge(mandatoryBridge, true).apply(state);
            }
        }
        state = new PlaceTile(tile, msg.getPosition(), msg.getRotation()).apply(state);
        if (mandatoryBridge != null) {
            state = state.appendEvent(new TokenPlacedEvent(PlayEvent.PlayEventMeta.createWithPlayer(player), BridgeCapability.BrigeToken.BRIDGE, mandatoryBridge));
        }
        if (tile.hasModifier(HillCapability.HILL) && !(tilePack = state.getTilePack()).isEmpty()) {
            state = state.setTilePack(tilePack.increaseHiddenUnderHills());
        }
        state = this.clearActions(state);
        state = state.setDrawnTile(null);
        if (tile.hasModifier(BazaarCapability.BAZAAR) && (model2 = (BazaarCapabilityModel)state.getCapabilityModel(BazaarCapability.class)).getSupply() == null) {
            state = state.addFlag(Flag.BAZAAR_AUCTION);
        }
        return this.next(state);
    }

    private GameState discardTile(GameState state) {
        Tile tile = state.getDrawnTile();
        return state.setDrawnTile(null).setDiscardedTiles((List<Tile>)state.getDiscardedTiles().append((Object)tile)).appendEvent(new TileDiscardedEvent(tile));
    }
}

