/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.phase;

import com.jcloisterzone.action.MeepleAction;
import com.jcloisterzone.board.pointer.FeaturePointer;
import com.jcloisterzone.feature.Castle;
import com.jcloisterzone.feature.Completable;
import com.jcloisterzone.feature.Feature;
import com.jcloisterzone.figure.Meeple;
import com.jcloisterzone.figure.Wagon;
import com.jcloisterzone.game.RandomGenerator;
import com.jcloisterzone.game.capability.WagonCapability;
import com.jcloisterzone.game.phase.Phase;
import com.jcloisterzone.game.phase.PhaseMessageHandler;
import com.jcloisterzone.game.phase.RequiredCapability;
import com.jcloisterzone.game.phase.StepResult;
import com.jcloisterzone.game.state.ActionsState;
import com.jcloisterzone.game.state.GameState;
import com.jcloisterzone.reducers.DeployMeeple;
import com.jcloisterzone.wsio.message.DeployMeepleMessage;
import com.jcloisterzone.wsio.message.PassMessage;
import io.vavr.Tuple2;
import io.vavr.collection.Queue;
import io.vavr.collection.Set;
import io.vavr.collection.Traversable;

@RequiredCapability(value=WagonCapability.class)
public class WagonPhase
extends Phase {
    public WagonPhase(RandomGenerator random) {
        super(random);
    }

    @Override
    public StepResult enter(GameState state) {
        Queue model = (Queue)state.getCapabilityModel(WagonCapability.class);
        while (!model.isEmpty()) {
            Tuple2 dequeueTuple = model.dequeue();
            model = (Queue)dequeueTuple._2;
            state = state.setCapabilityModel(WagonCapability.class, model);
            Tuple2 item = (Tuple2)dequeueTuple._1;
            Wagon wagon = (Wagon)item._1;
            Feature feature = state.getFeature((FeaturePointer)item._2);
            if (!(feature instanceof Completable)) continue;
            GameState _state = state;
            Traversable options = ((Completable)feature).getNeighboring().filter(fp -> {
                Feature f = _state.getFeature((FeaturePointer)fp);
                if (f instanceof Castle) {
                    Castle castle = (Castle)f;
                    return !castle.isOccupied(_state);
                }
                if (f instanceof Completable) {
                    Completable nei = (Completable)f;
                    return !nei.isCompleted(_state) && !nei.isOccupied(_state);
                }
                return false;
            });
            if (options.isEmpty()) continue;
            MeepleAction action = new MeepleAction(wagon, (Set<FeaturePointer>)options);
            state = state.setPlayerActions(new ActionsState(wagon.getPlayer(), action, true));
            return this.promote(state);
        }
        return this.next(state);
    }

    @Override
    @PhaseMessageHandler
    public StepResult handlePass(GameState state, PassMessage msg) {
        if (!state.getPlayerActions().isPassAllowed()) {
            throw new IllegalStateException("Pass is not allowed");
        }
        state = this.clearActions(state);
        return this.enter(state);
    }

    @PhaseMessageHandler
    public StepResult handleDeployMeeple(GameState state, DeployMeepleMessage msg) {
        FeaturePointer fp = msg.getPointer();
        Meeple m = state.getActivePlayer().getMeepleFromSupply(state, msg.getMeepleId());
        if (!(m instanceof Wagon)) {
            throw new IllegalArgumentException("Invalid follower");
        }
        state = new DeployMeeple(m, fp).apply(state);
        state = this.clearActions(state);
        return this.enter(state);
    }
}

