/*
 * Decompiled with CFR 0.152.
 */
package com.jcloisterzone.game.state;

import com.google.common.base.Predicates;
import com.jcloisterzone.Player;
import com.jcloisterzone.action.MeepleAction;
import com.jcloisterzone.action.PlayerAction;
import io.vavr.collection.Seq;
import io.vavr.collection.Vector;
import java.io.Serializable;

public class ActionsState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Player player;
    private final Vector<PlayerAction<?>> actions;
    private final boolean passAllowed;

    public ActionsState(Player player, Vector<PlayerAction<?>> actions, boolean passAllowed) {
        this.player = player;
        this.actions = actions;
        this.passAllowed = passAllowed;
    }

    public ActionsState(Player player, PlayerAction<?> action, boolean passAllowed) {
        this(player, Vector.of(action), passAllowed);
    }

    public ActionsState setActions(Vector<PlayerAction<?>> actions) {
        if (this.actions == actions) {
            return this;
        }
        return new ActionsState(this.player, actions, this.passAllowed);
    }

    public ActionsState appendAction(PlayerAction<?> action) {
        return this.setActions((Vector<PlayerAction<?>>)this.actions.append((Object)action));
    }

    public ActionsState appendActions(Iterable<PlayerAction<?>> actions) {
        return this.setActions((Vector<PlayerAction<?>>)this.actions.appendAll((Iterable)actions));
    }

    public ActionsState mergeMeepleActions() {
        Seq<Vector<MeepleAction>> grouped = ((Vector)((Vector)this.actions.filter(Predicates.instanceOf(MeepleAction.class))).map(a -> (MeepleAction)a)).groupBy(MeepleAction::getMeepleType).values();
        if (grouped.find(v -> v.length() > 1).isEmpty()) {
            return this;
        }
        Vector<PlayerAction<?>> actions = Vector.ofAll(grouped.map(v -> v.reduce(MeepleAction::merge)));
        actions = actions.appendAll((Iterable)this.actions.filter(Predicates.instanceOf(MeepleAction.class).negate()));
        return this.setActions(actions);
    }

    public Player getPlayer() {
        return this.player;
    }

    public Vector<PlayerAction<?>> getActions() {
        return this.actions;
    }

    public boolean isPassAllowed() {
        return this.passAllowed;
    }
}

